/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.packagers.nand.ip;

import com.vendor.burn.Messages;
import com.vendor.burn.model.FileSystem;
import com.vendor.burn.model.PartitionItem;
import com.vendor.burn.model.config.PreferenceConfig;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.define.IFastbootProgressMonitor;
import com.vendor.burn.model.devices.unknown.UDProperties;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import com.vendor.burn.packagers.nand.BlockType;
import com.vendor.burn.packagers.nand.FlashOption;
import com.vendor.burn.packagers.nand.NandCRandom;
import com.vendor.burn.packagers.nand.PageType;
import com.vendor.burn.packagers.nand.ReverseBlockSizeSector;
import com.vendor.burn.packagers.nand.ReversePageEccSector;
import com.vendor.burn.packagers.nand.ecc.ECCType;
import com.vendor.burn.packagers.nand.ecc.ECCV620;
import com.vendor.burn.packagers.nand.ip.NandIPCommon;
import com.vendor.burn.packagers.nand.ip.NandIPV600;
import com.vendor.burn.preferences.FastbootPreferences;
import com.vendor.burn.utilitily.BytesUtils;
import com.vendor.burn.utilitily.ToolUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class NandIPV620
extends NandIPCommon {
    private static Map<String, Integer> map = new HashMap<String, Integer>();
    private static int NANDIP_V620 = 1568;
    private static String[] FMCV100LIST = new String[]{"CJ3X1VXX8", "CJ3X1VXX7", "CJ3X1VXX8_CA", "CJ3X1VXX7_CA", "CJ3X1VXX8E", "CJ3X1VXX7_CA_N", "CJ3X2VXX6", "CJ3X0VXX1", "CJ3X1VXX6", "CJ309V100", "CJ309V101", "CJ3X1VXX1", "CJ3X0VXX2", "CJ3X1VXX8", "CJXXXVXXX", "CJ301V203", "CJ301V204", "CJ3X0VXX3", "CJ3X0VXX7", "CJ301V200", "CJ301V201", "CJ3X0VXX8", "CJ1X0VXX3", "CJ3X0VXX3H", "CJ301V202", "CJ3X1VXX9", "CJ3X1VXX9H", "CJ3X1VX10", "CJ3X1VX10H"};
    private IBurner burner;
    private static final ReversePageEccSector[] nfc620_page_ecc_reverse_sector = new ReversePageEccSector[]{new ReversePageEccSector(NANDIP_V620, PageType.Size2K, ECCType.Ecc8bit512, 0), new ReversePageEccSector(NANDIP_V620, PageType.Size2K, ECCType.Ecc4bit, 1), new ReversePageEccSector(NANDIP_V620, PageType.Size2K, ECCType.Ecc4bit, 1), new ReversePageEccSector(NANDIP_V620, PageType.Size2K, ECCType.Ecc24bit1k, 2), new ReversePageEccSector(NANDIP_V620, PageType.Size4K, ECCType.Ecc8bit512, 3), new ReversePageEccSector(NANDIP_V620, PageType.Size4K, ECCType.Ecc4bit, 4), new ReversePageEccSector(NANDIP_V620, PageType.Size4K, ECCType.Ecc4bit, 4), new ReversePageEccSector(NANDIP_V620, PageType.Size4K, ECCType.Ecc24bit1k, 5), new ReversePageEccSector(NANDIP_V620, PageType.Size8K, ECCType.Ecc24bit1k, 6), new ReversePageEccSector(NANDIP_V620, PageType.Size8K, ECCType.Ecc40bit1k, 7), new ReversePageEccSector(NANDIP_V620, PageType.Size16K, ECCType.Ecc40bit1k, 8), new ReversePageEccSector(NANDIP_V620, PageType.Size16K, ECCType.Ecc64bit1k, 9), new ReversePageEccSector(NANDIP_V620, PageType.Size8K, ECCType.Ecc64bit1k, 10)};
    private static final ReversePageEccSector[] nfc620_page_ecc_reverse_sector_fmcv100 = new ReversePageEccSector[]{new ReversePageEccSector(NANDIP_V620, PageType.Size2K, ECCType.Ecc4bit, 0), new ReversePageEccSector(NANDIP_V620, PageType.Size2K, ECCType.Ecc24bit1k, 1), new ReversePageEccSector(NANDIP_V620, PageType.Size4K, ECCType.Ecc4bit, 2), new ReversePageEccSector(NANDIP_V620, PageType.Size4K, ECCType.Ecc24bit1k, 3), new ReversePageEccSector(NANDIP_V620, PageType.Size8K, ECCType.Ecc24bit1k, 4), new ReversePageEccSector(NANDIP_V620, PageType.Size8K, ECCType.Ecc40bit1k, 5), new ReversePageEccSector(NANDIP_V620, PageType.Size16K, ECCType.Ecc40bit1k, 6), new ReversePageEccSector(NANDIP_V620, PageType.Size16K, ECCType.Ecc64bit1k, 7), new ReversePageEccSector(NANDIP_V620, PageType.Size8K, ECCType.Ecc64bit1k, 8)};
    private static final ReverseBlockSizeSector[] nfc620_blocksize_reverse_sector = new ReverseBlockSizeSector[]{new ReverseBlockSizeSector(NANDIP_V620, BlockType.BlockSize64, 0), new ReverseBlockSizeSector(NANDIP_V620, BlockType.BlockSize128, 1), new ReverseBlockSizeSector(NANDIP_V620, BlockType.BlockSize256, 2), new ReverseBlockSizeSector(NANDIP_V620, BlockType.BlockSize512, 3)};
    private String boardType;

    public NandIPV620() {
        map.put("2k4bit", 60);
        map.put("2k8bit", 64);
        map.put("2k13bit", 64);
        map.put("2k24bit", 116);
        map.put("2k27bit", 128);
        map.put("4k4bit", 88);
        map.put("4k8bit", 128);
        map.put("4k13bit", 112);
        map.put("4k24bit", 200);
        map.put("4k27bit", 224);
        map.put("8k24bit", 368);
        map.put("8k27bit", 416);
        map.put("8k40bit", 592);
        map.put("8k41bit", 608);
        map.put("8k60bit", 896);
        map.put("8k64bit", 928);
        map.put("8k80bit", 1152);
        map.put("16k40bit", 1152);
        map.put("16k41bit", 1184);
        map.put("16k60bit", 1760);
        map.put("16k64bit", 1824);
        map.put("16k80bit", 1376);
    }

    @Override
    public FlashOption[] getAvailableOptions(IBurner burner) {
        this.burner = burner;
        UDProperties properties = ((UnknownDevice)burner.getBurnContext().getDeviceSetting()).getProperties();
        this.boardType = properties.queryForString("TYPE");
        if (this.boardType != null && this.boardType.equalsIgnoreCase("CAM")) {
            return new FlashOption[]{new FlashOption(ECCType.Ecc4bit, PageType.Size2K, -1), new FlashOption(ECCType.Ecc24bit1k, PageType.Size2K, -1), new FlashOption(ECCType.Ecc4bit, PageType.Size4K, -1), new FlashOption(ECCType.Ecc24bit1k, PageType.Size4K, -1), new FlashOption(ECCType.Ecc24bit1k, PageType.Size8K, -1), new FlashOption(ECCType.Ecc40bit1k, PageType.Size8K, -1), new FlashOption(ECCType.Ecc64bit1k, PageType.Size8K, -1), new FlashOption(ECCType.Ecc40bit1k, PageType.Size16K, -1), new FlashOption(ECCType.Ecc64bit1k, PageType.Size16K, -1)};
        }
        if (this.isFMCV100()) {
            return new FlashOption[]{new FlashOption(ECCType.Ecc4bit, PageType.Size2K, -1), new FlashOption(ECCType.Ecc8bit512, PageType.Size2K, -1), new FlashOption(ECCType.Ecc24bit1k, PageType.Size2K, -1), new FlashOption(ECCType.Ecc4bit, PageType.Size4K, -1), new FlashOption(ECCType.Ecc8bit512, PageType.Size4K, -1), new FlashOption(ECCType.Ecc24bit1k, PageType.Size4K, -1), new FlashOption(ECCType.Ecc24bit1k, PageType.Size8K, -1), new FlashOption(ECCType.Ecc40bit1k, PageType.Size8K, -1), new FlashOption(ECCType.Ecc64bit1k, PageType.Size8K, -1), new FlashOption(ECCType.Ecc40bit1k, PageType.Size16K, -1), new FlashOption(ECCType.Ecc64bit1k, PageType.Size16K, -1)};
        }
        return new FlashOption[]{new FlashOption(ECCType.Ecc4bit, PageType.Size2K, -1), new FlashOption(ECCType.Ecc8bit512, PageType.Size2K, -1), new FlashOption(ECCType.Ecc24bit1k, PageType.Size2K, -1), new FlashOption(ECCType.Ecc4bit, PageType.Size4K, -1), new FlashOption(ECCType.Ecc8bit512, PageType.Size4K, -1), new FlashOption(ECCType.Ecc24bit1k, PageType.Size4K, -1), new FlashOption(ECCType.Ecc24bit1k, PageType.Size8K, -1), new FlashOption(ECCType.Ecc40bit1k, PageType.Size8K, -1), new FlashOption(ECCType.Ecc40bit1k, PageType.Size16K, -1)};
    }

    @Override
    public byte[] genPageData(byte[] pagebuf, FlashOption option, int oobSize) {
        ECCV620 ecc = new ECCV620();
        if (option.getEccType() == ECCType.Ecc4bit) {
            if (option.getPageType() == PageType.Size2K) {
                return this.genPageDataBytesForV620(ecc, option, pagebuf, 30, 14);
            }
            if (option.getPageType() == PageType.Size4K) {
                return this.genPageDataBytesForV620(ecc, option, pagebuf, 30, 14);
            }
        }
        if (option.getEccType() == ECCType.Ecc8bit512) {
            if (option.getPageType() == PageType.Size2K) {
                return this.genPageDataBytesForV620(ecc, option, pagebuf, 6, 28);
            }
            if (option.getPageType() == PageType.Size4K) {
                return this.genPageDataBytesForV620(ecc, option, pagebuf, 14, 28);
            }
        }
        if (option.getEccType() == ECCType.Ecc24bit1k) {
            if (option.getPageType() == PageType.Size2K) {
                return this.genPageDataBytesForV620(ecc, option, pagebuf, 30, 42);
            }
            if (option.getPageType() == PageType.Size4K) {
                return this.genPageDataBytesForV620(ecc, option, pagebuf, 30, 42);
            }
            if (option.getPageType() == PageType.Size8K) {
                return this.genPageDataBytesForV620(ecc, option, pagebuf, 30, 42);
            }
        }
        if (option.getEccType() == ECCType.Ecc40bit1k) {
            if (option.getPageType() == PageType.Size8K) {
                return this.genPageDataBytesForV620(ecc, option, pagebuf, 30, 70);
            }
            if (option.getPageType() == PageType.Size16K) {
                return this.genPageDataBytesForV620(ecc, option, pagebuf, 30, 70);
            }
        }
        if (option.getEccType() == ECCType.Ecc64bit1k) {
            if (option.getPageType() == PageType.Size8K) {
                return this.genPageDataBytesForV620(ecc, option, pagebuf, 30, 112);
            }
            if (option.getPageType() == PageType.Size16K) {
                return this.genPageDataBytesForV620(ecc, option, pagebuf, 30, 112);
            }
        }
        return null;
    }

    @Override
    public void make(String outputPath, FlashOption option, List<PartitionItem> partitions, int blockSize, boolean isSelectRandom, IFastbootProgressMonitor fastbootMonitor, IProgressMonitor monitor) {
        int usedOobSize = 0;
        usedOobSize = this.getUsedOobSize(option);
        fastbootMonitor.infoln("\nStart to make nand burner image...");
        fastbootMonitor.infoln("Options: " + option.toString() + "\n");
        monitor.beginTask(Messages.NandImageDialog_Title, partitions.size());
        int randomPageNum = -1;
        if (isSelectRandom && blockSize > -1) {
            randomPageNum = option.getPageType().getPageSize() == PageType.Size16K.getPageSize() ? blockSize / option.getPageType().getPageSize() : blockSize / 8192;
        }
        for (PartitionItem item : partitions) {
            block28: {
                boolean supportEmpty;
                int pageMakeSize;
                boolean ret;
                RandomAccessFile outRanFile;
                RandomAccessFile inRanFile;
                File outFile;
                FileSystem fileSystem;
                int pageCount;
                int pageCheckSize;
                block27: {
                    boolean itemState;
                    if (monitor.isCanceled()) {
                        return;
                    }
                    boolean bl = itemState = !item.isChecked() || item.getFile() == null;
                    if (itemState) {
                        monitor.worked(1);
                        continue;
                    }
                    this.differenceBlockSize(item, blockSize);
                    fastbootMonitor.info("Make image for '" + item.getFile().getName() + "'...");
                    pageCheckSize = option.getPageType().getPageSize();
                    if (item.getFileSystem() == FileSystem.yaffs) {
                        pageCheckSize = this.boardType != null && this.boardType.equalsIgnoreCase("CAM") ? option.getPageType().getPageSize() + option.getOOBSize() : option.getPageType().getPageSize() + 32;
                    }
                    File file = item.getNewTempFile() == null ? item.getFile() : item.getNewTempFile();
                    pageCount = (int)((file.length() + (long)pageCheckSize - 1L) / (long)pageCheckSize);
                    fileSystem = item.getFileSystem();
                    if (fileSystem == FileSystem.yaffs) {
                        pageCount = (int)(file.length() / (long)pageCheckSize);
                    }
                    outFile = FileUtils.getFile((String[])new String[]{String.valueOf(outputPath) + File.separator + item.getFile().getName() + ".burn"});
                    com.vendor.burn.utilitily.FileUtils.deleteFile(outFile);
                    inRanFile = null;
                    outRanFile = null;
                    ret = true;
                    com.vendor.burn.utilitily.FileUtils.checkFilePath(file);
                    inRanFile = new RandomAccessFile(file, "r");
                    outRanFile = new RandomAccessFile(outFile, "rw");
                    pageMakeSize = option.getPageType().getPageSize() + 32;
                    if (this.boardType != null && this.boardType.equalsIgnoreCase("CAM")) {
                        pageMakeSize = option.getPageType().getPageSize() + option.getOOBSize();
                    }
                    long start = item.getStart();
                    int reversePageEccEec = 0;
                    int reverseBlockEec = 0;
                    boolean page0ReverseFlag = false;
                    boolean page1ReverseFlag = false;
                    boolean nandPinSaveMpde = false;
                    nandPinSaveMpde = ToolUtils.isCmdLine() ? PreferenceConfig.isImgOpenPinSaveMode() : FastbootPreferences.isNandPinSaveMpde();
                    if (this.isCJ3X1VX11Series() && this.curSelectedNandWay != null && this.curSelectedNandWay.equals("SPINand")) {
                        nandPinSaveMpde = false;
                    }
                    String curPinSaveMode = null;
                    supportEmpty = false;
                    if (this.curSelectedNandWay != null) {
                        if (this.curSelectedNandWay.equals("Nand")) {
                            curPinSaveMode = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getNandPinSaveMode();
                            supportEmpty = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportNandEmpty();
                        } else if (this.curSelectedNandWay.equals("SPINand")) {
                            curPinSaveMode = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getSpiNandPinSaveMode();
                            supportEmpty = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportSPINandEmpty();
                        }
                    }
                    if (nandPinSaveMpde && start == 0L) {
                        ReverseBlockSizeSector blockSizeReverseSector;
                        ReversePageEccSector[] sector = null;
                        sector = curPinSaveMode != null && curPinSaveMode.equalsIgnoreCase(NandIPV620.getPinSaveModeArray()[0]) ? (this.isFMCV100() ? nfc620_page_ecc_reverse_sector_fmcv100 : nfc620_page_ecc_reverse_sector) : (curPinSaveMode != null && curPinSaveMode.equalsIgnoreCase(NandIPV620.getPinSaveModeArray()[1]) ? (ReversePageEccSector[])NandIPV600.fmc100_page_ecc_reverse_sector.clone() : (this.isFMCV100() ? (ReversePageEccSector[])nfc620_page_ecc_reverse_sector_fmcv100.clone() : (ReversePageEccSector[])nfc620_page_ecc_reverse_sector.clone()));
                        PageType pageType = option.getPageType();
                        ECCType eccType = option.getEccType();
                        ReversePageEccSector pageSizeEccReverseSector = this.getPageSizeEccReverseSector(pageType, eccType, sector);
                        if (pageSizeEccReverseSector != null) {
                            reversePageEccEec = pageSizeEccReverseSector.getReverse_sec();
                        }
                        if ((blockSizeReverseSector = this.getBlockSizeReverseSector(blockSize, pageType)) != null) {
                            reverseBlockEec = blockSizeReverseSector.getReverse_sec();
                        }
                    }
                    ret = this.writeDataToFile(option, fastbootMonitor, usedOobSize, randomPageNum, pageCheckSize, pageCount, fileSystem, inRanFile, outRanFile, ret, pageMakeSize, start, reversePageEccEec, reverseBlockEec, page0ReverseFlag, page1ReverseFlag, nandPinSaveMpde);
                    if (!monitor.isCanceled()) break block27;
                    this.closeTransportStream(fastbootMonitor, inRanFile, outRanFile);
                    com.vendor.burn.utilitily.FileUtils.deleteFile(item.getNewTempFile());
                    if (!ret) {
                        com.vendor.burn.utilitily.FileUtils.deleteFile(outFile);
                        monitor.worked(1);
                        continue;
                    }
                    return;
                }
                try {
                    if (supportEmpty) {
                        ret = this.checkEmptyFlagAndWriteToFile(option, blockSize, fastbootMonitor, usedOobSize, randomPageNum, pageCheckSize, pageCount, fileSystem, outRanFile, ret, pageMakeSize);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fastbootMonitor.warnln("FAILED! (Source file not found.)");
                    monitor.worked(1);
                    this.closeTransportStream(fastbootMonitor, inRanFile, outRanFile);
                    com.vendor.burn.utilitily.FileUtils.deleteFile(item.getNewTempFile());
                    if (ret) continue;
                    com.vendor.burn.utilitily.FileUtils.deleteFile(outFile);
                    monitor.worked(1);
                    continue;
                }
                catch (IOException iOException) {
                    try {}
                    catch (Throwable throwable) {
                        this.closeTransportStream(fastbootMonitor, inRanFile, outRanFile);
                        com.vendor.burn.utilitily.FileUtils.deleteFile(item.getNewTempFile());
                        if (!ret) {
                            com.vendor.burn.utilitily.FileUtils.deleteFile(outFile);
                            monitor.worked(1);
                            continue;
                        }
                        throw throwable;
                    }
                    this.closeTransportStream(fastbootMonitor, inRanFile, outRanFile);
                    com.vendor.burn.utilitily.FileUtils.deleteFile(item.getNewTempFile());
                    if (!ret) {
                        com.vendor.burn.utilitily.FileUtils.deleteFile(outFile);
                        monitor.worked(1);
                        continue;
                    }
                    break block28;
                }
                this.closeTransportStream(fastbootMonitor, inRanFile, outRanFile);
                com.vendor.burn.utilitily.FileUtils.deleteFile(item.getNewTempFile());
                if (!ret) {
                    com.vendor.burn.utilitily.FileUtils.deleteFile(outFile);
                    monitor.worked(1);
                    continue;
                }
            }
            fastbootMonitor.info("OK!");
            fastbootMonitor.warnln("(Start Address = 0x" + Long.toHexString(item.getStart()) + ", Length = 0x" + Long.toHexString(item.getLength()) + ")");
            monitor.worked(1);
        }
        fastbootMonitor.infoln("\nImage creating operation ends. All of the selected partitions are processed.");
        monitor.done();
    }

    private boolean writeDataToFile(FlashOption option, IFastbootProgressMonitor fastbootMonitor, int usedOobSize, int randomPageNum, int pageCheckSize, int pageCount, FileSystem fileSystem, RandomAccessFile inRanFile, RandomAccessFile outRanFile, boolean ret, int pageMakeSize, long start, int reversePageEccEec, int reverseBlockEec, boolean page0ReverseFlag, boolean page1ReverseFlag, boolean nandPinSaveMpde) {
        int i = 0;
        while (i < pageCount) {
            block10: {
                byte[] pagebuf = BytesUtils.genBytesWithFF(pageMakeSize);
                try {
                    inRanFile.seek(i * pageCheckSize);
                    int read = inRanFile.read(pagebuf, 0, pageCheckSize);
                    if (read < 0) {
                        System.out.println("Read Error.");
                    }
                    boolean isCAM = this.boardType != null && this.boardType.equalsIgnoreCase("CAM");
                    this.pageBufferValue(option, pageCheckSize, fileSystem, pageMakeSize, pagebuf, isCAM);
                }
                catch (IOException iOException) {
                    fastbootMonitor.warnln("FAILED! (Read data error.)");
                    ret = false;
                    break;
                }
                byte[] data = null;
                try {
                    data = this.genPageData(pagebuf, option, option.getOOBSize());
                    if (data == null) break;
                    this.dealWithNandCRandom(option, usedOobSize, randomPageNum, i, data);
                    if (nandPinSaveMpde && start == 0L) {
                        if (!page0ReverseFlag) {
                            int page0ReverseOff = 32 * reversePageEccEec;
                            NandIPV620.reverseBuf(data, page0ReverseOff, 32);
                        }
                        if (page0ReverseFlag && !page1ReverseFlag) {
                            int page1ReverseOff = 32 * reverseBlockEec;
                            NandIPV620.reverseBuf(data, page1ReverseOff, 32);
                            page1ReverseFlag = true;
                        }
                        page0ReverseFlag = true;
                    }
                    outRanFile.seek(i * (option.getPageType().getPageSize() + option.getOOBSize()));
                    outRanFile.write(data);
                    if (outRanFile.length() % (long)(option.getPageType().getPageSize() + option.getOOBSize()) != 0L) {
                        fastbootMonitor.warnln("FAILED! (Could not write output file.)");
                        ret = false;
                    }
                    break block10;
                }
                catch (Exception exception) {
                    fastbootMonitor.warnln("FAILED! (Data convert error.)");
                    ret = false;
                }
                break;
            }
            ++i;
        }
        return ret;
    }

    public void dealWithNandCRandom(FlashOption option, int usedOobSize, int randomPageNum, int i, byte[] data) {
        if (randomPageNum > 0) {
            NandCRandom random = new NandCRandom();
            if (usedOobSize != 0) {
                random.page_random_genV610(data, option.getPageType().getPageSize(), usedOobSize, i % randomPageNum);
            } else {
                random.page_random_genV610(data, option.getPageType().getPageSize(), option.getOOBSize(), i % randomPageNum);
            }
        }
    }

    private boolean checkEmptyFlagAndWriteToFile(FlashOption option, int blockSize, IFastbootProgressMonitor fastbootMonitor, int usedOobSize, int randomPageNum, int pageCheckSize, int pageCount, FileSystem fileSystem, RandomAccessFile outRanFile, boolean ret, int pageMakeSize) {
        int currentPageIndex = pageCount;
        int page_num_incl_data = pageCount;
        int page_per_block = blockSize / option.getPageType().getPageSize();
        int page_num_total_block = page_num_incl_data & ~(page_per_block - 1);
        int page_num_fill_null = (page_num_total_block += (page_num_incl_data & page_per_block - 1) > 0 ? page_per_block : 0) - page_num_incl_data;
        while (page_num_fill_null-- > 0) {
            byte[] pagebuf = BytesUtils.genBytesWithFF(pageMakeSize);
            boolean isCAM = this.boardType != null && this.boardType.equalsIgnoreCase("CAM");
            this.pageBufferValue(option, pageCheckSize, fileSystem, pageMakeSize, pagebuf, isCAM);
            byte[] data = null;
            try {
                data = this.genPageData(pagebuf, option, option.getOOBSize());
                NandCRandom random = new NandCRandom();
                if (randomPageNum > -1 && data != null) {
                    if (usedOobSize != 0) {
                        random.page_random_genV610(data, option.getPageType().getPageSize(), usedOobSize, currentPageIndex % randomPageNum);
                    } else {
                        random.page_random_genV610(data, option.getPageType().getPageSize(), option.getOOBSize(), currentPageIndex % randomPageNum);
                    }
                    outRanFile.write(data);
                }
                ++currentPageIndex;
            }
            catch (Exception exception) {
                fastbootMonitor.warnln("FAILED! (Write Empty flag error.)");
                ret = false;
                break;
            }
        }
        return ret;
    }

    public void pageBufferValue(FlashOption option, int pageCheckSize, FileSystem fileSystem, int pageMakeSize, byte[] pagebuf, boolean isCAM) {
        if (isCAM) {
            int camPageEmptyFlag = option.getPageType().getPageSize() + 32;
            if (fileSystem == FileSystem.ubiFs) {
                if (this.checkBufferFF(pagebuf, pageCheckSize)) {
                    pagebuf[camPageEmptyFlag - 1] = 0;
                    pagebuf[camPageEmptyFlag - 2] = 0;
                }
            } else {
                pagebuf[camPageEmptyFlag - 1] = 0;
                pagebuf[camPageEmptyFlag - 2] = 0;
            }
        } else if (fileSystem == FileSystem.ubiFs) {
            if (this.checkBufferFF(pagebuf, pageCheckSize)) {
                pagebuf[pageMakeSize - 1] = 0;
                pagebuf[pageMakeSize - 2] = 0;
            }
        } else {
            pagebuf[pageMakeSize - 1] = 0;
            pagebuf[pageMakeSize - 2] = 0;
        }
    }

    public boolean checkBufferFF(byte[] pagebuf, int length) {
        int index = 0;
        while (index < length) {
            if (pagebuf[index] != -1) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public static void printHexString(byte[] b) {
        int i = 0;
        while (i < b.length) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            System.out.print(String.valueOf(hex.toUpperCase()) + ",");
            ++i;
        }
    }

    private static void reverseBuf(byte[] buf, int startOff, int reverseLen) {
        int i = startOff;
        while (i < startOff + reverseLen) {
            buf[i] = ~buf[i];
            ++i;
        }
    }

    private ReversePageEccSector getPageSizeEccReverseSector(PageType pagetype, ECCType ecctype, ReversePageEccSector[] sector) {
        int i = 0;
        while (i < sector.length) {
            if (sector[i].getEcctype() == ecctype && sector[i].getPagetype() == pagetype) {
                return sector[i];
            }
            ++i;
        }
        return null;
    }

    private ReverseBlockSizeSector getBlockSizeReverseSector(int blocksize, PageType pageType) {
        int pageNum = blocksize / pageType.getPageSize();
        ReverseBlockSizeSector[] sector = nfc620_blocksize_reverse_sector;
        int i = 0;
        while (i < sector.length) {
            if (sector[i].getBlocktype().getSize() == pageNum) {
                return sector[i];
            }
            ++i;
        }
        return null;
    }

    private int getUsedOobSize(FlashOption option) {
        int usedOobSize = 0;
        if (option.getEccType() == ECCType.Ecc4bit) {
            if (option.getPageType() == PageType.Size2K) {
                if (map.get("2k4bit") != null) {
                    return map.get("2k4bit");
                }
            } else if (option.getPageType() == PageType.Size4K && map.get("4k4bit") != null) {
                return map.get("4k4bit");
            }
        }
        if (option.getEccType() == ECCType.Ecc8bit512) {
            if (option.getPageType() == PageType.Size2K) {
                if (map.get("2k8bit") != null) {
                    return map.get("2k8bit");
                }
            } else if (option.getPageType() == PageType.Size4K && map.get("4k8bit") != null) {
                return map.get("4k8bit");
            }
        }
        if (option.getEccType() == ECCType.Ecc13bit) {
            if (option.getPageType() == PageType.Size2K) {
                if (map.get("2k13bit") != null) {
                    return map.get("2k13bit");
                }
            } else if (option.getPageType() == PageType.Size4K && map.get("4k13bit") != null) {
                return map.get("4k13bit");
            }
        }
        if (option.getEccType() == ECCType.Ecc24bit1k) {
            if (option.getPageType() == PageType.Size2K) {
                if (map.get("2k24bit") != null) {
                    return map.get("2k24bit");
                }
            } else if (option.getPageType() == PageType.Size4K) {
                if (map.get("4k24bit") != null) {
                    return map.get("4k24bit");
                }
            } else if (option.getPageType() == PageType.Size8K && map.get("8k24bit") != null) {
                return map.get("8k24bit");
            }
        }
        if (option.getEccType() == ECCType.Ecc27bit) {
            if (option.getPageType() == PageType.Size2K) {
                if (map.get("2k27bit") != null) {
                    return map.get("2k27bit");
                }
            } else if (option.getPageType() == PageType.Size4K) {
                if (map.get("4k27bit") != null) {
                    return map.get("4k27bit");
                }
            } else if (option.getPageType() == PageType.Size8K && map.get("8k27bit") != null) {
                return map.get("8k27bit");
            }
        }
        if (option.getEccType() == ECCType.Ecc40bit1k) {
            if (option.getPageType() == PageType.Size8K) {
                if (map.get("8k40bit") != null) {
                    return map.get("8k40bit");
                }
            } else if (option.getPageType() == PageType.Size16K && map.get("16k40bit") != null) {
                return map.get("16k40bit");
            }
        }
        if (option.getEccType() == ECCType.Ecc41bit) {
            if (option.getPageType() == PageType.Size8K) {
                if (map.get("8k41bit") != null) {
                    return map.get("8k41bit");
                }
            } else if (option.getPageType() == PageType.Size16K && map.get("16k41bit") != null) {
                return map.get("16k41bit");
            }
        }
        if (option.getEccType() == ECCType.Ecc60bit) {
            if (option.getPageType() == PageType.Size8K) {
                if (map.get("8k60bit") != null) {
                    return map.get("8k60bit");
                }
            } else if (option.getPageType() == PageType.Size16K && map.get("16k60bit") != null) {
                return map.get("16k60bit");
            }
        }
        if (option.getEccType() == ECCType.Ecc64bit1k) {
            if (option.getPageType() == PageType.Size8K) {
                if (map.get("8k64bit") != null) {
                    return map.get("8k64bit");
                }
            } else if (option.getPageType() == PageType.Size16K && map.get("16k64bit") != null) {
                return map.get("16k64bit");
            }
        }
        if (option.getEccType() == ECCType.Ecc80bit) {
            if (option.getPageType() == PageType.Size8K) {
                if (map.get("8k80bit") != null) {
                    return map.get("8k80bit");
                }
            } else if (option.getPageType() == PageType.Size16K && map.get("16k80bit") != null) {
                return map.get("16k80bit");
            }
        }
        return usedOobSize;
    }

    public String toString() {
        return "Nand IP V620";
    }

    private boolean isFMCV100() {
        String chipName = ToolUtils.getChipName();
        if (chipName == null) {
            return false;
        }
        if (chipName.contains("-")) {
            chipName = chipName.replace("-", "_");
        }
        String[] stringArray = FMCV100LIST;
        int n = FMCV100LIST.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (chipName.equalsIgnoreCase(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isCJ3X1VX11Series() {
        boolean result;
        String chipName = ToolUtils.getChipName();
        if (chipName == null) {
            return false;
        }
        if (chipName.contains("-")) {
            chipName = chipName.replace("-", "_");
        }
        boolean bl = result = chipName.equalsIgnoreCase("CJ3X1VX11") || chipName.equalsIgnoreCase("CJ3X1VX11H") || chipName.equalsIgnoreCase("CJ3X1VX13") || chipName.equalsIgnoreCase("CJXX0VXX8") || chipName.equalsIgnoreCase("CJXX0VXX8H");
        return result;
    }

    public static ReversePageEccSector[] getNfc620PageEccReverseSector() {
        return (ReversePageEccSector[])nfc620_page_ecc_reverse_sector.clone();
    }
}

