/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.packagers.pro;

import com.vendor.burn.Messages;
import com.vendor.burn.model.FileSystem;
import com.vendor.burn.model.FlashType;
import com.vendor.burn.model.PartitionItem;
import com.vendor.burn.model.config.PreferenceConfig;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import com.vendor.burn.model.struct.SPartitionItem;
import com.vendor.burn.model.struct.SPartitionTable;
import com.vendor.burn.packagers.PackageData;
import com.vendor.burn.packagers.pro.CRC32A;
import com.vendor.burn.packagers.pro.DownloadType;
import com.vendor.burn.packagers.pro.UsbHeader;
import com.vendor.burn.packagers.pro.UsbImageMap;
import com.vendor.burn.packagers.pro.UsbManuInfo;
import com.vendor.burn.preferences.FastbootPreferences;
import com.vendor.burn.utilitily.BytesUtils;
import com.vendor.burn.utilitily.DataUtils;
import com.vendor.burn.utilitily.FileUtils;
import com.vendor.burn.utilitily.ToolUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.preference.IPreferenceStore;

public class EmmcProPackager {
    static final int MAXIMUM_PARTS = 4;
    static final int MAXINUM_CYLINDER = 1023;
    static final int MAXINUM_HEADS = 4;
    static final int MAXINUM_SECTORS = 16;
    static final int SECTOR_SIZE = 512;
    static final int ACTIVE_FLAG = 128;
    static final int EXTENDED = 5;
    static final int LINUX_PARTITION = 129;
    static final int LINUX_SWAP = 130;
    static final int LINUX_NATIVE = 131;
    static final int LINUX_EXTENDED = 133;
    static final int LINUX_LVM = 142;
    static final int LINUX_RAID = 253;
    static final int[] eMMCBootSector;
    static final int FILE_PART_SIZE = 0x400000;
    static final int EMPTY_LEN = 0x500000;
    public static int EMMC_FILE_BLOCK_SIZE;
    public static final int PACK_STATUS_SUCCESS = 0;
    public static final int PACK_STATUS_FAILED = 1;
    public static final int PACK_STATUS_USERCANCELED = -1;
    public static final int DATA_ALIGN_LENGTH = 512;
    UsbHeader header;
    List<PartitionItem> partitionItems;
    private IBurner burner;

    static {
        int[] nArray = new int[512];
        nArray[0] = 6;
        nArray[3] = 234;
        nArray[4] = 254;
        nArray[5] = 255;
        nArray[6] = 255;
        nArray[7] = 234;
        nArray[8] = 254;
        nArray[9] = 255;
        nArray[10] = 255;
        nArray[11] = 234;
        nArray[12] = 254;
        nArray[13] = 255;
        nArray[14] = 255;
        nArray[15] = 234;
        nArray[16] = 254;
        nArray[17] = 255;
        nArray[18] = 255;
        nArray[19] = 234;
        nArray[20] = 254;
        nArray[21] = 255;
        nArray[22] = 255;
        nArray[23] = 234;
        nArray[24] = 254;
        nArray[25] = 255;
        nArray[26] = 255;
        nArray[27] = 234;
        nArray[28] = 254;
        nArray[29] = 255;
        nArray[30] = 255;
        nArray[31] = 234;
        nArray[32] = 15;
        nArray[34] = 160;
        nArray[35] = 225;
        nArray[36] = 8;
        nArray[38] = 64;
        nArray[39] = 226;
        nArray[40] = 208;
        nArray[41] = 16;
        nArray[42] = 159;
        nArray[43] = 229;
        nArray[44] = 1;
        nArray[46] = 128;
        nArray[47] = 224;
        nArray[49] = 240;
        nArray[50] = 160;
        nArray[51] = 225;
        nArray[53] = 240;
        nArray[54] = 32;
        nArray[55] = 227;
        nArray[57] = 240;
        nArray[58] = 32;
        nArray[59] = 227;
        nArray[61] = 240;
        nArray[62] = 32;
        nArray[63] = 227;
        nArray[65] = 240;
        nArray[66] = 32;
        nArray[67] = 227;
        nArray[69] = 240;
        nArray[70] = 32;
        nArray[71] = 227;
        nArray[73] = 240;
        nArray[74] = 32;
        nArray[75] = 227;
        nArray[77] = 240;
        nArray[78] = 32;
        nArray[79] = 227;
        nArray[81] = 240;
        nArray[82] = 32;
        nArray[83] = 227;
        nArray[84] = 254;
        nArray[85] = 255;
        nArray[86] = 255;
        nArray[87] = 234;
        nArray[88] = 255;
        nArray[89] = 255;
        nArray[90] = 255;
        nArray[91] = 255;
        nArray[92] = 255;
        nArray[93] = 255;
        nArray[94] = 255;
        nArray[95] = 255;
        nArray[96] = 255;
        nArray[97] = 255;
        nArray[98] = 255;
        nArray[99] = 255;
        nArray[100] = 255;
        nArray[101] = 255;
        nArray[102] = 255;
        nArray[103] = 255;
        nArray[104] = 255;
        nArray[105] = 255;
        nArray[106] = 255;
        nArray[107] = 255;
        nArray[108] = 255;
        nArray[109] = 255;
        nArray[110] = 255;
        nArray[111] = 255;
        nArray[112] = 255;
        nArray[113] = 255;
        nArray[114] = 255;
        nArray[115] = 255;
        nArray[116] = 255;
        nArray[117] = 255;
        nArray[118] = 255;
        nArray[119] = 255;
        nArray[120] = 255;
        nArray[121] = 255;
        nArray[122] = 255;
        nArray[123] = 255;
        nArray[124] = 255;
        nArray[125] = 255;
        nArray[126] = 255;
        nArray[127] = 255;
        nArray[128] = 255;
        nArray[129] = 255;
        nArray[130] = 255;
        nArray[131] = 255;
        nArray[132] = 255;
        nArray[133] = 255;
        nArray[134] = 255;
        nArray[135] = 255;
        nArray[136] = 255;
        nArray[137] = 255;
        nArray[138] = 255;
        nArray[139] = 255;
        nArray[140] = 255;
        nArray[141] = 255;
        nArray[142] = 255;
        nArray[143] = 255;
        nArray[144] = 255;
        nArray[145] = 255;
        nArray[146] = 255;
        nArray[147] = 255;
        nArray[148] = 255;
        nArray[149] = 255;
        nArray[150] = 255;
        nArray[151] = 255;
        nArray[152] = 255;
        nArray[153] = 255;
        nArray[154] = 255;
        nArray[155] = 255;
        nArray[156] = 255;
        nArray[157] = 255;
        nArray[158] = 255;
        nArray[159] = 255;
        nArray[160] = 255;
        nArray[161] = 255;
        nArray[162] = 255;
        nArray[163] = 255;
        nArray[164] = 255;
        nArray[165] = 255;
        nArray[166] = 255;
        nArray[167] = 255;
        nArray[168] = 255;
        nArray[169] = 255;
        nArray[170] = 255;
        nArray[171] = 255;
        nArray[172] = 255;
        nArray[173] = 255;
        nArray[174] = 255;
        nArray[175] = 255;
        nArray[176] = 255;
        nArray[177] = 255;
        nArray[178] = 255;
        nArray[179] = 255;
        nArray[180] = 255;
        nArray[181] = 255;
        nArray[182] = 255;
        nArray[183] = 255;
        nArray[184] = 255;
        nArray[185] = 255;
        nArray[186] = 255;
        nArray[187] = 255;
        nArray[188] = 255;
        nArray[189] = 255;
        nArray[190] = 255;
        nArray[191] = 255;
        nArray[192] = 255;
        nArray[193] = 255;
        nArray[194] = 255;
        nArray[195] = 255;
        nArray[196] = 255;
        nArray[197] = 255;
        nArray[198] = 255;
        nArray[199] = 255;
        nArray[200] = 255;
        nArray[201] = 255;
        nArray[202] = 255;
        nArray[203] = 255;
        nArray[204] = 255;
        nArray[205] = 255;
        nArray[206] = 255;
        nArray[207] = 255;
        nArray[208] = 255;
        nArray[209] = 255;
        nArray[210] = 255;
        nArray[211] = 255;
        nArray[212] = 255;
        nArray[213] = 255;
        nArray[214] = 255;
        nArray[215] = 255;
        nArray[216] = 255;
        nArray[217] = 255;
        nArray[218] = 255;
        nArray[219] = 255;
        nArray[220] = 255;
        nArray[221] = 255;
        nArray[222] = 255;
        nArray[223] = 255;
        nArray[224] = 255;
        nArray[225] = 255;
        nArray[226] = 255;
        nArray[227] = 255;
        nArray[228] = 255;
        nArray[229] = 255;
        nArray[230] = 255;
        nArray[231] = 255;
        nArray[232] = 255;
        nArray[233] = 255;
        nArray[234] = 255;
        nArray[235] = 255;
        nArray[236] = 255;
        nArray[237] = 255;
        nArray[238] = 255;
        nArray[239] = 255;
        nArray[240] = 255;
        nArray[241] = 255;
        nArray[242] = 255;
        nArray[243] = 255;
        nArray[244] = 255;
        nArray[245] = 255;
        nArray[246] = 255;
        nArray[247] = 255;
        nArray[248] = 255;
        nArray[249] = 255;
        nArray[250] = 255;
        nArray[251] = 255;
        nArray[252] = 255;
        nArray[253] = 255;
        nArray[254] = 255;
        nArray[255] = 255;
        nArray[256] = 224;
        nArray[257] = 1;
        nArray[260] = 255;
        nArray[261] = 255;
        nArray[262] = 255;
        nArray[263] = 255;
        nArray[264] = 255;
        nArray[265] = 255;
        nArray[266] = 255;
        nArray[267] = 255;
        nArray[268] = 255;
        nArray[269] = 255;
        nArray[270] = 255;
        nArray[271] = 255;
        nArray[272] = 255;
        nArray[273] = 255;
        nArray[274] = 255;
        nArray[275] = 255;
        nArray[276] = 255;
        nArray[277] = 255;
        nArray[278] = 255;
        nArray[279] = 255;
        nArray[280] = 255;
        nArray[281] = 255;
        nArray[282] = 255;
        nArray[283] = 255;
        nArray[284] = 255;
        nArray[285] = 255;
        nArray[286] = 255;
        nArray[287] = 255;
        nArray[288] = 255;
        nArray[289] = 255;
        nArray[290] = 255;
        nArray[291] = 255;
        nArray[292] = 255;
        nArray[293] = 255;
        nArray[294] = 255;
        nArray[295] = 255;
        nArray[296] = 255;
        nArray[297] = 255;
        nArray[298] = 255;
        nArray[299] = 255;
        nArray[300] = 255;
        nArray[301] = 255;
        nArray[302] = 255;
        nArray[303] = 255;
        nArray[304] = 255;
        nArray[305] = 255;
        nArray[306] = 255;
        nArray[307] = 255;
        nArray[308] = 255;
        nArray[309] = 255;
        nArray[310] = 255;
        nArray[311] = 255;
        nArray[312] = 255;
        nArray[313] = 255;
        nArray[314] = 255;
        nArray[315] = 255;
        nArray[316] = 255;
        nArray[317] = 255;
        nArray[318] = 255;
        nArray[319] = 255;
        nArray[320] = 255;
        nArray[321] = 255;
        nArray[322] = 255;
        nArray[323] = 255;
        nArray[324] = 255;
        nArray[325] = 255;
        nArray[326] = 255;
        nArray[327] = 255;
        nArray[328] = 255;
        nArray[329] = 255;
        nArray[330] = 255;
        nArray[331] = 255;
        nArray[332] = 255;
        nArray[333] = 255;
        nArray[334] = 255;
        nArray[335] = 255;
        nArray[336] = 255;
        nArray[337] = 255;
        nArray[338] = 255;
        nArray[339] = 255;
        nArray[340] = 255;
        nArray[341] = 255;
        nArray[342] = 255;
        nArray[343] = 255;
        nArray[344] = 255;
        nArray[345] = 255;
        nArray[346] = 255;
        nArray[347] = 255;
        nArray[348] = 255;
        nArray[349] = 255;
        nArray[350] = 255;
        nArray[351] = 255;
        nArray[352] = 255;
        nArray[353] = 255;
        nArray[354] = 255;
        nArray[355] = 255;
        nArray[356] = 255;
        nArray[357] = 255;
        nArray[358] = 255;
        nArray[359] = 255;
        nArray[360] = 255;
        nArray[361] = 255;
        nArray[362] = 255;
        nArray[363] = 255;
        nArray[364] = 255;
        nArray[365] = 255;
        nArray[366] = 255;
        nArray[367] = 255;
        nArray[368] = 255;
        nArray[369] = 255;
        nArray[370] = 255;
        nArray[371] = 255;
        nArray[372] = 255;
        nArray[373] = 255;
        nArray[374] = 255;
        nArray[375] = 255;
        nArray[376] = 255;
        nArray[377] = 255;
        nArray[378] = 255;
        nArray[379] = 255;
        nArray[380] = 255;
        nArray[381] = 255;
        nArray[382] = 255;
        nArray[383] = 255;
        nArray[384] = 255;
        nArray[385] = 255;
        nArray[386] = 255;
        nArray[387] = 255;
        nArray[388] = 255;
        nArray[389] = 255;
        nArray[390] = 255;
        nArray[391] = 255;
        nArray[392] = 255;
        nArray[393] = 255;
        nArray[394] = 255;
        nArray[395] = 255;
        nArray[396] = 255;
        nArray[397] = 255;
        nArray[398] = 255;
        nArray[399] = 255;
        nArray[400] = 255;
        nArray[401] = 255;
        nArray[402] = 255;
        nArray[403] = 255;
        nArray[404] = 255;
        nArray[405] = 255;
        nArray[406] = 255;
        nArray[407] = 255;
        nArray[408] = 255;
        nArray[409] = 255;
        nArray[410] = 255;
        nArray[411] = 255;
        nArray[412] = 255;
        nArray[413] = 255;
        nArray[414] = 255;
        nArray[415] = 255;
        nArray[416] = 255;
        nArray[417] = 255;
        nArray[418] = 255;
        nArray[419] = 255;
        nArray[420] = 255;
        nArray[421] = 255;
        nArray[422] = 255;
        nArray[423] = 255;
        nArray[424] = 255;
        nArray[425] = 255;
        nArray[426] = 255;
        nArray[427] = 255;
        nArray[428] = 255;
        nArray[429] = 255;
        nArray[430] = 255;
        nArray[431] = 255;
        nArray[432] = 255;
        nArray[433] = 255;
        nArray[434] = 255;
        nArray[435] = 255;
        nArray[436] = 255;
        nArray[437] = 255;
        nArray[438] = 255;
        nArray[439] = 255;
        nArray[440] = 255;
        nArray[441] = 255;
        nArray[442] = 255;
        nArray[443] = 255;
        nArray[444] = 255;
        nArray[445] = 255;
        nArray[510] = 85;
        nArray[511] = 170;
        eMMCBootSector = nArray;
        EMMC_FILE_BLOCK_SIZE = 8192;
    }

    public EmmcProPackager(IBurner burner) {
        this.burner = burner;
    }

    private boolean eMMCSetPartTableItem(SPartitionItem part, long baseAddress, long absoluteAddress, long length) {
        boolean checkResult = this.checkDataAlign(baseAddress, absoluteAddress, length);
        if (!checkResult) {
            return checkResult;
        }
        long baseAddressSector = baseAddress / 512L;
        long absoluteStartSector = absoluteAddress / 512L;
        long absoluteStopSector = (absoluteAddress + length - 1L) / 512L;
        long start = absoluteStartSector;
        long size = absoluteStopSector - absoluteStartSector + 1L;
        start = 131 == part.sys_ind ? 1L : absoluteStartSector - baseAddressSector;
        if (absoluteStartSector / 64L > 1023L) {
            absoluteStartSector = 65535L;
        }
        if (absoluteStopSector / 64L > 1023L) {
            absoluteStopSector = 65535L;
        }
        long nStartSector = absoluteStartSector % 16L + 1L;
        long nStartHead = absoluteStartSector / 16L % 4L;
        long nStartCylinder = absoluteStartSector / 16L / 4L;
        long nStopSector = absoluteStopSector % 16L + 1L;
        long nStopHead = absoluteStopSector / 16L % 4L;
        long nStopCylinder = absoluteStopSector / 16L / 4L;
        part.head = (int)(nStartHead & 0xFFL);
        part.sector = (int)(nStartSector & 0xFFL);
        part.cyl = (int)(nStartCylinder & 0xFFL);
        part.sector = (int)((long)part.sector | nStartCylinder >> 2 & 0xC0L);
        part.end_head = (int)(nStopHead & 0xFFL);
        part.end_sector = (int)(nStopSector & 0xFFL);
        part.end_cyl = (int)(nStopCylinder & 0xFFL);
        part.end_sector = (int)((long)part.end_sector | nStopCylinder >> 2 & 0xC0L);
        part.start4[0] = (int)(start & 0xFFL);
        part.start4[1] = (int)(start >> 8) & 0xFF;
        part.start4[2] = (int)(start >> 16) & 0xFF;
        part.start4[3] = (int)(start >> 24) & 0xFF;
        part.size4[0] = (int)(size & 0xFFL);
        part.size4[1] = (int)(size >> 8) & 0xFF;
        part.size4[2] = (int)(size >> 16) & 0xFF;
        part.size4[3] = (int)(size >> 24) & 0xFF;
        return true;
    }

    public boolean checkDataAlign(long baseAddress, long absoluteAddress, long length) {
        if (baseAddress % 512L != 0L) {
            return false;
        }
        if (absoluteAddress % 512L != 0L) {
            return false;
        }
        return length % 512L == 0L;
    }

    protected SPartitionTable[] getPartitionTables(UsbManuInfo manuInfo) {
        UsbImageMap map;
        int emmcType = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getEmmcType();
        if (emmcType == 2) {
            return null;
        }
        int tableCount = manuInfo.getImageMaps().size();
        SPartitionTable[] partTables = new SPartitionTable[tableCount];
        int i = 0;
        while (i < tableCount) {
            partTables[i] = new SPartitionTable();
            ++i;
        }
        partTables[0].build(eMMCBootSector);
        int partTableIndex = 1;
        long baseAddress = 0L;
        long lastAddress = 0L;
        int i2 = 1;
        while (i2 < tableCount) {
            map = manuInfo.getImageMaps().get(i2);
            if (map.fileSystem == FileSystem.ext3 || map.fileSystem == FileSystem.f2fs || map.fileSystem == FileSystem.erofs) {
                lastAddress = map.endAddress;
            }
            ++i2;
        }
        i2 = 1;
        while (i2 < tableCount) {
            map = manuInfo.getImageMaps().get(i2);
            if (map.fileSystem == FileSystem.ext3) {
                long realStartAddress = map.startAddress;
                long length = map.endAddress - map.startAddress;
                SPartitionTable table = partTables[partTableIndex];
                table.part[0].boot_ind = 0;
                table.part[0].sys_ind = 131;
                table.szValidMark[0] = 85;
                table.szValidMark[1] = 170;
                this.eMMCSetPartTableItem(table.part[0], baseAddress, realStartAddress, length);
                SPartitionTable previousTable = partTables[partTableIndex - 1];
                previousTable.part[1].boot_ind = 0;
                previousTable.part[1].sys_ind = 5;
                long extendedLength = length + 512L;
                if (1 == partTableIndex) {
                    extendedLength = lastAddress - map.startAddress;
                }
                this.eMMCSetPartTableItem(previousTable.part[1], baseAddress, realStartAddress, extendedLength);
                if (1 == partTableIndex) {
                    baseAddress = map.startAddress;
                }
                ++partTableIndex;
            }
            ++i2;
        }
        return partTables;
    }

    public void setPartitionItems(List<PartitionItem> items) {
        this.partitionItems = items;
    }

    private File generateTempBoot() {
        PartitionItem fastbootItem;
        if (this.partitionItems != null && (fastbootItem = this.partitionItems.get(0)) != null) {
            String tempFileName;
            File tempFile;
            File fastbootFile = fastbootItem.getFile();
            byte[] fastbootBytes = FileUtils.readAllBytes(fastbootFile.getAbsolutePath());
            String fillData = null;
            if (ToolUtils.isCmdLine()) {
                fillData = String.valueOf(PreferenceConfig.getImgFillData());
            } else {
                IPreferenceStore preferences = FastbootPreferences.getPreferenceStore();
                fillData = preferences.getString("vendor.burn.config.imageFill");
            }
            byte[] pagebuf = new byte[512];
            if (fillData.equals("0xFF")) {
                pagebuf = BytesUtils.genBytesWithFF(512);
            }
            int fastbootLen = fastbootBytes.length;
            byte[] newTargetBytes = new byte[fastbootLen + 512];
            BytesUtils.copyBytes(newTargetBytes, pagebuf, 0, 0, pagebuf.length);
            BytesUtils.copyBytes(newTargetBytes, fastbootBytes, 512, 0, fastbootBytes.length);
            String parentFolder = fastbootFile.getParent();
            if (parentFolder == null) {
                parentFolder = "/";
            }
            if ((tempFile = new File(tempFileName = String.valueOf(parentFolder) + "/fastboot.temp")).exists() && !tempFile.delete()) {
                tempFile.deleteOnExit();
            }
            RandomAccessFile randFile = null;
            try {
                try {
                    randFile = new RandomAccessFile(tempFile, "rw");
                    randFile.seek(0L);
                    randFile.write(newTargetBytes);
                }
                catch (IOException iOException) {
                    File file = fastbootFile;
                    try {
                        if (randFile != null) {
                            randFile.close();
                        }
                    }
                    catch (IOException iOException2) {
                        return fastbootFile;
                    }
                    return file;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (randFile != null) {
                        randFile.close();
                    }
                }
                catch (IOException iOException) {
                    return fastbootFile;
                }
                throw throwable;
            }
            try {
                if (randFile != null) {
                    randFile.close();
                }
            }
            catch (IOException iOException) {
                return fastbootFile;
            }
            return new File(tempFileName);
        }
        return null;
    }

    protected int loadArguments(SubMonitor monitor, ArrayList<File> tmpFiles) {
        int emmcType = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getEmmcType();
        this.header = new UsbHeader();
        this.header.magicNum = 1280262468;
        UsbManuInfo manuInfo = new UsbManuInfo();
        manuInfo.manuId = 3;
        manuInfo.hardVersion = 1;
        manuInfo.softVersion = 0x1010101;
        manuInfo.snStart = 0;
        manuInfo.snEnd = -1;
        manuInfo.downloadType = DownloadType.BASIC;
        manuInfo.reserved = 0;
        long offset = 0L;
        File tempFastboot = null;
        if (emmcType == 3) {
            tempFastboot = this.generateTempBoot();
        }
        ArrayList<UsbImageMap> imgList = new ArrayList<UsbImageMap>();
        int i = 0;
        while (i < this.partitionItems.size()) {
            block20: {
                UsbImageMap img;
                block23: {
                    PartitionItem partItem;
                    block21: {
                        block22: {
                            if (monitor.isCanceled()) {
                                return -1;
                            }
                            partItem = this.partitionItems.get(i);
                            if (!partItem.isChecked()) break block20;
                            img = new UsbImageMap();
                            img.startAddress = partItem.getStart() + offset;
                            img.endAddress = img.startAddress + partItem.getLength();
                            img.flashType = partItem.getFlashType();
                            img.fileSystem = partItem.getFileSystem();
                            img.flashIndex = 0;
                            if (partItem.getFileSystem() == FileSystem.yaffs) {
                                img.flashIndex |= 0x10000;
                            }
                            if (img.fileSystem == FileSystem.ext3 || img.fileSystem == FileSystem.f2fs || img.fileSystem == FileSystem.erofs) {
                                if (emmcType < 2) {
                                    offset += 512L;
                                }
                            } else {
                                img.startAddress -= offset;
                                img.endAddress = img.startAddress + partItem.getLength();
                            }
                            if (partItem.getFile() != null) break block21;
                            img.fileName = null;
                            if (emmcType >= 2) break block22;
                            if (img.fileSystem != FileSystem.ext3 && i != 0) break block20;
                            img.fileLength = 512L;
                            break block23;
                        }
                        img.fileLength = partItem.getLength();
                        img.fileName = "tempToEarse";
                        break block23;
                    }
                    if (i == 0 && !partItem.isChecked()) {
                        img.fileName = null;
                        img.fileLength = emmcType < 2 ? 512L : 0L;
                    } else {
                        img.fileName = partItem.getFile().getPath();
                        if (emmcType == 3) {
                            if (partItem.getName().equalsIgnoreCase("fastboot") && i == 0) {
                                if (tempFastboot == null) {
                                    return -1;
                                }
                                img.fileLength = tempFastboot.length();
                                img.fileName = tempFastboot.getPath();
                            } else {
                                img.fileLength = new File(img.fileName).length();
                                img.fileName = partItem.getFile().getPath();
                            }
                        } else {
                            img.fileLength = new File(img.fileName).length();
                            img.fileName = partItem.getFile().getPath();
                        }
                        if ((img.fileSystem == FileSystem.ext3 || i == 0) && emmcType < 2) {
                            img.fileLength += 512L;
                        }
                    }
                }
                imgList.add(img);
            }
            ++i;
        }
        manuInfo.setImageMaps(imgList);
        ArrayList<UsbManuInfo> manuList = new ArrayList<UsbManuInfo>();
        manuList.add(manuInfo);
        this.header.setManuInfos(manuList);
        int hLength = 0;
        hLength = PackageData.is32BitsSeries() ? 18 : 22;
        int i2 = 0;
        while (i2 < this.header.getManuInfos().size()) {
            if (monitor.isCanceled()) {
                return -1;
            }
            hLength += this.header.getManuInfos().get(i2).getLength(this.burner);
            ++i2;
        }
        int hOffset = this.header.headerLength = hLength;
        int i3 = 0;
        while (i3 < this.header.getManuInfos().size()) {
            if (monitor.isCanceled()) {
                return -1;
            }
            int j = 0;
            while (j < this.header.getManuInfos().get(i3).getImageMaps().size()) {
                UsbImageMap img = this.header.getManuInfos().get(i3).getImageMaps().get(j);
                img.offset = hOffset;
                hOffset = (int)((long)hOffset + (8L + img.fileLength));
                ++j;
            }
            ++i3;
        }
        this.header.fileLength = hOffset;
        return 0;
    }

    protected int writeHeaderBytes(SubMonitor monitor, String filePath) throws IOException {
        block21: {
            PackageData packData = new PackageData(this.header.headerLength);
            packData.writeUint(this.header.magicNum);
            packData.writeUint(0L);
            packData.writeUint(this.header.headerLength);
            if (PackageData.is32BitsSeries()) {
                packData.writeUint(this.header.fileLength);
            } else {
                packData.writeUlong(this.header.fileLength);
            }
            packData.writeUShort(this.header.getManuInfos().size());
            int workCount = 0;
            int i = 0;
            while (i < this.header.getManuInfos().size()) {
                workCount += this.header.getManuInfos().get(i).getImageMaps().size();
                ++i;
            }
            monitor.beginTask(Messages.BurnComposite_Create_Usb_Package_Text, workCount);
            i = 0;
            while (i < this.header.getManuInfos().size()) {
                if (monitor.isCanceled()) {
                    return -1;
                }
                UsbManuInfo manuInfo = this.header.getManuInfos().get(i);
                packData.writeUint(manuInfo.manuId);
                packData.writeUint(manuInfo.hardVersion);
                packData.writeUint(manuInfo.softVersion);
                packData.writeUint(manuInfo.snStart);
                packData.writeUint(manuInfo.snEnd);
                packData.writeUint(manuInfo.downloadType.getCode());
                packData.writeUint(manuInfo.reserved);
                packData.writeUShort(manuInfo.getImageMaps().size());
                int j = 0;
                while (j < manuInfo.getImageMaps().size()) {
                    if (monitor.isCanceled()) {
                        return -1;
                    }
                    UsbImageMap imageMap = manuInfo.getImageMaps().get(j);
                    packData.writeUint(imageMap.fileLength);
                    packData.writeUint(imageMap.offset);
                    if (PackageData.is32BitsSeries()) {
                        packData.writeUint(imageMap.startAddress);
                        packData.writeUint(imageMap.endAddress);
                    } else {
                        packData.writeUlong(imageMap.startAddress);
                        packData.writeUlong(imageMap.endAddress);
                    }
                    if (imageMap.flashType == FlashType.spi) {
                        packData.writeUint(0L);
                    } else if (imageMap.flashType == FlashType.nand) {
                        packData.writeUint(1L);
                    } else {
                        packData.writeUint(2L);
                    }
                    packData.writeUint(imageMap.flashIndex);
                    monitor.worked(1);
                    ++j;
                }
                ++i;
            }
            this.header.headerCrc = CRC32A.calculate(packData.getData());
            packData.writeUint(this.header.headerCrc, 4);
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(filePath);
                    fos.write(packData.getData());
                }
                catch (IOException iOException) {
                    if (fos != null) {
                        fos.close();
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (fos != null) {
                    fos.close();
                }
                throw throwable;
            }
            if (fos != null) {
                fos.close();
            }
        }
        monitor.done();
        return 0;
    }

    protected int writeImageBytes(SubMonitor monitor, String filePath) throws IOException {
        int emmcType = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getEmmcType();
        IPreferenceStore preferences = FastbootPreferences.getPreferenceStore();
        String fillData = preferences.getString("vendor.burn.config.imageFill");
        int workCount = 0;
        int i = 0;
        while (i < this.header.getManuInfos().size()) {
            workCount += this.header.getManuInfos().get(i).getImageMaps().size();
            ++i;
        }
        monitor.beginTask(Messages.BurnComposite_Create_Usb_Package_Text, workCount);
        i = 0;
        while (i < this.header.getManuInfos().size()) {
            if (monitor.isCanceled()) {
                return -1;
            }
            SPartitionTable[] partTables = this.getPartitionTables(this.header.getManuInfos().get(i));
            int extCount = 0;
            int j = 0;
            while (j < this.header.getManuInfos().get(i).getImageMaps().size()) {
                int result;
                boolean needTableData;
                if (monitor.isCanceled()) {
                    return -1;
                }
                UsbImageMap imageMap = this.header.getManuInfos().get(i).getImageMaps().get(j);
                CRC32A crc = new CRC32A();
                crc.start();
                File file = new File(filePath);
                long fileSize = file.length();
                PackageData pd = new PackageData(8);
                pd.writeUint(0L);
                pd.writeUint(0L);
                FileOutputStream fos0 = null;
                try {
                    try {
                        fos0 = new FileOutputStream(filePath, true);
                        fos0.write(pd.getData());
                    }
                    catch (IOException iOException) {
                        try {
                            if (fos0 != null) {
                                fos0.close();
                            }
                        }
                        catch (IOException iOException2) {}
                        return 1;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (fos0 != null) {
                            fos0.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (fos0 != null) {
                        fos0.close();
                    }
                }
                catch (IOException iOException) {}
                boolean bl = needTableData = (imageMap.fileSystem == FileSystem.ext3 || j == 0) && emmcType < 2;
                if (needTableData) {
                    if (partTables == null) {
                        return 1;
                    }
                    byte[] sectorBytes = DataUtils.convertToByte(partTables[extCount].getData());
                    crc.update(sectorBytes);
                    FileOutputStream fos = null;
                    try {
                        try {
                            fos = new FileOutputStream(filePath, true);
                            fos.write(sectorBytes);
                            ++extCount;
                        }
                        catch (IOException iOException) {
                            try {
                                if (fos != null) {
                                    fos.close();
                                }
                            }
                            catch (IOException iOException3) {}
                            return 1;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (fos != null) {
                                fos.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                long fileLen = imageMap.fileLength;
                if (needTableData) {
                    fileLen -= 512L;
                }
                if ((result = this.readImageMapByFile(monitor, filePath, fillData, imageMap, crc, fileLen)) != 0) {
                    return result;
                }
                result = this.writeCrc(monitor, imageMap, crc, file, fileSize);
                if (result != 0) {
                    return result;
                }
                ++j;
            }
            ++i;
        }
        monitor.done();
        return 0;
    }

    private int writeCrc(SubMonitor monitor, UsbImageMap imageMap, CRC32A crc, File file, long fileSize) {
        RandomAccessFile raf = null;
        try {
            try {
                raf = new RandomAccessFile(file, "rw");
                raf.seek(fileSize);
                int crcValue = crc.getValue();
                PackageData pd = new PackageData(8);
                pd.writeUint(imageMap.fileLength);
                pd.writeUint(crcValue);
                raf.write(pd.getData());
                monitor.worked(1);
            }
            catch (IOException iOException) {
                try {
                    if (raf != null) {
                        raf.close();
                    }
                }
                catch (IOException iOException2) {}
                return 1;
            }
        }
        catch (Throwable throwable) {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (raf != null) {
                raf.close();
            }
        }
        catch (IOException iOException) {}
        return 0;
    }

    private int readImageMapByFile(SubMonitor monitor, String filePath, String fillData, UsbImageMap imageMap, CRC32A crc, long fileLen) {
        block46: {
            int partCount;
            int n = partCount = fileLen % 0x400000L == 0L ? (int)(fileLen / 0x400000L) : (int)(fileLen / 0x400000L) + 1;
            if (imageMap.fileName == null) break block46;
            if (imageMap.fileName.equals("tempToEarse")) {
                int k = 0;
                while (k < partCount) {
                    if (monitor.isCanceled()) {
                        return -1;
                    }
                    int partSize = 0;
                    partSize = k == partCount - 1 ? (int)(fileLen - 0x400000L * (long)(partCount - 1)) : 0x400000;
                    byte[] b = new byte[partSize];
                    if (fillData.equals("0xFF")) {
                        b = BytesUtils.genBytesWithFF(partSize);
                    }
                    crc.update(b);
                    FileOutputStream fos = null;
                    try {
                        try {
                            fos = new FileOutputStream(filePath, true);
                            fos.write(b);
                        }
                        catch (IOException iOException) {
                            try {
                                if (fos != null) {
                                    fos.close();
                                }
                            }
                            catch (IOException iOException2) {}
                            return 1;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (fos != null) {
                                fos.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException iOException) {}
                    ++k;
                }
            } else {
                int k = 0;
                while (k < partCount) {
                    if (monitor.isCanceled()) {
                        return -1;
                    }
                    int partSize = 0;
                    partSize = k == partCount - 1 ? (int)(fileLen - 0x400000L * (long)(partCount - 1)) : 0x400000;
                    RandomAccessFile iraf = null;
                    FileOutputStream fos = null;
                    try {
                        try {
                            int read;
                            iraf = new RandomAccessFile(imageMap.fileName, "r");
                            iraf.seek(0x400000L * (long)k);
                            byte[] b = new byte[partSize];
                            if (fillData.equals("0xFF")) {
                                b = BytesUtils.genBytesWithFF(partSize);
                            }
                            if ((read = iraf.read(b)) < 0) {
                                System.out.println("Read Error.");
                            }
                            crc.update(b);
                            fos = new FileOutputStream(filePath, true);
                            fos.write(b);
                        }
                        catch (IOException iOException) {
                            try {
                                if (iraf != null) {
                                    iraf.close();
                                }
                            }
                            catch (IOException iOException3) {}
                            try {
                                if (fos != null) {
                                    fos.close();
                                }
                            }
                            catch (IOException iOException4) {}
                            return 1;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (iraf != null) {
                                iraf.close();
                            }
                        }
                        catch (IOException iOException) {}
                        try {
                            if (fos != null) {
                                fos.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (iraf != null) {
                            iraf.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException iOException) {}
                    ++k;
                }
            }
        }
        return 0;
    }

    public int doPackage(SubMonitor monitor, String outputPath) {
        monitor.beginTask(Messages.BurnComposite_Create_Usb_Package_Text, 10);
        File file = new File(outputPath);
        ArrayList<File> tmpFiles = new ArrayList<File>();
        int argResult = this.loadArguments(monitor, tmpFiles);
        if (argResult != 0) {
            if (file.exists()) {
                boolean bl = file.delete();
            }
            monitor.done();
            return argResult;
        }
        try {
            int writeHeaderResult = this.writeHeaderBytes(SubMonitor.convert((IProgressMonitor)monitor, (String)"", (int)3), outputPath);
            if (writeHeaderResult != 0) {
                if (file.exists()) {
                    FileUtils.deleteFile(file);
                }
                monitor.done();
                return writeHeaderResult;
            }
            int writeImageResult = this.writeImageBytes(SubMonitor.convert((IProgressMonitor)monitor, (String)"", (int)6), outputPath);
            if (writeImageResult != 0) {
                if (file.exists()) {
                    boolean bl = file.delete();
                }
                monitor.done();
                return writeImageResult;
            }
        }
        catch (IOException iOException) {
            return 1;
        }
        for (File f : tmpFiles) {
            if (f.delete()) continue;
            f.deleteOnExit();
        }
        monitor.done();
        return 0;
    }

    protected void fillDataToEmptyPart(String fillData, RandomAccessFile imagefile, long partitionLen) throws IOException {
        int emptyLenCount = (int)((partitionLen + 0x500000L - 1L) / 0x500000L);
        int emptyLenSpace = (int)(partitionLen % 0x500000L);
        if (emptyLenCount == 0) {
            this.checkDataAndWrite(fillData, imagefile, (int)partitionLen);
        } else {
            int j = 0;
            while (j < emptyLenCount) {
                if (j == emptyLenCount - 1) {
                    if (emptyLenSpace == 0) {
                        this.checkDataAndWrite(fillData, imagefile, 0x500000);
                    } else {
                        this.checkDataAndWrite(fillData, imagefile, emptyLenSpace);
                    }
                } else {
                    this.checkDataAndWrite(fillData, imagefile, 0x500000);
                }
                ++j;
            }
        }
    }

    protected void checkDataAndWrite(String fillData, RandomAccessFile imagefile, int len) throws IOException {
        if (fillData.equals("0xFF")) {
            imagefile.write(BytesUtils.genBytesWithFF(len));
        } else if (fillData.equals("0x00")) {
            imagefile.write(BytesUtils.genBytesWithZero(len));
        }
    }
}

