/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.preferences;

import com.vendor.burn.Messages;
import com.vendor.burn.preferences.FastbootPreferences;
import com.vendor.burn.preferences.PreferenceConstants;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CommandSettingPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
PreferenceConstants {
    private String[][] data = new String[][]{{"Auto", "Auto"}, {"ethact 0", "ethact 0"}, {"ethact 1", "ethact 1"}, {"ethact 2", "ethact 2"}, {"ethact 3", "ethact 3"}};
    private String[][] baudRateArray = new String[][]{{"1000K", "1000K"}, {"900K", "900K"}, {"800K", "800K"}, {"700K", "700K"}, {"600K", "600K"}, {"500K", "500K"}, {"400K", "400K"}, {"300K", "300K"}, {"200K", "200K"}, {"115200", "115200"}, {"100K", "100K"}, {"50K", "50K"}};
    private BooleanFieldEditor eraseEditor;
    private BooleanFieldEditor eraseBeforeBurnEditor;
    private BooleanFieldEditor resetBeforeBurnEditor;
    private ComboFieldEditor baudRateEditor;
    private IntegerFieldEditor deviceAddressEditor;
    private IntegerFieldEditor i2cDelayEditor;
    private IntegerFieldEditor writeFlashTimeoutEditor;
    private IntegerFieldEditor i2cCmdRetryCountEditor;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(FastbootPreferences.getPreferenceStore());
    }

    protected void createFieldEditors() {
        final Composite parent = this.getFieldEditorParent();
        parent.setLayout((Layout)new GridLayout(1, false));
        Group serialCommandGroup = new Group(parent, 0);
        serialCommandGroup.setLayout((Layout)new GridLayout(1, false));
        serialCommandGroup.setLayoutData((Object)new GridData(768));
        serialCommandGroup.setText(Messages.Serial_Command);
        IntegerFieldEditor serialCommandTimeoutEditor = new IntegerFieldEditor("vendor.burn.commands.serial_command_timeout", Messages.Serial_Command_Timeout, (Composite)serialCommandGroup);
        serialCommandTimeoutEditor.setValidRange(25, 300);
        this.addField((FieldEditor)serialCommandTimeoutEditor);
        Label serialCommandTips = new Label((Composite)serialCommandGroup, 64);
        serialCommandTips.setText(Messages.Serial_Command_Timeout_Tips);
        GridData lblData = new GridData(4, 128, false, false, 2, 1);
        serialCommandTips.setLayoutData((Object)lblData);
        GridLayout gl = (GridLayout)serialCommandGroup.getLayout();
        gl.verticalSpacing = 10;
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        serialCommandGroup.layout();
        Group writeCommandGroup = new Group(parent, 0);
        writeCommandGroup.setLayout((Layout)new GridLayout(1, false));
        writeCommandGroup.setLayoutData((Object)new GridData(768));
        writeCommandGroup.setText(Messages.Command_Setting);
        IntegerFieldEditor mmcSpeedEditor = new IntegerFieldEditor("vendor.burn.commands.speed.emmc_write", Messages.Mmc_Write_Command_Speed, (Composite)writeCommandGroup);
        mmcSpeedEditor.setValidRange(1, 0x7FFFFFFE);
        this.addField((FieldEditor)mmcSpeedEditor);
        Label lblMmcTips = new Label((Composite)writeCommandGroup, 64);
        lblMmcTips.setText(Messages.Mmc_Write_Command_Setting_Tips);
        lblMmcTips.setLayoutData((Object)lblData);
        writeCommandGroup.layout();
        Group eraseCommandGroup = new Group(parent, 0);
        eraseCommandGroup.setLayout((Layout)new GridLayout(1, false));
        GridData gdData = new GridData(4, 1, true, false);
        eraseCommandGroup.setLayoutData((Object)gdData);
        eraseCommandGroup.setText(Messages.Erase_Command_Setting);
        this.eraseEditor = new BooleanFieldEditor("vendor.burn.config.emmcErase", Messages.CommandSettingPreferencePage_DiskFormatting, (Composite)eraseCommandGroup){

            protected void fireStateChanged(String property, boolean oldValue, boolean newValue) {
                super.fireStateChanged(property, oldValue, newValue);
                if (CommandSettingPreferencePage.this.eraseEditor != null) {
                    CommandSettingPreferencePage.this.eraseEditor.setEnabled(newValue, parent);
                }
            }
        };
        this.addField((FieldEditor)this.eraseEditor);
        GridLayout eraseGL = (GridLayout)eraseCommandGroup.getLayout();
        eraseGL.verticalSpacing = 10;
        eraseGL.marginHeight = 10;
        eraseGL.marginWidth = 10;
        eraseCommandGroup.layout();
        Group eraseCACommandGroup = new Group(parent, 0);
        eraseCACommandGroup.setLayout((Layout)new GridLayout(1, false));
        eraseCACommandGroup.setLayoutData((Object)gdData);
        eraseCACommandGroup.setText(Messages.Erase_BeforeBurn_Command_Setting);
        this.eraseBeforeBurnEditor = new BooleanFieldEditor("vendor.burn.config.emmcErase.beforeBurn", Messages.CommandSettingPreferencePage_EraseCASetting, (Composite)eraseCACommandGroup){

            protected void fireStateChanged(String property, boolean oldValue, boolean newValue) {
                super.fireStateChanged(property, oldValue, newValue);
                if (CommandSettingPreferencePage.this.eraseBeforeBurnEditor != null) {
                    CommandSettingPreferencePage.this.eraseBeforeBurnEditor.setEnabled(newValue, parent);
                }
            }
        };
        this.addField((FieldEditor)this.eraseBeforeBurnEditor);
        GridLayout eraseCAGL = (GridLayout)eraseCACommandGroup.getLayout();
        eraseCAGL.verticalSpacing = 10;
        eraseCAGL.marginHeight = 10;
        eraseCAGL.marginWidth = 10;
        eraseCACommandGroup.layout();
        Group resetCommandGroup = new Group(parent, 0);
        resetCommandGroup.setLayout((Layout)new GridLayout(1, false));
        resetCommandGroup.setLayoutData((Object)gdData);
        resetCommandGroup.setText(Messages.Reset_BeforeBurn_Command_Setting);
        this.resetBeforeBurnEditor = new BooleanFieldEditor("vendor.burn.config.reset.beforeBurn", Messages.CommandSettingPreferencePage_ResetCommandSetting, (Composite)resetCommandGroup){

            protected void fireStateChanged(String property, boolean oldValue, boolean newValue) {
                super.fireStateChanged(property, oldValue, newValue);
                if (CommandSettingPreferencePage.this.resetBeforeBurnEditor != null) {
                    CommandSettingPreferencePage.this.resetBeforeBurnEditor.setEnabled(newValue, parent);
                }
            }
        };
        this.addField((FieldEditor)this.resetBeforeBurnEditor);
        GridLayout resetCommand = new GridLayout();
        if (resetCommand instanceof Layout) {
            resetCommand = (GridLayout)resetCommandGroup.getLayout();
        }
        resetCommand.verticalSpacing = 10;
        resetCommand.marginHeight = 10;
        resetCommand.marginWidth = 10;
        resetCommandGroup.layout();
        Group netCommandGroup = new Group(parent, 0);
        netCommandGroup.setLayout((Layout)new GridLayout(1, false));
        netCommandGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        netCommandGroup.setText(Messages.CommandSettingPreferencePage_NetSelect_Tips);
        RadioGroupFieldEditor ethactField = new RadioGroupFieldEditor("vendor.burn.config.ethact", "", 5, this.data, (Composite)netCommandGroup);
        this.addField((FieldEditor)ethactField);
        gl = (GridLayout)netCommandGroup.getLayout();
        gl.verticalSpacing = 5;
        gl.marginHeight = 5;
        gl.marginWidth = 5;
        netCommandGroup.layout();
        Group i2cCommandGroup = new Group(parent, 0);
        i2cCommandGroup.setLayout((Layout)new GridLayout(2, false));
        i2cCommandGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        i2cCommandGroup.setText(Messages.CommandSettingPreferencePage_I2C_Command_Tips);
        this.baudRateEditor = new ComboFieldEditor("vendor.burn.i2c.baudrate", Messages.CommandSettingPreferencePage_I2C_BaudRate, this.baudRateArray, (Composite)i2cCommandGroup);
        this.addField((FieldEditor)this.baudRateEditor);
        this.deviceAddressEditor = new IntegerFieldEditor("vendor.burn.i2c.deviceAddress", Messages.CommandSettingPreferencePage_I2C_DeviceAddress, (Composite)i2cCommandGroup);
        this.deviceAddressEditor.setValidRange(0, 255);
        this.addField((FieldEditor)this.deviceAddressEditor);
        this.i2cDelayEditor = new IntegerFieldEditor("vendor.burn.i2c.delay", Messages.CommandSettingPreferencePage_I2C_Delay, (Composite)i2cCommandGroup);
        this.i2cDelayEditor.setValidRange(0, 3000);
        this.addField((FieldEditor)this.i2cDelayEditor);
        this.writeFlashTimeoutEditor = new IntegerFieldEditor("vendor.burn.i2c.timeout", Messages.CommandSettingPreferencePage_I2C_Timeout, (Composite)i2cCommandGroup);
        this.writeFlashTimeoutEditor.setValidRange(3000, 120000);
        this.addField((FieldEditor)this.writeFlashTimeoutEditor);
        this.i2cCmdRetryCountEditor = new IntegerFieldEditor("vendor.burn.i2c.retry.count", Messages.CommandSettingPreferencePage_I2C_RetryCount, (Composite)i2cCommandGroup);
        this.i2cCmdRetryCountEditor.setValidRange(10, 50);
        this.addField((FieldEditor)this.i2cCmdRetryCountEditor);
        gl = (GridLayout)i2cCommandGroup.getLayout();
        gl.verticalSpacing = 5;
        gl.marginHeight = 5;
        gl.marginWidth = 5;
        i2cCommandGroup.layout();
    }
}

