/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.preferences;

import com.vendor.burn.model.ProductLine;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import com.vendor.burn.preferences.FastbootPreferences;
import com.vendor.burn.preferences.JTAGPreferencePage;
import com.vendor.burn.preferences.PreferenceConstants;
import com.vendor.burn.utilitily.IPUtils;
import com.vendor.burn.utilitily.ToolUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;

public class FastbootPreferenceInitializer
extends AbstractPreferenceInitializer
implements PreferenceConstants {
    public void initializeDefaultPreferences() {
        IPreferenceStore store = FastbootPreferences.getPreferenceStore();
        store.setDefault("vendor.burn.console.out.debug", false);
        store.setDefault("vendor.burn.update.bootrags", false);
        store.setDefault("vendor.burn.check.network", true);
        store.setDefault("vendor.burn.dialogs.on", true);
        store.setDefault("vendor.burn.usb.split.fileSize", 32);
        store.setDefault("vendor.burn.config.client.mac", IPUtils.generatorMAC());
        store.setDefault("vendor.burn.config.client.gateway", "0.0.0.0");
        store.setDefault("vendor.burn.config.client.ip", "0.0.0.0");
        store.setDefault("vendor.burn.config.client.netmask", "0.0.0.0");
        store.setDefault("vendor.burn.dialogs.on", true);
        store.setDefault("vendor.burn.tftp.losingpackage.count", 15);
        store.setDefault("vendor.burn.tftp.windowSize.blockCount", 3);
        store.setDefault("vendor.burn.tftp.losingpackage.enable", true);
        store.setDefault("vendor.burn.tftp.timeout.noresponse", 10);
        int splitFileSize = 32;
        ProductLine.PRODUCTLINE chipType = ToolUtils.getProductLine();
        if (chipType != null && chipType != ProductLine.PRODUCTLINE.CAM) {
            splitFileSize = 128;
        }
        store.setDefault("vendor.burn.tftp.split.fileSize", splitFileSize);
        store.setDefault("vendor.burn.tftp.retry.count", 5);
        store.setDefault("vendor.burn.tftp.speed", 1024);
        store.setDefault("vendor.burn.tftp.port", 69);
        String ChinName = ToolUtils.getChipName();
        UnknownDevice properties = new UnknownDevice(ChinName);
        String boardType = properties.queryForString("TYPE");
        if (boardType != null && boardType.equalsIgnoreCase("TV")) {
            store.setDefault("vendor.burn.commands.speed.emmc_write", 1024);
        } else {
            store.setDefault("vendor.burn.commands.speed.emmc_write", 3072);
        }
        store.setDefault("vendor.burn.commands.serial_command_timeout", 40);
        store.setDefault("vendor.burn.i2c.baudrate", "900K");
        store.setDefault("vendor.burn.i2c.deviceAddress", 56);
        store.setDefault("vendor.burn.i2c.delay", 50);
        store.setDefault("vendor.burn.i2c.timeout", 60000);
        store.setDefault("vendor.burn.jtag.small.borad.model", JTAGPreferencePage.getJtagSmallModelTypeList()[0][0]);
        store.setDefault("vendor.burn.i2c.retry.count", 30);
        String os = Platform.getOS();
        if ("win32".equals(os)) {
            store.setDefault("vendor.burn.config.serial", "COM1");
        } else if ("linux".equals(os)) {
            store.setDefault("vendor.burn.config.serial", "/dev/ttyS0");
        }
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"vendor.burn.console.out.rgb.default", (RGB)RGB_DEFAULT);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"vendor.burn.console.out.rgb.info", (RGB)RGB_INFO);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"vendor.burn.console.out.rgb.received", (RGB)RGB_RECEIVED);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"vendor.burn.console.out.rgb.warning", (RGB)RGB_WARNING);
        store.setDefault("vendor.burn.config.imageFill.nand.pinSaveMode", true);
        store.setDefault("vendor.burn.tftp.crc.check", true);
        store.setDefault("vendor.burn.tftp.windowSize.open", true);
        store.setDefault("vendor.burn.config.imageFill", "0x00");
        store.setDefault("vendor.burn.config.ethact", "Auto");
        store.setDefault("vendor.burn.config.emmcErase", false);
        store.setDefault("vendor.burn.config.emmcErase.beforeBurn", false);
    }
}

