/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.preferences;

import com.vendor.burn.Activator;
import com.vendor.burn.preferences.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public final class FastbootPreferences
implements PreferenceConstants {
    public static final String ID = "com.vendor.burn.preferences.FastbootPreferencePage";
    public static final int MBYTE_SIZE_1 = 0x100000;

    public static boolean getBoolean(String key) {
        return FastbootPreferences.getPreferenceStore().getBoolean(key);
    }

    public static RGB getConsoleOutDefault() {
        return (RGB)FastbootPreferences.getValue(RGB.class, "vendor.burn.console.out.rgb.default");
    }

    public static RGB getConsoleOutReceived() {
        return (RGB)FastbootPreferences.getValue(RGB.class, "vendor.burn.console.out.rgb.received");
    }

    public static RGB getConsoleOutWarning() {
        return (RGB)FastbootPreferences.getValue(RGB.class, "vendor.burn.console.out.rgb.warning");
    }

    public static RGB getConsoleOutInfo() {
        return (RGB)FastbootPreferences.getValue(RGB.class, "vendor.burn.console.out.rgb.info");
    }

    public static long getUsbSpliteFileSize() {
        return FastbootPreferences.getInt("vendor.burn.usb.split.fileSize") * 0x100000;
    }

    public static String getBaudRate() {
        return (String)FastbootPreferences.getValue(String.class, "vendor.burn.i2c.baudrate");
    }

    public static int getDeviceAddress() {
        return FastbootPreferences.getInt("vendor.burn.i2c.deviceAddress");
    }

    public static int getI2cDelay() {
        return FastbootPreferences.getInt("vendor.burn.i2c.delay");
    }

    public static int getI2cTimeout() {
        return FastbootPreferences.getInt("vendor.burn.i2c.timeout");
    }

    public static String getJtagSmallBoradModel() {
        return (String)FastbootPreferences.getValue(String.class, "vendor.burn.jtag.small.borad.model");
    }

    public static int getI2cRetryCount() {
        return FastbootPreferences.getInt("vendor.burn.i2c.retry.count");
    }

    public static boolean isDialogOn() {
        return FastbootPreferences.getBoolean("vendor.burn.dialogs.on");
    }

    public static boolean isDebugOn() {
        return FastbootPreferences.getBoolean("vendor.burn.console.out.debug");
    }

    public static boolean isUpdateBootargsOn() {
        return FastbootPreferences.getBoolean("vendor.burn.update.bootrags");
    }

    public static boolean isCheckSameNetWork() {
        return FastbootPreferences.getBoolean("vendor.burn.check.network");
    }

    public static boolean isDiskFormatting() {
        return FastbootPreferences.getBoolean("vendor.burn.config.emmcErase");
    }

    public static boolean isEmmcEraseBeforeBurn() {
        return FastbootPreferences.getBoolean("vendor.burn.config.emmcErase.beforeBurn");
    }

    public static boolean isResetBeforeBurn() {
        return FastbootPreferences.getBoolean("vendor.burn.config.reset.beforeBurn");
    }

    public static boolean isNandPinSaveMpde() {
        return FastbootPreferences.getBoolean("vendor.burn.config.imageFill.nand.pinSaveMode");
    }

    public static boolean isOpenTftpCrcCheck() {
        return FastbootPreferences.getBoolean("vendor.burn.tftp.crc.check");
    }

    public static boolean isOpenTftpWindowSize() {
        return FastbootPreferences.getBoolean("vendor.burn.tftp.windowSize.open");
    }

    public static boolean isTftpIgnoreBlockAck() {
        return FastbootPreferences.getBoolean("vendor.burn.tftp.losingpackage.enable");
    }

    public static IPreferenceStore getPreferenceStore() {
        Activator default1 = Activator.getDefault();
        if (default1 == null) {
            return null;
        }
        return default1.getPreferenceStore();
    }

    public static Object getValue(Class<?> type, String name) {
        if (type == null) {
            return null;
        }
        IPreferenceStore preferences = FastbootPreferences.getPreferenceStore();
        if (!preferences.contains(name)) {
            return null;
        }
        if (Integer.class == type || Integer.TYPE == type) {
            return preferences.getInt(name);
        }
        if (Boolean.class == type || Boolean.TYPE == type) {
            return preferences.getBoolean(name);
        }
        if (Double.class == type || Double.TYPE == type) {
            return preferences.getDouble(name);
        }
        if (Float.class == type || Float.TYPE == type) {
            return Float.valueOf(preferences.getFloat(name));
        }
        if (Long.class == type || Long.TYPE == type) {
            return preferences.getLong(name);
        }
        if (String.class == type) {
            return preferences.getString(name);
        }
        if (RGB.class == type) {
            return PreferenceConverter.getColor((IPreferenceStore)preferences, (String)name);
        }
        if (FontData.class == type) {
            return PreferenceConverter.getFontData((IPreferenceStore)preferences, (String)name);
        }
        if (Point.class == type) {
            return PreferenceConverter.getPoint((IPreferenceStore)preferences, (String)name);
        }
        if (Rectangle.class == type) {
            return PreferenceConverter.getRectangle((IPreferenceStore)preferences, (String)name);
        }
        return null;
    }

    public static int getInt(String key) {
        return FastbootPreferences.getPreferenceStore().getInt(key);
    }

    public static class CONFIG {
        public static String getServerIP() {
            return FastbootPreferences.getPreferenceStore().getString("vendor.burn.config.serverip");
        }

        public static String getSerial() {
            return FastbootPreferences.getPreferenceStore().getString("vendor.burn.config.serial");
        }

        public static String getClientIP() {
            return FastbootPreferences.getPreferenceStore().getString("vendor.burn.config.client.ip");
        }

        public static String getClientNetmask() {
            return FastbootPreferences.getPreferenceStore().getString("vendor.burn.config.client.netmask");
        }

        public static String getClientGateway() {
            return FastbootPreferences.getPreferenceStore().getString("vendor.burn.config.client.gateway");
        }

        public static String getClientMac() {
            return FastbootPreferences.getPreferenceStore().getString("vendor.burn.config.client.mac");
        }

        public static String getClientWholeConfig() {
            return FastbootPreferences.getPreferenceStore().getString("vendor.burn.config.client.wholeConfig");
        }

        public static String getImageFillConfig() {
            return FastbootPreferences.getPreferenceStore().getString("vendor.burn.config.imageFill");
        }

        public static String getNetEthactConfig() {
            return FastbootPreferences.getPreferenceStore().getString("vendor.burn.config.ethact");
        }

        public static void setServerIP(String value) {
            FastbootPreferences.getPreferenceStore().setValue("vendor.burn.config.serverip", value);
        }

        public static void setSerial(String value) {
            FastbootPreferences.getPreferenceStore().setValue("vendor.burn.config.serial", value);
        }

        public static void setClientIP(String value) {
            FastbootPreferences.getPreferenceStore().setValue("vendor.burn.config.client.ip", value);
        }

        public static void setClientNetmask(String value) {
            FastbootPreferences.getPreferenceStore().setValue("vendor.burn.config.client.netmask", value);
        }

        public static void setClientGateway(String value) {
            FastbootPreferences.getPreferenceStore().setValue("vendor.burn.config.client.gateway", value);
        }

        public static void setClientMac(String value) {
            FastbootPreferences.getPreferenceStore().setValue("vendor.burn.config.client.mac", value);
        }

        public static void setClientWholeConfig(String value) {
            FastbootPreferences.getPreferenceStore().setValue("vendor.burn.config.client.wholeConfig", value);
        }

        public static void setImageFillConfig(String value) {
            FastbootPreferences.getPreferenceStore().setValue("vendor.burn.config.imageFill", value);
        }

        public static void setNetEthactConfig(String value) {
            FastbootPreferences.getPreferenceStore().setValue("vendor.burn.config.ethact", value);
        }
    }
}

