/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.serial.workers;

import com.vendor.burn.Activator;
import com.vendor.burn.Messages;
import com.vendor.burn.commands.I2cCommand;
import com.vendor.burn.commands.INFOCommand;
import com.vendor.burn.commands.SFCommand;
import com.vendor.burn.commands.SerialCommand;
import com.vendor.burn.commands.TFTPCommand;
import com.vendor.burn.jna.LibJTAGByJNA;
import com.vendor.burn.log.Log;
import com.vendor.burn.model.BoardConfig;
import com.vendor.burn.model.FileInfo;
import com.vendor.burn.model.FileSystem;
import com.vendor.burn.model.FlashType;
import com.vendor.burn.model.LocalConfig;
import com.vendor.burn.model.PartitionItem;
import com.vendor.burn.model.PlatformType;
import com.vendor.burn.model.ProductLine;
import com.vendor.burn.model.TransferWay;
import com.vendor.burn.model.config.BurnConfig;
import com.vendor.burn.model.config.PreferenceConfig;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.define.IFastbootProgressMonitor;
import com.vendor.burn.model.devices.IFrameSetting;
import com.vendor.burn.model.devices.burners.AbstractBurner;
import com.vendor.burn.model.devices.burners.CommonBurner;
import com.vendor.burn.model.devices.unknown.UDFrameSetting;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import com.vendor.burn.model.event.FastbootEvent;
import com.vendor.burn.model.receive.ReceiveTimeOutException;
import com.vendor.burn.preferences.FastbootPreferences;
import com.vendor.burn.serial.workers.CallLibBootromWorker;
import com.vendor.burn.serial.workers.CallLibJTAGWorker;
import com.vendor.burn.serial.workers.CallLibUSBWorker;
import com.vendor.burn.serial.workers.IBurnerWorker;
import com.vendor.burn.serial.workers.PartitionBurnerWorker;
import com.vendor.burn.serial.workers.SerialPort;
import com.vendor.burn.serial.workers.WorkerUtility;
import com.vendor.burn.utilitily.DataUtils;
import com.vendor.burn.utilitily.FileUtils;
import com.vendor.burn.utilitily.PropertiesUtility;
import com.vendor.burn.utilitily.ToolUtils;
import com.vendor.burn.views.FastbootView;
import com.vendor.burn.views.LightView;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TooManyListenersException;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.vendor.tftp.tool.TFTPService;

public abstract class AbstractBurnerWorker
extends WorkerUtility
implements IBurnerWorker {
    protected static final String BOOT_INFO = "     ";
    protected static final String BOOT_INFO_CJ109V100 = "          ";
    protected static final String BOOT_INFO_GSL_CJ109V100 = String.valueOf(new char[]{'\u001f', '\u001f', '\u001f', '\u001f', '\u001f'});
    protected static final String CHIP_NAME_CJ109V100 = "CJ109V100";
    protected static final String msg_BootFileNotFound = "Boot file not found!";
    protected static final String msg_FailedToReadBootFile = "Failed to read boot file!";
    protected static final String msg_TimeoutWhileReceiveCommandExecuteResult = Messages.ERROR_INFO_EXECUTE_COMMAND_TIME_OUT;
    private static final String GET_LAST_LENGTH = "Please enter the entire device length(K/M):";
    protected static final String msg_ResendCommand = "Resend command...";
    protected static final String msg_SendCommand = "Send command";
    protected static final String msg_UserCancelled = "User Cancelled!";
    protected static final String FASTBOOT_NO_CURRENT_START = "*** Not upport current start mode";
    protected static final String FASTBOOT_REG_NAME = "Reg Name:";
    protected static final String FASTBOOT_NO_NAND_FLASH = "No NAND device found!!!";
    protected static final String FASTBOOT_NO_EMMC_FLASH = "No MMC/SD card detect when read `SDIO_CARD_DETECT` pin.";
    protected static final String FASTBOOT_START_OVER = "SDK Version:";
    protected static final String FASTBOOT_HAVE_SPI_FLASH = "Check spi flash controller v350. found";
    protected static final String FASTBOOT_HAVE_NAND_FLASH_MFCV100 = "NAND Check Flash Memory Controller v100 ... Found";
    protected static final String FASTBOOT_HAVE_NAND_FLASH_OTHER = "Check nand flash controller";
    protected static final String FASTBOOT_HAVE_EMMC_FLASH = "MMC/SD Card:";
    protected static final int HEX = 16;
    protected static final int FILE_BLOCK_SIZE_32 = 0x2000000;
    protected static final int FILE_BLOCK_SIZE_128 = 0x8000000;
    protected static final int EMMC_BLOCKSZIE = 512;
    protected static final int CJXX0VXX5_BLOCKSZIE = 4096;
    protected static final int SEPARATE_CHUNKLEN = 0x500000;
    protected static final int SERIAL_MAX_BUFFER_SIZE = 10240;
    protected static final String DDRTRINING_SWL = "SWL";
    protected static final String DDRTRINING_SGA = "SGA";
    protected static final String DDRTRINING_HGA = "HGA";
    protected static final String DDRTRINING_HRD = "HRD";
    protected static final String DDRTRINING_SRD = "SRD";
    protected static final String DDRTRINING_SWD = "SWD";
    protected static final String DDRTRINING_DDR_FAILED = "DDR training failed";
    protected static final String BOOTROM_START = "Bootrom start";
    protected static final String BOOTROM_FROM_NAND = "Boot from NAND";
    protected static final String BOOTROM_FROM_EMMC = "Boot from eMMC";
    protected static final String BOOTROM_FROM_SD = "Boot from SD";
    protected static final String BOOTROM_READ_EMMC_ERROR = "Read eMMC error";
    protected static final String BOOTROM_READ_SD_ERROR = "Read SD error";
    protected static final String BOOTROM_MEDIA_SPI = "Boot Media: SPI";
    protected static final String BOOTROM_MEDIA_NAND = "Boot Media: NAND";
    protected static final String BOOTROM_MEDIA_SD = "Boot Media: SD";
    protected static final String BOOTROM_MEDIA_EMMC = "Boot Media: EMMC";
    protected static final String EMMC_INIT_ERR = "eMMC init error";
    protected static final String EMMC_READ_ERR = "eMMC read error";
    protected static final String EMMC_NORMAL_READ_ERR = "eMMC normal read error";
    protected static final String SD_INIT_ERR = "SD init error";
    protected static final String SD_READ_ERR = "SD read error";
    protected static final String SD_NORMAL_READ_ERR = "SD normal read error";
    protected static final String HEAD_AREA_FORMAT_ERR = "Head area format error";
    protected static final String VERIFY_KEY_AREA_FAILED = "Verify Key Area failed";
    protected static final String AUX_AREA_FORMAT_ERR = "Auxiliary area format error";
    protected static final String VERIFY_AUX_CODE_FAILED = "Verify Auxiliary Code failed";
    protected static final String VERIFY_AUX_AREA_FAILED = "Verify Auxiliary Area failed";
    protected static final String VERIFY_PARAM_AREA_FAILED = "Verify Param Area failed";
    protected static final String PARAM_LEN_ERR = "Param length error";
    protected static final String AUX_CODE_EXEC_FAILED = "Auxiliary code execution failed";
    protected static final String DDR_DDRE = "DDRE";
    protected static final String DDR_DDRTR = "DDRTR";
    protected static final String DDR_Err = "Err";
    protected static final String DDR_WL_ERR = "WL Err";
    protected static final String DDR_HWG_ERR = "HWG Err";
    protected static final String DDR_GATE_ERR = "Gate Err";
    protected static final String DDR_DDRT_ERR = "DDRT Err";
    protected static final String DDR_HWRD_ERR = "HWRD Err";
    protected static final String DDR_MPR_ERR = "MPR Err";
    protected static final String DDR_DATAEYE_ERR = "Dataeye Err";
    protected static final String FASTBOOT_START = "System startup";
    protected static final String REALLY_SCRUB = "Really scrub this NAND flash?";
    protected static final Map<String, Integer> lightCurrentStateMap = new HashMap<String, Integer>();
    protected static StringBuilder serialRecvBuf = new StringBuilder();
    private static LightView lightView = null;
    protected long spiBlockSize = 0L;
    protected long nandBlockSize = 0L;
    protected long pageSize = 0L;
    protected static final String BASE_SIZE = "size:";
    protected static final String SERIAL_LOG_FILE = "logs/burntool/serial_usb.log";
    protected static final String BASE_ADDR = "baseaddr:";
    protected static final long GSL_ADDRESS_TAG_VALUE = 510228540L;
    protected static final int GSL_TAG = 6144;
    protected static final int GSL_ADDRESS = 67242496;
    protected static final int GSL_LENGTH = 15360;
    protected static final int GSL_START_POSITION = 65536;
    protected String strNandInfo = "";
    protected boolean isCaChipByLibBootrom = true;
    private static IViewPart view = null;
    private static InputStream SOCKET_IN;
    private static OutputStream SOCKET_OUT;
    protected static SerialPort serialPort;
    private static Socket socket;
    private static final byte[] BREAK;
    public static final int LOOP = 1000;
    protected static final int TIME_FRAME_DATA = 500;
    protected static final int TIME_WAIT_FASTBOOT_INFO = 500;
    protected static final int TIMEOUT_PING = 5000;
    static int TIMEOUT_SEND_FRAME;
    static int TIMEOUT_SEND_FRAME_BOARD;
    private long lastLen = 0L;
    protected static String fastbootFromFlash;
    protected IFrameSetting frameSetting;
    protected static IFastbootProgressMonitor monitor;
    protected IProgressMonitor uimonitor;
    protected IBurner burner;
    protected static final StringBuilder serialReceived;
    protected static final ArrayList<String> usbSerialReceived;
    protected static final int SERIAL_RECEIVED_LENGTH = 4096;
    protected static final int UDP_RECEIVED_LENGTH = 1024;
    protected static final StringBuilder i2csReceived;
    protected static final StringBuilder usbsReceived;
    protected static StringBuilder udpReceived;
    protected static final StringBuilder jtagReceived;
    protected static final String NEW_LINE = "\n";
    protected FileInfo[] fileList;
    protected int RETY_TIMES = 5;
    protected int receiveTimeout = 5000;
    private FlashType flashType;

    static {
        BREAK = new byte[]{3};
        TIMEOUT_SEND_FRAME = 10000;
        TIMEOUT_SEND_FRAME_BOARD = 15000;
        serialReceived = new StringBuilder();
        usbSerialReceived = new ArrayList();
        i2csReceived = new StringBuilder();
        usbsReceived = new StringBuilder();
        udpReceived = new StringBuilder();
        jtagReceived = new StringBuilder();
    }

    public static int getTimeFrameCommand() {
        if (ToolUtils.isCmdLine()) {
            String timeout = PropertiesUtility.queryForString("serialCommandTimeout");
            if (timeout == null) {
                Log.errorln(Messages.MESSAGE_SERIAL_COMMAND_TIMEOUT_IS_NULL);
                System.exit(-1);
                return -1;
            }
            return Integer.valueOf(timeout);
        }
        return FastbootPreferences.getInt("vendor.burn.commands.serial_command_timeout");
    }

    public static int getTimeFrameHead() {
        if (ToolUtils.isCmdLine()) {
            String timeout = PropertiesUtility.queryForString("serialCommandTimeout");
            if (timeout == null) {
                Log.errorln(Messages.MESSAGE_SERIAL_COMMAND_TIMEOUT_IS_NULL);
                System.exit(-1);
                return -1;
            }
            return Integer.valueOf(timeout);
        }
        return FastbootPreferences.getInt("vendor.burn.commands.serial_command_timeout");
    }

    public static void setReceived(String printInfo) {
        serialReceived.append(printInfo);
    }

    public AbstractBurnerWorker(IFrameSetting frameSetting) {
        this.frameSetting = frameSetting;
        if (UnknownDevice.isOpenLightDebug() && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(LightView.ID) != null) {
            AbstractBurnerWorker.setView(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(LightView.ID));
            if (view != null) {
                AbstractBurnerWorker.setLightView((LightView)view);
            }
        }
    }

    protected static String getBootFrom(String received) {
        String KEY = "Boot Media: ";
        int startIndex = received.indexOf(KEY);
        if (-1 == startIndex) {
            return null;
        }
        int endIndex = received.indexOf("\r\n", startIndex += KEY.length());
        if (-1 == endIndex) {
            return null;
        }
        String strCapacity = received.substring(startIndex, endIndex);
        return strCapacity.trim();
    }

    protected String getVersionInfo(String operation) {
        StringBuffer buffer = new StringBuffer(NEW_LINE);
        IProduct product = Platform.getProduct();
        if (product != null) {
            String platformVersion = product.getDefiningBundle().getVersion().toString();
            String burnVersion = Activator.getDefault().getBundle().getVersion().toString();
            buffer.append("Platform Version: " + platformVersion).append(NEW_LINE);
            buffer.append("BurnTool Version: " + burnVersion.substring(0, burnVersion.lastIndexOf("."))).append(NEW_LINE);
            String osName = System.getProperties().getProperty("os.name");
            buffer.append("OS Name: ").append(osName).append(NEW_LINE);
            String osArch = System.getProperty("os.arch");
            buffer.append("OS Arch: ").append(osArch).append(NEW_LINE);
            String osVersion = System.getProperty("os.version").toLowerCase(Locale.US);
            buffer.append("OS Version: ").append(osVersion).append(NEW_LINE);
            buffer.append("Operation: ").append(operation).append(NEW_LINE);
            buffer.append("ChipName: ").append(this.burner.getBurnContext().getDeviceSetting().getName()).append(NEW_LINE);
            TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
            buffer.append("TransferWay: ").append(transferWay.toString()).append(NEW_LINE);
            if (transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndNet || transferWay == TransferWay.JTAGAndSerial) {
                int jtagFrequency = this.burner.getBurnContext().getJtagFrequency();
                buffer.append("JtagFrequency: ").append(jtagFrequency).append(NEW_LINE);
            }
        }
        return buffer.toString();
    }

    protected String getHexStartAddress() {
        if (((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) {
            if (((UDFrameSetting)this.frameSetting).getDdrInitAddrByLibBootrom() == 0L) {
                return Integer.toHexString(this.frameSetting.getThirdFileAddress());
            }
            return Long.toHexString(((UDFrameSetting)this.frameSetting).getDdrInitAddrByLibBootrom());
        }
        return Integer.toHexString(this.frameSetting.getThirdFileAddress());
    }

    protected int getHexStartAddressForInt() {
        if (((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) {
            if (((UDFrameSetting)this.frameSetting).getDdrInitAddrByLibBootrom() == 0L) {
                return this.frameSetting.getThirdFileAddress();
            }
            return (int)((UDFrameSetting)this.frameSetting).getDdrInitAddrByLibBootrom();
        }
        return this.frameSetting.getThirdFileAddress();
    }

    @Override
    public SerialPort createConnection(String portName) throws IOException, TooManyListenersException {
        boolean needInfoSerial;
        SerialPort currentSerialPort = new SerialPort();
        boolean isOpen = currentSerialPort.openPort(portName);
        if (!isOpen) {
            AbstractBurnerWorker.returnError(NLS.bind((String)Messages.PartitionBurner_msg_start_serial_failed_on_port, (Object)portName));
            return null;
        }
        AbstractBurnerWorker.setSerialPort(currentSerialPort);
        boolean bl = needInfoSerial = !((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom() && !((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportJTAGAndNet() && !((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportJTAG();
        if (needInfoSerial) {
            this.infoln(this.getStartMessage());
        }
        return currentSerialPort;
    }

    public static void returnError(String error) {
        if (monitor == null) {
            return;
        }
        FastbootEvent event = monitor.getEvent();
        if (event == null || event.isUserCanceled()) {
            return;
        }
        AbstractBurnerWorker.warningln(error);
        String message = event.getMessage();
        message = message != null ? String.valueOf(message) + NEW_LINE + error : error;
        event.setSuccess(false);
        event.setMessage(message);
    }

    protected String getStartMessage() {
        if (!ToolUtils.isCmdLine() && FastbootPreferences.isResetBeforeBurn()) {
            return NEW_LINE + Messages.ERROR_INFO_To_Send_ResetAndReboot_Frame;
        }
        return NEW_LINE + Messages.ERROR_INFO_Start_PowerOn;
    }

    @Override
    public boolean close() {
        if (serialPort != null) {
            serialPort.closePort();
            serialPort = null;
        }
        if (SOCKET_IN != null) {
            try {
                SOCKET_IN.close();
            }
            catch (IOException iOException) {}
        }
        if (SOCKET_OUT != null) {
            try {
                SOCKET_OUT.close();
            }
            catch (IOException iOException) {}
        }
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    @Override
    public boolean burn(IBurner bunner, LocalConfig localConfig, BoardConfig boardConfig) {
        return true;
    }

    @Override
    public void setProgressMonitor(IFastbootProgressMonitor monitor) {
        AbstractBurnerWorker.setMonitor(monitor);
    }

    public void setProgressMonitor(IProgressMonitor uimonitor) {
        this.uimonitor = uimonitor;
    }

    public IProgressMonitor getUimonitor() {
        return this.uimonitor;
    }

    public SerialPort getSerialPort() {
        return serialPort;
    }

    public static void setSerialPort(SerialPort port) {
        serialPort = port;
    }

    protected void prepareFile() {
        this.fileList = this.frameSetting.prepareFile();
    }

    public void sendBreak() throws IOException {
        this.sendBytes(BREAK);
    }

    public boolean sendTailFrame(int seq) {
        if (this.burner.getBurnContext().getTransferWay() == TransferWay.USBBootrom || this.burner.getBurnContext().getTransferWay() == TransferWay.USBNonNude) {
            return this.sendUSBTailFrame(seq);
        }
        int[] buffer = new int[5];
        int crc = 0;
        buffer[0] = 237;
        buffer[1] = seq & 0xFF;
        buffer[2] = ~seq & 0xFF;
        crc = AbstractBurnerWorker.calc_crc16(buffer, 3, 1);
        buffer[3] = crc >> 8 & 0xFF;
        buffer[4] = crc & 0xFF;
        try {
            boolean sendFrame;
            byte[] convertToByte = this.convertToByte(buffer);
            if (ToolUtils.isDebugOn()) {
                this.println("To send tail frame, send timeout=" + TIMEOUT_SEND_FRAME / 1000 + "s, wait response timeout=" + 500 + "ms data is :");
                this.outputHex(convertToByte);
            }
            int timeout = TIMEOUT_SEND_FRAME;
            if (FastbootView.isCJXX1Series()) {
                timeout = 200;
            }
            if (!(sendFrame = this.sendFrame(convertToByte, timeout, 500L)) && ToolUtils.isDebugOn()) {
                this.println("Failed to send tail Frame");
            }
            return sendFrame;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean sendUSBTailFrame(int seq) {
        int[] buffer = new int[]{237};
        try {
            byte[] convertToByte = this.convertToByte(buffer);
            boolean sendFrame = this.sendFrame(convertToByte, TIMEOUT_SEND_FRAME, 500L);
            if (!sendFrame && ToolUtils.isDebugOn()) {
                this.println("Failed to send tail Frame");
            }
            return sendFrame;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected byte[] convertToByte(int[] buffer) {
        byte[] bytes = new byte[buffer.length];
        int i = 0;
        while (i < buffer.length) {
            bytes[i] = (byte)(buffer[i] & 0xFF);
            ++i;
        }
        return bytes;
    }

    protected void print(String message) {
        if (monitor != null) {
            monitor.print(message);
        } else {
            System.out.print(message);
        }
        AbstractBurnerWorker.log(message);
    }

    private static void log(String str) {
        if (monitor != null) {
            monitor.log(str);
        }
    }

    public void println(String message) {
        if (ToolUtils.isDebugOn()) {
            this.print(String.valueOf(message) + NEW_LINE);
        }
    }

    protected static void receivedln(String received) {
        AbstractBurnerWorker.received(String.valueOf(received) + NEW_LINE);
    }

    protected static void received(String received) {
        if (monitor != null) {
            monitor.error(received);
            monitor.log(received);
        } else {
            System.err.print(received);
        }
    }

    protected void receivDebugInfo(String received) {
        if (monitor != null) {
            monitor.println(received);
        } else {
            System.out.print(received);
        }
    }

    protected static void warning(String warning) {
        if (monitor != null) {
            monitor.warn(warning);
        } else {
            System.out.print(warning);
        }
        AbstractBurnerWorker.log(warning);
    }

    public static void warningln(String warning) {
        AbstractBurnerWorker.warning(String.valueOf(warning) + NEW_LINE);
    }

    protected void info(String info) {
        if (monitor != null) {
            monitor.info(info);
        } else {
            System.out.print(info);
        }
        AbstractBurnerWorker.log(info);
    }

    public void infoln(String info) {
        if (info == null) {
            return;
        }
        this.info(String.valueOf(info) + NEW_LINE);
    }

    public boolean sendFrameForStart(byte[] data, long timeout, long frameTimeout) throws IOException {
        boolean isUSB;
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        boolean bl = isUSB = transferWay == TransferWay.USBBootrom || transferWay == TransferWay.USBNonNude;
        if (transferWay == TransferWay.I2CBootrom) {
            return this.sendI2cFrame(data, timeout, frameTimeout);
        }
        if (isUSB) {
            return this.sendUsbFrame(data, timeout, frameTimeout, transferWay);
        }
        StringBuilder temp = new StringBuilder();
        long startTime = System.currentTimeMillis();
        String hexdata = null;
        int sendCount = 0;
        while (System.currentTimeMillis() - startTime < timeout) {
            boolean handleCancel;
            if (this.uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
                return false;
            }
            if (this.getSerialPort() != null) {
                this.onAdataAvailable(serialReceived);
            }
            if (temp != null && temp.length() > 0) {
                this.onAdataAvailable(serialReceived);
                serialReceived.append((CharSequence)temp);
            }
            AbstractBurnerWorker.deleteContent(temp);
            if (this.sendBytes(data) != data.length) {
                return false;
            }
            if (ToolUtils.isDebugOn()) {
                this.println("sendBytes" + ++sendCount + ": To send command frame, send timeout=" + TIMEOUT_SEND_FRAME / 1000 + "s, wait response timeout=" + AbstractBurnerWorker.getTimeFrameCommand() + "ms data is :");
                this.outputHex(data);
            }
            boolean recieving = true;
            long fTime = System.currentTimeMillis();
            block5: while (recieving && !this.uimonitor.isCanceled()) {
                int receiveBytes;
                if (System.currentTimeMillis() - fTime > frameTimeout) {
                    recieving = false;
                }
                if ((receiveBytes = this.receiveBySerialOrSocket(temp)) != 1 || temp.length() <= 0) continue;
                char charAt = temp.charAt(0);
                if (ToolUtils.isDebugOn()) {
                    String hexString = Integer.toHexString(0xFF & charAt);
                    this.println("Returned:" + hexString);
                }
                switch (charAt & 0xFF) {
                    case 170: {
                        temp.deleteCharAt(0);
                        return true;
                    }
                    case 85: {
                        this.onAdataAvailable(temp);
                        hexdata = this.getHexdata(temp);
                        if (hexdata != null && hexdata.length() > 0) {
                            this.println("NAK Returned:" + hexdata);
                        }
                        temp.deleteCharAt(0);
                        recieving = false;
                        if (!UnknownDevice.isOpenLightDebug()) continue block5;
                        AbstractBurnerWorker.updateSerialLightToError();
                        break;
                    }
                    default: {
                        if (temp.length() <= 0) continue block5;
                        temp.deleteCharAt(0);
                        serialRecvBuf.append(charAt);
                        fTime = System.currentTimeMillis();
                    }
                }
            }
        }
        return false;
    }

    public boolean sendFrame(byte[] data, long timeout, long frameTimeout) throws IOException {
        boolean isI2C;
        boolean isUSB = this.burner.getBurnContext().getTransferWay() == TransferWay.USBBootrom || this.burner.getBurnContext().getTransferWay() == TransferWay.USBNonNude;
        boolean bl = isI2C = this.burner.getBurnContext().getTransferWay() == TransferWay.I2CBootrom || this.burner.getBurnContext().getTransferWay() == TransferWay.Usb2I2c;
        if (isI2C) {
            return this.sendI2cFrame(data, timeout, frameTimeout);
        }
        if (isUSB) {
            return this.sendUsbFrame(data, timeout, frameTimeout, this.burner.getBurnContext().getTransferWay());
        }
        return this.sendOtherFrame(data, timeout, frameTimeout);
    }

    private boolean sendOtherFrame(byte[] data, long timeout, long frameTimeout) throws IOException {
        StringBuilder temp = new StringBuilder();
        long startTime = System.currentTimeMillis();
        String hexdata = null;
        while (System.currentTimeMillis() - startTime < timeout) {
            boolean handleCancel;
            if (this.uimonitor != null && this.uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
                return false;
            }
            this.onAdataAvailable(temp);
            if (temp != null && temp.length() > 0) {
                serialReceived.append((CharSequence)temp);
            }
            AbstractBurnerWorker.deleteContent(temp);
            if (this.sendBytes(data) != data.length) {
                return false;
            }
            boolean recieving = true;
            long fTime = System.currentTimeMillis();
            block5: while (recieving) {
                int receiveBytes;
                if (System.currentTimeMillis() - fTime > frameTimeout) {
                    recieving = false;
                }
                if ((receiveBytes = this.receiveBytes(temp, 1)) != 1 || temp.length() <= 0) continue;
                char charAt = temp.charAt(0);
                if (ToolUtils.isDebugOn()) {
                    String hexString = Integer.toHexString(0xFF & charAt);
                    this.println("Returned:" + hexString);
                }
                switch (charAt & 0xFF) {
                    case 170: {
                        temp.deleteCharAt(0);
                        return true;
                    }
                    case 85: {
                        this.onAdataAvailable(temp);
                        hexdata = this.getHexdata(temp);
                        if (hexdata != null && hexdata.length() > 0) {
                            this.println("NAK Returned:" + hexdata);
                        }
                        temp.deleteCharAt(0);
                        recieving = false;
                        if (!UnknownDevice.isOpenLightDebug()) continue block5;
                        AbstractBurnerWorker.updateSerialLightToError();
                        break;
                    }
                    default: {
                        this.onAdataAvailable(temp);
                        hexdata = this.getHexdata(temp);
                        if (hexdata != null && hexdata.length() > 0) {
                            this.println("Unknown Returned:" + hexdata);
                        }
                        if (temp.length() <= 0) continue block5;
                        temp.deleteCharAt(0);
                        serialRecvBuf.append(charAt);
                        fTime = System.currentTimeMillis();
                    }
                }
            }
            this.println("serialCommandTimeout end:" + System.currentTimeMillis());
        }
        return false;
    }

    public int receiveBySerialOrSocket(StringBuilder temp) throws IOException {
        int receiveBytes = CommonBurner.isSocketTransfer ? this.socketReceiveBytes(temp, 1) : this.receiveBytes(temp, 1);
        return receiveBytes;
    }

    public boolean sendI2cFrame(byte[] data, long timeout, long frameTimeout) throws IOException {
        StringBuilder temp = new StringBuilder();
        long startTime = System.currentTimeMillis();
        String hexdata = null;
        while (System.currentTimeMillis() - startTime < timeout) {
            boolean handleCancel;
            if (this.uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
                this.receiveBytesByI2c(temp, 10);
                return false;
            }
            AbstractBurnerWorker.deleteContent(temp);
            I2cCommand.sendI2cCmdForBootrom(data.length, data, 0, null, 50, this);
            if (ToolUtils.isDebugOn()) {
                this.println("Debug: Send data is :");
                this.outputHex(data);
            }
            boolean recieving = true;
            long fTime = System.currentTimeMillis();
            block5: while (recieving && !this.uimonitor.isCanceled()) {
                String hexString;
                boolean handleCancel2;
                if (System.currentTimeMillis() - fTime > frameTimeout) {
                    recieving = false;
                }
                if (this.uimonitor.isCanceled() && (handleCancel2 = this.handleCancel())) {
                    this.receiveBytesByI2c(temp, 10);
                    return false;
                }
                boolean receiveResult = this.receiveBytesByI2c(temp, 1);
                if (!receiveResult || temp.length() <= 0) continue;
                char charAt = temp.charAt(0);
                if (ToolUtils.isDebugOn() && !(hexString = Integer.toHexString(0xFF & charAt)).equalsIgnoreCase("0")) {
                    this.println("Returned:" + hexString);
                }
                switch (charAt & 0xFF) {
                    case 170: {
                        temp.deleteCharAt(0);
                        return true;
                    }
                    case 85: {
                        hexdata = this.getHexdata(temp);
                        if (hexdata != null && hexdata.length() > 0) {
                            this.println("NAK Returned:" + hexdata);
                        }
                        temp.deleteCharAt(0);
                        recieving = false;
                        break;
                    }
                    default: {
                        hexdata = this.getHexdata(temp);
                        if (hexdata != null && hexdata.length() > 0) {
                            this.println("Unknown Returned:" + hexdata);
                        }
                        if (temp == null || temp.length() <= 0) continue block5;
                        if (temp.charAt(0) != '\u0000') {
                            fTime = System.currentTimeMillis();
                        }
                        temp.deleteCharAt(0);
                    }
                }
            }
        }
        return false;
    }

    public boolean sendUsbDataFrame(byte[] data, long timeout, TransferWay transferWay) throws IOException {
        long startTime = System.currentTimeMillis();
        if (System.currentTimeMillis() - startTime < timeout) {
            boolean handleCancel;
            if (this.uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
                return false;
            }
            boolean sendDataByUsb = CallLibUSBWorker.sendDataByUsb(data, data.length, transferWay);
            if (ToolUtils.isDebugOn()) {
                this.println("Debug: Send data is :");
                this.outputHex(data);
            }
            return sendDataByUsb;
        }
        return false;
    }

    public boolean sendUsbFrame(byte[] data, long timeout, long frameTimeout, TransferWay transferWay) throws IOException {
        StringBuilder temp = new StringBuilder();
        String hexdata = null;
        boolean openUsbResult = CallLibUSBWorker.openUsb(this.uimonitor, timeout, transferWay, BurnConfig.getUsbSerialNumber());
        if (!openUsbResult) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < timeout) {
            boolean handleCancel;
            if (this.uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
                return false;
            }
            AbstractBurnerWorker.deleteContent(temp);
            boolean sendDataByUsb = CallLibUSBWorker.sendDataByUsb(data, data.length, transferWay);
            if (!sendDataByUsb) {
                AbstractBurnerWorker.returnError(Messages.ERROR_USB_SEND_DATA_FAILED);
                return false;
            }
            if (ToolUtils.isDebugOn()) {
                this.println("Debug: Send data is :");
                this.outputHex(data);
            }
            boolean recieving = true;
            long fTime = System.currentTimeMillis();
            block7: while (recieving && !this.uimonitor.isCanceled()) {
                boolean handleCancel2;
                if (System.currentTimeMillis() - fTime > frameTimeout) {
                    recieving = false;
                }
                if (this.uimonitor.isCanceled() && (handleCancel2 = this.handleCancel())) {
                    return false;
                }
                boolean receiveResult = this.receiveBytesByUsb(temp, 2, transferWay);
                if (receiveResult) {
                    String hexString;
                    if (temp.length() <= 0) continue;
                    char charAt = temp.charAt(0);
                    if (ToolUtils.isDebugOn() && !(hexString = Integer.toHexString(0xFF & charAt)).equalsIgnoreCase("0")) {
                        this.println("Returned:" + hexString);
                    }
                    switch (charAt & 0xFF) {
                        case 170: {
                            temp.deleteCharAt(0);
                            return true;
                        }
                        case 85: {
                            hexdata = this.getHexdata(temp);
                            if (hexdata != null && hexdata.length() > 0) {
                                this.println("NAK Returned:" + hexdata);
                            }
                            temp.deleteCharAt(0);
                            recieving = false;
                            break;
                        }
                        default: {
                            if (temp.length() <= 0) continue block7;
                            temp.deleteCharAt(0);
                            fTime = System.currentTimeMillis();
                            break;
                        }
                    }
                    continue;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return false;
    }

    public boolean sendUdpCmd(String command, long timeout) throws IOException {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < timeout) {
            boolean handleCancel;
            if (this.uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
                return false;
            }
            if (!CallLibBootromWorker.UdpSendData(command, command.length())) continue;
            return true;
        }
        return false;
    }

    public boolean sendJtagCmd(byte[] data, long timeout) throws IOException {
        boolean handleCancel;
        if (this.uimonitor != null && this.uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
            return false;
        }
        AbstractBurnerWorker.deleteContent(jtagReceived);
        if (ToolUtils.isDebugOn()) {
            this.println("Debug: Send data is :");
            this.outputHex(data);
        }
        String cmdResult = CallLibJTAGWorker.sendCmdByJtag(data, data.length, timeout);
        jtagReceived.append(cmdResult);
        return true;
    }

    private String getHexdata(StringBuilder temp) {
        if (temp.length() > 0) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < temp.length()) {
                String hexString = Integer.toHexString(0xFF & temp.charAt(i));
                if (hexString.length() == 2) {
                    sb.append(hexString).append(",");
                } else {
                    sb.append("0").append(hexString).append(",");
                }
                ++i;
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }
        return null;
    }

    private void outputHex(byte[] data) {
        StringBuilder sb = new StringBuilder();
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            String hexString = Integer.toHexString(0xFF & b);
            if (hexString.length() == 2) {
                sb.append(hexString).append(",");
            } else {
                sb.append("0").append(hexString).append(",");
            }
            ++n2;
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.println(sb.toString());
    }

    public boolean handleCancel() {
        try {
            this.sendBreak();
        }
        catch (IOException iOException) {}
        AbstractBurnerWorker.warningln("\nUser Cancelled!");
        if (monitor == null) {
            return true;
        }
        FastbootEvent event = monitor.getEvent();
        if (event == null) {
            return true;
        }
        event.setUserCanceled(true);
        event.setSuccess(false);
        event.setMessage(msg_UserCancelled);
        return true;
    }

    public boolean downloadFile(int bootDdrAddr, String filePath, String sendInfo) {
        if (UnknownDevice.isOpenLightDebug()) {
            this.initLightState();
        }
        int totalOffset = 0;
        double rateLast = 0.0;
        AbstractBurnerWorker.deleteContent(serialReceived);
        AbstractBurnerWorker.deleteContent(i2csReceived);
        AbstractBurnerWorker.deleteContent(usbsReceived);
        AbstractBurnerWorker.deleteContent(jtagReceived);
        AbstractBurnerWorker.deleteContent(serialRecvBuf);
        String currentChip = FastbootView.getCurrentChip();
        if (CHIP_NAME_CJ109V100.equalsIgnoreCase(currentChip)) {
            sendInfo = BOOT_INFO_CJ109V100;
        }
        this.receivDebugInfo("startFrameInfo :" + sendInfo);
        if (!this.sendStartFrame(this.fileList[0], sendInfo)) {
            AbstractBurnerWorker.updateSerialLightToError();
            this.readBootromInfoNACK(serialReceived.toString());
            AbstractBurnerWorker.returnError(Messages.ERROR_INFO_Failed_To_Send_Start_Frame);
            return false;
        }
        AbstractBurnerWorker.updateSerialLightToRight();
        this.readBootromInfoAck(serialReceived.toString());
        int sendDataSize = this.getSendDataSize();
        int i = 0;
        while (i < this.fileList.length) {
            if (!this.setFileInfo(this.fileList[i], sendDataSize, totalOffset, rateLast)) {
                return false;
            }
            if (!this.setp1Delay(i, this.burner.getBurnContext().getTransferWay())) {
                return false;
            }
            if (!this.setGsl(i, this.fileList[i], sendDataSize, totalOffset, rateLast)) {
                return false;
            }
            ++i;
        }
        AbstractBurnerWorker.receivedln(" ---- 100%");
        return true;
    }

    private boolean setGsl(int setp1Index, FileInfo fileInfo, int sendDataSize, int totalOffset, double rateLast) {
        long gslAddree;
        boolean isSetGsl;
        String currentChip = FastbootView.getCurrentChip();
        boolean bl = isSetGsl = setp1Index == 1 && CHIP_NAME_CJ109V100.equalsIgnoreCase(currentChip);
        if (isSetGsl && (gslAddree = this.getGslAddree(fileInfo.getData())) == 510228540L) {
            byte[] data = fileInfo.getData();
            byte[] gslData = new byte[15360];
            System.arraycopy(data, 65536, gslData, 0, 15360);
            FileInfo gslFile = new FileInfo();
            gslFile.setAddress(67242496);
            gslFile.setLength(15360);
            gslFile.setData(gslData);
            if (!this.setFileInfo(gslFile, sendDataSize, totalOffset, rateLast)) {
                return false;
            }
        }
        return true;
    }

    private long getGslAddree(byte[] data) {
        long gslValue = 0L;
        if (data.length > 6148) {
            gslValue = (data[6144] << 24) + (data[6145] << 16) + (data[6146] << 8) + data[6147];
        }
        return gslValue;
    }

    protected boolean setp1Delay(int setp1Index, TransferWay transferWay) {
        boolean isSleep;
        String currentChip = FastbootView.getCurrentChip();
        boolean bl = isSleep = setp1Index == 1 && CHIP_NAME_CJ109V100.equalsIgnoreCase(currentChip) && transferWay == TransferWay.USBBootrom;
        if (isSleep) {
            boolean openUsbResult;
            CallLibUSBWorker.closeUsb(transferWay);
            long timeout = 3000L;
            try {
                Thread.sleep(timeout);
            }
            catch (InterruptedException interruptedException) {
                AbstractBurnerWorker.warningln("Error occurs while waiting setp1 run.");
                return false;
            }
            if (ToolUtils.isDebugOn()) {
                this.println("setp1 delay :" + timeout);
            }
            if (!(openUsbResult = CallLibUSBWorker.openUsb(this.uimonitor, timeout, transferWay, BurnConfig.getUsbSerialNumber()))) {
                AbstractBurnerWorker.returnError("Failed to open usb!");
                this.infoln("Failed to open usb!");
                return false;
            }
        }
        return true;
    }

    public boolean updateloadFile(int bootDdrAddr, int flashAddr, int lenght, String filePath) {
        if (UnknownDevice.isOpenLightDebug()) {
            this.initLightState();
        }
        AbstractBurnerWorker.deleteContent(serialReceived);
        return CallLibBootromWorker.Xmodem_upload(CallLibBootromWorker.getComFd(), bootDdrAddr, flashAddr, lenght, filePath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String readDataFromConsole(String prompt) {
        String str = null;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(System.in, System.getProperty("file.encoding")));
            str = br.readLine();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (br == null) return str;
            try {
                br.close();
                return str;
            }
            catch (IOException iOException) {}
            return str;
        }
        catch (IOException iOException) {
            try {
                if (br == null) return str;
            }
            catch (Throwable throwable) {
                if (br == null) throw throwable;
                try {
                    br.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                br.close();
                return str;
            }
            catch (IOException iOException3) {}
            return str;
        }
        if (br == null) return str;
        try {
            br.close();
            return str;
        }
        catch (IOException iOException) {}
        return str;
    }

    protected int getSendDataSize() {
        boolean isUSBTransWay;
        int sendDataSize = 1024;
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        boolean bl = isUSBTransWay = transferWay == TransferWay.USBBootrom || transferWay == TransferWay.USBNonNude || transferWay == TransferWay.UsbAndSerial;
        if (isUSBTransWay) {
            sendDataSize = 511;
        } else if (FastbootView.isCJ303V3Series()) {
            sendDataSize = 16384;
        }
        return sendDataSize;
    }

    protected void isSetGsl(List<PartitionItem> parts) {
        if (CHIP_NAME_CJ109V100.equalsIgnoreCase(ToolUtils.getChipName())) {
            byte[] data;
            boolean isSetGsl = false;
            File file = parts.get(0).getFile();
            if (file != null && 510228540L == this.getGslAddree(data = FileUtils.readAllBytes(file.getPath()))) {
                isSetGsl = true;
            }
            ToolUtils.setSetGsl(isSetGsl);
        }
    }

    public boolean downloadFile() {
        String currentChip = FastbootView.getCurrentChip();
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        String sendInfo = BOOT_INFO;
        if (CHIP_NAME_CJ109V100.equalsIgnoreCase(currentChip)) {
            if (transferWay == TransferWay.USBBootrom) {
                return true;
            }
            sendInfo = BOOT_INFO_GSL_CJ109V100;
        }
        if (UnknownDevice.isOpenLightDebug()) {
            this.initLightState();
        }
        int totalOffset = 0;
        double rateLast = 0.0;
        AbstractBurnerWorker.deleteContent(serialReceived);
        AbstractBurnerWorker.deleteContent(i2csReceived);
        AbstractBurnerWorker.deleteContent(usbsReceived);
        AbstractBurnerWorker.deleteContent(jtagReceived);
        AbstractBurnerWorker.deleteContent(serialRecvBuf);
        if (!this.sendStartFrame(this.fileList[0], sendInfo)) {
            AbstractBurnerWorker.updateSerialLightToError();
            this.readBootromInfoNACK(serialReceived.toString());
            AbstractBurnerWorker.returnError(Messages.ERROR_INFO_Failed_To_Send_Start_Frame);
            return false;
        }
        AbstractBurnerWorker.updateSerialLightToRight();
        this.readBootromInfoAck(serialReceived.toString());
        if (CHIP_NAME_CJ109V100.equalsIgnoreCase(currentChip)) {
            return true;
        }
        int sendDataSize = this.getSendDataSize();
        int i = 0;
        while (i < this.fileList.length) {
            this.setFileInfo(this.fileList[i], sendDataSize, totalOffset, rateLast);
            ++i;
        }
        AbstractBurnerWorker.receivedln(" ---- 100%");
        return true;
    }

    protected boolean setFileInfo(FileInfo fileInfo, int sendDataSize, int totalOffset, double rateLast) {
        boolean needUpdateLight;
        int currentLen = 0;
        byte[] tosend = null;
        if (!this.sendHeadFrame(fileInfo)) {
            AbstractBurnerWorker.updateSerialLightToError();
            this.readBootromAndDDrNAck(serialReceived.toString());
            AbstractBurnerWorker.returnError(Messages.ERROR_INFO_Failed_To_Send_Head_Frame);
            return false;
        }
        AbstractBurnerWorker.updateSerialLightToRight();
        this.readBootromAndDDrAck(serialReceived.toString());
        byte[] fileData = fileInfo.getData();
        byte[] realFileData = Arrays.copyOfRange(fileData, 0, fileInfo.getLength());
        int leftLength = realFileData.length;
        int seq = 1;
        int offset = 0;
        while (leftLength > 0) {
            boolean isPrint;
            currentLen = Math.min(sendDataSize, leftLength);
            tosend = Arrays.copyOfRange(realFileData, offset, offset + currentLen);
            if (!this.sendDataFrame(seq++, tosend, this.burner.getBurnContext().getTransferWay())) {
                AbstractBurnerWorker.updateSerialLightToError();
                AbstractBurnerWorker.returnError(Messages.ERROR_INFO_Failed_To_Send_Data_Frame);
                return false;
            }
            boolean bl = needUpdateLight = UnknownDevice.isOpenLightDebug() && lightCurrentStateMap.get(Light_E.SERIAL.name()) != null && lightCurrentStateMap.get(Light_E.SERIAL.name()).intValue() == Light_State_E.abnormal.ordinal();
            if (needUpdateLight) {
                AbstractBurnerWorker.updateSerialLightToRight();
            }
            leftLength -= tosend.length;
            offset += tosend.length;
            AbstractBurnerWorker.received("#");
            int total = this.calculateTotal();
            double temp = (double)(totalOffset += tosend.length) * 100.0 / (double)total;
            boolean bl2 = isPrint = temp - rateLast >= 10.0 && (int)temp != 100;
            if (!isPrint) continue;
            AbstractBurnerWorker.receivedln(" ---- " + (int)temp + "%");
            rateLast = temp;
        }
        if (!this.sendTailFrame(seq)) {
            if (FastbootView.isCJXX1Series()) {
                return true;
            }
            AbstractBurnerWorker.updateSerialLightToError();
            AbstractBurnerWorker.returnError(Messages.ERROR_INFO_Failed_To_Send_Tail_Frame);
            return false;
        }
        boolean bl = needUpdateLight = UnknownDevice.isOpenLightDebug() && lightCurrentStateMap.get(Light_E.SERIAL.name()) != null && lightCurrentStateMap.get(Light_E.SERIAL.name()).intValue() == Light_State_E.abnormal.ordinal();
        if (needUpdateLight) {
            AbstractBurnerWorker.updateSerialLightToRight();
        }
        if (this.burner.getBurnContext().getPlatformType() == PlatformType.CA) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                AbstractBurnerWorker.warningln("Error occurs while waiting DDR run.");
                return false;
            }
        }
        return true;
    }

    protected int calculateTotal() {
        int total = 0;
        int i = 0;
        while (i < this.fileList.length) {
            total += this.fileList[i].getLength();
            ++i;
        }
        return total;
    }

    public boolean sendDataFrame(int seq, byte[] pBuffer, TransferWay transferWay) {
        if (this.burner.getBurnContext().getTransferWay() == TransferWay.USBBootrom || this.burner.getBurnContext().getTransferWay() == TransferWay.USBNonNude) {
            return this.sendUSBDataFrame(seq, pBuffer, transferWay);
        }
        int len = pBuffer.length;
        int dwSendLength = len + 5;
        int[] pSendBuffer = new int[dwSendLength];
        int crc = 0;
        pSendBuffer[0] = 218;
        pSendBuffer[1] = seq & 0xFF;
        pSendBuffer[2] = ~seq & 0xFF;
        int i = 0;
        while (i < len) {
            pSendBuffer[i + 3] = pBuffer[i] & 0xFF;
            ++i;
        }
        crc = AbstractBurnerWorker.calc_crc16(pSendBuffer, len + 3, 1);
        pSendBuffer[3 + len] = crc >> 8 & 0xFF;
        pSendBuffer[4 + len] = crc & 0xFF;
        try {
            byte[] convertToByte = this.convertToByte(pSendBuffer);
            if (ToolUtils.isDebugOn()) {
                this.println("To send data frame, send timeout=" + TIMEOUT_SEND_FRAME / 1000 + "s, wait response timeout=" + 500 + "ms data is :");
                this.outputHex(convertToByte);
            }
            boolean sendFrame = this.sendFrame(convertToByte, TIMEOUT_SEND_FRAME, 500L);
            if (ToolUtils.isDebugOn() && !sendFrame) {
                this.println("Failed to send data frame");
            }
            return sendFrame;
        }
        catch (IOException e) {
            AbstractBurnerWorker.warningln(e.getMessage());
            return false;
        }
    }

    public boolean sendUSBDataFrame(int seq, byte[] pBuffer, TransferWay transferWay) {
        int len = pBuffer.length;
        int dwSendLength = len + 1;
        int[] pSendBuffer = new int[dwSendLength];
        pSendBuffer[0] = 218;
        int i = 0;
        while (i < len) {
            pSendBuffer[i + 1] = pBuffer[i] & 0xFF;
            ++i;
        }
        try {
            byte[] convertToByte = this.convertToByte(pSendBuffer);
            boolean sendFrame = this.sendUsbDataFrame(convertToByte, TIMEOUT_SEND_FRAME, transferWay);
            if (ToolUtils.isDebugOn() && !sendFrame) {
                this.println("Failed to send data frame");
            }
            return sendFrame;
        }
        catch (IOException e) {
            AbstractBurnerWorker.warningln(e.getMessage());
            return false;
        }
    }

    public boolean sendTranslateWayFrame(TransferWay way) {
        block16: {
            if (way == TransferWay.I2CBootrom || way == TransferWay.Usb2I2c) {
                SerialPort port;
                block15: {
                    port = null;
                    try {
                        port = this.createConnection(this.burner.getBurnContext().getLocalConfig().getComPort());
                        if (monitor == null) break block15;
                        monitor.begin();
                    }
                    catch (IOException iOException) {
                        if (port == null && monitor != null) {
                            this.infoln(Messages.SERAIL_PORT_OPEN_FAILED);
                            monitor.getEvent().setMessage(Messages.SERAIL_PORT_OPEN_FAILED);
                            monitor.finish();
                            return false;
                        }
                        break block16;
                    }
                    catch (TooManyListenersException tooManyListenersException) {
                        try {}
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (port == null && monitor != null) {
                                this.infoln(Messages.SERAIL_PORT_OPEN_FAILED);
                                monitor.getEvent().setMessage(Messages.SERAIL_PORT_OPEN_FAILED);
                                monitor.finish();
                                return false;
                            }
                            break block16;
                        }
                    }
                }
                if (port != null || monitor == null) break block16;
                this.infoln(Messages.SERAIL_PORT_OPEN_FAILED);
                monitor.getEvent().setMessage(Messages.SERAIL_PORT_OPEN_FAILED);
                monitor.finish();
                return false;
            }
        }
        int crc = 0;
        int[] buffer = new int[14];
        buffer[0] = 254;
        buffer[1] = 0;
        buffer[2] = 255;
        buffer[3] = 1;
        buffer[4] = way == TransferWay.Serial ? 0 : 1;
        buffer[5] = 0;
        buffer[6] = 0;
        buffer[7] = 0;
        buffer[8] = 0;
        buffer[9] = 0;
        buffer[10] = 0;
        buffer[11] = 0;
        crc = AbstractBurnerWorker.calc_crc16(buffer, 12, 1);
        buffer[12] = crc >> 8 & 0xFF;
        buffer[13] = crc & 0xFF;
        boolean sendFrame = false;
        try {
            byte[] convertToByte = this.convertToByte(buffer);
            if (ToolUtils.isDebugOn()) {
                this.println("To send start frame, send timeout=30s, wait response timeout=30ms data is :");
                this.outputHex(convertToByte);
            }
            if (!(sendFrame = this.sendOtherFrame(convertToByte, 30000L, 30L)) && ToolUtils.isDebugOn()) {
                this.println("Failed to send start frame");
            }
        }
        catch (IOException e) {
            AbstractBurnerWorker.warningln(e.getMessage());
        }
        if (way == TransferWay.I2CBootrom) {
            this.close();
        }
        return sendFrame;
    }

    public boolean sendStartFrame(FileInfo fileInfo, String sendInfo) {
        String boardType;
        Socket socketConnection;
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        if (CommonBurner.isSocketTransfer && (socketConnection = ((AbstractBurner)((Object)this.burner)).createSocket(AbstractBurnerWorker.getMonitor(), this)) == null) {
            return false;
        }
        if (FastbootView.isCJ303V300()) {
            this.setProgressMonitor(AbstractBurnerWorker.getMonitor());
            boolean sendTranslateFrame = this.sendTranslateWayFrame(transferWay);
            if (!sendTranslateFrame) {
                return false;
            }
        }
        if ((boardType = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getProperties().queryForString("TYPE")) != null && boardType.equalsIgnoreCase("CAM")) {
            return this.sendStartFrameForCAM(sendInfo);
        }
        if (this.burner.getBurnContext().getTransferWay() == TransferWay.USBBootrom || this.burner.getBurnContext().getTransferWay() == TransferWay.USBNonNude) {
            return this.sendUSBStartFrame();
        }
        int crc = 0;
        int[] buffer = new int[14];
        int length = 0;
        int address = 0;
        if (FastbootView.isCJ303V3Series()) {
            length = 16384;
            address = -559064486;
        } else {
            length = fileInfo.getLength();
            address = fileInfo.getAddress();
        }
        buffer[0] = 254;
        buffer[1] = 0;
        buffer[2] = 255;
        buffer[3] = 1;
        buffer[4] = length >> 24 & 0xFF;
        buffer[5] = length >> 16 & 0xFF;
        buffer[6] = length >> 8 & 0xFF;
        buffer[7] = length & 0xFF;
        buffer[8] = address >> 24 & 0xFF;
        buffer[9] = address >> 16 & 0xFF;
        buffer[10] = address >> 8 & 0xFF;
        buffer[11] = address & 0xFF;
        crc = AbstractBurnerWorker.calc_crc16(buffer, 12, 1);
        buffer[12] = crc >> 8 & 0xFF;
        buffer[13] = crc & 0xFF;
        try {
            boolean sendFrame;
            byte[] convertToByte = this.convertToByte(buffer);
            if (ToolUtils.isDebugOn()) {
                this.println("To send start frame, send timeout=30s, wait response timeout=13ms data is :");
                this.outputHex(convertToByte);
            }
            if (!(sendFrame = this.sendFrameForStart(convertToByte, 30000L, 13L)) && ToolUtils.isDebugOn()) {
                this.println("Failed to send start frame");
            }
            return sendFrame;
        }
        catch (IOException e) {
            AbstractBurnerWorker.warningln(e.getMessage());
            return false;
        }
    }

    private boolean sendStartFrameForCAM(String sendInfo) {
        if (this.burner.getBurnContext().getTransferWay() == TransferWay.USBBootrom) {
            this.infoln(this.getStartMessage());
            return this.sendUSBStartFrame();
        }
        if (CommonBurner.isSocketTransfer) {
            this.infoln(this.getStartMessage());
        }
        String temp = null;
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < this.burner.getBurnContext().getDeviceSetting().getFrameSetting().getSendStartFrameTimeout()) {
            if (CommonBurner.isSocketTransfer) {
                this.onAdataAvailable(serialReceived);
            }
            try {
                this.receiveBytes(serialReceived, 4096);
            }
            catch (IOException iOException) {}
            temp = serialReceived.toString();
            int indexOf = temp.indexOf(sendInfo);
            if (indexOf == -1) continue;
            try {
                this.sendBytes(new byte[]{-86});
                return true;
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public boolean sendUSBStartFrame() {
        int length;
        int[] buffer = new int[9];
        int address = length = DataUtils.getRandomValue();
        buffer[0] = 254;
        buffer[1] = length >> 24 & 0xFF;
        buffer[2] = length >> 16 & 0xFF;
        buffer[3] = length >> 8 & 0xFF;
        buffer[4] = length & 0xFF;
        buffer[5] = address >> 24 & 0xFF;
        buffer[6] = address >> 16 & 0xFF;
        buffer[7] = address >> 8 & 0xFF;
        buffer[8] = address & 0xFF;
        try {
            boolean sendFrame;
            byte[] convertToByte = this.convertToByte(buffer);
            if (ToolUtils.isDebugOn()) {
                this.println("To send start frame, send timeout=30s, wait response timeout=30ms data is :");
                this.outputHex(convertToByte);
            }
            if (!(sendFrame = this.sendFrameForStart(convertToByte, 30000L, 30L)) && ToolUtils.isDebugOn()) {
                this.println("Failed to send start frame");
            }
            return sendFrame;
        }
        catch (IOException e) {
            AbstractBurnerWorker.warningln(e.getMessage());
            return false;
        }
    }

    boolean sendHeadFrame(FileInfo fileInfo) {
        if (this.burner.getBurnContext().getTransferWay() == TransferWay.USBBootrom || this.burner.getBurnContext().getTransferWay() == TransferWay.USBNonNude) {
            return this.sendUSBHeadFrame(fileInfo);
        }
        if (ToolUtils.isDebugOn()) {
            this.println("Send head frame...");
        }
        int crc = 0;
        int[] buffer = new int[14];
        int length = fileInfo.getLength();
        int address = fileInfo.getAddress();
        buffer[0] = 254;
        buffer[1] = 0;
        buffer[2] = 255;
        buffer[3] = 1;
        buffer[4] = length >> 24 & 0xFF;
        buffer[5] = length >> 16 & 0xFF;
        buffer[6] = length >> 8 & 0xFF;
        buffer[7] = length & 0xFF;
        buffer[8] = address >> 24 & 0xFF;
        buffer[9] = address >> 16 & 0xFF;
        buffer[10] = address >> 8 & 0xFF;
        buffer[11] = address & 0xFF;
        crc = AbstractBurnerWorker.calc_crc16(buffer, 12, 1);
        buffer[12] = crc >> 8 & 0xFF;
        buffer[13] = crc & 0xFF;
        try {
            byte[] convertToByte = this.convertToByte(buffer);
            if (ToolUtils.isDebugOn()) {
                this.println("To send head frame, send timeout=" + TIMEOUT_SEND_FRAME / 1000 + "s, wait response timeout=" + AbstractBurnerWorker.getTimeFrameHead() + "ms data is :");
                this.outputHex(convertToByte);
            }
            boolean sendFrame = this.sendFrame(convertToByte, TIMEOUT_SEND_FRAME, AbstractBurnerWorker.getTimeFrameHead());
            if (ToolUtils.isDebugOn() && !sendFrame) {
                this.println("Failed to send head frame");
            }
            return sendFrame;
        }
        catch (IOException e) {
            AbstractBurnerWorker.warningln(e.getMessage());
            return false;
        }
    }

    boolean sendUSBHeadFrame(FileInfo fileInfo) {
        if (ToolUtils.isDebugOn()) {
            this.println("Send head frame...");
        }
        int[] buffer = new int[9];
        int length = fileInfo.getLength();
        int address = fileInfo.getAddress();
        buffer[0] = 254;
        buffer[1] = length >> 24 & 0xFF;
        buffer[2] = length >> 16 & 0xFF;
        buffer[3] = length >> 8 & 0xFF;
        buffer[4] = length & 0xFF;
        buffer[5] = address >> 24 & 0xFF;
        buffer[6] = address >> 16 & 0xFF;
        buffer[7] = address >> 8 & 0xFF;
        buffer[8] = address & 0xFF;
        try {
            byte[] convertToByte = this.convertToByte(buffer);
            boolean sendFrame = this.sendFrame(convertToByte, TIMEOUT_SEND_FRAME, AbstractBurnerWorker.getTimeFrameHead());
            if (ToolUtils.isDebugOn() && !sendFrame) {
                this.println("Failed to send head frame");
            }
            return sendFrame;
        }
        catch (IOException e) {
            AbstractBurnerWorker.warningln(e.getMessage());
            return false;
        }
    }

    public boolean prepareFile(String filePath) throws IOException {
        File file;
        if (ToolUtils.isDebugOn()) {
            this.println("Preparing File " + filePath);
        }
        if (!(file = new File(filePath)).exists()) {
            AbstractBurnerWorker.returnError(msg_BootFileNotFound);
            return false;
        }
        this.fileList = this.frameSetting.prepareFile(file, this.getFlashType());
        return true;
    }

    public boolean prepareProgrammerFile(String filePath) throws IOException {
        File file;
        if (ToolUtils.isDebugOn()) {
            this.println("Preparing File " + filePath);
        }
        if (!(file = new File(filePath)).exists()) {
            AbstractBurnerWorker.returnError(msg_BootFileNotFound);
            return false;
        }
        this.fileList = this.frameSetting.prepareProgrammerFile(file);
        return true;
    }

    public boolean sendCommand(String command) throws IOException, ReceiveTimeOutException {
        return this.sendCommand(command, 5000);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean sendCommand(SerialCommand command) throws IOException, ReceiveTimeOutException {
        if (command instanceof TFTPCommand) {
            block18: {
                result = false;
                totalTimeout = command.getTimeout();
                receiveTimeout = 0;
                retryCount = 0;
                if (!ToolUtils.isCmdLine()) {
                    receiveTimeout = FastbootPreferences.getInt("vendor.burn.tftp.timeout.noresponse") * 1000;
                    retryCount = FastbootPreferences.getInt("vendor.burn.tftp.retry.count");
                } else {
                    receiveTimeout = PreferenceConfig.getTftpTimeoutNoresponse() * 1000;
                    retryCount = PreferenceConfig.getTftpRetryCount();
                }
                if (ToolUtils.isDebugOn()) {
                    sb = new StringBuilder();
                    sb.append("sending tftp command :" + command.getCommand() + "\t no response timeout is " + receiveTimeout + "ms");
                    sb.append(" \t total timeout is " + totalTimeout + "ms");
                    sb.append(" \t retry count is " + retryCount);
                    this.println(sb.toString());
                }
                try {
                    result = this.sendTFTPCommand(command.getCommand(), totalTimeout, receiveTimeout);
                    break block18;
                }
                catch (ReceiveTimeOutException v0) {
                    loop = retryCount;
                    ** while (--loop > 0 && !result)
                }
lbl-1000:
                // 1 sources

                {
                    if (AbstractBurnerWorker.monitor.getEvent().isUserCanceled()) {
                        return false;
                    }
                    this.sendBreak();
                    AbstractBurnerWorker.warningln("\n" + Messages.ERROR_INFO_Failed_To_Execute_TFTPCommand);
                    AbstractBurnerWorker.warningln("Resend command...");
                    isSupportTFTPWin = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportTFTPWin();
                    isCheck = false;
                    isCheck = ToolUtils.isCmdLine() != false ? PreferenceConfig.isTftpWinSizeOpen() : FastbootPreferences.isOpenTftpWindowSize();
                    v1 = needReduceWinSize = isSupportTFTPWin != false && isCheck != false && TFTPService.getWinSizeBlockCount() > 0 && TFTPService.getWinSizeBlockCount() > 1;
                    if (needReduceWinSize) {
                        TFTPService.setWinSizeBlockCount((int)(TFTPService.getWinSizeBlockCount() - 1));
                        this.infoln("The current Window Size value is " + (TFTPService.getWinSizeBlockCount() + 1));
                    } else {
                        TFTPService.setWinSizeBlockCount((int)1);
                    }
                    try {
                        result = this.sendTFTPCommand(command.getCommand(), totalTimeout * (retryCount - loop + 1), receiveTimeout * (retryCount - loop + 1));
                    }
                    catch (ReceiveTimeOutException v2) {}
                    continue;
                }
            }
            if (!result) {
                AbstractBurnerWorker.returnError(Messages.ERROR_INFO_Failed_To_Execute_TFTPCommand);
                if (UnknownDevice.isOpenLightDebug()) {
                    AbstractBurnerWorker.lightCurrentStateMap.put(Light_E.TFTP.name(), Light_State_E.abnormal.ordinal());
                    if (AbstractBurnerWorker.getLightView() != null) {
                        AbstractBurnerWorker.updateLightColor(AbstractBurnerWorker.getLightView().getTftplbl(), AbstractBurnerWorker.lightCurrentStateMap.get(Light_E.TFTP.name()));
                    }
                }
                throw new ReceiveTimeOutException(Messages.ERROR_INFO_Failed_To_Execute_TFTPCommand);
            }
            AbstractBurnerWorker.monitor.getEvent().setMessage(null);
            return result;
        }
        if (command instanceof SFCommand) {
            try {
                Thread.sleep(800L);
            }
            catch (InterruptedException v3) {}
            return this.sendCommand(command.getCommand(), command.getTimeout());
        }
        return this.sendCommand(command.getCommand(), command.getTimeout());
    }

    public boolean sendCommandNoReturnValue(String command) throws IOException, ReceiveTimeOutException {
        boolean isSerial;
        AbstractBurnerWorker.deleteContent(serialReceived);
        AbstractBurnerWorker.deleteContent(i2csReceived);
        AbstractBurnerWorker.deleteContent(usbsReceived);
        AbstractBurnerWorker.deleteContent(jtagReceived);
        this.infoln("\nSend command:\t" + command);
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        boolean bl = isSerial = transferWay == TransferWay.Net || transferWay == TransferWay.Serial || transferWay == TransferWay.NetNonNude || transferWay == TransferWay.Uart2Compress;
        if (isSerial && !CommonBurner.isSocketTransfer) {
            CallLibBootromWorker.SendDataNoReply(CallLibBootromWorker.getComFd(), command, command.length());
            return true;
        }
        if (!this.sendCmdByTrans(command, TIMEOUT_SEND_FRAME)) {
            return false;
        }
        this.infoln(String.valueOf(command) + " success!");
        return true;
    }

    protected boolean sendCommandDontCareEOTBySerial(String command, int timeout) throws IOException, ReceiveTimeOutException {
        boolean isSerial;
        AbstractBurnerWorker.deleteContent(serialReceived);
        this.infoln("\nSend command:\t" + command);
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        boolean bl = isSerial = transferWay == TransferWay.Net || transferWay == TransferWay.Serial || transferWay == TransferWay.NetNonNude || transferWay == TransferWay.Uart2Compress || transferWay == TransferWay.UsbAndSerial || transferWay == TransferWay.UDP;
        if (isSerial && !CommonBurner.isSocketTransfer) {
            boolean commandFrame = CallLibBootromWorker.SendData(CallLibBootromWorker.getComFd(), command, command.length(), timeout);
            if (!commandFrame) {
                if (ToolUtils.isDebugOn()) {
                    this.println("Failed to send command frame");
                }
                return false;
            }
            return true;
        }
        if (!this.serialCommand(command, timeout)) {
            return false;
        }
        long receiveTime = System.currentTimeMillis();
        String temp = this.getCurSerialReceived();
        int offset = 0;
        while (true) {
            if (System.currentTimeMillis() - receiveTime > (long)timeout) {
                StringBuilder sb = new StringBuilder(msg_TimeoutWhileReceiveCommandExecuteResult);
                sb.append("(").append(command);
                if (ToolUtils.isDebugOn()) {
                    sb.append("\ttimeout=").append(timeout / 1000).append("s");
                }
                sb.append(")");
                AbstractBurnerWorker.warningln(sb.toString());
                throw new ReceiveTimeOutException(sb.toString());
            }
            if (temp.indexOf("[EOT](OK)") != -1) {
                return true;
            }
            temp = this.getCurSerialReceived();
            if (temp.length() <= offset) continue;
            int length = temp.length();
            CharSequence subSequence = temp.subSequence(offset, length);
            offset += subSequence.length();
            AbstractBurnerWorker.received(subSequence.toString());
        }
    }

    protected boolean sendCommandDontCareEOT(String command, int timeout) throws IOException, ReceiveTimeOutException {
        boolean hasError;
        CharSequence subSequence;
        int length;
        boolean isSerial;
        AbstractBurnerWorker.deleteContent(serialReceived);
        AbstractBurnerWorker.deleteContent(i2csReceived);
        AbstractBurnerWorker.deleteContent(usbsReceived);
        AbstractBurnerWorker.deleteContent(jtagReceived);
        this.infoln("\nSend command:\t" + command);
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        boolean bl = isSerial = (transferWay == TransferWay.Net || transferWay == TransferWay.Serial || transferWay == TransferWay.NetNonNude || transferWay == TransferWay.UDP || transferWay == TransferWay.Uart2Compress) && !CommonBurner.isSocketTransfer;
        if (isSerial) {
            boolean commandFrame = CallLibBootromWorker.SendData(CallLibBootromWorker.getComFd(), command, command.length(), timeout);
            if (!commandFrame) {
                this.println("Failed to send command frame");
                return false;
            }
            return true;
        }
        if (!this.sendCmdByTrans(command, timeout)) {
            return false;
        }
        boolean reading = true;
        long receiveTime = System.currentTimeMillis();
        String temp = this.getCurReceived();
        int offset = 0;
        while (reading) {
            boolean handleCancel;
            if (this.uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
                return false;
            }
            if (System.currentTimeMillis() - receiveTime > (long)timeout) {
                boolean hasLoadOrUplo;
                StringBuilder sb = new StringBuilder(msg_TimeoutWhileReceiveCommandExecuteResult);
                sb.append("(").append(command);
                sb.append("\ttimeout=").append(timeout / 1000).append("s");
                sb.append(")");
                AbstractBurnerWorker.warningln(sb.toString());
                boolean bl2 = hasLoadOrUplo = command.startsWith("load") || command.startsWith("uplo");
                if (hasLoadOrUplo) {
                    return true;
                }
                throw new ReceiveTimeOutException(sb.toString());
            }
            if (temp.indexOf("[EOT]") != -1) break;
            temp = this.getCurReceived();
            if (temp.length() <= offset) continue;
            length = temp.length();
            subSequence = temp.subSequence(offset, length);
            offset += subSequence.length();
            AbstractBurnerWorker.received(subSequence.toString());
        }
        if (temp.indexOf("[EOT](OK)") != -1) {
            return true;
        }
        if (temp.indexOf("[EOT](ERROR)") != -1) {
            return false;
        }
        receiveTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - receiveTime < 3000L) {
            if (!ToolUtils.isCmdLine() && this.uimonitor.isCanceled()) {
                this.sendBreak();
                this.handleCancel();
                return false;
            }
            temp = this.getCurReceived();
            if (temp.indexOf("[EOT](OK)") != -1) {
                return true;
            }
            if (temp.indexOf("[EOT](ERROR)") != -1) break;
        }
        if ((temp = this.getCurReceived()).length() > offset) {
            length = temp.length();
            subSequence = temp.subSequence(offset, length);
            AbstractBurnerWorker.received(subSequence.toString());
        }
        boolean bl3 = hasError = temp.indexOf("ERROR") != -1 || temp.indexOf("[EOT](E") != -1;
        return !hasError;
    }

    protected boolean sendCommand(String command, int timeout) throws IOException, ReceiveTimeOutException {
        boolean hasError;
        CharSequence subSequence;
        int length;
        TransferWay transferWay;
        boolean isSerial;
        AbstractBurnerWorker.deleteContent(serialReceived);
        AbstractBurnerWorker.deleteContent(i2csReceived);
        AbstractBurnerWorker.deleteContent(usbsReceived);
        AbstractBurnerWorker.deleteContent(jtagReceived);
        this.infoln("\nSend command:\t" + command);
        if (ToolUtils.isDebugOn()) {
            this.println("\nIf your boot is not the lastest one, \nthere may be non-answer from board during executing command.\nPlease be patient for waiting.\nThe time may be :\t" + timeout / 1000 + "s.");
        }
        boolean bl = isSerial = ((transferWay = this.burner.getBurnContext().getTransferWay()) == TransferWay.Net || transferWay == TransferWay.Serial || transferWay == TransferWay.NetNonNude || transferWay == TransferWay.Uart2Compress || transferWay == TransferWay.JTAGAndSerial || transferWay == TransferWay.UsbTransNet) && !CommonBurner.isSocketTransfer;
        if (isSerial) {
            boolean commandFrame = CallLibBootromWorker.SendData(CallLibBootromWorker.getComFd(), command, command.length(), timeout);
            if (!commandFrame) {
                this.println("Failed to send command frame");
                return false;
            }
            return true;
        }
        if (!this.sendCmdByTrans(command, timeout)) {
            return false;
        }
        boolean reading = true;
        long receiveTime = System.currentTimeMillis();
        String temp = this.getCurReceived();
        if ("usbtftp error".equals(command) || "usbtftp end".equals(command) || "usbtftp start".equals(command)) {
            reading = false;
        }
        int offset = 0;
        while (reading) {
            boolean handleCancel;
            if (this.uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
                return false;
            }
            if (System.currentTimeMillis() - receiveTime > (long)timeout) {
                boolean isLoadOrUplo;
                boolean bl2 = isLoadOrUplo = command.startsWith("load") || command.startsWith("uplo") || command.startsWith("nand bad");
                if (isLoadOrUplo) {
                    return true;
                }
                StringBuilder sb = new StringBuilder(msg_TimeoutWhileReceiveCommandExecuteResult);
                sb.append("(").append(command);
                sb.append("\ttimeout=").append(timeout / 1000).append("s");
                sb.append(")");
                AbstractBurnerWorker.warningln(sb.toString());
                if (this.getCurReceived().contains(REALLY_SCRUB)) {
                    String y = "y\r";
                    if (this.sendBytes(y.getBytes(System.getProperty("file.encoding"))) != y.length()) {
                        return false;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    break;
                }
                this.println("\nSend command timeout : " + sb.toString());
                throw new ReceiveTimeOutException(sb.toString());
            }
            if (temp.indexOf("[EOT]") != -1) {
                length = temp.length();
                subSequence = temp.subSequence(offset, length);
                offset += subSequence.length();
                AbstractBurnerWorker.received(subSequence.toString());
                break;
            }
            temp = this.getCurReceived();
            if (temp.length() <= offset) continue;
            length = temp.length();
            subSequence = temp.subSequence(offset, length);
            offset += subSequence.length();
            AbstractBurnerWorker.received(subSequence.toString());
        }
        if (temp.indexOf("[EOT](OK)") != -1) {
            return true;
        }
        if (temp.indexOf("[EOT](ERROR)") != -1) {
            AbstractBurnerWorker.returnError(Messages.ERROR_INFO_Failed_To_Execute_Command);
            return false;
        }
        receiveTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - receiveTime < 4000L) {
            if (this.uimonitor.isCanceled()) {
                this.sendBreak();
                this.handleCancel();
                return false;
            }
            temp = this.getCurReceived();
            if (temp.indexOf("[EOT](OK)") != -1) {
                return true;
            }
            if (temp.indexOf("[EOT](ERROR)") != -1) break;
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (temp.length() > offset) {
            length = temp.length();
            subSequence = temp.subSequence(offset, length);
            AbstractBurnerWorker.received(subSequence.toString());
        }
        boolean bl3 = hasError = temp.indexOf("ERROR") != -1 || temp.indexOf("[EOT](E") != -1;
        if (hasError) {
            AbstractBurnerWorker.returnError(Messages.ERROR_INFO_Failed_To_Execute_Command);
            return false;
        }
        throw new ReceiveTimeOutException("Send command timeout : " + timeout);
    }

    protected boolean sendCmdByTrans(String command, int timeout) throws IOException {
        boolean isUdp;
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        boolean isUSB = transferWay == TransferWay.USBBootrom || transferWay == TransferWay.USBNonNude || transferWay == TransferWay.UsbAndSerial || transferWay == TransferWay.GPT;
        boolean isJTAG = transferWay == TransferWay.JTAGAndNet || transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndSerial;
        boolean bl = isUdp = transferWay == TransferWay.UDP && ToolUtils.isCmdLine();
        if (isUSB) {
            byte[] cmdFrame = null;
            cmdFrame = transferWay == TransferWay.UsbAndSerial || FastbootView.isSupportUsbNonNude(transferWay) || transferWay == TransferWay.GPT ? command.getBytes(System.getProperty("file.encoding")) : this.convertToByte(AbstractBurnerWorker.getUSBCommandFrame(command));
            if (ToolUtils.isDebugOn()) {
                StringBuilder sBuilder = new StringBuilder();
                sBuilder.append("To send command frame, send timeout=");
                sBuilder.append(TIMEOUT_SEND_FRAME / 1000);
                sBuilder.append("s, wait response timeout=" + AbstractBurnerWorker.getTimeFrameCommand());
                sBuilder.append("ms data is :");
                this.println(sBuilder.toString());
                this.outputHex(cmdFrame);
            }
            long curTimeout = TIMEOUT_SEND_FRAME;
            curTimeout = timeout < TIMEOUT_SEND_FRAME ? (long)TIMEOUT_SEND_FRAME : (long)timeout;
            boolean commandResult = this.sendUsbDataFrame(cmdFrame, curTimeout, this.burner.getBurnContext().getTransferWay());
            if (!commandResult) {
                if (ToolUtils.isDebugOn()) {
                    this.println("Failed to send command frame");
                }
                return false;
            }
        } else if (isJTAG && FastbootView.getJtagChipTypeByChipName() != LibJTAGByJNA.EJtagChipType.CJ3X1VXX5 && FastbootView.getJtagChipTypeByChipName() != LibJTAGByJNA.EJtagChipType.CJXX0VXX4) {
            AbstractBurnerWorker.deleteContent(jtagReceived);
            byte[] commandBytes = command.getBytes(System.getProperty("file.encoding"));
            boolean cmdResult = this.sendJtagCmd(commandBytes, timeout);
            if (!cmdResult) {
                this.println("Failed to send jtag command.");
                return false;
            }
        } else if (isUdp) {
            boolean cmdResult = this.sendUdpCmd(command, timeout);
            if (!cmdResult) {
                if (ToolUtils.isDebugOn()) {
                    this.println("Failed to send command frame");
                }
                return false;
            }
        } else if (!this.serialCommand(command, timeout)) {
            return false;
        }
        return true;
    }

    protected boolean serialCommandFastboot(String command, int timeOut) throws IOException {
        if (!CommonBurner.isSocketTransfer) {
            AbstractBurnerWorker.deleteContent(serialReceived);
            AbstractBurnerWorker.deleteContent(i2csReceived);
            AbstractBurnerWorker.deleteContent(usbsReceived);
            AbstractBurnerWorker.deleteContent(jtagReceived);
            AbstractBurnerWorker.deleteContent(serialReceived);
            return CallLibBootromWorker.SendDataNoReply(CallLibBootromWorker.getComFd(), command, command.length());
        }
        return this.serialCommand(command, timeOut);
    }

    protected boolean serialCommand(String command, int timeOut) throws IOException {
        boolean commandFrame;
        boolean commandHeadFrame;
        boolean isSerial;
        AbstractBurnerWorker.deleteContent(serialReceived);
        AbstractBurnerWorker.deleteContent(i2csReceived);
        AbstractBurnerWorker.deleteContent(usbsReceived);
        AbstractBurnerWorker.deleteContent(jtagReceived);
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        boolean bl = isSerial = transferWay == TransferWay.Net || transferWay == TransferWay.Serial || transferWay == TransferWay.NetNonNude || transferWay == TransferWay.Uart2Compress || transferWay == TransferWay.UsbAndSerial;
        if (isSerial && !CommonBurner.isSocketTransfer) {
            boolean commandFrame2 = CallLibBootromWorker.SendData(CallLibBootromWorker.getComFd(), command, command.length(), timeOut);
            if (!commandFrame2) {
                this.println("Failed to send command frame");
                return false;
            }
            return true;
        }
        byte[] headFrame = this.convertToByte(AbstractBurnerWorker.getCommandHeadFrame(command));
        if (ToolUtils.isDebugOn()) {
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append("To send command head frame, send timeout=");
            sBuilder.append(TIMEOUT_SEND_FRAME / 1000);
            sBuilder.append("s, wait response timeout=" + AbstractBurnerWorker.getTimeFrameCommand());
            sBuilder.append("ms data is :");
            this.println(sBuilder.toString());
            this.outputHex(headFrame);
        }
        if (!(commandHeadFrame = this.sendFrame(headFrame, TIMEOUT_SEND_FRAME, AbstractBurnerWorker.getTimeFrameCommand()))) {
            this.println("Failed to send command head frame");
            return false;
        }
        AbstractBurnerWorker.deleteContent(serialReceived);
        byte[] cmdFrame = this.convertToByte(AbstractBurnerWorker.getCommandFrame(command));
        if (ToolUtils.isDebugOn()) {
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append("To send command frame, send timeout=");
            sBuilder.append(TIMEOUT_SEND_FRAME / 1000);
            sBuilder.append("s, wait response timeout=" + AbstractBurnerWorker.getTimeFrameCommand());
            sBuilder.append("ms data is :");
            this.println(sBuilder.toString());
            this.outputHex(cmdFrame);
        }
        if (!(commandFrame = this.sendFrame(cmdFrame, TIMEOUT_SEND_FRAME, AbstractBurnerWorker.getTimeFrameCommand()))) {
            this.println("Failed to send command frame");
            return false;
        }
        return true;
    }

    public String getCurUsbCommonReceived() {
        boolean isUSB;
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        boolean bl = isUSB = transferWay == TransferWay.USBBootrom || transferWay == TransferWay.USBNonNude || transferWay == TransferWay.UsbAndSerial;
        if (isUSB) {
            return usbsReceived.toString();
        }
        return null;
    }

    public void createFileForRecvSerial() {
        block33: {
            String filePath = FileUtils.toAbsolutePath(SERIAL_LOG_FILE);
            FileOutputStream fileOutputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            BufferedWriter bufferedWriter = null;
            try {
                try {
                    fileOutputStream = new FileOutputStream(filePath, true);
                    outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, System.getProperty("file.encoding"));
                    bufferedWriter = new BufferedWriter(outputStreamWriter);
                    for (String line : usbSerialReceived) {
                        bufferedWriter.append(line);
                        bufferedWriter.newLine();
                    }
                }
                catch (IOException iOException) {
                    usbSerialReceived.clear();
                    if (bufferedWriter != null) {
                        try {
                            bufferedWriter.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    if (outputStreamWriter != null) {
                        try {
                            outputStreamWriter.close();
                        }
                        catch (IOException iOException3) {}
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException4) {}
                    }
                    break block33;
                }
            }
            catch (Throwable throwable) {
                usbSerialReceived.clear();
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {}
                }
                if (outputStreamWriter != null) {
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            usbSerialReceived.clear();
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getCurReceived() {
        boolean isJTAG;
        StringBuilder temp = new StringBuilder();
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        boolean isI2C = transferWay == TransferWay.I2CBootrom;
        boolean isUSB = transferWay == TransferWay.USBBootrom || transferWay == TransferWay.USBNonNude || transferWay == TransferWay.UsbAndSerial;
        boolean bl = isJTAG = transferWay == TransferWay.JTAGAndNet || transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndSerial;
        if (isI2C) {
            try {
                this.receiveBytesByI2c(i2csReceived, 1024);
                if (i2csReceived.toString() != null && !i2csReceived.toString().isEmpty()) {
                    temp.append(i2csReceived.toString());
                }
            }
            catch (IOException iOException) {}
        } else if (isUSB) {
            try {
                this.receiveBytesByUsbIgnore(usbsReceived, 1024, transferWay);
                if (usbsReceived.toString() != null && !usbsReceived.toString().isEmpty()) {
                    temp.append(usbsReceived.toString());
                    if ((transferWay == TransferWay.USBBootrom || transferWay == TransferWay.USBNonNude && !FastbootView.isCJ309V100_CA_N_Series()) && temp.length() > 0) {
                        temp.deleteCharAt(0);
                    }
                }
                if (transferWay == TransferWay.UsbAndSerial) {
                    StringBuilder serialTemp = new StringBuilder();
                    this.receiveBytes(serialTemp, 4096);
                    usbSerialReceived.add(serialTemp.toString());
                }
            }
            catch (IOException iOException) {}
        } else {
            if (isJTAG && FastbootView.getJtagChipTypeByChipName() != LibJTAGByJNA.EJtagChipType.CJ3X1VXX5 && FastbootView.getJtagChipTypeByChipName() != LibJTAGByJNA.EJtagChipType.CJXX0VXX4) {
                return jtagReceived.toString();
            }
            if (transferWay == TransferWay.UDP) {
                AbstractBurnerWorker.deleteContent(udpReceived);
                this.receiveBytesByUdp(udpReceived, 1024);
                if (udpReceived.toString() != null && !udpReceived.toString().isEmpty()) {
                    temp.append(udpReceived.toString());
                }
            } else {
                return this.getCurSerialReceived();
            }
        }
        return temp.toString();
    }

    private String getCurSerialReceived() {
        block4: {
            if (CommonBurner.isSocketTransfer) {
                this.onAdataAvailableStr();
            } else {
                try {
                    this.receiveBytesBySerial(serialReceived, 4096);
                }
                catch (IOException e) {
                    if (!ToolUtils.isDebugOn()) break block4;
                    this.println("io exception occurs while receiving data :" + e.getMessage());
                }
            }
        }
        return serialReceived.toString();
    }

    protected boolean sendTFTPCommand(String tftpcommand, int totalTimeout, int receiveTime) throws IOException, ReceiveTimeOutException {
        boolean isJTAG;
        String losingPackageCheck = null;
        boolean isTftpLostEnable = false;
        int n = 0;
        if (ToolUtils.isCmdLine()) {
            isTftpLostEnable = PreferenceConfig.isTftpLostEnable();
            n = PreferenceConfig.getTftpLostCount();
        } else {
            isTftpLostEnable = FastbootPreferences.isTftpIgnoreBlockAck();
            n = FastbootPreferences.getInt("vendor.burn.tftp.losingpackage.count");
        }
        if (isTftpLostEnable) {
            StringBuilder sb = new StringBuilder();
            while (n > 0) {
                sb.append("T ");
                --n;
            }
            losingPackageCheck = sb.toString();
            this.println("losingPackageCheck=\t'" + losingPackageCheck + "'");
        }
        AbstractBurnerWorker.deleteContent(serialReceived);
        AbstractBurnerWorker.deleteContent(i2csReceived);
        AbstractBurnerWorker.deleteContent(usbsReceived);
        AbstractBurnerWorker.deleteContent(jtagReceived);
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        boolean bl = isJTAG = transferWay == TransferWay.JTAGAndNet || transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndSerial;
        if (isJTAG && FastbootView.getJtagChipTypeByChipName() != LibJTAGByJNA.EJtagChipType.CJ3X1VXX5 && FastbootView.getJtagChipTypeByChipName() != LibJTAGByJNA.EJtagChipType.CJXX0VXX4) {
            this.infoln("\nSend command:\t" + tftpcommand);
            if (ToolUtils.isDebugOn()) {
                this.println("\nIf your boot is not the lastest one, \nthere may be non-answer from board during executing command.\nPlease be patient for waiting.\nThe total time may be :\t" + totalTimeout / 1000 + "s, receiveTimeout is " + receiveTime / 1000 + "s");
            }
            AbstractBurnerWorker.deleteContent(jtagReceived);
            byte[] commandBytes = tftpcommand.getBytes(System.getProperty("file.encoding"));
            boolean cmdResult = this.sendJtagCmd(commandBytes, totalTimeout);
            if (!cmdResult) {
                this.println("Failed to send jtag tftp command.");
                return false;
            }
        } else {
            boolean isSerial;
            AbstractBurnerWorker.deleteContent(serialReceived);
            AbstractBurnerWorker.deleteContent(i2csReceived);
            AbstractBurnerWorker.deleteContent(usbsReceived);
            AbstractBurnerWorker.deleteContent(jtagReceived);
            boolean isCommand = this.sendCommand(tftpcommand, totalTimeout);
            if (!isCommand) {
                this.println("Failed to send tftp command.");
                return false;
            }
            boolean bl2 = isSerial = transferWay == TransferWay.Net || transferWay == TransferWay.NetNonNude || transferWay == TransferWay.Uart2Compress || transferWay == TransferWay.JTAGAndSerial;
            if (isSerial) {
                return true;
            }
        }
        boolean reading = true;
        long start = System.currentTimeMillis();
        String temp = this.getCurReceived();
        int offset = 0;
        String subSequence = null;
        while (reading) {
            boolean handleCancel;
            if (this.uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
                return false;
            }
            if (System.currentTimeMillis() - start > (long)totalTimeout) {
                return this.checkTimeout(tftpcommand, totalTimeout);
            }
            temp = this.getCurReceived();
            if (temp.length() > offset) {
                start = System.currentTimeMillis();
                int length = temp.length();
                subSequence = temp.subSequence(offset, length).toString();
                offset += subSequence.length();
                if (subSequence.startsWith("#", 0)) {
                    AbstractBurnerWorker.received("#");
                    this.updateTftpLightToNormal();
                }
                if (subSequence.startsWith("T", 0)) {
                    this.updateTftpLightToAbnormal();
                }
                AbstractBurnerWorker.received(subSequence);
                if (subSequence.indexOf("#") != -1) {
                    start = System.currentTimeMillis();
                }
                if (temp.indexOf("ARP Retry count exceeded") != -1) {
                    totalTimeout = receiveTime;
                }
                if (temp.indexOf("######") != -1) {
                    totalTimeout = receiveTime;
                }
            }
            if (temp.indexOf("[EOT]") != -1) break;
        }
        return this.checkSendTftpCmdReturn(temp, offset, totalTimeout);
    }

    private boolean checkSendTftpCmdReturn(String temp, int offset, long totalTimeout) throws IOException {
        boolean result;
        if (temp.indexOf("[EOT](OK)") != -1) {
            return true;
        }
        if (temp.indexOf("[EOT](ERROR)") != -1) {
            AbstractBurnerWorker.returnError(Messages.ERROR_INFO_Failed_To_Execute_Command);
            return false;
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            if (this.uimonitor.isCanceled()) {
                this.sendBreak();
                this.handleCancel();
                return false;
            }
            temp = this.getCurReceived();
            if (temp.indexOf("[EOT](OK)") != -1) {
                return true;
            }
            if (temp.indexOf("[EOT](ERROR)") == -1) continue;
            AbstractBurnerWorker.returnError(Messages.ERROR_INFO_Failed_To_Execute_Command);
            return false;
        }
        boolean bl = result = temp.indexOf("[EOT](OK)") == -1 && temp.indexOf("[EOT](O") != -1 || temp.indexOf("[EOT](ERROR)") == -1 && temp.indexOf("[EOT](E") != -1;
        if (result) {
            start = System.currentTimeMillis();
            while (temp.indexOf("[EOT](OK)") == -1 && temp.indexOf("[EOT](ERROR)") == -1 && System.currentTimeMillis() - start < 1000L) {
                if (this.uimonitor.isCanceled()) {
                    this.sendBreak();
                    this.handleCancel();
                    return false;
                }
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {}
                temp = this.getCurReceived();
            }
        }
        if ((temp = this.getCurReceived()).length() > offset) {
            int length = temp.length();
            String subSequence = temp.subSequence(offset, length).toString();
            AbstractBurnerWorker.received(subSequence);
        }
        if (temp.indexOf("ERROR") != -1 || temp.indexOf("[EOT](E") != -1) {
            AbstractBurnerWorker.returnError(Messages.ERROR_INFO_Failed_To_Execute_Command);
            return false;
        }
        if (temp.indexOf("[EOT](OK)") != -1) {
            return true;
        }
        try {
            throw new ReceiveTimeOutException("Send command timeout : " + totalTimeout);
        }
        catch (ReceiveTimeOutException receiveTimeOutException) {
            return false;
        }
    }

    private boolean checkTimeout(String tftpcommand, long totalTimeout) throws ReceiveTimeOutException {
        boolean loadOrUplo;
        StringBuilder sb = new StringBuilder(Messages.ERROR_INFO_Failed_To_Execute_TFTPCommand);
        sb.append("(").append(tftpcommand);
        if (ToolUtils.isDebugOn()) {
            sb.append("\ttimeout=").append(totalTimeout / 1000L).append("s");
        }
        sb.append(")");
        if (ToolUtils.isDebugOn()) {
            this.println(sb.toString());
        }
        boolean bl = loadOrUplo = tftpcommand.startsWith("load") || tftpcommand.startsWith("uplo");
        if (loadOrUplo) {
            return true;
        }
        this.updateTftpLightToAbnormal();
        throw new ReceiveTimeOutException(sb.toString());
    }

    private void updateTftpLightToAbnormal() {
        if (UnknownDevice.isOpenLightDebug() && lightCurrentStateMap.get(Light_E.TFTP.name()).equals(Light_State_E.normal.ordinal())) {
            lightCurrentStateMap.put(Light_E.TFTP.name(), Light_State_E.abnormal.ordinal());
            if (AbstractBurnerWorker.getLightView() != null) {
                AbstractBurnerWorker.updateLightColor(AbstractBurnerWorker.getLightView().getTftplbl(), lightCurrentStateMap.get(Light_E.TFTP.name()));
            }
        }
    }

    private void updateTftpLightToNormal() {
        if (UnknownDevice.isOpenLightDebug() && !lightCurrentStateMap.get(Light_E.TFTP.name()).equals(Light_State_E.normal.ordinal())) {
            lightCurrentStateMap.put(Light_E.TFTP.name(), Light_State_E.normal.ordinal());
            if (AbstractBurnerWorker.getLightView() != null) {
                AbstractBurnerWorker.updateLightColor(AbstractBurnerWorker.getLightView().getTftplbl(), lightCurrentStateMap.get(Light_E.TFTP.name()));
            }
        }
    }

    public int socketReceiveBytes(StringBuilder buffer, int length) throws IOException {
        assert (buffer != null);
        byte[] bytes = new byte[length];
        if (SOCKET_IN != null && SOCKET_IN.available() > 0) {
            int read = SOCKET_IN.read(bytes, 0, length);
            int i = 0;
            while (i < read) {
                buffer.append((char)bytes[0]);
                ++i;
            }
            return read;
        }
        return 0;
    }

    public void receiveBytesStr(StringBuilder buffer, int length) throws IOException {
        assert (buffer != null);
        byte[] bytes = new byte[length];
        if (CommonBurner.isSocketTransfer) {
            while (SOCKET_IN != null && SOCKET_IN.available() > 0) {
                int read = SOCKET_IN.read(bytes);
                int i = 0;
                while (i < read) {
                    char data = (char)bytes[i];
                    if (buffer != null) {
                        buffer.append(data);
                    }
                    ++i;
                }
            }
        }
    }

    public int receiveBytes(StringBuilder buffer, int length) throws IOException {
        assert (buffer != null);
        byte[] bytes = new byte[length];
        if (CommonBurner.isSocketTransfer) {
            if (SOCKET_IN != null && SOCKET_IN.available() > 0) {
                int read = SOCKET_IN.read(bytes, 0, length);
                int i = 0;
                while (i < read) {
                    buffer.append((char)bytes[i]);
                    ++i;
                }
                return read;
            }
        } else {
            boolean result = CallLibBootromWorker.RecevieBytes(CallLibBootromWorker.getComFd(), bytes, length);
            if (result) {
                int i = 0;
                while (i < bytes.length) {
                    if (bytes[i] != 0) {
                        buffer.append((char)bytes[i]);
                    }
                    ++i;
                }
                return length;
            }
            if (ToolUtils.isDebugOn()) {
                this.println("serial receive datas:" + new String(bytes, Charset.defaultCharset()));
            }
        }
        return 0;
    }

    public boolean receiveBytesByI2c(StringBuilder buffer, int length) throws IOException {
        assert (buffer != null);
        byte[] bytes = new byte[length];
        boolean result = I2cCommand.sendI2cCmdForBootrom(0, null, length, bytes, 0, this);
        if (result) {
            int i = 0;
            while (i < bytes.length) {
                if (bytes[i] != 0) {
                    buffer.append((char)bytes[i]);
                }
                ++i;
            }
        }
        return result;
    }

    private int receiveBytesByUdp(StringBuilder buffer, int length) {
        byte[] bytes = new byte[length];
        int recvLen = CallLibBootromWorker.UdpRecevieData(bytes, length);
        int i = 0;
        while (i < recvLen) {
            if (bytes[i] != 0) {
                buffer.append((char)bytes[i]);
            }
            ++i;
        }
        return recvLen;
    }

    public boolean receiveBytesByUsb(StringBuilder buffer, int length, TransferWay transferWay) throws IOException {
        assert (buffer != null);
        byte[] bytes = new byte[length];
        boolean result = CallLibUSBWorker.recvDataUsb(bytes, length, transferWay);
        if (result) {
            int i = 0;
            while (i < bytes.length) {
                if (bytes[i] != 0) {
                    buffer.append((char)bytes[i]);
                }
                ++i;
            }
        }
        return result;
    }

    public int receiveBytesByUsbIgnore(StringBuilder buffer, int length, TransferWay transferWay) throws IOException {
        assert (buffer != null);
        byte[] bytes = new byte[length];
        int recvLen = CallLibUSBWorker.recvDataUsbIgnore(bytes, length, transferWay);
        int i = 0;
        while (i < recvLen) {
            if (bytes[i] != 0) {
                buffer.append((char)bytes[i]);
            }
            ++i;
        }
        return recvLen;
    }

    public int sendBytes(byte[] pBuffer) throws IOException {
        assert (pBuffer != null);
        if (CommonBurner.isSocketTransfer) {
            SOCKET_OUT.write(pBuffer);
            SOCKET_OUT.flush();
        } else {
            boolean result = CallLibBootromWorker.SendBytes(CallLibBootromWorker.getComFd(), pBuffer, pBuffer.length);
            if (!result) {
                return 0;
            }
        }
        return pBuffer.length;
    }

    public final void onSocketAdataAvailable(StringBuilder currrent) {
        block5: {
            byte[] bytes = new byte[1024];
            try {
                while (SOCKET_IN.available() > 0) {
                    int read = SOCKET_IN.read(bytes);
                    int i = 0;
                    while (i < read) {
                        char c = (char)bytes[i];
                        if (currrent != null) {
                            currrent.append(c);
                        }
                        ++i;
                    }
                }
            }
            catch (IOException e) {
                if (!ToolUtils.isDebugOn()) break block5;
                this.println("io exception occurs while receiving data :" + e.getMessage());
            }
        }
    }

    public final void onAdataAvailableStr() {
        block2: {
            try {
                this.receiveBytesStr(serialReceived, 4096);
            }
            catch (IOException e) {
                if (!ToolUtils.isDebugOn()) break block2;
                this.println("io exception occurs while receiving data :" + e.getMessage());
            }
        }
    }

    public final void onAdataAvailable(StringBuilder curReceived) {
        block2: {
            try {
                this.receiveBytes(curReceived, 4096);
            }
            catch (IOException e) {
                if (!ToolUtils.isDebugOn()) break block2;
                this.println("io exception occurs while receiving data :" + e.getMessage());
            }
        }
    }

    public boolean receiveBytesBySerial(StringBuilder buffer, int length) throws IOException {
        assert (buffer != null);
        byte[] bytes = new byte[length];
        boolean result = CallLibBootromWorker.RecevieData(CallLibBootromWorker.getComFd(), bytes, length);
        if (result) {
            int i = 0;
            while (i < bytes.length) {
                if (bytes[i] != 0) {
                    buffer.append((char)bytes[i]);
                }
                ++i;
            }
        }
        if (ToolUtils.isDebugOn()) {
            this.println("serial receive data :" + new String(bytes, Charset.defaultCharset()));
        }
        return result;
    }

    protected String getDDRFreeParam(String key, String received, TransferWay transferWay) {
        if (received == null) {
            return null;
        }
        String strDDRFreeSize = null;
        int startIndex = 0;
        int endIndex = 0;
        if (transferWay == TransferWay.UsbAndSerial || FastbootView.isCJ309V100_CA_N_Series() && transferWay == TransferWay.USBNonNude) {
            if (key.equalsIgnoreCase(BASE_ADDR)) {
                startIndex = received.lastIndexOf(")") + 1;
                if (-1 == startIndex) {
                    return strDDRFreeSize;
                }
                endIndex = received.indexOf(":", startIndex);
            } else {
                startIndex = received.lastIndexOf(":") + 1;
                if (-1 == startIndex) {
                    return strDDRFreeSize;
                }
                endIndex = received.length();
            }
            if (-1 == endIndex) {
                return strDDRFreeSize;
            }
            strDDRFreeSize = received.substring(startIndex, endIndex);
        } else {
            startIndex = received.indexOf(key);
            if (-1 == startIndex) {
                return strDDRFreeSize;
            }
            endIndex = received.indexOf(" ", startIndex);
            if (-1 == endIndex && -1 == (endIndex = received.indexOf("\r\n", startIndex))) {
                return strDDRFreeSize;
            }
            strDDRFreeSize = received.substring(startIndex + key.length(), endIndex);
        }
        return strDDRFreeSize;
    }

    protected long parseLong(String strDDRFreeSize) {
        if (strDDRFreeSize == null) {
            return 0L;
        }
        if (strDDRFreeSize.startsWith("0x")) {
            strDDRFreeSize = strDDRFreeSize.substring(strDDRFreeSize.indexOf("0x") + "0x".length());
        }
        return Long.parseLong(strDDRFreeSize, 16);
    }

    protected String getDDRFreeParamBySerial() throws IOException, ReceiveTimeOutException {
        String chipType = FastbootView.getCurrentChipType();
        if (ProductLine.PRODUCTLINE.CAM.name().equalsIgnoreCase(chipType)) {
            return null;
        }
        INFOCommand ddrFreeCommand = INFOCommand.getDDRFree();
        if (this.sendCommandDontCareEOTBySerial(ddrFreeCommand.getCommand(), ddrFreeCommand.getTimeout())) {
            return this.getCurSerialReceived();
        }
        return null;
    }

    protected String getDDRFreeParam() throws IOException, ReceiveTimeOutException {
        String chipType = FastbootView.getCurrentChipType();
        if (ProductLine.PRODUCTLINE.CAM.name().equalsIgnoreCase(chipType)) {
            return null;
        }
        INFOCommand ddrFreeCommand = INFOCommand.getDDRFree();
        if (this.sendCommandDontCareEOT(ddrFreeCommand.getCommand(), ddrFreeCommand.getTimeout())) {
            return this.getCurReceived();
        }
        return null;
    }

    public boolean checkLastPartition(List<PartitionItem> parts) {
        long lastPartLen = this.getLastPartitionLength(parts);
        int size = parts.size();
        PartitionItem partition = parts.get(size - 1);
        if (partition.getLength() == -1L) {
            if (lastPartLen == -1L) {
                return false;
            }
            if (lastPartLen % 1024L != 0L) {
                if (!ToolUtils.isCmdLine()) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)NLS.bind((String)Messages.PartitionBurner_msg_Length_must_be_NK_times_that_is_should_be_with_unit_K_or_M_in_row_lastParitionLen, (Object)1024));
                        }
                    });
                } else {
                    Log.errorln(NLS.bind((String)Messages.PartitionBurner_msg_Length_must_be_NK_times_that_is_should_be_with_unit_K_or_M_in_row_lastParitionLen, (Object)1024));
                }
                return false;
            }
            if (0L == lastPartLen) {
                if (!ToolUtils.isCmdLine()) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)Messages.AbstractBurner_msg_the_partition_length_must_be_nonzero_in_row_lastPartitionLength);
                        }
                    });
                } else {
                    Log.errorln(Messages.AbstractBurner_msg_the_partition_length_must_be_nonzero_in_row_lastPartitionLength);
                }
                return false;
            }
            if (lastPartLen < 0L) {
                if (!ToolUtils.isCmdLine()) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)Messages.AbstractBurner_msg_the_partition_length_must_be_Less_than_zero_lastPartitionLength);
                        }
                    });
                } else {
                    Log.errorln(Messages.AbstractBurner_msg_the_partition_length_must_be_Less_than_zero_lastPartitionLength);
                }
                return false;
            }
            partition.setLength(lastPartLen);
        }
        return true;
    }

    public long getLastPartitionLength(final List<PartitionItem> parts) {
        this.lastLen = 0L;
        final int emmcType = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getEmmcType();
        final int size = parts.size();
        PartitionItem partition = parts.get(size - 1);
        long partitionLength = partition.getLength();
        final long start = partition.getStart();
        if (partitionLength == -1L) {
            if (ToolUtils.isCmdLine()) {
                System.out.println(Messages.Set_LastPartition_Length);
                String inputLenStr = AbstractBurnerWorker.readDataFromConsole(GET_LAST_LENGTH);
                long inputLen = WorkerUtility.ReceiveHelper.convertToNumber(inputLenStr);
                int nExtFormatCount = 0;
                int index = 0;
                while (index < size) {
                    PartitionItem par = parts.get(index);
                    FileSystem fileSystem = par.getFileSystem();
                    if (FileSystem.ext3 == fileSystem || fileSystem == FileSystem.f2fs || fileSystem == FileSystem.erofs) {
                        ++nExtFormatCount;
                    }
                    ++index;
                }
                long lastLen = 0L;
                lastLen = emmcType == PartitionBurnerWorker.EMMC_TYPE_E.EMMC_HAVE_MBR_TYPE.ordinal() ? inputLen - start - (long)(nExtFormatCount * 512) : inputLen - start;
                return lastLen;
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    InputDialog inputDialog = new InputDialog(Display.getDefault().getActiveShell(), Messages.Get_LastPartition_Length_In_MakeImage, Messages.Set_All_board_Length, "", null);
                    int open = inputDialog.open();
                    String inputValue = null;
                    if (open == 0) {
                        inputValue = inputDialog.getValue();
                    } else if (open == 1) {
                        AbstractBurnerWorker.this.lastLen = -1L;
                        return;
                    }
                    int nExtFormatCount = 0;
                    int index = 0;
                    while (index < size) {
                        PartitionItem par = (PartitionItem)parts.get(index);
                        FileSystem fileSystem = par.getFileSystem();
                        if (FileSystem.ext3 == fileSystem || fileSystem == FileSystem.f2fs || fileSystem == FileSystem.erofs) {
                            ++nExtFormatCount;
                        }
                        ++index;
                    }
                    long inputLen = WorkerUtility.ReceiveHelper.convertToNumber(inputValue);
                    AbstractBurnerWorker.this.lastLen = 0L;
                    if (emmcType == PartitionBurnerWorker.EMMC_TYPE_E.EMMC_HAVE_MBR_TYPE.ordinal()) {
                        AbstractBurnerWorker.this.lastLen = inputLen - start - (long)(nExtFormatCount * 512);
                    } else {
                        AbstractBurnerWorker.this.lastLen = inputLen - start;
                    }
                }
            });
        }
        return this.lastLen;
    }

    protected void readAuxAreaForLibBootrom(String recieved) {
        if (recieved.length() > 0 && !recieved.equalsIgnoreCase("(OK)") && ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) {
            if (recieved.toString().contains(HEAD_AREA_FORMAT_ERR)) {
                lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
                AbstractBurnerWorker.returnError(Messages.ERROR_INFO_HEAD_AREA_FORMAT_ERR);
                return;
            }
            if (recieved.toString().contains(VERIFY_KEY_AREA_FAILED)) {
                lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
                AbstractBurnerWorker.returnError(Messages.ERROR_INFO_VERIFY_KEY_AREA_FAILED);
                return;
            }
            if (recieved.toString().contains(AUX_AREA_FORMAT_ERR)) {
                lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
                AbstractBurnerWorker.returnError(Messages.ERROR_INFO_AUX_AREA_FORMAT_ERR);
                return;
            }
            if (recieved.toString().contains(VERIFY_AUX_CODE_FAILED)) {
                lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
                AbstractBurnerWorker.returnError(Messages.ERROR_INFO_VERIFY_AUX_CODE_FAILED);
                return;
            }
            if (recieved.toString().contains(VERIFY_AUX_AREA_FAILED)) {
                lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
                AbstractBurnerWorker.returnError(Messages.ERROR_INFO_VERIFY_AUX_AREA_FAILED);
                return;
            }
            if (recieved.toString().contains(VERIFY_PARAM_AREA_FAILED)) {
                lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
                AbstractBurnerWorker.returnError(Messages.ERROR_INFO_VERIFY_PARAM_AREA_FAILED);
                return;
            }
            if (recieved.toString().contains(PARAM_LEN_ERR)) {
                lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
                AbstractBurnerWorker.returnError(Messages.ERROR_INFO_PARAM_LEN_ERR);
                return;
            }
            if (recieved.toString().contains(AUX_CODE_EXEC_FAILED)) {
                lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
                AbstractBurnerWorker.returnError(Messages.ERROR_INFO_AUX_CODE_EXEC_FAILED);
                return;
            }
        }
    }

    protected void readBootromInfoNACK(String temp) {
        boolean needUpdateLight;
        boolean bl = needUpdateLight = UnknownDevice.isOpenLightDebug() && temp.length() > 0;
        if (needUpdateLight) {
            if (temp.contains(BOOTROM_START)) {
                AbstractBurnerWorker.received(BOOTROM_START);
                lightCurrentStateMap.put(Light_E.CPU.name(), Light_State_E.normal.ordinal());
            } else {
                lightCurrentStateMap.put(Light_E.SERIAL.name(), Light_State_E.abnormal.ordinal());
            }
            if (((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) {
                AbstractBurnerWorker.updateBootromForLib(temp);
            } else {
                AbstractBurnerWorker.updateLightNACK(temp);
            }
            lightCurrentStateMap.put(Light_E.BOOTROM.name(), Light_State_E.abnormal.ordinal());
            AbstractBurnerWorker.updateLightState();
        }
    }

    private static void updateLightNACK(String temp) {
        boolean checkFlash;
        if (temp.contains(BOOTROM_FROM_NAND)) {
            AbstractBurnerWorker.received(BOOTROM_FROM_NAND);
            AbstractBurnerWorker.updateBootFromLbl("Nand");
        }
        if (temp.contains(BOOTROM_FROM_EMMC)) {
            AbstractBurnerWorker.received(BOOTROM_FROM_EMMC);
            AbstractBurnerWorker.updateBootFromLbl("eMMC");
        }
        if (temp.contains(BOOTROM_FROM_SD)) {
            AbstractBurnerWorker.received(BOOTROM_FROM_SD);
            AbstractBurnerWorker.updateBootFromLbl("SD");
        }
        boolean bl = checkFlash = !temp.contains(BOOTROM_FROM_NAND) && !temp.contains(BOOTROM_FROM_EMMC) && !temp.contains(BOOTROM_FROM_SD);
        if (checkFlash) {
            lightCurrentStateMap.put(Light_E.BOOTROM.name(), Light_State_E.abnormal.ordinal());
        }
        if (temp.contains(BOOTROM_READ_EMMC_ERROR)) {
            AbstractBurnerWorker.received(BOOTROM_READ_EMMC_ERROR);
            lightCurrentStateMap.put(Light_E.READ_EMMC.name(), Light_State_E.abnormal.ordinal());
        } else {
            lightCurrentStateMap.put(Light_E.READ_EMMC.name(), Light_State_E.normal.ordinal());
        }
        if (temp.contains(BOOTROM_READ_SD_ERROR)) {
            AbstractBurnerWorker.received(BOOTROM_READ_SD_ERROR);
            lightCurrentStateMap.put(Light_E.READ_SD.name(), Light_State_E.abnormal.ordinal());
        } else {
            lightCurrentStateMap.put(Light_E.READ_SD.name(), Light_State_E.normal.ordinal());
        }
    }

    private static void updateBootromForLib(String temp) {
        if (temp.contains(BOOTROM_START)) {
            lightCurrentStateMap.put(Light_E.CPU.name(), Light_State_E.normal.ordinal());
        }
        if (temp.contains(BOOTROM_MEDIA_SPI)) {
            AbstractBurnerWorker.updateBootFromLbl("SPI");
        }
        if (temp.contains(BOOTROM_MEDIA_NAND)) {
            AbstractBurnerWorker.updateBootFromLbl("NAND");
        }
        if (temp.contains(BOOTROM_MEDIA_SD)) {
            AbstractBurnerWorker.updateBootFromLbl("SD");
        }
        if (temp.contains(BOOTROM_MEDIA_EMMC)) {
            AbstractBurnerWorker.updateBootFromLbl("eMMC");
        }
        if (temp.contains(EMMC_INIT_ERR)) {
            lightCurrentStateMap.put(Light_E.READ_EMMC.name(), Light_State_E.abnormal.ordinal());
        } else {
            lightCurrentStateMap.put(Light_E.READ_EMMC.name(), Light_State_E.normal.ordinal());
        }
        if (temp.contains(EMMC_READ_ERR)) {
            lightCurrentStateMap.put(Light_E.READ_EMMC.name(), Light_State_E.abnormal.ordinal());
        } else {
            lightCurrentStateMap.put(Light_E.READ_EMMC.name(), Light_State_E.normal.ordinal());
        }
        if (temp.contains(EMMC_NORMAL_READ_ERR)) {
            lightCurrentStateMap.put(Light_E.READ_EMMC.name(), Light_State_E.abnormal.ordinal());
        } else {
            lightCurrentStateMap.put(Light_E.READ_EMMC.name(), Light_State_E.normal.ordinal());
        }
        if (temp.contains(SD_INIT_ERR)) {
            lightCurrentStateMap.put(Light_E.READ_SD.name(), Light_State_E.abnormal.ordinal());
        } else {
            lightCurrentStateMap.put(Light_E.READ_SD.name(), Light_State_E.normal.ordinal());
        }
        if (temp.contains(SD_READ_ERR)) {
            lightCurrentStateMap.put(Light_E.READ_SD.name(), Light_State_E.abnormal.ordinal());
        } else {
            lightCurrentStateMap.put(Light_E.READ_SD.name(), Light_State_E.normal.ordinal());
        }
        if (temp.contains(SD_NORMAL_READ_ERR)) {
            lightCurrentStateMap.put(Light_E.READ_SD.name(), Light_State_E.abnormal.ordinal());
        } else {
            lightCurrentStateMap.put(Light_E.READ_SD.name(), Light_State_E.normal.ordinal());
        }
    }

    protected void readBootromInfoAck(String temp) {
        if (UnknownDevice.isOpenLightDebug()) {
            lightCurrentStateMap.put(Light_E.CPU.name(), Light_State_E.normal.ordinal());
            if (temp.length() > 0) {
                if (((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) {
                    AbstractBurnerWorker.updateBootromForLib(temp);
                } else {
                    AbstractBurnerWorker.updateBootromACK(temp);
                }
                AbstractBurnerWorker.deleteContent(serialReceived);
            } else {
                lightCurrentStateMap.put(Light_E.READ_EMMC.name(), Light_State_E.normal.ordinal());
                lightCurrentStateMap.put(Light_E.READ_SD.name(), Light_State_E.normal.ordinal());
            }
            lightCurrentStateMap.put(Light_E.BOOTROM.name(), Light_State_E.normal.ordinal());
            AbstractBurnerWorker.updateLightState();
        }
    }

    private static void updateBootromACK(String temp) {
        if (temp.contains(BOOTROM_START)) {
            AbstractBurnerWorker.receivedln(BOOTROM_START);
            lightCurrentStateMap.put(Light_E.CPU.name(), Light_State_E.normal.ordinal());
        }
        if (temp.contains(BOOTROM_FROM_NAND)) {
            AbstractBurnerWorker.receivedln(BOOTROM_FROM_NAND);
            AbstractBurnerWorker.updateBootFromLbl("NAND");
        }
        if (temp.contains(BOOTROM_FROM_EMMC)) {
            AbstractBurnerWorker.receivedln(BOOTROM_FROM_EMMC);
            AbstractBurnerWorker.updateBootFromLbl("eMMC");
        }
        if (temp.contains(BOOTROM_FROM_SD)) {
            AbstractBurnerWorker.receivedln(BOOTROM_FROM_SD);
            AbstractBurnerWorker.updateBootFromLbl("SD");
        }
        if (temp.contains(BOOTROM_READ_EMMC_ERROR)) {
            AbstractBurnerWorker.receivedln(BOOTROM_READ_EMMC_ERROR);
            lightCurrentStateMap.put(Light_E.READ_EMMC.name(), Light_State_E.abnormal.ordinal());
        } else {
            lightCurrentStateMap.put(Light_E.READ_EMMC.name(), Light_State_E.normal.ordinal());
        }
        if (temp.contains(BOOTROM_READ_SD_ERROR)) {
            AbstractBurnerWorker.receivedln(BOOTROM_READ_SD_ERROR);
            lightCurrentStateMap.put(Light_E.READ_SD.name(), Light_State_E.abnormal.ordinal());
        } else {
            lightCurrentStateMap.put(Light_E.READ_SD.name(), Light_State_E.normal.ordinal());
        }
    }

    protected void readBootromAndDDrNAck(String temp) {
        if (UnknownDevice.isOpenLightDebug()) {
            lightCurrentStateMap.put(Light_E.DDR_INIT.name(), Light_State_E.abnormal.ordinal());
            if (AbstractBurnerWorker.getLightView() != null) {
                AbstractBurnerWorker.updateLightColor(AbstractBurnerWorker.getLightView().getDdrInitLbl(), lightCurrentStateMap.get(Light_E.DDR_INIT.name()));
            }
            this.readDdrTrainingInfo(temp);
        }
    }

    protected void readBootromAndDDrAck(String temp) {
        if (UnknownDevice.isOpenLightDebug()) {
            lightCurrentStateMap.put(Light_E.DDR_INIT.name(), Light_State_E.normal.ordinal());
            if (lightView != null) {
                AbstractBurnerWorker.updateLightColor(lightView.getDdrInitLbl(), lightCurrentStateMap.get(Light_E.DDR_INIT.name()));
            }
            this.readDdrTrainingInfo(temp);
        }
    }

    protected void readDdrTrainingInfo(String temp) {
        if (temp.length() > 0 && !temp.equalsIgnoreCase("(OK)")) {
            if (((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) {
                AbstractBurnerWorker.supportLibBootrom(temp);
            } else {
                AbstractBurnerWorker.notSupportLibBootrom(temp);
            }
            if (lightCurrentStateMap.get(Light_E.DDR_TRAINING.name()).intValue() != Light_State_E.abnormal.ordinal()) {
                lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.normal.ordinal());
            }
        } else {
            lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.normal.ordinal());
        }
        AbstractBurnerWorker.updateLightState();
    }

    public static void notSupportLibBootrom(String temp) {
        if (temp.contains(DDRTRINING_SWL)) {
            lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
        }
        if (temp.contains(DDRTRINING_SGA)) {
            lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
        }
        if (temp.contains(DDRTRINING_HGA)) {
            lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
        }
        if (temp.contains(DDRTRINING_HRD)) {
            lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
        }
        if (temp.contains(DDRTRINING_SRD)) {
            lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
        }
        if (temp.contains(DDRTRINING_SWD)) {
            lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
        }
        if (temp.contains(DDRTRINING_DDR_FAILED)) {
            lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
        }
        if (temp.contains(DDR_DDRE)) {
            lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
        }
        if (temp.contains(DDR_DDRTR) && temp.contains(DDR_Err)) {
            lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
        }
    }

    public static void supportLibBootrom(String temp) {
        if (temp.contains(DDR_WL_ERR)) {
            lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
        }
        if (temp.contains(DDR_HWG_ERR)) {
            lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
        }
        if (temp.contains(DDR_GATE_ERR)) {
            lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
        }
        if (temp.contains(DDR_DDRT_ERR)) {
            lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
        }
        if (temp.contains(DDR_HWRD_ERR)) {
            lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
        }
        if (temp.contains(DDR_MPR_ERR)) {
            lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
        }
        if (temp.contains(DDR_DATAEYE_ERR)) {
            lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
        }
        if (temp.contains(DDR_DDRE)) {
            lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
        }
    }

    protected void outDdrTrainingInfo(String temp) {
        if (temp.length() > 0 && !temp.equalsIgnoreCase("(OK)")) {
            boolean isddrSuccess = true;
            if (((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) {
                if (temp.contains(DDR_WL_ERR)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDR_HWG_ERR)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDR_GATE_ERR)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDR_DDRT_ERR)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDR_HWRD_ERR)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDR_MPR_ERR)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDR_DATAEYE_ERR)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDR_DDRE)) {
                    isddrSuccess = false;
                }
            } else {
                if (temp.contains(DDRTRINING_SWL)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDRTRINING_SGA)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDRTRINING_HGA)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDRTRINING_HRD)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDRTRINING_SRD)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDRTRINING_SWD)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDRTRINING_DDR_FAILED)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDR_DDRE)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDR_DDRTR) && temp.contains(DDR_Err)) {
                    isddrSuccess = false;
                }
            }
            if (!isddrSuccess) {
                AbstractBurnerWorker.received(temp);
            }
        }
    }

    protected static void readBootInfo(String temp) {
        if (temp.length() > 0) {
            if (temp.contains(FASTBOOT_START)) {
                lightCurrentStateMap.put(Light_E.BOOTROM.name(), Light_State_E.normal.ordinal());
                lightCurrentStateMap.put(Light_E.FASTBOOT_START.name(), Light_State_E.normal.ordinal());
            }
            if (temp.contains(FASTBOOT_NO_CURRENT_START)) {
                lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
            } else {
                lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.normal.ordinal());
            }
            fastbootFromFlash = AbstractBurnerWorker.getBootFrom(temp);
            if (temp.contains(FASTBOOT_NO_NAND_FLASH)) {
                lightCurrentStateMap.put(Light_E.FLASH_NAND.name(), Light_State_E.warn.ordinal());
                if (fastbootFromFlash != null) {
                    if (fastbootFromFlash.equalsIgnoreCase("nand")) {
                        lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
                    } else {
                        lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.normal.ordinal());
                    }
                }
            } else if (temp.contains(FASTBOOT_HAVE_NAND_FLASH_MFCV100) || temp.contains(FASTBOOT_HAVE_NAND_FLASH_OTHER)) {
                lightCurrentStateMap.put(Light_E.FLASH_NAND.name(), Light_State_E.normal.ordinal());
                if (fastbootFromFlash != null && fastbootFromFlash.equalsIgnoreCase("emmc")) {
                    lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
                } else {
                    lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.normal.ordinal());
                }
            } else if (temp.contains("start download process.")) {
                lightCurrentStateMap.put(Light_E.FLASH_NAND.name(), Light_State_E.warn.ordinal());
            }
            if (temp.contains(FASTBOOT_NO_EMMC_FLASH)) {
                lightCurrentStateMap.put(Light_E.FLASH_EMMC.name(), Light_State_E.warn.ordinal());
                if (fastbootFromFlash != null) {
                    if (fastbootFromFlash.equalsIgnoreCase("emmc")) {
                        lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
                    } else {
                        lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.normal.ordinal());
                    }
                }
            } else if (temp.contains(FASTBOOT_HAVE_EMMC_FLASH)) {
                lightCurrentStateMap.put(Light_E.FLASH_EMMC.name(), Light_State_E.normal.ordinal());
                if (fastbootFromFlash != null && fastbootFromFlash.equalsIgnoreCase("nand")) {
                    lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
                } else {
                    lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.normal.ordinal());
                }
            } else if (temp.contains("start download process.")) {
                lightCurrentStateMap.put(Light_E.FLASH_EMMC.name(), Light_State_E.warn.ordinal());
            }
            AbstractBurnerWorker.updateLightState();
        }
    }

    protected static void updateLightState() {
        if (ToolUtils.isCmdLine()) {
            return;
        }
        if (AbstractBurnerWorker.getLightView() != null) {
            AbstractBurnerWorker.updateLightColor(AbstractBurnerWorker.getLightView().getSerialLbl(), lightCurrentStateMap.get(Light_E.SERIAL.name()));
            AbstractBurnerWorker.updateLightColor(AbstractBurnerWorker.getLightView().getCpuLbl(), lightCurrentStateMap.get(Light_E.CPU.name()));
            AbstractBurnerWorker.updateLightColor(AbstractBurnerWorker.getLightView().getBootromLbl(), lightCurrentStateMap.get(Light_E.BOOTROM.name()));
            AbstractBurnerWorker.updateLightColor(AbstractBurnerWorker.getLightView().getReadEmmcLbl(), lightCurrentStateMap.get(Light_E.READ_EMMC.name()));
            AbstractBurnerWorker.updateLightColor(AbstractBurnerWorker.getLightView().getReadSDLbl(), lightCurrentStateMap.get(Light_E.READ_SD.name()));
            AbstractBurnerWorker.updateLightColor(AbstractBurnerWorker.getLightView().getDdrInitLbl(), lightCurrentStateMap.get(Light_E.DDR_INIT.name()));
            AbstractBurnerWorker.updateLightColor(AbstractBurnerWorker.getLightView().getDdrTrainingLbl(), lightCurrentStateMap.get(Light_E.DDR_TRAINING.name()));
            AbstractBurnerWorker.updateLightColor(AbstractBurnerWorker.getLightView().getFastbootStartLbl(), lightCurrentStateMap.get(Light_E.FASTBOOT_START.name()));
            AbstractBurnerWorker.updateLightColor(AbstractBurnerWorker.getLightView().getFlashTypeMatchLbl(), lightCurrentStateMap.get(Light_E.FLASH_AND_IMAGE_MATCH.name()));
            AbstractBurnerWorker.updateLightColor(AbstractBurnerWorker.getLightView().getEmmcFlash(), lightCurrentStateMap.get(Light_E.FLASH_EMMC.name()));
            AbstractBurnerWorker.updateLightColor(AbstractBurnerWorker.getLightView().getNandFlash(), lightCurrentStateMap.get(Light_E.FLASH_NAND.name()));
        }
    }

    protected static void updateSerialLightToError() {
        if (ToolUtils.isCmdLine()) {
            return;
        }
        if (UnknownDevice.isOpenLightDebug()) {
            lightCurrentStateMap.put(Light_E.SERIAL.name(), Light_State_E.abnormal.ordinal());
            if (AbstractBurnerWorker.getLightView() != null) {
                AbstractBurnerWorker.updateLightColor(AbstractBurnerWorker.getLightView().getSerialLbl(), lightCurrentStateMap.get(Light_E.SERIAL.name()));
            }
        }
    }

    protected static void updateSerialLightToRight() {
        if (ToolUtils.isCmdLine()) {
            return;
        }
        if (UnknownDevice.isOpenLightDebug()) {
            lightCurrentStateMap.put(Light_E.SERIAL.name(), Light_State_E.normal.ordinal());
            if (AbstractBurnerWorker.getLightView() != null) {
                AbstractBurnerWorker.updateLightColor(AbstractBurnerWorker.getLightView().getSerialLbl(), lightCurrentStateMap.get(Light_E.SERIAL.name()));
            }
        }
    }

    protected void initLightState() {
        if (ToolUtils.isCmdLine()) {
            return;
        }
        if (view != null && view instanceof LightView) {
            LightView lightView = (LightView)view;
            lightCurrentStateMap.put(Light_E.SERIAL.name(), Light_State_E.init.ordinal());
            lightCurrentStateMap.put(Light_E.CPU.name(), Light_State_E.init.ordinal());
            lightCurrentStateMap.put(Light_E.BOOTROM.name(), Light_State_E.init.ordinal());
            lightCurrentStateMap.put(Light_E.READ_EMMC.name(), Light_State_E.init.ordinal());
            lightCurrentStateMap.put(Light_E.READ_SD.name(), Light_State_E.init.ordinal());
            lightCurrentStateMap.put(Light_E.DDR_INIT.name(), Light_State_E.init.ordinal());
            lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.init.ordinal());
            lightCurrentStateMap.put(Light_E.FASTBOOT_START.name(), Light_State_E.init.ordinal());
            lightCurrentStateMap.put(Light_E.FLASH_NAND.name(), Light_State_E.init.ordinal());
            lightCurrentStateMap.put(Light_E.FLASH_EMMC.name(), Light_State_E.init.ordinal());
            lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.init.ordinal());
            lightCurrentStateMap.put(Light_E.TFTP.name(), Light_State_E.init.ordinal());
            AbstractBurnerWorker.updateLightColor(lightView.getSerialLbl(), lightCurrentStateMap.get(Light_E.SERIAL.name()));
            AbstractBurnerWorker.updateLightColor(lightView.getCpuLbl(), lightCurrentStateMap.get(Light_E.CPU.name()));
            AbstractBurnerWorker.updateLightColor(lightView.getBootromLbl(), lightCurrentStateMap.get(Light_E.BOOTROM.name()));
            AbstractBurnerWorker.updateLightColor(lightView.getReadEmmcLbl(), lightCurrentStateMap.get(Light_E.READ_EMMC.name()));
            AbstractBurnerWorker.updateLightColor(lightView.getReadSDLbl(), lightCurrentStateMap.get(Light_E.READ_SD.name()));
            AbstractBurnerWorker.updateLightColor(lightView.getDdrInitLbl(), lightCurrentStateMap.get(Light_E.DDR_INIT.name()));
            AbstractBurnerWorker.updateLightColor(lightView.getDdrTrainingLbl(), lightCurrentStateMap.get(Light_E.DDR_TRAINING.name()));
            AbstractBurnerWorker.updateLightColor(lightView.getFastbootStartLbl(), lightCurrentStateMap.get(Light_E.FASTBOOT_START.name()));
            AbstractBurnerWorker.updateLightColor(lightView.getFlashTypeMatchLbl(), lightCurrentStateMap.get(Light_E.FLASH_AND_IMAGE_MATCH.name()));
            AbstractBurnerWorker.updateLightColor(lightView.getEmmcFlash(), lightCurrentStateMap.get(Light_E.FLASH_EMMC.name()));
            AbstractBurnerWorker.updateLightColor(lightView.getNandFlash(), lightCurrentStateMap.get(Light_E.FLASH_NAND.name()));
            AbstractBurnerWorker.updateLightColor(lightView.getTftplbl(), lightCurrentStateMap.get(Light_E.TFTP.name()));
        }
    }

    protected static void updateBootFromLbl(final String bootFromFlash) {
        if (ToolUtils.isCmdLine()) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                AbstractBurnerWorker.getLightView().getBootFromLbl().setText(String.valueOf(Messages.LightView_BootFrom) + " " + bootFromFlash);
                AbstractBurnerWorker.getLightView().getBootFromLbl().redraw();
                AbstractBurnerWorker.getLightView().getComposite().layout();
            }
        });
    }

    protected void updateCaTypeLbl(final String caType) {
        if (ToolUtils.isCmdLine()) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (AbstractBurnerWorker.getLightView() != null) {
                    if (AbstractBurnerWorker.getLightView().getCaTypeLbl() != null) {
                        AbstractBurnerWorker.getLightView().getCaTypeLbl().setText(String.valueOf(Messages.LightView_CAType) + " " + caType);
                        AbstractBurnerWorker.getLightView().getCaTypeLbl().redraw();
                    }
                    if (AbstractBurnerWorker.getLightView().getComposite() != null && !lightView.getComposite().isDisposed()) {
                        AbstractBurnerWorker.getLightView().getComposite().layout();
                    }
                }
            }
        });
    }

    protected static void updateLightColor(final ImageHyperlink imageHyperlink, int lightState) {
        if (ToolUtils.isCmdLine()) {
            return;
        }
        switch (lightState) {
            case 0: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        imageHyperlink.setImage(Activator.getImage("icons/white_light.png"));
                        imageHyperlink.redraw();
                    }
                });
                break;
            }
            case 1: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        imageHyperlink.setImage(Activator.getImage("icons/green_light.png"));
                        imageHyperlink.redraw();
                    }
                });
                break;
            }
            case 2: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        imageHyperlink.setImage(Activator.getImage("icons/red_light.png"));
                        imageHyperlink.redraw();
                    }
                });
                break;
            }
            case 3: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        imageHyperlink.setImage(Activator.getImage("icons/yellow_light.png"));
                        imageHyperlink.redraw();
                    }
                });
                break;
            }
            default: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        imageHyperlink.setImage(Activator.getImage("icons/white_light.png"));
                        imageHyperlink.redraw();
                    }
                });
            }
        }
    }

    protected boolean isPage() {
        UnknownDevice unknownDevice;
        String nandAlignmentType;
        return this.burner.getBurnContext().getDeviceSetting() instanceof UnknownDevice && (nandAlignmentType = (unknownDevice = (UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getNandAlignmentType()) != null && nandAlignmentType.equalsIgnoreCase("PAGE");
    }

    protected void registerJnaFunction(IProgressMonitor uimonitor, int totalWork) {
        SubMonitor subProgressMonitor = SubMonitor.convert((IProgressMonitor)uimonitor, (String)"", (int)totalWork);
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        if (ToolUtils.isJTagTransferMode(this.burner.getBurnContext().getTransferWay())) {
            new CallLibJTAGWorker(this.frameSetting, this.burner, subProgressMonitor);
            LibJTAGByJNA.instance.jtag_RegisterPrint(CallLibJTAGWorker.JTAGPRINTINFOCALLBACK);
            LibJTAGByJNA.instance.jtag_RegisterCancel(CallLibJTAGWorker.CANCELCALLBACK);
        } else if (transferWay == TransferWay.UsbAndSerial || FastbootView.isSupportUsbNonNude(transferWay)) {
            new CallLibUSBWorker(this.frameSetting, this.burner, subProgressMonitor);
        }
    }

    public FlashType getFlashType() {
        return this.flashType;
    }

    public void setFlashType(FlashType flashType) {
        this.flashType = flashType;
    }

    public static InputStream getSOCKET_IN() {
        return SOCKET_IN;
    }

    public static void setSOCKET_IN(InputStream sOCKET_IN) {
        SOCKET_IN = sOCKET_IN;
    }

    public static OutputStream getSOCKET_OUT() {
        return SOCKET_OUT;
    }

    public static void setSOCKET_OUT(OutputStream sOCKET_OUT) {
        SOCKET_OUT = sOCKET_OUT;
    }

    public static IFastbootProgressMonitor getMonitor() {
        return monitor;
    }

    public static void setMonitor(IFastbootProgressMonitor monitor) {
        AbstractBurnerWorker.monitor = monitor;
    }

    public static LightView getLightView() {
        return lightView;
    }

    public static void setLightView(LightView lightView) {
        AbstractBurnerWorker.lightView = lightView;
    }

    public long getSpiBlockSize() {
        return this.spiBlockSize;
    }

    public void setSpiBlockSize(long spiBlockSize) {
        this.spiBlockSize = spiBlockSize;
    }

    public long getNandBlockSize() {
        return this.nandBlockSize;
    }

    public void setNandBlockSize(long nandBlockSize) {
        this.nandBlockSize = nandBlockSize;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }

    public String getStrNandInfo() {
        return this.strNandInfo;
    }

    public void setStrNandInfo(String strNandInfo) {
        this.strNandInfo = strNandInfo;
    }

    public static IViewPart getView() {
        return view;
    }

    public static void setView(IViewPart view) {
        AbstractBurnerWorker.view = view;
    }

    public Socket createSocketConnection(String serialServerIp, String serialPort) {
        block7: {
            block6: {
                if (serialServerIp != null) break block6;
                Log.errorln(Messages.MESSAGE_SERIALSERVER_IP_ERROR);
                return null;
            }
            if (serialPort != null) break block7;
            Log.errorln(Messages.MESSAGE_NUMBERFORMAT_EXCEPTION);
            return null;
        }
        try {
            socket = new Socket(serialServerIp, Integer.parseInt(serialPort));
            AbstractBurnerWorker.setSOCKET_IN(socket.getInputStream());
            AbstractBurnerWorker.setSOCKET_OUT(socket.getOutputStream());
        }
        catch (NumberFormatException numberFormatException) {
            Log.errorln(Messages.MESSAGE_NUMBERFORMAT_EXCEPTION);
        }
        catch (UnknownHostException unknownHostException) {
            Log.errorln(Messages.MESSAGE_UNKNOWHOST_EXCEPTION);
        }
        catch (IOException iOException) {
            Log.errorln(Messages.IO_EXCEPTION);
        }
        return socket;
    }

    public void sendResetCommand() throws IOException, ReceiveTimeOutException {
        boolean isResetJtag;
        TransferWay curTransferWay = this.burner.getBurnContext().getTransferWay();
        boolean bl = isResetJtag = !(!FastbootView.isCJXX0VXX5Series() && !FastbootView.isCJ3X0VXX1Series() && !FastbootView.isCJ3X1VXX8E_Series() || curTransferWay != TransferWay.JTAG && curTransferWay != TransferWay.JTAGAndNet && curTransferWay != TransferWay.JTAGAndSerial);
        if (!isResetJtag) {
            String resetCommand = "reset";
            this.sendCommandNoReturnValue(resetCommand);
        }
    }

    protected boolean usbStart(TransferWay transferWay) throws ReceiveTimeOutException, IOException {
        return false;
    }

    protected static enum Light_E {
        CPU,
        BOOTROM,
        READ_EMMC,
        READ_SD,
        DDR_INIT,
        DDR_TRAINING,
        FASTBOOT_START,
        FLASH_NAND,
        FLASH_EMMC,
        FLASH_AND_IMAGE_MATCH,
        SERIAL,
        TFTP;

    }

    protected static enum Light_State_E {
        init,
        normal,
        abnormal,
        warn;

    }
}

