/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.serial.workers;

import com.vendor.burn.Messages;
import com.vendor.burn.commands.CrcCommand;
import com.vendor.burn.commands.EraseCommand;
import com.vendor.burn.commands.MWCommand;
import com.vendor.burn.commands.NetCommand;
import com.vendor.burn.commands.ReadCommand;
import com.vendor.burn.commands.SFCommand;
import com.vendor.burn.commands.TFTPCommand;
import com.vendor.burn.commands.UnZipCommand;
import com.vendor.burn.commands.WriteCommand;
import com.vendor.burn.model.BoardConfig;
import com.vendor.burn.model.BurnContext;
import com.vendor.burn.model.ChipID;
import com.vendor.burn.model.FileSystem;
import com.vendor.burn.model.FlashType;
import com.vendor.burn.model.LocalConfig;
import com.vendor.burn.model.PlatformType;
import com.vendor.burn.model.TransferWay;
import com.vendor.burn.model.config.PreferenceConfig;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.devices.burners.AbstractBurner;
import com.vendor.burn.model.devices.burners.AddressBurner;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import com.vendor.burn.model.event.EventType;
import com.vendor.burn.model.event.FastbootEvent;
import com.vendor.burn.model.receive.ReceiveTimeOutException;
import com.vendor.burn.model.struct.XmodelParameter;
import com.vendor.burn.preferences.FastbootPreferences;
import com.vendor.burn.serial.workers.CallLibBootromWorker;
import com.vendor.burn.serial.workers.CallLibJTAGWorker;
import com.vendor.burn.serial.workers.CallLibUSBWorker;
import com.vendor.burn.serial.workers.FastbootBurnerWorker;
import com.vendor.burn.serial.workers.WorkerUtility;
import com.vendor.burn.utilitily.FileUtils;
import com.vendor.burn.utilitily.GZipUtils;
import com.vendor.burn.utilitily.PropertiesUtility;
import com.vendor.burn.utilitily.ToolUtils;
import com.vendor.burn.views.FastbootView;
import com.vendor.platform.api.statistics.ToolStatistics;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.vendor.tftp.prefences.TFTPPreferences;
import org.vendor.tftp.tool.TFTPService;

public class AddressBurnerWorker
extends FastbootBurnerWorker {
    public static int FILE_PART_SIZE_32 = 0x2000000;
    private static final int COMMAND_TIMEOUT = 5000;
    private static long tempFileDivisionSize = 0L;
    private static int usbStartNumber = 0;
    static String BurntLengthGreaterEraseLength = "Burning Failed.\nReal burnt length is greater than the erase length,if prints ERROR: Attempt to write not aligned. it may be bad blocks. Please modify the length of the partitionif prints ERROR: Attempt write beyond end of device. Please reduced the length of the partition.";
    protected final BoardConfig board;
    private final LocalConfig local;

    public AddressBurnerWorker(IBurner burner) {
        super(burner.getBurnContext().getDeviceSetting().getFrameSetting(), burner);
        this.burner = burner;
        BurnContext burnContext = burner.getBurnContext();
        this.local = burnContext.getLocalConfig();
        this.board = burnContext.getBoardConfig();
    }

    public boolean burn(IProgressMonitor uimonitor, File file, FlashType flashType, FileSystem fileSystem, String startAddress, ChipID chipID) throws IOException {
        ToolStatistics.INSTANCE.logUsage("BurnTool", "Burn By Address", "ChipName: " + this.burner.getBurnContext().getDeviceSetting().getName());
        ToolStatistics.INSTANCE.logToolInUse("BurnTool");
        String versionInfo = this.getVersionInfo("Burn By Address");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        try {
            boolean isResetJtag;
            this.setProgressMonitor(uimonitor);
            uimonitor.beginTask("Burn Address", 100);
            FastbootEvent event = AddressBurnerWorker.getMonitor().getEvent();
            event.init(EventType.BURN);
            AddressBurnerWorker.getMonitor().begin();
            SubMonitor subProgressMonitor = SubMonitor.convert((IProgressMonitor)uimonitor, (String)"", (int)100);
            TransferWay transferWay = this.getBurner().getBurnContext().getTransferWay();
            if (transferWay == TransferWay.Usb2I2c || transferWay == TransferWay.I2CBootrom) {
                boolean bl = this.burnSinglePartByI2c(uimonitor, file, startAddress, flashType, false, chipID);
                return bl;
            }
            if (transferWay == TransferWay.USBNonNude) {
                boolean result = this.bootromByNonNude(uimonitor);
                if (!result) {
                    return false;
                }
                result = this.downloadBootByUSB(uimonitor, file, transferWay);
                if (!result) {
                    return false;
                }
                uimonitor.setTaskName("Burning " + file.getName());
                ArrayList<FlashType> hasFlashTypes = new ArrayList<FlashType>();
                hasFlashTypes.add(flashType);
                boolean loadVersionInfo = this.loadVersionInfo(transferWay);
                if (!loadVersionInfo || this.version == null) {
                    if (this.burner.getBurnContext().getPlatformType() == PlatformType.CA) {
                        this.loadBlockSizes(hasFlashTypes, chipID, false);
                        AddressBurnerWorker.warningln("Warning: Failed to load version info!");
                    } else {
                        AddressBurnerWorker.returnError("Failed to load version info!");
                        return false;
                    }
                }
                this.loadBlockSizes(hasFlashTypes, chipID, false);
                boolean burnFile = this.burnFile(subProgressMonitor, file, fileSystem, flashType, Long.parseLong(startAddress, 16), chipID);
                event.setSuccess(burnFile);
                if (burnFile) {
                    this.infoln("\nAddress burnt successfully.");
                } else {
                    AddressBurnerWorker.returnError("\nFailed to burn by address!");
                }
                this.sendCommandToSetMac();
                String resetCommand = "reset";
                this.sendCommandNoReturnValue(resetCommand);
                boolean bl = burnFile;
                return bl;
            }
            uimonitor.setTaskName("Init Board");
            this.registerJnaFunction(uimonitor, 100);
            ArrayList<FlashType> hasFlashTypes = new ArrayList<FlashType>();
            hasFlashTypes.add(flashType);
            boolean initBoard = this.initBoard(hasFlashTypes, true);
            if (!initBoard) {
                return false;
            }
            if (!this.startFastbootUsbTransferWay(uimonitor, transferWay)) {
                return false;
            }
            this.loadBlockSizes(hasFlashTypes, ((AddressBurner)this.burner).getCurrentChipId(), false);
            if (transferWay == TransferWay.Uart2Compress) {
                this.getTempFileDivisionSize(transferWay);
            } else if (this.isNeedSetupNet(transferWay) && !this.setupNetwork(transferWay)) {
                AddressBurnerWorker.returnError("Failed to setup network!");
                return false;
            }
            uimonitor.setTaskName("Burning " + file.getName());
            boolean burnFile = this.burnFile(subProgressMonitor, file, fileSystem, flashType, Long.parseLong(startAddress, 16), chipID);
            event.setSuccess(burnFile);
            if (burnFile) {
                this.infoln("\nAddress burnt successfully.");
            } else {
                AddressBurnerWorker.returnError("\nFailed to burn by address!");
            }
            this.sendCommandToSetMac();
            boolean bl = isResetJtag = !(!FastbootView.isCJXX0VXX5Series() && !FastbootView.isCJ3X0VXX1Series() && !FastbootView.isCJ3X1VXX8E_Series() || transferWay != TransferWay.JTAG && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.JTAGAndSerial);
            if (!isResetJtag) {
                String resetCommand = "reset";
                this.sendCommandNoReturnValue(resetCommand);
            }
            boolean bl2 = burnFile;
            return bl2;
        }
        catch (ReceiveTimeOutException receiveTimeOutException) {
            AddressBurnerWorker.returnError("\nConnection Interrupted, please try again.\n");
            return false;
        }
        finally {
            this.printCrcValue(file);
            uimonitor.done();
        }
    }

    protected void sendCommandToSetMac() throws IOException, ReceiveTimeOutException {
        if (ToolUtils.isCmdLine() && this.board != null && this.board.isGeneratorMAC()) {
            NetCommand athactCommand = this.getAthactCommand();
            if (athactCommand == null) {
                return;
            }
            this.sendCommand(athactCommand.getCommand(), 5000);
            String changePortCommand = "saveenv";
            this.sendCommand(changePortCommand, 5000);
        }
    }

    protected boolean burnFile(SubMonitor subProgressMonitor, File file, FileSystem fileSystem, FlashType flashType, long start, ChipID chipID) throws IOException, ReceiveTimeOutException {
        long blockSize = 0L;
        if (flashType == FlashType.spi) {
            blockSize = this.getSpiBlockSize();
        } else {
            blockSize = this.getNandBlockSize();
            if (this.isPage() && start != 0L) {
                blockSize = this.getPageSize();
            }
        }
        if (blockSize <= 0L) {
            String error = "Failed to get blocksize for the Flash \t" + flashType.name();
            AddressBurnerWorker.returnError(error);
            return false;
        }
        if (start % blockSize != 0L) {
            String error = "Address is not block aligned!\nBlock size:\t" + blockSize;
            AddressBurnerWorker.returnError(error);
            return false;
        }
        fileSystem = FileSystem.none;
        if (FileSystem.isYaffsFile(this.burner, file)) {
            fileSystem = FileSystem.yaffs;
        }
        long fileSize = file.length();
        long writeLength = 0L;
        writeLength = fileSize % blockSize != 0L ? blockSize * (fileSize / blockSize + 1L) : fileSize;
        long eraseLength = writeLength;
        if (start != 0L && this.isPage()) {
            long nandBlockSize = this.getNandBlockSize();
            eraseLength = fileSize % nandBlockSize != 0L ? nandBlockSize * (fileSize / nandBlockSize + 1L) : fileSize;
        }
        if (FileSystem.yaffs == fileSystem) {
            writeLength = fileSize;
        }
        long filePartSize = FastbootPreferences.getUsbSpliteFileSize();
        if (FileSystem.yaffs == fileSystem) {
            long[] yaffsPageandOOBSize = this.getYaffsPageandOOBSize();
            long ulPageSize = yaffsPageandOOBSize[0];
            long ulOOBSize = yaffsPageandOOBSize[1];
            if (0L == ulPageSize || 0L == ulOOBSize) {
                AddressBurnerWorker.returnError("Failed to get yaffs block size!");
                return false;
            }
            writeLength = fileSize;
            filePartSize = FastbootPreferences.getUsbSpliteFileSize() / blockSize * (blockSize + blockSize / ulPageSize * ulOOBSize);
        }
        if (writeLength == 0L) {
            return false;
        }
        AddressBurnerWorker.getMonitor().updateLength(writeLength);
        if (writeLength > filePartSize) {
            return this.burnLargeFile(subProgressMonitor, file, fileSystem, flashType, filePartSize, start, eraseLength, writeLength, chipID);
        }
        return this.burnSmallFile(subProgressMonitor, file, fileSystem, flashType, start, eraseLength, writeLength, chipID);
    }

    /*
     * Exception decompiling
     */
    protected boolean burnLargeFile(SubMonitor subProgressMonitor, File file, FileSystem fileSystem, FlashType flashType, long filePartSize, long start, long eraseLength, long adjustedTotalWriteLength, ChipID chipID) throws IOException, ReceiveTimeOutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 30[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected int writeBufferToPartFile(long filePartSize, FileInputStream inputStream, boolean result, File partfile, int partLength) throws FileNotFoundException, IOException {
        int partLen = partLength;
        byte[] buffer = new byte[0x200000];
        FileOutputStream outputtream = null;
        try {
            int read;
            outputtream = new FileOutputStream(partfile);
            int length = (int)Math.min(filePartSize, (long)buffer.length);
            while (inputStream != null && (long)partLen < filePartSize && result && (read = inputStream.read(buffer, 0, length)) > 0) {
                ((OutputStream)outputtream).write(buffer, 0, read);
                int n = length = filePartSize - (long)(partLen += read) < (long)buffer.length ? (int)(filePartSize - (long)partLen) : buffer.length;
            }
        }
        catch (Throwable throwable) {
            if (outputtream != null) {
                try {
                    ((OutputStream)outputtream).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (outputtream != null) {
            try {
                ((OutputStream)outputtream).close();
            }
            catch (IOException iOException) {}
        }
        return partLen;
    }

    private WriteCommand getWriteCommand(FileSystem fileSystem, FlashType flashType, int times, long address, int partLength, String ddrAddress) {
        WriteCommand writeCommand = WriteCommand.write(flashType, ddrAddress, Long.toHexString(address), Long.toHexString(partLength));
        if (fileSystem == FileSystem.yaffs) {
            writeCommand = times == 0 ? WriteCommand.writeYaffs(flashType, ddrAddress, Long.toHexString(address), Long.toHexString(partLength)) : WriteCommand.writeYaffsuc(flashType, ddrAddress, Long.toHexString(address), Long.toHexString(partLength));
        }
        return writeCommand;
    }

    private long handleRealBurnLen(FileSystem fileSystem, FlashType flashType, long filePartSize, long address) {
        boolean isYaffs;
        boolean bl = isYaffs = fileSystem == FileSystem.yaffs || FlashType.nand == flashType;
        if (isYaffs) {
            long realBurnLength = this.getRealBurnLength(address);
            if (realBurnLength == -1L) {
                AddressBurnerWorker.returnError("Failed to get real burt length.");
                return address;
            }
            if (realBurnLength == 0L) {
                this.infoln("Warning:BurnTool didn't receive the real burning length from the board, so please try to use the release version of the boot");
            }
            address += realBurnLength;
        } else {
            address += filePartSize;
        }
        return address;
    }

    private boolean checkBlockFlash(SubMonitor subProgressMonitor, boolean result, WriteCommand writeCommand, int burnCount) throws IOException, ReceiveTimeOutException {
        while (!result) {
            String returnString = this.getCurReceived();
            if (!returnString.contains("WARNING: block is marked as bad")) break;
            AddressBurnerWorker.warningln("A block is marked as bad block, burning the file again,the current is the " + burnCount + " times");
            subProgressMonitor.setTaskName("Writing...");
            result = this.sendCommand(writeCommand);
            ++burnCount;
        }
        return result;
    }

    private boolean unzipForUart2Compress(String unzipAddr, WriteCommand writeCommand) throws IOException, ReceiveTimeOutException {
        if (this.getBurner().getBurnContext().getTransferWay() == TransferWay.Uart2Compress) {
            UnZipCommand unZipCommand = UnZipCommand.unzip(this.getHexStartAddress(), unzipAddr);
            return this.sendCommand(unZipCommand.toString(), unZipCommand.calculateTimeOut(Long.toHexString(tempFileDivisionSize)));
        }
        return true;
    }

    protected boolean downloadFileByTrans(SubMonitor subProgressMonitor, boolean result, XmodelParameter xmodelPar, File partfile, int progressWork) throws IOException, ReceiveTimeOutException {
        boolean isUSB;
        subProgressMonitor.setTaskName("Downloading File : " + partfile.getName());
        TransferWay transferWay = this.getBurner().getBurnContext().getTransferWay();
        boolean isI2C = transferWay == TransferWay.Usb2I2c || transferWay == TransferWay.I2CBootrom;
        boolean bl = isUSB = transferWay == TransferWay.USBBootrom || transferWay == TransferWay.USBNonNude || transferWay == TransferWay.UsbAndSerial;
        if (transferWay == TransferWay.Serial) {
            result = this.downloadFileSerial(SubMonitor.convert((IProgressMonitor)this.uimonitor, (String)"", (int)progressWork), partfile, false);
        } else if (transferWay == TransferWay.Uart2Compress) {
            File compressFile = GZipUtils.compress(this.uimonitor, partfile, false, true);
            if (compressFile == null) {
                AddressBurnerWorker.returnError(NLS.bind((String)Messages.ERROR_INFO_DISK_SPACE_LOW, (Object)partfile));
                return false;
            }
            result = this.downloadFileSerial(SubMonitor.convert((IProgressMonitor)subProgressMonitor, (String)"", (int)progressWork), compressFile, false);
            if (compressFile.exists()) {
                FileUtils.deleteFile(compressFile);
            }
        } else if (!isI2C) {
            if (isUSB) {
                this.infoln("\nSend command:\tDownloading File : " + partfile.getName());
                result = CallLibUSBWorker.downloadFileByUsb(partfile, this.getHexStartAddressForInt(), transferWay);
                subProgressMonitor.worked(progressWork);
                if (!result) {
                    AddressBurnerWorker.returnError(Messages.ERROR_INFO_USB_DOWNLOAD_FAILED);
                    return false;
                }
            } else if (transferWay == TransferWay.UDP) {
                StringBuilder info = new StringBuilder("\n");
                info.append("Send command");
                info.append(":\t");
                this.infoln(String.valueOf(info.toString()) + "Downloading File : " + partfile.getName());
                String path = partfile.getPath();
                result = CallLibBootromWorker.UdpDownloadFile(path, this.getHexStartAddressForInt());
                if (!result) {
                    AddressBurnerWorker.returnError(Messages.ERROR_INFO_UDP_DOWNLOAD_FAILED);
                    return false;
                }
            } else if (transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndSerial) {
                result = this.jtagAndCheckCRC(partfile);
                subProgressMonitor.worked(progressWork);
                if (!result) {
                    AddressBurnerWorker.returnError(Messages.FAILED_TO_DOWNLOAD_FILE_BY_JTAG);
                    return false;
                }
            } else {
                boolean openTftpCrcCheck = true;
                if (ToolUtils.isCmdLine()) {
                    openTftpCrcCheck = PreferenceConfig.isTftpCrcCheck() && !FastbootView.isCJXX0VXX5Series();
                } else {
                    boolean bl2 = openTftpCrcCheck = FastbootPreferences.isOpenTftpCrcCheck() && !FastbootView.isCJXX0VXX5Series();
                }
                if (openTftpCrcCheck) {
                    int retransmitCount = 0;
                    while (retransmitCount < 3) {
                        result = this.tftpAndCheckCRC(subProgressMonitor, partfile, openTftpCrcCheck);
                        if (!result) {
                            ++retransmitCount;
                            continue;
                        }
                        break;
                    }
                } else {
                    result = this.tftpAndCheckCRC(subProgressMonitor, partfile, openTftpCrcCheck);
                }
                subProgressMonitor.worked(progressWork);
                if (!result) {
                    AddressBurnerWorker.returnError(Messages.Partition_TFTP_CRC_Failed);
                    return false;
                }
            }
        }
        return result;
    }

    protected boolean burnSmallFile(SubMonitor subProgressMonitor, File file, FileSystem fileSystem, FlashType flashType, long address, long eraseLength, long writeLength, ChipID chipID) throws IOException, ReceiveTimeOutException {
        subProgressMonitor.beginTask("", 100);
        try {
            boolean validFile;
            boolean result = true;
            String hexAddress = Long.toHexString(address);
            String hexWriteLength = Long.toHexString(writeLength);
            String hexEraseLength = Long.toHexString(eraseLength);
            EraseCommand eraseCommand = EraseCommand.erase(flashType, hexAddress, hexEraseLength);
            String ddrAddress = this.getHexStartAddress();
            String unzipAddr = Long.toHexString(tempFileDivisionSize + (long)this.getHexStartAddressForInt());
            if (this.getBurner().getBurnContext().getTransferWay() == TransferWay.Uart2Compress) {
                ddrAddress = unzipAddr;
            }
            WriteCommand writeCommand = WriteCommand.write(flashType, ddrAddress, hexAddress, hexWriteLength);
            if (fileSystem == FileSystem.yaffs) {
                writeCommand = WriteCommand.writeYaffs(flashType, ddrAddress, hexAddress, hexWriteLength);
            }
            boolean bl = validFile = file != null && file.exists() && file.isFile();
            if (validFile) {
                subProgressMonitor.setTaskName("Sending MW command.");
                MWCommand memsetCommand = MWCommand.mwAddress(this.getHexStartAddress(), hexWriteLength);
                result = this.sendCommand(memsetCommand);
                subProgressMonitor.worked(2);
                if (result) {
                    subProgressMonitor.setTaskName("Downloading File : " + file.getName());
                    XmodelParameter xmodelPar = new XmodelParameter(file.length(), 0L);
                    result = this.downloadFileByTrans(subProgressMonitor, result, xmodelPar, file, 95);
                    if (!result) {
                        boolean bl2 = result;
                        return bl2;
                    }
                }
            }
            if (result && flashType == FlashType.spi) {
                result = this.sendCommand(SFCommand.getInstance(chipID));
                subProgressMonitor.worked(1);
            }
            if (result) {
                subProgressMonitor.setTaskName("Erasing...");
                result = this.sendCommand(eraseCommand);
            }
            subProgressMonitor.worked(1);
            if (result && validFile) {
                if (this.getBurner().getBurnContext().getTransferWay() == TransferWay.Uart2Compress) {
                    UnZipCommand unZipCommand = UnZipCommand.unzip(this.getHexStartAddress(), unzipAddr);
                    result = this.sendCommand(unZipCommand.toString(), unZipCommand.calculateTimeOut(Long.toHexString(tempFileDivisionSize)));
                }
                subProgressMonitor.setTaskName("Writing...");
                result = this.sendCommand(writeCommand);
            }
            int burnCount = 1;
            boolean bl3 = result = this.checkBlockFlash(subProgressMonitor, result, writeCommand, burnCount);
            return bl3;
        }
        finally {
            subProgressMonitor.done();
        }
    }

    public IBurner getBurner() {
        return this.burner;
    }

    @Override
    protected String getStartMessage() {
        return super.getStartMessage();
    }

    protected boolean initSpi(ChipID chipId) throws IOException, ReceiveTimeOutException {
        return this.initSpi(this.getFlashType(), chipId);
    }

    protected boolean initSpi(FlashType flashType, ChipID ChipId) throws IOException, ReceiveTimeOutException {
        boolean bRet = true;
        if (flashType == FlashType.spi) {
            bRet = this.sendCommand(SFCommand.getInstance(ChipId));
        }
        return bRet;
    }

    @Override
    public void switchTFTPDownloadHome(File file) {
        if (file == null) {
            return;
        }
        if (!TFTPService.TFTPSERVICE.isStart()) {
            return;
        }
        if (file.isFile()) {
            file = file.getParentFile();
        }
        if (file.isDirectory()) {
            TFTPService.TFTPSERVICE.setServerDirectory(file);
            this.infoln("\tTftp server Download Home switched to <" + file.getAbsolutePath() + ">");
        }
    }

    public boolean upload(IProgressMonitor uimonitor, File file, FileSystem uploadFileSystem, String address, String length, boolean needStartBoot, ChipID chipId) throws IOException {
        ToolStatistics.INSTANCE.logUsage("BurnTool", "Upload By Address", "ChipName: " + this.burner.getBurnContext().getDeviceSetting().getName());
        ToolStatistics.INSTANCE.logToolInUse("BurnTool");
        String versionInfo = this.getVersionInfo("Upload By Address");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        this.registerJnaFunction(uimonitor, 100);
        try {
            this.setProgressMonitor(uimonitor);
            uimonitor.beginTask("", 100);
            FastbootEvent event = AddressBurnerWorker.getMonitor().getEvent();
            event.init(EventType.UPLOAD);
            uimonitor.setTaskName("Init Board");
            FlashType flashType = this.getFlashType();
            ArrayList<FlashType> hasFlashTypes = new ArrayList<FlashType>();
            hasFlashTypes.add(flashType);
            TransferWay transferWay = this.getBurner().getBurnContext().getTransferWay();
            if (needStartBoot) {
                if (!this.initBoard(hasFlashTypes, false)) {
                    String error = "Failed to initialize the board!";
                    AddressBurnerWorker.returnError(error);
                    return false;
                }
                if (this.isNeedSetupNet(transferWay) && !this.setupNetwork(transferWay)) {
                    AddressBurnerWorker.returnError("Failed to setup network!");
                    return false;
                }
            }
            if (!this.startFastbootUsbTransferWay(uimonitor, transferWay)) {
                return false;
            }
            if (needStartBoot) {
                this.loadBlockSizes(hasFlashTypes, ((AddressBurner)this.burner).getCurrentChipId(), false);
            }
            uimonitor.worked(5);
            ReadCommand readCommand = null;
            if (FileSystem.yaffs != uploadFileSystem) {
                readCommand = ReadCommand.read(flashType, this.getHexStartAddress(), address, length);
            } else {
                readCommand = ReadCommand.readYaffs(flashType, this.getHexStartAddress(), address, length);
                uploadFileSystem = null;
            }
            boolean bRet = true;
            bRet = this.initSpi(flashType, chipId);
            uimonitor.setTaskName("Reading Content");
            if (bRet) {
                bRet = this.sendCommand(readCommand);
            }
            uimonitor.worked(10);
            uimonitor.setTaskName("Uploading Content");
            if (bRet) {
                try {
                    bRet = this.uploadByTrans(uimonitor, Long.parseLong(length, 16), file);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            event.setSuccess(bRet);
            if (bRet) {
                this.infoln("Uploaded successfully by Address.");
            } else {
                AddressBurnerWorker.returnError("Failed to upload by Address!");
            }
            boolean bl = bRet;
            return bl;
        }
        catch (ReceiveTimeOutException receiveTimeOutException) {
            AddressBurnerWorker.returnError("\nConnection Interrupted, please try again.\n");
            return false;
        }
        finally {
            uimonitor.done();
        }
    }

    protected boolean uploadByTrans(IProgressMonitor uiMonitor, long length, File tmpFile) throws IOException, ReceiveTimeOutException {
        boolean isOnlyJTAG;
        boolean result = false;
        TransferWay transferWay = this.getBurner().getBurnContext().getTransferWay();
        boolean isSerial = transferWay == TransferWay.Serial || transferWay == TransferWay.Uart2Compress;
        boolean isI2C = transferWay == TransferWay.Usb2I2c || transferWay == TransferWay.I2CBootrom;
        boolean isUSB = transferWay == TransferWay.USBBootrom || transferWay == TransferWay.USBNonNude;
        boolean isUsbAndSerial = transferWay == TransferWay.UsbAndSerial || FastbootView.isSupportUsbNonNude(transferWay);
        boolean bl = isOnlyJTAG = transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndSerial;
        if (isSerial) {
            this.infoln("\nSend command:\tDumping File by Serial: " + tmpFile.getName());
            result = this.upload(SubMonitor.convert((IProgressMonitor)this.uimonitor, (String)"", (int)98), tmpFile, this.getHexStartAddress(), Long.toHexString(length));
        } else if (isI2C) {
            AddressBurnerWorker.returnError(NLS.bind((String)Messages.ERROR_INFO_Cur_TransferMode_NoSupport_Upload, (Object)"I2C"));
        } else {
            if (isUSB) {
                AddressBurnerWorker.returnError(NLS.bind((String)Messages.ERROR_INFO_Cur_TransferMode_NoSupport_Upload, (Object)"USB"));
                return false;
            }
            if (isUsbAndSerial) {
                this.infoln("\nSend command:\tDumping File by USB: " + tmpFile.getName());
                CallLibUSBWorker.uploadFileByUsb(tmpFile, this.getHexStartAddressForInt(), (int)length, transferWay);
            } else if (isOnlyJTAG) {
                this.infoln("\nSend command:\tDumping File by JTAG: " + tmpFile.getName());
                result = CallLibJTAGWorker.dumpFileByJtag(tmpFile.getPath(), this.getHexStartAddressForInt(), length);
            } else {
                this.switchTFTPDownloadHome(tmpFile);
                TFTPCommand uploadCommand = TFTPCommand.upload(tmpFile, this.getHexStartAddress(), Long.toHexString(length));
                result = this.sendCommand(uploadCommand);
            }
        }
        return result;
    }

    protected void deleteTempFile(File file) {
        long startTime = System.currentTimeMillis();
        long outTime = 2000L;
        while (file != null && !file.delete() && System.currentTimeMillis() - startTime < outTime) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (file != null && file.exists()) {
            AddressBurnerWorker.warning(NLS.bind((String)Messages.AddressBurnerWorker_PartFile_Delete_Failed, (Object)file.getAbsolutePath()));
        }
    }

    protected void setMessage(String mesg) {
        if (AddressBurnerWorker.getMonitor() != null) {
            AddressBurnerWorker.getMonitor().getEvent().setMessage(mesg);
        }
        AddressBurnerWorker.warningln(mesg);
    }

    protected long getRealBurnLength(long eraseLength) {
        String strBurnInfo = this.getCurReceived();
        if (strBurnInfo.indexOf("ERROR: Attempt") != -1 || strBurnInfo.indexOf("RRR: Attempt") != -1) {
            return eraseLength + 1L;
        }
        if ((strBurnInfo = strBurnInfo.replaceAll("[EOT]", "").trim()).length() == 0) {
            return 0L;
        }
        String FLAG = "len_incl_bad is ";
        int beginIndex = strBurnInfo.indexOf(FLAG);
        if (beginIndex == -1) {
            return 0L;
        }
        int endIndex = strBurnInfo.indexOf("\r\n", beginIndex += FLAG.length());
        String strRealBurnLength = strBurnInfo.substring(beginIndex, endIndex);
        long parseLong = -1L;
        try {
            parseLong = Long.parseLong(strRealBurnLength);
        }
        catch (Exception exception) {
            parseLong = -1L;
            AddressBurnerWorker.warningln("Failed to parse to number from '" + strRealBurnLength + "'.");
        }
        return parseLong;
    }

    long[] getYaffsPageandOOBSize() throws IOException, ReceiveTimeOutException {
        String strNandInfo = this.getStrNandInfo();
        long pageSize = WorkerUtility.ReceiveHelper.getPageSize(strNandInfo);
        long oobSize = WorkerUtility.ReceiveHelper.getOobSize(strNandInfo);
        if (pageSize < 0L || oobSize < 0L) {
            return new long[2];
        }
        return new long[]{pageSize, oobSize};
    }

    public boolean initBoard(ArrayList<FlashType> hasFlashTypes, boolean isBurn) throws IOException, ReceiveTimeOutException {
        TransferWay transferWay;
        if (ToolUtils.isDebugOn()) {
            this.println("InitBoard Start");
        }
        if (((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) {
            if (!this.programmerDownload(null, ((AbstractBurner)((Object)this.burner)).getProgrammerFile())) {
                AddressBurnerWorker.returnError("Failed to download fastboot!");
                return false;
            }
        } else {
            boolean isReplaceBoot;
            String programmerFile = ((AbstractBurner)((Object)this.burner)).getProgrammerFile();
            String file = ((AddressBurner)this.burner).getFile();
            String address = ((AddressBurner)this.burner).getAddress();
            ChipID chipID = ((AddressBurner)this.burner).getChipID();
            boolean bl = isReplaceBoot = isBurn && address != null && address.equals("0") && programmerFile == null && chipID != null && chipID == ChipID.chip0;
            if (isReplaceBoot) {
                programmerFile = file;
            }
            if (this.burner.getBurnContext().getPlatformType() == PlatformType.NonCA ? !this.bootDownload(programmerFile) : !this.programmerDownload(null, programmerFile)) {
                return false;
            }
        }
        this.version = null;
        boolean loadVersionInfo = this.loadVersionInfo(this.burner.getBurnContext().getTransferWay());
        if (!loadVersionInfo || this.version == null) {
            if (this.burner.getBurnContext().getPlatformType() == PlatformType.CA) {
                AddressBurnerWorker.warningln("Warning: Failed to load version info!");
            } else {
                AddressBurnerWorker.returnError("Failed to load version info!");
                return false;
            }
        }
        if (this.isNeedSetupNet(transferWay = this.getBurner().getBurnContext().getTransferWay())) {
            this.setupNetwork(transferWay);
        }
        return true;
    }

    protected void loadBlockSizes(ChipID chipID) {
        FlashType[] flashTypes;
        FlashType[] flashTypeArray = flashTypes = this.getBurner().getBurnContext().getDeviceSetting().getFlashSetting().getFlashTypes(this.getBurner());
        int n = flashTypes.length;
        int n2 = 0;
        while (n2 < n) {
            FlashType flash = flashTypeArray[n2];
            if (flash == FlashType.spi) {
                this.setSpiBlockSize(this.getBlockSize(FlashType.spi, chipID, false));
            } else if (flash == FlashType.nand) {
                this.setNandBlockSize(this.getBlockSize(FlashType.nand, chipID, false));
            }
            ++n2;
        }
    }

    protected void loadBlockSizes(ArrayList<FlashType> hasFlashTypes, ChipID chipID, boolean isFastboot) {
        if (hasFlashTypes == null) {
            return;
        }
        for (FlashType flash : hasFlashTypes) {
            if (flash == FlashType.spi) {
                this.getBlockSize(FlashType.spi, chipID, isFastboot);
                continue;
            }
            if (flash != FlashType.nand) continue;
            this.getBlockSize(FlashType.nand, chipID, isFastboot);
        }
    }

    public boolean erase(IProgressMonitor uimonitor, String address, String length) throws IOException {
        ToolStatistics.INSTANCE.logUsage("BurnTool", "Erase By Address", "ChipName: " + this.burner.getBurnContext().getDeviceSetting().getName());
        ToolStatistics.INSTANCE.logToolInUse("BurnTool");
        String versionInfo = this.getVersionInfo("Erase By Address");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        try {
            this.setProgressMonitor(uimonitor);
            uimonitor.beginTask("", 100);
            AddressBurnerWorker.getMonitor().getEvent().init(EventType.ERASE);
            uimonitor.setTaskName("Init Board");
            this.registerJnaFunction(uimonitor, 100);
            long blockSize = 0L;
            FlashType flashType = this.getFlashType();
            ArrayList<FlashType> hasFlashTypes = new ArrayList<FlashType>();
            hasFlashTypes.add(flashType);
            boolean result = true;
            TransferWay transferWay = this.getBurner().getBurnContext().getTransferWay();
            if (transferWay == TransferWay.USBNonNude) {
                result = this.bootromByNonNude(uimonitor);
                if (!result) {
                    return false;
                }
                boolean loadVersionInfo = this.loadVersionInfo(this.burner.getBurnContext().getTransferWay());
                if (!loadVersionInfo || this.version == null) {
                    if (this.burner.getBurnContext().getPlatformType() == PlatformType.CA) {
                        this.loadBlockSizes(hasFlashTypes, ((AddressBurner)this.burner).getCurrentChipId(), false);
                        AddressBurnerWorker.warningln("Warning: Failed to load version info!");
                    } else {
                        AddressBurnerWorker.returnError("Failed to load version info!");
                        return false;
                    }
                }
                this.loadBlockSizes(hasFlashTypes, ((AddressBurner)this.burner).getCurrentChipId(), false);
            } else {
                result = this.initBoard(hasFlashTypes, false);
                if (!result) {
                    return false;
                }
            }
            if (!this.startFastbootUsbTransferWay(uimonitor, transferWay)) {
                return false;
            }
            if (transferWay != TransferWay.USBNonNude) {
                this.loadBlockSizes(hasFlashTypes, ((AddressBurner)this.burner).getCurrentChipId(), false);
            }
            if (this.getFlashType() == FlashType.spi) {
                blockSize = this.getSpiBlockSize();
            } else {
                blockSize = this.getNandBlockSize();
                if (this.isPage()) {
                    blockSize = this.getPageSize();
                }
            }
            long addr = Long.parseLong(address, 16);
            if (addr % blockSize != 0L) {
                String error = "Address is not block aligned!\nBlock size:\t" + blockSize;
                AddressBurnerWorker.returnError(error);
                return false;
            }
            long len = Long.parseLong(length, 16);
            if (len % blockSize != 0L) {
                String error = "Length is not block aligned!\nBlock size:\t" + blockSize;
                AddressBurnerWorker.returnError(error);
                return false;
            }
            uimonitor.worked(20);
            if (flashType == FlashType.spi) {
                result = this.sendCommand(SFCommand.getInstance(((AddressBurner)this.burner).getCurrentChipId()));
            }
            if (result) {
                result = this.sendCommand(EraseCommand.erase(flashType, address, length));
            }
            if (result) {
                boolean isResetJtag;
                this.infoln("Flash erased successfully!");
                transferWay = this.getBurner().getBurnContext().getTransferWay();
                boolean bl = isResetJtag = !(!FastbootView.isCJXX0VXX5Series() && !FastbootView.isCJ3X0VXX1Series() && !FastbootView.isCJ3X1VXX8E_Series() || transferWay != TransferWay.JTAG && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.JTAGAndSerial);
                if (!isResetJtag) {
                    String resetCommand = "reset";
                    this.sendCommandNoReturnValue(resetCommand);
                }
            } else {
                AddressBurnerWorker.returnError("Failed to Erase Flash by address!");
            }
            boolean bl = result;
            return bl;
        }
        catch (ReceiveTimeOutException receiveTimeOutException) {
            AddressBurnerWorker.returnError("\nConnection Interrupted, please try again.\n");
            return false;
        }
        finally {
            uimonitor.done();
        }
    }

    @Override
    protected NetCommand[] buildNetCommands(TransferWay transferWay) {
        String ethactID = null;
        if (!ToolUtils.isCmdLine()) {
            IPreferenceStore preferences = FastbootPreferences.getPreferenceStore();
            ethactID = preferences.getString("vendor.burn.config.ethact");
        } else {
            ethactID = String.valueOf(PreferenceConfig.getCmdEthact());
        }
        NetCommand[] commands = null;
        if (ethactID == null) {
            commands = new NetCommand[5];
        }
        if (ethactID != null && ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[0])) {
            commands = new NetCommand[5];
        }
        if (ethactID != null && !ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[0])) {
            commands = new NetCommand[6];
        }
        if (commands != null) {
            commands[0] = this.getFirstElement(commands);
            commands[1] = transferWay == TransferWay.UsbTransNet ? NetCommand.setClientMAC("") : NetCommand.setClientMAC(this.board.getMac());
            commands[2] = NetCommand.setClientIP(this.board.getIp());
            commands[3] = NetCommand.setClientNetMask(this.board.getSubnetMask());
            commands[4] = NetCommand.setClientGateway(this.board.getGateway());
            if (ethactID != null) {
                if (ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[0])) {
                    return commands;
                }
                if (ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[1])) {
                    commands[5] = NetCommand.setEthact("0");
                } else if (ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[2])) {
                    commands[5] = NetCommand.setEthact("1");
                } else if (ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[3])) {
                    commands[5] = NetCommand.setEthact("2");
                } else if (ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[4])) {
                    commands[5] = NetCommand.setEthact("3");
                } else {
                    return commands;
                }
            }
        }
        return commands;
    }

    protected NetCommand getAthactCommand() {
        String ethactID = String.valueOf(PreferenceConfig.getCmdEthact());
        NetCommand netCommand = null;
        if (ethactID == null || this.board == null) {
            return netCommand;
        }
        netCommand = NetCommand.setClientMAC(this.board.getMac());
        return netCommand;
    }

    private NetCommand getFirstElement(NetCommand[] netCommand) {
        String serverIp;
        netCommand[0] = !ToolUtils.isCmdLine() ? ((serverIp = TFTPPreferences.getPRETFTPSERVERIP()) != null && !serverIp.isEmpty() ? NetCommand.setServerIP(serverIp) : NetCommand.setServerIP(this.local.getServerIp())) : NetCommand.setServerIP(this.local.getServerIp());
        return netCommand[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean setupNetwork(TransferWay transferWay) throws ReceiveTimeOutException {
        try {
            if (!this.usbStart(transferWay)) {
                return false;
            }
            NetCommand[] commands = this.buildNetCommands(transferWay);
            if (commands == null) {
                return false;
            }
            NetCommand[] netCommandArray = commands;
            int n = commands.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    int port;
                    String changePortCommand;
                    String portConfigurable = PropertiesUtility.queryForString("portConfigurable");
                    if (portConfigurable != null && Boolean.valueOf(portConfigurable).booleanValue() && !this.sendCommand(changePortCommand = "setenv tftpdstp " + String.valueOf(port = CrcCommand.getTFTPPort()))) {
                        return false;
                    }
                    break;
                }
                NetCommand command = netCommandArray[n2];
                if (!this.sendCommand(command)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (IOException iOException) {}
        FastbootView.setStartNetwork(false);
        ++usbStartNumber;
        return true;
    }

    @Override
    protected boolean usbStart(TransferWay transferWay) throws ReceiveTimeOutException, IOException {
        boolean isUsbToEthernet = this.getBurner().getBurnContext().isUsbToEthernet();
        if (transferWay == TransferWay.UsbTransNet || isUsbToEthernet) {
            String usbTransNetCmd = "usb start";
            if (!this.sendCommand(usbTransNetCmd)) {
                AddressBurnerWorker.returnError(Messages.Fastboot_NotSupportUsbTransNetWay);
                return false;
            }
            if (usbStartNumber == 0) {
                String returnStr = this.getCurReceived();
                String[] split = returnStr.split("\r\n");
                boolean foundFlag = false;
                String[] stringArray = split;
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    if (line.contains("Ethernet Device(s) found")) {
                        foundFlag = true;
                        int flagIndex = line.indexOf("Ethernet Device(s) found");
                        String usb2ethCountStr = "";
                        if (flagIndex < 2) {
                            AddressBurnerWorker.returnError(Messages.Burner_NotFoundUsb2EthPort);
                            return false;
                        }
                        usb2ethCountStr = line.substring(flagIndex - 2, flagIndex).trim();
                        try {
                            int usb2ethCount = Integer.parseInt(usb2ethCountStr);
                            if (usb2ethCount > 0) break;
                            AddressBurnerWorker.returnError(Messages.Burner_NotFoundUsb2EthPort);
                            return false;
                        }
                        catch (NumberFormatException numberFormatException) {
                            AddressBurnerWorker.returnError(Messages.Burner_NotFoundUsb2EthPort);
                            return false;
                        }
                    }
                    ++n2;
                }
                if (!foundFlag) {
                    AddressBurnerWorker.returnError(Messages.Burner_NotFoundUsb2EthPort);
                    return false;
                }
            }
        }
        return true;
    }

    protected String calculateBurnTotalTime(long burnTotalTime) {
        StringBuilder burnTotalTimeStr = new StringBuilder();
        long hours = burnTotalTime % 86400000L / 3600000L;
        long minutes = burnTotalTime % 3600000L / 60000L;
        long seconds = burnTotalTime % 60000L / 1000L;
        if (hours != 0L) {
            burnTotalTimeStr.append(hours);
            burnTotalTimeStr.append(" ");
            burnTotalTimeStr.append(Messages.AbstractBurner_BurnTotalTime_hours);
        }
        if (minutes != 0L) {
            burnTotalTimeStr.append(minutes);
            burnTotalTimeStr.append(" ");
            burnTotalTimeStr.append(Messages.AbstractBurner_BurnTotalTime_minutes);
        }
        if (seconds != 0L) {
            burnTotalTimeStr.append(seconds);
            burnTotalTimeStr.append(" ");
            burnTotalTimeStr.append(Messages.AbstractBurner_BurnTotalTime_seconds);
        }
        return burnTotalTimeStr.toString();
    }
}

