/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.serial.workers;

import com.vendor.burn.model.define.IChecker;
import com.vendor.burn.model.receive.ReceiveTimeOutException;
import com.vendor.burn.serial.workers.AddressBurnerWorker;
import com.vendor.burn.serial.workers.CallLibJTAGWorker;
import com.vendor.burn.utilitily.ToolUtils;
import com.vendor.platform.api.statistics.ToolStatistics;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;

public class BadCheckBurnerWorker
extends AddressBurnerWorker {
    private static StringBuilder content = new StringBuilder();

    public BadCheckBurnerWorker(IChecker checker) {
        super(checker);
    }

    public boolean initBoard() throws IOException, ReceiveTimeOutException {
        if (ToolUtils.isDebugOn()) {
            this.println("InitBoard Start");
        }
        return this.bootDownload(null);
    }

    public boolean eraseBad(IProgressMonitor uimonitor) throws ReceiveTimeOutException, IOException {
        ToolStatistics.INSTANCE.logUsage("BurnTool", "Nand Scrub", "ChipName: " + this.burner.getBurnContext().getDeviceSetting().getName());
        ToolStatistics.INSTANCE.logToolInUse("BurnTool");
        String versionInfo = this.getVersionInfo("Nand Scrub");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        monitor.getEvent().setSuccess(false);
        this.setProgressMonitor(uimonitor);
        uimonitor.beginTask("Erase Bad Blocks", 100);
        BadCheckBurnerWorker.deleteContent(content);
        uimonitor.setTaskName("Init Board");
        boolean initBoard = this.initBoard();
        if (!initBoard) {
            return false;
        }
        uimonitor.internalWorked(0.2);
        String received = this.getCurReceived();
        content.append(received);
        if (received.toUpperCase().indexOf("NAND") == -1) {
            BadCheckBurnerWorker.warningln("No Nand Found.");
            return false;
        }
        uimonitor.setTaskName("Sending nand scrub command.");
        uimonitor.internalWorked(0.6);
        boolean sendCommand = this.sendCommand("nand scrub", 10000);
        if (!sendCommand) {
            BadCheckBurnerWorker.warningln("Failed to execute nand scrub command.");
            return false;
        }
        content.append(this.getCurReceived());
        monitor.getEvent().setSuccess(true);
        monitor.getEvent().setMessage(content.toString());
        this.infoln("Nand scrub successful.");
        return true;
    }

    public boolean check(IProgressMonitor uimonitor) throws ReceiveTimeOutException, IOException {
        ToolStatistics.INSTANCE.logUsage("BurnTool", "Bad Check", "ChipName: " + this.burner.getBurnContext().getDeviceSetting().getName());
        ToolStatistics.INSTANCE.logToolInUse("BurnTool");
        String versionInfo = this.getVersionInfo("Bad Check");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        try {
            monitor.getEvent().setSuccess(false);
            this.setProgressMonitor(uimonitor);
            uimonitor.beginTask("Check Bad Blocks", 100);
            BadCheckBurnerWorker.deleteContent(content);
            uimonitor.setTaskName("Init Board");
            boolean initBoard = this.initBoard();
            if (!initBoard) {
                return false;
            }
            uimonitor.internalWorked(0.2);
            String received = this.getCurReceived();
            content.append(received);
            if (received.toUpperCase().indexOf("NAND") == -1) {
                BadCheckBurnerWorker.warningln("No Nand Found.");
                return false;
            }
            uimonitor.setTaskName("Sending Check command.");
            uimonitor.internalWorked(0.6);
            boolean sendCommand = this.sendCommand("nand bad", 10000);
            if (!sendCommand) {
                BadCheckBurnerWorker.warningln("Failed to get bad block info.");
                return false;
            }
            this.onAdataAvailable(serialReceived);
            content.append((CharSequence)serialReceived);
            monitor.getEvent().setSuccess(true);
            monitor.getEvent().setMessage(content.toString());
        }
        finally {
            uimonitor.done();
        }
        return true;
    }
}

