/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.serial.workers;

import com.vendor.burn.Messages;
import com.vendor.burn.model.define.ICheckerBoard;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import com.vendor.burn.model.receive.ReceiveTimeOutException;
import com.vendor.burn.serial.workers.AbstractBurnerWorker;
import com.vendor.burn.serial.workers.AddressBurnerWorker;
import com.vendor.burn.utilitily.ToolUtils;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;

public class BoardBurnerWorker
extends AddressBurnerWorker {
    private static StringBuilder content = new StringBuilder();

    public BoardBurnerWorker(ICheckerBoard checker) {
        super(checker);
    }

    private boolean waitPowerOn(IProgressMonitor uimonitor) {
        if (ToolUtils.isDebugOn()) {
            this.println("InitBoard Start");
        }
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)TIMEOUT_SEND_FRAME_BOARD) {
            if (uimonitor.isCanceled()) {
                return false;
            }
            if (!this.checkSdkVersion(this.getCurReceived())) continue;
            return true;
        }
        BoardBurnerWorker.returnError(Messages.BoardCheckComposite_CheckBorad_WaitInit_ERROR);
        return false;
    }

    public boolean check(IProgressMonitor uimonitor) throws ReceiveTimeOutException, IOException {
        try {
            boolean initBoard;
            monitor.getEvent().setSuccess(false);
            this.setProgressMonitor(uimonitor);
            uimonitor.beginTask("Check Bad Blocks", 100);
            BoardBurnerWorker.deleteContent(content);
            uimonitor.setTaskName("Init Board");
            if (UnknownDevice.isOpenLightDebug()) {
                this.initLightState();
            }
            if (!(initBoard = this.waitPowerOn(uimonitor))) {
                lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.SERIAL.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.CPU.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
            } else {
                lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.SERIAL.name(), AbstractBurnerWorker.Light_State_E.normal.ordinal());
            }
            BoardBurnerWorker.updateLightState();
            uimonitor.internalWorked(20.0);
            uimonitor.setTaskName("Waiting for fastboot boot.");
            content.append(this.getCurReceived());
            boolean hasSdkVersion = initBoard;
            uimonitor.setTaskName("Check Bootrom Startup.");
            uimonitor.internalWorked(20.0);
            this.checkBootromInfo(content.toString(), hasSdkVersion);
            uimonitor.setTaskName("Check Fastboot and DDR Startup.");
            uimonitor.internalWorked(20.0);
            this.checkFastbootAndDdrInfo(content.toString());
            uimonitor.internalWorked(30.0);
            this.onAdataAvailable(serialReceived);
            content.append((CharSequence)serialReceived);
            monitor.getEvent().setSuccess(true);
            monitor.getEvent().setMessage(content.toString());
        }
        finally {
            uimonitor.done();
        }
        return true;
    }

    private void checkBootromInfo(String recieved, boolean hasSdkVersion) {
        if (hasSdkVersion) {
            this.readBootromInfoAck(recieved);
        } else {
            this.readBootromInfoNACK(recieved);
        }
    }

    private boolean checkSdkVersion(String recieved) {
        if (recieved != null && recieved.trim().length() != 0) {
            int indexOf = recieved.indexOf("SDK Version:");
            return indexOf != -1;
        }
        return false;
    }

    private void checkFastbootAndDdrInfo(String recieved) {
        if (recieved.length() > 0) {
            if (recieved.toString().contains("System startup")) {
                lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.BOOTROM.name(), AbstractBurnerWorker.Light_State_E.normal.ordinal());
                lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FASTBOOT_START.name(), AbstractBurnerWorker.Light_State_E.normal.ordinal());
            } else {
                lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FASTBOOT_START.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
            }
            if (recieved.toString().contains("*** Not upport current start mode")) {
                lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FLASH_AND_IMAGE_MATCH.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
            }
            fastbootFromFlash = BoardBurnerWorker.getBootFrom(recieved);
            this.checkDdrTrainingInfo(content.toString());
            this.checkRegVersion(content.toString());
            if (recieved.toString().contains("No NAND device found!!!")) {
                lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FLASH_NAND.name(), AbstractBurnerWorker.Light_State_E.warn.ordinal());
                if (fastbootFromFlash != null && fastbootFromFlash.equalsIgnoreCase("nand")) {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FLASH_AND_IMAGE_MATCH.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                } else {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FLASH_AND_IMAGE_MATCH.name(), AbstractBurnerWorker.Light_State_E.normal.ordinal());
                }
            } else if (recieved.toString().contains("NAND Check Flash Memory Controller v100 ... Found") || recieved.toString().contains("Check nand flash controller")) {
                lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FLASH_NAND.name(), AbstractBurnerWorker.Light_State_E.normal.ordinal());
                if (fastbootFromFlash != null && fastbootFromFlash.equalsIgnoreCase("emmc")) {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FLASH_AND_IMAGE_MATCH.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                } else {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FLASH_AND_IMAGE_MATCH.name(), AbstractBurnerWorker.Light_State_E.normal.ordinal());
                }
            } else if (recieved.toString().contains("start download process.")) {
                lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FLASH_NAND.name(), AbstractBurnerWorker.Light_State_E.warn.ordinal());
            }
            if (recieved.toString().contains("No MMC/SD card detect when read `SDIO_CARD_DETECT` pin.")) {
                lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FLASH_EMMC.name(), AbstractBurnerWorker.Light_State_E.warn.ordinal());
                if (fastbootFromFlash != null && fastbootFromFlash.equalsIgnoreCase("emmc")) {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FLASH_AND_IMAGE_MATCH.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                } else {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FLASH_AND_IMAGE_MATCH.name(), AbstractBurnerWorker.Light_State_E.normal.ordinal());
                }
            } else if (recieved.toString().contains("MMC/SD Card:")) {
                lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FLASH_EMMC.name(), AbstractBurnerWorker.Light_State_E.normal.ordinal());
                if (fastbootFromFlash != null && fastbootFromFlash.equalsIgnoreCase("nand")) {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FLASH_AND_IMAGE_MATCH.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                } else {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FLASH_AND_IMAGE_MATCH.name(), AbstractBurnerWorker.Light_State_E.normal.ordinal());
                }
            } else if (recieved.toString().contains("start download process.")) {
                lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FLASH_EMMC.name(), AbstractBurnerWorker.Light_State_E.warn.ordinal());
            }
            BoardBurnerWorker.updateLightState();
        }
    }

    private void checkRegVersion(String recieved) {
        if (recieved.length() > 0) {
            if (recieved.toString().contains("Reg Name:")) {
                lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.DDR_INIT.name(), AbstractBurnerWorker.Light_State_E.normal.ordinal());
                lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.DDR_TRAINING.name(), AbstractBurnerWorker.Light_State_E.normal.ordinal());
            } else {
                lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.DDR_INIT.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.DDR_TRAINING.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
            }
        }
        BoardBurnerWorker.updateLightState();
    }

    protected static String getBootFrom(String recieved) {
        String KEY = "Boot Media: ";
        int startIndex = recieved.indexOf(KEY);
        if (-1 == startIndex) {
            return null;
        }
        int endIndex = recieved.indexOf("\r\n", startIndex += KEY.length());
        if (-1 == endIndex) {
            return null;
        }
        String strCapacity = recieved.substring(startIndex, endIndex);
        return strCapacity.trim();
    }

    private void checkDdrTrainingInfo(String recieved) {
        if (recieved.length() > 0 && !recieved.equalsIgnoreCase("(OK)")) {
            if (((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) {
                if (recieved.toString().contains("WL Err")) {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.DDR_TRAINING.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                }
                if (recieved.toString().contains("HWG Err")) {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.DDR_TRAINING.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                }
                if (recieved.toString().contains("Gate Err")) {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.DDR_TRAINING.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                }
                if (recieved.toString().contains("DDRT Err")) {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.DDR_TRAINING.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                }
                if (recieved.toString().contains("HWRD Err")) {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.DDR_TRAINING.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                }
                if (recieved.toString().contains("MPR Err")) {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.DDR_TRAINING.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                }
                if (recieved.toString().contains("Dataeye Err")) {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.DDR_TRAINING.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                }
                if (recieved.toString().contains("DDRE")) {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.DDR_TRAINING.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                }
            } else {
                if (recieved.toString().contains("SWL")) {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.DDR_TRAINING.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                }
                if (recieved.toString().contains("SGA")) {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.DDR_TRAINING.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                }
                if (recieved.toString().contains("HGA")) {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.DDR_TRAINING.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                }
                if (recieved.toString().contains("HRD")) {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.DDR_TRAINING.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                }
                if (recieved.toString().contains("SRD")) {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.DDR_TRAINING.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                }
                if (recieved.toString().contains("SWD")) {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.DDR_TRAINING.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                }
                if (recieved.toString().contains("DDR training failed")) {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.DDR_TRAINING.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                }
                if (recieved.toString().contains("DDRE")) {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.DDR_TRAINING.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                }
                if (recieved.toString().contains("DDRTR") && recieved.toString().contains("Err")) {
                    lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.DDR_TRAINING.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                }
            }
            if (((Integer)lightCurrentStateMap.get(AbstractBurnerWorker.Light_E.DDR_TRAINING.name())).intValue() != AbstractBurnerWorker.Light_State_E.abnormal.ordinal()) {
                lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.DDR_TRAINING.name(), AbstractBurnerWorker.Light_State_E.normal.ordinal());
            }
        }
        BoardBurnerWorker.updateLightState();
    }
}

