/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.serial.workers;

import com.vendor.burn.jna.LibBootromByJNA;
import com.vendor.burn.model.ProductLine;
import com.vendor.burn.model.burnBootByLib.BootromStep;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.define.IFastbootProgressMonitor;
import com.vendor.burn.model.devices.IFrameSetting;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import com.vendor.burn.preferences.FastbootPreferences;
import com.vendor.burn.serial.workers.AbstractBurnerWorker;
import com.vendor.burn.serial.workers.FastbootBurnerWorker;
import com.vendor.burn.utilitily.ToolUtils;
import org.eclipse.core.runtime.SubMonitor;

public class CallLibBootromWorker
extends FastbootBurnerWorker {
    private static final int NO_CARE_CHAR = -1;
    private static SubMonitor subMonitor;
    private static long comFd;
    private static long udpFd;
    private static long socketFd;
    public static final LibBootromByJNA.JavaCallbackCancel callbackCancel;
    public static final LibBootromByJNA.JavaCallbackAdd callback;

    static {
        comFd = -1L;
        udpFd = -1L;
        socketFd = -1L;
        callbackCancel = new LibBootromByJNA.JavaCallbackCancel(){

            @Override
            public boolean isCancel() {
                if (subMonitor == null) {
                    return false;
                }
                return subMonitor.isCanceled();
            }
        };
        callback = new LibBootromByJNA.JavaCallbackAdd(){

            @Override
            public void printInfo(int nStep, String comName, String printInfo, String debugInfo, int curStepSuccess) {
                if (monitor == null) {
                    monitor = ToolUtils.isCmdLine() ? IFastbootProgressMonitor.PROGRESSMONITORCMDLINE : IFastbootProgressMonitor.PROGRESSMONITORCOMPOSITE;
                }
                if (ToolUtils.isDebugOn()) {
                    if (debugInfo != null) {
                        monitor.print(debugInfo);
                    }
                    if (printInfo != null) {
                        monitor.print(printInfo);
                    }
                }
                if (printInfo != null) {
                    CallLibBootromWorker.received(printInfo);
                }
                if (debugInfo != null && subMonitor != null && debugInfo.indexOf("%") != -1) {
                    int progress = 0;
                    try {
                        progress = Integer.parseInt(debugInfo.substring(0, debugInfo.indexOf("%")));
                        subMonitor.worked(progress);
                        subMonitor.notify();
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (printInfo != null && printInfo.length() > 0 && UnknownDevice.isOpenLightDebug()) {
                    if (curStepSuccess == 0) {
                        this.setLightDebug(nStep, printInfo, false);
                    } else {
                        this.setLightDebug(nStep, printInfo, true);
                    }
                }
            }

            private void setLightDebug(int nStep, String printInfo, boolean curStepSuccess) {
                if (nStep == -1) {
                    return;
                }
                if (nStep != BootromStep.OPEN_SERIAL_COM.ordinal()) {
                    if (nStep == BootromStep.SEND_TYPE_FRAME.ordinal()) {
                        if (curStepSuccess) {
                            CallLibBootromWorker.updateSerialLightToRight();
                        } else {
                            CallLibBootromWorker.updateSerialLightToError();
                        }
                    } else if (nStep == BootromStep.SEND_HEAD_DATA.ordinal() || nStep == BootromStep.SEND_AUX_CODE.ordinal() || nStep == BootromStep.SEND_PARAM_AREA.ordinal() || nStep == BootromStep.SEND_BOARD_FRAME.ordinal()) {
                        if (curStepSuccess && lightCurrentStateMap.get(AbstractBurnerWorker.Light_E.SERIAL.name()) != null && ((Integer)lightCurrentStateMap.get(AbstractBurnerWorker.Light_E.SERIAL.name())).intValue() == AbstractBurnerWorker.Light_State_E.abnormal.ordinal()) {
                            CallLibBootromWorker.updateSerialLightToRight();
                        }
                    } else if (nStep == BootromStep.SEND_BOOT_IMAGE.ordinal()) {
                        if (printInfo.contains("*** Not upport current start mode")) {
                            AbstractBurnerWorker.lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FLASH_AND_IMAGE_MATCH.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                            if (CallLibBootromWorker.getLightView() != null) {
                                CallLibBootromWorker.updateLightColor(CallLibBootromWorker.getLightView().getFlashTypeMatchLbl(), (Integer)lightCurrentStateMap.get(AbstractBurnerWorker.Light_E.FLASH_AND_IMAGE_MATCH.name()));
                            }
                        }
                    } else if (nStep == BootromStep.WAIT_BOOT_RUN.ordinal()) {
                        if (curStepSuccess) {
                            CallLibBootromWorker.readBootInfo(printInfo);
                        } else {
                            lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FASTBOOT_START.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                        }
                        if (printInfo.contains("*** Not upport current start mode")) {
                            AbstractBurnerWorker.lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FLASH_AND_IMAGE_MATCH.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                            if (CallLibBootromWorker.getLightView() != null) {
                                CallLibBootromWorker.updateLightColor(CallLibBootromWorker.getLightView().getFlashTypeMatchLbl(), (Integer)lightCurrentStateMap.get(AbstractBurnerWorker.Light_E.FLASH_AND_IMAGE_MATCH.name()));
                            }
                        }
                    }
                }
            }
        };
    }

    public static void setComFd(long comFd) {
        CallLibBootromWorker.comFd = comFd;
    }

    public static long getComFd() {
        return comFd;
    }

    public static long getSocketFd() {
        return socketFd;
    }

    public static void setSocketFd(long socketFd) {
        CallLibBootromWorker.socketFd = socketFd;
    }

    public static long getUdpFd() {
        return udpFd;
    }

    public static void setUdpFd(long udpFd) {
        CallLibBootromWorker.udpFd = udpFd;
    }

    public CallLibBootromWorker(IFrameSetting frameSetting, IBurner burner, SubMonitor subProgressMonitor) {
        super(frameSetting, burner);
        CallLibBootromWorker.setSubMonitor(subProgressMonitor);
        String osName = System.getProperties().getProperty("os.name");
        if (osName.toLowerCase().startsWith("windows")) {
            System.setProperty("jna.encoding", "GBK");
        } else {
            System.setProperty("jna.encoding", "UTF-8");
        }
    }

    public static boolean bootDownloadByLib(String commName, int notBareBurn, int ddrOrFlash, String filePath, int[] caType, long[] initDdrAddr, int[] errorCode) {
        int burnResult = 0;
        burnResult = !ToolUtils.isCmdLine() && FastbootPreferences.isResetBeforeBurn() && ProductLine.PRODUCTLINE.TV == ToolUtils.getProductLine() ? LibBootromByJNA.instance.Bootrom_BootDownloadReboot(commName, notBareBurn, ddrOrFlash, filePath, caType, initDdrAddr, errorCode) : LibBootromByJNA.instance.bootrom_BootDownload(commName, notBareBurn, ddrOrFlash, filePath, caType, initDdrAddr, errorCode);
        return burnResult != 0;
    }

    public static boolean Ymodem_load(long comFd, int bootDdrAddr, String fileName) {
        int burnResult = LibBootromByJNA.instance.Ymodem_load(comFd, bootDdrAddr, fileName);
        return burnResult != 0;
    }

    public static boolean Xmodem_upload(long comFd, int bootDdrAddr, int flashAddr, int lenght, String fileName) {
        int burnResult = LibBootromByJNA.instance.Xmodem_upload(comFd, bootDdrAddr, flashAddr, lenght, fileName);
        return burnResult != 0;
    }

    public static boolean createUdpSocket(String ip, int port) {
        long burnResult = LibBootromByJNA.instance.CreateUdpSocket(ip, port);
        if (burnResult == 0L) {
            return false;
        }
        CallLibBootromWorker.setUdpFd(burnResult);
        return true;
    }

    public static boolean createSerialPortServer(String ip, int port) {
        long burnResult = LibBootromByJNA.instance.CreateSerialPortServer(ip, port);
        CallLibBootromWorker.setSocketFd(burnResult);
        return burnResult != 0L;
    }

    public static void closeSocket() {
        LibBootromByJNA.instance.CloseSocket(udpFd);
        CallLibBootromWorker.setUdpFd(-1L);
    }

    public static boolean UdpSendData(String data, int dataLen) {
        int burnResult = LibBootromByJNA.instance.UdpSendData(udpFd, data, dataLen);
        return burnResult != 0;
    }

    public static int UdpRecevieData(byte[] data, int dataLen) {
        return LibBootromByJNA.instance.UdpRecevieData(udpFd, data, dataLen);
    }

    public static boolean UdpDownloadFile(String fileName, int ddrAddress) {
        int burnResult = LibBootromByJNA.instance.UdpDownloadFile(udpFd, fileName, ddrAddress);
        return burnResult != 0;
    }

    public static boolean SendData(long comFd, String data, int dataLen, int timeout) {
        int burnResult = LibBootromByJNA.instance.SendData(comFd, data, dataLen, timeout);
        return burnResult != 0;
    }

    public static boolean SendBytes(long comFd, byte[] data, int dataLen) {
        int burnResult = LibBootromByJNA.instance.SendBytes(comFd, data, dataLen);
        return burnResult != 0;
    }

    public static boolean SendDataNoReply(long comFd, String data, int dataLen) {
        int burnResult = LibBootromByJNA.instance.SendDataNoReply(comFd, data, dataLen);
        return burnResult != 0;
    }

    public static boolean CreateSerialComm(String comName) {
        long burnResult = LibBootromByJNA.instance.CreateSerialComm(comName);
        CallLibBootromWorker.setComFd(burnResult);
        return burnResult != 0L;
    }

    public static boolean DestroySerialComm(long comFd) {
        int burnResult = LibBootromByJNA.instance.DestroySerialComm(comFd);
        return burnResult != -1;
    }

    public static int ScanSerialPort(byte[] comName, int length) {
        return LibBootromByJNA.instance.ScanSerialPort(comName, length);
    }

    public static boolean RecevieData(long comFd, byte[] data, int dataLen) {
        int burnResult = LibBootromByJNA.instance.RecevieData(comFd, data, dataLen);
        return burnResult != 0;
    }

    public static boolean RecevieBytes(long comFd, byte[] data, int dataLen) {
        int burnResult = LibBootromByJNA.instance.RecevieBytes(comFd, data, dataLen);
        return burnResult != 0;
    }

    public static boolean bootDownloadByLibSocket(String serialServerIp, short serialServerPort, int notBareBurn, int ddrOrFlash, String filePath, int[] caType, long[] initDdrAddr, int[] errorCode) {
        int burnResult = LibBootromByJNA.instance.Bootrom_BootDownloadByNetwork(serialServerIp, serialServerPort, notBareBurn, ddrOrFlash, filePath, caType, initDdrAddr, errorCode);
        return burnResult != 0;
    }

    public static boolean bootDownloadByLib(String commName, int notBareBurn, int ddrOrFlash, String filePath, String chipName, int[] caType, long[] initDdrAddr, int[] errorCode) {
        int burnResult = LibBootromByJNA.instance.bootrom_BootDownloadByName(commName, notBareBurn, ddrOrFlash, filePath, chipName, ToolUtils.getInstallPath(), caType, initDdrAddr, errorCode);
        return burnResult != 0;
    }

    public static boolean bootDownloadByLibSocket(String serialServerIp, short serialServerPort, int notBareBurn, int ddrOrFlash, String filePath, String chipName, int[] caType, long[] initDdrAddr, int[] errorCode) {
        int burnResult = LibBootromByJNA.instance.Bootrom_BootDownloadByNetworkAndName(serialServerIp, serialServerPort, notBareBurn, ddrOrFlash, filePath, chipName, ToolUtils.getInstallPath(), caType, initDdrAddr, errorCode);
        return burnResult != 0;
    }

    public static SubMonitor getSubMonitor() {
        return subMonitor;
    }

    public static void setSubMonitor(SubMonitor subMonitor) {
        CallLibBootromWorker.subMonitor = subMonitor;
    }

    public static void setTypeFrameFrequency(int dwTimeout) {
        LibBootromByJNA.instance.SetTypeFrameFrequency(dwTimeout);
    }
}

