/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.serial.workers;

import com.vendor.burn.jna.LibJTAGByJNA;
import com.vendor.burn.model.ProductLine;
import com.vendor.burn.model.config.BurnConfig;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.define.IFastbootProgressMonitor;
import com.vendor.burn.model.devices.IFrameSetting;
import com.vendor.burn.preferences.FastbootPreferences;
import com.vendor.burn.preferences.JTAGPreferencePage;
import com.vendor.burn.serial.workers.FastbootBurnerWorker;
import com.vendor.burn.utilitily.ToolUtils;
import com.vendor.burn.views.FastbootView;
import org.eclipse.core.runtime.SubMonitor;

public class CallLibJTAGWorker
extends FastbootBurnerWorker {
    private static final String PURE_JTAG = "jtag";
    private static SubMonitor subMonitor;
    public static final LibJTAGByJNA.JavaCallbackCancel CANCELCALLBACK;
    public static final LibJTAGByJNA.JavaCallbackAdd JTAGPRINTINFOCALLBACK;

    static {
        CANCELCALLBACK = new LibJTAGByJNA.JavaCallbackCancel(){

            @Override
            public boolean isCancel() {
                if (subMonitor == null) {
                    return false;
                }
                return subMonitor.isCanceled();
            }
        };
        JTAGPRINTINFOCALLBACK = new LibJTAGByJNA.JavaCallbackAdd(){

            @Override
            public void printInfo(String printInfo, String debugInfo) {
                if (monitor == null) {
                    monitor = ToolUtils.isCmdLine() ? IFastbootProgressMonitor.PROGRESSMONITORCMDLINE : IFastbootProgressMonitor.PROGRESSMONITORCOMPOSITE;
                }
                if (ToolUtils.isDebugOn()) {
                    if (debugInfo != null) {
                        monitor.print(debugInfo);
                    }
                    if (printInfo != null) {
                        monitor.print(printInfo);
                    }
                }
                if (printInfo != null) {
                    CallLibJTAGWorker.received(printInfo);
                }
            }
        };
    }

    public CallLibJTAGWorker(IFrameSetting frameSetting, IBurner burner, SubMonitor subProgressMonitor) {
        super(frameSetting, burner);
        CallLibJTAGWorker.setSubMonitor(subProgressMonitor);
        String osName = System.getProperties().getProperty("os.name");
        if (osName.toLowerCase().startsWith("windows")) {
            System.setProperty("jna.encoding", "GBK");
        } else {
            System.setProperty("jna.encoding", "UTF-8");
        }
    }

    public static boolean bootDownloadByLib(int jtagChipType, String commName, int ddrOrFlash, long[] initDdrAddr, String filePath, String dllPath, int[] errorCode, int level) {
        int ft2232Chip = 0;
        ProductLine.PRODUCTLINE productLine = ToolUtils.getProductLine();
        if (productLine == ProductLine.PRODUCTLINE.TV) {
            if (!FastbootView.getCurrentChip().equalsIgnoreCase("CJXX0VXX6")) {
                ft2232Chip = 2;
            }
        } else {
            String jtagSmallBroadModel;
            ft2232Chip = ToolUtils.isCmdLine() ? BurnConfig.getBoardConfig().getSmallboradmodel() : ((jtagSmallBroadModel = FastbootPreferences.getJtagSmallBoradModel()).equals(JTAGPreferencePage.getJTAGSMALLMODELTYPELIST()[0][0]) ? 0 : 1);
        }
        CallLibJTAGWorker.jtag_SetFT2232Chip(ft2232Chip);
        if (jtagChipType == LibJTAGByJNA.EJtagChipType.CJ3X0VXX1.ordinal() || jtagChipType == LibJTAGByJNA.EJtagChipType.CJ3X1VXX6.ordinal() || jtagChipType == LibJTAGByJNA.EJtagChipType.CJ309V100.ordinal() || jtagChipType == LibJTAGByJNA.EJtagChipType.CJXX0VXX5.ordinal() || jtagChipType == LibJTAGByJNA.EJtagChipType.CJ3X1VXX3.ordinal() || jtagChipType == LibJTAGByJNA.EJtagChipType.CJXX0VXX6.ordinal()) {
            commName = PURE_JTAG;
        }
        LibJTAGByJNA.instance.jtag_SetFrequency(level);
        int burnResult = LibJTAGByJNA.instance.jtag_BootDownload(jtagChipType, commName, ddrOrFlash, initDdrAddr, filePath, dllPath, errorCode);
        return burnResult != 0;
    }

    public static String sendCmdByJtag(byte[] data, int length, long timeout) {
        if (FastbootView.getJtagChipTypeByChipName() == LibJTAGByJNA.EJtagChipType.CJXX0VXX5 || FastbootView.getJtagChipTypeByChipName() == LibJTAGByJNA.EJtagChipType.CJXX0VXX6) {
            return LibJTAGByJNA.instance.jtag_SendCmd_Semihosting(data, length, timeout);
        }
        return LibJTAGByJNA.instance.jtag_SendCmd(data, length, timeout);
    }

    public static boolean sendFileByJtag(String filePath, long ddrAddr) {
        return LibJTAGByJNA.instance.jtag_LoadFile(filePath, ddrAddr);
    }

    public static boolean dumpFileByJtag(String filePath, long ddrAddr, long length) {
        return LibJTAGByJNA.instance.jtag_DumpFile(filePath, ddrAddr, length);
    }

    public static void releaseJtag() {
        LibJTAGByJNA.instance.jtag_Release();
    }

    public static boolean jtag_StartSignalTest() {
        return LibJTAGByJNA.instance.jtag_StartSignalTest();
    }

    public static boolean jtag_StopSignalTest() {
        return LibJTAGByJNA.instance.jtag_StopSignalTest();
    }

    public static void jtag_SetFT2232Chip(int ft2232Model) {
        LibJTAGByJNA.instance.jtag_SetFT2232Chip(ft2232Model);
    }

    public static void printDebugInfo(String debugInfo) {
        if (ToolUtils.isDebugOn()) {
            if (monitor != null) {
                monitor.print(debugInfo);
            } else {
                System.out.print(debugInfo);
            }
        }
    }

    public static SubMonitor getSubMonitor() {
        return subMonitor;
    }

    public static void setSubMonitor(SubMonitor subMonitor) {
        CallLibJTAGWorker.subMonitor = subMonitor;
    }
}

