/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.serial.workers;

import com.vendor.burn.Messages;
import com.vendor.burn.jna.LibAndroidUsbByJNA;
import com.vendor.burn.jna.LibUsbByJNA;
import com.vendor.burn.model.TransferWay;
import com.vendor.burn.model.config.BurnConfig;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.define.IFastbootProgressMonitor;
import com.vendor.burn.model.devices.IFrameSetting;
import com.vendor.burn.model.event.FastbootEvent;
import com.vendor.burn.serial.workers.FastbootBurnerWorker;
import com.vendor.burn.utilitily.ToolUtils;
import com.vendor.burn.views.FastbootView;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class CallLibUSBWorker
extends FastbootBurnerWorker {
    private static boolean connected = false;
    private static long[] handle = new long[1];
    private static final int CJ1X0VXX1_VID = 4817;
    private static final int CJ1X0VXX1_PID = 53249;
    private static final int OPEN_SUCCESS = 0;
    private static final int DOWNLOAD_SUCCESS = 1;
    public static final int SEND_TIMEOUT = 5000;
    public static final int RECV_TIMEOUT = 10000;
    public static final int RECV_IGNORE_TIMEOUT = 1000;
    public static final int GET_CUR_RECEIVED_LEN = 1024;
    public static final int WAIT_BOOT_RUN_RECE_LEN = 512;
    private static SubMonitor subMonitor;
    public static final LibUsbByJNA.JavaCallbackCancel callbackCancel;
    public static final LibUsbByJNA.JavaCallbackAdd callback;
    public static final LibAndroidUsbByJNA.JavaCallbackCancel CALL_FASTBOOT_BACK_CANCEL;
    public static final LibAndroidUsbByJNA.JavaCallbackAdd CALL_FASTBOOT_BACK_CALLBACK;

    static {
        callbackCancel = new LibUsbByJNA.JavaCallbackCancel(){

            @Override
            public boolean isCancel() {
                if (subMonitor == null) {
                    return false;
                }
                return subMonitor.isCanceled();
            }
        };
        callback = new LibUsbByJNA.JavaCallbackAdd(){

            @Override
            public void printInfo(String printInfo, String debugInfo) {
                if (ToolUtils.isDebugOn() && monitor != null) {
                    monitor.print(debugInfo);
                }
                CallLibUSBWorker.received(printInfo);
                if (debugInfo != null && subMonitor != null && debugInfo.indexOf("%") != -1) {
                    int progress = 0;
                    try {
                        progress = Integer.parseInt(debugInfo.substring(0, debugInfo.indexOf("%")));
                        subMonitor.worked(progress);
                        subMonitor.notify();
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        };
        CALL_FASTBOOT_BACK_CANCEL = new LibAndroidUsbByJNA.JavaCallbackCancel(){

            @Override
            public boolean isCancel() {
                if (subMonitor == null) {
                    return false;
                }
                return subMonitor.isCanceled();
            }
        };
        CALL_FASTBOOT_BACK_CALLBACK = new LibAndroidUsbByJNA.JavaCallbackAdd(){

            @Override
            public void printInfo(String printInfo, String debugInfo) {
                if (ToolUtils.isDebugOn() && monitor != null) {
                    monitor.print(debugInfo);
                }
                CallLibUSBWorker.received(printInfo);
                if (debugInfo != null && subMonitor != null && debugInfo.indexOf("%") != -1) {
                    int progress = 0;
                    try {
                        progress = Integer.parseInt(debugInfo.substring(0, debugInfo.indexOf("%")));
                        subMonitor.worked(progress);
                        subMonitor.notify();
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        };
    }

    public CallLibUSBWorker(IFrameSetting frameSetting, IBurner burner, SubMonitor subProgressMonitor) {
        super(frameSetting, burner);
        CallLibUSBWorker.setSubMonitor(subProgressMonitor);
        String osName = System.getProperties().getProperty("os.name");
        if (osName.toLowerCase().startsWith("windows")) {
            System.setProperty("jna.encoding", "GBK");
        } else {
            System.setProperty("jna.encoding", "UTF-8");
        }
    }

    public static boolean openUsb(IProgressMonitor uimonitor, long timeout, TransferWay transferWay, String serialNumber) {
        if (transferWay == TransferWay.UsbAndSerial || FastbootView.isSupportUsbNonNude(transferWay)) {
            LibAndroidUsbByJNA.instance.RegisterPrint(CALL_FASTBOOT_BACK_CALLBACK);
            LibAndroidUsbByJNA.instance.RegisterCancel(CALL_FASTBOOT_BACK_CANCEL);
        } else {
            LibUsbByJNA.instance.RegisterPrint(callback);
            LibUsbByJNA.instance.RegisterCancel(callbackCancel);
        }
        long startTime = System.currentTimeMillis();
        int openResult = 1;
        while (System.currentTimeMillis() - startTime < timeout) {
            if (!connected) {
                if (uimonitor.isCanceled()) {
                    FastbootEvent event;
                    if (monitor != null && (event = monitor.getEvent()) != null) {
                        event.setUserCanceled(true);
                        event.setSuccess(false);
                        event.setMessage("User Cancelled!");
                    }
                    return false;
                }
                if (transferWay == TransferWay.UsbAndSerial || FastbootView.isSupportUsbNonNude(transferWay)) {
                    boolean isExistsSerial = true;
                    if (ToolUtils.isCmdLine()) {
                        isExistsSerial = false;
                    } else {
                        serialNumber = null;
                    }
                    openResult = LibAndroidUsbByJNA.instance.USB_Open(handle, isExistsSerial, serialNumber);
                } else {
                    int usbDeviceNumber = BurnConfig.getUsbDeviceNumber();
                    openResult = usbDeviceNumber == -1 ? LibUsbByJNA.instance.USB_Open(handle, 4817, 53249) : LibUsbByJNA.instance.USB_Open_Multiple(handle, 4817, 53249, usbDeviceNumber);
                }
                if (openResult != 0) continue;
                System.out.println("Open USB Success");
                connected = true;
                return true;
            }
            return true;
        }
        System.out.println("Open USB: " + openResult);
        return CallLibUSBWorker.checkReturn(monitor, openResult);
    }

    public static void closeUsb(TransferWay transferWay) {
        if (connected) {
            if (transferWay == TransferWay.UsbAndSerial || FastbootView.isSupportUsbNonNude(transferWay)) {
                LibAndroidUsbByJNA.instance.USB_Close(handle[0]);
            } else {
                LibUsbByJNA.instance.USB_Close(handle[0]);
            }
            connected = false;
        }
    }

    public static boolean sendDataByUsb(byte[] pData, int nLen, TransferWay transferWay) {
        if (connected) {
            int sendLen = -1;
            sendLen = transferWay == TransferWay.UsbAndSerial || transferWay == TransferWay.GPT || FastbootView.isCJ309V100_CA_N_Series() && transferWay == TransferWay.USBNonNude ? LibAndroidUsbByJNA.instance.USB_SendData(handle[0], pData, nLen, 5000) : LibUsbByJNA.instance.USB_SendData(handle[0], pData, nLen, 5000);
            return sendLen == nLen;
        }
        return false;
    }

    public static boolean recvDataUsb(byte[] pData, int nLen, TransferWay transferWay) {
        if (connected) {
            int recvLen = -1;
            recvLen = transferWay == TransferWay.UsbAndSerial || FastbootView.isSupportUsbNonNude(transferWay) || transferWay == TransferWay.GPT ? LibAndroidUsbByJNA.instance.USB_RecvData(handle[0], pData, nLen, 5000) : LibUsbByJNA.instance.USB_RecvData(handle[0], pData, nLen, 10000);
            return recvLen == nLen;
        }
        return false;
    }

    public static int recvDataUsbIgnore(byte[] pData, int nLen, TransferWay transferWay) {
        if (connected) {
            if (transferWay == TransferWay.UsbAndSerial || FastbootView.isSupportUsbNonNude(transferWay)) {
                return LibAndroidUsbByJNA.instance.USB_RecvData(handle[0], pData, nLen, 10000);
            }
            return LibUsbByJNA.instance.USB_RecvData(handle[0], pData, nLen, 1000);
        }
        return 0;
    }

    public static boolean downloadFileGptByUsb(File file) {
        String filePath = file.getPath();
        if (connected) {
            int downloadResult = LibAndroidUsbByJNA.instance.USB_DownloadFileGpt(handle[0], filePath);
            return downloadResult == 1;
        }
        return false;
    }

    public static boolean downloadFileByUsb(File file, int ddrAddress, TransferWay transferWay) {
        String filePath = file.getPath();
        if (connected) {
            int downloadResult = -1;
            downloadResult = transferWay == TransferWay.UsbAndSerial || FastbootView.isSupportUsbNonNude(transferWay) ? LibAndroidUsbByJNA.instance.USB_DownloadFile(handle[0], filePath, ddrAddress) : LibUsbByJNA.instance.USB_DownloadFile(handle[0], filePath, ddrAddress);
            return downloadResult == 1;
        }
        return false;
    }

    public static boolean uploadFileByUsb(File file, int ddrAddress, int length, TransferWay transferWay) {
        String filePath = file.getPath();
        if (connected) {
            int downloadResult = 0;
            downloadResult = transferWay == TransferWay.UsbAndSerial || FastbootView.isSupportUsbNonNude(transferWay) ? LibAndroidUsbByJNA.instance.USB_UploadFile(handle[0], filePath, ddrAddress, length) : LibUsbByJNA.instance.USB_UploadFile(handle[0], filePath);
            return downloadResult == 1;
        }
        return false;
    }

    public static boolean eraseGptPartByUSB(String partitonName, int timeout) {
        if (connected) {
            int downloadResult = LibAndroidUsbByJNA.instance.USB_EraseGptPartiton(handle[0], partitonName, timeout);
            return downloadResult == 1;
        }
        return false;
    }

    public static boolean eraseFlashByUSB(int ddrAddress, int length, int timeout) {
        if (connected) {
            int downloadResult = LibAndroidUsbByJNA.instance.USB_EraseFlash(handle[0], ddrAddress, length, timeout);
            return downloadResult == 1;
        }
        return false;
    }

    public static boolean isConnected() {
        return connected;
    }

    public static boolean checkReturn(IFastbootProgressMonitor monitor, int input) {
        boolean result = false;
        LibUsbEnum returnValue = LibUsbEnum.valueOf(input);
        if (returnValue == null) {
            return result;
        }
        switch (returnValue) {
            case LIBUSB_SUCCESS: {
                result = true;
                break;
            }
            case LIBUSB_TIMEOUT: {
                monitor.getEvent().setMessage(Messages.ERROR_USB_OPEN_TIMEOUT);
                break;
            }
            case LIBUSB_ERROR_IO: {
                monitor.getEvent().setMessage(NLS.bind((String)Messages.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_IO.name()));
                break;
            }
            case LIBUSB_ERROR_INVALID_PARAM: {
                monitor.getEvent().setMessage(NLS.bind((String)Messages.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_INVALID_PARAM.name()));
                break;
            }
            case LIBUSB_ERROR_ACCESS: {
                monitor.getEvent().setMessage(NLS.bind((String)Messages.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_ACCESS.name()));
                break;
            }
            case LIBUSB_ERROR_NO_DEVICE: {
                monitor.getEvent().setMessage(NLS.bind((String)Messages.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_NO_DEVICE.name()));
                break;
            }
            case LIBUSB_ERROR_NOT_FOUND: {
                monitor.getEvent().setMessage(NLS.bind((String)Messages.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_NOT_FOUND.name()));
                break;
            }
            case LIBUSB_ERROR_BUSY: {
                monitor.getEvent().setMessage(NLS.bind((String)Messages.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_BUSY.name()));
                break;
            }
            case LIBUSB_ERROR_TIMEOUT: {
                monitor.getEvent().setMessage(NLS.bind((String)Messages.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_TIMEOUT.name()));
                break;
            }
            case LIBUSB_ERROR_OVERFLOW: {
                monitor.getEvent().setMessage(NLS.bind((String)Messages.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_OVERFLOW.name()));
                break;
            }
            case LIBUSB_ERROR_PIPE: {
                monitor.getEvent().setMessage(NLS.bind((String)Messages.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_PIPE.name()));
                break;
            }
            case LIBUSB_ERROR_INTERRUPTED: {
                monitor.getEvent().setMessage(NLS.bind((String)Messages.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_INTERRUPTED.name()));
                break;
            }
            case LIBUSB_ERROR_NO_MEM: {
                monitor.getEvent().setMessage(NLS.bind((String)Messages.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_NO_MEM.name()));
                break;
            }
            case LIBUSB_ERROR_NOT_SUPPORTED: {
                monitor.getEvent().setMessage(NLS.bind((String)Messages.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_NOT_SUPPORTED.name()));
                break;
            }
            case LIBUSB_ERROR_OTHER: {
                monitor.getEvent().setMessage(NLS.bind((String)Messages.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_OTHER.name()));
                break;
            }
        }
        return result;
    }

    public static <T> LibUsbEnum getEnum(int index) {
        Class<LibUsbEnum> clazz = LibUsbEnum.class;
        T[] c = clazz.getEnumConstants();
        return (LibUsbEnum)((Object)c[index]);
    }

    public static SubMonitor getSubMonitor() {
        return subMonitor;
    }

    public static void setSubMonitor(SubMonitor subMonitor) {
        CallLibUSBWorker.subMonitor = subMonitor;
    }

    public static enum LibUsbEnum {
        LIBUSB_SUCCESS(0),
        LIBUSB_TIMEOUT(1),
        LIBUSB_ERROR_IO(-1),
        LIBUSB_ERROR_INVALID_PARAM(-2),
        LIBUSB_ERROR_ACCESS(-3),
        LIBUSB_ERROR_NO_DEVICE(-4),
        LIBUSB_ERROR_NOT_FOUND(-5),
        LIBUSB_ERROR_BUSY(-6),
        LIBUSB_ERROR_TIMEOUT(-7),
        LIBUSB_ERROR_OVERFLOW(-8),
        LIBUSB_ERROR_PIPE(-9),
        LIBUSB_ERROR_INTERRUPTED(-10),
        LIBUSB_ERROR_NO_MEM(-11),
        LIBUSB_ERROR_NOT_SUPPORTED(-12),
        LIBUSB_ERROR_OTHER(-99);

        private int value = 0;

        private LibUsbEnum(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static LibUsbEnum valueOf(String string) {
            return Enum.valueOf(LibUsbEnum.class, string);
        }
    }
}

