/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.serial.workers;

import com.vendor.burn.commands.CrcCommand;
import com.vendor.burn.model.AlgorithmType;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.event.EventType;
import com.vendor.burn.serial.workers.CallLibJTAGWorker;
import com.vendor.burn.serial.workers.PartitionBurnerWorker;
import com.vendor.platform.api.statistics.ToolStatistics;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class CheckSumBurnerWorker
extends PartitionBurnerWorker {
    public CheckSumBurnerWorker(IBurner burner) {
        super(burner);
        this.burner = burner;
    }

    public boolean checkSum(IProgressMonitor uiMonitor, File file, boolean call, final Text checkSumResultText, AlgorithmType checkSumType) {
        ToolStatistics.INSTANCE.logUsage("BurnTool", "Check Sum", "ChipName: " + this.burner.getBurnContext().getDeviceSetting().getName());
        ToolStatistics.INSTANCE.logToolInUse("BurnTool");
        String versionInfo = this.getVersionInfo("Check Sum");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        monitor.getEvent().init(EventType.CHECK_SUM);
        if (uiMonitor.isCanceled()) {
            monitor.getEvent().setUserCanceled(true);
            return false;
        }
        uiMonitor.beginTask("Checking Sum", 100);
        if (uiMonitor.isCanceled()) {
            monitor.getEvent().setUserCanceled(true);
            return false;
        }
        if (checkSumType == null) {
            return false;
        }
        String result = "";
        try {
            if (checkSumType.equals((Object)AlgorithmType.CUMULATIVE_SUM)) {
                result = Integer.toHexString(CrcCommand.calculateCheckSum(file));
                result = this.alignByByte(result, 8);
            } else {
                result = Integer.toHexString(CrcCommand.calculateCRC16(file));
                result = this.alignByByte(result, 4);
            }
        }
        catch (IOException iOException) {}
        final String resultStr = "0x" + result;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                checkSumResultText.setText(resultStr);
            }
        });
        uiMonitor.worked(100);
        CheckSumBurnerWorker.warning("Check Sum Results: " + resultStr + "\n");
        this.infoln("The Check Sum successfully!");
        return true;
    }

    public String alignByByte(String str, int size) {
        StringBuilder sb = new StringBuilder();
        int num = size - str.length();
        if (size - str.length() > 0) {
            int j = 0;
            while (j < num) {
                sb.append("0");
                ++j;
            }
        }
        sb.append(str);
        return sb.toString();
    }
}

