/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.serial.workers;

import com.vendor.burn.analysis.TimeLogger;
import com.vendor.burn.commands.EraseCommand;
import com.vendor.burn.commands.INFOCommand;
import com.vendor.burn.commands.MWCommand;
import com.vendor.burn.commands.ReadCommand;
import com.vendor.burn.commands.SFCommand;
import com.vendor.burn.commands.WriteCommand;
import com.vendor.burn.jna.LibJTAGByJNA;
import com.vendor.burn.model.ChipID;
import com.vendor.burn.model.FileSystem;
import com.vendor.burn.model.FlashType;
import com.vendor.burn.model.PartitionItem;
import com.vendor.burn.model.PlatformType;
import com.vendor.burn.model.TransferWay;
import com.vendor.burn.model.cmdline.BurnStatus;
import com.vendor.burn.model.config.PreferenceConfig;
import com.vendor.burn.model.devices.burners.CommonBurner;
import com.vendor.burn.model.devices.unknown.UDFrameSetting;
import com.vendor.burn.model.devices.unknown.UDProperties;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import com.vendor.burn.model.event.EventType;
import com.vendor.burn.model.receive.ReceiveTimeOutException;
import com.vendor.burn.preferences.FastbootPreferences;
import com.vendor.burn.serial.workers.CallLibJTAGWorker;
import com.vendor.burn.serial.workers.CallLibUSBWorker;
import com.vendor.burn.serial.workers.EmmcPartitionBurnerWorker;
import com.vendor.burn.utilitily.FileUtils;
import com.vendor.burn.utilitily.ToolUtils;
import com.vendor.burn.views.FastbootView;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.preference.IPreferenceStore;

public class CommonBurnerWorker
extends EmmcPartitionBurnerWorker {
    public static final String FASTBOOT_NAME = "fastboot";
    public static final String BOOT = "boot";
    public static final String BOOTONE = "boot1";
    public static final String BOOTTWO = "boot2";
    public static final String USERBOOT = "userBoot";

    public CommonBurnerWorker(CommonBurner burner) {
        super(burner);
    }

    @Override
    public boolean burn(IProgressMonitor uimonitor, List<PartitionItem> parts) throws IOException, ReceiveTimeOutException {
        if (!ToolUtils.isCmdLine()) {
            String versionInfo = this.getVersionInfo("Burn By Partition");
            CallLibJTAGWorker.printDebugInfo(versionInfo);
        }
        this.registerJnaFunction(uimonitor, 100);
        if (UnknownDevice.isOpenLightDebug()) {
            this.initLightState();
        }
        long burnStartTime = System.currentTimeMillis();
        int selectedPartCount = this.getSelectedPartCount(parts);
        this.setProgressMonitor(uimonitor);
        CommonBurnerWorker.getMonitor().getEvent().init(EventType.BURN);
        uimonitor.beginTask("Burn By Partition", 100 * selectedPartCount);
        boolean result = this.burnByTransferWay(uimonitor, parts, selectedPartCount, new int[1]);
        long burnTotalTime = System.currentTimeMillis() - burnStartTime;
        String burnTotalTimeStr = this.calculateBurnTotalTime(burnTotalTime);
        CommonBurnerWorker.getMonitor().getEvent().setTotalBurnTime(burnTotalTimeStr);
        this.printDebugTimeLogger(parts.get(0), burnTotalTime);
        return result;
    }

    @Override
    public boolean erase(IProgressMonitor uimonitor, List<PartitionItem> parts) throws IOException, ReceiveTimeOutException {
        boolean isEmmcOrUfs;
        this.setProgressMonitor(uimonitor);
        int selected = 0;
        for (PartitionItem partitionItem : parts) {
            if (!partitionItem.isChecked()) continue;
            ++selected;
        }
        int totalWork = (selected + 2) * 100;
        uimonitor.beginTask("", totalWork);
        uimonitor.setTaskName("Init Board");
        SubMonitor subProgressMonitor = SubMonitor.convert((IProgressMonitor)uimonitor, (String)"", (int)100);
        if (!ToolUtils.isCmdLine()) {
            String versionInfo = this.getVersionInfo("Erase Partitions");
            CallLibJTAGWorker.printDebugInfo(versionInfo);
        }
        this.registerJnaFunction(uimonitor, 100);
        ArrayList<FlashType> hasFlashTypes = FlashType.getCurFlashTypes(parts);
        TransferWay curTransferWay = this.getBurner().getBurnContext().getTransferWay();
        boolean result = this.startbootForNoneNude(uimonitor, parts, hasFlashTypes, curTransferWay);
        if (!result) {
            return result;
        }
        if (!this.sendSsdByPci(parts)) {
            return false;
        }
        uimonitor.worked(100);
        uimonitor.setTaskName("Erase Partitions");
        int partsSize = parts.size();
        boolean bl = isEmmcOrUfs = this.isHasFlash(hasFlashTypes, FlashType.emmc) || this.isHasFlash(hasFlashTypes, FlashType.ufs) || this.isHasFlash(hasFlashTypes, FlashType.ssd);
        if (this.getBurner().getBurnContext().getBoardConfig().isSocket() && isEmmcOrUfs) {
            this.getDdrFreeBaseAddr(this.burner.getBurnContext().getTransferWay());
        }
        int index = 0;
        while (index < partsSize) {
            if (uimonitor.isCanceled()) break;
            PartitionItem part = parts.get(index);
            if (part.isChecked()) {
                CommonBurnerWorker.getMonitor().highlight(part);
                String partitionName = part.getName() == null ? "" : part.getName();
                uimonitor.subTask("Partition: " + partitionName);
                if (curTransferWay == TransferWay.GPT) {
                    if (part.getName() != null) {
                        this.infoln("\nSend command:\terase: " + part.getName());
                        if (!CallLibUSBWorker.eraseGptPartByUSB(part.getName(), 3000)) {
                            return false;
                        }
                        this.infoln("Partition " + partitionName + " Erased successfully!");
                    }
                } else {
                    FlashType flashType = part.getFlashType();
                    if (FlashType.emmc == flashType || FlashType.ufs == flashType || FlashType.ssd == flashType) {
                        result = this.eraseEmmcPart(subProgressMonitor, part);
                    } else {
                        if (ToolUtils.isJTagTransferMode(this.getBurner().getBurnContext().getTransferWay())) {
                            new CallLibJTAGWorker(this.frameSetting, this.burner, subProgressMonitor);
                            LibJTAGByJNA.instance.jtag_RegisterPrint(CallLibJTAGWorker.JTAGPRINTINFOCALLBACK);
                            LibJTAGByJNA.instance.jtag_RegisterCancel(CallLibJTAGWorker.CANCELCALLBACK);
                        }
                        result = this.eraseForNandorSpi(subProgressMonitor, partsSize, index, part);
                    }
                }
                if (!result && !ToolUtils.isCmdLine()) {
                    this.sendResetCommand();
                    return result;
                }
                uimonitor.worked(100);
            }
            ++index;
        }
        this.sendResetCommand();
        return true;
    }

    @Override
    public boolean eraseAll(IProgressMonitor uimonitor, List<PartitionItem> parts) throws IOException, ReceiveTimeOutException {
        boolean hasUfs;
        boolean hasEmmc;
        boolean hasSpi;
        this.setProgressMonitor(uimonitor);
        parts = ((CommonBurner)this.getBurner()).getChildren();
        int selected = 0;
        for (PartitionItem partitionItem : parts) {
            if (!partitionItem.isChecked()) continue;
            ++selected;
        }
        int totalWork = (selected + 2) * 100;
        uimonitor.beginTask("", totalWork);
        uimonitor.setTaskName("Init Board");
        String versionInfo = this.getVersionInfo("Erase all partitions");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        this.registerJnaFunction(uimonitor, 100);
        ArrayList<FlashType> hasFlashTypes = FlashType.getCurFlashTypes(parts);
        if (hasFlashTypes.size() == 0) {
            hasFlashTypes = FlashType.getCurAllFlashTypes(parts);
        }
        TransferWay curTransferWay = this.getBurner().getBurnContext().getTransferWay();
        boolean result = true;
        result = this.startbootForNoneNude(uimonitor, parts, null, curTransferWay);
        if (!result) {
            return result;
        }
        boolean hasNand = this.isHasFlash(hasFlashTypes, FlashType.nand);
        if (hasNand) {
            result = this.eraseNand(hasFlashTypes);
        }
        if (hasSpi = this.isHasFlash(hasFlashTypes, FlashType.spi)) {
            result = this.eraseAllSpi(hasFlashTypes, parts);
        }
        if (hasEmmc = this.isHasFlash(hasFlashTypes, FlashType.emmc)) {
            result = this.eraseEmmcOrUfs(uimonitor, FlashType.emmc);
        }
        if (hasUfs = this.isHasFlash(hasFlashTypes, FlashType.ufs)) {
            result = this.eraseEmmcOrUfs(uimonitor, FlashType.ufs);
        }
        if (!result) {
            CommonBurnerWorker.returnError("Failed to Erase all partitions!");
            return false;
        }
        this.infoln("Erase all partitions successfully!");
        uimonitor.worked(100);
        return result;
    }

    @Override
    public boolean upload(IProgressMonitor uimonitor, List<PartitionItem> parts) throws IOException, ReceiveTimeOutException {
        CommonBurnerWorker.getMonitor().getEvent().init(EventType.UPLOAD);
        this.setProgressMonitor(uimonitor);
        int selected = 0;
        for (PartitionItem partitionItem : parts) {
            if (!partitionItem.isChecked()) continue;
            ++selected;
        }
        int totalWork = (selected + 2) * 100;
        uimonitor.beginTask("", totalWork);
        uimonitor.setTaskName("Init Board");
        String versionInfo = this.getVersionInfo("Uploading Partitions");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        this.registerJnaFunction(uimonitor, totalWork);
        ArrayList<FlashType> hasFlashTypes = FlashType.getCurFlashTypes(parts);
        TransferWay curTransferWay = this.getBurner().getBurnContext().getTransferWay();
        boolean result = this.startbootForNoneNude(uimonitor, parts, hasFlashTypes, curTransferWay);
        if (!result) {
            return result;
        }
        if (!this.sendSsdByPci(parts)) {
            return false;
        }
        uimonitor.worked(100);
        uimonitor.setTaskName("Setting Up Network");
        TransferWay transferWay = this.getBurner().getBurnContext().getTransferWay();
        if (this.isNeedSetupNet(transferWay) && !this.setupNetwork(transferWay)) {
            CommonBurnerWorker.returnError("Failed to setup network!");
            return false;
        }
        uimonitor.setTaskName("Uploading Partitions");
        int partsSize = parts.size();
        boolean isBeginTask = false;
        int partIndex = 0;
        while (partIndex < parts.size()) {
            PartitionItem partition = parts.get(partIndex);
            if (partition.isChecked()) {
                FileSystem uploadFileSystem = partition.getFileSystem();
                String start = Long.toHexString(partition.getStart());
                String length = Long.toHexString(partition.getLength());
                FlashType flashType = partition.getFlashType();
                File file = partition.getFile();
                if (FlashType.emmc == flashType || FlashType.ufs == flashType || FlashType.ssd == flashType) {
                    if (isBeginTask) {
                        uimonitor.beginTask("Uploading Partitions", selected * 100);
                        isBeginTask = false;
                    }
                    result = this.uploadPartForEmmc(uimonitor, partsSize, partIndex, partition);
                } else {
                    isBeginTask = true;
                    this.setFlashType(partition.getFlashType());
                    result = this.upload(uimonitor, file, uploadFileSystem, start, length, false, ChipID.chip0);
                }
                if (!result) {
                    this.sendResetCommand();
                    return result;
                }
                --selected;
            }
            ++partIndex;
        }
        this.sendResetCommand();
        uimonitor.worked(100);
        return true;
    }

    @Override
    public boolean createImage(IProgressMonitor uiMonitor, File file, List<PartitionItem> parts, boolean call) {
        return super.createImage(uiMonitor, file, parts, call);
    }

    private boolean uploadPartForEmmc(IProgressMonitor uiMonitor, int partsSize, int partIndex, PartitionItem partition) throws IOException, ReceiveTimeOutException {
        String partitionName = partition.getName() == null ? "" : partition.getName();
        uiMonitor.subTask("Parition:" + partitionName);
        CommonBurnerWorker.getMonitor().highlight(partition);
        File file = partition.getFile();
        long start = partition.getStart();
        long length = partition.getLength();
        FlashType flashType = partition.getFlashType();
        if (length == -1L && partIndex == partsSize - 1) {
            long neMMCCapacity = this.geteMMCSpaceSize(flashType);
            if (0L == neMMCCapacity) {
                CommonBurnerWorker.warningln("Failed to get eMMC capacity!");
                return false;
            }
            length = neMMCCapacity - start;
            String errorType = "All eMMC remain space ";
            if (flashType == FlashType.ufs) {
                errorType = "All ufs remain space ";
            }
            CommonBurnerWorker.warningln(String.valueOf(errorType) + length + " Bytes allotted to last partition!");
        }
        long uploadAddress = start / 512L;
        long uploadLength = length / 512L;
        int partCount = (int)(length / 0x2000000L);
        if (length % 0x2000000L != 0L) {
            ++partCount;
        }
        TransferWay transferWay = this.getBurner().getBurnContext().getTransferWay();
        File tmpFile = null;
        try {
            tmpFile = this.createFile(String.valueOf(file.getPath()) + ".tmp", partitionName);
            if (tmpFile == null) {
                CommonBurnerWorker.returnError("Failed to upload " + partitionName + " partition!");
                return false;
            }
            if (transferWay != TransferWay.UsbAndSerial && !FastbootView.isSupportUsbNonNude(transferWay)) {
                this.switchTFTPDownloadHome(tmpFile);
            }
            if (partCount == 1) {
                boolean result = this.sendCommand(ReadCommand.readMMC_0_Destination_(this.getHexStartAddress(), Long.toHexString(uploadAddress), Long.toHexString(uploadLength), flashType));
                if (result) {
                    result = this.uploadByTrans(uiMonitor, length, tmpFile);
                }
                if (!result) {
                    CommonBurnerWorker.returnError("Failed to upload " + partitionName + " partition!");
                    return false;
                }
                uiMonitor.worked(100);
                this.infoln("Partition uploaded successfully!");
            } else {
                int i = 0;
                while (i < partCount) {
                    block50: {
                        File partFile = this.createFile(String.valueOf(file.getPath()) + ".part" + i, partitionName);
                        if (partFile == null) {
                            return false;
                        }
                        long partUploadAddress = uploadAddress + (long)i * 65536L;
                        long partUploadRealLength = 0L;
                        long partUploadLength = 0L;
                        if (i == partCount - 1) {
                            partUploadRealLength = length - (long)i * 0x2000000L;
                            partUploadLength = uploadLength - (long)i * 65536L;
                        } else {
                            partUploadRealLength = 0x2000000L;
                            partUploadLength = 65536L;
                        }
                        boolean result = this.sendCommand(ReadCommand.readMMC_0_Destination_(this.getHexStartAddress(), Long.toHexString(partUploadAddress), Long.toHexString(partUploadLength), flashType));
                        if (result) {
                            result = this.uploadByTrans(uiMonitor, partUploadRealLength, partFile);
                        }
                        if (!result) {
                            CommonBurnerWorker.returnError("Failed to upload " + partitionName + " partition!");
                            return false;
                        }
                        this.infoln("Partition part " + i + " uploaded successfully!");
                        BufferedInputStream bis = null;
                        RandomAccessFile raf = null;
                        try {
                            try {
                                bis = new BufferedInputStream(new FileInputStream(partFile));
                                raf = new RandomAccessFile(tmpFile, "rw");
                                raf.seek(tmpFile.length());
                                byte[] buffer = new byte[512];
                                int readSize = 0;
                                while ((readSize = bis.read(buffer, 0, buffer.length)) != -1) {
                                    raf.write(buffer, 0, readSize);
                                }
                            }
                            catch (IOException iOException) {
                                try {
                                    if (raf != null) {
                                        raf.close();
                                    }
                                }
                                catch (IOException iOException2) {}
                                try {
                                    if (bis != null) {
                                        bis.close();
                                    }
                                }
                                catch (IOException iOException3) {}
                                partFile.deleteOnExit();
                                this.deleteTempFile(partFile);
                                break block50;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                if (raf != null) {
                                    raf.close();
                                }
                            }
                            catch (IOException iOException) {}
                            try {
                                if (bis != null) {
                                    bis.close();
                                }
                            }
                            catch (IOException iOException) {}
                            partFile.deleteOnExit();
                            this.deleteTempFile(partFile);
                            throw throwable;
                        }
                        try {
                            if (raf != null) {
                                raf.close();
                            }
                        }
                        catch (IOException iOException) {}
                        try {
                            if (bis != null) {
                                bis.close();
                            }
                        }
                        catch (IOException iOException) {}
                        partFile.deleteOnExit();
                        this.deleteTempFile(partFile);
                    }
                    ++i;
                }
                uiMonitor.worked(100);
            }
            if (!FileUtils.copy(uiMonitor, tmpFile, file)) {
                CommonBurnerWorker.returnError("Cannot operate on the destination file!");
                return false;
            }
        }
        finally {
            if (tmpFile != null) {
                tmpFile.deleteOnExit();
            }
            this.deleteTempFile(tmpFile);
        }
        if (transferWay != TransferWay.UsbAndSerial && !FastbootView.isSupportUsbNonNude(transferWay)) {
            this.switchTFTPDownloadHome(file);
        }
        uiMonitor.worked(100);
        return true;
    }

    private File createFile(String path, String partitionName) throws IOException {
        File partFile = new File(path);
        if (partFile.exists() && !partFile.delete()) {
            CommonBurnerWorker.returnError("Cannot operate on temp file. Uplodaing will be stoped.");
            return null;
        }
        if (!partFile.createNewFile()) {
            CommonBurnerWorker.returnError("Failed to upload " + partitionName + " partition!");
            return null;
        }
        return partFile;
    }

    private boolean eraseEmmcOrUfs(IProgressMonitor uiMonitor, FlashType flashType) throws IOException, ReceiveTimeOutException {
        boolean result = false;
        long neMMCCapacity = this.geteMMCSpaceSize(flashType);
        if (0L == neMMCCapacity) {
            CommonBurnerWorker.warningln("Failed to get eMMC capacity!");
            return false;
        }
        long erasePartitionLen = neMMCCapacity / 512L * 512L;
        if (erasePartitionLen % 512L != 0L) {
            erasePartitionLen += 512L;
        }
        int length = 0x8000000;
        UDProperties properties = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getProperties();
        String boardType = properties.queryForString("TYPE");
        if (boardType != null && boardType.equalsIgnoreCase("CAM")) {
            length = 0x2000000;
        }
        long count = erasePartitionLen / (long)length;
        long eraseLenSector = erasePartitionLen / 512L;
        uiMonitor.beginTask("", (int)(count * 10L) + 20);
        if (FastbootPreferences.isDiskFormatting()) {
            result = this.sendCommand(EraseCommand.eraseEmmc(Long.toHexString(0L), Long.toHexString(eraseLenSector), Long.toHexString(neMMCCapacity)));
        } else {
            long partLength = length;
            partLength /= 512L;
            String fillData = null;
            if (ToolUtils.isCmdLine()) {
                fillData = String.valueOf(PreferenceConfig.getImgFillData());
            } else {
                IPreferenceStore preferences = FastbootPreferences.getPreferenceStore();
                fillData = preferences.getString("vendor.burn.config.imageFill");
            }
            long address = 0L;
            block0: while (eraseLenSector > 0L) {
                MWCommand memsetCommand;
                if (uiMonitor.isCanceled()) break;
                if (eraseLenSector >= (long)(length / 512)) {
                    memsetCommand = null;
                    if (fillData.equals("0xFF")) {
                        long writeSize = partLength * 512L;
                        if (flashType == FlashType.ufs) {
                            writeSize = partLength * 4096L;
                        }
                        memsetCommand = MWCommand.mwAddress(this.getHexStartAddress(), Long.toHexString(writeSize));
                    } else {
                        memsetCommand = MWCommand.mwAddress(this.getHexStartAddress(), Long.toHexString(partLength * 512L));
                    }
                    result = this.sendCommand(memsetCommand);
                    uiMonitor.worked(5);
                    int i = 0;
                    while ((long)i < count) {
                        if (uiMonitor.isCanceled()) continue block0;
                        WriteCommand burnCommand = WriteCommand.writeeMMC(flashType, this.getHexStartAddress(), Long.toHexString(address), Long.toHexString(partLength));
                        result = this.sendCommand(burnCommand);
                        address += partLength;
                        uiMonitor.worked(10);
                        eraseLenSector -= partLength;
                        ++i;
                    }
                    continue;
                }
                memsetCommand = MWCommand.mwAddress(this.getHexStartAddress(), Long.toHexString(eraseLenSector * 512L));
                result = this.sendCommand(memsetCommand);
                uiMonitor.worked(5);
                WriteCommand burnCommand = WriteCommand.writeeMMC(flashType, this.getHexStartAddress(), Long.toHexString(address), Long.toHexString(eraseLenSector));
                result &= this.sendCommand(burnCommand);
                address += eraseLenSector;
                uiMonitor.worked(10);
                eraseLenSector = 0L;
            }
        }
        return result;
    }

    private boolean eraseAllSpi(ArrayList<FlashType> hasFlashTypes, List<PartitionItem> parts) throws IOException, ReceiveTimeOutException {
        boolean result = false;
        ArrayList<ChipID> existChipIDInParts = ChipID.getChipIDInParts(parts);
        if (existChipIDInParts != null) {
            for (ChipID chipID : existChipIDInParts) {
                result = this.sendCommand(SFCommand.getInstance(chipID));
                long spiSpaceSize = this.getSpiSpaceSize();
                if (spiSpaceSize == 0L || spiSpaceSize <= 0L || !result) continue;
                result = this.sendCommand(EraseCommand.erase(FlashType.spi, Long.toHexString(0L), Long.toHexString(spiSpaceSize)));
            }
        }
        return result;
    }

    private boolean eraseNand(ArrayList<FlashType> hasFlashTypes) throws IOException, ReceiveTimeOutException {
        boolean result = false;
        long nandSpaceSize = this.getNandSpaceSize();
        if (nandSpaceSize != 0L && nandSpaceSize > 0L) {
            EraseCommand eraseCommand = CommonBurnerWorker.eraseAllCommand(nandSpaceSize);
            result = this.sendCommand(eraseCommand);
        }
        return result;
    }

    private boolean eraseEmmcPart(SubMonitor subProgressMonitor, PartitionItem part) throws IOException, ReceiveTimeOutException {
        long erasePartitionLen;
        boolean bRet = true;
        long startSector = part.getStart() / 512L;
        long partitionLen = part.getLength();
        int length = 0x8000000;
        UDProperties properties = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getProperties();
        String boardType = properties.queryForString("TYPE");
        if (boardType != null && boardType.equalsIgnoreCase("CAM")) {
            length = 0x2000000;
        }
        if ((erasePartitionLen = partitionLen / 512L * 512L) % 512L != 0L) {
            erasePartitionLen += 512L;
        }
        long count = erasePartitionLen / (long)length;
        long eraseLenSector = erasePartitionLen / 512L;
        long partLength = length;
        partLength /= 512L;
        block0: while (eraseLenSector > 0L) {
            MWCommand memsetCommand;
            if (subProgressMonitor.isCanceled()) break;
            if (eraseLenSector >= (long)(length / 512)) {
                memsetCommand = MWCommand.mwAddress(this.getHexStartAddress(), Long.toHexString(partLength * 512L));
                bRet = this.sendCommand(memsetCommand);
                if (!bRet) {
                    return false;
                }
                int i = 0;
                while ((long)i < count) {
                    if (subProgressMonitor.isCanceled()) continue block0;
                    WriteCommand burnCommand = WriteCommand.writeeMMC(part.getFlashType(), this.getHexStartAddress(), Long.toHexString(startSector), Long.toHexString(partLength));
                    bRet = this.sendCommand(burnCommand);
                    if (!bRet) {
                        return false;
                    }
                    startSector += partLength;
                    eraseLenSector -= partLength;
                    ++i;
                }
                continue;
            }
            memsetCommand = MWCommand.mwAddress(this.getHexStartAddress(), Long.toHexString(eraseLenSector * 512L));
            bRet = this.sendCommand(memsetCommand);
            if (!bRet) {
                return false;
            }
            WriteCommand burnCommand = WriteCommand.writeeMMC(part.getFlashType(), this.getHexStartAddress(), Long.toHexString(startSector), Long.toHexString(eraseLenSector));
            bRet = this.sendCommand(burnCommand);
            if (!bRet) {
                return false;
            }
            startSector += eraseLenSector;
            eraseLenSector = 0L;
        }
        return true;
    }

    private boolean burnReceivePart(String partName, List<PartitionItem> parts) {
        PartitionItem burnPart = null;
        for (PartitionItem part : parts) {
            if (!partName.equals(part.getName())) continue;
            burnPart = part;
            break;
        }
        if (burnPart == null) {
            CommonBurnerWorker.returnError("partition " + partName + " is not found in the burning list.");
            return false;
        }
        this.infoln("\nSend command:\t" + burnPart.getName());
        return CallLibUSBWorker.downloadFileGptByUsb(burnPart.getFile());
    }

    private boolean burnEachPartForGpt(IProgressMonitor uimonitor, List<PartitionItem> parts) throws IOException, ReceiveTimeOutException {
        for (PartitionItem part : parts) {
            if (!part.getName().equalsIgnoreCase("gpt")) continue;
            this.infoln("\nSend command:\tDownloading File : gpt");
            if (CallLibUSBWorker.downloadFileGptByUsb(part.getFile())) break;
            return false;
        }
        for (PartitionItem part : parts) {
            if (!part.getName().equalsIgnoreCase("bootargs")) continue;
            this.infoln("\nSend command:\tDownloading File : bootargs");
            if (CallLibUSBWorker.downloadFileGptByUsb(part.getFile())) break;
            return false;
        }
        INFOCommand command = INFOCommand.getInfoGpt();
        this.infoln("\nSend command:\t" + command.getCommand());
        if (!this.sendCmdByTrans(command.getCommand(), command.getTimeout())) {
            return false;
        }
        StringBuilder temp = new StringBuilder();
        if (!this.receiveBytesByUsb(temp, 512, TransferWay.GPT)) {
            return false;
        }
        String recvStr = temp.toString();
        String recvResult = recvStr.substring(0, 4);
        if (!recvResult.equalsIgnoreCase("info")) {
            this.infoln("getinfo gpt failed");
            return false;
        }
        String recvParts = recvStr.substring(4, recvStr.length());
        String[] partsName = recvParts.split("/");
        int i = 0;
        while (i < partsName.length) {
            this.burnReceivePart(partsName[i], parts);
            ++i;
        }
        return true;
    }

    public boolean burnByTransferWay(IProgressMonitor uimonitor, List<PartitionItem> PartitionItems, int selectedPartCount, int[] errorCode) throws IOException, ReceiveTimeOutException {
        if (this.getUimonitor() == null) {
            this.setProgressMonitor(uimonitor);
        }
        this.createTimer();
        if (!ToolUtils.isCmdLine()) {
            this.registerJnaFunction(uimonitor, 100);
        }
        List<PartitionItem> parts = this.getCurEmmcFlashTypes(PartitionItems);
        ArrayList<FlashType> hasFlashTypes = FlashType.getCurFlashTypes(parts);
        PartitionItem fastboot = parts.get(0);
        boolean result = true;
        TransferWay curTransferWay = this.getBurner().getBurnContext().getTransferWay();
        if (curTransferWay == TransferWay.Uart2Compress) {
            result = this.burnByUart2Compress(uimonitor, parts, hasFlashTypes, fastboot, curTransferWay);
            if (!result) {
                return result;
            }
            this.sendCommandToSetMac();
            String resetCommand = "reset";
            this.sendCommandNoReturnValue(resetCommand);
        } else if (curTransferWay == TransferWay.Usb2I2c || curTransferWay == TransferWay.I2CBootrom) {
            this.i2cTimeLogger = new TimeLogger();
            this.flashTimeLogger = new TimeLogger();
            this.resetTimeLogger = new TimeLogger();
            result = this.burnByI2c(uimonitor, parts, fastboot, result, hasFlashTypes, selectedPartCount);
            this.sendCommandToSetMac();
            if (ToolUtils.isDebugOn()) {
                CommonBurnerWorker.getMonitor().println(this.i2cTimeLogger.exportLog("I2C transmission time"));
                CommonBurnerWorker.getMonitor().println(this.flashTimeLogger.exportLog("Burning Flash of time"));
                CommonBurnerWorker.getMonitor().println(this.resetTimeLogger.exportLog("Reset time"));
            }
            if (!result) {
                return result;
            }
        } else if (curTransferWay == TransferWay.GPT) {
            result = this.startBootForBurn(uimonitor, parts, selectedPartCount, hasFlashTypes, fastboot, curTransferWay);
            if (!result) {
                errorCode[0] = BurnStatus.BURN_BOOT_FAILED.getErrorCode();
                return result;
            }
            if (!this.burnEachPartForGpt(uimonitor, parts)) {
                errorCode[0] = BurnStatus.BURN_PARTITION_FAILED.getErrorCode();
                return false;
            }
            this.sendCommandToSetMac();
        } else {
            boolean isResetJtag;
            result = this.startBootForBurn(uimonitor, parts, selectedPartCount, hasFlashTypes, fastboot, curTransferWay);
            if (!result) {
                errorCode[0] = BurnStatus.BURN_BOOT_FAILED.getErrorCode();
                return result;
            }
            uimonitor.setTaskName("Burning Partitions");
            int partsSize = parts.size();
            this.startZipThread(uimonitor, parts, hasFlashTypes, curTransferWay);
            boolean isPci = true;
            int index = 1;
            while (index < partsSize) {
                PartitionItem partitionItem = parts.get(index);
                FlashType flashType = partitionItem.getFlashType();
                if (flashType == FlashType.emmc || flashType == FlashType.ufs || flashType == FlashType.ssd) {
                    if (flashType == FlashType.ssd && isPci) {
                        if (!this.sendSsdByPci(parts)) {
                            return false;
                        }
                        isPci = false;
                    }
                    result = this.burnEachPartForEmmc(uimonitor, parts, index);
                } else {
                    result = this.burnEachPartForNandOrSpi(uimonitor, parts, index);
                }
                if (!result) {
                    errorCode[0] = BurnStatus.BURN_PARTITION_FAILED.getErrorCode();
                    return result;
                }
                ++index;
            }
            this.sendCommandToSetMac();
            boolean bl = isResetJtag = !(!FastbootView.isCJXX0VXX5Series() && !FastbootView.isCJ3X0VXX1Series() && !FastbootView.isCJ3X1VXX8E_Series() || curTransferWay != TransferWay.JTAG && curTransferWay != TransferWay.JTAGAndNet && curTransferWay != TransferWay.JTAGAndSerial);
            if (!isResetJtag) {
                String resetCommand = "reset";
                this.sendCommandNoReturnValue(resetCommand);
            }
        }
        this.infoln("Partition burnt completed!");
        return result;
    }

    private boolean sendSsdByPci(List<PartitionItem> parts) throws IOException, ReceiveTimeOutException {
        boolean isExist = false;
        int index = 1;
        while (index < parts.size()) {
            FlashType flashType = parts.get(index).getFlashType();
            if (flashType == FlashType.ssd) {
                isExist = true;
            }
            ++index;
        }
        if (isExist) {
            if (!this.sendCommand("pci")) {
                return false;
            }
            if (!this.sendCommand("nvme scan")) {
                return false;
            }
        }
        return true;
    }

    private boolean startBootForBurn(IProgressMonitor uimonitor, List<PartitionItem> parts, int selectedPartCount, ArrayList<FlashType> hasFlashTypes, PartitionItem fastboot, TransferWay curTransferWay) throws IOException, ReceiveTimeOutException {
        if (fastboot.isChecked()) {
            uimonitor.setTaskName("Burning Fastboot Partition");
        }
        FastbootView.setStartNetwork(true);
        FlashType bootFlashType = fastboot.getFlashType();
        if (bootFlashType == FlashType.emmc || bootFlashType == FlashType.ufs) {
            int emmcType = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getEmmcType();
            if (!this.burnbootForEmmc(curTransferWay, emmcType, fastboot, parts)) {
                return false;
            }
            this.changeFastbootFlash(parts);
        } else if (!this.burnbootForNandOrSpi(uimonitor, parts, selectedPartCount, hasFlashTypes, fastboot, curTransferWay)) {
            return false;
        }
        if (FastbootView.isStartNetwork() && !this.needSetupNetwork(curTransferWay)) {
            return false;
        }
        if (fastboot.getFile() != null) {
            this.burnBootTimeLogger.logEnd();
        }
        return true;
    }

    private void startZipThread(IProgressMonitor uimonitor, List<PartitionItem> parts, ArrayList<FlashType> hasFlashTypes, TransferWay curTransferWay) throws IOException, ReceiveTimeOutException {
        boolean hasEmmcFlash;
        boolean bl = hasEmmcFlash = this.isHasFlash(hasFlashTypes, FlashType.emmc) || this.isHasFlash(hasFlashTypes, FlashType.ufs) || this.isHasFlash(hasFlashTypes, FlashType.ssd);
        if (hasEmmcFlash) {
            long ddrFreeBaseAddr = 0L;
            long ddrFreeSize = 0L;
            try {
                String ddrFreeSizeStr = curTransferWay == TransferWay.UDP ? this.udpDdrFreeSizeStr : this.getDDRFreeParam();
                ddrFreeSize = this.parseLong(this.getDDRFreeParam("size:", ddrFreeSizeStr, curTransferWay));
                ddrFreeBaseAddr = this.parseLong(this.getDDRFreeParam("baseaddr:", ddrFreeSizeStr, curTransferWay));
            }
            catch (IOException iOException) {
            }
            catch (ReceiveTimeOutException receiveTimeOutException) {}
            if (this.frameSetting instanceof UDFrameSetting) {
                UDFrameSetting udFrameSetting = (UDFrameSetting)this.frameSetting;
                udFrameSetting.setDdrInitAddrByLibBootrom(ddrFreeBaseAddr);
            }
            if (ToolUtils.isDebugOn()) {
                this.println("ddrFree: " + ddrFreeSize);
                this.println("baseAddr: " + ddrFreeBaseAddr);
            }
            this.useCompress = this.getTempDivisionSize(ddrFreeSize);
            this.runMakeZipThread(uimonitor, parts, this.useCompress);
        }
    }

    private boolean eraseForNandorSpi(SubMonitor subProgressMonitor, int partsSize, int index, PartitionItem part) throws IOException, ReceiveTimeOutException {
        boolean bRet = true;
        String partitionName = part.getName();
        FlashType flashType = part.getFlashType();
        long partStart = part.getStart();
        long partLength = part.getLength();
        long startSector = partStart / 512L;
        if (index == partsSize - 1 && partLength == -1L && (partLength = this.getLastPartitionLen(part, partStart, partLength, flashType, startSector)) == -1L) {
            return false;
        }
        if (FlashType.spi == flashType) {
            bRet = this.sendCommand(SFCommand.getInstance(ChipID.chip0));
        }
        if (bRet) {
            bRet = this.sendCommand(EraseCommand.erase(flashType, Long.toHexString(partStart), Long.toHexString(partLength)));
        }
        if (!bRet) {
            CommonBurnerWorker.returnError("Failed to Erase " + partitionName + " Partition!");
            return false;
        }
        this.infoln("Partition " + partitionName + " Erased successfully!");
        subProgressMonitor.worked(100);
        return bRet;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean startbootForNoneNude(IProgressMonitor uimonitor, List<PartitionItem> parts, ArrayList<FlashType> hasFlashTypes, TransferWay curTransferWay) throws IOException, ReceiveTimeOutException {
        PartitionItem fastboot = parts.get(0);
        FlashType bootFlashType = fastboot.getFlashType();
        TransferWay transferWay = this.getBurner().getBurnContext().getTransferWay();
        if (transferWay != TransferWay.USBNonNude) {
            boolean result = this.prepareToBurn(false, EventType.ERASE, hasFlashTypes);
            if (result) return true;
            return false;
        }
        boolean result = this.bootromByNonNude(uimonitor);
        if (!result) {
            return false;
        }
        if (bootFlashType != FlashType.nand) {
            if (bootFlashType != FlashType.spi) return true;
        }
        if (this.loadVersionInfo(this.burner.getBurnContext().getTransferWay())) {
            this.loadBlockSizes(hasFlashTypes, ChipID.chip0, false);
            return true;
        }
        if (this.burner.getBurnContext().getPlatformType() == PlatformType.CA) {
            this.loadBlockSizes(hasFlashTypes, ChipID.chip0, false);
            CommonBurnerWorker.warningln("Warning: Failed to load version info!");
            return true;
        }
        CommonBurnerWorker.returnError("Failed to load version info!");
        return false;
    }

    private boolean isHasFlash(ArrayList<FlashType> hasFlashTypes, FlashType curFlashType) {
        for (FlashType flashType : hasFlashTypes) {
            if (flashType != curFlashType) continue;
            return true;
        }
        return false;
    }

    public int getSelectedPartCount(List<PartitionItem> parts) {
        int selectedPartCount = 0;
        for (PartitionItem partitionItem : parts) {
            if (!partitionItem.isChecked()) continue;
            ++selectedPartCount;
        }
        return selectedPartCount;
    }

    public List<PartitionItem> getCurEmmcFlashTypes(List<PartitionItem> PartitionItems) {
        FlashType flashType;
        if (!FastbootView.isCJ309V100_CA_N_Series() || ToolUtils.isCmdLine()) {
            return PartitionItems;
        }
        ArrayList<PartitionItem> parts = new ArrayList<PartitionItem>();
        if (PartitionItems.size() > 0) {
            PartitionItem partitionItemOld = PartitionItems.get(0);
            PartitionItem partitionItemNew = new PartitionItem();
            partitionItemNew.setChipID(partitionItemOld.getChipID());
            partitionItemNew.setFile(partitionItemOld.getFile());
            partitionItemNew.setFileSystem(partitionItemOld.getFileSystem());
            partitionItemNew.setLength(partitionItemOld.getLength());
            partitionItemNew.setName(partitionItemOld.getName());
            partitionItemNew.setNewTempFile(partitionItemOld.getNewTempFile());
            partitionItemNew.setStart(partitionItemOld.getStart());
            partitionItemNew.setFlashType(partitionItemOld.getFlashType());
            partitionItemNew.setChecked(partitionItemOld.isChecked());
            parts.add(partitionItemNew);
            flashType = partitionItemOld.getFlashType();
            if (flashType == FlashType.emmc0) {
                partitionItemNew.setFlashType(FlashType.emmc);
                this.getBurner().getBurnContext().setEmmcBootType(USERBOOT);
            } else if (flashType == FlashType.emmc1) {
                partitionItemNew.setFlashType(FlashType.emmc);
                this.getBurner().getBurnContext().setEmmcBootType(BOOTONE);
            } else if (flashType == FlashType.emmc2) {
                partitionItemNew.setFlashType(FlashType.emmc);
                this.getBurner().getBurnContext().setEmmcBootType(BOOTTWO);
            } else if (flashType == FlashType.emmc) {
                this.getBurner().getBurnContext().setEmmcBootType(BOOT);
            }
        }
        int i = 1;
        while (i < PartitionItems.size()) {
            PartitionItem partitionItem = PartitionItems.get(i);
            parts.add(partitionItem);
            flashType = partitionItem.getFlashType();
            if (flashType.toString().startsWith(FlashType.emmc.name())) {
                ((PartitionItem)parts.get(i)).setFlashType(FlashType.emmc);
            }
            ++i;
        }
        return parts;
    }

    private void changeFastbootFlash(List<PartitionItem> parts) {
        if (!FastbootView.isCJ309V100_CA_N_Series() || ToolUtils.isCmdLine() || parts.size() <= 0) {
            return;
        }
        String bootType = this.burner.getBurnContext().getEmmcBootType();
        if (bootType.equalsIgnoreCase(USERBOOT)) {
            parts.get(0).setFlashType(FlashType.emmc0);
        } else if (bootType.equalsIgnoreCase(BOOTONE)) {
            parts.get(0).setFlashType(FlashType.emmc1);
        } else if (bootType.equalsIgnoreCase(BOOTTWO)) {
            parts.get(0).setFlashType(FlashType.emmc2);
        }
        this.burner.getBurnContext().setEmmcBootType(BOOT);
    }

    private void createTimer() {
        this.burnBootTimeLogger = new TimeLogger();
        this.tftpTimeLogger = new TimeLogger();
        this.burnTimeLogger = new TimeLogger();
        this.waitZipTimeLogger = new TimeLogger();
        this.zipAndPageTimeLogger = new TimeLogger();
        this.unZipTimeLogger = new TimeLogger();
        this.spellingSparseFileLogger = new TimeLogger();
        this.crcLogger = new TimeLogger();
    }
}

