/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.serial.workers;

import com.vendor.burn.Messages;
import com.vendor.burn.model.FlashType;
import com.vendor.burn.model.TransferWay;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.event.EventType;
import com.vendor.burn.model.receive.ReceiveTimeOutException;
import com.vendor.burn.serial.workers.CallLibJTAGWorker;
import com.vendor.burn.serial.workers.CallLibUSBWorker;
import com.vendor.burn.serial.workers.PartitionBurnerWorker;
import com.vendor.burn.utilitily.FileUtils;
import com.vendor.platform.api.statistics.ToolStatistics;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class DdrBurnerWorker
extends PartitionBurnerWorker {
    public static final String commontStart = "usbtftp start";
    public static final String commontError = "usbtftp error";
    public static final String commontEnd = "usbtftp end";
    public static final int DOWNLOADCOMMANDLENGTH = 3;
    public static final int UPLOADCOMMANDLENGTH = 4;
    private static final int receivedNumber = 10;

    public DdrBurnerWorker(IBurner burner) {
        super(burner);
        this.burner = burner;
    }

    public boolean burn(IProgressMonitor uiMonitor, String directory) {
        ToolStatistics.INSTANCE.logUsage(Messages.FASTBOOT_MessageDialog_Title, "Ddr burn", "ChipName: " + this.burner.getBurnContext().getDeviceSetting().getName());
        ToolStatistics.INSTANCE.logToolInUse(Messages.FASTBOOT_MessageDialog_Title);
        String versionInfo = this.getVersionInfo("Ddr burn");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        monitor.getEvent().init(EventType.DDR_BURN);
        uiMonitor.beginTask("Ddr burn", 100);
        this.setProgressMonitor(uiMonitor);
        TransferWay curTransferWay = this.getBurner().getBurnContext().getTransferWay();
        if (curTransferWay == TransferWay.USBBootrom || curTransferWay == TransferWay.USBNonNude) {
            this.setFlashType(FlashType.ddr);
            while (true) {
                block25: {
                    boolean startResult = this.waitOpenUsb(uiMonitor, curTransferWay);
                    uiMonitor.worked(20);
                    try {
                        if (!startResult) break block25;
                        if (uiMonitor.isCanceled()) {
                            this.sendUsbCommand(commontError);
                            break;
                        }
                        this.getCurReceived();
                        if (!this.sendUsbCommand(commontStart)) {
                            this.sendUsbCommand(commontError);
                            continue;
                        }
                        uiMonitor.worked(30);
                        String received = null;
                        int number = 0;
                        while (!uiMonitor.isCanceled()) {
                            if (number == 10) {
                                this.infoln("\nrequest information number:\t" + number);
                                break;
                            }
                            received = this.getCurUsbCommonReceived();
                            if (received == null || received.length() <= 0) {
                                this.infoln("\nrequest information is empty.\t");
                                ++number;
                                continue;
                            }
                            int index = received.indexOf("\n");
                            if (index > 0) {
                                received = received.substring(0, index);
                            }
                            received = received.trim();
                            this.infoln("\nrequest information:\t" + received);
                            if (received.toLowerCase().startsWith("usbtftp ")) {
                                String[] commons = received.split(" ");
                                if (commons.length < 3) {
                                    DdrBurnerWorker.warning("\nSend command format error, refer to ' usbtftp get addr file '.");
                                    this.sendUsbCommand(commontError);
                                } else {
                                    if (commons.length == 3) {
                                        this.downloadFile(commons, directory, uiMonitor, curTransferWay);
                                    } else if (commons.length == 4) {
                                        this.uploadFile(commons, directory, uiMonitor);
                                    }
                                    if (!this.sendUsbCommand(commontEnd)) {
                                        this.sendUsbCommand(commontError);
                                    } else {
                                        try {
                                            Thread.sleep(300L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                }
                                break;
                            }
                            ++number;
                        }
                    }
                    finally {
                        CallLibUSBWorker.closeUsb(curTransferWay);
                        continue;
                    }
                }
                if (uiMonitor.isCanceled()) break;
            }
        } else {
            DdrBurnerWorker.warningln("\n" + Messages.DdrComposite_OnlyUsb);
        }
        return true;
    }

    private void uploadFile(String[] commons, String directory, IProgressMonitor uiMonitor) {
        String addressStr = commons[1];
        String fileName = commons[2];
        String lengthStr = commons[3];
        File file = new File(String.valueOf(directory) + File.separator + fileName);
        if (file.exists()) {
            FileUtils.deleteFile(file);
        }
        uiMonitor.setTaskName("Uploading File : " + file.getName());
        uiMonitor.worked(50);
        SubMonitor subProgressMonitor = SubMonitor.convert((IProgressMonitor)this.uimonitor, (String)"", (int)100);
        this.uimonitor.setTaskName("Uploading " + file.getName());
        subProgressMonitor.setTaskName("Uploading File : " + file.getName());
        this.infoln("\nSend command:\tUploading File : " + file.getName());
        int ddrAddress = this.getAddress(addressStr);
        if (ddrAddress == -1) {
            DdrBurnerWorker.warning("\nmemory address error :\t" + addressStr);
            this.sendUsbCommand(commontError);
            return;
        }
        int length = this.getAddress(lengthStr);
        if (length == 0) {
            DdrBurnerWorker.warning("\nmemory address length error :\t" + length);
            this.sendUsbCommand(commontError);
            return;
        }
        boolean loadResult = CallLibUSBWorker.uploadFileByUsb(file, 0, 0, this.getBurner().getBurnContext().getTransferWay());
        if (!loadResult) {
            DdrBurnerWorker.returnError(Messages.ERROR_INFO_USB_UPLOAD_FAILED);
            this.sendUsbCommand(commontError);
            return;
        }
        uiMonitor.worked(80);
    }

    private void downloadFile(String[] commons, String directory, IProgressMonitor uiMonitor, TransferWay curTransferWay) {
        String addressStr = commons[1];
        String fileName = commons[2];
        File file = new File(String.valueOf(directory) + File.separator + fileName);
        if (!file.exists()) {
            DdrBurnerWorker.warning("\nFile does not exist:\t" + file.getPath());
            this.sendUsbCommand(commontError);
            return;
        }
        uiMonitor.setTaskName("Downloading File : " + file.getName());
        uiMonitor.worked(50);
        SubMonitor subProgressMonitor = SubMonitor.convert((IProgressMonitor)this.uimonitor, (String)"", (int)100);
        this.uimonitor.setTaskName("Burning " + file.getName());
        subProgressMonitor.setTaskName("Downloading File : " + file.getName());
        this.infoln("\nSend command:\tDownloading File : " + file.getName());
        int ddrAddress = this.getAddress(addressStr);
        if (ddrAddress == 0) {
            DdrBurnerWorker.warning("\nDownload memory address Error :\t" + addressStr);
            this.sendUsbCommand(commontError);
            return;
        }
        boolean loadResult = CallLibUSBWorker.downloadFileByUsb(file, ddrAddress, curTransferWay);
        if (!loadResult) {
            DdrBurnerWorker.returnError(Messages.ERROR_INFO_USB_DOWNLOAD_FAILED);
            this.sendUsbCommand(commontError);
            return;
        }
        uiMonitor.worked(80);
    }

    private int getAddress(String addressStr) {
        int index;
        if (addressStr.toLowerCase().indexOf("0x") == 0) {
            addressStr = addressStr.substring(2, addressStr.length());
        }
        if ((index = addressStr.indexOf("\n")) > 0) {
            addressStr = addressStr.substring(0, index);
        }
        try {
            return (int)Long.parseLong(addressStr, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private boolean sendUsbCommand(String infocmd) {
        try {
            if (!this.sendCommand(infocmd)) {
                DdrBurnerWorker.returnError("Failed to send command " + infocmd + ". ");
                return false;
            }
        }
        catch (IOException iOException) {
        }
        catch (ReceiveTimeOutException receiveTimeOutException) {}
        return true;
    }
}

