/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.serial.workers;

import com.vendor.burn.Messages;
import com.vendor.burn.jna.LibBootromByJNA;
import com.vendor.burn.model.BurnContext;
import com.vendor.burn.model.FlashType;
import com.vendor.burn.model.LocalConfig;
import com.vendor.burn.model.PartitionItem;
import com.vendor.burn.model.PlatformType;
import com.vendor.burn.model.TransferWay;
import com.vendor.burn.model.config.BurnConfig;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.devices.IFrameSetting;
import com.vendor.burn.model.devices.burners.AbstractBurner;
import com.vendor.burn.model.devices.unknown.UDFrameSetting;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import com.vendor.burn.model.dqInfo;
import com.vendor.burn.model.phyInfo;
import com.vendor.burn.model.receive.ReceiveTimeOutException;
import com.vendor.burn.serial.workers.AbstractBurnerWorker;
import com.vendor.burn.serial.workers.CallLibBootromWorker;
import com.vendor.burn.serial.workers.CallLibUSBWorker;
import com.vendor.burn.serial.workers.Modem;
import com.vendor.burn.ui.burners.DdrCheckComposite;
import com.vendor.burn.utilitily.ToolUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Display;

public class DdrCheckBurnerWorker
extends AbstractBurnerWorker
implements Modem {
    protected static final int TIMEOUT_XMODEM_EOT = 30000;
    protected static String msg_FailedToPrepareFile = "Failed to prepare File!";
    protected static String msg_FailedToLoadVersion = "Failed to load version info!";
    protected static String msg_BootBurnedSuccessfully = "Boot burned successfully.";
    protected static final String PHY = "PHY";
    protected static final String INIT = "init";
    protected static final String INIT_0X = "init 0x";
    protected static final String BYTE0 = "Byte0";
    protected static final String BYTE = "Byte";
    protected static final String BYTE_VALUE = "0";
    protected static final String INIT_VALUE = "00000000";
    protected static final String INIT_VALUE_BREAK = "0x000000";
    protected static final String ERR = "Err ";
    protected static final String FAIL = "Fail";
    protected static final String PASS = "Pass";
    protected static final String DQ = "   DQ";
    protected static final String PHY_SEPARATOR = "PHY";
    protected static final String LINE_BREAK = "\n";
    protected static final String ENTER_BREAK = "\r";
    protected static final String BLOCK_MARKED_BAD = "WARNING: block is marked as bad";
    protected LocalConfig localConfig;
    String ubootStartLog;
    protected static final int OUTPUT_PARAM_SIZE = 1;
    protected static final int TIMEMS = 10000;
    private static final int CANCEL_CODE = 256;
    private static List<phyInfo> phyInfoList = new ArrayList<phyInfo>();

    public DdrCheckBurnerWorker(IFrameSetting frameSetting, IBurner burner) {
        super(frameSetting);
        this.burner = burner;
        if (burner != null) {
            BurnContext burnContext = burner.getBurnContext();
            this.localConfig = burnContext.getLocalConfig();
        }
    }

    public boolean burn(IProgressMonitor uimonitor, FlashType flashType, String filePath) throws IOException, ReceiveTimeOutException {
        this.setProgressMonitor(uimonitor);
        uimonitor.beginTask("", 100);
        this.registerJnaFunction(uimonitor, 100);
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        if ((transferWay == TransferWay.Serial || transferWay == TransferWay.Net) && this.burner.getBurnContext().getDeviceSetting() instanceof UnknownDevice) {
            UnknownDevice deviceSetting = (UnknownDevice)this.burner.getBurnContext().getDeviceSetting();
            if (deviceSetting.isSupportBurnByLibBootrom()) {
                if (!this.programmerDownload(SubMonitor.convert((IProgressMonitor)uimonitor, (String)"", (int)86), filePath, ((AbstractBurner)((Object)this.burner)).getProgrammerFile(), null)) {
                    DdrCheckBurnerWorker.returnError("Failed to download fastboot!");
                    return false;
                }
            } else if (this.burner.getBurnContext().getPlatformType() == PlatformType.NonCA ? !this.bootDownload(SubMonitor.convert((IProgressMonitor)uimonitor, (String)"", (int)86), filePath) : !this.programmerDownload(SubMonitor.convert((IProgressMonitor)uimonitor, (String)"", (int)86), filePath, ((AbstractBurner)((Object)this.burner)).getProgrammerFile(), null)) {
                return false;
            }
        }
        String received = String.valueOf(serialRecvBuf.toString().trim()) + this.getCurReceived().trim();
        DdrCheckBurnerWorker.received(received.toString());
        this.getPhyInfoList(received.toString());
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DdrCheckComposite.createPartControl(phyInfoList);
            }
        });
        DdrCheckBurnerWorker.deleteContent(serialReceived);
        uimonitor.done();
        return true;
    }

    private void setDqInfoList(List<phyInfo> phyInfoList) {
        int i = 0;
        while (i < phyInfoList.size()) {
            List<dqInfo> dqInfoList = DdrCheckBurnerWorker.initDqInfoList();
            List<String> dqErrList = phyInfoList.get(i).getDqErrList();
            String str = null;
            int index = 0;
            int j = 0;
            while (j < dqErrList.size()) {
                str = dqErrList.get(j).substring(dqErrList.get(j).length() - 2, dqErrList.get(j).length());
                index = phyInfoList.get(i).getInit().contains("0x") ? (int)Long.parseLong(str, 16) : Integer.parseInt(str);
                dqInfoList.get(index).setStatu(dqInfo.STATU.RED);
                ++j;
            }
            phyInfoList.get(i).setDqInfoList(dqInfoList);
            ++i;
        }
    }

    private static List<dqInfo> initDqInfoList() {
        ArrayList<dqInfo> dqInfoList = new ArrayList<dqInfo>();
        int index = 0;
        while (index < 32) {
            long num = (long)Math.pow(2.0, index);
            dqInfo info = new dqInfo();
            info.setName(String.valueOf(DdrCheckBurnerWorker.intToBinary32(num, 32)) + DQ + index);
            info.setStatu(dqInfo.STATU.GREEN);
            dqInfoList.add(info);
            ++index;
        }
        return dqInfoList;
    }

    private static String intToBinary(long num, int bitNum) {
        String str = Long.toBinaryString(num);
        while (str.length() < bitNum) {
            str = BYTE_VALUE + str;
        }
        char[] bankNoArray = str.toCharArray();
        String binaryStr = "";
        int i = 0;
        while (i < bankNoArray.length) {
            binaryStr = String.valueOf(binaryStr) + bankNoArray[i];
            ++i;
        }
        return binaryStr;
    }

    private static String intToBinary32(long num, int bitNum) {
        String str = Long.toBinaryString(num);
        while (str.length() < bitNum) {
            str = BYTE_VALUE + str;
        }
        char[] bankNoArray = str.toCharArray();
        String binaryStr = "";
        int i = 0;
        while (i < bankNoArray.length) {
            if (i % 4 == 0 && i > 0) {
                binaryStr = String.valueOf(binaryStr) + " ";
            }
            binaryStr = String.valueOf(binaryStr) + bankNoArray[i];
            ++i;
        }
        return binaryStr;
    }

    private List<phyInfo> getPhyInfoList(String str) {
        phyInfoList.clear();
        String[] arr = str.split("PHY");
        ArrayList<String> dqErrList = null;
        int i = 0;
        while (i < arr.length) {
            String phyStr = arr[i];
            if (phyStr.contains(INIT)) {
                int endIndex;
                dqErrList = new ArrayList<String>();
                phyInfo info = new phyInfo();
                if (phyStr.contains(ERR)) {
                    info.setStatu(phyInfo.STATU.RED);
                } else {
                    info.setStatu(phyInfo.STATU.GREEN);
                }
                String init = "";
                int beginIndex = phyStr.indexOf(INIT);
                if (beginIndex > 0 && (endIndex = phyStr.contains("0x") ? phyStr.indexOf(BYTE, beginIndex) : phyStr.indexOf(BYTE0, beginIndex += INIT.length())) > beginIndex) {
                    init = phyStr.substring(beginIndex, endIndex).replaceAll(LINE_BREAK, "").replaceAll(ENTER_BREAK, "").trim();
                }
                this.addInfo(dqErrList, phyStr, info, init);
            }
            ++i;
        }
        this.setDqInfoList(phyInfoList);
        return phyInfoList;
    }

    private void addInfo(List<String> dqErrList, String phyStr, phyInfo info, String init) {
        info.setInit(init);
        String initValue = null;
        initValue = init.startsWith("0x") ? init.replaceAll("0x", "") : init;
        if (!initValue.equals(INIT_VALUE) && phyStr.contains(ERR)) {
            info.setAcordqs("/");
            info.setZq(PASS);
            info.setDq(FAIL);
        }
        if (initValue.equals(INIT_VALUE) && !phyStr.contains(ERR)) {
            info.setAcordqs("/");
            info.setZq(PASS);
            info.setDq(PASS);
        }
        this.setPhyinfoData(phyStr, initValue, info, dqErrList);
        info.setDqErrList(dqErrList);
        phyInfoList.add(info);
    }

    private void setPhyinfoData(String phyStr, String init, phyInfo info, List<String> dqErrList) {
        Long num;
        String initStr;
        if (phyStr.contains(ERR)) {
            info.setDq(FAIL);
            String[] byteArr = phyStr.split(BYTE);
            int j = 0;
            while (j < byteArr.length) {
                String bisValue = byteArr[j];
                if (!bisValue.contains("PHY")) {
                    String[] dqArr = bisValue.split(LINE_BREAK);
                    int x = 0;
                    while (x < dqArr.length) {
                        String value;
                        String dqValue = dqArr[x];
                        if (dqValue.contains(ERR) && !dqErrList.contains(value = dqValue.replaceAll(ERR, "").replaceAll(ENTER_BREAK, ""))) {
                            if (value.contains(INIT_VALUE_BREAK)) {
                                value = value.replaceAll(INIT_VALUE_BREAK, "");
                                dqErrList.add(value);
                            } else {
                                dqErrList.add(value);
                            }
                        }
                        ++x;
                    }
                }
                ++j;
            }
        }
        if ((initStr = DdrCheckBurnerWorker.intToBinary(num = Long.valueOf(Long.parseLong(init, 16)), 32)).length() == 32) {
            String reverseInitStr = new StringBuffer(initStr).reverse().toString();
            String aCorValue = reverseInitStr.substring(5, 6);
            String dqsValue = reverseInitStr.substring(6, 7);
            String zqValue = reverseInitStr.substring(3, 4);
            if (aCorValue.equals(BYTE_VALUE) && dqsValue.equals(BYTE_VALUE)) {
                info.setAcordqs("/");
            } else {
                info.setAcordqs(FAIL);
            }
            if (zqValue.equals(BYTE_VALUE)) {
                info.setZq(PASS);
            } else {
                info.setZq(FAIL);
            }
        }
    }

    public boolean bootDownload(String filePath) throws IOException {
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        boolean isSupportLibBootrom = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom() && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.JTAG && transferWay != TransferWay.JTAGAndSerial;
        boolean isBootromByJTAG = transferWay == TransferWay.JTAGAndNet || transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndSerial;
        SubMonitor subMonitor = null;
        if (this.uimonitor != null) {
            subMonitor = SubMonitor.convert((IProgressMonitor)this.uimonitor, (String)"", (int)50);
        }
        if (isSupportLibBootrom) {
            return this.burnByLibBootrom(subMonitor, filePath);
        }
        if (isBootromByJTAG) {
            return true;
        }
        try {
            new CallLibBootromWorker(this.frameSetting, this.burner, subMonitor);
            LibBootromByJNA.instance.Uart_RegisterPrint(CallLibBootromWorker.callback);
            LibBootromByJNA.instance.Uart_RegisterCancel(CallLibBootromWorker.callbackCancel);
            if (filePath == null || filePath.length() == 0) {
                this.prepareFile();
            } else if (!this.prepareFile(filePath)) {
                DdrCheckBurnerWorker.returnError(msg_FailedToPrepareFile);
                return false;
            }
            if (!this.downloadFile()) {
                DdrCheckBurnerWorker.returnError(Messages.ERROR_INFO_Failed_To_Download_File);
                return false;
            }
            this.infoln("Boot download completed!");
            if (this.getFlashType() != DDR) {
                if (!this.waitBootRun(10000)) {
                    return false;
                }
                this.infoln("Boot started successfully!");
            }
            return true;
        }
        finally {
            if (this.fileList != null) {
                this.fileList = null;
            }
        }
    }

    protected boolean burnByLibBootrom(SubMonitor subProgressMonitor, String filePath) {
        if (subProgressMonitor == null) {
            return false;
        }
        try {
            boolean is3796CV300;
            new CallLibBootromWorker(this.frameSetting, this.burner, subProgressMonitor);
            LibBootromByJNA.instance.Uart_RegisterPrint(CallLibBootromWorker.callback);
            LibBootromByJNA.instance.Uart_RegisterCancel(CallLibBootromWorker.callbackCancel);
            String commName = this.burner.getBurnContext().getLocalConfig().getComPort();
            if (this.burner.getBurnContext().getTransferWay() == TransferWay.NetNonNude) {
                filePath = null;
            }
            int notBareBurn = filePath == null || filePath.isEmpty() ? 1 : 0;
            int ddrOrFlash = this.getFlashType() != DDR ? 0 : 1;
            int[] caType = new int[1];
            long[] initDdrAddr = new long[1];
            int[] errorCode = new int[1];
            if (UnknownDevice.isOpenLightDebug()) {
                this.initLightState();
            }
            this.infoln(this.getStartMessage());
            subProgressMonitor.worked(1);
            boolean result = false;
            boolean bl = is3796CV300 = "CJ309V100".equalsIgnoreCase(ToolUtils.getChipName()) || "CJ309V101".equalsIgnoreCase(ToolUtils.getChipName()) || "CJ3X1VXX2".equalsIgnoreCase(ToolUtils.getChipName());
            if (is3796CV300) {
                CallLibBootromWorker.setTypeFrameFrequency(this.burner.getBurnContext().getDwTimeout());
                result = CallLibBootromWorker.bootDownloadByLib(commName, notBareBurn, ddrOrFlash, filePath, ToolUtils.getChipName(), caType, initDdrAddr, errorCode);
            } else {
                result = CallLibBootromWorker.bootDownloadByLib(commName, notBareBurn, ddrOrFlash, filePath, caType, initDdrAddr, errorCode);
            }
            if (this.burner instanceof AbstractBurner) {
                serialPort = ((AbstractBurner)((Object)this.burner)).openSerailPort(DdrCheckBurnerWorker.getMonitor(), this, this.burner.getBurnContext().getLocalConfig().getComPort());
            }
            if (serialPort == null) {
                return false;
            }
            if (result) {
                String caTypeStr = "";
                if (caType[0] == 1) {
                    caTypeStr = "CA";
                    this.isCaChipByLibBootrom = true;
                } else {
                    caTypeStr = "noCA";
                    this.isCaChipByLibBootrom = false;
                }
                this.updateCaTypeLbl(caTypeStr);
                ((UDFrameSetting)this.frameSetting).setDdrInitAddrByLibBootrom(initDdrAddr[0]);
            } else if ((errorCode[0] & 0xFFFF) == 256) {
                this.handleCancel();
                return false;
            }
            subProgressMonitor.worked(100);
            boolean bl2 = result;
            return bl2;
        }
        finally {
            subProgressMonitor.done();
        }
    }

    private boolean bootDownLoadByDDRCheck(SubMonitor subProgressMonitor, String filePath) throws IOException {
        try {
            subProgressMonitor.setTaskName("Downloading Boot");
            if (filePath == null || filePath.length() == 0) {
                this.prepareFile();
            } else if (!this.prepareFile(filePath)) {
                DdrCheckBurnerWorker.returnError(msg_FailedToPrepareFile);
                return false;
            }
            new CallLibBootromWorker(this.frameSetting, this.burner, subProgressMonitor);
            LibBootromByJNA.instance.Uart_RegisterPrint(CallLibBootromWorker.callback);
            LibBootromByJNA.instance.Uart_RegisterCancel(CallLibBootromWorker.callbackCancel);
            if (!this.downloadFile(this.getHexStartAddressForInt(), filePath, "     ")) {
                DdrCheckBurnerWorker.returnError(Messages.ERROR_INFO_Failed_To_Download_File);
                return false;
            }
            this.infoln("Boot download completed!");
            return true;
        }
        finally {
            if (this.fileList != null) {
                this.fileList = null;
            }
            subProgressMonitor.done();
        }
    }

    public boolean bootDownload(SubMonitor subProgressMonitor, String filePath) throws IOException {
        boolean isSupportLibBootrom;
        subProgressMonitor.beginTask("", 100);
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        boolean bl = isSupportLibBootrom = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom() && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.JTAG && transferWay != TransferWay.JTAGAndSerial;
        if (isSupportLibBootrom) {
            try {
                subProgressMonitor.setTaskName("Downloading Boot");
                if (!this.burnByLibBootrom(SubMonitor.convert((IProgressMonitor)this.uimonitor, (String)"", (int)98), filePath)) {
                    DdrCheckBurnerWorker.updateLightState();
                    return false;
                }
                this.infoln("Boot started successfully!");
                return true;
            }
            finally {
                subProgressMonitor.done();
            }
        }
        return this.bootDownLoadByDDRCheck(subProgressMonitor, filePath);
    }

    public boolean programmerDownload(String bootFile, String programmerFile) {
        block8: {
            block10: {
                block11: {
                    boolean programmerInvaild;
                    block9: {
                        try {
                            boolean bootAndProgrammerisInVaild;
                            if (!((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) break block8;
                            boolean bl = bootAndProgrammerisInVaild = (bootFile == null || bootFile.isEmpty()) && (programmerFile == null || programmerFile.isEmpty()) || this.burner.getBurnContext().getTransferWay() == TransferWay.NetNonNude;
                            if (!bootAndProgrammerisInVaild) break block9;
                            if (!this.bootDownload(null)) {
                                return false;
                            }
                        }
                        catch (IOException iOException) {
                            return false;
                        }
                    }
                    boolean bl = programmerInvaild = programmerFile == null || programmerFile.isEmpty();
                    if (!programmerInvaild) break block10;
                    if (this.bootDownload(bootFile)) break block11;
                    return false;
                }
                if (!this.isCaChipByLibBootrom) {
                    return true;
                }
            }
            if (!this.bootDownload(programmerFile)) {
                return false;
            }
        }
        return true;
    }

    public boolean programmerDownload(SubMonitor subProgressMonitor, String bootFile, String programmerFile, List<PartitionItem> parts) {
        block8: {
            block9: {
                block12: {
                    block11: {
                        block10: {
                            subProgressMonitor.setTaskName("Downloading Boot");
                            this.registerJnaFunction((IProgressMonitor)subProgressMonitor, 100);
                            TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
                            try {
                                boolean programmerInvaild;
                                boolean bootAndProgisInVaild;
                                boolean isSerial;
                                boolean bl = isSerial = transferWay == TransferWay.Serial || transferWay == TransferWay.Net;
                                if (!isSerial) break block8;
                                boolean bl2 = bootAndProgisInVaild = !(bootFile != null && !bootFile.isEmpty() || programmerFile != null && !programmerFile.isEmpty());
                                if (bootAndProgisInVaild) break block9;
                                boolean bl3 = programmerInvaild = programmerFile == null || programmerFile.isEmpty();
                                if (!programmerInvaild) break block10;
                                if (!this.prepareProgrammerFile(bootFile)) {
                                    return false;
                                }
                                break block11;
                            }
                            catch (IOException iOException) {
                                return false;
                            }
                        }
                        if (this.prepareProgrammerFile(programmerFile)) break block11;
                        return false;
                    }
                    new CallLibBootromWorker(this.frameSetting, this.burner, subProgressMonitor);
                    LibBootromByJNA.instance.Uart_RegisterPrint(CallLibBootromWorker.callback);
                    LibBootromByJNA.instance.Uart_RegisterCancel(CallLibBootromWorker.callbackCancel);
                    subProgressMonitor.subTask("Downloading boot");
                    this.infoln("[Download File by Serial]\nfile = " + bootFile + "\naddress = " + this.getHexStartAddress());
                    this.infoln("Serial Download Command = " + bootFile);
                    if (this.downloadFile(this.getHexStartAddressForInt(), bootFile, "     ")) break block12;
                    return false;
                }
                if (this.getFlashType() != DDR) break block9;
                return true;
            }
            subProgressMonitor.subTask("Waiting Boot to Run");
            if (!this.waitBootRunCA()) {
                return false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean waitBootRun(int timeMS) {
        startTime = System.currentTimeMillis();
        offset = 0;
        temp = null;
        subSequence = null;
        i2csBuilder = new StringBuilder();
        usbsBuilder = new StringBuilder();
        timeout = 30000L;
        transferWay = this.burner.getBurnContext().getTransferWay();
        if (transferWay != TransferWay.USBBootrom && transferWay != TransferWay.USBNonNude) ** GOTO lbl56
        CallLibUSBWorker.closeUsb(transferWay);
        this.sleep(timeMS);
        openUsbResult = CallLibUSBWorker.openUsb(this.uimonitor, timeout, transferWay, BurnConfig.getUsbSerialNumber());
        if (openUsbResult) ** GOTO lbl56
        return false;
lbl-1000:
        // 1 sources

        {
            if (transferWay == TransferWay.I2CBootrom) {
                try {
                    this.receiveBytesByI2c(i2csBuilder, 256);
                    temp = i2csBuilder.toString();
                }
                catch (IOException v0) {}
            } else if (transferWay == TransferWay.USBBootrom || transferWay == TransferWay.USBNonNude) {
                try {
                    this.receiveBytesByUsbIgnore(usbsBuilder, 512, transferWay);
                    temp = usbsBuilder.toString();
                }
                catch (IOException v1) {}
            } else {
                try {
                    this.receiveBytes(DdrCheckBurnerWorker.serialReceived, 4096);
                }
                catch (IOException v2) {}
                temp = DdrCheckBurnerWorker.serialReceived.toString();
            }
            indexOf = -1;
            if (temp == null || temp.length() <= offset) continue;
            len = temp.length();
            subSequence = temp.subSequence(offset, len);
            offset += subSequence.length();
            if (subSequence.toString().indexOf("\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014") == -1) {
                DdrCheckBurnerWorker.received(subSequence.toString());
            } else {
                DdrCheckBurnerWorker.receivedln(subSequence.toString());
            }
            indexOf = temp.toLowerCase().indexOf("start download process.");
            if (UnknownDevice.isOpenLightDebug() && temp.toString().contains("*** Not upport current start mode")) {
                AbstractBurnerWorker.lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FLASH_AND_IMAGE_MATCH.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                DdrCheckBurnerWorker.updateLightState();
            }
            if (indexOf == -1) continue;
            if (UnknownDevice.isOpenLightDebug()) {
                DdrCheckBurnerWorker.readBootInfo(temp);
            }
            DdrCheckBurnerWorker.received("\n");
            return true;
lbl56:
            // 4 sources

            ** while (System.currentTimeMillis() - startTime < timeout)
        }
lbl57:
        // 1 sources

        if (UnknownDevice.isOpenLightDebug()) {
            DdrCheckBurnerWorker.lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FASTBOOT_START.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
            DdrCheckBurnerWorker.updateLightState();
        }
        DdrCheckBurnerWorker.returnError(Messages.ERROR_INFO_Failed_To_Wait_Boot_Running);
        return false;
    }

    protected boolean waitBootRunCA() {
        long startTime = System.currentTimeMillis();
        int offset = 0;
        String temp = null;
        CharSequence subSequence = null;
        while (System.currentTimeMillis() - startTime < 10000L) {
            int indexOf;
            this.onAdataAvailable(serialReceived);
            temp = serialReceived.toString();
            if (temp.length() > offset) {
                int len = temp.length();
                subSequence = temp.subSequence(offset, len);
                offset += subSequence.length();
                if (temp.toString().indexOf("     ") == -1) {
                    DdrCheckBurnerWorker.received(subSequence.toString());
                } else {
                    try {
                        this.sendBytes(new byte[]{-86});
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                    DdrCheckBurnerWorker.receivedln(subSequence.toString());
                }
            }
            if ((indexOf = temp.toLowerCase().indexOf("start download process.")) == -1) continue;
            this.ubootStartLog = temp;
            DdrCheckBurnerWorker.received(LINE_BREAK);
            return true;
        }
        DdrCheckBurnerWorker.returnError(Messages.ERROR_INFO_Failed_To_Wait_Boot_Running);
        return false;
    }

    private void sleep(int timeMS) {
        if (timeMS < 1) {
            return;
        }
        try {
            Thread.sleep(timeMS);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected static void updateLightState() {
        if (ToolUtils.isCmdLine()) {
            return;
        }
        if (DdrCheckBurnerWorker.getLightView() != null) {
            DdrCheckBurnerWorker.updateLightColor(DdrCheckBurnerWorker.getLightView().getSerialLbl(), (Integer)lightCurrentStateMap.get(AbstractBurnerWorker.Light_E.SERIAL.name()));
            DdrCheckBurnerWorker.updateLightColor(DdrCheckBurnerWorker.getLightView().getCpuLbl(), (Integer)lightCurrentStateMap.get(AbstractBurnerWorker.Light_E.CPU.name()));
            DdrCheckBurnerWorker.updateLightColor(DdrCheckBurnerWorker.getLightView().getBootromLbl(), (Integer)lightCurrentStateMap.get(AbstractBurnerWorker.Light_E.BOOTROM.name()));
            DdrCheckBurnerWorker.updateLightColor(DdrCheckBurnerWorker.getLightView().getReadEmmcLbl(), (Integer)lightCurrentStateMap.get(AbstractBurnerWorker.Light_E.READ_EMMC.name()));
            DdrCheckBurnerWorker.updateLightColor(DdrCheckBurnerWorker.getLightView().getReadSDLbl(), (Integer)lightCurrentStateMap.get(AbstractBurnerWorker.Light_E.READ_SD.name()));
            DdrCheckBurnerWorker.updateLightColor(DdrCheckBurnerWorker.getLightView().getDdrInitLbl(), (Integer)lightCurrentStateMap.get(AbstractBurnerWorker.Light_E.DDR_INIT.name()));
            DdrCheckBurnerWorker.updateLightColor(DdrCheckBurnerWorker.getLightView().getDdrTrainingLbl(), (Integer)lightCurrentStateMap.get(AbstractBurnerWorker.Light_E.DDR_TRAINING.name()));
            DdrCheckBurnerWorker.updateLightColor(DdrCheckBurnerWorker.getLightView().getFastbootStartLbl(), (Integer)lightCurrentStateMap.get(AbstractBurnerWorker.Light_E.FASTBOOT_START.name()));
            DdrCheckBurnerWorker.updateLightColor(DdrCheckBurnerWorker.getLightView().getFlashTypeMatchLbl(), (Integer)lightCurrentStateMap.get(AbstractBurnerWorker.Light_E.FLASH_AND_IMAGE_MATCH.name()));
            DdrCheckBurnerWorker.updateLightColor(DdrCheckBurnerWorker.getLightView().getEmmcFlash(), (Integer)lightCurrentStateMap.get(AbstractBurnerWorker.Light_E.FLASH_EMMC.name()));
            DdrCheckBurnerWorker.updateLightColor(DdrCheckBurnerWorker.getLightView().getNandFlash(), (Integer)lightCurrentStateMap.get(AbstractBurnerWorker.Light_E.FLASH_NAND.name()));
        }
    }
}

