/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.serial.workers;

import com.vendor.burn.Messages;
import com.vendor.burn.analysis.TimeLogger;
import com.vendor.burn.commands.EraseCommand;
import com.vendor.burn.commands.MWCommand;
import com.vendor.burn.commands.UnZipCommand;
import com.vendor.burn.commands.WriteCommand;
import com.vendor.burn.model.ChipID;
import com.vendor.burn.model.FileSystem;
import com.vendor.burn.model.FlashType;
import com.vendor.burn.model.PartitionItem;
import com.vendor.burn.model.PlatformType;
import com.vendor.burn.model.TransferWay;
import com.vendor.burn.model.config.BurnConfig;
import com.vendor.burn.model.config.PreferenceConfig;
import com.vendor.burn.model.devices.burners.AbstractBurner;
import com.vendor.burn.model.devices.burners.EmmcBurner;
import com.vendor.burn.model.devices.unknown.UDFrameSetting;
import com.vendor.burn.model.devices.unknown.UDProperties;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import com.vendor.burn.model.event.EventType;
import com.vendor.burn.model.receive.ReceiveTimeOutException;
import com.vendor.burn.model.struct.SPartitionItem;
import com.vendor.burn.model.struct.XmodelParameter;
import com.vendor.burn.preferences.FastbootPreferences;
import com.vendor.burn.serial.workers.CallLibJTAGWorker;
import com.vendor.burn.serial.workers.CallLibUSBWorker;
import com.vendor.burn.serial.workers.PartitionBurnerWorker;
import com.vendor.burn.sparse.SparseFileAgent;
import com.vendor.burn.sparse.SparseHeader;
import com.vendor.burn.thread.LargeFileTogetherThread;
import com.vendor.burn.thread.PartitionTempObj;
import com.vendor.burn.thread.TempFileInfo;
import com.vendor.burn.utilitily.BufferedRandomAccessFile;
import com.vendor.burn.utilitily.FileUtils;
import com.vendor.burn.utilitily.ToolUtils;
import com.vendor.burn.views.FastbootView;
import com.vendor.platform.api.statistics.ToolStatistics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class EmmcPartitionBurnerWorker
extends PartitionBurnerWorker {
    private static long tempFileDivisionSize = 0L;
    static final int MAXINUM_HEADS = 4;
    static final int MAXINUM_SECTORS = 16;
    static final int EXTENDED = 5;
    static final int LINUX_NATIVE = 131;
    static final int LINUX_EXTENDED = 133;
    private static final int[] eMMCBootSector;
    protected boolean useCompress;
    private final LargeFileTogetherThread largeFileTogetherThread = new LargeFileTogetherThread(this);
    private final long[][] m_nOldExt3Part = new long[256][3];

    static {
        int[] nArray = new int[512];
        nArray[0] = 6;
        nArray[3] = 234;
        nArray[4] = 254;
        nArray[5] = 255;
        nArray[6] = 255;
        nArray[7] = 234;
        nArray[8] = 254;
        nArray[9] = 255;
        nArray[10] = 255;
        nArray[11] = 234;
        nArray[12] = 254;
        nArray[13] = 255;
        nArray[14] = 255;
        nArray[15] = 234;
        nArray[16] = 254;
        nArray[17] = 255;
        nArray[18] = 255;
        nArray[19] = 234;
        nArray[20] = 254;
        nArray[21] = 255;
        nArray[22] = 255;
        nArray[23] = 234;
        nArray[24] = 254;
        nArray[25] = 255;
        nArray[26] = 255;
        nArray[27] = 234;
        nArray[28] = 254;
        nArray[29] = 255;
        nArray[30] = 255;
        nArray[31] = 234;
        nArray[32] = 15;
        nArray[34] = 160;
        nArray[35] = 225;
        nArray[36] = 8;
        nArray[38] = 64;
        nArray[39] = 226;
        nArray[40] = 208;
        nArray[41] = 16;
        nArray[42] = 159;
        nArray[43] = 229;
        nArray[44] = 1;
        nArray[46] = 128;
        nArray[47] = 224;
        nArray[49] = 240;
        nArray[50] = 160;
        nArray[51] = 225;
        nArray[53] = 240;
        nArray[54] = 32;
        nArray[55] = 227;
        nArray[57] = 240;
        nArray[58] = 32;
        nArray[59] = 227;
        nArray[61] = 240;
        nArray[62] = 32;
        nArray[63] = 227;
        nArray[65] = 240;
        nArray[66] = 32;
        nArray[67] = 227;
        nArray[69] = 240;
        nArray[70] = 32;
        nArray[71] = 227;
        nArray[73] = 240;
        nArray[74] = 32;
        nArray[75] = 227;
        nArray[77] = 240;
        nArray[78] = 32;
        nArray[79] = 227;
        nArray[81] = 240;
        nArray[82] = 32;
        nArray[83] = 227;
        nArray[84] = 254;
        nArray[85] = 255;
        nArray[86] = 255;
        nArray[87] = 234;
        nArray[88] = 255;
        nArray[89] = 255;
        nArray[90] = 255;
        nArray[91] = 255;
        nArray[92] = 255;
        nArray[93] = 255;
        nArray[94] = 255;
        nArray[95] = 255;
        nArray[96] = 255;
        nArray[97] = 255;
        nArray[98] = 255;
        nArray[99] = 255;
        nArray[100] = 255;
        nArray[101] = 255;
        nArray[102] = 255;
        nArray[103] = 255;
        nArray[104] = 255;
        nArray[105] = 255;
        nArray[106] = 255;
        nArray[107] = 255;
        nArray[108] = 255;
        nArray[109] = 255;
        nArray[110] = 255;
        nArray[111] = 255;
        nArray[112] = 255;
        nArray[113] = 255;
        nArray[114] = 255;
        nArray[115] = 255;
        nArray[116] = 255;
        nArray[117] = 255;
        nArray[118] = 255;
        nArray[119] = 255;
        nArray[120] = 255;
        nArray[121] = 255;
        nArray[122] = 255;
        nArray[123] = 255;
        nArray[124] = 255;
        nArray[125] = 255;
        nArray[126] = 255;
        nArray[127] = 255;
        nArray[128] = 255;
        nArray[129] = 255;
        nArray[130] = 255;
        nArray[131] = 255;
        nArray[132] = 255;
        nArray[133] = 255;
        nArray[134] = 255;
        nArray[135] = 255;
        nArray[136] = 255;
        nArray[137] = 255;
        nArray[138] = 255;
        nArray[139] = 255;
        nArray[140] = 255;
        nArray[141] = 255;
        nArray[142] = 255;
        nArray[143] = 255;
        nArray[144] = 255;
        nArray[145] = 255;
        nArray[146] = 255;
        nArray[147] = 255;
        nArray[148] = 255;
        nArray[149] = 255;
        nArray[150] = 255;
        nArray[151] = 255;
        nArray[152] = 255;
        nArray[153] = 255;
        nArray[154] = 255;
        nArray[155] = 255;
        nArray[156] = 255;
        nArray[157] = 255;
        nArray[158] = 255;
        nArray[159] = 255;
        nArray[160] = 255;
        nArray[161] = 255;
        nArray[162] = 255;
        nArray[163] = 255;
        nArray[164] = 255;
        nArray[165] = 255;
        nArray[166] = 255;
        nArray[167] = 255;
        nArray[168] = 255;
        nArray[169] = 255;
        nArray[170] = 255;
        nArray[171] = 255;
        nArray[172] = 255;
        nArray[173] = 255;
        nArray[174] = 255;
        nArray[175] = 255;
        nArray[176] = 255;
        nArray[177] = 255;
        nArray[178] = 255;
        nArray[179] = 255;
        nArray[180] = 255;
        nArray[181] = 255;
        nArray[182] = 255;
        nArray[183] = 255;
        nArray[184] = 255;
        nArray[185] = 255;
        nArray[186] = 255;
        nArray[187] = 255;
        nArray[188] = 255;
        nArray[189] = 255;
        nArray[190] = 255;
        nArray[191] = 255;
        nArray[192] = 255;
        nArray[193] = 255;
        nArray[194] = 255;
        nArray[195] = 255;
        nArray[196] = 255;
        nArray[197] = 255;
        nArray[198] = 255;
        nArray[199] = 255;
        nArray[200] = 255;
        nArray[201] = 255;
        nArray[202] = 255;
        nArray[203] = 255;
        nArray[204] = 255;
        nArray[205] = 255;
        nArray[206] = 255;
        nArray[207] = 255;
        nArray[208] = 255;
        nArray[209] = 255;
        nArray[210] = 255;
        nArray[211] = 255;
        nArray[212] = 255;
        nArray[213] = 255;
        nArray[214] = 255;
        nArray[215] = 255;
        nArray[216] = 255;
        nArray[217] = 255;
        nArray[218] = 255;
        nArray[219] = 255;
        nArray[220] = 255;
        nArray[221] = 255;
        nArray[222] = 255;
        nArray[223] = 255;
        nArray[224] = 255;
        nArray[225] = 255;
        nArray[226] = 255;
        nArray[227] = 255;
        nArray[228] = 255;
        nArray[229] = 255;
        nArray[230] = 255;
        nArray[231] = 255;
        nArray[232] = 255;
        nArray[233] = 255;
        nArray[234] = 255;
        nArray[235] = 255;
        nArray[236] = 255;
        nArray[237] = 255;
        nArray[238] = 255;
        nArray[239] = 255;
        nArray[240] = 255;
        nArray[241] = 255;
        nArray[242] = 255;
        nArray[243] = 255;
        nArray[244] = 255;
        nArray[245] = 255;
        nArray[246] = 255;
        nArray[247] = 255;
        nArray[248] = 255;
        nArray[249] = 255;
        nArray[250] = 255;
        nArray[251] = 255;
        nArray[252] = 255;
        nArray[253] = 255;
        nArray[254] = 255;
        nArray[255] = 255;
        nArray[256] = 224;
        nArray[257] = 1;
        nArray[260] = 255;
        nArray[261] = 255;
        nArray[262] = 255;
        nArray[263] = 255;
        nArray[264] = 255;
        nArray[265] = 255;
        nArray[266] = 255;
        nArray[267] = 255;
        nArray[268] = 255;
        nArray[269] = 255;
        nArray[270] = 255;
        nArray[271] = 255;
        nArray[272] = 255;
        nArray[273] = 255;
        nArray[274] = 255;
        nArray[275] = 255;
        nArray[276] = 255;
        nArray[277] = 255;
        nArray[278] = 255;
        nArray[279] = 255;
        nArray[280] = 255;
        nArray[281] = 255;
        nArray[282] = 255;
        nArray[283] = 255;
        nArray[284] = 255;
        nArray[285] = 255;
        nArray[286] = 255;
        nArray[287] = 255;
        nArray[288] = 255;
        nArray[289] = 255;
        nArray[290] = 255;
        nArray[291] = 255;
        nArray[292] = 255;
        nArray[293] = 255;
        nArray[294] = 255;
        nArray[295] = 255;
        nArray[296] = 255;
        nArray[297] = 255;
        nArray[298] = 255;
        nArray[299] = 255;
        nArray[300] = 255;
        nArray[301] = 255;
        nArray[302] = 255;
        nArray[303] = 255;
        nArray[304] = 255;
        nArray[305] = 255;
        nArray[306] = 255;
        nArray[307] = 255;
        nArray[308] = 255;
        nArray[309] = 255;
        nArray[310] = 255;
        nArray[311] = 255;
        nArray[312] = 255;
        nArray[313] = 255;
        nArray[314] = 255;
        nArray[315] = 255;
        nArray[316] = 255;
        nArray[317] = 255;
        nArray[318] = 255;
        nArray[319] = 255;
        nArray[320] = 255;
        nArray[321] = 255;
        nArray[322] = 255;
        nArray[323] = 255;
        nArray[324] = 255;
        nArray[325] = 255;
        nArray[326] = 255;
        nArray[327] = 255;
        nArray[328] = 255;
        nArray[329] = 255;
        nArray[330] = 255;
        nArray[331] = 255;
        nArray[332] = 255;
        nArray[333] = 255;
        nArray[334] = 255;
        nArray[335] = 255;
        nArray[336] = 255;
        nArray[337] = 255;
        nArray[338] = 255;
        nArray[339] = 255;
        nArray[340] = 255;
        nArray[341] = 255;
        nArray[342] = 255;
        nArray[343] = 255;
        nArray[344] = 255;
        nArray[345] = 255;
        nArray[346] = 255;
        nArray[347] = 255;
        nArray[348] = 255;
        nArray[349] = 255;
        nArray[350] = 255;
        nArray[351] = 255;
        nArray[352] = 255;
        nArray[353] = 255;
        nArray[354] = 255;
        nArray[355] = 255;
        nArray[356] = 255;
        nArray[357] = 255;
        nArray[358] = 255;
        nArray[359] = 255;
        nArray[360] = 255;
        nArray[361] = 255;
        nArray[362] = 255;
        nArray[363] = 255;
        nArray[364] = 255;
        nArray[365] = 255;
        nArray[366] = 255;
        nArray[367] = 255;
        nArray[368] = 255;
        nArray[369] = 255;
        nArray[370] = 255;
        nArray[371] = 255;
        nArray[372] = 255;
        nArray[373] = 255;
        nArray[374] = 255;
        nArray[375] = 255;
        nArray[376] = 255;
        nArray[377] = 255;
        nArray[378] = 255;
        nArray[379] = 255;
        nArray[380] = 255;
        nArray[381] = 255;
        nArray[382] = 255;
        nArray[383] = 255;
        nArray[384] = 255;
        nArray[385] = 255;
        nArray[386] = 255;
        nArray[387] = 255;
        nArray[388] = 255;
        nArray[389] = 255;
        nArray[390] = 255;
        nArray[391] = 255;
        nArray[392] = 255;
        nArray[393] = 255;
        nArray[394] = 255;
        nArray[395] = 255;
        nArray[396] = 255;
        nArray[397] = 255;
        nArray[398] = 255;
        nArray[399] = 255;
        nArray[400] = 255;
        nArray[401] = 255;
        nArray[402] = 255;
        nArray[403] = 255;
        nArray[404] = 255;
        nArray[405] = 255;
        nArray[406] = 255;
        nArray[407] = 255;
        nArray[408] = 255;
        nArray[409] = 255;
        nArray[410] = 255;
        nArray[411] = 255;
        nArray[412] = 255;
        nArray[413] = 255;
        nArray[414] = 255;
        nArray[415] = 255;
        nArray[416] = 255;
        nArray[417] = 255;
        nArray[418] = 255;
        nArray[419] = 255;
        nArray[420] = 255;
        nArray[421] = 255;
        nArray[422] = 255;
        nArray[423] = 255;
        nArray[424] = 255;
        nArray[425] = 255;
        nArray[426] = 255;
        nArray[427] = 255;
        nArray[428] = 255;
        nArray[429] = 255;
        nArray[430] = 255;
        nArray[431] = 255;
        nArray[432] = 255;
        nArray[433] = 255;
        nArray[434] = 255;
        nArray[435] = 255;
        nArray[436] = 255;
        nArray[437] = 255;
        nArray[438] = 255;
        nArray[439] = 255;
        nArray[440] = 255;
        nArray[441] = 255;
        nArray[442] = 255;
        nArray[443] = 255;
        nArray[444] = 255;
        nArray[445] = 255;
        nArray[510] = 85;
        nArray[511] = 170;
        eMMCBootSector = nArray;
    }

    public EmmcPartitionBurnerWorker(EmmcBurner burner) {
        super(burner);
        this.burner = burner;
    }

    @Override
    public boolean burn(IProgressMonitor uiMonitor, List<PartitionItem> parts) throws IOException, ReceiveTimeOutException {
        ToolStatistics.INSTANCE.logUsage("BurnTool", "Burn Emmc", "ChipName: " + this.burner.getBurnContext().getDeviceSetting().getName());
        ToolStatistics.INSTANCE.logToolInUse("BurnTool");
        String versionInfo = this.getVersionInfo("Burn Emmc");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        if (UnknownDevice.isOpenLightDebug()) {
            this.initLightState();
        }
        this.burnBootTimeLogger = new TimeLogger();
        this.tftpTimeLogger = new TimeLogger();
        this.burnTimeLogger = new TimeLogger();
        this.waitZipTimeLogger = new TimeLogger();
        this.zipAndPageTimeLogger = new TimeLogger();
        this.unZipTimeLogger = new TimeLogger();
        this.spellingSparseFileLogger = new TimeLogger();
        this.setCrcLogger(new TimeLogger());
        long burnStartTime = 0L;
        burnStartTime = System.currentTimeMillis();
        this.setProgressMonitor(uiMonitor);
        EmmcPartitionBurnerWorker.getMonitor().getEvent().init(EventType.BURN);
        int emmcType = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getEmmcType();
        int selectedPartCount = 1;
        for (PartitionItem partitionItem : parts) {
            if (!partitionItem.isChecked()) continue;
            ++selectedPartCount;
        }
        boolean createPartitionTable = false;
        if (emmcType == PartitionBurnerWorker.EMMC_TYPE_E.EMMC_HAVE_MBR_TYPE.ordinal() && (createPartitionTable = ((EmmcBurner)this.burner).isCreatePartitionTable())) {
            ++selectedPartCount;
        }
        uiMonitor.beginTask("", selectedPartCount * 100);
        try {
            int partsSize;
            boolean burnOver;
            TransferWay transferWay;
            PartitionItem fastboot = parts.get(0);
            if (fastboot.isChecked()) {
                uiMonitor.setTaskName("Burning Fastboot Partition");
            }
            if (fastboot.getFile() != null) {
                this.burnBootTimeLogger.logStart(fastboot.getName(), fastboot.getFile().length());
            }
            if (!this.burnbootForEmmc(transferWay = this.getBurner().getBurnContext().getTransferWay(), emmcType, fastboot, parts)) {
                return false;
            }
            if (fastboot.getFile() != null) {
                this.burnBootTimeLogger.logEnd();
            }
            boolean bl = burnOver = (partsSize = parts.size()) == 1 && !createPartitionTable;
            if (burnOver) {
                String resetCommand = "reset";
                this.sendCommandNoReturnValue(resetCommand);
                return true;
            }
            if (!this.needSetupNetwork(transferWay)) {
                return false;
            }
            if (!this.createMBR(uiMonitor, parts, emmcType, createPartitionTable)) {
                return false;
            }
            uiMonitor.setTaskName("Burning Other Partitions");
            String ddrFreeSizeStr = this.getDDRFreeParam();
            long ddrFreeSize = this.parseLong(this.getDDRFreeParam("size:", ddrFreeSizeStr, transferWay));
            this.useCompress = this.getTempDivisionSize(ddrFreeSize);
            this.runMakeZipThread(uiMonitor, parts, this.useCompress);
            this.uimonitor.setTaskName("Burning Partitions");
            boolean result = this.burnOtherPartition(uiMonitor, parts, emmcType, partsSize, transferWay);
            if (!result) {
                boolean bl2 = result;
                return bl2;
            }
            long burnTotalTime = System.currentTimeMillis() - burnStartTime;
            String burnTotalTimeStr = this.calculateBurnTotalTime(burnTotalTime);
            EmmcPartitionBurnerWorker.getMonitor().getEvent().setTotalBurnTime(burnTotalTimeStr);
            this.printDebugTimeLogger(fastboot, burnTotalTime);
            boolean bl3 = result;
            return bl3;
        }
        finally {
            this.largeFileTogetherThread.stop();
            this.largeFileTogetherThread.clearTempFile();
            uiMonitor.done();
        }
    }

    private boolean burnOtherPartition(IProgressMonitor uiMonitor, List<PartitionItem> parts, int emmcType, int partsSize, TransferWay transferWay) throws IOException, ReceiveTimeOutException {
        boolean isResetJtag;
        int nExtFormatCount = 0;
        boolean result = true;
        int index = 1;
        while (index < partsSize) {
            PartitionItem lastItem;
            boolean isLastPart;
            PartitionItem partitionItem = parts.get(index);
            FileSystem fileSystem = partitionItem.getFileSystem();
            if (FileSystem.ext3 == fileSystem || fileSystem == FileSystem.f2fs || fileSystem == FileSystem.erofs) {
                ++nExtFormatCount;
            }
            String partitionName = partitionItem.getName() == null ? "" : partitionItem.getName();
            uiMonitor.subTask("Partition " + partitionItem.getName());
            EmmcPartitionBurnerWorker.getMonitor().highlight(partitionItem);
            long partStart = partitionItem.getStart();
            long partLength = partitionItem.getLength();
            long startSector = partStart / 512L;
            boolean bl = isLastPart = index == partsSize - 1 && partLength == -1L;
            if (isLastPart && (lastItem = parts.get(index)).isChecked() && (partLength = this.getLastPartitionLen(emmcType, nExtFormatCount, partitionItem, partLength, startSector)) == -1L) {
                return false;
            }
            if (emmcType == PartitionBurnerWorker.EMMC_TYPE_E.EMMC_HAVE_MBR_TYPE.ordinal()) {
                startSector += (long)nExtFormatCount;
            }
            boolean isBootargsNeedChanged = false;
            if (!ToolUtils.isCmdLine() && FastbootPreferences.isUpdateBootargsOn()) {
                isBootargsNeedChanged = true;
            }
            if (!partitionItem.isChecked()) {
                boolean isnotCheckBootargs;
                boolean bl2 = isnotCheckBootargs = isBootargsNeedChanged && partitionItem.getName().equalsIgnoreCase("bootargs");
                if (isnotCheckBootargs) {
                    EmmcPartitionBurnerWorker.warningln("Bootargs partition has not been checked, so the automatic update bootargs is not successful!");
                }
            } else {
                boolean needUpdateBootargs;
                File file = null;
                boolean bl3 = needUpdateBootargs = isBootargsNeedChanged && partitionItem.getName().equalsIgnoreCase("bootargs") && partitionItem.getFile() != null;
                if (needUpdateBootargs) {
                    this.setTmpBootargsString(this.getEmmcBootargsPartitionString(parts));
                    if (this.getTmpBootargsString() != null) {
                        file = this.prepareEmmcReplacedBootargs(partitionItem.getFile(), this.getTmpBootargsString());
                    }
                } else if (partitionItem.getFile() != null) {
                    file = partitionItem.getFile();
                }
                if (file != null) {
                    long burnLenSector;
                    boolean validFileResult = this.validFile(partitionName, file);
                    this.switchTFTPDownloadHome(file);
                    long fileSize = 0L;
                    if (validFileResult) {
                        fileSize = file.length();
                    }
                    long burnFileSize = fileSize / 512L * 512L;
                    if (fileSize % 512L != 0L) {
                        burnFileSize += 512L;
                    }
                    if ((burnLenSector = burnFileSize / 512L) == 0L) {
                        return false;
                    }
                    FlashType flashType = partitionItem.getFlashType();
                    result = this.burnFile(uiMonitor, fileSystem, partLength, startSector, file, burnFileSize, burnLenSector, flashType, tempFileDivisionSize, partitionName, partitionItem.getChipID());
                    if (!result) {
                        return result;
                    }
                } else {
                    FlashType flashType;
                    long burnLenSector;
                    long burnPartitionLen = partLength / 512L * 512L;
                    if (burnPartitionLen % 512L != 0L) {
                        burnPartitionLen += 512L;
                    }
                    if (!(result = this.burnFile(uiMonitor, fileSystem, partLength, startSector, null, burnPartitionLen, burnLenSector = burnPartitionLen / 512L, flashType = partitionItem.getFlashType(), tempFileDivisionSize, partitionName, partitionItem.getChipID()))) {
                        return result;
                    }
                }
                if (file != null) {
                    this.deleteTempFile(partitionItem, file);
                }
                this.burnPartitionInfo(result, partitionName, file);
            }
            ++index;
        }
        this.infoln("Partition burnt completed!");
        this.sendCommandToSetMac();
        boolean bl = isResetJtag = !(!FastbootView.isCJXX0VXX5Series() && !FastbootView.isCJ3X0VXX1Series() && !FastbootView.isCJ3X1VXX8E_Series() || transferWay != TransferWay.JTAG && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.JTAGAndSerial);
        if (!isResetJtag) {
            String resetCommand = "reset";
            this.sendCommandNoReturnValue(resetCommand);
        }
        return result;
    }

    protected boolean burnEachPartForEmmc(IProgressMonitor uimonitor, List<PartitionItem> parts, int index) throws IOException, ReceiveTimeOutException {
        boolean needUpdateBootargs;
        PartitionItem lastItem;
        boolean isLastPart;
        boolean result = false;
        int partsSize = parts.size();
        int emmcType = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getEmmcType();
        PartitionItem partitionItem = parts.get(index);
        FileSystem fileSystem = partitionItem.getFileSystem();
        String partitionName = partitionItem.getName() == null ? "" : partitionItem.getName();
        uimonitor.subTask("Partition " + partitionItem.getName());
        EmmcPartitionBurnerWorker.getMonitor().highlight(partitionItem);
        long partStart = partitionItem.getStart();
        long partLength = partitionItem.getLength();
        long startSector = partStart / 512L;
        boolean bl = isLastPart = index == partsSize - 1 && partLength == -1L;
        if (isLastPart && (lastItem = parts.get(index)).isChecked() && (partLength = this.getLastPartitionLen(emmcType, 0, partitionItem, partLength, startSector)) == -1L) {
            return false;
        }
        boolean isBootargsNeedChanged = false;
        isBootargsNeedChanged = ToolUtils.isCmdLine() ? PreferenceConfig.isCmdEraseBeforeBurn() : FastbootPreferences.isEmmcEraseBeforeBurn();
        if (!partitionItem.isChecked()) {
            boolean isnotCheckBootargs;
            boolean bl2 = isnotCheckBootargs = isBootargsNeedChanged && partitionItem.getName().equalsIgnoreCase("bootargs");
            if (isnotCheckBootargs) {
                EmmcPartitionBurnerWorker.warningln("Bootargs partition has not been checked, so the automatic update bootargs is not successful!");
            }
            return true;
        }
        File file = null;
        boolean bl3 = needUpdateBootargs = isBootargsNeedChanged && partitionItem.getName().equalsIgnoreCase("bootargs") && partitionItem.getFile() != null;
        if (needUpdateBootargs) {
            if (this.getEmmcBootargsPartitionString(parts) != null) {
                this.setTmpBootargsString(this.getEmmcBootargsPartitionString(parts));
            }
            if (partitionItem.getFile() != null && this.getTmpBootargsString() != null) {
                file = this.prepareEmmcReplacedBootargs(partitionItem.getFile(), this.getTmpBootargsString());
            }
        } else if (partitionItem.getFile() != null) {
            file = partitionItem.getFile();
        }
        if (file != null) {
            boolean validFileResult = this.validFile(partitionName, file);
            if (!validFileResult) {
                return validFileResult;
            }
            this.switchTFTPDownloadHome(file);
            long fileSize = file.length();
            long burnLenSector = (fileSize + 512L - 1L) / 512L;
            long burnFileSize = burnLenSector * 512L;
            if (burnLenSector == 0L) {
                return false;
            }
            FlashType flashType = partitionItem.getFlashType();
            result = this.burnFile(uimonitor, fileSystem, partLength, startSector, file, burnFileSize, burnLenSector, flashType, tempFileDivisionSize, partitionName, partitionItem.getChipID());
            if (!result) {
                return result;
            }
        } else {
            FlashType flashType;
            long burnLenSector;
            long burnPartitionLen = partLength / 512L * 512L;
            if (burnPartitionLen % 512L != 0L) {
                burnPartitionLen += 512L;
            }
            if (!(result = this.burnFile(uimonitor, fileSystem, partLength, startSector, null, burnPartitionLen, burnLenSector = burnPartitionLen / 512L, flashType = partitionItem.getFlashType(), tempFileDivisionSize, partitionName, partitionItem.getChipID()))) {
                return result;
            }
        }
        if (file != null) {
            this.deleteTempFile(partitionItem, file);
        }
        this.burnPartitionInfo(result, partitionName, file);
        return result;
    }

    protected void deleteTempFile(PartitionItem partitionItem, File file) {
        if (file == partitionItem.getFile()) {
            return;
        }
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    protected void printDebugTimeLogger(PartitionItem fastboot, long burnTotalTime) {
        if (ToolUtils.isDebugOn()) {
            if (fastboot.getFile() != null) {
                EmmcPartitionBurnerWorker.getMonitor().println(this.burnBootTimeLogger.exportLog("BurnBoot Command Execution"));
            }
            EmmcPartitionBurnerWorker.getMonitor().println(this.spellingSparseFileLogger.exportLog("Spelling Sparse File"));
            EmmcPartitionBurnerWorker.getMonitor().println(this.zipAndPageTimeLogger.exportLog("ZipAndPage Command Execution"));
            EmmcPartitionBurnerWorker.getMonitor().println(this.waitZipTimeLogger.exportLog("WaitZip Command Execution"));
            if (this.getBurner().getBurnContext().getTransferWay() == TransferWay.Net) {
                EmmcPartitionBurnerWorker.getMonitor().println(this.tftpTimeLogger.exportLog("TFTP Transfer"));
            }
            EmmcPartitionBurnerWorker.getMonitor().println(this.crcLogger.exportLog("CRC Command Execution"));
            EmmcPartitionBurnerWorker.getMonitor().println(this.unZipTimeLogger.exportLog("UnZip Command Execution"));
            EmmcPartitionBurnerWorker.getMonitor().println(this.burnTimeLogger.exportLog("Write Command Execution"));
            EmmcPartitionBurnerWorker.getMonitor().println("\nTotal Burn Time: " + burnTotalTime + " ms");
        }
    }

    protected boolean burnbootForEmmc(TransferWay transferWay, int emmcType, PartitionItem fastboot, List<PartitionItem> parts) throws IOException, ReceiveTimeOutException {
        boolean bootProcessResult;
        boolean result;
        return !(transferWay == TransferWay.USBNonNude ? !(result = this.burnbootByUSBNoneNudeForEmmc(emmcType, fastboot, transferWay)) : !(bootProcessResult = this.bootProcess(SubMonitor.convert((IProgressMonitor)this.uimonitor, (String)"", (int)50), fastboot, parts)));
    }

    protected boolean needSetupNetwork(TransferWay transferWay) throws ReceiveTimeOutException {
        if (this.isNeedSetupNet(transferWay) && !this.setupNetwork(transferWay)) {
            EmmcPartitionBurnerWorker.returnError("Failed to setup network!");
            return false;
        }
        return true;
    }

    protected void runMakeZipThread(final IProgressMonitor uiMonitor, final List<PartitionItem> parts, boolean useCompress) {
        if (useCompress) {
            new Thread(){

                @Override
                public void run() {
                    boolean isCreate = true;
                    try {
                        EmmcPartitionBurnerWorker.this.largeFileTogetherThread.startMakeZipFile(uiMonitor, parts, tempFileDivisionSize, EmmcPartitionBurnerWorker.getMonitor());
                    }
                    catch (IOException e) {
                        isCreate = false;
                        EmmcPartitionBurnerWorker.getMonitor().println("runMakeZipThread Compress file Abnormal, error information : " + e.getMessage());
                    }
                    catch (ReceiveTimeOutException e) {
                        isCreate = false;
                        EmmcPartitionBurnerWorker.getMonitor().println("runMakeZipThread Run Compress file Abnormal, error information :" + e.getMessage());
                    }
                    catch (NullPointerException nullPointerException) {
                        isCreate = false;
                        EmmcPartitionBurnerWorker.getMonitor().println("runMakeZipThread Run Compress file Abnormal, error information :" + nullPointerException.getMessage());
                    }
                    if (!isCreate) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.FASTBOOT_ERROR_Title, (String)Messages.MESSAGE_CREATETMEP_ERROR);
                            }
                        });
                        return;
                    }
                }
            }.start();
        }
    }

    private boolean createMBR(IProgressMonitor uiMonitor, List<PartitionItem> parts, int emmcType, boolean createPartitionTable) throws IOException, ReceiveTimeOutException {
        boolean needMBR;
        boolean bl = needMBR = emmcType == PartitionBurnerWorker.EMMC_TYPE_E.EMMC_HAVE_MBR_TYPE.ordinal() && createPartitionTable;
        if (needMBR) {
            uiMonitor.setTaskName("Creating Partition Table");
            if (!this.createPartitionTables(parts)) {
                EmmcPartitionBurnerWorker.returnError("Failed to create partition tables!");
                return false;
            }
            uiMonitor.worked(50);
        }
        return true;
    }

    protected boolean getTempDivisionSize(long ddrFreeSize) {
        long preferemcesSplitFileSize = 0L;
        preferemcesSplitFileSize = ToolUtils.isCmdLine() ? (long)PreferenceConfig.getTftpSplitFileSize() * 1024L * 1024L : ToolUtils.getTftpSplitFileSize();
        String ddrInitSize = this.getHexStartAddress();
        if (ddrInitSize.startsWith("0x")) {
            ddrInitSize = ddrInitSize.substring(ddrInitSize.indexOf("0x") + "0x".length());
        }
        if (ddrFreeSize == 0L) {
            EmmcPartitionBurnerWorker.setTempFileDivisionSize(preferemcesSplitFileSize);
            return false;
        }
        if (ddrFreeSize / 2L > 0x2000000L) {
            EmmcPartitionBurnerWorker.setTempFileDivisionSize((ddrFreeSize - Long.parseLong(ddrInitSize, 16)) / 2L);
            return true;
        }
        if (ddrFreeSize / 2L < 0x2000000L) {
            EmmcPartitionBurnerWorker.setTempFileDivisionSize(ddrFreeSize);
            return false;
        }
        EmmcPartitionBurnerWorker.setTempFileDivisionSize(0x2000000L);
        return false;
    }

    protected boolean burnbootByUSBNoneNudeForEmmc(int emmcType, PartitionItem fastboot, TransferWay transferWay) throws IOException, ReceiveTimeOutException {
        boolean result = false;
        if (FastbootView.isCJ309V100_CA_N_Series()) {
            boolean openUsbResult = CallLibUSBWorker.openUsb(this.uimonitor, 30000L, transferWay, BurnConfig.getUsbSerialNumber());
            if (!openUsbResult) {
                EmmcPartitionBurnerWorker.returnError("Failed to open usb!");
                this.infoln("Failed to open usb!");
                return false;
            }
        } else {
            result = this.bootromByNonNude(this.uimonitor);
            if (!result) {
                return false;
            }
        }
        if (fastboot.isChecked()) {
            SubMonitor subProgressMonitor = SubMonitor.convert((IProgressMonitor)this.uimonitor, (String)"", (int)50);
            EmmcPartitionBurnerWorker.getMonitor().highlight(fastboot);
            if (subProgressMonitor != null) {
                subProgressMonitor.beginTask("Burning " + fastboot.getName(), 100);
                subProgressMonitor.setTaskName("Downloading Boot");
            }
            File file = fastboot.getFile();
            long blockSize = 512L;
            this.getDdrFreeBaseAddr(transferWay);
            if (file != null) {
                long fileSize = file.length();
                long emmcWriteSize = (fileSize + blockSize - 1L) / blockSize;
                result = this.downloadBootByUSB(this.uimonitor, file, transferWay);
                if (!result) {
                    return false;
                }
                if (!this.bootBurn(SubMonitor.convert((IProgressMonitor)this.uimonitor, (String)"", (int)15), fastboot.getFlashType(), Long.toHexString(fastboot.getStart()), Long.toHexString(emmcWriteSize), fastboot.getChipID())) {
                    EmmcPartitionBurnerWorker.returnError("Failed to burn fastboot!");
                    return false;
                }
            } else {
                MWCommand memsetCommand;
                long partitionLen = fastboot.getLength();
                long emmcWriteSize = (partitionLen + blockSize - 1L) / blockSize;
                long writeSize = emmcWriteSize * 512L;
                if (fastboot.getFlashType() == FlashType.ufs) {
                    writeSize = emmcWriteSize * 4096L;
                }
                if (!(result = this.sendCommand(memsetCommand = MWCommand.mwAddress(this.getHexStartAddress(), Long.toHexString(writeSize))))) {
                    EmmcPartitionBurnerWorker.returnError("Failed to burn fastboot!");
                    return false;
                }
                long bootStart = 0L;
                if (this.burner.getBurnContext().getPlatformType() == PlatformType.NonCA) {
                    if (emmcType != 2) {
                        bootStart = 512L;
                    }
                } else if (emmcType == 3) {
                    bootStart = 512L;
                }
                if (!this.bootBurn(SubMonitor.convert((IProgressMonitor)this.uimonitor, (String)"", (int)15), fastboot.getFlashType(), Long.toHexString(fastboot.getStart()), Long.toHexString(emmcWriteSize -= bootStart), fastboot.getChipID())) {
                    EmmcPartitionBurnerWorker.returnError("Failed to burn fastboot!");
                    return false;
                }
            }
            if (file != null) {
                this.infoln("Fastboot burn successfully!");
            } else {
                this.infoln("Fastboot erase successfully!");
            }
        }
        return true;
    }

    private boolean bootProcess(SubMonitor subProgressMonitor, PartitionItem fastboot, List<PartitionItem> parts) throws IOException, ReceiveTimeOutException {
        if (fastboot.isChecked()) {
            EmmcPartitionBurnerWorker.getMonitor().highlight(fastboot);
            if (subProgressMonitor != null) {
                subProgressMonitor.beginTask("Burning " + fastboot.getName(), 100);
                subProgressMonitor.setTaskName("Downloading Boot");
            }
            File file = fastboot.getFile();
            long blockSize = 512L;
            if (file != null) {
                long fileSize = file.length();
                long emmcWriteSize = (fileSize + blockSize - 1L) / blockSize;
                if (((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) {
                    if (!this.programmerDownload(SubMonitor.convert((IProgressMonitor)subProgressMonitor, (String)"", (int)75), fastboot.getFile().getPath(), ((AbstractBurner)((Object)this.burner)).getProgrammerFile(), parts)) {
                        EmmcPartitionBurnerWorker.returnError("Failed to download fastboot!");
                        return false;
                    }
                } else if (this.burner.getBurnContext().getPlatformType() == PlatformType.NonCA) {
                    if (!this.bootDownload(SubMonitor.convert((IProgressMonitor)subProgressMonitor, (String)"", (int)75), fastboot.getFile().getPath())) {
                        EmmcPartitionBurnerWorker.returnError("Failed to download fastboot!");
                        return false;
                    }
                } else if (!this.programmerDownload(SubMonitor.convert((IProgressMonitor)subProgressMonitor, (String)"", (int)75), fastboot.getFile().getPath(), ((AbstractBurner)((Object)this.burner)).getProgrammerFile(), parts)) {
                    EmmcPartitionBurnerWorker.returnError("Failed to download fastboot!");
                    return false;
                }
                this.uimonitor.setTaskName("Check SBL");
                boolean result = this.burnSBL((IProgressMonitor)subProgressMonitor, parts, ((AbstractBurner)((Object)this.burner)).getProgrammerFile());
                if (!result) {
                    return result;
                }
                if (!this.bootBurn(SubMonitor.convert((IProgressMonitor)subProgressMonitor, (String)"", (int)15), fastboot.getFlashType(), Long.toHexString(fastboot.getStart()), Long.toHexString(emmcWriteSize), fastboot.getChipID())) {
                    EmmcPartitionBurnerWorker.returnError("Failed to burn fastboot!");
                    return false;
                }
            } else {
                MWCommand memsetCommand;
                Boolean result;
                long partitionLen = fastboot.getLength();
                long emmcWriteSize = (partitionLen + blockSize - 1L) / blockSize;
                if (((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) {
                    if (!this.programmerDownload(SubMonitor.convert((IProgressMonitor)subProgressMonitor, (String)"", (int)75), null, ((AbstractBurner)((Object)this.burner)).getProgrammerFile(), parts)) {
                        EmmcPartitionBurnerWorker.returnError("Failed to download fastboot!");
                        return false;
                    }
                } else if (this.burner.getBurnContext().getPlatformType() == PlatformType.NonCA) {
                    if (!this.bootDownload(null)) {
                        EmmcPartitionBurnerWorker.returnError("Failed to download fastboot! ");
                        return false;
                    }
                } else if (!this.programmerDownload(null, ((AbstractBurner)((Object)this.burner)).getProgrammerFile())) {
                    EmmcPartitionBurnerWorker.returnError("Failed to download fastboot! ");
                    return false;
                }
                long writeSize = emmcWriteSize * 512L;
                if (fastboot.getFlashType() == FlashType.ufs) {
                    writeSize = emmcWriteSize * 4096L;
                }
                if (!(result = Boolean.valueOf(this.sendCommand(memsetCommand = MWCommand.mwAddress(this.getHexStartAddress(), Long.toHexString(writeSize))))).booleanValue()) {
                    EmmcPartitionBurnerWorker.returnError("Failed to burn fastboot!");
                    return false;
                }
                int emmcType = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getEmmcType();
                long bootStart = 0L;
                if (this.burner.getBurnContext().getPlatformType() == PlatformType.NonCA) {
                    if (emmcType != 2) {
                        bootStart = 512L;
                    }
                } else if (emmcType == 3) {
                    bootStart = 512L;
                }
                if (!this.bootBurn(SubMonitor.convert((IProgressMonitor)subProgressMonitor, (String)"", (int)15), fastboot.getFlashType(), Long.toHexString(fastboot.getStart()), Long.toHexString(emmcWriteSize -= bootStart), fastboot.getChipID())) {
                    EmmcPartitionBurnerWorker.returnError("Failed to burn fastboot!");
                    return false;
                }
            }
            if (file != null) {
                this.infoln("Fastboot burnt successfully!");
            } else {
                this.infoln("Fastboot erase successfully!");
            }
        } else if (((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) {
            if (!this.programmerDownload(SubMonitor.convert((IProgressMonitor)subProgressMonitor, (String)"", (int)75), null, ((AbstractBurner)((Object)this.burner)).getProgrammerFile(), parts)) {
                EmmcPartitionBurnerWorker.returnError("Failed to download fastboot!");
                return false;
            }
        } else if (this.burner.getBurnContext().getPlatformType() == PlatformType.NonCA) {
            if (!this.bootDownload(null)) {
                EmmcPartitionBurnerWorker.returnError("Failed to download fastboot! Please reset the board, try again.");
                return false;
            }
        } else if (!this.programmerDownload(null, ((AbstractBurner)((Object)this.burner)).getProgrammerFile())) {
            EmmcPartitionBurnerWorker.returnError("Failed to download fastboot! Please reset the board, try again.");
            return false;
        }
        return true;
    }

    private boolean burnFile(IProgressMonitor uiMonitor, FileSystem fileSystem, long partitionLen, long partCount, File file, long burnFileSize, long ulBurnLenBlockCount, FlashType flashType, long tempFileDivisionSize, String partitionName, ChipID chipID) throws IOException, ReceiveTimeOutException {
        boolean result = false;
        uiMonitor.worked(10);
        if (this.useCompress && file != null) {
            if (burnFileSize > 0x2000000L) {
                PartitionTempObj partitionTempObj;
                int index;
                uiMonitor.subTask("Burning " + file.getName());
                uiMonitor.setTaskName("Compress " + file.getName());
                this.waitZipTimeLogger.logStart(file.getName(), file.length());
                while (this.largeFileTogetherThread.getPartitionTempObjList().size() == 0) {
                    block21: {
                        block20: {
                            try {
                                if (!uiMonitor.isCanceled()) break block20;
                                return false;
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (this.checkComFileForFreeSpace(file)) break block21;
                        return false;
                    }
                    Thread.sleep(100L);
                }
                boolean isReadyzipFile = false;
                while (!isReadyzipFile) {
                    block23: {
                        block22: {
                            try {
                                index = 0;
                                while (index < this.largeFileTogetherThread.getPartitionTempObjList().size()) {
                                    partitionTempObj = this.largeFileTogetherThread.getPartitionTempObjList().get(index);
                                    String name = partitionTempObj.getPartitionName();
                                    if (name != null && name.equals(partitionName)) {
                                        isReadyzipFile = true;
                                        break;
                                    }
                                    ++index;
                                }
                                if (isReadyzipFile) continue;
                                if (!uiMonitor.isCanceled()) break block22;
                                return false;
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (this.checkComFileForFreeSpace(file)) break block23;
                        return false;
                    }
                    Thread.sleep(50L);
                }
                this.waitZipTimeLogger.logEnd();
                index = 0;
                while (index < this.largeFileTogetherThread.getPartitionTempObjList().size()) {
                    partitionTempObj = this.largeFileTogetherThread.getPartitionTempObjList().get(index);
                    if (partitionTempObj.getPartitionName().equals(partitionName) && !(result = this.burnCompressPartition(SubMonitor.convert((IProgressMonitor)uiMonitor, (String)"", (int)100), partitionTempObj, fileSystem, partCount, file, partitionLen, flashType))) {
                        return false;
                    }
                    ++index;
                }
            } else {
                result = this.burnSmallFile(SubMonitor.convert((IProgressMonitor)uiMonitor, (String)"", (int)100), file, fileSystem, flashType, partCount, partitionLen, ulBurnLenBlockCount, chipID);
                if (!result) {
                    return false;
                }
            }
        } else {
            result = burnFileSize > tempFileDivisionSize ? this.burnLargeFile(SubMonitor.convert((IProgressMonitor)uiMonitor, (String)"", (int)100), file, fileSystem, flashType, tempFileDivisionSize, partCount, partitionLen, ulBurnLenBlockCount, chipID) : this.burnSmallFile(SubMonitor.convert((IProgressMonitor)uiMonitor, (String)"", (int)100), file, fileSystem, flashType, partCount, partitionLen, ulBurnLenBlockCount, chipID);
            if (!result) {
                return false;
            }
        }
        return result;
    }

    private boolean burnCompressPartition(SubMonitor subProgressMonitor, PartitionTempObj partitionTempObj, FileSystem fileSystem, long address, File file, long partitionLen, FlashType flashType) throws IOException, ReceiveTimeOutException {
        boolean result = true;
        this.waitZipTimeLogger.logStart(file.getName(), file.length());
        while (partitionTempObj.getTempFileInfoList().size() == 0) {
            block7: {
                block6: {
                    try {
                        if (!subProgressMonitor.isCanceled()) break block6;
                        return false;
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.checkComFileForFreeSpace(file)) break block7;
                return false;
            }
            Thread.sleep(50L);
        }
        this.waitZipTimeLogger.logEnd();
        boolean erasePart = this.erasePart(subProgressMonitor, address, partitionLen, flashType);
        if (!erasePart) {
            this.infoln("Failed to earse part file(" + file.getPath() + ").");
            return false;
        }
        result = this.burnSinglePartZipFile(subProgressMonitor, fileSystem, address, result, partitionTempObj, file, partitionLen, flashType);
        return result;
    }

    protected boolean burnSinglePartZipFile(SubMonitor subProgressMonitor, FileSystem fileSystem, long address, boolean result, PartitionTempObj partitionTempObj, File file, long partitionLen, FlashType flashType) throws IOException, ReceiveTimeOutException, FileNotFoundException {
        if (subProgressMonitor == null) {
            return false;
        }
        int totalTempCount = partitionTempObj.getTotalTempCount();
        List<TempFileInfo> tempFileInfoList = partitionTempObj.getTempFileInfoList();
        if (ToolUtils.isDebugOn()) {
            EmmcPartitionBurnerWorker.getMonitor().println(this.waitZipTimeLogger.exportLog(String.valueOf(partitionTempObj.getPartitionName()) + " Before Burning TotalTempCount : " + totalTempCount));
            EmmcPartitionBurnerWorker.getMonitor().println(this.waitZipTimeLogger.exportLog(String.valueOf(partitionTempObj.getPartitionName()) + " Before Burning TempFileInfoList : " + tempFileInfoList.size()));
        }
        int i = 0;
        while (i < tempFileInfoList.size()) {
            TempFileInfo tempFileInfo = tempFileInfoList.get(i);
            if (!tempFileInfo.isBurnState()) {
                File zipTempFile = tempFileInfo.getZipTempFile();
                if (zipTempFile != null) {
                    subProgressMonitor.beginTask("Download " + zipTempFile.getName(), 100 * tempFileInfoList.size());
                    long tempFileBurnNeedSize = tempFileInfo.getTempFileBurnNeedSize();
                    long startAddressOffset = tempFileInfo.getStartAddressOffset();
                    long burnFileSize = tempFileBurnNeedSize / 512L * 512L;
                    if (tempFileBurnNeedSize % 512L != 0L) {
                        burnFileSize += 512L;
                    }
                    long burnLenSector = burnFileSize / 512L;
                    XmodelParameter xmodelPar = new XmodelParameter(zipTempFile.length(), 0L);
                    boolean falg = this.downloadFileByTrans(subProgressMonitor, result, xmodelPar, zipTempFile, 50);
                    if (!falg) {
                        return falg;
                    }
                    if (this.unZipTimeLogger != null) {
                        this.unZipTimeLogger.logStart(zipTempFile.getName(), zipTempFile.length());
                    }
                    String unzipAddr = Long.toHexString(tempFileDivisionSize + (long)this.getHexStartAddressForInt());
                    subProgressMonitor.setTaskName("Unzip " + zipTempFile.getName());
                    UnZipCommand unZipCommand = UnZipCommand.unzip(this.getHexStartAddress(), unzipAddr);
                    falg = this.sendCommand(unZipCommand.toString(), unZipCommand.calculateTimeOut(Long.toHexString(tempFileDivisionSize)));
                    subProgressMonitor.worked(20);
                    if (this.unZipTimeLogger != null) {
                        this.unZipTimeLogger.logEnd();
                    }
                    if (!falg) {
                        return false;
                    }
                    if (result) {
                        boolean isSparse = (fileSystem == FileSystem.ext3 || fileSystem == FileSystem.f2fs || fileSystem == FileSystem.erofs) && SparseFileAgent.isAndroidSparseFile(file);
                        WriteCommand mmcCommand = null;
                        mmcCommand = isSparse ? WriteCommand.writeeMMCSP(flashType, unzipAddr, Long.toHexString(address + startAddressOffset / 512L), Long.toHexString(burnLenSector)) : WriteCommand.writeeMMC(flashType, unzipAddr, Long.toHexString(address + startAddressOffset / 512L), Long.toHexString(burnLenSector));
                        if (this.burnTimeLogger != null) {
                            this.burnTimeLogger.logStart(zipTempFile.getName(), burnLenSector);
                        }
                        subProgressMonitor.setTaskName("Write " + zipTempFile.getName());
                        if (mmcCommand == null) {
                            return false;
                        }
                        result = this.sendCommand(mmcCommand);
                        subProgressMonitor.worked(30);
                        if (this.burnTimeLogger != null) {
                            this.burnTimeLogger.logEnd();
                        }
                        tempFileInfo.setBurnState(true);
                        FileUtils.deleteFile(zipTempFile);
                        if (!result) {
                            return false;
                        }
                    }
                }
                if (ToolUtils.isDebugOn()) {
                    EmmcPartitionBurnerWorker.getMonitor().println(this.waitZipTimeLogger.exportLog(String.valueOf(partitionTempObj.getPartitionName()) + " Burning tempFileInfo index :" + i));
                    EmmcPartitionBurnerWorker.getMonitor().println(this.waitZipTimeLogger.exportLog(String.valueOf(partitionTempObj.getPartitionName()) + " Burning TempFileInfoList :" + tempFileInfoList.size()));
                }
            }
            ++i;
        }
        if (partitionTempObj.getTempFileInfoList().size() == totalTempCount) {
            int burnAllTempNum = 0;
            int i2 = 0;
            while (i2 < partitionTempObj.getTempFileInfoList().size()) {
                TempFileInfo tempFileInfo = partitionTempObj.getTempFileInfoList().get(i2);
                if (tempFileInfo.isBurnState()) {
                    ++burnAllTempNum;
                }
                ++i2;
            }
            if (burnAllTempNum == totalTempCount) {
                result = true;
            } else {
                block34: {
                    block33: {
                        try {
                            if (!subProgressMonitor.isCanceled()) break block33;
                            return false;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.checkComFileForFreeSpace(file)) break block34;
                    return false;
                }
                Thread.sleep(100L);
                result = this.burnSinglePartZipFile(subProgressMonitor, fileSystem, address, result, partitionTempObj, file, partitionLen, flashType);
            }
        } else {
            block36: {
                block35: {
                    if (ToolUtils.isDebugOn()) {
                        EmmcPartitionBurnerWorker.getMonitor().println(this.waitZipTimeLogger.exportLog(String.valueOf(partitionTempObj.getPartitionName()) + " TotalTempCount : " + totalTempCount));
                        EmmcPartitionBurnerWorker.getMonitor().println(this.waitZipTimeLogger.exportLog(String.valueOf(partitionTempObj.getPartitionName()) + " TempFileInfoList : " + tempFileInfoList.size()));
                    }
                    if (!subProgressMonitor.isCanceled()) break block35;
                    return false;
                }
                if (this.checkComFileForFreeSpace(file)) break block36;
                return false;
            }
            try {
                Thread.sleep(500L);
                result = this.burnSinglePartZipFile(subProgressMonitor, fileSystem, address, result, partitionTempObj, file, partitionLen, flashType);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {}
        }
        if (ToolUtils.isDebugOn()) {
            EmmcPartitionBurnerWorker.getMonitor().println(this.waitZipTimeLogger.exportLog(String.valueOf(partitionTempObj.getPartitionName()) + " After Burning TotalTempCount : " + totalTempCount));
            EmmcPartitionBurnerWorker.getMonitor().println(this.waitZipTimeLogger.exportLog(String.valueOf(partitionTempObj.getPartitionName()) + " After Burning TempFileInfoList : " + tempFileInfoList.size()));
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean burnLargeFile(SubMonitor subProgressMonitor, File file, FileSystem fileSystem, FlashType flashType, long filePartSize, long address, long eraseLength, long totalLengthToBurn, ChipID chipID) throws IOException, ReceiveTimeOutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 48[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long handleChunkData(BufferedRandomAccessFile inFile, BufferedRandomAccessFile outFile, long readLength, int chunkLen) throws IOException {
        int chunkDataSpaceCount = (chunkLen + 0x500000 - 1) / 0x500000;
        int chunkDataSpaceSpace = chunkLen % 0x500000;
        byte[] chunkData = new byte[0x500000];
        int j = 0;
        while (j < chunkDataSpaceCount) {
            int len = j == chunkDataSpaceCount - 1 ? (chunkDataSpaceSpace == 0 ? 0x500000 : chunkDataSpaceSpace) : 0x500000;
            int read = inFile.read(chunkData, 0, len);
            if (read != len) {
                return readLength;
            }
            readLength += (long)len;
            outFile.write(chunkData, 0, len);
            ++j;
        }
        return readLength;
    }

    @Override
    protected boolean burnSmallFile(SubMonitor subProgressMonitor, File file, FileSystem fileSystem, FlashType flashType, long address, long eraseLength, long writeLength, ChipID chipID) throws IOException, ReceiveTimeOutException {
        try {
            if (subProgressMonitor == null) {
                return false;
            }
            boolean result = true;
            if (file != null) {
                MWCommand memsetCommand;
                subProgressMonitor.beginTask("Burning " + file.getName(), 100);
                long writeSize = writeLength * 512L;
                if (flashType == FlashType.ufs) {
                    writeSize = writeLength * 4096L;
                }
                if (!(result = this.sendCommand(memsetCommand = MWCommand.mwAddress(this.getHexStartAddress(), Long.toHexString(writeSize))))) {
                    boolean bl = result;
                    return bl;
                }
                subProgressMonitor.worked(10);
                boolean erasePart = this.erasePart(subProgressMonitor, address, eraseLength, flashType);
                if (!erasePart) {
                    this.infoln("Failed to earse part file(" + file.getPath() + ").");
                    return false;
                }
                XmodelParameter xmodelPar = new XmodelParameter(file.length(), 0L);
                if (!(result = this.downloadFileByTrans(subProgressMonitor, result, xmodelPar, file, 50))) {
                    boolean bl = result;
                    return bl;
                }
                if (result) {
                    boolean isSparse = (fileSystem == FileSystem.ext3 || fileSystem == FileSystem.f2fs || fileSystem == FileSystem.erofs) && SparseFileAgent.isAndroidSparseFile(file);
                    WriteCommand writeCommand = null;
                    if (isSparse) {
                        try (BufferedRandomAccessFile inFile = null;){
                            inFile = new BufferedRandomAccessFile(file, "r");
                            byte[] sparseHeaderData = new byte[28];
                            inFile.seek(0L);
                            int read = inFile.read(sparseHeaderData);
                            if (read != sparseHeaderData.length) {
                                return false;
                            }
                            SparseHeader sparseHeader = new SparseHeader();
                            sparseHeader.fromBytes(sparseHeaderData);
                            writeCommand = WriteCommand.writeeMMCSP(flashType, this.getHexStartAddress(), Long.toHexString(address), Long.toHexString((long)sparseHeader.blk_sz * sparseHeader.total_blks / 512L));
                        }
                    } else {
                        writeCommand = WriteCommand.writeeMMC(flashType, this.getHexStartAddress(), Long.toHexString(address), Long.toHexString(writeLength));
                    }
                    this.burnTimeLogger.logStart(file.getName(), writeLength);
                    if (writeCommand == null) {
                        return false;
                    }
                    result = this.sendCommand(writeCommand);
                    this.burnTimeLogger.logEnd();
                    if (!result) {
                        return false;
                    }
                }
            } else {
                subProgressMonitor.beginTask("Erasing ", 100);
                long totalLength = eraseLength;
                long count = totalLength / 0x2000000L;
                totalLength = totalLength % 512L != 0L ? totalLength / 512L + 1L : (totalLength /= 512L);
                long partLength = 0x2000000L;
                partLength /= 512L;
                block18: while (totalLength > 0L) {
                    MWCommand memsetCommand;
                    if (subProgressMonitor.isCanceled()) break;
                    if (totalLength >= 65536L) {
                        memsetCommand = MWCommand.mwAddress(this.getHexStartAddress(), Long.toHexString(partLength * 512L));
                        result = this.sendCommand(memsetCommand);
                        subProgressMonitor.worked(5);
                        if (!result) {
                            return false;
                        }
                        int i = 0;
                        while ((long)i < count) {
                            if (subProgressMonitor.isCanceled()) continue block18;
                            WriteCommand burnCommand = WriteCommand.writeeMMC(flashType, this.getHexStartAddress(), Long.toHexString(address), Long.toHexString(partLength));
                            result = this.sendCommand(burnCommand);
                            if (!result) {
                                return false;
                            }
                            address += partLength;
                            subProgressMonitor.worked(10);
                            totalLength -= partLength;
                            ++i;
                        }
                        continue;
                    }
                    memsetCommand = MWCommand.mwAddress(this.getHexStartAddress(), Long.toHexString(totalLength * 512L));
                    result = this.sendCommand(memsetCommand);
                    subProgressMonitor.worked(5);
                    if (!result) {
                        return false;
                    }
                    WriteCommand burnCommand = WriteCommand.writeeMMC(flashType, this.getHexStartAddress(), Long.toHexString(address), Long.toHexString(totalLength));
                    result = this.sendCommand(burnCommand);
                    if (!result) {
                        return false;
                    }
                    address += totalLength;
                    subProgressMonitor.worked(10);
                    totalLength = 0L;
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (subProgressMonitor != null) {
                subProgressMonitor.done();
            }
        }
    }

    @Override
    public boolean erase(IProgressMonitor uiMonitor, List<PartitionItem> parts) throws IOException, ReceiveTimeOutException {
        ToolStatistics.INSTANCE.logUsage("BurnTool", "Erase Emmc", "ChipName: " + this.burner.getBurnContext().getDeviceSetting().getName());
        ToolStatistics.INSTANCE.logToolInUse("BurnTool");
        String versionInfo = this.getVersionInfo("Erase Emmc");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        this.setProgressMonitor(uiMonitor);
        this.eraseTimeLogger = new TimeLogger();
        long eraseStartTime = 0L;
        eraseStartTime = System.currentTimeMillis();
        boolean bRet = true;
        uiMonitor.setTaskName("Init Board");
        PartitionItem fastboot = parts.get(0);
        FlashType flashType = FlashType.emmc;
        if (fastboot != null) {
            flashType = fastboot.getFlashType();
        }
        if (this.getBurner().getBurnContext().getTransferWay() == TransferWay.USBNonNude ? !(bRet = this.bootromByNonNude(this.uimonitor)) : !(bRet = this.prepareToBurn(false, EventType.ERASE, null))) {
            return false;
        }
        uiMonitor.setTaskName("Erase Partitions");
        long neMMCCapacity = this.geteMMCSpaceSize(flashType);
        if (0L == neMMCCapacity) {
            EmmcPartitionBurnerWorker.warningln("Failed to get eMMC capacity!");
            return false;
        }
        long erasePartitionLen = neMMCCapacity / 512L * 512L;
        if (erasePartitionLen % 512L != 0L) {
            erasePartitionLen += 512L;
        }
        int length = 0x8000000;
        UDProperties properties = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getProperties();
        String boardType = properties.queryForString("TYPE");
        if (boardType != null && boardType.equalsIgnoreCase("CAM")) {
            length = 0x2000000;
        }
        long count = erasePartitionLen / (long)length;
        long eraseLenSector = erasePartitionLen / 512L;
        uiMonitor.beginTask("", (int)(count * 10L) + 20);
        if (FastbootPreferences.isDiskFormatting()) {
            bRet = this.sendCommand(EraseCommand.eraseEmmc(Long.toHexString(0L), Long.toHexString(eraseLenSector), Long.toHexString(neMMCCapacity)));
        } else {
            long partLength = length;
            partLength /= 512L;
            String fillData = null;
            if (ToolUtils.isCmdLine()) {
                fillData = String.valueOf(PreferenceConfig.getImgFillData());
            } else {
                IPreferenceStore preferences = FastbootPreferences.getPreferenceStore();
                fillData = preferences.getString("vendor.burn.config.imageFill");
            }
            long address = 0L;
            block0: while (eraseLenSector > 0L) {
                MWCommand memsetCommand;
                if (uiMonitor.isCanceled()) break;
                if (eraseLenSector >= (long)(length / 512)) {
                    memsetCommand = null;
                    if (fillData.equals("0xFF")) {
                        long writeSize = partLength * 512L;
                        if (flashType == FlashType.ufs) {
                            writeSize = partLength * 4096L;
                        }
                        memsetCommand = MWCommand.mwAddress(this.getHexStartAddress(), Long.toHexString(writeSize));
                    } else {
                        memsetCommand = MWCommand.mwAddress(this.getHexStartAddress(), Long.toHexString(partLength * 512L));
                    }
                    bRet = this.sendCommand(memsetCommand);
                    uiMonitor.worked(5);
                    int i = 0;
                    while ((long)i < count) {
                        if (uiMonitor.isCanceled()) continue block0;
                        WriteCommand burnCommand = WriteCommand.writeeMMC(flashType, this.getHexStartAddress(), Long.toHexString(address), Long.toHexString(partLength));
                        bRet = this.sendCommand(burnCommand);
                        address += partLength;
                        uiMonitor.worked(10);
                        eraseLenSector -= partLength;
                        ++i;
                    }
                    continue;
                }
                memsetCommand = MWCommand.mwAddress(this.getHexStartAddress(), Long.toHexString(eraseLenSector * 512L));
                bRet = this.sendCommand(memsetCommand);
                uiMonitor.worked(5);
                WriteCommand burnCommand = WriteCommand.writeeMMC(flashType, this.getHexStartAddress(), Long.toHexString(address), Long.toHexString(eraseLenSector));
                bRet &= this.sendCommand(burnCommand);
                address += eraseLenSector;
                uiMonitor.worked(10);
                eraseLenSector = 0L;
            }
        }
        this.sendResetCommand();
        if (!bRet) {
            EmmcPartitionBurnerWorker.returnError("Failed to erase all devices!");
            return false;
        }
        this.infoln("All devices erased successfully!");
        long eraseTotalTime = System.currentTimeMillis() - eraseStartTime;
        String eraseTotalTimeStr = this.calculateBurnTotalTime(eraseTotalTime);
        if (ToolUtils.isDebugOn()) {
            EmmcPartitionBurnerWorker.getMonitor().println(this.eraseTimeLogger.exportLog("erase Command Execution"));
        }
        this.infoln("The images are erased successfully, which took " + eraseTotalTimeStr + "!");
        uiMonitor.worked(100);
        return bRet;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean upload(IProgressMonitor uiMonitor, List<PartitionItem> parts) throws IOException, ReceiveTimeOutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 56[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean erasePart(SubMonitor subProgressMonitor, long address, long eraseLength, FlashType flashType) throws IOException, ReceiveTimeOutException {
        boolean bRet = true;
        boolean isEmmcEraseBeforeBurn = false;
        isEmmcEraseBeforeBurn = ToolUtils.isCmdLine() ? PreferenceConfig.isCmdEraseBeforeBurn() : FastbootPreferences.isEmmcEraseBeforeBurn();
        if (isEmmcEraseBeforeBurn) {
            long erasePartitionLen;
            int length = 0x8000000;
            UDProperties properties = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getProperties();
            String boardType = properties.queryForString("TYPE");
            if (boardType != null && boardType.equalsIgnoreCase("CAM")) {
                length = 0x2000000;
            }
            if ((erasePartitionLen = eraseLength / 512L * 512L) % 512L != 0L) {
                erasePartitionLen += 512L;
            }
            long count = erasePartitionLen / (long)length;
            long eraseLenSector = erasePartitionLen / 512L;
            long partLength = length;
            partLength /= 512L;
            String fillData = null;
            if (ToolUtils.isCmdLine()) {
                fillData = String.valueOf(PreferenceConfig.getImgFillData());
            } else {
                IPreferenceStore preferences = FastbootPreferences.getPreferenceStore();
                fillData = preferences.getString("vendor.burn.config.imageFill");
            }
            block0: while (eraseLenSector > 0L) {
                MWCommand memsetCommand;
                if (subProgressMonitor.isCanceled()) break;
                if (eraseLenSector >= (long)(length / 512)) {
                    memsetCommand = null;
                    if (fillData.equals("0xFF")) {
                        long writeSize = partLength * 512L;
                        if (flashType == FlashType.ufs) {
                            writeSize = partLength * 4096L;
                        }
                        memsetCommand = MWCommand.mwAddress(this.getHexStartAddress(), Long.toHexString(writeSize));
                    } else {
                        memsetCommand = MWCommand.mwAddress(this.getHexStartAddress(), Long.toHexString(partLength * 512L));
                    }
                    bRet = this.sendCommand(memsetCommand);
                    if (!bRet) {
                        return false;
                    }
                    int i = 0;
                    while ((long)i < count) {
                        if (subProgressMonitor.isCanceled()) continue block0;
                        WriteCommand burnCommand = WriteCommand.writeeMMC(flashType, this.getHexStartAddress(), Long.toHexString(address), Long.toHexString(partLength));
                        bRet = this.sendCommand(burnCommand);
                        address += partLength;
                        eraseLenSector -= partLength;
                        ++i;
                    }
                    continue;
                }
                memsetCommand = MWCommand.mwAddress(this.getHexStartAddress(), Long.toHexString(eraseLenSector * 512L));
                bRet = this.sendCommand(memsetCommand);
                if (!bRet) {
                    return false;
                }
                WriteCommand burnCommand = WriteCommand.writeeMMC(flashType, this.getHexStartAddress(), Long.toHexString(address), Long.toHexString(eraseLenSector));
                bRet = this.sendCommand(burnCommand);
                if (!bRet) {
                    return false;
                }
                address += eraseLenSector;
                eraseLenSector = 0L;
            }
        }
        return bRet;
    }

    private boolean burnPartitionInfo(boolean result, String partitionName, File file) {
        if (result) {
            if (file != null) {
                this.infoln("Partition " + partitionName + " burned successfully!");
            } else {
                this.infoln("Partition " + partitionName + " Erased successfully!");
            }
        } else {
            if (file != null) {
                EmmcPartitionBurnerWorker.returnError("Failed to Burn " + partitionName + " Partition!");
            } else {
                EmmcPartitionBurnerWorker.returnError("Failed to Erase " + partitionName + " Partition!");
            }
            return false;
        }
        return true;
    }

    private boolean validFile(String partitionName, File file) {
        boolean validFile;
        boolean bl = validFile = file != null && file.exists();
        if (!validFile) {
            EmmcPartitionBurnerWorker.returnError("File can't be find in partition " + partitionName);
            return false;
        }
        if (file.isDirectory()) {
            EmmcPartitionBurnerWorker.returnError("The selected file is a directrory in partition of " + partitionName);
            validFile = false;
        }
        return validFile;
    }

    private boolean checkComFileForFreeSpace(File file) {
        String toolPath = ToolUtils.getInstallPath();
        String directoryPath = toolPath;
        if (!FileUtils.checkFreeSpace(directoryPath, file.length())) {
            EmmcPartitionBurnerWorker.returnError(NLS.bind((String)Messages.ERROR_INFO_DISK_SPACE_LOW, (Object)(String.valueOf(directoryPath) + File.separator + file.getName())));
            return false;
        }
        return true;
    }

    private long getLastPartitionLen(int emmcType, int nExtFormatCount, PartitionItem partition, long partLength, long partCount) throws IOException, ReceiveTimeOutException {
        long neMMCCapacity = this.geteMMCSpaceSize(partition.getFlashType());
        FlashType flashType = partition.getFlashType();
        String type = "emmc";
        if (flashType == FlashType.ufs) {
            type = "ufs";
        } else if (flashType == FlashType.ssd) {
            type = "ssd";
        }
        if (0L == neMMCCapacity) {
            EmmcPartitionBurnerWorker.warningln("Failed to get " + type + " capacity!");
            return -1L;
        }
        partLength = emmcType == PartitionBurnerWorker.EMMC_TYPE_E.EMMC_HAVE_MBR_TYPE.ordinal() ? neMMCCapacity - partCount * 512L - (long)nExtFormatCount * 512L : neMMCCapacity - partCount * 512L;
        partition.setLength(partLength);
        EmmcPartitionBurnerWorker.warningln("All " + type + " remain space " + partLength + " Bytes allotted to last partition!");
        EmmcPartitionBurnerWorker.deleteContent(serialReceived);
        return partLength;
    }

    @Override
    public File getHome(List<PartitionItem> parts, EventType eventType) {
        File file;
        if (parts.size() == 0) {
            return null;
        }
        for (PartitionItem partitionItem : parts) {
            if (!partitionItem.isChecked() || (file = partitionItem.getFile()) == null) continue;
            if (eventType == EventType.BURN) {
                if (!file.exists() || !file.isFile()) continue;
                return file.getParentFile();
            }
            return file.getParentFile();
        }
        for (PartitionItem partitionItem : parts) {
            file = partitionItem.getFile();
            if (file == null) continue;
            return file.getParentFile();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private boolean createPartitionTables(List<PartitionItem> parts) throws IOException, ReceiveTimeOutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[TRYBLOCK]], but top level block is 28[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean eMMC_SetPartTableItem(SPartitionItem part, long baseAddress, long absoluteAddress, long length) {
        int emmcType = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getEmmcType();
        if (baseAddress % 512L != 0L) {
            EmmcPartitionBurnerWorker.returnError("BaseAddress is not 512's ");
            return false;
        }
        if (absoluteAddress % 512L != 0L) {
            EmmcPartitionBurnerWorker.returnError("absoluteAddress is not 512's ");
            return false;
        }
        if (length % 512L != 0L) {
            EmmcPartitionBurnerWorker.returnError("length is not 512's ");
            return false;
        }
        long baseAddressSector = baseAddress / 512L;
        long absoluteStartSector = absoluteAddress / 512L;
        long absoluteStopSector = (absoluteAddress + length - 1L) / 512L;
        long start = absoluteStartSector;
        long size = absoluteStopSector - absoluteStartSector + 1L;
        start = 131 == part.sys_ind && emmcType == PartitionBurnerWorker.EMMC_TYPE_E.EMMC_HAVE_MBR_TYPE.ordinal() ? 1L : absoluteStartSector - baseAddressSector;
        if (absoluteStartSector / 64L > 1023L) {
            absoluteStartSector = 65535L;
        }
        if (absoluteStopSector / 64L > 1023L) {
            absoluteStopSector = 65535L;
        }
        long nStartSector = absoluteStartSector % 16L + 1L;
        long nStartHead = absoluteStartSector / 16L % 4L;
        long nStartCylinder = absoluteStartSector / 16L / 4L;
        long nStopSector = absoluteStopSector % 16L + 1L;
        long nStopHead = absoluteStopSector / 16L % 4L;
        long nStopCylinder = absoluteStopSector / 16L / 4L;
        part.head = (int)(nStartHead & 0xFFL);
        part.sector = (int)(nStartSector & 0xFFL);
        part.cyl = (int)(nStartCylinder & 0xFFL);
        part.sector = (int)((long)part.sector | nStartCylinder >> 2 & 0xC0L);
        part.end_head = (int)(nStopHead & 0xFFL);
        part.end_sector = (int)(nStopSector & 0xFFL);
        part.end_cyl = (int)(nStopCylinder & 0xFFL);
        part.end_sector = (int)((long)part.end_sector | nStopCylinder >> 2 & 0xC0L);
        part.start4[0] = (int)(start & 0xFFL);
        part.start4[1] = (int)(start >> 8) & 0xFF;
        part.start4[2] = (int)(start >> 16) & 0xFF;
        part.start4[3] = (int)(start >> 24) & 0xFF;
        part.size4[0] = (int)(size & 0xFFL);
        part.size4[1] = (int)(size >> 8) & 0xFF;
        part.size4[2] = (int)(size >> 16) & 0xFF;
        part.size4[3] = (int)(size >> 24) & 0xFF;
        return true;
    }

    /*
     * Exception decompiling
     */
    public boolean createImage(IProgressMonitor uiMonitor, File file, List<PartitionItem> parts, boolean call) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 27[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void emmcWriteToFile(IProgressMonitor uiMonitor, String fillData, int commandType, int emmcType, RandomAccessFile imagefile, File bootFile, long startSector, int i, long fastbootPartionLen, File partfile) throws FileNotFoundException, IOException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)uiMonitor, (String)"", (int)100);
        try (RandomAccessFile bootImage = null;){
            if (emmcType == PartitionBurnerWorker.EMMC_TYPE_E.EMMC_HAVE_MBR_TYPE.ordinal()) {
                if (this.burner.getBurnContext().getPlatformType() == PlatformType.CA || commandType == 0) {
                    if (i == 0) {
                        bootImage = new RandomAccessFile(bootFile, "rw");
                        this.checkDataAndWrite(fillData, bootImage, (int)fastbootPartionLen);
                        this.writeToFile(subMonitor, bootImage, 0L, partfile);
                    } else {
                        this.writeToFile(subMonitor, imagefile, startSector * 512L + 512L, partfile);
                    }
                } else {
                    this.writeToFile(subMonitor, imagefile, startSector * 512L + 512L, partfile);
                }
            } else if (emmcType == PartitionBurnerWorker.EMMC_TYPE_E.EMMC_NO_MBR_TYPE.ordinal()) {
                this.writeToFile(subMonitor, imagefile, startSector * 512L, partfile);
            } else if (emmcType == PartitionBurnerWorker.EMMC_TYPE_E.EMMC_CJ3X1VX12H_TYPE.ordinal()) {
                if (i == 0) {
                    this.writeToFile(subMonitor, imagefile, startSector * 512L + 512L, partfile);
                } else {
                    this.writeToFile(subMonitor, imagefile, startSector * 512L, partfile);
                }
            }
        }
    }

    private long getLastPartitionLen(List<PartitionItem> parts) {
        PartitionItem lastPart = parts.get(parts.size() - 1);
        return lastPart.getStart() + lastPart.getLength();
    }

    public static void setTempFileDivisionSize(long tempFileDivisionSize) {
        EmmcPartitionBurnerWorker.tempFileDivisionSize = tempFileDivisionSize;
    }

    protected void getDdrFreeBaseAddr(TransferWay transferWay) throws IOException, ReceiveTimeOutException {
        String ddrFreeSizeStr = this.getDDRFreeParam();
        long ddrFreeBaseAddr = this.parseLong(this.getDDRFreeParam("baseaddr:", ddrFreeSizeStr, transferWay));
        if (this.frameSetting instanceof UDFrameSetting) {
            UDFrameSetting udFrameSetting = (UDFrameSetting)this.frameSetting;
            udFrameSetting.setDdrInitAddrByLibBootrom(ddrFreeBaseAddr);
        }
    }
}

