/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.serial.workers;

import com.vendor.burn.Messages;
import com.vendor.burn.analysis.TimeLogger;
import com.vendor.burn.commands.CrcCommand;
import com.vendor.burn.commands.EraseCommand;
import com.vendor.burn.commands.I2cCommand;
import com.vendor.burn.commands.INFOCommand;
import com.vendor.burn.commands.MmcPartCommand;
import com.vendor.burn.commands.NetCommand;
import com.vendor.burn.commands.SFCommand;
import com.vendor.burn.commands.SerialCommand;
import com.vendor.burn.commands.TFTPCommand;
import com.vendor.burn.commands.UnZipCommand;
import com.vendor.burn.commands.WriteCommand;
import com.vendor.burn.jna.LibBootromByJNA;
import com.vendor.burn.jna.LibJTAGByJNA;
import com.vendor.burn.model.BoardConfig;
import com.vendor.burn.model.BurnContext;
import com.vendor.burn.model.ChipID;
import com.vendor.burn.model.FlashType;
import com.vendor.burn.model.JTAG_STATUS;
import com.vendor.burn.model.LocalConfig;
import com.vendor.burn.model.PartitionItem;
import com.vendor.burn.model.PlatformType;
import com.vendor.burn.model.TransferWay;
import com.vendor.burn.model.config.BurnConfig;
import com.vendor.burn.model.config.PreferenceConfig;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.define.IChecker;
import com.vendor.burn.model.devices.IAddressBurner;
import com.vendor.burn.model.devices.IBootBurner;
import com.vendor.burn.model.devices.IFrameSetting;
import com.vendor.burn.model.devices.burners.AbstractBurner;
import com.vendor.burn.model.devices.burners.CommonBurner;
import com.vendor.burn.model.devices.unknown.UDFrameSetting;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import com.vendor.burn.model.event.EventType;
import com.vendor.burn.model.event.FastbootEvent;
import com.vendor.burn.model.receive.ReceiveTimeOutException;
import com.vendor.burn.preferences.FastbootPreferences;
import com.vendor.burn.serial.workers.AbstractBurnerWorker;
import com.vendor.burn.serial.workers.CallLibBootromWorker;
import com.vendor.burn.serial.workers.CallLibJTAGWorker;
import com.vendor.burn.serial.workers.CallLibUSBWorker;
import com.vendor.burn.serial.workers.Modem;
import com.vendor.burn.serial.workers.SerialPort;
import com.vendor.burn.serial.workers.WorkerUtility;
import com.vendor.burn.utilitily.FileUtils;
import com.vendor.burn.utilitily.GZipUtils;
import com.vendor.burn.utilitily.PropertiesUtility;
import com.vendor.burn.utilitily.ToolUtils;
import com.vendor.burn.views.FastbootView;
import com.vendor.platform.api.statistics.ToolStatistics;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.vendor.tftp.prefences.TFTPPreferences;
import org.vendor.tftp.tool.TFTPService;

public class FastbootBurnerWorker
extends AbstractBurnerWorker
implements Modem {
    static final int TIMEOUT_XMODEM_EOT = 30000;
    static String msg_FailedToPrepareFile = "Failed to prepare File!";
    static String msg_FailedToLoadVersion = "Failed to load version info!";
    static String msg_BootBurnedSuccessfully = "Boot burned successfully.";
    private static long tempFileDivisionSize = 0L;
    protected static final String BLOCK_MARKED_BAD = "WARNING: block is marked as bad";
    protected String version;
    protected BoardConfig boardConfig;
    protected LocalConfig localConfig;
    protected String udpDdrFreeSizeStr;
    String ubootStartLog;
    protected static final int OUTPUT_PARAM_SIZE = 1;
    protected static final int TIMEMS = 10000;
    private static final int CANCEL_CODE = 256;
    public static final String WRITEBEFORE = "writeBefore";
    public static final String WRITEAFTER = "writeAfter";
    private static final String PARTITION_SBL = "sbl";
    protected TimeLogger burnBootTimeLogger = new TimeLogger();
    protected TimeLogger tftpTimeLogger = new TimeLogger();
    protected TimeLogger burnTimeLogger = new TimeLogger();
    protected TimeLogger waitZipTimeLogger = new TimeLogger();
    protected TimeLogger zipAndPageTimeLogger = new TimeLogger();
    protected TimeLogger unZipTimeLogger = new TimeLogger();
    protected TimeLogger eraseTimeLogger = new TimeLogger();
    protected TimeLogger spellingSparseFileLogger = new TimeLogger();
    protected TimeLogger crcLogger = new TimeLogger();
    protected TimeLogger i2cTimeLogger = new TimeLogger();
    protected TimeLogger flashTimeLogger = new TimeLogger();
    protected TimeLogger resetTimeLogger = new TimeLogger();
    protected static final int TFTP_MAX_RETURN_COUNT = 3;

    public FastbootBurnerWorker(IFrameSetting frameSetting, IBurner burner) {
        super(frameSetting);
        this.burner = burner;
        if (burner != null) {
            BurnContext burnContext = burner.getBurnContext();
            this.localConfig = burnContext.getLocalConfig();
            this.boardConfig = burnContext.getBoardConfig();
        }
    }

    public boolean burn(IProgressMonitor uimonitor, FlashType flashType, String filePath) throws IOException, ReceiveTimeOutException {
        if (!ToolUtils.isCmdLine()) {
            ToolStatistics.INSTANCE.logUsage("BurnTool", "Burn By Fastboot", "ChipName: " + this.burner.getBurnContext().getDeviceSetting().getName());
            ToolStatistics.INSTANCE.logToolInUse("BurnTool");
            String versionInfo = this.getVersionInfo("Burn By Fastboot");
            CallLibJTAGWorker.printDebugInfo(versionInfo);
        }
        try {
            boolean isResetJtag;
            this.setProgressMonitor(uimonitor);
            uimonitor.beginTask("", 100);
            this.registerJnaFunction(uimonitor, 100);
            FastbootEvent event = FastbootBurnerWorker.getMonitor().getEvent();
            event.init(EventType.BURN);
            this.setFlashType(flashType);
            TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
            File file = new File(filePath);
            if (transferWay == TransferWay.Uart2Compress) {
                uimonitor.setTaskName("Init Board");
                ArrayList<FlashType> hasFlashTypes = new ArrayList<FlashType>();
                hasFlashTypes.add(flashType);
                boolean initBoard = this.initBoard(hasFlashTypes);
                if (!initBoard) {
                    return false;
                }
                this.getTempFileDivisionSize(transferWay);
            } else {
                if (transferWay == TransferWay.Usb2I2c || transferWay == TransferWay.I2CBootrom) {
                    boolean result = this.burnSinglePartByI2c(uimonitor, file, "0", flashType, true, ChipID.chip0);
                    if (result) {
                        event.setSuccess(true);
                        uimonitor.done();
                        return true;
                    }
                    return false;
                }
                if (transferWay == TransferWay.USBNonNude) {
                    boolean result = false;
                    result = this.bootromByNonNude(uimonitor);
                    if (!result) {
                        return false;
                    }
                    result = this.downloadBootByUSB(uimonitor, file, transferWay);
                    if (!result) {
                        return false;
                    }
                } else if (((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) {
                    if (!this.programmerDownload(SubMonitor.convert((IProgressMonitor)uimonitor, (String)"", (int)86), filePath, ((AbstractBurner)((Object)this.burner)).getProgrammerFile(), null)) {
                        FastbootBurnerWorker.returnError("Failed to download fastboot!");
                        return false;
                    }
                } else if (this.burner.getBurnContext().getPlatformType() == PlatformType.NonCA ? !this.bootDownload(SubMonitor.convert((IProgressMonitor)uimonitor, (String)"", (int)86), filePath) : !this.programmerDownload(SubMonitor.convert((IProgressMonitor)uimonitor, (String)"", (int)86), filePath, ((AbstractBurner)((Object)this.burner)).getProgrammerFile(), null)) {
                    return false;
                }
            }
            if (flashType == FlashType.ddr) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    FastbootBurnerWorker.warningln("Error occurs while waiting DDR run.");
                    File file2 = new File(filePath);
                    this.printCrcValue(file2);
                    uimonitor.done();
                    return false;
                }
                FastbootBurnerWorker.received(serialRecvBuf + this.getCurReceived());
                event.setSuccess(true);
                uimonitor.done();
                FastbootBurnerWorker.deleteContent(usbsReceived);
                return true;
            }
            String unzipAddr = Long.toHexString(tempFileDivisionSize + (long)this.getHexStartAddressForInt());
            if (this.burner.getBurnContext().getTransferWay() == TransferWay.Uart2Compress) {
                File partFile = this.copyComFileToToolPath(uimonitor, file);
                if (partFile == null) {
                    return false;
                }
                File compressFile = GZipUtils.compress(uimonitor, partFile, false, true);
                if (compressFile == null) {
                    FastbootBurnerWorker.returnError(NLS.bind((String)Messages.ERROR_INFO_DISK_SPACE_LOW, (Object)partFile));
                    return false;
                }
                this.downloadFileSerial(SubMonitor.convert((IProgressMonitor)uimonitor, (String)"", (int)86), compressFile, false);
                if (compressFile.exists()) {
                    FileUtils.deleteFile(compressFile);
                }
                if (partFile.exists()) {
                    FileUtils.deleteFile(partFile);
                }
                if (this.burner.getBurnContext().getTransferWay() == TransferWay.Uart2Compress) {
                    UnZipCommand unZipCommand = UnZipCommand.unzip(this.getHexStartAddress(), unzipAddr);
                    this.sendCommand(unZipCommand.toString(), unZipCommand.calculateTimeOut(Long.toHexString(tempFileDivisionSize)));
                }
                if (flashType == FlashType.ddr) {
                    this.sendCommandNoReturnValue("go " + unzipAddr);
                }
            }
            uimonitor.setTaskName("Loading Info");
            if (this.loadVersionInfo(transferWay)) {
                FlashType loadBootMode = this.loadBootMode();
                if (flashType != loadBootMode && loadBootMode != null) {
                    FastbootBurnerWorker.returnError(NLS.bind((String)Messages.ERROR_INFO_Invalid_Mode_And_RealMode, (Object)loadBootMode.name()));
                    return false;
                }
            } else {
                FastbootBurnerWorker.warningln(msg_FailedToLoadVersion);
                return false;
            }
            uimonitor.worked(1);
            uimonitor.setTaskName("Burning Boot");
            long blockSize = this.getBlockSize(flashType, ChipID.chip0, true);
            if (blockSize == 0L) {
                String error = "Failed to load blocksize for " + flashType.name();
                FastbootBurnerWorker.returnError(error);
                return false;
            }
            long fileSize = file.length();
            long eraseLength = fileSize;
            if (eraseLength % blockSize != 0L) {
                eraseLength = (eraseLength / blockSize + 1L) * blockSize;
            }
            long writeLength = this.getWriteLength(flashType, blockSize, fileSize);
            if (!this.bootBurn(SubMonitor.convert((IProgressMonitor)uimonitor, (String)"", (int)12), flashType, Long.toHexString(eraseLength), Long.toHexString(writeLength), ChipID.chip0)) {
                FastbootBurnerWorker.returnError("Failed to burn boot.");
                return false;
            }
            TransferWay curTransferWay = this.burner.getBurnContext().getTransferWay();
            boolean bl = isResetJtag = !(!FastbootView.isCJXX0VXX5Series() && !FastbootView.isCJ3X0VXX1Series() && !FastbootView.isCJ3X1VXX8E_Series() || curTransferWay != TransferWay.JTAG && curTransferWay != TransferWay.JTAGAndNet && curTransferWay != TransferWay.JTAGAndSerial);
            if (!isResetJtag) {
                this.sendCommandNoReturnValue("reset");
            }
            event.setSuccess(true);
            this.infoln(msg_BootBurnedSuccessfully);
        }
        finally {
            File file = new File(filePath);
            this.printCrcValue(file);
            uimonitor.done();
        }
        return true;
    }

    protected boolean downloadBootByUDP(IProgressMonitor uimonitor, File file) {
        StringBuilder sendCommand = new StringBuilder("\nSend command");
        this.infoln(sendCommand + ":\t" + "Downloading File : " + file.getName());
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)uimonitor, (String)"", (int)100);
        boolean result = CallLibBootromWorker.UdpDownloadFile(file.getPath(), this.getHexStartAddressForInt());
        subProgress.worked(100);
        if (!result) {
            FastbootBurnerWorker.returnError(Messages.ERROR_INFO_UDP_DOWNLOAD_FAILED);
            return false;
        }
        return true;
    }

    protected boolean downloadBootByUSB(IProgressMonitor uimonitor, File file, TransferWay transferWay) {
        this.infoln("\nSend command:\tDownloading File : " + file.getName());
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)uimonitor, (String)"", (int)100);
        boolean result = CallLibUSBWorker.downloadFileByUsb(file, this.getHexStartAddressForInt(), transferWay);
        subProgress.worked(100);
        if (!result) {
            FastbootBurnerWorker.returnError(Messages.ERROR_INFO_USB_DOWNLOAD_FAILED);
            return false;
        }
        return true;
    }

    public boolean bootBurn(SubMonitor subProgressMonitor, FlashType flashType, String eraseLength, String writeLength, ChipID chipID) throws IOException, ReceiveTimeOutException {
        String address = "0x0";
        String wLen = writeLength;
        if (wLen == null) {
            wLen = eraseLength;
        }
        String ddrAddress = this.getHexStartAddress();
        String unzipAddr = Long.toHexString(tempFileDivisionSize + (long)this.getHexStartAddressForInt());
        if (this.burner.getBurnContext().getTransferWay() == TransferWay.Uart2Compress) {
            ddrAddress = unzipAddr;
        }
        FlashType flash = flashType;
        ArrayList<SerialCommand> commands = new ArrayList<SerialCommand>();
        if (flash == FlashType.emmc || flash == FlashType.ufs) {
            commands.clear();
            MmcPartCommand.addMmcPartConfCommand(WRITEBEFORE, commands, flash, this.burner);
            int commandType = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getEmmcWriteCmdType();
            int emmcType = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getEmmcType();
            if (this.burner.getBurnContext().getPlatformType() == PlatformType.NonCA || commandType == 0) {
                if (emmcType == 2) {
                    commands.add(WriteCommand.writeeMMC(flashType, ddrAddress, "0", wLen));
                } else {
                    commands.add(WriteCommand.writeeMMC(flashType, ddrAddress, "1", wLen));
                }
            } else if (emmcType == 2) {
                commands.add(WriteCommand.writeeMMC(flashType, ddrAddress, "0", wLen));
            } else if (emmcType == 3) {
                commands.add(WriteCommand.writeeMMC(flashType, ddrAddress, "1", wLen));
            } else {
                commands.add(WriteCommand.bootWriteeMMC(ddrAddress, "0", wLen));
            }
            MmcPartCommand.addMmcPartConfCommand(WRITEAFTER, commands, flash, this.burner);
        } else {
            if (flash == FlashType.spi) {
                commands.add(SFCommand.getInstance(chipID));
            }
            commands.add(EraseCommand.erase(flash, address, eraseLength));
            commands.add(WriteCommand.write(flash, ddrAddress, address, wLen));
        }
        try {
            int total = commands.size();
            subProgressMonitor.beginTask("", total * 100);
            subProgressMonitor.setTaskName("Burning Boot");
            int i = 0;
            while (i < commands.size()) {
                SerialCommand serialCommand = (SerialCommand)commands.get(i);
                subProgressMonitor.subTask("Execute command:" + serialCommand.getCommand());
                if (!this.sendCommand(serialCommand)) {
                    return false;
                }
                subProgressMonitor.worked(100);
                ++i;
            }
        }
        finally {
            subProgressMonitor.done();
        }
        return true;
    }

    private boolean isJTAG() {
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        boolean isBootromByJTAG = transferWay == TransferWay.JTAGAndNet || transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndSerial;
        return isBootromByJTAG;
    }

    public boolean bootDownload(String filePath) throws IOException {
        Socket socketConnection;
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        boolean isSupportLibBootrom = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom() && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.JTAG && transferWay != TransferWay.JTAGAndSerial;
        boolean isBootromByJTAG = transferWay == TransferWay.JTAGAndNet || transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndSerial;
        SubMonitor subMonitor = null;
        if (this.uimonitor != null) {
            subMonitor = SubMonitor.convert((IProgressMonitor)this.uimonitor, (String)"", (int)50);
        }
        boolean result = false;
        if (isSupportLibBootrom) {
            result = this.burnByLibBootrom(subMonitor, filePath);
        } else if (isBootromByJTAG) {
            FastbootBurnerWorker.deleteContent(jtagReceived);
            FastbootView.setFastbootStart(false);
            result = this.burnByJTAG(filePath);
            if (result) {
                this.infoln("Boot started successfully!");
                if (FastbootView.isCJXX0VXX5Series()) {
                    FastbootView.setFastbootStart(true);
                }
            }
        } else {
            try {
                new CallLibBootromWorker(this.frameSetting, this.burner, subMonitor);
                LibBootromByJNA.instance.Uart_RegisterPrint(CallLibBootromWorker.callback);
                LibBootromByJNA.instance.Uart_RegisterCancel(CallLibBootromWorker.callbackCancel);
                if (filePath == null || filePath.length() == 0) {
                    this.prepareFile();
                } else if (!this.prepareFile(filePath)) {
                    FastbootBurnerWorker.returnError(msg_FailedToPrepareFile);
                    return false;
                }
                if (!this.downloadFile()) {
                    FastbootBurnerWorker.returnError(Messages.ERROR_INFO_Failed_To_Download_File);
                    return false;
                }
                this.infoln("Boot download completed!");
                if (this.getFlashType() != DDR) {
                    if (!this.waitBootRun(10000)) {
                        result = false;
                    }
                    this.infoln("Boot started successfully!");
                }
                result = true;
            }
            finally {
                if (this.fileList != null) {
                    this.fileList = null;
                }
            }
        }
        if (result && CommonBurner.isSocketTransfer && (socketConnection = ((AbstractBurner)((Object)this.burner)).createSocket(FastbootBurnerWorker.getMonitor(), this)) == null) {
            return false;
        }
        return result;
    }

    protected boolean tftpAndCheckCRC(SubMonitor subProgressMonitor, File file, boolean openTftpCrcCheck) throws IOException, ReceiveTimeOutException {
        boolean result = false;
        if (TFTPService.TFTPSERVICE.getServerDirectory() != null && !TFTPService.TFTPSERVICE.getServerDirectory().equals(file.getParentFile())) {
            this.switchTFTPDownloadHome(file);
        }
        if (this.tftpTimeLogger != null) {
            this.tftpTimeLogger.logStart(file.getName(), file.length());
        }
        if (subProgressMonitor != null) {
            subProgressMonitor.setTaskName("Download File : " + file.getName());
        }
        TFTPCommand downloadCommand = TFTPCommand.download(file, this.getHexStartAddress());
        result = this.sendCommand(downloadCommand);
        if (this.tftpTimeLogger != null) {
            this.tftpTimeLogger.logEnd();
        }
        if (result && openTftpCrcCheck) {
            result = this.checkTFTPCrc32(subProgressMonitor, file);
        }
        return result;
    }

    private boolean checkTFTPCrc32(SubMonitor subProgressMonitor, File file) throws IOException, ReceiveTimeOutException {
        long fileCrcValue = CrcCommand.calculateCRC(file);
        boolean result = false;
        if (this.crcLogger != null) {
            this.crcLogger.logStart(file.getName(), file.length());
        }
        if (this.sendCommand(CrcCommand.sendCRCCommand(file, this.getHexStartAddress()))) {
            String crcReturnStr = this.getCurReceived();
            result = CrcCommand.compareFileCRC(fileCrcValue, CrcCommand.receiveCRC(crcReturnStr));
            if (!result) {
                boolean isSupportTFTPWin = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportTFTPWin();
                if (isSupportTFTPWin) {
                    boolean isCheck = false;
                    isCheck = ToolUtils.isCmdLine() ? PreferenceConfig.isTftpWinSizeOpen() : FastbootPreferences.isOpenTftpWindowSize();
                    if (isCheck && TFTPService.getWinSizeBlockCount() > 0 && TFTPService.getWinSizeBlockCount() > 1) {
                        TFTPService.setWinSizeBlockCount((int)(TFTPService.getWinSizeBlockCount() - 1));
                        this.infoln("The current Window Size value is " + (TFTPService.getWinSizeBlockCount() + 1));
                    }
                } else {
                    TFTPService.setWinSizeBlockCount((int)1);
                }
                FastbootBurnerWorker.warningln("Warn:CRC check failed, TFTP download again.");
            }
        } else {
            FastbootBurnerWorker.warningln("Warn:CRC send command failed, TFTP download again.");
        }
        if (this.crcLogger != null) {
            this.crcLogger.logEnd();
        }
        return result;
    }

    protected boolean burnByLibBootrom(SubMonitor subProgressMonitor, String filePath) {
        try {
            SerialPort serialPort;
            boolean is3796CV300;
            new CallLibBootromWorker(this.frameSetting, this.burner, subProgressMonitor);
            LibBootromByJNA.instance.Uart_RegisterPrint(CallLibBootromWorker.callback);
            LibBootromByJNA.instance.Uart_RegisterCancel(CallLibBootromWorker.callbackCancel);
            if (ToolUtils.isCmdLine()) {
                CallLibBootromWorker.setTypeFrameFrequency(this.burner.getBurnContext().getDwTimeout());
            }
            String commName = this.burner.getBurnContext().getLocalConfig().getComPort();
            if (this.burner.getBurnContext().getTransferWay() == TransferWay.NetNonNude) {
                filePath = null;
            }
            int notBareBurn = filePath == null || filePath.isEmpty() ? 1 : 0;
            int ddrOrFlash = this.getFlashType() != DDR ? 0 : 1;
            int[] caType = new int[1];
            long[] initDdrAddr = new long[1];
            int[] errorCode = new int[1];
            if (UnknownDevice.isOpenLightDebug()) {
                this.initLightState();
            }
            this.infoln(this.getStartMessage());
            this.monitorProgress(subProgressMonitor, 1);
            boolean result = false;
            boolean bl = is3796CV300 = "CJ309V100".equalsIgnoreCase(ToolUtils.getChipName()) || "CJ309V101".equalsIgnoreCase(ToolUtils.getChipName()) || "CJ3X1VXX2".equalsIgnoreCase(ToolUtils.getChipName());
            result = is3796CV300 ? (this.boardConfig.isSocket() ? CallLibBootromWorker.bootDownloadByLibSocket(this.boardConfig.getSerialServerIp(), this.boardConfig.getSerialServerPort(), notBareBurn, ddrOrFlash, filePath, ToolUtils.getChipName(), caType, initDdrAddr, errorCode) : CallLibBootromWorker.bootDownloadByLib(commName, notBareBurn, ddrOrFlash, filePath, ToolUtils.getChipName(), caType, initDdrAddr, errorCode)) : (this.boardConfig.isSocket() ? CallLibBootromWorker.bootDownloadByLibSocket(this.boardConfig.getSerialServerIp(), this.boardConfig.getSerialServerPort(), notBareBurn, ddrOrFlash, filePath, caType, initDdrAddr, errorCode) : CallLibBootromWorker.bootDownloadByLib(commName, notBareBurn, ddrOrFlash, filePath, caType, initDdrAddr, errorCode));
            if (!this.boardConfig.isSocket() && (serialPort = ((AbstractBurner)((Object)this.burner)).openSerailPort(FastbootBurnerWorker.getMonitor(), this, this.burner.getBurnContext().getLocalConfig().getComPort())) == null) {
                return false;
            }
            if (result) {
                String caTypeStr = "";
                if (caType[0] == 1) {
                    caTypeStr = "CA";
                    this.isCaChipByLibBootrom = true;
                } else {
                    caTypeStr = "noCA";
                    this.isCaChipByLibBootrom = false;
                }
                this.updateCaTypeLbl(caTypeStr);
                ((UDFrameSetting)this.frameSetting).setDdrInitAddrByLibBootrom(initDdrAddr[0]);
            } else if ((errorCode[0] & 0xFFFF) == 256) {
                this.handleCancel();
                return false;
            }
            this.monitorProgress(subProgressMonitor, 100);
            boolean bl2 = result;
            return bl2;
        }
        finally {
            if (subProgressMonitor != null) {
                subProgressMonitor.done();
            }
        }
    }

    private void monitorProgress(SubMonitor subProgressMonitor, int progress) {
        if (subProgressMonitor != null) {
            subProgressMonitor.worked(progress);
        }
    }

    protected boolean burnByJTAG(SubMonitor subProgressMonitor, String filePath, int level) {
        try {
            SerialPort serialPort;
            String commName = this.burner.getBurnContext().getLocalConfig().getComPort();
            int jtagChipType = FastbootView.getJtagChipTypeByChipName().ordinal();
            int ddrOrFlash = this.getFlashType() != DDR ? 0 : 1;
            long[] initDdrAddr = new long[]{this.frameSetting.getThirdFileAddress()};
            int[] errorCode = new int[1];
            if (FastbootView.isCJ3X1VXX8E_Series()) {
                this.infoln("\n" + Messages.ERROR_INFO_Start_JTAG);
            }
            subProgressMonitor.worked(1);
            boolean result = CallLibJTAGWorker.bootDownloadByLib(jtagChipType, commName, ddrOrFlash, initDdrAddr, filePath, LibJTAGByJNA.JTAG_DLL_PATH, errorCode, level);
            if (!result) {
                this.checkJTAGReturn(errorCode);
                boolean bl = result;
                return bl;
            }
            ((UDFrameSetting)this.frameSetting).setDdrInitAddrByLibBootrom(initDdrAddr[0]);
            if ((FastbootView.getJtagChipTypeByChipName() == LibJTAGByJNA.EJtagChipType.CJ3X1VXX5 || FastbootView.getJtagChipTypeByChipName() == LibJTAGByJNA.EJtagChipType.CJXX0VXX4) && (serialPort = ((AbstractBurner)((Object)this.burner)).openSerailPort(FastbootBurnerWorker.getMonitor(), this, this.burner.getBurnContext().getLocalConfig().getComPort())) == null) {
                return false;
            }
            subProgressMonitor.worked(100);
            boolean bl = result;
            return bl;
        }
        finally {
            subProgressMonitor.done();
        }
    }

    private void checkJTAGReturn(int[] errorCode) {
        int error = errorCode[0] & 0xFFFF;
        if (error == 256) {
            this.handleCancel();
        } else if (error == JTAG_STATUS.OPENOCD_DEVICE_NOT_FOUND.getErrorCode()) {
            monitor.getEvent().setMessage(Messages.ERROR_JTAG_OPENOCD_DEVICE_NOT_FOUND);
        } else if (error == JTAG_STATUS.SERAIL_PORT_OPEN_FAILED.getErrorCode()) {
            monitor.getEvent().setMessage(Messages.SERAIL_PORT_OPEN_FAILED);
        } else if (error == JTAG_STATUS.SERAIL_PORT_NO_DATA.getErrorCode()) {
            monitor.getEvent().setMessage(Messages.SERAIL_PORT_NO_DATA);
        } else if (error == JTAG_STATUS.SERAIL_PORT_BOOT_NOT_RUN.getErrorCode()) {
            monitor.getEvent().setMessage(Messages.SERAIL_PORT_BOOT_NOT_RUN);
        } else if (error == JTAG_STATUS.BOOT_NOT_RUN.getErrorCode()) {
            monitor.getEvent().setMessage(Messages.BOOT_NOT_RUN);
        } else if (error == JTAG_STATUS.INVALID_PARAMETER.getErrorCode()) {
            monitor.getEvent().setMessage(Messages.INVALID_PARAMETER);
        } else if (error == JTAG_STATUS.WRONG_CHIP_ID.getErrorCode()) {
            monitor.getEvent().setMessage(Messages.WRONG_CHIP_ID);
        } else if (error == JTAG_STATUS.INVALID_BASIC.getErrorCode()) {
            monitor.getEvent().setMessage(Messages.INVALID_BASIC);
        } else if (error == JTAG_STATUS.DOWNLOAD_FILE_FAILED.getErrorCode()) {
            monitor.getEvent().setMessage(Messages.DOWNLOAD_FILE_FAILED);
        } else if (error == JTAG_STATUS.READ_REG_ERROR.getErrorCode()) {
            monitor.getEvent().setMessage(Messages.READ_REG_ERROR);
        } else if (error == JTAG_STATUS.OPERATE_TIME_OUT.getErrorCode()) {
            monitor.getEvent().setMessage(Messages.OPERATE_TIME_OUT);
        } else if (error == JTAG_STATUS.INIT_OPENOCD_FAIL.getErrorCode()) {
            monitor.getEvent().setMessage(Messages.INIT_OPENOCD_FAIL);
        } else if (error == JTAG_STATUS.INIT_DDR_FAIL.getErrorCode()) {
            monitor.getEvent().setMessage(Messages.INIT_DDR_FAIL);
        } else if (error == JTAG_STATUS.CRC32_VERIFY_TIMEOUT.getErrorCode()) {
            monitor.getEvent().setMessage(Messages.CRC32_VERIFY_TIMEOUT);
        } else if (error == JTAG_STATUS.BOARD_POWER_OFF.getErrorCode()) {
            monitor.getEvent().setMessage(Messages.BOARD_POWER_OFF);
        }
    }

    protected boolean burnByJTAG(String filePath) {
        SerialPort serialPort;
        int jtagFrequency;
        boolean result;
        if (filePath != null && filePath.isEmpty()) {
            filePath = null;
        }
        String commName = this.burner.getBurnContext().getLocalConfig().getComPort();
        int jtagChipType = FastbootView.getJtagChipTypeByChipName().ordinal();
        int ddrOrFlash = this.getFlashType() != DDR ? 0 : 1;
        long[] initDdrAddr = new long[]{this.frameSetting.getThirdFileAddress()};
        int[] errorCode = new int[1];
        if (FastbootView.isCJ3X1VXX8E_Series()) {
            this.infoln("\n" + Messages.ERROR_INFO_Start_JTAG);
        }
        if (!(result = CallLibJTAGWorker.bootDownloadByLib(jtagChipType, commName, ddrOrFlash, initDdrAddr, filePath, LibJTAGByJNA.JTAG_DLL_PATH, errorCode, jtagFrequency = this.burner.getBurnContext().getJtagFrequency()))) {
            this.checkJTAGReturn(errorCode);
            return result;
        }
        ((UDFrameSetting)this.frameSetting).setDdrInitAddrByLibBootrom(initDdrAddr[0]);
        if ((FastbootView.getJtagChipTypeByChipName() == LibJTAGByJNA.EJtagChipType.CJ3X1VXX5 || FastbootView.getJtagChipTypeByChipName() == LibJTAGByJNA.EJtagChipType.CJXX0VXX4) && (serialPort = ((AbstractBurner)((Object)this.burner)).openSerailPort(FastbootBurnerWorker.getMonitor(), this, this.burner.getBurnContext().getLocalConfig().getComPort())) == null) {
            return false;
        }
        return result;
    }

    private boolean setupUdpPort() throws IOException, ReceiveTimeOutException {
        int port = this.burner.getBurnContext().getBoardConfig().getUdpPort();
        NetCommand command = NetCommand.setServerPort(String.valueOf(port));
        if (!this.sendCommandDontCareEOTBySerial(command.getCommand(), command.getTimeout())) {
            return false;
        }
        return this.sendCommandDontCareEOTBySerial("saveenv", command.getTimeout());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean startFastbootUdpTransferWay(IProgressMonitor uimonitor, TransferWay curTransferWay) throws IOException {
        if (curTransferWay == TransferWay.UDP && ToolUtils.isCmdLine()) {
            try {
                this.udpDdrFreeSizeStr = this.getDDRFreeParamBySerial();
            }
            catch (ReceiveTimeOutException receiveTimeOutException) {
                return false;
            }
            if (this.udpDdrFreeSizeStr == null) {
                return false;
            }
            try {
                NetCommand[] commands = this.buildNetCommands(curTransferWay);
                if (commands == null) {
                    return false;
                }
                NetCommand[] netCommandArray = commands;
                int n = commands.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        if (!this.setupUdpPort()) {
                            return false;
                        }
                        break;
                    }
                    NetCommand command = netCommandArray[n2];
                    if (!this.sendCommandDontCareEOTBySerial(command.getCommand(), command.getTimeout())) {
                        return false;
                    }
                    ++n2;
                }
            }
            catch (ReceiveTimeOutException receiveTimeOutException) {
                return false;
            }
            String ddrFreeSize = this.getDDRFreeParam("size:", this.udpDdrFreeSizeStr, TransferWay.Serial);
            String ddrFreeBaseAddr = this.getDDRFreeParam("baseaddr:", this.udpDdrFreeSizeStr, TransferWay.Serial);
            String command = INFOCommand.getUDPServiceCommand(ddrFreeBaseAddr, ddrFreeSize).getCommand();
            try {
                this.sendCommandDontCareEOTBySerial(command, TIMEOUT_SEND_FRAME);
            }
            catch (IOException iOException) {
            }
            catch (ReceiveTimeOutException receiveTimeOutException) {}
            if (!CallLibBootromWorker.createUdpSocket(this.burner.getBurnContext().getBoardConfig().getIp(), this.burner.getBurnContext().getBoardConfig().getUdpPort())) {
                return false;
            }
        }
        return true;
    }

    protected boolean startFastbootUsbTransferWay(IProgressMonitor uimonitor, TransferWay curTransferWay) throws IOException {
        if (curTransferWay == TransferWay.UsbAndSerial) {
            String ddrFreeSizeStr = null;
            try {
                ddrFreeSizeStr = this.getDDRFreeParamBySerial();
                FastbootBurnerWorker.receivedln(ddrFreeSizeStr);
            }
            catch (ReceiveTimeOutException receiveTimeOutException) {}
            if (ddrFreeSizeStr == null) {
                return false;
            }
            String command = null;
            if (ToolUtils.isCmdLine()) {
                command = INFOCommand.getUsbSerial(BurnConfig.getUsbSerialNumber()).getCommand();
                this.infoln("\nSend command:\t" + command);
                if (!this.serialCommand(command, TIMEOUT_SEND_FRAME)) {
                    return false;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            String ddrFreeSize = this.getDDRFreeParam("size:", ddrFreeSizeStr, TransferWay.Serial);
            String ddrFreeBaseAddr = this.getDDRFreeParam("baseaddr:", ddrFreeSizeStr, TransferWay.Serial);
            command = INFOCommand.getFastboot(ddrFreeBaseAddr, ddrFreeSize).getCommand();
            this.infoln("\nSend command:\t" + command);
            if (!this.serialCommandFastboot(command, TIMEOUT_SEND_FRAME)) {
                if (ToolUtils.isDebugOn()) {
                    this.println("Failed to send command frame");
                }
                return false;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
            boolean openUsbResult = CallLibUSBWorker.openUsb(uimonitor, 3000L, TransferWay.UsbAndSerial, BurnConfig.getUsbSerialNumber());
            if (!openUsbResult) {
                return false;
            }
        }
        return true;
    }

    public boolean bootDownload(SubMonitor subProgressMonitor, String filePath) throws IOException {
        boolean isBootromByJTAG;
        subProgressMonitor.beginTask("", 100);
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        boolean isSupportLibBootrom = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom() && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.JTAG && transferWay != TransferWay.JTAGAndSerial;
        boolean bl = isBootromByJTAG = transferWay == TransferWay.JTAGAndNet || transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndSerial;
        if (isSupportLibBootrom) {
            try {
                Socket socketConnection;
                subProgressMonitor.setTaskName("Downloading Boot");
                if (!this.burnByLibBootrom(SubMonitor.convert((IProgressMonitor)this.uimonitor, (String)"", (int)98), filePath)) {
                    FastbootBurnerWorker.updateLightState();
                    return false;
                }
                this.infoln("Boot started successfully!");
                if (CommonBurner.isSocketTransfer && (socketConnection = ((AbstractBurner)((Object)this.burner)).createSocket(FastbootBurnerWorker.getMonitor(), this)) == null) {
                    return false;
                }
                if (!this.startFastbootUdpTransferWay(this.uimonitor, this.burner.getBurnContext().getTransferWay())) {
                    return false;
                }
                return this.startFastbootUsbTransferWay(this.uimonitor, this.burner.getBurnContext().getTransferWay());
                {
                }
            }
            finally {
                subProgressMonitor.done();
            }
        }
        if (isBootromByJTAG) {
            FastbootBurnerWorker.deleteContent(jtagReceived);
            FastbootView.setFastbootStart(false);
            int jtagFrequency = this.burner.getBurnContext().getJtagFrequency();
            try {
                subProgressMonitor.setTaskName("Downloading Boot");
                if (!this.burnByJTAG(SubMonitor.convert((IProgressMonitor)this.uimonitor, (String)"", (int)98), filePath, jtagFrequency)) {
                    return false;
                }
                this.infoln("Boot started successfully!");
                if (transferWay != TransferWay.JTAGAndNet) {
                    FastbootView.setFastbootStart(true);
                }
                return true;
            }
            finally {
                subProgressMonitor.done();
            }
        }
        try {
            subProgressMonitor.setTaskName("Downloading Boot");
            if (filePath == null || filePath.length() == 0) {
                this.prepareFile();
            } else if (!this.prepareFile(filePath)) {
                FastbootBurnerWorker.returnError(msg_FailedToPrepareFile);
                return false;
            }
            new CallLibBootromWorker(this.frameSetting, this.burner, subProgressMonitor);
            LibBootromByJNA.instance.Uart_RegisterPrint(CallLibBootromWorker.callback);
            LibBootromByJNA.instance.Uart_RegisterCancel(CallLibBootromWorker.callbackCancel);
            if (!this.downloadFile(this.getHexStartAddressForInt(), filePath, "     ")) {
                FastbootBurnerWorker.returnError(Messages.ERROR_INFO_Failed_To_Download_File);
                return false;
            }
            this.infoln("Boot download completed!");
            if (this.getFlashType() != DDR) {
                subProgressMonitor.subTask("Waiting Boot to Run");
                if (!this.waitBootRun(10000)) {
                    return false;
                }
                this.infoln("Boot started successfully!");
            }
            return true;
        }
        finally {
            if (this.fileList != null) {
                this.fileList = null;
            }
            subProgressMonitor.done();
        }
    }

    public boolean programmerDownload(String bootFile, String programmerFile) {
        block27: {
            block30: {
                block29: {
                    block28: {
                        boolean programmerInvaild;
                        boolean bootAndProgisInVaild;
                        block24: {
                            block25: {
                                block26: {
                                    boolean programmerInvaild2;
                                    block20: {
                                        block22: {
                                            block23: {
                                                boolean programmerInvaild3;
                                                block21: {
                                                    try {
                                                        boolean bootAndProgrammerisInVaild;
                                                        if (!((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) break block20;
                                                        boolean bl = bootAndProgrammerisInVaild = (bootFile == null || bootFile.isEmpty()) && (programmerFile == null || programmerFile.isEmpty()) || this.burner.getBurnContext().getTransferWay() == TransferWay.NetNonNude;
                                                        if (!bootAndProgrammerisInVaild) break block21;
                                                        if (!this.bootDownload(null)) {
                                                            return false;
                                                        }
                                                    }
                                                    catch (IOException iOException) {
                                                        return false;
                                                    }
                                                }
                                                boolean bl = programmerInvaild3 = programmerFile == null || programmerFile.isEmpty();
                                                if (!programmerInvaild3) break block22;
                                                if (this.bootDownload(bootFile)) break block23;
                                                return false;
                                            }
                                            if (!this.isCaChipByLibBootrom) {
                                                return true;
                                            }
                                        }
                                        if (!this.bootDownload(programmerFile)) {
                                            return false;
                                        }
                                    }
                                    if (!this.isJTAG()) break block24;
                                    boolean bl = programmerInvaild2 = programmerFile == null || programmerFile.isEmpty();
                                    if (!programmerInvaild2) break block25;
                                    if (this.bootDownload(bootFile)) break block26;
                                    return false;
                                }
                                if (!this.isCaChipByLibBootrom) {
                                    return true;
                                }
                            }
                            if (!this.bootDownload(programmerFile)) {
                                return false;
                            }
                        }
                        boolean bl = bootAndProgisInVaild = !(bootFile != null && !bootFile.isEmpty() || programmerFile != null && !programmerFile.isEmpty());
                        if (bootAndProgisInVaild) break block27;
                        boolean bl2 = programmerInvaild = programmerFile == null || programmerFile.isEmpty();
                        if (!programmerInvaild) break block28;
                        if (!this.prepareProgrammerFile(bootFile)) {
                            return false;
                        }
                        break block29;
                    }
                    if (this.prepareProgrammerFile(programmerFile)) break block29;
                    return false;
                }
                if (this.downloadFile()) break block30;
                return false;
            }
            if (this.getFlashType() != DDR) break block27;
            return true;
        }
        if (!this.waitBootRunCA()) {
            return false;
        }
        return this.downloadBootAgain(bootFile);
    }

    private boolean downloadBootAgain(String bootFile) {
        boolean bootFileVaild;
        boolean bl = bootFileVaild = bootFile != null && !bootFile.isEmpty();
        if (bootFileVaild) {
            File bFile = new File(bootFile);
            boolean isSerialOnly = this.burner instanceof IBootBurner && !(this.burner instanceof IAddressBurner) || this.burner instanceof IChecker;
            boolean downloadResult = true;
            TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
            boolean needOpenNetWork = this.isNeedOpenNetWork(isSerialOnly, transferWay);
            if (needOpenNetWork) {
                block19: {
                    if (this.setupNetwork(transferWay)) break block19;
                    FastbootBurnerWorker.returnError("Failed to setup network!");
                    return false;
                }
                try {
                    this.switchTFTPDownloadHome(bFile);
                    if (!this.sendCommand(TFTPCommand.download(bFile, this.getHexStartAddress()))) {
                        downloadResult = false;
                    }
                }
                catch (IOException iOException) {
                    downloadResult = false;
                }
                catch (ReceiveTimeOutException receiveTimeOutException) {
                    downloadResult = false;
                }
            } else if (transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndSerial) {
                boolean result = false;
                try {
                    result = this.jtagAndCheckCRC(bFile);
                }
                catch (IOException iOException) {
                }
                catch (ReceiveTimeOutException receiveTimeOutException) {}
                if (!result) {
                    FastbootBurnerWorker.returnError(Messages.FAILED_TO_DOWNLOAD_FILE_BY_JTAG);
                    return false;
                }
            } else {
                new CallLibBootromWorker(this.frameSetting, this.burner, SubMonitor.convert((IProgressMonitor)this.uimonitor, (String)"", (int)100));
                LibBootromByJNA.instance.Uart_RegisterPrint(CallLibBootromWorker.callback);
                LibBootromByJNA.instance.Uart_RegisterCancel(CallLibBootromWorker.callbackCancel);
                try {
                    if (!this.downloadFileSerial(bFile)) {
                        downloadResult = false;
                    }
                }
                catch (IOException iOException) {
                    downloadResult = false;
                }
                catch (ReceiveTimeOutException receiveTimeOutException) {
                    downloadResult = false;
                }
            }
            if (!downloadResult) {
                FastbootBurnerWorker.warningln("\nFailed to downlaod file. Please check the board status and connection, then try again.");
                return false;
            }
        }
        return true;
    }

    private boolean isNeedOpenNetWork(boolean isSerialOnly, TransferWay transferWay) {
        boolean needOpenNetWork = (transferWay == TransferWay.Net || transferWay == TransferWay.UsbTransNet || transferWay == TransferWay.JTAGAndNet) && !isSerialOnly;
        return needOpenNetWork;
    }

    public boolean programmerDownload(SubMonitor subProgressMonitor, String bootFile, String programmerFile, List<PartitionItem> parts) {
        block24: {
            block27: {
                block26: {
                    block25: {
                        boolean programmerInvaild;
                        boolean bootAndProgisInVaild;
                        block19: {
                            block23: {
                                block21: {
                                    block22: {
                                        boolean programmerInvaild2;
                                        block20: {
                                            subProgressMonitor.setTaskName("Downloading Boot");
                                            this.registerJnaFunction((IProgressMonitor)subProgressMonitor, 100);
                                            try {
                                                boolean bootAndProgrammerisInVaild;
                                                boolean isLibBootromOrJtag;
                                                boolean bl = isLibBootromOrJtag = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom() || this.burner.getBurnContext().getTransferWay() == TransferWay.JTAGAndNet || this.burner.getBurnContext().getTransferWay() == TransferWay.JTAG || this.burner.getBurnContext().getTransferWay() == TransferWay.JTAGAndSerial;
                                                if (!isLibBootromOrJtag) break block19;
                                                boolean bl2 = bootAndProgrammerisInVaild = (bootFile == null || bootFile.isEmpty()) && (programmerFile == null || programmerFile.isEmpty()) || this.burner.getBurnContext().getTransferWay() == TransferWay.NetNonNude;
                                                if (!bootAndProgrammerisInVaild) break block20;
                                                if (!this.bootDownload(subProgressMonitor, null)) {
                                                    return false;
                                                }
                                            }
                                            catch (IOException iOException) {
                                                return false;
                                            }
                                        }
                                        boolean bl = programmerInvaild2 = programmerFile == null || programmerFile.isEmpty();
                                        if (!programmerInvaild2) break block21;
                                        if (this.bootDownload(subProgressMonitor, bootFile)) break block22;
                                        return false;
                                    }
                                    if (!this.isCaChipByLibBootrom) {
                                        return true;
                                    }
                                }
                                boolean needDownLoadSBL = this.getNeedDownLoadSBL(parts);
                                if (!needDownLoadSBL || bootFile == null || bootFile.isEmpty()) break block23;
                                if (!this.bootDownload(subProgressMonitor, bootFile)) {
                                    return false;
                                }
                            }
                            if (!this.bootDownload(subProgressMonitor, programmerFile)) {
                                return false;
                            }
                        }
                        boolean bl = bootAndProgisInVaild = !(bootFile != null && !bootFile.isEmpty() || programmerFile != null && !programmerFile.isEmpty());
                        if (bootAndProgisInVaild) break block24;
                        boolean bl3 = programmerInvaild = programmerFile == null || programmerFile.isEmpty();
                        if (!programmerInvaild) break block25;
                        if (!this.prepareProgrammerFile(bootFile)) {
                            return false;
                        }
                        break block26;
                    }
                    if (this.prepareProgrammerFile(programmerFile)) break block26;
                    return false;
                }
                new CallLibBootromWorker(this.frameSetting, this.burner, subProgressMonitor);
                LibBootromByJNA.instance.Uart_RegisterPrint(CallLibBootromWorker.callback);
                LibBootromByJNA.instance.Uart_RegisterCancel(CallLibBootromWorker.callbackCancel);
                subProgressMonitor.subTask("Downloading boot");
                this.infoln("[Download File by Serial]\nfile = " + bootFile + "\naddress = " + this.getHexStartAddress());
                this.infoln("Serial Download Command = " + bootFile);
                if (this.downloadFile(this.getHexStartAddressForInt(), bootFile, "     ")) break block27;
                return false;
            }
            if (this.getFlashType() != DDR) break block24;
            return true;
        }
        subProgressMonitor.subTask("Waiting Boot to Run");
        if (!this.waitBootRunCA()) {
            return false;
        }
        if (this.getFlashType() == DDR) {
            return true;
        }
        boolean needDownLoadSBL = this.getNeedDownLoadSBL(parts);
        if (needDownLoadSBL) {
            return true;
        }
        subProgressMonitor.subTask("Preparing");
        return this.downloadBootAgain(subProgressMonitor, bootFile);
    }

    protected boolean burnSBL(IProgressMonitor uiMonitor, List<PartitionItem> parts, String programmerPath) throws IOException, ReceiveTimeOutException {
        boolean needDownLoadSBL = this.getNeedDownLoadSBL(parts);
        if (needDownLoadSBL) {
            File sblFile = this.getSBLFile(parts);
            if (programmerPath != null && !programmerPath.isEmpty()) {
                sblFile = new File(programmerPath);
            }
            if (sblFile == null) {
                return false;
            }
            boolean result = this.downloadFileSerial(SubMonitor.convert((IProgressMonitor)this.uimonitor, (String)"", (int)100), sblFile, true);
            if (!result) {
                return result;
            }
            if (!this.waitBootRun(10000)) {
                return false;
            }
            this.infoln("SBL Started successfully!");
            PartitionItem fastboot = parts.get(0);
            if (!fastboot.isChecked()) {
                return true;
            }
            File file = fastboot.getFile();
            if (file == null) {
                return false;
            }
            String bootFilePath = file.getPath();
            if (!this.downloadBootAgain(SubMonitor.convert((IProgressMonitor)this.uimonitor, (String)"", (int)95), bootFilePath)) {
                return false;
            }
        }
        return true;
    }

    protected boolean getNeedDownLoadSBL(List<PartitionItem> parts) {
        if (!FastbootView.isNeedDownLoadSBLSeries() || parts == null) {
            return false;
        }
        boolean hasSBL = false;
        boolean hasSBLFile = false;
        for (PartitionItem partitionItem : parts) {
            boolean vaildFile;
            String name = partitionItem.getName();
            if (name == null || !name.equalsIgnoreCase(PARTITION_SBL)) continue;
            hasSBL = true;
            File sblFile = partitionItem.getFile();
            if (sblFile == null) continue;
            boolean bl = vaildFile = sblFile.exists() && !sblFile.isDirectory();
            if (vaildFile) {
                hasSBLFile = true;
                break;
            }
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"BurnTool", (String)Messages.WARN_SBL_IS_NOT_SELECT_FILE);
            break;
        }
        return hasSBL && hasSBLFile;
    }

    private File getSBLFile(List<PartitionItem> parts) {
        for (PartitionItem partitionItem : parts) {
            String name = partitionItem.getName();
            if (!name.equalsIgnoreCase(PARTITION_SBL)) continue;
            return partitionItem.getFile();
        }
        return null;
    }

    private boolean downloadBootAgain(SubMonitor subProgressMonitor, String bootFile) {
        boolean bootFileVaild;
        boolean bl = bootFileVaild = bootFile != null && !bootFile.isEmpty();
        if (bootFileVaild) {
            File bFile = new File(bootFile);
            boolean downloadResult = true;
            TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
            boolean needOpenNetWork = this.isNeedOpenNetWork(transferWay);
            if (needOpenNetWork) {
                block23: {
                    if (this.setupNetwork(transferWay)) break block23;
                    FastbootBurnerWorker.returnError("Failed to setup network!");
                    return false;
                }
                try {
                    this.switchTFTPDownloadHome(bFile);
                    boolean result = false;
                    int retransmitCount = 0;
                    result = this.checkTftpCrcIfTrue(subProgressMonitor, bFile, result, retransmitCount);
                    if (!result) {
                        FastbootBurnerWorker.returnError(Messages.Partition_TFTP_CRC_Failed);
                        return false;
                    }
                }
                catch (IOException iOException) {
                    downloadResult = false;
                }
                catch (ReceiveTimeOutException receiveTimeOutException) {
                    downloadResult = false;
                }
            } else if (transferWay == TransferWay.JTAGAndSerial || transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndNet) {
                boolean result = false;
                try {
                    result = this.jtagAndCheckCRC(bFile);
                }
                catch (IOException iOException) {
                }
                catch (ReceiveTimeOutException receiveTimeOutException) {}
                if (!result) {
                    FastbootBurnerWorker.returnError(Messages.Partition_JTAG_CRC_Failed);
                    return false;
                }
            } else if (transferWay == TransferWay.UsbAndSerial || FastbootView.isSupportUsbNonNude(transferWay)) {
                downloadResult = this.downloadBootByUSB((IProgressMonitor)subProgressMonitor, bFile, transferWay);
            } else if (transferWay == TransferWay.UDP) {
                downloadResult = this.downloadBootByUDP((IProgressMonitor)subProgressMonitor, bFile);
            } else {
                try {
                    if (!this.downloadFileSerial(SubMonitor.convert((IProgressMonitor)this.uimonitor, (String)"", (int)20), bFile, false)) {
                        downloadResult = false;
                    }
                }
                catch (IOException iOException) {
                    downloadResult = false;
                }
                catch (ReceiveTimeOutException receiveTimeOutException) {
                    downloadResult = false;
                }
            }
            if (!downloadResult) {
                FastbootBurnerWorker.warningln("\nFailed to downlaod file. Please check the board status and connection, then try again.");
                return false;
            }
        }
        return true;
    }

    public boolean checkTftpCrcIfTrue(SubMonitor subProgressMonitor, File bFile, boolean result, int retransmitCount) throws IOException, ReceiveTimeOutException {
        boolean openTftpCrcCheck = true;
        boolean checkResult = result;
        int retransmitMaxCount = retransmitCount;
        if (ToolUtils.isCmdLine()) {
            openTftpCrcCheck = PreferenceConfig.isTftpCrcCheck() && !FastbootView.isCJXX0VXX5Series();
        } else {
            boolean bl = openTftpCrcCheck = FastbootPreferences.isOpenTftpCrcCheck() && !FastbootView.isCJXX0VXX5Series();
        }
        if (openTftpCrcCheck) {
            while (retransmitMaxCount < 3) {
                this.infoln("tftp crc count:" + retransmitMaxCount);
                checkResult = this.tftpAndCheckCRC(subProgressMonitor, bFile, openTftpCrcCheck);
                if (!checkResult) {
                    ++retransmitMaxCount;
                    continue;
                }
                break;
            }
        } else {
            checkResult = this.tftpAndCheckCRC(subProgressMonitor, bFile, openTftpCrcCheck);
        }
        return checkResult;
    }

    private boolean isNeedOpenNetWork(TransferWay transferWay) {
        boolean needOpenNetWork = transferWay == TransferWay.Net || transferWay == TransferWay.UsbTransNet || transferWay == TransferWay.JTAGAndNet || transferWay == TransferWay.NetNonNude;
        return needOpenNetWork;
    }

    protected boolean jtagAndCheckCRC(File partfile) throws IOException, ReceiveTimeOutException {
        boolean openTftpCrcCheck = false;
        if (ToolUtils.isCmdLine()) {
            openTftpCrcCheck = PreferenceConfig.isTftpCrcCheck() && !FastbootView.isCJXX0VXX5Series();
        } else {
            boolean bl = openTftpCrcCheck = FastbootPreferences.isOpenTftpCrcCheck() && !FastbootView.isCJXX0VXX5Series();
        }
        if (openTftpCrcCheck) {
            int retransmitCount = 0;
            while (retransmitCount < 3) {
                boolean result = this.sendFileByJTAG(partfile);
                if (!result) {
                    return false;
                }
                result = this.checkJtagCrc32(partfile);
                if (result) {
                    return result;
                }
                ++retransmitCount;
            }
        } else {
            return this.sendFileByJTAG(partfile);
        }
        return true;
    }

    protected boolean checkJtagCrc32(File partfile) throws IOException, ReceiveTimeOutException {
        String crcReturnStr;
        boolean result = false;
        long fileCrcValue = CrcCommand.calculateCRC(partfile);
        if (this.crcLogger != null) {
            this.crcLogger.logStart(partfile.getName(), partfile.length());
        }
        if (this.sendCommand(CrcCommand.sendCRCCommand(partfile, this.getHexStartAddress())) && !(result = CrcCommand.compareFileCRC(fileCrcValue, CrcCommand.receiveCRC(crcReturnStr = this.getCurReceived())))) {
            FastbootBurnerWorker.warningln("Warn:CRC check failed, JTAG download again.");
        }
        if (this.crcLogger != null) {
            this.crcLogger.logEnd();
        }
        return result;
    }

    protected boolean sendFileByJTAG(File file) {
        boolean checkFile;
        boolean bl = checkFile = file == null || !file.exists() || file.isDirectory();
        if (checkFile) {
            return false;
        }
        this.infoln("\nSend command:\tDownloading File by JTAG: " + file.getName());
        boolean result = CallLibJTAGWorker.sendFileByJtag(file.getPath(), Long.parseLong(this.getHexStartAddress(), 16));
        return result;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean waitBootRun(int timeMS) {
        startTime = System.currentTimeMillis();
        offset = 0;
        temp = null;
        subSequence = null;
        i2csBuilder = new StringBuilder();
        usbsBuilder = new StringBuilder();
        timeout = 30000L;
        transferWay = this.burner.getBurnContext().getTransferWay();
        if (transferWay != TransferWay.USBBootrom && transferWay != TransferWay.USBNonNude) ** GOTO lbl35
        CallLibUSBWorker.closeUsb(transferWay);
        this.sleep(timeMS);
        openUsbResult = CallLibUSBWorker.openUsb(this.uimonitor, timeout, transferWay, BurnConfig.getUsbSerialNumber());
        if (openUsbResult) ** GOTO lbl35
        return false;
lbl-1000:
        // 1 sources

        {
            temp = this.getTempReceive(temp, i2csBuilder, usbsBuilder, transferWay);
            indexOf = -1;
            if (temp == null || temp.length() <= offset) continue;
            len = temp.length();
            subSequence = temp.subSequence(offset, len);
            offset += subSequence.length();
            if (subSequence.toString().indexOf("\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014") == -1) {
                FastbootBurnerWorker.received(subSequence.toString());
            } else {
                FastbootBurnerWorker.receivedln(subSequence.toString());
            }
            indexOf = temp.toLowerCase().indexOf("start download process.");
            if (UnknownDevice.isOpenLightDebug() && temp.toString().contains("*** Not upport current start mode")) {
                AbstractBurnerWorker.lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FLASH_AND_IMAGE_MATCH.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                FastbootBurnerWorker.updateLightState();
            }
            if (indexOf == -1) continue;
            if (UnknownDevice.isOpenLightDebug()) {
                FastbootBurnerWorker.readBootInfo(temp);
            }
            FastbootBurnerWorker.received("\n");
            return true;
lbl35:
            // 4 sources

            ** while (System.currentTimeMillis() - startTime < timeout)
        }
lbl36:
        // 1 sources

        if (UnknownDevice.isOpenLightDebug()) {
            FastbootBurnerWorker.lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FASTBOOT_START.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
            FastbootBurnerWorker.updateLightState();
        }
        FastbootBurnerWorker.returnError(Messages.ERROR_INFO_Failed_To_Wait_Boot_Running);
        return false;
    }

    protected String getTempReceive(String temp, StringBuilder i2csBuilder, StringBuilder usbsBuilder, TransferWay transferWay) {
        String tempReceived = temp;
        if (transferWay == TransferWay.I2CBootrom) {
            try {
                this.receiveBytesByI2c(i2csBuilder, 256);
                tempReceived = i2csBuilder.toString();
            }
            catch (IOException iOException) {}
        } else if (transferWay == TransferWay.USBBootrom || transferWay == TransferWay.USBNonNude) {
            try {
                this.receiveBytesByUsbIgnore(usbsBuilder, 512, transferWay);
                tempReceived = usbsBuilder.toString();
            }
            catch (IOException iOException) {}
        } else {
            this.socketReceived();
            tempReceived = serialReceived.toString();
        }
        return tempReceived;
    }

    protected boolean waitBootRunCA() {
        long startTime = System.currentTimeMillis();
        int offset = 0;
        String temp = null;
        CharSequence subSequence = null;
        while (System.currentTimeMillis() - startTime < 10000L) {
            int indexOf;
            this.onAdataAvailable(serialReceived);
            temp = serialReceived.toString();
            if (temp.length() > offset) {
                int len = temp.length();
                subSequence = temp.subSequence(offset, len);
                offset += subSequence.length();
                if (temp.toString().indexOf("     ") == -1) {
                    FastbootBurnerWorker.received(subSequence.toString());
                } else {
                    try {
                        this.sendBytes(new byte[]{-86});
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                    FastbootBurnerWorker.receivedln(subSequence.toString());
                }
            }
            if ((indexOf = temp.toLowerCase().indexOf("start download process.")) == -1) continue;
            this.ubootStartLog = temp;
            FastbootBurnerWorker.received("\n");
            return true;
        }
        FastbootBurnerWorker.returnError(Messages.ERROR_INFO_Failed_To_Wait_Boot_Running);
        return false;
    }

    protected boolean waitOpenUsb(IProgressMonitor uiMonitor, TransferWay curTransferWay) {
        CallLibUSBWorker.closeUsb(curTransferWay);
        while (true) {
            this.uimonitor.subTask("Waiting Open Usb");
            boolean openUsbResult = CallLibUSBWorker.openUsb(this.uimonitor, 30000L, curTransferWay, BurnConfig.getUsbSerialNumber());
            if (openUsbResult) {
                this.infoln("\nOpen Usb successfully!");
                return true;
            }
            this.infoln("\nOpen Usb Failed!");
            if (uiMonitor.isCanceled()) {
                return false;
            }
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    protected boolean bootromByNonNude(IProgressMonitor uimonitor) {
        if (!this.sendUSBStartFrame()) {
            FastbootBurnerWorker.returnError(Messages.ERROR_INFO_Failed_To_Send_Start_Frame);
            return false;
        }
        if (this.getFlashType() != DDR) {
            uimonitor.subTask("Waiting Boot to Run");
            if (!this.waitBootRun(10000)) {
                return false;
            }
            this.infoln("Boot started successfully!");
        }
        return true;
    }

    protected NetCommand[] buildNetCommands(TransferWay transferWay) {
        IPreferenceStore preferences = FastbootPreferences.getPreferenceStore();
        String ethactID = preferences.getString("vendor.burn.config.ethact");
        NetCommand[] commands = null;
        if (ethactID == null) {
            commands = new NetCommand[5];
        }
        if (ethactID != null && ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[0])) {
            commands = new NetCommand[5];
        }
        if (ethactID != null && !ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[0])) {
            commands = new NetCommand[6];
        }
        String serverIp = TFTPPreferences.getPRETFTPSERVERIP();
        if (commands != null) {
            commands[0] = serverIp != null && !serverIp.isEmpty() ? NetCommand.setServerIP(serverIp) : NetCommand.setServerIP(this.localConfig.getServerIp());
            commands[1] = transferWay == TransferWay.UsbTransNet ? NetCommand.setClientMAC("") : NetCommand.setClientMAC(this.getBoardConfig().getMac());
            commands[2] = NetCommand.setClientIP(this.getBoardConfig().getIp());
            commands[3] = NetCommand.setClientNetMask(this.getBoardConfig().getSubnetMask());
            commands[4] = NetCommand.setClientGateway(this.getBoardConfig().getGateway());
            if (ethactID != null) {
                if (ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[0])) {
                    return commands;
                }
                if (ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[1])) {
                    commands[5] = NetCommand.setEthact("0");
                } else if (ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[2])) {
                    commands[5] = NetCommand.setEthact("1");
                } else if (ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[3])) {
                    commands[5] = NetCommand.setEthact("2");
                } else if (ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[4])) {
                    commands[5] = NetCommand.setEthact("3");
                } else {
                    return commands;
                }
            }
        }
        return commands;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean setupNetwork(TransferWay transferWay) throws ReceiveTimeOutException {
        try {
            String usbTransNetCmd;
            if ((transferWay == TransferWay.UsbTransNet || this.burner.getBurnContext().isUsbToEthernet()) && !this.sendCommand(usbTransNetCmd = "usb start")) {
                FastbootBurnerWorker.returnError(Messages.Fastboot_NotSupportUsbTransNetWay);
                return false;
            }
            NetCommand[] commands = this.buildNetCommands(transferWay);
            if (commands == null) {
                return false;
            }
            NetCommand[] netCommandArray = commands;
            int n = commands.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    int port;
                    String changePortCommand;
                    String portConfigurable = PropertiesUtility.queryForString("portConfigurable");
                    if (portConfigurable != null && Boolean.valueOf(portConfigurable).booleanValue() && !this.sendCommand(changePortCommand = "setenv tftpdstp " + String.valueOf(port = CrcCommand.getTFTPPort()))) {
                        return false;
                    }
                    break;
                }
                NetCommand command = netCommandArray[n2];
                if (!this.sendCommand(command)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (IOException iOException) {}
        FastbootView.setStartNetwork(false);
        return true;
    }

    public FlashType loadBootMode() throws ReceiveTimeOutException {
        try {
            if (!this.sendCommand(INFOCommand.getBootmode())) {
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        String strCurrentLog = this.getCurReceived().toLowerCase();
        if (strCurrentLog.indexOf("nand") > -1) {
            return FlashType.nand;
        }
        if (strCurrentLog.indexOf("spi") > -1) {
            return FlashType.spi;
        }
        if (strCurrentLog.indexOf("emmc") > -1) {
            return FlashType.emmc;
        }
        return null;
    }

    public long getBlockSize(FlashType type, ChipID chipID, boolean isFastboot) {
        block17: {
            if (FastbootView.isCJXX0VXX5Series()) {
                if (FlashType.nand == type) {
                    this.setNandBlockSize(4096L);
                } else if (FlashType.spi == type) {
                    this.setSpiBlockSize(4096L);
                }
                return 4096L;
            }
            if (FlashType.emmc == type) {
                return 512L;
            }
            if (FlashType.nand != type && FlashType.spi != type) {
                return 0L;
            }
            try {
                if (this.sendCommand(INFOCommand.info(type))) {
                    String curReceived = this.getCurReceived();
                    this.setStrNandInfo(curReceived);
                    long blockSize = WorkerUtility.ReceiveHelper.getBlockSize(curReceived);
                    if (FlashType.nand == type) {
                        this.setPageSize(WorkerUtility.ReceiveHelper.getPageSize(curReceived));
                        this.setNandBlockSize(blockSize);
                        if (this.isPage() && !isFastboot) {
                            return this.getPageSize();
                        }
                        return this.getNandBlockSize();
                    }
                    if (FlashType.spi == type) {
                        this.setSpiBlockSize(blockSize);
                        return this.getSpiBlockSize();
                    }
                    break block17;
                }
                if (this.burner.getBurnContext().getPlatformType() == PlatformType.CA) {
                    this.setStrNandInfo(this.ubootStartLog);
                    long blockSize = WorkerUtility.ReceiveHelper.getBlockSize(this.ubootStartLog);
                    if (FlashType.nand == type) {
                        this.setPageSize(WorkerUtility.ReceiveHelper.getPageSize(this.ubootStartLog));
                        this.setNandBlockSize(blockSize);
                        if (this.isPage() && !isFastboot) {
                            return this.getPageSize();
                        }
                        return this.getNandBlockSize();
                    }
                    if (FlashType.spi == type) {
                        this.setSpiBlockSize(blockSize);
                        return this.getSpiBlockSize();
                    }
                    break block17;
                }
                return 0L;
            }
            catch (IOException iOException) {
                return 0L;
            }
            catch (ReceiveTimeOutException receiveTimeOutException) {
                return 0L;
            }
        }
        return 0L;
    }

    public long getWriteLength(FlashType flashType, long blockSize, long fileSize) {
        long writeLength = 0L;
        writeLength = fileSize % blockSize != 0L ? blockSize * (fileSize / blockSize + 1L) : fileSize;
        if (flashType == FlashType.emmc) {
            writeLength = (fileSize + blockSize - 1L) / blockSize;
        }
        return writeLength;
    }

    private void sleep(int timeMS) {
        if (timeMS < 1) {
            return;
        }
        try {
            Thread.sleep(timeMS);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected int printBuffer(int offset) {
        int length;
        this.onAdataAvailable(serialReceived);
        if (offset < 0) {
            offset = 0;
        }
        if ((length = serialReceived.length()) > offset) {
            FastbootBurnerWorker.received(serialReceived.substring(offset, length));
        }
        return length;
    }

    protected boolean downloadFileSerial(File file) throws IOException, ReceiveTimeOutException {
        this.infoln("[Download File by Serial]\nfile = " + file.getAbsolutePath() + "\naddress = " + this.getHexStartAddress());
        this.infoln("Serial Download Command = " + file.getCanonicalPath());
        return this.downloadFile(this.getHexStartAddressForInt(), file.getCanonicalPath(), "     ");
    }

    protected boolean downloadFileSerial(SubMonitor subProgressMonitor, File file, boolean isSbl) throws IOException, ReceiveTimeOutException {
        try {
            subProgressMonitor.beginTask("", 100);
            subProgressMonitor.subTask("Serial File Transfer");
            this.infoln("[Download File by Serial]\nfile = " + file.getAbsolutePath() + "\naddress = " + this.getHexStartAddress());
            this.infoln("Serial Download Command = " + file.getAbsolutePath());
            this.infoln("                    length=" + file.length());
            this.infoln("                    isSBL=" + isSbl);
            boolean bl = this.sendByXModem(this.getHexStartAddressForInt(), file.getAbsolutePath());
            return bl;
        }
        finally {
            subProgressMonitor.done();
        }
    }

    public void socketReceived() {
        this.onAdataAvailable(serialReceived);
    }

    public boolean sendByXModem(int bootDdrAddr, String fileName) throws IOException {
        if (this.boardConfig.isSocket()) {
            boolean result = CallLibBootromWorker.createSerialPortServer(this.boardConfig.getSerialServerIp(), this.boardConfig.getSerialServerPort());
            if (!result) {
                this.infoln("Create serial port server failed.");
                return false;
            }
            this.infoln("Create serial port server success." + CallLibBootromWorker.getSocketFd());
            return CallLibBootromWorker.Ymodem_load(CallLibBootromWorker.getSocketFd(), bootDdrAddr, fileName);
        }
        return CallLibBootromWorker.Ymodem_load(CallLibBootromWorker.getComFd(), bootDdrAddr, fileName);
    }

    public static int crc_16(byte[] data) {
        int crc = 0;
        int counter = 0;
        while (counter < data.length) {
            int d = data[counter] & 0xFF;
            crc = crc << 8 ^ crc16_table[(crc >> 8 ^ d) & 0xFF];
            ++counter;
        }
        return crc & 0xFFFF;
    }

    protected boolean upload(SubMonitor subProgressMonitor, File file, String hexAddress, String hexLength) throws IOException, ReceiveTimeOutException {
        int length = Integer.parseInt(hexLength, 16);
        int adress = Integer.parseInt(hexAddress, 16);
        this.infoln("Download :\t" + file.getAbsolutePath());
        FastbootBurnerWorker.deleteContent(serialReceived);
        FastbootBurnerWorker.deleteContent(i2csReceived);
        FastbootBurnerWorker.deleteContent(usbsReceived);
        return this.updateloadFile(this.getHexStartAddressForInt(), adress, length, file.getAbsolutePath());
    }

    public boolean loadVersionInfo(TransferWay transferWay) {
        if (transferWay == TransferWay.UsbAndSerial || FastbootView.isSupportUsbNonNude(transferWay)) {
            this.version = "";
            return true;
        }
        try {
            if (!this.sendCommand(INFOCommand.getVersion())) {
                return false;
            }
        }
        catch (IOException iOException) {
        }
        catch (ReceiveTimeOutException receiveTimeOutException) {}
        this.version = WorkerUtility.ReceiveHelper.getVersion(this.getCurReceived());
        return this.version != null;
    }

    private void loadBlockSizes(FlashType flash, ChipID chipID, boolean isFastboot) {
        if (flash == FlashType.spi) {
            this.getBlockSize(FlashType.spi, chipID, isFastboot);
        }
        if (flash == FlashType.nand) {
            this.getBlockSize(FlashType.nand, chipID, isFastboot);
        }
    }

    /*
     * Exception decompiling
     */
    protected boolean burnSinglePartByI2c(IProgressMonitor uimonitor, File file, String startAddress, FlashType flashType, boolean isNakedBurn, ChipID chipID) throws IOException, ReceiveTimeOutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 12[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void closeI2cAndDeleteTempFile(File compressFile, File comFatherFile) {
        if (compressFile != null && compressFile.exists()) {
            FileUtils.deleteFile(compressFile);
        }
        if (comFatherFile != null && comFatherFile.exists()) {
            FileUtils.deleteFile(comFatherFile);
        }
    }

    protected boolean checkUpgradeStatus(File file, long timeout, int i2cDelay) {
        long oldTime = System.currentTimeMillis();
        long currentTime = 0L;
        boolean burnSuccess = false;
        FastbootBurnerWorker.receivedln("Write data to flash...");
        this.onAdataAvailable(serialReceived);
        while (currentTime - oldTime < timeout) {
            int status = I2cCommand.sendGetUpgradeStatus(i2cDelay, monitor);
            if (status == -1) {
                FastbootBurnerWorker.returnError(Messages.PartitionBurnerWork_I2c_Upgrade_Fail);
                this.onAdataAvailable(serialReceived);
                if (serialReceived != null && serialReceived.length() > 0) {
                    FastbootBurnerWorker.receivedln(serialReceived.toString());
                }
                return false;
            }
            if (status != 0 && status == 1) {
                FastbootBurnerWorker.receivedln("The " + file.getName() + " burning successfully.");
                burnSuccess = true;
                break;
            }
            currentTime = System.currentTimeMillis();
        }
        if (serialReceived != null && serialReceived.length() > 0) {
            FastbootBurnerWorker.receivedln(serialReceived.toString());
        }
        if (!burnSuccess) {
            FastbootBurnerWorker.returnError(Messages.PartitionBurnerWork_I2c_Upgrade_Write_Flash_Timeout);
        }
        return burnSuccess;
    }

    public boolean initBoard(ArrayList<FlashType> hasFlashTypes) throws IOException, ReceiveTimeOutException {
        TransferWay transferWay;
        if (ToolUtils.isDebugOn()) {
            this.println("InitBoard Start");
        }
        if (this.burner.getBurnContext().getPlatformType() == PlatformType.NonCA ? !this.bootDownload(null) : !this.programmerDownload(null, ((AbstractBurner)((Object)this.burner)).getProgrammerFile())) {
            return false;
        }
        this.version = null;
        boolean loadVersionInfo = this.loadVersionInfo(this.burner.getBurnContext().getTransferWay());
        if (!loadVersionInfo || this.version == null) {
            if (this.burner.getBurnContext().getPlatformType() == PlatformType.CA) {
                FastbootBurnerWorker.warningln("Warning: Failed to load version info!");
            } else {
                FastbootBurnerWorker.returnError("Failed to load version info!");
                return false;
            }
        }
        if (this.isNeedSetupNet(transferWay = this.burner.getBurnContext().getTransferWay())) {
            this.setupNetwork(transferWay);
        }
        return true;
    }

    public boolean isNeedSetupNet(TransferWay transferWay) {
        boolean result = transferWay == TransferWay.Net || transferWay == TransferWay.UsbTransNet || transferWay == TransferWay.NetNonNude || transferWay == TransferWay.JTAGAndNet;
        return result;
    }

    protected void switchTFTPDownloadHome(File file) {
        if (file == null) {
            return;
        }
        if (file.isFile()) {
            file = file.getParentFile();
        }
        if (!TFTPService.TFTPSERVICE.isStart()) {
            InetAddress address = null;
            try {
                address = InetAddress.getByName("0.0.0.0");
            }
            catch (UnknownHostException unknownHostException) {}
            int port = FastbootPreferences.getInt("vendor.burn.tftp.port");
            try {
                boolean result = TFTPService.TFTPSERVICE.start(file, address, ToolUtils.getPortCmd(), port);
                if (!result) {
                    FastbootBurnerWorker.warningln(Messages.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
                }
            }
            catch (SocketException socketException) {}
        }
        if (file.isDirectory()) {
            TFTPService.TFTPSERVICE.setServerDirectory(file);
            this.infoln("\tTftp server Download Home switched to <" + file.getAbsolutePath() + ">");
        }
    }

    protected File copyComFileToToolPath(IProgressMonitor uiMonitor, File file) {
        boolean tftpOccupied = this.burner.getBurnContext().isTftpOccupied();
        String partFilePath = null;
        String toolPath = null;
        if (tftpOccupied) {
            partFilePath = file.getPath();
        } else {
            toolPath = ToolUtils.getInstallPath();
            partFilePath = String.valueOf(toolPath) + File.separator + file.getName();
        }
        File partFile = new File(partFilePath);
        boolean copy = FileUtils.copy(uiMonitor, file, partFile);
        if (!copy) {
            FastbootBurnerWorker.returnError(NLS.bind((String)Messages.ERROR_INFO_DISK_SPACE_LOW, (Object)partFile));
            return null;
        }
        return partFile;
    }

    public void printCrcValue(File file) {
        if (!FastbootView.isCJXX1Series()) {
            return;
        }
        if (file == null) {
            return;
        }
        try {
            long crcValue = CrcCommand.calculateCRC16(file);
            this.infoln("\nCRC: " + file.getName() + " " + "0x" + Long.toHexString(crcValue));
        }
        catch (IOException iOException) {}
    }

    protected void getTempFileDivisionSize(TransferWay curTransferWay) throws IOException, ReceiveTimeOutException {
        String ddrFreeSizeStr = this.getDDRFreeParam();
        long ddrFreeSize = this.parseLong(this.getDDRFreeParam("size:", ddrFreeSizeStr, curTransferWay));
        String ddrInitSize = this.getHexStartAddress();
        if (ddrInitSize.startsWith("0x")) {
            ddrInitSize = ddrInitSize.substring(ddrInitSize.indexOf("0x") + "0x".length());
        }
        long preferemcesSplitFileSize = ToolUtils.getTftpSplitFileSize();
        tempFileDivisionSize = ddrFreeSize == 0L ? preferemcesSplitFileSize : (ddrFreeSize / 2L > 0x2000000L ? (ddrFreeSize - Long.parseLong(ddrInitSize, 16)) / 2L : (ddrFreeSize / 2L < 0x2000000L ? ddrFreeSize : 0x2000000L));
    }

    public BoardConfig getBoardConfig() {
        return this.boardConfig;
    }
}

