/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.serial.workers;

import com.vendor.burn.Messages;
import com.vendor.burn.analysis.TimeLogger;
import com.vendor.burn.commands.EraseCommand;
import com.vendor.burn.commands.I2cCommand;
import com.vendor.burn.commands.MWCommand;
import com.vendor.burn.commands.SFCommand;
import com.vendor.burn.commands.UnZipCommand;
import com.vendor.burn.commands.WriteCommand;
import com.vendor.burn.model.ChipID;
import com.vendor.burn.model.FileSystem;
import com.vendor.burn.model.FlashType;
import com.vendor.burn.model.PartitionItem;
import com.vendor.burn.model.PlatformType;
import com.vendor.burn.model.TransferWay;
import com.vendor.burn.model.config.BurnConfig;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.devices.burners.AbstractBurner;
import com.vendor.burn.model.devices.burners.CommonBurner;
import com.vendor.burn.model.devices.burners.PartitionBurner;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import com.vendor.burn.model.event.EventType;
import com.vendor.burn.model.receive.ReceiveTimeOutException;
import com.vendor.burn.model.struct.XmodelParameter;
import com.vendor.burn.preferences.FastbootPreferences;
import com.vendor.burn.serial.workers.AddressBurnerWorker;
import com.vendor.burn.serial.workers.CallLibJTAGWorker;
import com.vendor.burn.serial.workers.CallLibUSBWorker;
import com.vendor.burn.serial.workers.WorkerUtility;
import com.vendor.burn.thirdparty.ZlibCRC32;
import com.vendor.burn.utilitily.BufferedRandomAccessFile;
import com.vendor.burn.utilitily.BytesUtils;
import com.vendor.burn.utilitily.FileUtils;
import com.vendor.burn.utilitily.GZipUtils;
import com.vendor.burn.utilitily.StringUtils;
import com.vendor.burn.utilitily.ToolUtils;
import com.vendor.burn.views.FastbootView;
import com.vendor.platform.api.statistics.ToolStatistics;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class PartitionBurnerWorker
extends AddressBurnerWorker {
    private static long bootargsFileLen = 0L;
    protected static final int SECTOR_SIZE = 512;
    protected static final int UFS_SIZE = 4096;
    private static long tempFileDivisionSize = 0L;
    protected String tmpBootargsString;
    protected static final int UIMONITOR_100 = 100;
    protected static final int UIMONITOR_50 = 50;
    protected static final int EMPTY_LEN = 0x500000;

    public PartitionBurnerWorker(IBurner burner) {
        super(burner);
    }

    public boolean burn(IProgressMonitor uimonitor, List<PartitionItem> parts) throws IOException, ReceiveTimeOutException {
        ToolStatistics.INSTANCE.logUsage("BurnTool", "Burn Partition", "ChipName: " + this.burner.getBurnContext().getDeviceSetting().getName());
        ToolStatistics.INSTANCE.logToolInUse("BurnTool");
        String versionInfo = this.getVersionInfo("Burn Partition");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        if (UnknownDevice.isOpenLightDebug()) {
            this.initLightState();
        }
        this.tftpTimeLogger = new TimeLogger();
        this.burnTimeLogger = new TimeLogger();
        long burnStartTime = 0L;
        burnStartTime = System.currentTimeMillis();
        this.setProgressMonitor(uimonitor);
        PartitionBurnerWorker.getMonitor().getEvent().init(EventType.BURN);
        int selectedPartCount = 0;
        for (PartitionItem partitionItem : parts) {
            if (!partitionItem.isChecked()) continue;
            ++selectedPartCount;
        }
        this.isSetGsl(parts);
        uimonitor.beginTask("Burn By Partition", 100 * selectedPartCount);
        try {
            ArrayList<FlashType> hasFlashTypes = new ArrayList<FlashType>();
            for (PartitionItem partitionItem : parts) {
                FlashType flashType;
                if (!partitionItem.isChecked() || hasFlashTypes.contains((Object)(flashType = partitionItem.getFlashType()))) continue;
                hasFlashTypes.add(flashType);
            }
            boolean result = this.burnByTransferWay(uimonitor, parts, selectedPartCount, hasFlashTypes);
            this.printLog(burnStartTime);
            boolean bl = result;
            return bl;
        }
        finally {
            this.printPartsCrcValue(parts);
            uimonitor.done();
        }
    }

    private void printPartsCrcValue(List<PartitionItem> parts) {
        if (parts == null) {
            return;
        }
        for (PartitionItem partitionItem : parts) {
            File file;
            if (!partitionItem.isChecked() || (file = partitionItem.getFile()) == null) continue;
            this.printCrcValue(file);
        }
    }

    private boolean burnByTransferWay(IProgressMonitor uimonitor, List<PartitionItem> parts, int selectedPartCount, ArrayList<FlashType> hasFlashTypes) throws IOException, ReceiveTimeOutException {
        PartitionItem fastboot = parts.get(0);
        boolean result = true;
        TransferWay curTransferWay = this.getBurner().getBurnContext().getTransferWay();
        if (curTransferWay == TransferWay.Uart2Compress) {
            result = this.burnByUart2Compress(uimonitor, parts, hasFlashTypes, fastboot, curTransferWay);
            if (!result) {
                return result;
            }
            this.sendCommandToSetMac();
            String resetCommand = "reset";
            this.sendCommandNoReturnValue(resetCommand);
        } else if (curTransferWay == TransferWay.Usb2I2c || curTransferWay == TransferWay.I2CBootrom) {
            this.i2cTimeLogger = new TimeLogger();
            this.flashTimeLogger = new TimeLogger();
            this.resetTimeLogger = new TimeLogger();
            result = this.burnByI2c(uimonitor, parts, fastboot, result, hasFlashTypes, selectedPartCount);
            if (ToolUtils.isDebugOn()) {
                PartitionBurnerWorker.getMonitor().println(this.i2cTimeLogger.exportLog("I2C transmission time"));
                PartitionBurnerWorker.getMonitor().println(this.flashTimeLogger.exportLog("Burning Flash of time"));
                PartitionBurnerWorker.getMonitor().println(this.resetTimeLogger.exportLog("Reset time"));
            }
            if (!result) {
                return result;
            }
        } else if (curTransferWay == TransferWay.USBNonNude) {
            result = this.burnPartsByUSBNonNudeForNandOrSpi(uimonitor, parts, selectedPartCount, hasFlashTypes, fastboot);
            if (!result) {
                return result;
            }
            this.sendCommandToSetMac();
            String resetCommand = "reset";
            this.sendCommandNoReturnValue(resetCommand);
        } else {
            boolean isResetJtag;
            result = this.burnByOtherTransferWay(uimonitor, parts, selectedPartCount, hasFlashTypes, fastboot);
            if (!result) {
                return result;
            }
            this.sendCommandToSetMac();
            boolean bl = isResetJtag = !(!FastbootView.isCJXX0VXX5Series() && !FastbootView.isCJ3X0VXX1Series() && !FastbootView.isCJ3X1VXX8E_Series() || curTransferWay != TransferWay.JTAG && curTransferWay != TransferWay.JTAGAndNet && curTransferWay != TransferWay.JTAGAndSerial);
            if (!isResetJtag) {
                String resetCommand = "reset";
                this.sendCommandNoReturnValue(resetCommand);
            }
        }
        this.infoln("Partition burnt completed!");
        return result;
    }

    protected boolean burnByUart2Compress(IProgressMonitor uimonitor, List<PartitionItem> parts, ArrayList<FlashType> hasFlashTypes, PartitionItem fastboot, TransferWay curTransferWay) throws IOException, ReceiveTimeOutException {
        PartitionBurnerWorker.getMonitor().highlight(fastboot);
        uimonitor.setTaskName("Burn boot");
        uimonitor.setTaskName("Prepare to Burn");
        boolean result = this.prepareToBurn(false, EventType.BURN, hasFlashTypes);
        if (!result) {
            PartitionBurnerWorker.returnError("Failed to Prepare for other partitions!");
            return false;
        }
        this.getTempFileDivisionSize(curTransferWay);
        uimonitor.setTaskName("Burning Partitions");
        int partsSize = parts.size();
        int index = 0;
        while (index < partsSize) {
            PartitionItem partitionItem = parts.get(index);
            boolean isBootargsNeedChanged = false;
            if (!ToolUtils.isCmdLine() && FastbootPreferences.isUpdateBootargsOn()) {
                isBootargsNeedChanged = true;
            }
            if (!partitionItem.isChecked()) {
                if (isBootargsNeedChanged && partitionItem.getName().equalsIgnoreCase("bootargs")) {
                    PartitionBurnerWorker.warningln("Bootargs partition has not been checked, so the automatic update bootargs is not successful!");
                }
            } else {
                this.switchTFTPDownloadHome(partitionItem.getFile());
                PartitionBurnerWorker.getMonitor().highlight(partitionItem);
                long partStart = partitionItem.getStart();
                long partLength = partitionItem.getLength();
                FlashType flashType = partitionItem.getFlashType();
                long startSector = partStart / 512L;
                if (index == partsSize - 1 && partLength == -1L && (partLength = this.getLastPartitionLen(partitionItem, partStart, partLength, flashType, startSector)) == -1L) {
                    return false;
                }
                result = this.burnPart(SubMonitor.convert((IProgressMonitor)uimonitor, (String)"", (int)20), partitionItem, parts);
                if (!result) {
                    return result;
                }
            }
            ++index;
        }
        return result;
    }

    protected boolean burnByI2c(IProgressMonitor uimonitor, List<PartitionItem> parts, PartitionItem fastboot, boolean result, ArrayList<FlashType> hasFlashTypes, int selectedPartCount) throws IOException, ReceiveTimeOutException {
        PartitionBurnerWorker.getMonitor().highlight(fastboot);
        uimonitor.setTaskName("Burn boot");
        if (this.burner.getBurnContext().getTransferWay() == TransferWay.I2CBootrom) {
            uimonitor.setTaskName("Prepare to Burn");
            if (fastboot.isChecked()) {
                PartitionBurnerWorker.getMonitor().highlight(fastboot);
                uimonitor.setTaskName("Burn boot");
                result = this.burnNudeBoard(SubMonitor.convert((IProgressMonitor)uimonitor, (String)"", (int)100), fastboot, hasFlashTypes, null, true);
                if (!result) {
                    return false;
                }
                if (selectedPartCount == 1) {
                    if (this.resetTimeLogger != null) {
                        this.resetTimeLogger.logStart("Start send reset", 0L);
                    }
                    String resetCommand = "reset";
                    this.sendCommandNoReturnValue(resetCommand);
                    this.infoln("Partition Burning completed!");
                    uimonitor.done();
                    if (this.resetTimeLogger != null) {
                        this.resetTimeLogger.logEnd();
                    }
                    return true;
                }
                if (!FastbootView.isCJXX1Series()) {
                    String resetCommand = "reset";
                    this.sendCommandNoReturnValue(resetCommand);
                }
                I2cCommand.I2cCloseChannel();
                this.infoln("\nI2C channels were closed successfully.");
                long startTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - startTime < 5000L) {
                }
            } else if (FastbootView.isCJXX1Series() || FastbootView.isCJ303V300()) {
                uimonitor.setTaskName("Prepare to Burn");
                result = this.prepareToBurn(fastboot.isChecked(), EventType.BURN, hasFlashTypes);
                if (!result) {
                    PartitionBurnerWorker.returnError("Failed to Prepare for other partitions!");
                    return false;
                }
                I2cCommand.I2cCloseChannel();
                this.infoln("\nI2C channels were closed successfully.");
            }
            if (this.isOnlyBurnBoot(parts, parts.size())) {
                return true;
            }
        }
        result = this.burnByUSB2I2C(uimonitor, parts);
        return result;
    }

    private boolean burnByUSB2I2C(IProgressMonitor uimonitor, List<PartitionItem> parts) throws IOException, ReceiveTimeOutException {
        int startIndex;
        boolean result = true;
        int partsSize = parts.size();
        uimonitor.setTaskName("Burning Partitions");
        if (!I2cCommand.I2cOpenChannel()) {
            return false;
        }
        this.infoln("\nI2C channels open success, the bit rate is " + I2cCommand.getBaudRate() + ", device address is 0x" + Integer.toHexString(I2cCommand.getDeviceAddress()));
        uimonitor.setTaskName("Burning Partitions");
        if (!this.getLastPartitionLen(parts, partsSize)) {
            return false;
        }
        int i2cDelay = FastbootPreferences.getInt("vendor.burn.i2c.delay");
        uimonitor.setTaskName("Burning Partitions");
        int index = startIndex = this.burner.getBurnContext().getTransferWay() == TransferWay.Usb2I2c ? 0 : 1;
        while (index < partsSize) {
            boolean handleCancel;
            if (uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
                this.closeI2cAndDeleteTempFile(null, null);
                return false;
            }
            PartitionItem partitionItem = parts.get(index);
            PartitionBurnerWorker.getMonitor().highlight(partitionItem);
            File file = partitionItem.getFile();
            if (partitionItem.isChecked()) {
                boolean fileVaild;
                boolean bl = fileVaild = file == null || !file.exists();
                if (fileVaild) {
                    this.printWarnToPartition(index, partitionItem);
                } else {
                    SubMonitor subProgressMonitor = SubMonitor.convert((IProgressMonitor)uimonitor, (String)"", (int)100);
                    long partStart = partitionItem.getStart();
                    String name = partitionItem.getName();
                    File partFile = this.copyComFileToToolPath(uimonitor, file);
                    if (partFile == null) {
                        return false;
                    }
                    File compressFile = GZipUtils.compress(uimonitor, partFile, false, true);
                    if (compressFile == null) {
                        PartitionBurnerWorker.returnError(NLS.bind((String)Messages.ERROR_INFO_DISK_SPACE_LOW, (Object)partFile));
                        return false;
                    }
                    long compressFileLen = compressFile.length();
                    try (BufferedRandomAccessFile inFile = null;){
                        boolean bl2;
                        inFile = new BufferedRandomAccessFile(compressFile, "r");
                        result = I2cCommand.sendUpgradeStart((int)compressFileLen, true);
                        if (!result) {
                            this.closeI2cAndDeleteTempFile(compressFile, partFile);
                            bl2 = result;
                            return bl2;
                        }
                        if (!(result = this.sendUpgradeRun(uimonitor, result, i2cDelay, subProgressMonitor, partStart, name, partFile, compressFile, compressFileLen, inFile))) {
                            this.closeI2cAndDeleteTempFile(compressFile, partFile);
                            bl2 = result;
                            return bl2;
                        }
                    }
                    PartitionBurnerWorker.receivedln(" ---- 100%");
                    ChipID chipID = partitionItem.getChipID();
                    result = I2cCommand.sendUpgradeFinish((int)partStart, chipID);
                    if (!result) {
                        this.closeI2cAndDeleteTempFile(compressFile, partFile);
                        return result;
                    }
                    int waitWriteTimeout = FastbootPreferences.getI2cTimeout();
                    result = this.checkUpgradeStatus(file, waitWriteTimeout, i2cDelay);
                    if (!result) {
                        this.closeI2cAndDeleteTempFile(compressFile, partFile);
                        return result;
                    }
                    FileUtils.deleteFile(compressFile);
                    FileUtils.deleteFile(partFile);
                }
            }
            ++index;
        }
        this.sendCommandToSetMac();
        this.closeI2cAndDeleteTempFile(null, null);
        if (FastbootView.isCJXX1Series() && this.burner.getBurnContext().getTransferWay() == TransferWay.I2CBootrom) {
            I2cCommand.I2cCloseChannel();
            this.infoln("\nI2C channels were closed successfully.");
            if (I2cCommand.I2cOpenChannelForBootrom(52, PartitionBurnerWorker.getMonitor())) {
                this.infoln("\nI2C channels open success, the bit rate is " + I2cCommand.getBaudRate() + ", device address is 0x" + Integer.toHexString(52));
            }
            String resetCommand = "reset";
            this.sendCommandNoReturnValue(resetCommand);
        }
        return result;
    }

    private boolean sendUpgradeRun(IProgressMonitor uimonitor, boolean result, int i2cDelay, SubMonitor subProgressMonitor, long partStart, String name, File partFile, File compressFile, long compressFileLen, BufferedRandomAccessFile inFile) throws IOException {
        int dataCount = (int)((compressFileLen + 124L - 1L) / 124L);
        int dataSpace = (int)compressFileLen % 124;
        this.printI2cLog(uimonitor, subProgressMonitor, partStart, name, compressFile, compressFileLen, dataCount);
        int totalOffset = 0;
        double rateLast = 0.0;
        int total = (int)compressFileLen;
        byte[] data = new byte[124];
        int upgradeIndex = 0;
        if (dataCount == 0) {
            int read = inFile.read(data, 0, data.length);
            if (read != data.length) {
                return false;
            }
            result = I2cCommand.sendUpgradeRun(upgradeIndex, data);
            if (!result) {
                this.closeI2cAndDeleteTempFile(compressFile, partFile);
                return result;
            }
            ++upgradeIndex;
        } else {
            int j = 0;
            while (j < dataCount) {
                boolean needPrint;
                int status;
                boolean handleCancel;
                if (uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
                    this.closeI2cAndDeleteTempFile(compressFile, partFile);
                    return false;
                }
                int len = 0;
                if (j == dataCount - 1) {
                    if (dataSpace == 0) {
                        len = 124;
                    } else {
                        len = dataSpace;
                        data = new byte[124];
                    }
                } else {
                    len = 124;
                }
                int read = inFile.read(data, 0, len);
                if (read != len) {
                    return false;
                }
                if (upgradeIndex == 256) {
                    upgradeIndex = 0;
                }
                if (!(result = I2cCommand.sendUpgradeRun(upgradeIndex, data))) {
                    this.closeI2cAndDeleteTempFile(compressFile, partFile);
                    return result;
                }
                if (upgradeIndex != 0 && upgradeIndex % 10 == 0 && (status = I2cCommand.sendGetUpgradeStatus(i2cDelay, monitor)) == -1) {
                    this.closeI2cAndDeleteTempFile(compressFile, partFile);
                    PartitionBurnerWorker.returnError(Messages.PartitionBurnerWork_I2c_Upgrade_Fail);
                    return false;
                }
                ++upgradeIndex;
                PartitionBurnerWorker.received("#");
                double temp = (double)(totalOffset += len) * 100.0 / (double)total;
                boolean bl = needPrint = temp - rateLast >= 1.0 && (int)temp != 100;
                if (needPrint) {
                    PartitionBurnerWorker.receivedln(" ---- " + (int)temp + "%");
                    rateLast = temp;
                }
                subProgressMonitor.worked(1);
                ++j;
            }
        }
        return result;
    }

    private void printI2cLog(IProgressMonitor uimonitor, SubMonitor subProgressMonitor, long partStart, String name, File compressFile, long compressFileLen, int dataCount) {
        uimonitor.setTaskName("Downloading File");
        subProgressMonitor.beginTask("Burn the " + name, dataCount);
        subProgressMonitor.setTaskName("Downloading File");
        this.infoln("\n[Download File by I2c]");
        this.infoln("file = " + compressFile.getAbsolutePath());
        this.infoln("address = " + partStart);
        this.infoln("fileLength = " + compressFileLen);
    }

    private void printWarnToPartition(int index, PartitionItem partitionItem) {
        if (partitionItem.getName() != null) {
            PartitionBurnerWorker.warningln(NLS.bind((String)Messages.PartitionBurnerWork_I2c_Not_Exist, (Object)partitionItem.getName()));
        } else {
            PartitionBurnerWorker.warningln(NLS.bind((String)Messages.PartitionBurnerWork_I2c_Not_Exist, (Object)("The Line " + (index + 1) + " file")));
        }
    }

    private boolean getLastPartitionLen(List<PartitionItem> parts, int partsSize) {
        long lastPartitionLen;
        PartitionItem lastPartitionItem = parts.get(partsSize - 1);
        if (lastPartitionItem.isChecked() && (lastPartitionLen = lastPartitionItem.getLength()) == -1L && !this.checkLastPartition(parts)) {
            PartitionBurnerWorker.returnError(Messages.PartitionBurnerWork_GetLastPartitionLen_Fail);
            this.closeI2cAndDeleteTempFile(null, null);
            return false;
        }
        return true;
    }

    private boolean isOnlyBurnBoot(List<PartitionItem> parts, int partsSize) {
        boolean onlyBootChecked = true;
        int index = 1;
        while (index < partsSize) {
            PartitionItem partitionItem = parts.get(index);
            PartitionBurnerWorker.getMonitor().highlight(partitionItem);
            if (partitionItem.isChecked()) {
                onlyBootChecked = false;
                break;
            }
            ++index;
        }
        return onlyBootChecked;
    }

    private boolean burnByOtherTransferWay(IProgressMonitor uimonitor, List<PartitionItem> parts, int selectedPartCount, ArrayList<FlashType> hasFlashTypes, PartitionItem fastboot) throws IOException, ReceiveTimeOutException {
        boolean result;
        SubMonitor subProgressMonitor = SubMonitor.convert((IProgressMonitor)uimonitor, (String)"", (int)100);
        this.registerJnaFunction(uimonitor, 100);
        if (fastboot.isChecked()) {
            PartitionBurnerWorker.getMonitor().highlight(fastboot);
            uimonitor.setTaskName("Burn boot");
            result = this.burnNudeBoard(subProgressMonitor, fastboot, hasFlashTypes, parts, true);
            if (!result) {
                return false;
            }
            if (selectedPartCount == 1) {
                this.infoln("Partition Burning completed!");
                uimonitor.done();
                return true;
            }
        }
        uimonitor.setTaskName("Prepare to Burn");
        result = this.prepareToBurn(fastboot.isChecked(), EventType.BURN, hasFlashTypes);
        if (!result) {
            PartitionBurnerWorker.returnError("Failed to Prepare for other partitions!");
            return false;
        }
        uimonitor.setTaskName("Burning Partitions");
        int partsSize = parts.size();
        int index = 1;
        while (index < partsSize) {
            PartitionItem partitionItem = parts.get(index);
            boolean isBootargsNeedChanged = false;
            if (!ToolUtils.isCmdLine() && FastbootPreferences.isUpdateBootargsOn()) {
                isBootargsNeedChanged = true;
            }
            if (!partitionItem.isChecked()) {
                if (isBootargsNeedChanged && partitionItem.getName().equalsIgnoreCase("bootargs")) {
                    PartitionBurnerWorker.warningln("Bootargs partition has not been checked, so the automatic update bootargs is not successful!");
                }
            } else {
                this.switchTFTPDownloadHome(partitionItem.getFile());
                PartitionBurnerWorker.getMonitor().highlight(partitionItem);
                long partStart = partitionItem.getStart();
                long partLength = partitionItem.getLength();
                FlashType flashType = partitionItem.getFlashType();
                long startSector = partStart / 512L;
                if (index == partsSize - 1 && partLength == -1L && (partLength = this.getLastPartitionLen(partitionItem, partStart, partLength, flashType, startSector)) == -1L) {
                    return false;
                }
                result = this.burnPart(subProgressMonitor, partitionItem, parts);
                if (!result) {
                    return result;
                }
            }
            ++index;
        }
        return result;
    }

    protected boolean burnEachPartForNandOrSpi(IProgressMonitor uimonitor, List<PartitionItem> parts, int index) throws IOException, ReceiveTimeOutException {
        int partsSize = parts.size();
        PartitionItem partitionItem = parts.get(index);
        boolean isBootargsNeedChanged = false;
        if (!ToolUtils.isCmdLine() && FastbootPreferences.isUpdateBootargsOn()) {
            isBootargsNeedChanged = true;
        }
        if (!partitionItem.isChecked()) {
            if (isBootargsNeedChanged && partitionItem.getName().equalsIgnoreCase("bootargs")) {
                PartitionBurnerWorker.warningln("Bootargs partition has not been checked, so the automatic update bootargs is not successful!");
            }
            return true;
        }
        this.switchTFTPDownloadHome(partitionItem.getFile());
        PartitionBurnerWorker.getMonitor().highlight(partitionItem);
        long partStart = partitionItem.getStart();
        long partLength = partitionItem.getLength();
        FlashType flashType = partitionItem.getFlashType();
        long startSector = partStart / 512L;
        if (index == partsSize - 1 && partLength == -1L && (partLength = this.getLastPartitionLen(partitionItem, partStart, partLength, flashType, startSector)) == -1L) {
            return false;
        }
        return this.burnPart(SubMonitor.convert((IProgressMonitor)uimonitor, (String)"", (int)100), partitionItem, parts);
    }

    private boolean burnPartsByUSBNonNudeForNandOrSpi(IProgressMonitor uimonitor, List<PartitionItem> parts, int selectedPartCount, ArrayList<FlashType> hasFlashTypes, PartitionItem fastboot) throws IOException, ReceiveTimeOutException {
        boolean result = false;
        result = this.bootromByNonNude(uimonitor);
        if (!result) {
            return false;
        }
        if (fastboot.isChecked()) {
            result = this.downloadBootByUSB(uimonitor, fastboot.getFile(), this.burner.getBurnContext().getTransferWay());
            if (!result) {
                return false;
            }
            this.burnbootByUSBNonNude(SubMonitor.convert((IProgressMonitor)uimonitor, (String)"", (int)100), selectedPartCount, hasFlashTypes, fastboot);
        } else if (this.loadVersionInfo(this.burner.getBurnContext().getTransferWay())) {
            this.loadBlockSizes(hasFlashTypes, fastboot.getChipID(), false);
        } else if (this.burner.getBurnContext().getPlatformType() == PlatformType.CA) {
            this.loadBlockSizes(hasFlashTypes, fastboot.getChipID(), false);
            PartitionBurnerWorker.warningln("Warning: Failed to load version info!");
        } else {
            PartitionBurnerWorker.returnError("Failed to load version info!");
            return false;
        }
        uimonitor.setTaskName("Burning Partitions");
        int partsSize = parts.size();
        int index = 1;
        while (index < partsSize) {
            PartitionItem partitionItem = parts.get(index);
            boolean isBootargsNeedChanged = false;
            if (!ToolUtils.isCmdLine() && FastbootPreferences.isUpdateBootargsOn()) {
                isBootargsNeedChanged = true;
            }
            if (!partitionItem.isChecked()) {
                if (isBootargsNeedChanged && partitionItem.getName().equalsIgnoreCase("bootargs")) {
                    PartitionBurnerWorker.warningln("Bootargs partition has not been checked, so the automatic update bootargs is not successful!");
                }
            } else {
                PartitionBurnerWorker.getMonitor().highlight(partitionItem);
                long partStart = partitionItem.getStart();
                long partLength = partitionItem.getLength();
                FlashType flashType = partitionItem.getFlashType();
                long startSector = partStart / 512L;
                if (index == partsSize - 1 && partLength == -1L && (partLength = this.getLastPartitionLen(partitionItem, partStart, partLength, flashType, startSector)) == -1L) {
                    return false;
                }
                result = this.burnPart(SubMonitor.convert((IProgressMonitor)uimonitor, (String)"", (int)100), partitionItem, parts);
                if (!result) {
                    return result;
                }
            }
            ++index;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean burnbootForNandOrSpi(IProgressMonitor uimonitor, List<PartitionItem> parts, int selectedPartCount, ArrayList<FlashType> hasFlashTypes, PartitionItem fastboot, TransferWay curTransferWay) throws IOException, ReceiveTimeOutException {
        boolean result = false;
        if (curTransferWay == TransferWay.USBNonNude) {
            if (FastbootView.isCJ309V100_CA_N_Series()) {
                boolean openUsbResult = CallLibUSBWorker.openUsb(uimonitor, 30000L, curTransferWay, BurnConfig.getUsbSerialNumber());
                if (!openUsbResult) {
                    PartitionBurnerWorker.returnError("Failed to open usb!");
                    this.infoln("Failed to open usb!");
                    return false;
                }
            } else {
                result = this.bootromByNonNude(uimonitor);
                if (!result) {
                    return false;
                }
            }
            if (fastboot.isChecked()) {
                result = this.downloadBootByUSB(uimonitor, fastboot.getFile(), this.burner.getBurnContext().getTransferWay());
                if (!result) {
                    return false;
                }
                this.burnbootByUSBNonNude(SubMonitor.convert((IProgressMonitor)uimonitor, (String)"", (int)100), selectedPartCount, hasFlashTypes, fastboot);
                return result;
            }
            if (this.loadVersionInfo(this.burner.getBurnContext().getTransferWay())) {
                this.loadBlockSizes(hasFlashTypes, fastboot.getChipID(), false);
                return result;
            }
            if (this.burner.getBurnContext().getPlatformType() == PlatformType.CA) {
                this.loadBlockSizes(hasFlashTypes, fastboot.getChipID(), false);
                PartitionBurnerWorker.warningln("Warning: Failed to load version info!");
                return result;
            }
            PartitionBurnerWorker.returnError("Failed to load version info!");
            return false;
        }
        if (fastboot.isChecked()) {
            PartitionBurnerWorker.getMonitor().highlight(fastboot);
            uimonitor.setTaskName("Burn boot");
            result = this.burnNudeBoard(SubMonitor.convert((IProgressMonitor)uimonitor, (String)"", (int)100), fastboot, hasFlashTypes, parts, true);
            if (!result) {
                return false;
            }
            if (selectedPartCount == 1) {
                this.infoln("Partition Burning completed!");
                uimonitor.done();
                return true;
            }
        }
        uimonitor.setTaskName("Prepare to Burn");
        result = this.prepareToBurn(fastboot.isChecked(), EventType.BURN, hasFlashTypes);
        if (result) return result;
        PartitionBurnerWorker.returnError("Failed to Prepare for other partitions!");
        return false;
    }

    private boolean burnbootByUSBNonNude(SubMonitor subProgressMonitor, int selectedPartCount, ArrayList<FlashType> hasFlashTypes, PartitionItem fastboot) throws ReceiveTimeOutException, IOException {
        PartitionBurnerWorker.getMonitor().highlight(fastboot);
        this.uimonitor.setTaskName("Burn boot");
        FlashType flashType = fastboot.getFlashType();
        subProgressMonitor.setTaskName("Loading Version Info");
        if (this.loadVersionInfo(this.burner.getBurnContext().getTransferWay())) {
            FlashType bootMode = this.loadBootMode();
            if (bootMode != null && flashType != bootMode) {
                PartitionBurnerWorker.returnError(NLS.bind((String)Messages.ERROR_INFO_Invalid_Mode_And_RealMode, (Object)bootMode.name()));
                return false;
            }
            subProgressMonitor.worked(5);
            subProgressMonitor.setTaskName("Loading Block Size");
            this.loadBlockSizes(hasFlashTypes, fastboot.getChipID(), false);
            subProgressMonitor.worked(5);
        } else if (this.burner.getBurnContext().getPlatformType() == PlatformType.CA) {
            subProgressMonitor.worked(5);
            subProgressMonitor.setTaskName("Loading Block Size");
            this.loadBlockSizes(hasFlashTypes, fastboot.getChipID(), false);
            subProgressMonitor.worked(5);
            PartitionBurnerWorker.warningln("Warning: Failed to load version info!");
        } else {
            PartitionBurnerWorker.returnError("Failed to load version info!");
            return false;
        }
        long uLength = fastboot.getLength();
        if (FlashType.spi == flashType && 0L != this.getSpiBlockSize() && uLength % this.getSpiBlockSize() != 0L) {
            String error = "Please check partition length of '" + fastboot.getName() + "'!" + "(" + "should be " + this.getSpiBlockSize() + " * n)";
            PartitionBurnerWorker.returnError(error);
            return false;
        }
        long blockSize = 0L;
        if (FlashType.spi == flashType) {
            blockSize = this.getSpiBlockSize();
        } else {
            blockSize = this.getNandBlockSize();
            if (this.isPage()) {
                blockSize = this.getPageSize();
            }
        }
        if (0L == blockSize) {
            PartitionBurnerWorker.returnError("Invalid " + flashType.name() + " flash block size!");
            return false;
        }
        if (uLength % blockSize != 0L) {
            String error = "Please check partition length of '" + fastboot.getName() + "'!" + "(" + "should be " + blockSize + " * n)";
            PartitionBurnerWorker.returnError(error);
            return false;
        }
        long fileSize = fastboot.getFile().length();
        long writeLength = 0L;
        writeLength = fileSize % blockSize != 0L ? blockSize * (fileSize / blockSize + 1L) : fileSize;
        if (!this.bootBurn(SubMonitor.convert((IProgressMonitor)this.uimonitor, (String)"", (int)20), flashType, Long.toHexString(uLength), Long.toHexString(writeLength), fastboot.getChipID())) {
            PartitionBurnerWorker.returnError("Failed to burn fastboot partition!");
            return false;
        }
        if (selectedPartCount == 1) {
            this.infoln("Partition Burning completed!");
            this.uimonitor.done();
            return true;
        }
        return true;
    }

    public boolean prepareToBurn(boolean bootLoaded, EventType eventType, ArrayList<FlashType> hasFlashTypes) throws IOException, ReceiveTimeOutException {
        boolean result = true;
        if (!bootLoaded) {
            if (((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) {
                if (!this.programmerDownload(null, ((AbstractBurner)((Object)this.burner)).getProgrammerFile())) {
                    PartitionBurnerWorker.returnError("Failed to download fastboot!");
                    return false;
                }
            } else {
                result = this.burner.getBurnContext().getPlatformType() == PlatformType.NonCA ? this.bootDownload(null) : this.programmerDownload(null, ((AbstractBurner)((Object)this.burner)).getProgrammerFile());
                if (!result) {
                    PartitionBurnerWorker.returnError("Failed to Download Boot!");
                    return false;
                }
            }
            if (!this.startFastbootUsbTransferWay(this.uimonitor, this.burner.getBurnContext().getTransferWay())) {
                return false;
            }
            if (this.loadVersionInfo(this.burner.getBurnContext().getTransferWay())) {
                this.loadBlockSizes(hasFlashTypes, ChipID.chip0, false);
            } else if (this.burner.getBurnContext().getPlatformType() == PlatformType.CA) {
                this.loadBlockSizes(hasFlashTypes, ChipID.chip0, false);
                PartitionBurnerWorker.warningln("Warning: Failed to load version info!");
            } else {
                PartitionBurnerWorker.returnError("Failed to load version info!");
                return false;
            }
        }
        if (EventType.BURN == eventType || EventType.UPLOAD == eventType) {
            TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
            if (this.isNeedSetupNet(transferWay)) {
                return result && this.setupNetwork(transferWay);
            }
            return result;
        }
        return result;
    }

    public boolean burnNudeBoard(SubMonitor subProgressMonitor, PartitionItem first, ArrayList<FlashType> hasFlashTypes, List<PartitionItem> parts, boolean isFastboot) throws IOException, ReceiveTimeOutException {
        try {
            subProgressMonitor.beginTask("", 100);
            subProgressMonitor.setTaskName("Downloading Boot");
            if (this.i2cTimeLogger != null && first.getFile() != null) {
                this.i2cTimeLogger.logStart("Download boot via I2C", first.getFile().length());
            }
            this.setFlashType(first.getFlashType());
            String bootPath = first.getFile().getPath();
            if (((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) {
                if (!this.programmerDownload(SubMonitor.convert((IProgressMonitor)subProgressMonitor, (String)"", (int)75), bootPath, ((AbstractBurner)((Object)this.burner)).getProgrammerFile(), parts)) {
                    PartitionBurnerWorker.returnError(Messages.SERAIL_PORT_BOOT_NOT_RUN);
                    PartitionBurnerWorker.returnError("Failed to download fastboot!");
                    return false;
                }
            } else if (this.burner.getBurnContext().getPlatformType() == PlatformType.NonCA) {
                if (!this.bootDownload(SubMonitor.convert((IProgressMonitor)subProgressMonitor, (String)"", (int)75), bootPath)) {
                    PartitionBurnerWorker.returnError(Messages.SERAIL_PORT_BOOT_NOT_RUN);
                    PartitionBurnerWorker.returnError("Failed to download fastboot!");
                    return false;
                }
            } else if (!this.programmerDownload(SubMonitor.convert((IProgressMonitor)subProgressMonitor, (String)"", (int)75), bootPath, ((AbstractBurner)((Object)this.burner)).getProgrammerFile(), parts)) {
                PartitionBurnerWorker.returnError(Messages.SERAIL_PORT_BOOT_NOT_RUN);
                PartitionBurnerWorker.returnError("Failed to download fastboot!");
                return false;
            }
            if (this.getFlashType() == DDR && FastbootView.isCJ101V300Series()) {
                return true;
            }
            this.uimonitor.setTaskName("Check SBL");
            boolean result = this.burnSBL(this.uimonitor, parts, ((AbstractBurner)((Object)this.burner)).getProgrammerFile());
            if (!result) {
                boolean bl = result;
                return bl;
            }
            FlashType flashType = first.getFlashType();
            subProgressMonitor.setTaskName("Loading Version Info");
            if (this.loadVersionInfo(this.burner.getBurnContext().getTransferWay())) {
                FlashType bootMode = this.loadBootMode();
                if (bootMode != null && flashType != bootMode) {
                    PartitionBurnerWorker.returnError(NLS.bind((String)Messages.ERROR_INFO_Invalid_Mode_And_RealMode, (Object)bootMode.name()));
                    return false;
                }
                subProgressMonitor.worked(5);
                subProgressMonitor.setTaskName("Loading Block Size");
                this.loadBlockSizes(hasFlashTypes, first.getChipID(), isFastboot);
                subProgressMonitor.worked(5);
            } else if (this.burner.getBurnContext().getPlatformType() == PlatformType.CA) {
                subProgressMonitor.worked(5);
                subProgressMonitor.setTaskName("Loading Block Size");
                this.loadBlockSizes(hasFlashTypes, first.getChipID(), isFastboot);
                subProgressMonitor.worked(5);
                PartitionBurnerWorker.warningln("Warning: Failed to load version info!");
            } else {
                PartitionBurnerWorker.returnError("Failed to load version info!");
                return false;
            }
            long uLength = first.getLength();
            long blockSize = 0L;
            if (FlashType.spi == flashType) {
                blockSize = this.getSpiBlockSize();
            } else if (FlashType.nand == flashType) {
                blockSize = this.getNandBlockSize();
                if (this.isPage() && !isFastboot) {
                    blockSize = this.getPageSize();
                }
            }
            if (0L == blockSize) {
                PartitionBurnerWorker.returnError("Invalid " + flashType.name() + " flash block size!");
                return false;
            }
            if (uLength % blockSize != 0L) {
                String error = "Please check partition length of '" + first.getName() + "'!" + "(" + "should be " + blockSize + " * n)";
                PartitionBurnerWorker.returnError(error);
                return false;
            }
            long fileSize = first.getFile().length();
            long writeLength = 0L;
            writeLength = fileSize % blockSize != 0L ? blockSize * (fileSize / blockSize + 1L) : fileSize;
            if (this.i2cTimeLogger != null) {
                this.i2cTimeLogger.logEnd();
            }
            if (this.flashTimeLogger != null) {
                this.flashTimeLogger.logStart(first.getFile().getName(), writeLength);
            }
            if (!this.bootBurn(SubMonitor.convert((IProgressMonitor)subProgressMonitor, (String)"", (int)15), flashType, Long.toHexString(uLength), Long.toHexString(writeLength), first.getChipID())) {
                PartitionBurnerWorker.returnError("Failed to burn fastboot partition!");
                return false;
            }
            if (this.flashTimeLogger != null) {
                this.flashTimeLogger.logEnd();
            }
            return true;
        }
        finally {
            subProgressMonitor.done();
        }
    }

    private boolean burnPart(SubMonitor subProgressMonitor, PartitionItem partitionItem, List<PartitionItem> parts) throws IOException, ReceiveTimeOutException {
        try {
            long partitionLength;
            String partitionName = partitionItem.getName() == null ? "" : partitionItem.getName();
            subProgressMonitor.beginTask("", 100);
            subProgressMonitor.setTaskName("Partition " + partitionName);
            PartitionBurnerWorker.getMonitor().highlight(partitionItem);
            long partStart = 0L;
            partStart = partitionItem.getStart();
            long writeLenght = partitionLength = partitionItem.getLength();
            FlashType flashType = partitionItem.getFlashType();
            FileSystem fileSystem = partitionItem.getFileSystem();
            File itemFile = null;
            boolean isBootargsNeedChanged = false;
            if (!ToolUtils.isCmdLine() && FastbootPreferences.isUpdateBootargsOn()) {
                isBootargsNeedChanged = true;
            }
            if (isBootargsNeedChanged && partitionItem.getName().equalsIgnoreCase("bootargs") && partitionItem.getFile() != null) {
                this.tmpBootargsString = this.getBootargsPartitionString(parts, "sfc", "nand");
                if (this.tmpBootargsString == null) {
                    return false;
                }
                itemFile = this.prepareReplacedBootargs(partitionItem.getFile(), this.tmpBootargsString);
            } else {
                itemFile = partitionItem.getFile();
            }
            subProgressMonitor.subTask("Prepare and Validate");
            if (this.getSpiBlockSize() == 0L && this.getNandBlockSize() == 0L) {
                this.loadBlockSizes(FlashType.getCurFlashTypes(parts), partitionItem.getChipID(), false);
            }
            long blockSize = this.getNandBlockSize();
            if (this.isPage()) {
                blockSize = this.getPageSize();
            }
            if (FlashType.spi == flashType) {
                blockSize = this.getSpiBlockSize();
            }
            if (0L == blockSize) {
                PartitionBurnerWorker.returnError("Invalid " + flashType.name() + " flash block size!");
                return false;
            }
            long fileSize = 0L;
            fileSize = itemFile != null && itemFile.exists() && itemFile.isFile() ? itemFile.length() : 0L;
            writeLenght = fileSize % blockSize == 0L ? fileSize : fileSize / blockSize * blockSize + blockSize;
            if (partitionLength % blockSize != 0L) {
                String error = "Please check partition length of '" + partitionItem.getName() + "'!" + "(" + "should be " + blockSize + " * n)";
                PartitionBurnerWorker.returnError(error);
                return false;
            }
            subProgressMonitor.worked(2);
            long filePartSize = 0L;
            filePartSize = ToolUtils.isCmdLine() ? (long)FILE_PART_SIZE_32 : FastbootPreferences.getUsbSpliteFileSize();
            if (fileSystem == FileSystem.yaffs) {
                long[] yaffsPageandOOBSize = this.getYaffsPageandOOBSize();
                long ulPageSize = yaffsPageandOOBSize[0];
                long ulOOBSize = yaffsPageandOOBSize[1];
                if (0L == ulPageSize || 0L == ulOOBSize) {
                    PartitionBurnerWorker.returnError("Failed to get yaffs block size in Partition " + partitionName + " !");
                    return false;
                }
                writeLenght = fileSize;
                filePartSize = filePartSize / blockSize * (blockSize + blockSize / ulPageSize * ulOOBSize);
            }
            boolean result = true;
            if (writeLenght > filePartSize) {
                if (itemFile == null) {
                    PartitionBurnerWorker.returnError("Partition " + partitionName + " burning failed!");
                    return false;
                }
                if (this.burner instanceof CommonBurner) {
                    PartitionBurnerWorker worker = new PartitionBurnerWorker((PartitionBurner)this.burner);
                    worker.setProgressMonitor(this.uimonitor);
                    this.tftpTimeLogger = new TimeLogger();
                    this.burnTimeLogger = new TimeLogger();
                    result = worker.burnLargeFile(SubMonitor.convert((IProgressMonitor)subProgressMonitor, (String)"", (int)98), itemFile, fileSystem, flashType, filePartSize, partStart, partitionLength, writeLenght, partitionItem.getChipID());
                } else {
                    result = this.burnLargeFile(SubMonitor.convert((IProgressMonitor)subProgressMonitor, (String)"", (int)98), itemFile, fileSystem, flashType, filePartSize, partStart, partitionLength, writeLenght, partitionItem.getChipID());
                }
            } else if (this.burner instanceof CommonBurner) {
                PartitionBurnerWorker worker = new PartitionBurnerWorker((PartitionBurner)this.burner);
                worker.setProgressMonitor(this.uimonitor);
                this.tftpTimeLogger = new TimeLogger();
                this.burnTimeLogger = new TimeLogger();
                result = worker.burnSmallFile(SubMonitor.convert((IProgressMonitor)subProgressMonitor, (String)"", (int)98), itemFile, fileSystem, flashType, partStart, partitionLength, writeLenght, partitionItem.getChipID());
            } else {
                result = this.burnSmallFile(SubMonitor.convert((IProgressMonitor)subProgressMonitor, (String)"", (int)98), itemFile, fileSystem, flashType, partStart, partitionLength, writeLenght, partitionItem.getChipID());
            }
            if (!result) {
                PartitionBurnerWorker.returnError("Partition " + partitionName + " burning failed!");
                return false;
            }
            this.infoln("Partition " + partitionName + " burnt successfully!");
            if (itemFile != partitionItem.getFile() && !itemFile.delete()) {
                itemFile.deleteOnExit();
            }
            boolean bl = result;
            return bl;
        }
        finally {
            subProgressMonitor.done();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean burnLargeFile(SubMonitor subProgressMonitor, File file, FileSystem fileSystem, FlashType flashType, long filePartSize, long start, long eraseLength, long adjustedTotalWriteLength, ChipID chipID) throws IOException, ReceiveTimeOutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 25[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected boolean burnSmallFile(SubMonitor subProgressMonitor, File file, FileSystem fileSystem, FlashType flashType, long address, long eraseLength, long writeLength, ChipID chipID) throws IOException, ReceiveTimeOutException {
        if (subProgressMonitor == null) {
            return false;
        }
        String name = file != null ? file.getName() : "";
        subProgressMonitor.beginTask("Burning " + name, 100);
        try {
            long realBurnLength;
            boolean validFile;
            boolean result = true;
            String hexAddress = Long.toHexString(address);
            String hexWriteLength = Long.toHexString(writeLength);
            String hexEraseLength = Long.toHexString(eraseLength);
            EraseCommand eraseCommand = EraseCommand.erase(flashType, hexAddress, hexEraseLength);
            String unzipAddr = Long.toHexString(tempFileDivisionSize + (long)this.getHexStartAddressForInt());
            String ddrAddress = this.getBurner().getBurnContext().getTransferWay() == TransferWay.Uart2Compress ? unzipAddr : this.getHexStartAddress();
            WriteCommand writeCommand = fileSystem == FileSystem.yaffs ? WriteCommand.writeYaffs(flashType, ddrAddress, hexAddress, hexWriteLength) : WriteCommand.write(flashType, ddrAddress, hexAddress, hexWriteLength);
            boolean bl = validFile = file != null && file.exists() && file.isFile();
            if (validFile) {
                XmodelParameter xmodelPar;
                subProgressMonitor.setTaskName("Sending MW command.");
                MWCommand memsetCommand = MWCommand.mwAddress(this.getHexStartAddress(), hexWriteLength);
                result = this.sendCommand(memsetCommand);
                subProgressMonitor.worked(2);
                if (result && !(result = this.downloadFileByTrans(subProgressMonitor, result, xmodelPar = new XmodelParameter(file.length(), 0L), file, 95))) {
                    boolean bl2 = result;
                    return bl2;
                }
            }
            if (result && flashType == FlashType.spi) {
                result = this.sendCommand(SFCommand.getInstance(chipID));
                subProgressMonitor.worked(1);
            }
            TransferWay transferWay = this.getBurner().getBurnContext().getTransferWay();
            if (result) {
                boolean isUsbAndSerialAndNonNude;
                subProgressMonitor.setTaskName("Erasing...");
                boolean bl3 = isUsbAndSerialAndNonNude = transferWay == TransferWay.UsbAndSerial || FastbootView.isSupportUsbNonNude(transferWay);
                if (isUsbAndSerialAndNonNude) {
                    this.infoln("\nSend command:\t " + eraseCommand.getCommand());
                    result = CallLibUSBWorker.eraseFlashByUSB((int)address, (int)eraseLength, eraseCommand.getTimeout());
                } else {
                    result = this.sendCommand(eraseCommand);
                }
            }
            subProgressMonitor.worked(1);
            if (result && validFile) {
                if (transferWay == TransferWay.Uart2Compress) {
                    UnZipCommand unZipCommand = UnZipCommand.unzip(this.getHexStartAddress(), unzipAddr);
                    result = this.sendCommand(unZipCommand.toString(), unZipCommand.calculateTimeOut(Long.toHexString(tempFileDivisionSize)));
                }
                if (this.burnTimeLogger != null && file != null) {
                    this.burnTimeLogger.logStart(file.getName(), writeLength);
                }
                subProgressMonitor.setTaskName("Writing...");
                result = this.sendCommand(writeCommand);
                if (this.burnTimeLogger != null) {
                    this.burnTimeLogger.logEnd();
                }
            }
            if (result && (realBurnLength = this.getRealBurnLength(eraseLength)) > eraseLength) {
                PartitionBurnerWorker.returnError(BurntLengthGreaterEraseLength);
                return false;
            }
            int burnCount = 1;
            while (!result) {
                String returnString = this.getCurReceived();
                if (!returnString.contains("WARNING: block is marked as bad")) break;
                PartitionBurnerWorker.warningln("A block is marked as bad block, burning the file again,the current is the " + burnCount + " times");
                if (this.burnTimeLogger != null && file != null) {
                    this.burnTimeLogger.logStart(file.getName(), writeLength);
                }
                subProgressMonitor.setTaskName("Writing...");
                result = this.sendCommand(writeCommand);
                if (this.burnTimeLogger != null) {
                    this.burnTimeLogger.logEnd();
                }
                ++burnCount;
            }
            boolean bl4 = result;
            return bl4;
        }
        finally {
            subProgressMonitor.done();
        }
    }

    private void printLog(long burnStartTime) {
        long burnTotalTime = System.currentTimeMillis() - burnStartTime;
        String burnTotalTimeStr = this.calculateBurnTotalTime(burnTotalTime);
        PartitionBurnerWorker.getMonitor().getEvent().setTotalBurnTime(burnTotalTimeStr);
        TransferWay transferWay = this.getBurner().getBurnContext().getTransferWay();
        if (this.isNeedSetupNet(transferWay)) {
            PartitionBurnerWorker.getMonitor().println(this.tftpTimeLogger.exportLog("TFTP Transfer"));
        }
        this.burnTimeLogger.logEnd();
        PartitionBurnerWorker.getMonitor().println("\nTotal Burn Time: " + burnTotalTime + " ms");
    }

    public boolean upload(IProgressMonitor uiMonitor, List<PartitionItem> parts) throws IOException, ReceiveTimeOutException {
        this.setProgressMonitor(this.uimonitor);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean erase(IProgressMonitor uiMonitor, List<PartitionItem> parts) throws IOException, ReceiveTimeOutException {
        boolean isResetJtag;
        ToolStatistics.INSTANCE.logUsage("BurnTool", "Erase Partition", "ChipName: " + this.burner.getBurnContext().getDeviceSetting().getName());
        ToolStatistics.INSTANCE.logToolInUse("BurnTool");
        String versionInfo = this.getVersionInfo("Erase Partition");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        this.setProgressMonitor(uiMonitor);
        this.registerJnaFunction(uiMonitor, 100);
        int selected = 0;
        int totalWork = 0;
        for (PartitionItem partitionItem : parts) {
            if (!partitionItem.isChecked()) continue;
            ++selected;
        }
        totalWork = (selected + 2) * 100;
        uiMonitor.beginTask("", totalWork);
        boolean bRet = true;
        uiMonitor.setTaskName("Init Board");
        ArrayList<FlashType> hasFlashTypes = new ArrayList<FlashType>();
        for (PartitionItem partitionItem : parts) {
            FlashType flashType;
            if (!partitionItem.isChecked() || hasFlashTypes.contains((Object)(flashType = partitionItem.getFlashType()))) continue;
            hasFlashTypes.add(flashType);
        }
        if (this.getBurner().getBurnContext().getTransferWay() == TransferWay.USBNonNude) {
            bRet = this.bootromByNonNude(this.uimonitor);
            if (!bRet) {
                return false;
            }
            if (this.loadVersionInfo(this.burner.getBurnContext().getTransferWay())) {
                this.loadBlockSizes(hasFlashTypes, ChipID.chip0, false);
            } else {
                if (this.burner.getBurnContext().getPlatformType() != PlatformType.CA) {
                    PartitionBurnerWorker.returnError("Failed to load version info!");
                    return false;
                }
                this.loadBlockSizes(hasFlashTypes, ChipID.chip0, false);
                PartitionBurnerWorker.warningln("Warning: Failed to load version info!");
            }
        } else {
            bRet = this.prepareToBurn(false, EventType.ERASE, hasFlashTypes);
            if (!bRet) {
                return false;
            }
        }
        uiMonitor.worked(100);
        uiMonitor.setTaskName("Erase Partitions");
        int partsSize = parts.size();
        int index = 0;
        while (index < partsSize) {
            PartitionItem part = parts.get(index);
            if (part.isChecked()) {
                PartitionBurnerWorker.getMonitor().highlight(part);
                String partitionName = part.getName() == null ? "" : part.getName();
                uiMonitor.subTask("Partition: " + partitionName);
                long partLength = part.getLength();
                FlashType flashType = part.getFlashType();
                long partStart = part.getStart();
                long startSector = partStart / 512L;
                if (index == partsSize - 1 && partLength == -1L && (partLength = this.getLastPartitionLen(part, partStart, partLength, flashType, startSector)) == -1L) {
                    return false;
                }
                if (FlashType.spi == flashType) {
                    bRet = this.sendCommand(SFCommand.getInstance(part.getChipID()));
                }
                if (bRet) {
                    bRet = this.sendCommand(EraseCommand.erase(flashType, Long.toHexString(partStart), Long.toHexString(partLength)));
                }
                if (!bRet) {
                    PartitionBurnerWorker.returnError("Failed to Erase " + partitionName + " Partition!");
                    this.sendResetCommand();
                    return false;
                }
                this.infoln("Partition " + partitionName + " Erased successfully!");
                uiMonitor.worked(100);
            }
            ++index;
        }
        TransferWay transferWay = this.getBurner().getBurnContext().getTransferWay();
        boolean bl = isResetJtag = !(!FastbootView.isCJXX0VXX5Series() && !FastbootView.isCJ3X0VXX1Series() && !FastbootView.isCJ3X1VXX8E_Series() || transferWay != TransferWay.JTAG && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.JTAGAndSerial);
        if (!isResetJtag) {
            String resetCommand = "reset";
            this.sendCommandNoReturnValue(resetCommand);
        }
        return bRet;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean eraseAll(IProgressMonitor uiMonitor, List<PartitionItem> children) throws IOException, ReceiveTimeOutException {
        boolean isResetJtag;
        long nandSpaceSize;
        ToolStatistics.INSTANCE.logUsage("BurnTool", "Erase All By Partition", "ChipName: " + this.burner.getBurnContext().getDeviceSetting().getName());
        ToolStatistics.INSTANCE.logToolInUse("BurnTool");
        String versionInfo = this.getVersionInfo("Erase All By Partition");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        this.setProgressMonitor(uiMonitor);
        this.registerJnaFunction(uiMonitor, 100);
        boolean bRet = true;
        int totalWork = 100;
        uiMonitor.setTaskName("Init Board");
        uiMonitor.beginTask("", totalWork);
        ArrayList<FlashType> hasFlashTypes = new ArrayList<FlashType>();
        hasFlashTypes.add(FlashType.spi);
        if (!FastbootView.isCJXX0VXX5Series()) {
            hasFlashTypes.add(FlashType.nand);
        }
        if (this.getBurner().getBurnContext().getTransferWay() == TransferWay.USBNonNude) {
            bRet = this.bootromByNonNude(this.uimonitor);
            if (!bRet) {
                return false;
            }
            if (this.loadVersionInfo(this.burner.getBurnContext().getTransferWay())) {
                this.loadBlockSizes(hasFlashTypes, ChipID.chip0, false);
            } else {
                if (this.burner.getBurnContext().getPlatformType() != PlatformType.CA) {
                    PartitionBurnerWorker.returnError("Failed to load version info!");
                    return false;
                }
                this.loadBlockSizes(hasFlashTypes, ChipID.chip0, false);
                PartitionBurnerWorker.warningln("Warning: Failed to load version info!");
            }
        } else {
            bRet = this.prepareToBurn(false, EventType.ERASE, hasFlashTypes);
            if (!bRet) {
                return false;
            }
        }
        uiMonitor.worked(10);
        uiMonitor.setTaskName("Erase Partitions");
        if (!FastbootView.isCJXX0VXX5Series() && (nandSpaceSize = this.getNandSpaceSize()) != 0L && nandSpaceSize > 0L) {
            EraseCommand eraseCommand = PartitionBurnerWorker.eraseAllCommand(nandSpaceSize);
            bRet = this.sendCommand(eraseCommand);
        }
        ArrayList<ChipID> existChipIDInParts = null;
        existChipIDInParts = FastbootView.isCJXX0VXX5Series() ? ChipID.getExistChipIDInPartsCJXX0VXX2(children) : ChipID.getExistChipIDInParts(children);
        if (existChipIDInParts != null) {
            for (ChipID chipID : existChipIDInParts) {
                long spiSpaceSize;
                if (FastbootView.isCJXX1Series()) {
                    bRet = this.sendCommand(SFCommand.getInstance(chipID));
                }
                if ((spiSpaceSize = this.getSpiSpaceSize()) == 0L || spiSpaceSize <= 0L) continue;
                bRet = this.sendCommand(SFCommand.getInstance(chipID));
                if (bRet) {
                    bRet = this.sendCommand(EraseCommand.erase(FlashType.spi, Long.toHexString(0L), Long.toHexString(spiSpaceSize)));
                }
                uiMonitor.worked(30);
            }
        }
        if (!bRet) {
            PartitionBurnerWorker.returnError("Failed to Erase all partitions!");
            return false;
        }
        this.infoln("Erase all partitions successfully!");
        TransferWay transferWay = this.getBurner().getBurnContext().getTransferWay();
        boolean bl = isResetJtag = !(!FastbootView.isCJXX0VXX5Series() && !FastbootView.isCJ3X0VXX1Series() && !FastbootView.isCJ3X1VXX8E_Series() || transferWay != TransferWay.JTAG && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.JTAGAndSerial);
        if (!isResetJtag) {
            String resetCommand = "reset";
            this.sendCommandNoReturnValue(resetCommand);
        }
        uiMonitor.worked(100);
        return bRet;
    }

    public static EraseCommand eraseAllCommand(long nandSpaceSize) {
        String eraseAllCommand = "nand erase 0";
        if (FastbootView.isNandEraseAllOtherCommand()) {
            eraseAllCommand = "nand erase.chip";
        }
        EraseCommand eraseCommand = new EraseCommand(eraseAllCommand);
        eraseCommand.setTimeout(EraseCommand.calTimeout(String.valueOf(nandSpaceSize), FlashType.nand));
        return eraseCommand;
    }

    protected long getLastPartitionLen(PartitionItem partitionItem, long partStart, long partLength, FlashType flashType, long startSector) throws IOException, ReceiveTimeOutException {
        if (flashType == FlashType.emmc || flashType == FlashType.ufs) {
            long neMMCCapacity = this.geteMMCSpaceSize(flashType);
            if (0L == neMMCCapacity) {
                String errorInfo = "Failed to get eMMC capacity!";
                if (flashType == FlashType.ufs) {
                    errorInfo = "Failed to get ufs capacity!";
                }
                PartitionBurnerWorker.warningln(errorInfo);
                return -1L;
            }
            partLength = neMMCCapacity - startSector * 512L;
        } else if (flashType == FlashType.nand || flashType == FlashType.spi) {
            boolean result;
            if (FlashType.spi == flashType && !(result = this.sendCommand(SFCommand.getInstance(partitionItem.getChipID())))) {
                return -1L;
            }
            long nParCapacity = this.getParSpaceSize();
            if (0L == nParCapacity) {
                PartitionBurnerWorker.warningln("Failed to get Parttition capacity!");
                return -1L;
            }
            partLength = nParCapacity - partStart;
        }
        PartitionBurnerWorker.warningln("All Parttition remain space" + partLength + " Bytes allotted to last partition!");
        partitionItem.setLength(partLength);
        return partLength;
    }

    public File getHome(List<PartitionItem> parts, EventType eventType) {
        File file;
        if (parts.size() == 0) {
            return null;
        }
        for (PartitionItem partitionItem : parts) {
            if (!partitionItem.isChecked() || (file = partitionItem.getFile()) == null) continue;
            if (eventType == EventType.BURN) {
                if (!file.exists() || !file.isFile()) continue;
                return file.getParentFile();
            }
            return file.getParentFile();
        }
        for (PartitionItem partitionItem : parts) {
            file = partitionItem.getFile();
            if (file == null) continue;
            return file.getParentFile();
        }
        return null;
    }

    private long getParSpaceSize() throws IOException, ReceiveTimeOutException {
        if (!this.sendCommand("getinfo nand") && !this.sendCommand("getinfo spi")) {
            return 0L;
        }
        String received = this.getCurReceived();
        long result = WorkerUtility.ReceiveHelper.getChipSize(received);
        return result;
    }

    protected long getNandSpaceSize() throws IOException, ReceiveTimeOutException {
        if (!this.sendCommand("getinfo nand")) {
            return 0L;
        }
        String received = this.getCurReceived();
        long result = WorkerUtility.ReceiveHelper.getChipSize(received);
        return result;
    }

    protected long getSpiSpaceSize() throws IOException, ReceiveTimeOutException {
        if (!this.sendCommand("getinfo spi")) {
            return 0L;
        }
        String received = this.getCurReceived();
        long result = WorkerUtility.ReceiveHelper.getChipSize(received);
        if (FastbootView.isCJXX0VXX5Series()) {
            result = WorkerUtility.ReceiveHelper.getCJXX0VXX5ChipSize(received);
        }
        return result;
    }

    protected long geteMMCSpaceSize(FlashType flashType) throws IOException, ReceiveTimeOutException {
        String infocmd = "mmcinfo";
        if (flashType != null) {
            if (flashType == FlashType.ufs) {
                infocmd = "ufsinfo";
            } else if (flashType == FlashType.ssd) {
                infocmd = "nvme info";
            }
        }
        if (!this.sendCommand(infocmd)) {
            PartitionBurnerWorker.warningln("Failed to send command " + infocmd + ".  ");
            return 0L;
        }
        String received = this.getCurReceived();
        if (flashType != null && flashType == FlashType.ssd) {
            return this.getCapacityBySsd(infocmd, received);
        }
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        if (transferWay == TransferWay.UsbAndSerial || FastbootView.isSupportUsbNonNude(transferWay)) {
            return this.getCapacityByUsbAndSerial(infocmd, received);
        }
        return this.getCapacityByEmmc(infocmd, received);
    }

    private long getCapacityByUsbAndSerial(String infocmd, String received) {
        String key = "[EOT](OK)";
        int startIndex = received.indexOf(key);
        if (startIndex == -1) {
            PartitionBurnerWorker.warningln(String.valueOf(infocmd) + ":" + received);
            PartitionBurnerWorker.warningln("[EOT](OK): " + startIndex);
            return 0L;
        }
        startIndex += key.length();
        int endIndex = received.lastIndexOf(".");
        if (endIndex == -1) {
            PartitionBurnerWorker.warningln("." + startIndex);
            return 0L;
        }
        String strCapacity = received.substring(startIndex, endIndex);
        long capacityValue = 0L;
        try {
            capacityValue = Long.parseLong(strCapacity.trim());
        }
        catch (NumberFormatException numberFormatException) {
            PartitionBurnerWorker.warningln(Messages.EmmcComposite_Capacity_Error);
        }
        return capacityValue;
    }

    private long getCapacityByEmmc(String infocmd, String received) {
        String key = "High Capacity: ";
        int startIndex = received.indexOf(key);
        if (startIndex == -1) {
            PartitionBurnerWorker.warningln(String.valueOf(infocmd) + ":" + received);
            PartitionBurnerWorker.warningln("High Capacity: " + startIndex);
            return 0L;
        }
        startIndex += key.length();
        key = "Capacity: ";
        if ((startIndex = received.indexOf(key, startIndex)) == -1) {
            PartitionBurnerWorker.warningln("Capacity: " + startIndex);
            return 0L;
        }
        int endIndex = received.indexOf("\r\n", startIndex += key.length());
        if (endIndex == -1) {
            PartitionBurnerWorker.warningln("\r\n" + endIndex);
            return 0L;
        }
        String strCapacity = received.substring(startIndex, endIndex);
        long capacityValue = 0L;
        try {
            capacityValue = Long.parseLong(strCapacity.trim());
        }
        catch (NumberFormatException numberFormatException) {
            PartitionBurnerWorker.warningln(Messages.EmmcComposite_Capacity_Error);
        }
        return capacityValue;
    }

    private long getCapacityBySsd(String infocmd, String received) {
        String key = "Capacity: ";
        int startIndex = received.indexOf(key);
        if (startIndex == -1) {
            PartitionBurnerWorker.warningln(String.valueOf(infocmd) + ":" + received);
            PartitionBurnerWorker.warningln("Capacity: " + startIndex);
            return 0L;
        }
        int endIndex = received.indexOf("MB", startIndex);
        if (endIndex == -1) {
            PartitionBurnerWorker.warningln("\r\n" + endIndex);
            return 0L;
        }
        String strCapacity = received.substring(startIndex + key.length(), endIndex).trim();
        long capacityValue = 0L;
        try {
            capacityValue = (long)Double.parseDouble(strCapacity);
        }
        catch (NumberFormatException numberFormatException) {
            PartitionBurnerWorker.warningln(Messages.EmmcComposite_Capacity_Error);
        }
        this.receivDebugInfo(String.valueOf(key) + capacityValue);
        return capacityValue * 1024L * 1024L;
    }

    /*
     * Loose catch block
     */
    private File prepareReplacedBootargs(File inputFile, String newString) {
        String tempFileName;
        File tempFile;
        int mtdpartsLength;
        int mtdpartsStart;
        String targetLine;
        String[] lines;
        RandomAccessFile randFile;
        byte[] dstBytes;
        byte[] content;
        block40: {
            block39: {
                block38: {
                    PartitionBurnerWorker.getMonitor().infoln("\nReplace 'mtdparts' definition in bootargs partition.");
                    PartitionBurnerWorker.getMonitor().info("With new string: ");
                    PartitionBurnerWorker.getMonitor().warnln(newString);
                    content = FileUtils.readAllBytes(inputFile.getAbsolutePath());
                    if (content.length < 4) {
                        return inputFile;
                    }
                    byte[] strBytes = BytesUtils.genSubBytes(content, 4, content.length - 4);
                    String strLines = null;
                    dstBytes = null;
                    randFile = null;
                    strLines = new String(strBytes, System.getProperty("file.encoding"));
                    lines = strLines.split("\u0000");
                    targetLine = null;
                    int targetLineIndex = -1;
                    int i = 0;
                    while (i < lines.length) {
                        if (lines[i].startsWith("bootargs".toLowerCase())) {
                            targetLine = lines[i];
                            targetLineIndex = i;
                            break;
                        }
                        ++i;
                    }
                    if (targetLine != null && targetLineIndex != -1) break block38;
                    File file = inputFile;
                    try {
                        if (randFile != null) {
                            randFile.close();
                        }
                    }
                    catch (IOException iOException) {
                        return inputFile;
                    }
                    return file;
                }
                mtdpartsStart = targetLine.indexOf("mtdparts");
                if (mtdpartsStart != -1) break block39;
                File file = inputFile;
                try {
                    if (randFile != null) {
                        randFile.close();
                    }
                }
                catch (IOException iOException) {
                    return inputFile;
                }
                return file;
            }
            String other = "(others)";
            String sdCard = "(sdcard)";
            int otherLen = other.length();
            int sdCardLen = sdCard.length();
            String mtdpartsTitleString = targetLine.substring(mtdpartsStart);
            int partsLengthEmpty = mtdpartsTitleString.indexOf(" ");
            int partsLengthOther = mtdpartsTitleString.indexOf(other);
            int partsLengthSdCard = mtdpartsTitleString.indexOf(sdCard);
            mtdpartsLength = -1;
            if (partsLengthOther != -1) {
                newString = newString.concat(",-(others)");
                mtdpartsLength = partsLengthOther + otherLen;
            } else {
                mtdpartsLength = partsLengthSdCard != -1 ? partsLengthSdCard + sdCardLen : (partsLengthEmpty != -1 ? partsLengthEmpty : mtdpartsTitleString.length());
            }
            if (mtdpartsLength != -1) break block40;
            File file = inputFile;
            try {
                if (randFile != null) {
                    randFile.close();
                }
            }
            catch (IOException iOException) {
                return inputFile;
            }
            return file;
        }
        StringBuilder newTargetString = new StringBuilder();
        newTargetString.append(targetLine.substring(0, mtdpartsStart));
        newTargetString.append(newString);
        newTargetString.append(targetLine.substring(mtdpartsStart + mtdpartsLength));
        lines[targetLineIndex] = newTargetString.toString();
        StringBuilder strToWrite = new StringBuilder();
        int i = 0;
        while (i < lines.length) {
            if (lines[i].length() == 0) break;
            strToWrite.append(lines[i]);
            strToWrite.append("\u0000");
            ++i;
        }
        dstBytes = strToWrite.toString().getBytes(System.getProperty("file.encoding"));
        int len = (int)bootargsFileLen;
        BytesUtils.copyBytes(content, dstBytes, 4, 0, dstBytes.length);
        ZlibCRC32 crc32 = new ZlibCRC32();
        crc32.update(content, 4, len - 4);
        int crcValue = (int)crc32.getValue();
        content[0] = (byte)(crcValue & 0xFF);
        content[1] = (byte)(crcValue >> 8);
        content[2] = (byte)(crcValue >> 16);
        content[3] = (byte)(crcValue >> 24);
        String parentFolder = inputFile.getParent();
        if (parentFolder == null) {
            parentFolder = "/";
        }
        if ((tempFile = new File(tempFileName = String.valueOf(parentFolder) + "/bootargs.temp")).exists() && !tempFile.delete()) {
            tempFile.deleteOnExit();
        }
        randFile = new RandomAccessFile(tempFile, "rw");
        randFile.seek(0L);
        randFile.write(content);
        File file = new File(tempFileName);
        try {
            if (randFile != null) {
                randFile.close();
            }
        }
        catch (IOException iOException) {
            return inputFile;
        }
        return file;
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            File file2 = inputFile;
            try {
                if (randFile != null) {
                    randFile.close();
                }
            }
            catch (IOException iOException) {
                return inputFile;
            }
            return file2;
        }
        catch (IOException iOException) {
            File file3 = inputFile;
            {
                catch (Throwable throwable) {
                    try {
                        if (randFile != null) {
                            randFile.close();
                        }
                    }
                    catch (IOException iOException2) {
                        return inputFile;
                    }
                    throw throwable;
                }
            }
            try {
                if (randFile != null) {
                    randFile.close();
                }
            }
            catch (IOException iOException3) {
                return inputFile;
            }
            return file3;
        }
    }

    /*
     * Loose catch block
     */
    protected File prepareEmmcReplacedBootargs(File inputFile, String newString) {
        String tempFileName;
        File tempFile;
        int partsLength;
        int partsStart;
        String targetLine;
        String[] lines;
        RandomAccessFile randFile;
        byte[] dstBytes;
        byte[] content;
        block46: {
            block45: {
                int emmcType;
                block44: {
                    emmcType = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getEmmcType();
                    if (emmcType == EMMC_TYPE_E.EMMC_HAVE_MBR_TYPE.ordinal()) {
                        PartitionBurnerWorker.getMonitor().infoln("\nReplace 'mtdparts' definition in bootargs partition.");
                    } else if (emmcType == EMMC_TYPE_E.EMMC_NO_MBR_TYPE.ordinal() || emmcType == EMMC_TYPE_E.EMMC_CJ3X1VX12H_TYPE.ordinal()) {
                        PartitionBurnerWorker.getMonitor().infoln("\nReplace 'blkdevparts' definition in bootargs partition.");
                    }
                    PartitionBurnerWorker.getMonitor().info("With new string: ");
                    PartitionBurnerWorker.getMonitor().warnln(newString);
                    content = FileUtils.readAllBytes(inputFile.getAbsolutePath());
                    if (content.length < 4) {
                        return inputFile;
                    }
                    byte[] strBytes = BytesUtils.genSubBytes(content, 4, content.length - 4);
                    String strLines = null;
                    dstBytes = null;
                    randFile = null;
                    strLines = new String(strBytes, System.getProperty("file.encoding"));
                    lines = strLines.split("\u0000");
                    targetLine = null;
                    int targetLineIndex = -1;
                    int i = 0;
                    while (i < lines.length) {
                        if (lines[i].startsWith("bootargs".toLowerCase())) {
                            targetLine = lines[i];
                            targetLineIndex = i;
                            break;
                        }
                        ++i;
                    }
                    if (targetLine != null && targetLineIndex != -1) break block44;
                    File file2 = inputFile;
                    try {
                        if (randFile != null) {
                            randFile.close();
                        }
                    }
                    catch (IOException iOException) {
                        return inputFile;
                    }
                    return file2;
                }
                partsStart = -1;
                if (emmcType == EMMC_TYPE_E.EMMC_HAVE_MBR_TYPE.ordinal()) {
                    partsStart = targetLine.indexOf("mtdparts");
                } else if (emmcType == EMMC_TYPE_E.EMMC_NO_MBR_TYPE.ordinal() || emmcType == EMMC_TYPE_E.EMMC_CJ3X1VX12H_TYPE.ordinal()) {
                    partsStart = targetLine.indexOf("blkdevparts");
                }
                if (partsStart != -1) break block45;
                File file3 = inputFile;
                try {
                    if (randFile != null) {
                        randFile.close();
                    }
                }
                catch (IOException iOException) {
                    return inputFile;
                }
                return file3;
            }
            String other = "(others)";
            String sdCard = "(sdcard)";
            int otherLen = other.length();
            int sdCardLen = sdCard.length();
            String partsTitleString = targetLine.substring(partsStart);
            int partsLengthEmpty = partsTitleString.indexOf(" ");
            int partsLengthOther = partsTitleString.indexOf(other);
            int partsLengthSdCard = partsTitleString.indexOf(sdCard);
            partsLength = -1;
            if (partsLengthOther != -1) {
                newString = newString.concat(",-(others)");
                partsLength = partsLengthOther + otherLen;
            } else {
                partsLength = partsLengthEmpty != -1 ? partsLengthEmpty : (partsLengthSdCard != -1 ? partsLengthSdCard + sdCardLen : partsTitleString.length());
            }
            if (partsLength != -1) break block46;
            File file4 = inputFile;
            try {
                if (randFile != null) {
                    randFile.close();
                }
            }
            catch (IOException iOException) {
                return inputFile;
            }
            return file4;
        }
        StringBuilder newTargetString = new StringBuilder();
        newTargetString.append(targetLine.substring(0, partsStart));
        newTargetString.append(newString);
        newTargetString.append(targetLine.substring(partsStart + partsLength));
        lines[targetLineIndex] = newTargetString.toString();
        StringBuilder strToWrite = new StringBuilder();
        int i = 0;
        while (i < lines.length) {
            lines[i].length();
            strToWrite.append(lines[i]);
            strToWrite.append("\u0000");
            ++i;
        }
        dstBytes = strToWrite.toString().getBytes(System.getProperty("file.encoding"));
        int len = (int)bootargsFileLen;
        BytesUtils.copyBytes(content, dstBytes, 4, 0, dstBytes.length);
        ZlibCRC32 crc32 = new ZlibCRC32();
        crc32.update(content, 4, len - 4);
        int crcValue = (int)crc32.getValue();
        content[0] = (byte)(crcValue & 0xFF);
        content[1] = (byte)(crcValue >> 8);
        content[2] = (byte)(crcValue >> 16);
        content[3] = (byte)(crcValue >> 24);
        String parentFolder = inputFile.getParent();
        if (parentFolder == null) {
            parentFolder = "/";
        }
        if ((tempFile = new File(tempFileName = String.valueOf(parentFolder) + "/bootargs.temp")).exists() && !tempFile.delete()) {
            tempFile.deleteOnExit();
        }
        randFile = new RandomAccessFile(tempFile, "rw");
        randFile.seek(0L);
        randFile.write(content);
        File file = new File(tempFileName);
        try {
            if (randFile != null) {
                randFile.close();
            }
        }
        catch (IOException iOException) {
            return inputFile;
        }
        return file;
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            File file2 = inputFile;
            try {
                if (randFile != null) {
                    randFile.close();
                }
            }
            catch (IOException iOException) {
                return inputFile;
            }
            return file2;
        }
        catch (IOException iOException) {
            File file3 = inputFile;
            {
                catch (Throwable throwable) {
                    try {
                        if (randFile != null) {
                            randFile.close();
                        }
                    }
                    catch (IOException iOException2) {
                        return inputFile;
                    }
                    throw throwable;
                }
            }
            try {
                if (randFile != null) {
                    randFile.close();
                }
            }
            catch (IOException iOException3) {
                return inputFile;
            }
            return file3;
        }
    }

    private String getBootargsPartitionString(List<PartitionItem> parts, String spiMtdId, String nandMtdId) {
        String partSize;
        if (!(spiMtdId != null && spiMtdId.length() != 0 || nandMtdId != null && nandMtdId.length() != 0)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("mtdparts=");
        int spiCount = 0;
        int nandCount = 0;
        for (PartitionItem pi : parts) {
            if (pi.getFlashType() == FlashType.spi) {
                ++spiCount;
            }
            if (pi.getFlashType() != FlashType.nand) continue;
            ++nandCount;
        }
        if (spiMtdId != null && spiMtdId.length() > 0 && spiCount > 0) {
            sb.append(String.valueOf(spiMtdId) + ":");
            int writeCount = 0;
            for (PartitionItem part : parts) {
                if (part.getFlashType() == FlashType.nand) continue;
                partSize = "-";
                if (part.getLength() > -1L) {
                    partSize = StringUtils.getStorageSizeString(part.getLength());
                }
                if (partSize == null) {
                    return null;
                }
                if (part.getName().equalsIgnoreCase("bootargs") && part.getFile() != null) {
                    bootargsFileLen = part.getFile().length();
                }
                if (writeCount > 0) {
                    sb.append(",");
                }
                sb.append(String.valueOf(partSize) + "(" + part.getName() + ")");
                ++writeCount;
            }
            if (nandMtdId != null && nandMtdId.length() > 0 && nandCount > 0) {
                sb.append(";");
            }
        }
        if (nandMtdId != null && nandMtdId.length() > 0 && nandCount > 0) {
            sb.append(String.valueOf(nandMtdId) + ":");
            int writeCount = 0;
            for (PartitionItem part : parts) {
                if (part.getFlashType() == FlashType.spi) continue;
                partSize = "-";
                if (part.getLength() > -1L) {
                    partSize = StringUtils.getStorageSizeString(part.getLength());
                }
                if (partSize == null) {
                    return null;
                }
                if (part.getName().equalsIgnoreCase("bootargs")) {
                    bootargsFileLen = part.getFile().length();
                }
                if (writeCount > 0) {
                    sb.append(",");
                }
                sb.append(String.valueOf(partSize) + "(" + part.getName() + ")");
                ++writeCount;
            }
        }
        return sb.toString();
    }

    public String getEmmcBootargsPartitionString(List<PartitionItem> parts) {
        int emmcType = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getEmmcType();
        StringBuilder sb = new StringBuilder();
        int writeCount = 0;
        if (emmcType == EMMC_TYPE_E.EMMC_HAVE_MBR_TYPE.ordinal()) {
            sb.append("mtdparts=hi_emmc:");
        } else if (emmcType == EMMC_TYPE_E.EMMC_NO_MBR_TYPE.ordinal() || emmcType == EMMC_TYPE_E.EMMC_CJ3X1VX12H_TYPE.ordinal()) {
            sb.append("blkdevparts=mmcblk0:");
        }
        for (PartitionItem part : parts) {
            String partSize = "-";
            if (part.getLength() > -1L) {
                partSize = StringUtils.getStorageSizeString(part.getLength());
            }
            if (partSize == null) {
                return null;
            }
            if (part.getName().equalsIgnoreCase("bootargs") && part.getFile() != null) {
                PartitionBurnerWorker.setBootargsFileLen(part.getFile().length());
            }
            if (writeCount > 0) {
                sb.append(",");
            }
            sb.append(String.valueOf(partSize) + "(" + part.getName() + ")");
            ++writeCount;
        }
        return sb.toString();
    }

    protected void checkDataAndWrite(String fillData, RandomAccessFile imagefile, int len) throws IOException {
        if (fillData.equals("0xFF")) {
            imagefile.write(BytesUtils.genBytesWithFF(len));
        } else if (fillData.equals("0x00")) {
            imagefile.write(BytesUtils.genBytesWithZero(len));
        }
    }

    protected void fillDataToEmptyPart(String fillData, RandomAccessFile imagefile, long partitionLen) throws IOException {
        int emptyLenCount = (int)((partitionLen + 0x500000L - 1L) / 0x500000L);
        int emptyLenSpace = (int)(partitionLen % 0x500000L);
        if (emptyLenCount == 0) {
            this.checkDataAndWrite(fillData, imagefile, (int)partitionLen);
        } else {
            int j = 0;
            while (j < emptyLenCount) {
                if (j == emptyLenCount - 1) {
                    if (emptyLenSpace == 0) {
                        this.checkDataAndWrite(fillData, imagefile, 0x500000);
                    } else {
                        this.checkDataAndWrite(fillData, imagefile, emptyLenSpace);
                    }
                } else {
                    this.checkDataAndWrite(fillData, imagefile, 0x500000);
                }
                ++j;
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void writeToFile(SubMonitor subProgressMonitor, RandomAccessFile imagefile, long offset, File partfile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 17[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public TimeLogger getZipAndPageTimeLogger() {
        return this.zipAndPageTimeLogger;
    }

    public TimeLogger getSpellingSparseFileLogger() {
        return this.spellingSparseFileLogger;
    }

    public String getTmpBootargsString() {
        return this.tmpBootargsString;
    }

    public void setTmpBootargsString(String tmpBootargsString) {
        this.tmpBootargsString = tmpBootargsString;
    }

    public TimeLogger getBurnBootTimeLogger() {
        return this.burnBootTimeLogger;
    }

    public void setBurnBootTimeLogger(TimeLogger burnBootTimeLogger) {
        this.burnBootTimeLogger = burnBootTimeLogger;
    }

    public TimeLogger getTftpTimeLogger() {
        return this.tftpTimeLogger;
    }

    public void setTftpTimeLogger(TimeLogger tftpTimeLogger) {
        this.tftpTimeLogger = tftpTimeLogger;
    }

    public TimeLogger getBurnTimeLogger() {
        return this.burnTimeLogger;
    }

    public void setBurnTimeLogger(TimeLogger burnTimeLogger) {
        this.burnTimeLogger = burnTimeLogger;
    }

    public TimeLogger getWaitZipTimeLogger() {
        return this.waitZipTimeLogger;
    }

    public void setWaitZipTimeLogger(TimeLogger waitZipTimeLogger) {
        this.waitZipTimeLogger = waitZipTimeLogger;
    }

    public TimeLogger getUnZipTimeLogger() {
        return this.unZipTimeLogger;
    }

    public void setUnZipTimeLogger(TimeLogger unZipTimeLogger) {
        this.unZipTimeLogger = unZipTimeLogger;
    }

    public TimeLogger getEraseTimeLogger() {
        return this.eraseTimeLogger;
    }

    public void setEraseTimeLogger(TimeLogger eraseTimeLogger) {
        this.eraseTimeLogger = eraseTimeLogger;
    }

    public TimeLogger getCrcLogger() {
        return this.crcLogger;
    }

    public void setCrcLogger(TimeLogger crcLogger) {
        this.crcLogger = crcLogger;
    }

    public void setZipAndPageTimeLogger(TimeLogger zipAndPageTimeLogger) {
        this.zipAndPageTimeLogger = zipAndPageTimeLogger;
    }

    public void setSpellingSparseFileLogger(TimeLogger spellingSparseFileLogger) {
        this.spellingSparseFileLogger = spellingSparseFileLogger;
    }

    public static long getBootargsFileLen() {
        return bootargsFileLen;
    }

    public static void setBootargsFileLen(long bootargsFileLen) {
        PartitionBurnerWorker.bootargsFileLen = bootargsFileLen;
    }

    public static enum EMMC_TYPE_E {
        NO_EMMC_TYPE,
        EMMC_HAVE_MBR_TYPE,
        EMMC_NO_MBR_TYPE,
        EMMC_CJ3X1VX12H_TYPE;

    }
}

