/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.sparse;

public class SparseHeader {
    public static final int LENGTH = 28;
    private static final byte[] EMPTY = new byte[28];
    public int magic;
    public short major_version;
    public short minor_version;
    public short file_hdr_sz;
    public short chunk_hdr_sz;
    public int blk_sz;
    public long total_blks;
    public int total_chunks;
    public int image_checksum;

    public boolean fromBytes(byte[] data) {
        if (data.length < 28) {
            return false;
        }
        this.magic = (data[3] & 0xFF) << 24 | (data[2] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[0] & 0xFF;
        this.major_version = (short)((data[5] & 0xFF) << 8 | data[4] & 0xFF);
        this.minor_version = (short)((data[7] & 0xFF) << 8 | data[6] & 0xFF);
        this.file_hdr_sz = (short)((data[9] & 0xFF) << 8 | data[8] & 0xFF);
        this.chunk_hdr_sz = (short)((data[11] & 0xFF) << 8 | data[10] & 0xFF);
        this.blk_sz = (data[15] & 0xFF) << 24 | (data[14] & 0xFF) << 16 | (data[13] & 0xFF) << 8 | data[12] & 0xFF;
        this.total_blks = (data[19] & 0xFF) << 24 | (data[18] & 0xFF) << 16 | (data[17] & 0xFF) << 8 | data[16] & 0xFF;
        this.total_chunks = (data[23] & 0xFF) << 24 | (data[22] & 0xFF) << 16 | (data[21] & 0xFF) << 8 | data[20] & 0xFF;
        this.image_checksum = (data[27] & 0xFF) << 24 | (data[26] & 0xFF) << 16 | (data[25] & 0xFF) << 8 | data[24] & 0xFF;
        return true;
    }

    public byte[] toBytes() {
        byte[] data = new byte[]{(byte)(this.magic & 0xFF), (byte)(this.magic >> 8), (byte)(this.magic >> 16), (byte)(this.magic >> 24), (byte)(this.major_version & 0xFF), (byte)(this.major_version >> 8), (byte)(this.minor_version & 0xFF), (byte)(this.minor_version >> 8), (byte)(this.file_hdr_sz & 0xFF), (byte)(this.file_hdr_sz >> 8), (byte)(this.chunk_hdr_sz & 0xFF), (byte)(this.chunk_hdr_sz >> 8), (byte)(this.blk_sz & 0xFF), (byte)(this.blk_sz >> 8), (byte)(this.blk_sz >> 16), (byte)(this.blk_sz >> 24), (byte)(this.total_blks & 0xFFL), (byte)(this.total_blks >> 8), (byte)(this.total_blks >> 16), (byte)(this.total_blks >> 24), (byte)(this.total_chunks & 0xFF), (byte)(this.total_chunks >> 8), (byte)(this.total_chunks >> 16), (byte)(this.total_chunks >> 24), (byte)(this.image_checksum & 0xFF), (byte)(this.image_checksum >> 8), (byte)(this.image_checksum >> 16), (byte)(this.image_checksum >> 24)};
        return data;
    }

    public static byte[] getEmpty() {
        return EMPTY;
    }
}

