/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.ui;

import com.vendor.burn.Messages;
import com.vendor.burn.model.PartitionItem;
import com.vendor.burn.model.TransferWay;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.define.IErasable;
import com.vendor.burn.model.define.IFastbootProgressMonitor;
import com.vendor.burn.model.define.IUploadable;
import com.vendor.burn.model.devices.IUIAdapter;
import com.vendor.burn.model.devices.IUIAdapterable;
import com.vendor.burn.model.devices.burners.CommonBurner;
import com.vendor.burn.model.devices.burners.EmmcBurner;
import com.vendor.burn.model.devices.burners.PartitionBurner;
import com.vendor.burn.model.event.EventType;
import com.vendor.burn.model.event.FastbootEvent;
import com.vendor.burn.model.event.IFastbootEventListener;
import com.vendor.burn.preferences.FastbootPreferences;
import com.vendor.burn.ui.IDEHelper;
import com.vendor.burn.utilitily.ToolUtils;
import com.vendor.burn.views.FastbootView;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public abstract class BurnComposite
extends Composite
implements IFastbootEventListener,
IUIAdapterable {
    protected static final String LABEL_BURN = Messages.BurnComposite_Burn_Text;
    protected static final String LABEL_DDRCHECK = Messages.BurnComposite_DdrCheck_Text;
    protected static final String LABEL_UPLOAD = Messages.BurnComposite_Upload_Text;
    protected static final String LABEL_ERASE = Messages.BurnComposite_Erase_Text;
    protected static final String LABEL_FALSH_TYPE = Messages.BurnComposite_LABEL_FALSHTYPE;
    protected static final String LABEL_FALSH_ID = Messages.BurnComposite_LABEL_FALSHID;
    protected static final String LABEL_BROWSE = Messages.BurnComposite_Browse_Text;
    protected static final String LABEL_SAVE = Messages.BurnComposite_Save_Text;
    protected static final String LABEL_FILE = Messages.BurnComposite_LABEL_FILE;
    protected static final String LABEL_CREATE_USB_PACKAGE = Messages.BurnComposite_Create_Usb_Package_Text;
    protected static final String LABEL_MAKE_NAND_IMAGE = Messages.PartitionComposite_Button_MakeNandImage;
    private IUIAdapter adapter;
    protected IBurner burner;
    protected IFastbootProgressMonitor progressMonitor;

    public BurnComposite(Composite parent, int style, IBurner burner) {
        super(parent, style);
        this.burner = burner;
        this._setLayout(this.createLayout());
        this.createContents(this);
        IFastbootProgressMonitor monitor = this.getProgressMonitor();
        monitor.addListener(this);
    }

    public BurnComposite(Composite parent, int style, IBurner burner2, TabItem tabItem2) {
        super(parent, style);
        this.burner = burner2;
        this._setLayout(this.createLayout());
        this.createContents(this);
        IFastbootProgressMonitor monitor = this.getProgressMonitor();
        monitor.addListener(this);
    }

    private void _setLayout(Layout layout) {
        super.setLayout(layout);
    }

    protected boolean isErase() {
        IBurner burner = this.getBurner();
        TransferWay transterWay = burner.getBurnContext().getTransferWay();
        if (transterWay.equals((Object)TransferWay.Usb2I2c)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"BurnTool", (String)Messages.I2C_UPGRADE_NOT_SUPPORT_ERASE);
            return false;
        }
        return true;
    }

    protected boolean startInfo() {
        boolean isStart = true;
        if (FastbootView.isCJ3X1VXX8E_Series() && ToolUtils.isJTagTransferMode(this.getBurner().getBurnContext().getTransferWay())) {
            return MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.FASTBOOT_MessageDialog_Title, (String)Messages.ERROR_INFO_Start_JTAG);
        }
        return isStart;
    }

    protected void burn() {
        IBurner burner = this.getBurner();
        if (this.checkStatus(burner.checkBeforeBurn())) {
            if (!this.startInfo()) {
                this.enableButtons();
                return;
            }
            IFastbootProgressMonitor monitor = this.getProgressMonitor();
            monitor.getEvent().setBurner(this.getBurner());
            burner.burn(monitor);
        } else {
            this.enableButtons();
        }
    }

    protected void enableButtons() {
    }

    protected boolean checkStatus(IStatus status) {
        boolean valid;
        if (status == Status.CANCEL_STATUS) {
            return false;
        }
        boolean bl = valid = status == null || status.isOK();
        if (!valid) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.FASTBOOT_MessageDialog_Title, (String)status.getMessage());
        }
        return valid;
    }

    protected abstract void createContents(Composite var1);

    protected abstract Layout createLayout();

    protected boolean isAlertWhenDone() {
        return FastbootPreferences.isDialogOn();
    }

    protected void erase() {
        IBurner burner = this.getBurner();
        if (burner instanceof IErasable) {
            IErasable eraseable = (IErasable)((Object)burner);
            if (!this.startInfo()) {
                this.enableButtons();
                return;
            }
            if (this.getBurner() instanceof EmmcBurner) {
                IFastbootProgressMonitor monitor = this.getProgressMonitor();
                monitor.getEvent().setBurner(this.getBurner());
                eraseable.erase(monitor);
            } else if (this.checkStatus(eraseable.checkBeforeErase())) {
                IFastbootProgressMonitor monitor = this.getProgressMonitor();
                monitor.getEvent().setBurner(this.getBurner());
                eraseable.erase(monitor);
            } else {
                this.enableButtons();
            }
        }
    }

    protected void eraseAll() {
        IBurner burner = this.getBurner();
        if (burner instanceof IErasable) {
            IErasable eraseable = (IErasable)((Object)burner);
            if (!this.startInfo()) {
                this.enableButtons();
                return;
            }
            if (burner.getBurnContext().getTransferWay() == TransferWay.GPT) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.FASTBOOT_MessageDialog_Title, (String)Messages.AddressComposite_Gpt_NotSupport_EraseAll);
                this.enableButtons();
                return;
            }
            IFastbootProgressMonitor monitor = this.getProgressMonitor();
            if (this.getBurner() instanceof CommonBurner) {
                monitor.getEvent().setBurner(this.getBurner());
                eraseable.eraseAll(monitor);
            } else if (this.getBurner() instanceof EmmcBurner) {
                monitor.getEvent().setBurner(this.getBurner());
                eraseable.erase(monitor);
            } else {
                monitor.getEvent().setBurner(this.getBurner());
                eraseable.eraseAll(monitor);
            }
        }
    }

    public IBurner getBurner() {
        return this.burner;
    }

    public IFastbootProgressMonitor getProgressMonitor() {
        if (this.progressMonitor == null) {
            this.progressMonitor = ToolUtils.isCmdLine() ? IFastbootProgressMonitor.PROGRESSMONITORCMDLINE : IFastbootProgressMonitor.PROGRESSMONITORCOMPOSITE;
        }
        return this.progressMonitor;
    }

    @Override
    public void updateLength(long length) {
    }

    public final void setLayout(Layout layout) {
    }

    protected void upload() {
        IBurner burner = this.getBurner();
        if (burner instanceof IUploadable) {
            IUploadable uploadable = (IUploadable)((Object)burner);
            if (!this.startInfo()) {
                this.enableButtons();
                return;
            }
            IStatus checkBeforeUpload = uploadable.checkBeforeUpload();
            if (checkBeforeUpload != null && checkBeforeUpload.getSeverity() == 8) {
                this.enableButtons();
                return;
            }
            if (this.checkStatus(checkBeforeUpload)) {
                uploadable.upload(this.getProgressMonitor());
            } else {
                this.enableButtons();
            }
        }
    }

    @Override
    public void started(FastbootEvent event) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        IViewPart findView = activePage.findView("org.eclipse.ui.console.ConsoleView");
        if (findView != null) {
            activePage.setPartState(activePage.getReference((IWorkbenchPart)findView), 2);
        } else {
            try {
                activePage.showView("org.eclipse.ui.console.ConsoleView");
            }
            catch (PartInitException partInitException) {}
        }
        this.disableUI();
    }

    protected void disableUI() {
        if (!this.isDisposed() && this.getParent() != null) {
            this.getParent().setEnabled(false);
        }
    }

    @Override
    public void finished(FastbootEvent event) {
        this.enableUI();
        if (event.getBurner() != this.getBurner()) {
            return;
        }
        if (this.isAlertWhenDone()) {
            String message = null;
            EventType type = event.getType();
            if (type == null) {
                return;
            }
            if (event.isUserCanceled()) {
                message = event.getMessage();
                if (message == null) {
                    message = "User Cancelled!";
                }
                IDEHelper.preOpenDialog();
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.FASTBOOT_MessageDialog_Title, (String)message);
                return;
            }
            if ((message = this.getMessageForAllEvent(event, message, type)) != null) {
                IDEHelper.preOpenDialog();
                final String tipsMessage = message;
                if (event.isSuccess()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)BurnComposite.this.getShell(), (String)Messages.FASTBOOT_MessageDialog_Title, (String)tipsMessage);
                        }
                    });
                } else {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)BurnComposite.this.getShell(), (String)Messages.FASTBOOT_MessageDialog_Title, (String)tipsMessage);
                        }
                    });
                }
            }
        }
    }

    private String getMessageForAllEvent(FastbootEvent event, String message, EventType type) {
        if (type == EventType.BURN) {
            message = this.getMessaageForBurn(event);
        } else if (type == EventType.ERASE) {
            message = this.getMessageForErase(event);
        } else if (type == EventType.UPLOAD) {
            message = this.getMessageForUpload(event);
        } else if (type == EventType.CREATE_IMAGE) {
            message = this.getMessageForCreateImage(event);
        } else if (type == EventType.CREATE_USB_PACKAGE) {
            message = this.getMessageForCreateUSB(event);
        }
        return message;
    }

    private String getMessageForCreateUSB(FastbootEvent event) {
        String message = event.getMessage();
        if (event.isSuccess()) {
            message = Messages.BurnComposite_Create_Usb_Package_Success;
        } else if (message == null) {
            message = Messages.BurnComposite_Create_Usb_Package_Failed;
        }
        return message;
    }

    private String getMessageForCreateImage(FastbootEvent event) {
        String message = event.getMessage();
        if (event.isSuccess()) {
            message = Messages.BurnComposite_Create_Image_Success;
        }
        return message;
    }

    private String getMessageForUpload(FastbootEvent event) {
        String message = event.getMessage();
        if (event.isSuccess()) {
            message = Messages.BurnComposite_Upload_Message_Success;
        } else if (message == null) {
            message = Messages.BurnComposite_Upload_Message_Failed;
        }
        return message;
    }

    private String getMessageForErase(FastbootEvent event) {
        String message = event.getMessage();
        if (event.isSuccess()) {
            message = Messages.BurnComposite_Erase_Message_Success;
        } else if (message == null) {
            message = Messages.BurnComposite_Erase_Message_Failed;
        }
        return message;
    }

    private String getMessaageForBurn(FastbootEvent event) {
        String message = event.getMessage();
        if (event.isSuccess()) {
            boolean isPartition;
            String totalBurnTime = event.getTotalBurnTime();
            boolean bl = isPartition = event.getBurner() instanceof PartitionBurner || event.getBurner() instanceof EmmcBurner;
            if (isPartition) {
                boolean totalBurnTimeVaild;
                boolean bl2 = totalBurnTimeVaild = totalBurnTime != null && !totalBurnTime.equalsIgnoreCase("");
                message = totalBurnTimeVaild ? String.valueOf(Messages.BurnComposite_Burn_Message_Success_And_Time) + totalBurnTime + "." : Messages.BurnComposite_Burn_Message_Success;
            } else {
                message = Messages.BurnComposite_Burn_Message_Success;
            }
        } else if (message == null) {
            message = Messages.BurnComposite_Burn_Message_Failed;
        }
        return message;
    }

    protected void enableUI() {
        if (!this.isDisposed() && this.getParent() != null) {
            this.getParent().setEnabled(true);
        }
    }

    @Override
    public void hightLight(List<PartitionItem> parts) {
    }

    @Override
    public IUIAdapter getUIAdapter() {
        return this.adapter;
    }

    @Override
    public void setUIAdapter(IUIAdapter adapter) {
        this.adapter = adapter;
        this.burner.getBurnContext().setUIAdapter(adapter);
    }
}

