/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.ui.burners;

import com.vendor.burn.Messages;
import com.vendor.burn.model.FlashType;
import com.vendor.burn.model.PartitionInfo;
import com.vendor.burn.model.PartitionItem;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.devices.IAddressBurner;
import com.vendor.burn.model.devices.burners.AbstractBurner;
import com.vendor.burn.ui.burners.FastbootComposite;
import com.vendor.burn.views.FastbootView;
import java.io.File;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class AddressComposite
extends FastbootComposite
implements SelectionListener {
    private Text lengthText;
    private Button eraseButton;
    private Button uploadButton;
    private Text addressText;
    private static String filePath;
    private static FlashType flashType;
    private long start;
    private long length;
    protected static final String LABEL_HEX = "(HEX)";

    public AddressComposite(Composite parent, int style, IBurner burner, TabItem tabItem2) {
        super(parent, style, burner, tabItem2);
    }

    protected void createAddressEditor(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.AddressComposite_Address);
        this.addressText = this.createHexText(parent);
        this.addressText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String text = AddressComposite.this.addressText.getText();
                if (text.trim().length() == 0) {
                    AddressComposite.this.getBurner().setAddress(null);
                } else {
                    AddressComposite.this.getBurner().setAddress(text);
                }
            }
        });
        label = new Label(parent, 0);
        label.setText(LABEL_HEX);
        GridData layoutData = new GridData(512);
        label.setLayoutData((Object)layoutData);
        new Label(parent, 0);
    }

    @Override
    protected void createContents(Composite parent) {
        this.createFlashTypeEditor(parent, flashType);
        if (FastbootView.isCJXX1Series()) {
            this.createFlashIdEditor(parent);
        }
        this.createAddressEditor(parent);
        this.createLengthEditor(parent);
        this.createFileEditor(parent);
        this.createProgrammerFileText(parent);
        this.createButtonsControl(parent);
        super.initData();
    }

    protected void getPartitionData(PartitionInfo partitionInfo) {
        if (partitionInfo != null) {
            String programmerFileStr;
            PartitionItem data = partitionInfo.getChildren().get(0);
            File programmerFile = partitionInfo.getProgrammerFile();
            String string = programmerFileStr = partitionInfo.getProgrammerFile() != null ? programmerFile.getPath() : "";
            if (this.programmerFileText != null) {
                this.programmerFileText.setText(programmerFileStr);
                ((AbstractBurner)((Object)this.getBurner())).setProgrammerFile(programmerFileStr);
            }
            this.length = data.getLength();
            this.start = data.getStart();
            try {
                this.lengthText.setText(String.valueOf(Long.toHexString(this.length)));
                this.addressText.setText(String.valueOf(Long.toHexString(this.start)));
            }
            catch (NumberFormatException numberFormatException) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Please check Length!!!");
            }
            flashType = data.getFlashType();
            this.updateFlashType(this, flashType);
            if (this.flashCombo != null && !this.flashCombo.isDisposed()) {
                this.flashCombo.select(data.getChipID().ordinal());
                this.getBurner().setFlashId(data.getChipID());
            }
            try {
                if (data.getFile() != null) {
                    filePath = data.getFile().getAbsolutePath();
                }
            }
            catch (Exception exception) {}
            if (filePath != null) {
                this.updateFileEditor(this, filePath);
            }
        }
    }

    protected Text createHexText(Composite parent) {
        Text hexText = new Text(parent, 2048);
        GridData layoutData = new GridData(768);
        hexText.setLayoutData((Object)layoutData);
        hexText.setTextLimit(10);
        hexText.addListener(25, (Listener)new HexVerifier());
        return hexText;
    }

    protected void createLengthEditor(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.AddressComposite_Length);
        this.lengthText = this.createHexText(parent);
        this.lengthText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String value = AddressComposite.this.lengthText.getText();
                if (value.trim().length() == 0) {
                    AddressComposite.this.getBurner().setLength(null);
                } else {
                    try {
                        Long.parseLong(value, 16);
                        AddressComposite.this.getBurner().setLength(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        MessageDialog.openError((Shell)AddressComposite.this.getShell(), (String)"Error", (String)"Please check Length!!!");
                    }
                }
            }
        });
        label = new Label(parent, 0);
        label.setText(LABEL_HEX);
        GridData layoutData = new GridData(512);
        label.setLayoutData((Object)layoutData);
        new Label(parent, 0);
    }

    @Override
    protected void fillButtons(Composite buttonComp, List<Button> buttons) {
        this.burnButton = this.createButton(buttonComp, LABEL_BURN);
        this.burnButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AddressComposite.this.burnButton.setEnabled(false);
                AddressComposite.this.burn();
            }
        });
        this.eraseButton = this.createButton(buttonComp, LABEL_ERASE);
        this.eraseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (!AddressComposite.this.isErase()) {
                    return;
                }
                AddressComposite.this.eraseButton.setEnabled(false);
                AddressComposite.this.erase();
            }
        });
        this.uploadButton = this.createButton(buttonComp, LABEL_UPLOAD);
        this.uploadButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AddressComposite.this.uploadButton.setEnabled(false);
                AddressComposite.this.upload();
            }
        });
        buttons.add(this.burnButton);
        buttons.add(this.eraseButton);
        buttons.add(this.uploadButton);
    }

    @Override
    protected void enableUI() {
        this.getUIAdapter().enableBoradChange();
        if (this.isDisposed()) {
            return;
        }
        this.enableButtons();
    }

    @Override
    protected void enableButtons() {
        super.enableButtons();
        if (this.burnButton != null && !this.burnButton.isDisposed()) {
            this.burnButton.setEnabled(true);
        }
        if (this.eraseButton != null && !this.eraseButton.isDisposed()) {
            this.eraseButton.setEnabled(true);
        }
        if (this.uploadButton != null && !this.uploadButton.isDisposed()) {
            this.uploadButton.setEnabled(true);
        }
    }

    @Override
    protected void disableUI() {
        this.getUIAdapter().disableBoradChange();
        if (this.isDisposed()) {
            return;
        }
        if (this.burnButton != null && !this.burnButton.isDisposed()) {
            this.burnButton.setEnabled(false);
        }
        if (this.eraseButton != null && !this.eraseButton.isDisposed()) {
            this.eraseButton.setEnabled(false);
        }
        if (this.uploadButton != null && !this.uploadButton.isDisposed()) {
            this.uploadButton.setEnabled(false);
        }
    }

    @Override
    public IAddressBurner getBurner() {
        return (IAddressBurner)super.getBurner();
    }

    @Override
    public void updateLength(long length) {
        String hexString = Long.toHexString(length);
        this.getBurner().setLength(hexString);
        if (this.lengthText == null || this.isDisposed()) {
            return;
        }
        this.lengthText.setText(this.getBurner().getLength());
    }

    @Override
    protected void handleBrwoseFileCA() {
        String filePath;
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        String text = this.programmerFileText.getText();
        if (!text.equals("")) {
            dialog.setFileName(text);
        }
        if ((filePath = dialog.open()) != null) {
            this.programmerFileText.setText(filePath);
            File bootFile = new File(filePath);
            if (bootFile.exists()) {
                ((AbstractBurner)((Object)this.getBurner())).setProgrammerFile(filePath);
            }
        }
    }

    @Override
    protected void createProgrammerFileText(Composite parent) {
        Label programmerFileLabel = new Label(parent, 0);
        programmerFileLabel.setText(Messages.FastbootComposite_LABEL_PROGRAMER_FILE);
        this.programmerFileText = new Text(parent, 2048);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.programmerFileText.setEnabled(false);
        this.programmerFileText.setLayoutData((Object)layoutData);
        this.programmerFileBrowseButton = new Button(parent, 0);
        this.programmerFileBrowseButton.setLayoutData((Object)new GridData());
        this.programmerFileBrowseButton.setText(LABEL_BROWSE);
        this.programmerFileBrowseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AddressComposite.this.handleBrwoseFileCA();
            }
        });
    }

    public void widgetSelected(SelectionEvent e) {
        this.getPartitionData((PartitionInfo)e.data);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private static class HexVerifier
    implements Listener {
        private HexVerifier() {
        }

        public void handleEvent(Event e) {
            Text text = (Text)e.widget;
            StringBuffer newText = new StringBuffer();
            newText.setLength(10);
            char[] textChars = text.getTextChars();
            int i = 0;
            while (i < textChars.length) {
                newText.setCharAt(i, textChars[i]);
                ++i;
            }
            char[] chars = e.text.toCharArray();
            int index = e.start - 1;
            int i2 = 0;
            while (i2 < e.text.length()) {
                if (++index >= newText.length()) {
                    e.doit = false;
                    return;
                }
                newText.setCharAt(index, chars[i2]);
                ++i2;
            }
            newText.trimToSize();
            String value = newText.toString().trim();
            try {
                Long.parseLong(value, 16);
            }
            catch (NumberFormatException numberFormatException) {
                e.doit = false;
            }
        }
    }
}

