/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.ui.burners;

import com.vendor.burn.Activator;
import com.vendor.burn.Messages;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.define.ICheckerBoard;
import com.vendor.burn.model.define.IFastbootProgressMonitor;
import com.vendor.burn.model.devices.burners.BoardCheckBurner;
import com.vendor.burn.model.event.EventType;
import com.vendor.burn.model.event.FastbootEvent;
import com.vendor.burn.ui.BurnComposite;
import com.vendor.burn.views.LightView;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class BoradCheckComposite
extends BurnComposite {
    private Composite control;
    private Button btnCheckBorad;
    private Text textInfo;
    static RGB RGB_RECEIVED = new RGB(255, 0, 0);
    static RGB WHITE_RECEIVED = new RGB(255, 255, 255);

    public BoradCheckComposite(Composite parent, int style, IBurner burner) {
        super(parent, style, burner);
    }

    @Override
    protected void createContents(Composite parent) {
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new GridLayout(1, false));
        this.control.setLayoutData((Object)new GridData(1808));
        this.btnCheckBorad = new Button(this.control, 8);
        this.btnCheckBorad.setImage(Activator.getImage("icons/fix.png"));
        this.btnCheckBorad.setText(Messages.BoardCheckComposite_CheckBorad_Button);
        this.btnCheckBorad.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BoradCheckComposite.this.disableUI();
                BoradCheckComposite.this.checkBoard();
            }
        });
        GridData btnCheckGD = new GridData(2, 1, true, false);
        btnCheckGD.widthHint = 250;
        this.btnCheckBorad.setLayoutData((Object)btnCheckGD);
        this.textInfo = new Text(this.control, 2570);
        this.textInfo.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.textInfo.setText(String.valueOf(Messages.BoardCheckComposite_CheckBorad_StartInfo) + ":\r\n");
    }

    private void checkBoard() {
        IFastbootProgressMonitor monitor = this.getProgressMonitor();
        monitor.begin();
        ICheckerBoard checker = (ICheckerBoard)this.getBurner();
        if (this.checkStatus(checker.checkBeforeCheck())) {
            monitor.getEvent().setBurner(checker);
            checker.check(monitor);
        } else {
            monitor.finish();
        }
    }

    private void updateTextInfo(String message) {
        if (this.textInfo.isDisposed()) {
            return;
        }
        this.textInfo.setText(message.trim());
        this.textInfo.setForeground(new Color(null, RGB_RECEIVED));
        this.textInfo.setTopIndex(Integer.MAX_VALUE);
    }

    @Override
    protected Layout createLayout() {
        return new GridLayout(1, false);
    }

    @Override
    protected void disableUI() {
        super.disableUI();
        if (this.btnCheckBorad != null && !this.btnCheckBorad.isDisposed()) {
            this.btnCheckBorad.setEnabled(false);
        }
    }

    @Override
    protected void enableUI() {
        super.enableUI();
        if (this.btnCheckBorad != null && !this.btnCheckBorad.isDisposed()) {
            this.btnCheckBorad.setEnabled(true);
        }
    }

    @Override
    public void started(FastbootEvent event) {
        if (event.getBurner() instanceof BoardCheckBurner) {
            IViewPart view;
            if (PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(LightView.ID) != null && (view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(LightView.ID)) != null) {
                LightView lightView = (LightView)view;
                lightView.getTftplbl().setVisible(false);
            }
            super.started(event);
            if (event.getBurner() == this.getBurner()) {
                this.btnCheckBorad.setEnabled(false);
            }
            if (!this.textInfo.isDisposed()) {
                this.textInfo.setText(String.valueOf(Messages.BoardCheckComposite_CheckBorad_StartInfo) + ":\r\n");
            }
        }
    }

    @Override
    public void finished(FastbootEvent event) {
        if (event.getBurner() instanceof BoardCheckBurner) {
            String message;
            this.enableUI();
            if (event.getBurner() == this.getBurner()) {
                this.btnCheckBorad.setEnabled(true);
            }
            if (event.getType() == EventType.CHECK && (message = event.getMessage()) != null && message.trim().length() != 0) {
                this.updateTextInfo(message);
            }
        }
    }
}

