/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.ui.burners;

import com.vendor.burn.Messages;
import com.vendor.burn.model.FlashType;
import com.vendor.burn.model.PartitionItem;
import com.vendor.burn.model.PlatformType;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.define.IFastbootProgressMonitor;
import com.vendor.burn.model.devices.ICommonBurner;
import com.vendor.burn.model.devices.burners.AbstractBurner;
import com.vendor.burn.model.devices.burners.CommonBurner;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import com.vendor.burn.ui.burners.PartitionComposite;
import com.vendor.burn.ui.dialog.SelectProDialog;
import com.vendor.burn.utilitily.ToolUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class CommonComposite
extends PartitionComposite {
    private Button uploadButton;
    private Button eraseButton;
    private Button eraseAllButton;
    private Button createPartitionTable;
    private Button browseButton;
    private Button createImageButton;

    public CommonComposite(Composite parent, int style, IBurner burner) {
        super(parent, style, burner);
    }

    @Override
    protected IContentProvider createContentProvider() {
        return new ViewerContentProvider();
    }

    @Override
    protected void createContents(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Composite com = new Composite(parent, 0);
        com.setLayout((Layout)new GridLayout(6, false));
        GridData gridData = new GridData(1808);
        com.setLayoutData((Object)gridData);
        this.useXMLPathAsParentButton = new Button(com, 32);
        GridData layoutData = new GridData();
        this.useXMLPathAsParentButton.setLayoutData((Object)layoutData);
        this.useXMLPathAsParentButton.setText(Messages.PartitionComposite_LABEL_Default_Use_XML_Path);
        this.useXMLPathAsParentButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String text = CommonComposite.this.tableFileText.getText().trim();
                File file = new File(text);
                if (file.exists()) {
                    CommonComposite.this.loadPartitionFile(file, CommonComposite.this.useXMLPathAsParentButton.getSelection());
                }
            }
        });
        this.useXMLPathAsParentButton.setSelection(true);
        Label label = new Label(com, 0);
        label.setText(Messages.CommonComposite_LABEL_PartitionFile);
        this.tableFileText = new Text(com, 2048);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.tableFileText.setLayoutData((Object)layoutData);
        this.tableFileText.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                CommonComposite.this.handleEnterOnTableFileText();
            }
        });
        this.browseButton = new Button(com, 0);
        layoutData = new GridData();
        ToolUtils.setWidthForOS(layoutData, 60, 70);
        this.browseButton.setLayoutData((Object)layoutData);
        this.browseButton.setText(LABEL_BROWSE);
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CommonComposite.this.handleBrowseFile();
            }
        });
        this.saveButton = new Button(com, 0);
        this.saveButton.setLayoutData((Object)layoutData);
        this.saveButton.setText(LABEL_SAVE);
        this.saveButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CommonComposite.this.savePartitionTable();
            }
        });
        int emmcType = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getEmmcType();
        if (emmcType == 1) {
            this.createPartitionTable = new Button(com, 32);
            this.createPartitionTable.setText(Messages.EmmcComposite_Create_eMMC_Partition_Table);
            this.createPartitionTable.setLayoutData((Object)new GridData(1, 1, false, false));
            this.createPartitionTable.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ICommonBurner burner = CommonComposite.this.getBurner();
                    burner.setCreatePartitionTable(CommonComposite.this.createPartitionTable.getSelection());
                }
            });
            this.createPartitionTable.setSelection(this.getBurner().isCreatePartitionTable());
        } else if (this.getBurner().getBurnContext().getPlatformType() == PlatformType.CA || ((UnknownDevice)this.getBurner().getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) {
            this.createPartitionTable = new Button(com, 32);
            this.createPartitionTable.setText(Messages.EmmcComposite_Create_eMMC_Partition_Table);
            this.createPartitionTable.setVisible(false);
        }
        if (this.getBurner().getBurnContext().getPlatformType() == PlatformType.CA || ((UnknownDevice)this.getBurner().getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) {
            Label programmerFileLabel = new Label(com, 0);
            programmerFileLabel.setText(Messages.EmmcComposite_LABEL_PROGRAMER_FILE);
            GridData programmerLblGD = new GridData(1, 1, false, false);
            programmerFileLabel.setLayoutData((Object)programmerLblGD);
            this.programmerFileText = new Text(com, 2048);
            GridData programmerFileTextLayout = new GridData(4, 1, true, false);
            programmerFileTextLayout.horizontalSpan = 2;
            this.programmerFileText.setLayoutData((Object)programmerFileTextLayout);
            this.programmerFileText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ((AbstractBurner)((Object)CommonComposite.this.getBurner())).setProgrammerFile(CommonComposite.this.programmerFileText.getText().trim());
                    CommonComposite.this.getBurner().getPratitionInfo().setProgrammerFile(new File(CommonComposite.this.programmerFileText.getText().trim()));
                }
            });
            this.programmerFileBrowseButton = new Button(com, 0);
            GridData programmerBtnLayout = new GridData(1, 1, false, false);
            ToolUtils.setWidthForOS(programmerBtnLayout, 125, 145);
            programmerBtnLayout.horizontalSpan = 2;
            this.programmerFileBrowseButton.setLayoutData((Object)programmerBtnLayout);
            this.programmerFileBrowseButton.setText(LABEL_BROWSE);
            this.programmerFileBrowseButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    CommonComposite.this.handleBrwoseProgrammerFile();
                }
            });
        }
        this.createButtons(com);
        Control tableControl = this.createItemTable(com);
        this.itemViewer = (CheckboxTableViewer)tableControl.getData();
        this.itemViewer.setInput((Object)this.getBurner());
        GridData layoutData2 = new GridData(4, 4, true, true, 6, 1);
        tableControl.setLayoutData((Object)layoutData2);
        this.initData();
    }

    @Override
    protected Layout createLayout() {
        return new GridLayout(5, false);
    }

    @Override
    protected String getCreateImageButtonCaption() {
        return Messages.CommonComposite_LABEL_Create_BurningImg;
    }

    @Override
    protected void enableButtons() {
        if (this.burnButton != null && !this.burnButton.isDisposed()) {
            this.burnButton.setEnabled(true);
        }
        if (this.eraseButton != null && !this.eraseButton.isDisposed()) {
            this.eraseButton.setEnabled(true);
        }
        if (this.eraseAllButton != null && !this.eraseAllButton.isDisposed()) {
            this.eraseAllButton.setEnabled(true);
        }
        if (this.uploadButton != null && !this.uploadButton.isDisposed()) {
            this.uploadButton.setEnabled(true);
        }
        if (this.createImageButton != null && !this.createImageButton.isDisposed()) {
            this.createImageButton.setEnabled(true);
        }
        if (this.browseButton != null && !this.browseButton.isDisposed()) {
            this.browseButton.setEnabled(true);
        }
        if (this.saveButton != null && !this.saveButton.isDisposed()) {
            this.saveButton.setEnabled(true);
        }
        if (this.createPartitionTable != null && !this.createPartitionTable.isDisposed()) {
            this.createPartitionTable.setEnabled(true);
        }
        if (this.programmerFileBrowseButton != null && !this.programmerFileBrowseButton.isDisposed()) {
            this.programmerFileBrowseButton.setEnabled(true);
        }
        if (this.createUsbPackageButton != null && !this.createUsbPackageButton.isDisposed()) {
            this.createUsbPackageButton.setEnabled(true);
        }
    }

    @Override
    protected void enableUI() {
        super.enableUI();
        if (this.isDisposed()) {
            return;
        }
        this.enableButtons();
    }

    @Override
    protected void createButtons(Composite parent) {
        Composite buttonComp = new Composite(parent, 0);
        buttonComp.setLayout((Layout)new GridLayout(6, true));
        GridData gd = new GridData();
        gd.horizontalSpan = 6;
        buttonComp.setLayoutData((Object)gd);
        this.burnButton = new Button(buttonComp, 0);
        this.burnButton.setText(LABEL_BURN);
        GridData layoutData = new GridData(576);
        layoutData.widthHint = 120;
        this.burnButton.setLayoutData((Object)layoutData);
        this.burnButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CommonComposite.this.burnButton.setEnabled(false);
                CommonComposite.this.burn();
            }
        });
        this.eraseButton = new Button(buttonComp, 0);
        this.eraseButton.setText(LABEL_ERASE);
        layoutData = new GridData(576);
        layoutData.widthHint = 120;
        this.eraseButton.setLayoutData((Object)layoutData);
        this.eraseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CommonComposite.this.eraseButton.setEnabled(false);
                CommonComposite.this.erase();
            }
        });
        this.eraseAllButton = new Button(buttonComp, 0);
        this.eraseAllButton.setText(Messages.EmmcComposite_EmmcEraseAll);
        layoutData = new GridData(576);
        layoutData.widthHint = 120;
        this.eraseAllButton.setLayoutData((Object)layoutData);
        this.eraseAllButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (!CommonComposite.this.isErase()) {
                    return;
                }
                CommonComposite.this.eraseAllButton.setEnabled(false);
                CommonComposite.this.eraseAll();
            }
        });
        this.uploadButton = new Button(buttonComp, 0);
        this.uploadButton.setText(LABEL_UPLOAD);
        layoutData = new GridData(576);
        layoutData.widthHint = 120;
        this.uploadButton.setLayoutData((Object)layoutData);
        this.uploadButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CommonComposite.this.uploadButton.setEnabled(false);
                CommonComposite.this.upload();
            }
        });
        this.createImageButton = new Button(buttonComp, 0);
        this.createImageButton.setText(this.getCreateImageButtonCaption());
        layoutData = new GridData(576);
        ToolUtils.setWidthForOS(layoutData, 140, 160);
        this.createImageButton.setLayoutData((Object)layoutData);
        this.createImageButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CommonComposite.this.disableUI();
                List<PartitionItem> children = CommonComposite.this.getBurner().getPratitionInfo().getChildren();
                boolean onlySelectEmmc = FlashType.isOnlySelectCurFlashType(children, FlashType.emmc);
                if (onlySelectEmmc) {
                    for (PartitionItem partitionItem : children) {
                        partitionItem.setChecked(true);
                    }
                    CommonComposite.this.updateSelection();
                } else if (FlashType.isEmmc(children, FlashType.emmc)) {
                    for (PartitionItem partitionItem : children) {
                        partitionItem.setChecked(partitionItem.getFlashType().equals((Object)FlashType.emmc));
                    }
                    CommonComposite.this.updateSelection();
                }
                CommonComposite.this.createImage();
                CommonComposite.this.enableUI();
            }
        });
        this.createUsbPackageButton = new Button(buttonComp, 0);
        this.createUsbPackageButton.setText(LABEL_CREATE_USB_PACKAGE);
        layoutData = new GridData(576);
        ToolUtils.setWidthForOS(layoutData, 135, 160);
        this.createUsbPackageButton.setLayoutData((Object)layoutData);
        this.createUsbPackageButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (!CommonComposite.this.checkStatus(((CommonBurner)CommonComposite.this.getBurner()).checkCreateProImage())) {
                    return;
                }
                List<PartitionItem> children = CommonComposite.this.getBurner().getPratitionInfo().getChildren();
                int size = children.size();
                int i = 0;
                while (i < size) {
                    PartitionItem partition = children.get(i);
                    if (i == size - 1 && partition.isChecked() && !((CommonBurner)CommonComposite.this.getBurner()).getBurnerWorker().checkLastPartition(children)) {
                        return;
                    }
                    ++i;
                }
                SelectProDialog selectProDialog = new SelectProDialog(Display.getCurrent().getActiveShell(), 67680, CommonComposite.this.burner, children);
                selectProDialog.open();
                if (selectProDialog.getStatus() == 0) {
                    String selectProWay = selectProDialog.getSelectProWay();
                    if (selectProWay.equals("serial")) {
                        CommonComposite.this.handleCreateUsbPackage();
                    } else if (selectProWay.equals("usb")) {
                        try {
                            FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 8192);
                            dialog.setOverwrite(true);
                            dialog.setFileName("pro_usb.zip");
                            String filePath = dialog.open();
                            if (filePath != null) {
                                CommonComposite.this.disableUI();
                                IFastbootProgressMonitor monitor = CommonComposite.this.getProgressMonitor();
                                monitor.getEvent().setBurner(CommonComposite.this.getBurner());
                                filePath = dialog.getFilterPath();
                                String fileName = dialog.getFileName();
                                CommonComposite.this.handleCreateProUsb(monitor, filePath, fileName);
                            }
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                    }
                }
            }
        });
        buttonComp.setLayoutData((Object)new GridData(4, 1, true, false, 5, 1));
    }

    @Override
    protected void disableUI() {
        super.disableUI();
        if (this.isDisposed()) {
            return;
        }
        if (this.eraseButton != null && !this.eraseButton.isDisposed()) {
            this.eraseButton.setEnabled(false);
        }
        if (this.eraseAllButton != null && !this.eraseAllButton.isDisposed()) {
            this.eraseAllButton.setEnabled(false);
        }
        if (this.uploadButton != null && !this.uploadButton.isDisposed()) {
            this.uploadButton.setEnabled(false);
        }
        if (this.createImageButton != null && !this.createImageButton.isDisposed()) {
            this.createImageButton.setEnabled(false);
        }
        if (this.browseButton != null && !this.browseButton.isDisposed()) {
            this.browseButton.setEnabled(false);
        }
        if (this.saveButton != null && !this.saveButton.isDisposed()) {
            this.saveButton.setEnabled(false);
        }
        if (this.createPartitionTable != null && !this.createPartitionTable.isDisposed()) {
            this.createPartitionTable.setEnabled(false);
        }
        if (this.programmerFileBrowseButton != null && !this.programmerFileBrowseButton.isDisposed()) {
            this.programmerFileBrowseButton.setEnabled(false);
        }
        if (this.createUsbPackageButton != null && !this.createUsbPackageButton.isDisposed()) {
            this.createUsbPackageButton.setEnabled(false);
        }
    }

    @Override
    public ICommonBurner getBurner() {
        return (ICommonBurner)super.getBurner();
    }

    @Override
    protected void handleCreateUsbPackage() {
        List<PartitionItem> children = this.getBurner().getPratitionInfo().getChildren();
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setOverwrite(true);
        dialog.setFileName("usb_update.bin");
        String filePath = dialog.open();
        if (filePath != null) {
            this.disableUI();
            IFastbootProgressMonitor monitor = this.getProgressMonitor();
            monitor.getEvent().setBurner(this.getBurner());
            ((CommonBurner)this.getBurner()).createProImage(monitor, filePath, children);
        }
    }

    private static class ViewerContentProvider
    implements IStructuredContentProvider {
        private ViewerContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof CommonBurner) {
                return ((CommonBurner)inputElement).getChildren().toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

