/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.ui.burners;

import com.vendor.burn.Activator;
import com.vendor.burn.Messages;
import com.vendor.burn.model.FlashType;
import com.vendor.burn.model.PlatformType;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.devices.IBootBurner;
import com.vendor.burn.model.devices.IDeviceSetting;
import com.vendor.burn.model.devices.IUIAdapter;
import com.vendor.burn.model.devices.burners.AbstractBurner;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import com.vendor.burn.model.dqInfo;
import com.vendor.burn.model.phyInfo;
import com.vendor.burn.ui.BurnComposite;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class DdrCheckComposite
extends BurnComposite {
    public static final String ID = DdrCheckComposite.class.getName();
    protected static Image greenLight = Activator.getImage("icons//green_light.png");
    protected static Image redLight = Activator.getImage("icons/red_light.png");
    protected static Image grayLight = Activator.getImage("icons/white_light.png");
    protected static List<ImageHyperlink> phylblList = new ArrayList<ImageHyperlink>();
    protected Button burnButton;
    protected Text programmerFileText;
    protected Button programmerFileBrowseButton;
    private Button browseButton;
    private Combo flashTypeCombo;
    private Text fileText;
    private static ScrolledComposite scrolledComposite;
    private static Composite parent;
    private static String initLabelName;
    private static String acOrDqsLabelName;
    private static String zQLabelName;
    private static String dQLabelName;
    private static String PASS;
    private static String FAIL;
    private static Color green;
    private static Color red;

    static {
        initLabelName = "init :";
        acOrDqsLabelName = "AC or CLK or DQS:";
        zQLabelName = "ZQ :";
        dQLabelName = "DQ :";
        PASS = " Pass";
        FAIL = " Fail";
    }

    public DdrCheckComposite(Composite parent, int style, IBurner burner) {
        super(parent, style, burner);
        green = new Color((Device)parent.getDisplay(), 0, 255, 0);
        red = new Color((Device)parent.getDisplay(), 255, 0, 0);
    }

    @Override
    public IBootBurner getBurner() {
        if (super.getBurner() instanceof IBootBurner) {
            return (IBootBurner)super.getBurner();
        }
        return null;
    }

    public static void createPartControl(List<phyInfo> phyInfoList) {
        if (scrolledComposite != null && !scrolledComposite.isDisposed()) {
            scrolledComposite.dispose();
        }
        scrolledComposite = new ScrolledComposite(parent, 2560);
        GridData scrollableLayoutData = new GridData(1808);
        scrollableLayoutData.horizontalSpan = 4;
        scrolledComposite.setLayoutData((Object)scrollableLayoutData);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinWidth(300);
        scrolledComposite.setMinHeight(900);
        scrolledComposite.setAlwaysShowScrollBars(true);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(1808);
        gd.heightHint = 1;
        composite.setLayoutData((Object)gd);
        scrolledComposite.setContent((Control)composite);
        GridData layoutData1 = new GridData(1808);
        Composite compositePhy0 = new Composite(composite, 2048);
        compositePhy0.setLayout((Layout)new GridLayout(3, false));
        compositePhy0.setLayoutData((Object)layoutData1);
        Composite compositePhy1 = new Composite(composite, 2048);
        compositePhy1.setLayout((Layout)new GridLayout(3, false));
        compositePhy1.setLayoutData((Object)layoutData1);
        ImageHyperlink link = new ImageHyperlink(compositePhy0, 0);
        link.setUnderlined(true);
        link.setText("DDR0");
        DdrCheckComposite.setLinkFontSize(link, compositePhy0);
        link.setImage(grayLight);
        ImageHyperlink link1 = new ImageHyperlink(compositePhy1, 0);
        link1.setUnderlined(true);
        link1.setText("DDR1");
        DdrCheckComposite.setLinkFontSize(link1, compositePhy1);
        link1.setImage(grayLight);
        DdrCheckComposite.addHyperlinkListenerToView(link, "");
        DdrCheckComposite.addHyperlinkListenerToView(link1, "");
        DdrCheckComposite.changeLightStatu(phyInfoList, link1, link, compositePhy0, compositePhy1);
        parent.layout();
    }

    private static void changeLightColor(ImageHyperlink link, ImageHyperlink link1, phyInfo info, int i) {
        if (info.getStatu().toString() == "GREEN" && i == 0) {
            link.setImage(greenLight);
        }
        if (info.getStatu().toString() == "RED" && i == 0) {
            link.setImage(redLight);
        }
        if (info.getStatu().toString() == "GREEN" && i == 1) {
            link1.setImage(greenLight);
        }
        if (info.getStatu().toString() == "RED" && i == 1) {
            link1.setImage(redLight);
        }
    }

    private static void changeLightStatu(List<phyInfo> phyInfoList, ImageHyperlink link1, ImageHyperlink link, Composite compositePhy0, Composite compositePhy1) {
        if (phyInfoList != null) {
            int i = 0;
            while (i < phyInfoList.size()) {
                phyInfo info = phyInfoList.get(i);
                DdrCheckComposite.changeLightColor(link, link1, info, i);
                Label initLabel = null;
                Label aCorDQSLabel = null;
                Label zQLabel = null;
                Label dQLabel = null;
                if (i == 0) {
                    initLabel = new Label(compositePhy0, 0);
                    aCorDQSLabel = new Label(compositePhy0, 0);
                    zQLabel = new Label(compositePhy0, 0);
                    dQLabel = new Label(compositePhy0, 0);
                } else {
                    initLabel = new Label(compositePhy1, 0);
                    aCorDQSLabel = new Label(compositePhy1, 0);
                    zQLabel = new Label(compositePhy1, 0);
                    dQLabel = new Label(compositePhy1, 0);
                }
                DdrCheckComposite.setLabelStyle(initLabel, aCorDQSLabel, zQLabel, dQLabel, info, i, compositePhy0, compositePhy1);
                ++i;
            }
        }
    }

    private static void setLabelStyle(Label initLabel, Label aCorDQSLabel, Label zQLabel, Label dQLabel, phyInfo info, int i, Composite compositePhy0, Composite compositePhy1) {
        List<dqInfo> dqInfoList = info.getDqInfoList();
        Composite com = null;
        if (dqInfoList != null) {
            com = i == 0 ? compositePhy0 : compositePhy1;
            Composite dQComposite = new Composite(com, 0);
            dQComposite.setLayout((Layout)new GridLayout(3, true));
            GridData gd = new GridData(1808);
            dQComposite.setLayoutData((Object)gd);
            Label singleDQLabel = null;
            int j = 0;
            while (j < dqInfoList.size()) {
                singleDQLabel = new Label(dQComposite, 0);
                GridData grid = new GridData(0, 0, true, true, 3, 1);
                singleDQLabel.setLayoutData((Object)grid);
                if (dqInfoList.get(j).getStatu() == dqInfo.STATU.GREEN) {
                    singleDQLabel.setText(String.valueOf(dqInfoList.get(j).getName()) + PASS);
                    singleDQLabel.setForeground(green);
                } else {
                    singleDQLabel.setText(String.valueOf(dqInfoList.get(j).getName()) + FAIL);
                    singleDQLabel.setForeground(red);
                }
                ++j;
            }
        }
        initLabel.setText(String.valueOf(initLabelName) + info.getInit());
        initLabel.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        DdrCheckComposite.setLabelFontSize(initLabel, com);
        aCorDQSLabel.setText(String.valueOf(acOrDqsLabelName) + info.getAcordqs());
        aCorDQSLabel.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        DdrCheckComposite.setLabelFontSize(aCorDQSLabel, com);
        zQLabel.setText(String.valueOf(zQLabelName) + info.getZq());
        zQLabel.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        DdrCheckComposite.setLabelFontSize(zQLabel, com);
        dQLabel.setText(String.valueOf(dQLabelName) + info.getDq());
        dQLabel.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        DdrCheckComposite.setLabelForegroundColor(initLabel, aCorDQSLabel, zQLabel, dQLabel, info);
        DdrCheckComposite.setLabelFontSize(dQLabel, com);
        ArrayList<Label> dQLabelList = new ArrayList<Label>();
        DdrCheckComposite.setDqLabelForegroundColor(dQLabel, dQLabelList, info);
    }

    private static void setDqLabelForegroundColor(Label dQLabel, ArrayList<Label> dQLabelList, phyInfo info) {
        if (info.getInit() == null || info.getInit().isEmpty()) {
            return;
        }
        String dq = info.getDq();
        if (dq == null || dq.isEmpty()) {
            return;
        }
        if (dq.toLowerCase().equals("pass")) {
            int i = 0;
            while (i < dQLabelList.size()) {
                dQLabelList.get(i).setForeground(green);
                ++i;
            }
        } else {
            int i = 0;
            while (i < dQLabelList.size()) {
                dQLabelList.get(i).setForeground(red);
                ++i;
            }
        }
    }

    private static void setLinkFontSize(ImageHyperlink link, Composite com) {
        link.setFont(new Font((Device)com.getDisplay(), Messages.Font_Style, 14, 1));
    }

    private static void setLabelFontSize(Label initLabel, Composite com) {
        if (com != null) {
            initLabel.setFont(new Font((Device)com.getDisplay(), Messages.Font_Style, 14, 1));
        }
    }

    private static void setLabelForegroundColor(Label initLabel, Label aCorDQSLabel, Label zQLabel, Label dQLabel, phyInfo phyinfo) {
        if (phyinfo.getInit() == null || phyinfo.getInit().isEmpty()) {
            return;
        }
        boolean initSuccess = DdrCheckComposite.updateInitSuccess(phyinfo);
        if (dQLabel == null || initLabel == null || aCorDQSLabel == null || zQLabel == null) {
            return;
        }
        if (initSuccess) {
            initLabel.setForeground(green);
        } else {
            initLabel.setForeground(red);
        }
        String dq = phyinfo.getDq();
        if (dq == null || dq.isEmpty()) {
            return;
        }
        if (dq.toLowerCase().equals("pass")) {
            dQLabel.setForeground(green);
        } else {
            dQLabel.setForeground(red);
        }
        String acorDqs = phyinfo.getAcordqs();
        if (acorDqs.toLowerCase().equals("/")) {
            aCorDQSLabel.setForeground(green);
        } else {
            aCorDQSLabel.setForeground(red);
        }
        String zq = phyinfo.getZq();
        if (zq.toLowerCase().equals("pass")) {
            zQLabel.setForeground(green);
        } else {
            zQLabel.setForeground(red);
        }
    }

    private static boolean updateInitSuccess(phyInfo phyinfo) {
        boolean initSuccess = true;
        char[] initArray = null;
        initArray = phyinfo.getInit().startsWith("0x") ? phyinfo.getInit().substring(2).toCharArray() : phyinfo.getInit().toCharArray();
        int i = 0;
        while (i < initArray.length) {
            if (initArray[i] != '0') {
                initSuccess = false;
                break;
            }
            ++i;
        }
        return initSuccess;
    }

    protected Button createButton(Composite buttonComp, String label) {
        Button button = new Button(buttonComp, 0);
        button.setText(label);
        GridData layoutData = new GridData(576);
        layoutData.minimumWidth = 100;
        button.setLayoutData((Object)layoutData);
        return button;
    }

    protected List<Button> createButtons(Composite buttonComp) {
        ArrayList<Button> buttons = new ArrayList<Button>();
        this.fillButtons(buttonComp, buttons);
        return buttons;
    }

    protected void createButtonsControl(Composite parent) {
        Composite buttonComp = new Composite(parent, 0);
        GridData layoutData = new GridData(776);
        layoutData.horizontalSpan = 3;
        buttonComp.setLayoutData((Object)layoutData);
        List<Button> buttons = this.createButtons(buttonComp);
        buttonComp.setLayout((Layout)new GridLayout(buttons.size(), true));
    }

    @Override
    protected void createContents(Composite parent) {
        DdrCheckComposite.parent = parent;
        this.createFlashTypeEditor(parent, null);
        this.createFileEditor(parent);
        IDeviceSetting setting = this.getBurner().getBurnContext().getDeviceSetting();
        if (setting instanceof UnknownDevice && (this.getBurner().getBurnContext().getPlatformType() == PlatformType.CA || ((UnknownDevice)setting).isSupportBurnByLibBootrom())) {
            this.createProgrammerFileText(parent);
        }
        this.createButtonsControl(parent);
        this.initData();
    }

    protected void initData() {
        IBootBurner burner = this.getBurner();
        String[] flashNames = burner.getBurnContext().getDeviceSetting().getFlashSetting().getFlashNames(burner);
        this.flashTypeCombo.setItems(new String[]{flashNames[2]});
        this.flashTypeCombo.select(0);
    }

    protected void createFileEditor(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(LABEL_FILE);
        this.fileText = new Text(parent, 2048);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.fileText.setLayoutData((Object)layoutData);
        this.fileText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String filePath = DdrCheckComposite.this.fileText.getText();
                if (filePath.trim().length() == 0) {
                    DdrCheckComposite.this.fileText.setText("");
                } else {
                    DdrCheckComposite.this.getBurner().setFile(filePath);
                }
            }
        });
        this.fileText.setEnabled(false);
        this.browseButton = new Button(parent, 0);
        this.browseButton.setText(LABEL_BROWSE);
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String filePath;
                FileDialog dialog = new FileDialog(DdrCheckComposite.this.getShell(), 4096);
                String text = DdrCheckComposite.this.fileText.getText();
                if (!text.equals("")) {
                    dialog.setFileName(text);
                }
                if ((filePath = dialog.open()) != null) {
                    DdrCheckComposite.this.fileText.setText(filePath);
                    DdrCheckComposite.this.getBurner().setFile(filePath);
                }
            }
        });
    }

    protected void updateFileEditor(Composite parent, String filePath) {
        this.fileText.setText(String.valueOf(filePath));
    }

    protected void createFlashTypeEditor(Composite parent, FlashType flashType) {
        Label label = new Label(parent, 0);
        label.setText(LABEL_FALSH_TYPE);
        this.flashTypeCombo = new Combo(parent, 8);
        GridData layoutData = new GridData(544);
        layoutData.horizontalSpan = 3;
        this.flashTypeCombo.setLayoutData((Object)layoutData);
        this.flashTypeCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DdrCheckComposite.this.handleFlashTypeChanged();
            }
        });
    }

    protected void handleFlashTypeChanged() {
        int index = this.flashTypeCombo.getSelectionIndex();
        if (index == -1) {
            index = 0;
        }
        IBootBurner burner = this.getBurner();
        FlashType flashType = burner.getBurnContext().getDeviceSetting().getFlashSetting().findFlashType(burner, "ddr");
        burner.setFlashType(flashType);
    }

    protected void updateFlashType(Composite parent, FlashType flashType) {
        int i = 0;
        while (i < this.flashTypeCombo.getItemCount()) {
            String flashName = this.flashTypeCombo.getItem(i);
            if (flashName.equalsIgnoreCase("spi nand/nand")) {
                flashName = FlashType.nand.name();
            } else if (flashName.equalsIgnoreCase("spi nor")) {
                flashName = FlashType.spi.name();
            }
            if (flashType.name().equalsIgnoreCase(flashName)) {
                this.flashTypeCombo.select(i);
            }
            ++i;
        }
        this.handleFlashTypeChanged();
    }

    @Override
    protected Layout createLayout() {
        return new GridLayout(4, false);
    }

    @Override
    protected void disableUI() {
        IUIAdapter adapter = this.getUIAdapter();
        adapter.disableReloadButton();
        adapter.disableSerialSelection();
        if (this.isDisposed()) {
            return;
        }
        if (this.burnButton != null && !this.burnButton.isDisposed()) {
            this.burnButton.setEnabled(false);
        }
        if (this.browseButton != null && !this.browseButton.isDisposed()) {
            this.browseButton.setEnabled(false);
        }
    }

    @Override
    protected void enableButtons() {
        if (this.burnButton != null && !this.burnButton.isDisposed()) {
            this.burnButton.setEnabled(true);
        }
    }

    @Override
    protected void enableUI() {
        IUIAdapter adapter = this.getUIAdapter();
        adapter.enableReloadButton();
        adapter.enableSerialSelection();
        if (this.isDisposed()) {
            return;
        }
        this.enableButtons();
        if (this.browseButton != null && !this.browseButton.isDisposed()) {
            this.browseButton.setEnabled(true);
        }
    }

    protected void fillButtons(Composite buttonComp, List<Button> buttons) {
        this.burnButton = this.createButton(buttonComp, BurnComposite.LABEL_DDRCHECK);
        IBootBurner burner = this.getBurner();
        FlashType flashType = burner.getBurnContext().getDeviceSetting().getFlashSetting().findFlashType(burner, "ddr");
        burner.setFlashType(flashType);
        this.burnButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DdrCheckComposite.this.burnButton.setEnabled(false);
                DdrCheckComposite.this.burn();
            }
        });
        buttons.add(this.burnButton);
    }

    protected void handleBrwoseFileCA() {
        String filePath;
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        String text = this.programmerFileText.getText();
        if (!text.equals("")) {
            dialog.setFileName(text);
        }
        if ((filePath = dialog.open()) != null) {
            this.programmerFileText.setText(filePath);
            File bootFile = new File(filePath);
            if (bootFile.exists()) {
                ((AbstractBurner)((Object)this.getBurner())).setProgrammerFile(filePath);
            }
        }
    }

    protected void createProgrammerFileText(Composite parent) {
        Label programmerFileLabel = new Label(parent, 0);
        programmerFileLabel.setText(Messages.FastbootComposite_LABEL_PROGRAMER_FILE);
        this.programmerFileText = new Text(parent, 2048);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.programmerFileText.setEnabled(false);
        this.programmerFileText.setLayoutData((Object)layoutData);
        this.programmerFileBrowseButton = new Button(parent, 0);
        this.programmerFileBrowseButton.setLayoutData((Object)new GridData());
        this.programmerFileBrowseButton.setText(LABEL_BROWSE);
        this.programmerFileBrowseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DdrCheckComposite.this.handleBrwoseFileCA();
            }
        });
    }

    private static void addHyperlinkListenerToView(final ImageHyperlink imageHyperlink, final String info) {
        imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                if (info == null) {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.FASTBOOT_WARNING_Title, (String)Messages.LightView_Read_File_ERROR);
                    return;
                }
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)imageHyperlink.getText(), (String)info);
            }
        });
    }
}

