/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.ui.burners;

import com.vendor.burn.Activator;
import com.vendor.burn.Messages;
import com.vendor.burn.model.FileSystem;
import com.vendor.burn.model.FlashType;
import com.vendor.burn.model.PartitionInfo;
import com.vendor.burn.model.PartitionItem;
import com.vendor.burn.model.PlatformType;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.define.IFastbootProgressMonitor;
import com.vendor.burn.model.devices.IDeviceSetting;
import com.vendor.burn.model.devices.IEmmcBurner;
import com.vendor.burn.model.devices.IFileSystemSetting;
import com.vendor.burn.model.devices.IFlashSetting;
import com.vendor.burn.model.devices.IMergeBurner;
import com.vendor.burn.model.devices.IPartitionBurner;
import com.vendor.burn.model.devices.ISaveable;
import com.vendor.burn.model.devices.burners.AbstractBurner;
import com.vendor.burn.model.devices.burners.CommonBurner;
import com.vendor.burn.model.devices.burners.EmmcBurner;
import com.vendor.burn.model.devices.burners.MergeBurner;
import com.vendor.burn.model.devices.burners.PartitionBurner;
import com.vendor.burn.model.devices.unknown.UDProperties;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import com.vendor.burn.model.event.EventType;
import com.vendor.burn.model.event.FastbootEvent;
import com.vendor.burn.model.event.IFastbootEventListener;
import com.vendor.burn.model.exceptions.InvalidElementException;
import com.vendor.burn.model.exceptions.InvalidFileSystemException;
import com.vendor.burn.packagers.nand.FlashOption;
import com.vendor.burn.packagers.nand.NandImageDialog;
import com.vendor.burn.packagers.nand.ip.NandIPCommon;
import com.vendor.burn.serial.workers.WorkerUtility;
import com.vendor.burn.ui.BurnComposite;
import com.vendor.burn.ui.burners.EmmcComposite;
import com.vendor.burn.ui.dialog.SelectNandImageDialog;
import com.vendor.burn.ui.dialog.SelectProDialog;
import com.vendor.burn.utilitily.FileUtils;
import com.vendor.burn.utilitily.ToolUtils;
import com.vendor.burn.utilitily.ZipUtils;
import com.vendor.platform.api.statistics.ToolStatistics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.vendor.preferences.BurnState;

public class PartitionComposite
extends BurnComposite
implements ISaveable,
IFastbootEventListener {
    protected static final String DATA_EDITOR = "EDITOR";
    protected static final String DATA_EDITOR_JUM = "EDITOR_JUM";
    protected static final String DATA_DISPOSELISTNER_JUM = "DISPOSELISTNER_JUM";
    protected static final String DATA_DISPOSELISTNER = "DISPOSELISTNER";
    protected static final String FASTBOOT = "fastboot";
    private static String saveNandImgPath;
    private static final String SELECT_File = "SelectFile";
    protected static final int COL_SEL = 0;
    protected static final int COL_NAME = 1;
    protected static final int COL_SELECT_FILE = 2;
    protected static final int COL_FLASH_TYPE = 3;
    protected static final int COL_FILE_SYSTEM = 4;
    protected static final int COL_START = 5;
    protected static final int COL_LENGTH = 6;
    protected static final int COL_JUMP = 7;
    protected static final int COL_ADD = 8;
    private static final String[] COLUMNS;
    boolean isDirty = false;
    int labelWidth = 0;
    private File partitionFile;
    protected CheckboxTableViewer itemViewer;
    protected boolean vBarVisibility = false;
    protected Button burnButton;
    protected Text tableFileText;
    private ComboBoxCellEditor fileSystemEditor;
    private ComboBoxCellEditor flashTypeEditor;
    private Button eraseButton;
    private Button eraseAllButton;
    private Button browseButton;
    private Button makeNandImageButton;
    protected Button saveButton;
    protected Button createUsbPackageButton;
    protected Button useXMLPathAsParentButton;
    protected Text programmerFileText;
    protected Button programmerFileBrowseButton;
    private TabItem tabItem;
    private CheckboxTableViewer viewer;

    static {
        COLUMNS = new String[]{Messages.PartitionComposite_TABLE_COLOMN_SEL, Messages.PartitionComposite_TABLE_COLOMN_NAME, Messages.PartitionComposite_TABLE_COLOMN_FILE, Messages.PartitionComposite_TABLE_COLOMN_FLASHTYPE, Messages.PartitionComposite_TABLE_COLOMN_FILESYSTEM, Messages.PartitionComposite_TABLE_COLOMN_START, Messages.PartitionComposite_TABLE_COLOMN_LENGTH, Messages.PartitionComposite_TABLE_COLOMN_JUMP, Messages.PartitionComposite_TABLE_COLOMN_ADD};
    }

    public PartitionComposite(Composite parent, int style, IBurner burner) {
        super(parent, style, burner);
        Activator.getDefault().add(this);
        if (!(this instanceof EmmcComposite)) {
            IFastbootProgressMonitor iFastbootProgressMonitor = this.getProgressMonitor();
            if (Platform.getProduct() == null) {
                return;
            }
            Platform.getProduct().getDefiningBundle().getVersion().toString();
            Activator.getDefault().getBundle().getVersion().toString();
            UDProperties properties = ((UnknownDevice)burner.getBurnContext().getDeviceSetting()).getProperties();
            String boardType = properties.queryForString("TYPE");
            if (boardType != null) {
                boardType.equalsIgnoreCase("CAM");
            }
            iFastbootProgressMonitor.infoln("\n");
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected boolean isSamePartitionItems(List<PartitionItem> l0, List<PartitionItem> l2) {
        if (l0.size() != l2.size()) {
            return false;
        }
        int i = 0;
        while (i < l2.size()) {
            if (!l0.get(i).partitionItemEquals(l2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected void createContents(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Composite com = new Composite(parent, 0);
        com.setLayout((Layout)new GridLayout(6, false));
        GridData gridData = new GridData(1808);
        com.setLayoutData((Object)gridData);
        this.useXMLPathAsParentButton = new Button(com, 32);
        GridData layoutData = new GridData(1, 1, false, false);
        this.useXMLPathAsParentButton.setLayoutData((Object)layoutData);
        this.useXMLPathAsParentButton.setText(Messages.PartitionComposite_LABEL_Default_Use_XML_Path);
        this.useXMLPathAsParentButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String text = PartitionComposite.this.tableFileText.getText().trim();
                File file = new File(text);
                if (file.exists()) {
                    PartitionComposite.this.loadPartitionFile(file, PartitionComposite.this.useXMLPathAsParentButton.getSelection());
                }
            }
        });
        this.useXMLPathAsParentButton.setSelection(true);
        Label label = new Label(com, 0);
        layoutData = new GridData(1, 1, false, false);
        layoutData.horizontalIndent = 20;
        label.setLayoutData((Object)layoutData);
        label.setText(Messages.PartitionComposite_LABEL_PARTITION_FILE);
        this.tableFileText = new Text(com, 2048);
        GridData tableFileTextGD = new GridData(4, 1, true, false);
        tableFileTextGD.horizontalIndent = 5;
        tableFileTextGD.horizontalSpan = 2;
        this.tableFileText.setLayoutData((Object)tableFileTextGD);
        this.tableFileText.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                PartitionComposite.this.handleEnterOnTableFileText();
            }
        });
        this.browseButton = new Button(com, 0);
        layoutData = new GridData(1, 1, false, false);
        ToolUtils.setWidthForOS(layoutData, 60, 70);
        this.browseButton.setLayoutData((Object)layoutData);
        this.browseButton.setText(LABEL_BROWSE);
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PartitionComposite.this.handleBrowseFile();
            }
        });
        this.saveButton = new Button(com, 0);
        this.saveButton.setLayoutData((Object)layoutData);
        this.saveButton.setText(LABEL_SAVE);
        this.saveButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PartitionComposite.this.savePartitionTable();
            }
        });
        if (this.getBurner().getBurnContext().getPlatformType() == PlatformType.CA || ((UnknownDevice)this.getBurner().getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) {
            Button alignButton = new Button(com, 32);
            layoutData = new GridData(1, 1, false, false);
            alignButton.setLayoutData((Object)layoutData);
            alignButton.setText(Messages.PartitionComposite_LABEL_Default_Use_XML_Path);
            alignButton.setVisible(false);
            Label programmerFileLabel = new Label(com, 0);
            programmerFileLabel.setText(Messages.PartitionComposite_LABEL_PROGRAMER_FILE);
            GridData programmerLblGD = new GridData(1, 1, false, false);
            programmerLblGD.horizontalIndent = 15;
            programmerFileLabel.setLayoutData((Object)programmerLblGD);
            this.programmerFileText = new Text(com, 2048);
            GridData programmerTextGD = new GridData(4, 1, true, false);
            programmerTextGD.horizontalIndent = 5;
            programmerTextGD.horizontalSpan = 2;
            this.programmerFileText.setLayoutData((Object)programmerTextGD);
            this.programmerFileText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String fileStr = PartitionComposite.this.programmerFileText.getText().trim();
                    ((AbstractBurner)((Object)PartitionComposite.this.getBurner())).setProgrammerFile(fileStr);
                    PartitionComposite.this.getBurner().getPratitionInfo().setProgrammerFile(new File(fileStr));
                }
            });
            this.programmerFileBrowseButton = new Button(com, 0);
            layoutData = new GridData(1, 1, false, false);
            layoutData.horizontalSpan = 2;
            ToolUtils.setWidthForOS(layoutData, 125, 145);
            this.programmerFileBrowseButton.setLayoutData((Object)layoutData);
            this.programmerFileBrowseButton.setText(LABEL_BROWSE);
            this.programmerFileBrowseButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    PartitionComposite.this.handleBrwoseProgrammerFile();
                }
            });
        }
        this.createButtons(com);
        Control tableControl = this.createItemTable(com);
        this.itemViewer = (CheckboxTableViewer)tableControl.getData();
        this.itemViewer.setInput((Object)this.getBurner());
        GridData layoutData2 = new GridData(4, 4, true, true, 6, 1);
        tableControl.setLayoutData((Object)layoutData2);
        this.initData();
    }

    protected void createButtons(Composite parent) {
        Composite buttonComp = new Composite(parent, 0);
        buttonComp.setLayout((Layout)new GridLayout(5, true));
        GridData gd = new GridData();
        gd.horizontalSpan = 6;
        buttonComp.setLayoutData((Object)gd);
        this.burnButton = new Button(buttonComp, 0);
        this.burnButton.setText(LABEL_BURN);
        GridData layoutData = new GridData(576);
        layoutData.widthHint = 120;
        this.burnButton.setLayoutData((Object)layoutData);
        this.burnButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PartitionComposite.this.burnButton.setEnabled(false);
                PartitionComposite.this.burn();
            }
        });
        this.eraseButton = new Button(buttonComp, 0);
        this.eraseButton.setText(LABEL_ERASE);
        layoutData = new GridData(576);
        layoutData.widthHint = 120;
        this.eraseButton.setLayoutData((Object)layoutData);
        this.eraseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (!PartitionComposite.this.isErase()) {
                    return;
                }
                PartitionComposite.this.eraseButton.setEnabled(false);
                PartitionComposite.this.erase();
            }
        });
        this.eraseAllButton = new Button(buttonComp, 0);
        this.eraseAllButton.setText(Messages.EmmcComposite_EmmcEraseAll);
        layoutData = new GridData(576);
        layoutData.widthHint = 120;
        this.eraseAllButton.setLayoutData((Object)layoutData);
        this.eraseAllButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (!PartitionComposite.this.isErase()) {
                    return;
                }
                PartitionComposite.this.eraseButton.setEnabled(false);
                PartitionComposite.this.eraseAll();
            }
        });
        this.makeNandImageButton = new Button(buttonComp, 0);
        this.makeNandImageButton.setText(LABEL_MAKE_NAND_IMAGE);
        layoutData = new GridData(576);
        ToolUtils.setWidthForOS(layoutData, 150, 160);
        this.makeNandImageButton.setLayoutData((Object)layoutData);
        this.makeNandImageButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                List<PartitionItem> partitions = PartitionComposite.this.getBurner().getPratitionInfo().getChildren();
                boolean flag = false;
                for (PartitionItem item : partitions) {
                    if (!item.isChecked() || item.getFile() == null) continue;
                    flag = true;
                }
                if (flag) {
                    IPartitionBurner burner = PartitionComposite.this.getBurner();
                    if (PartitionComposite.this.checkStatus(burner.checkCreateImage())) {
                        PartitionComposite.this.handleCreateNandImage();
                    } else {
                        PartitionComposite.this.enableButtons();
                    }
                } else {
                    MessageDialog.openInformation((Shell)PartitionComposite.this.getShell(), (String)Messages.FastbootPreferencePage_Info_Message, (String)Messages.PartitionComposite_msg_please_check_one_Partition);
                }
            }
        });
        this.createUsbPackageButton = new Button(buttonComp, 0);
        this.createUsbPackageButton.setText(LABEL_CREATE_USB_PACKAGE);
        layoutData = new GridData(576);
        ToolUtils.setWidthForOS(layoutData, 120, 160);
        this.createUsbPackageButton.setLayoutData((Object)layoutData);
        this.createUsbPackageButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (!PartitionComposite.this.checkStatus(((PartitionBurner)PartitionComposite.this.getBurner()).checkBeforeMakePro())) {
                    return;
                }
                List<PartitionItem> children = PartitionComposite.this.getBurner().getPratitionInfo().getChildren();
                int size = children.size();
                int i = 0;
                while (i < size) {
                    PartitionItem partition = children.get(i);
                    if (i == size - 1 && partition.isChecked() && !((PartitionBurner)PartitionComposite.this.getBurner()).checkLastPartition(children)) {
                        return;
                    }
                    ++i;
                }
                SelectProDialog selectProDialog = new SelectProDialog(Display.getCurrent().getActiveShell(), 67680, PartitionComposite.this.burner, children);
                selectProDialog.open();
                if (selectProDialog.getStatus() == 0) {
                    String selectProWay = selectProDialog.getSelectProWay();
                    if (selectProWay.equals("serial")) {
                        ToolStatistics.INSTANCE.logUsage("BurnTool", "Create Pro-serial Image By Partition", "ChipName: " + PartitionComposite.this.burner.getBurnContext().getDeviceSetting().getName());
                        ToolStatistics.INSTANCE.logToolInUse("BurnTool");
                        PartitionComposite.this.handleCreateUsbPackage();
                    } else if (selectProWay.equals("usb")) {
                        ToolStatistics.INSTANCE.logUsage("BurnTool", "Create Pro-usb Image By Partition", "ChipName: " + PartitionComposite.this.burner.getBurnContext().getDeviceSetting().getName());
                        ToolStatistics.INSTANCE.logToolInUse("BurnTool");
                        try {
                            FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 8192);
                            dialog.setOverwrite(true);
                            dialog.setFileName("pro_usb.zip");
                            String filePath = dialog.open();
                            if (filePath != null) {
                                PartitionComposite.this.disableUI();
                                IFastbootProgressMonitor monitor = PartitionComposite.this.getProgressMonitor();
                                monitor.getEvent().setBurner(PartitionComposite.this.getBurner());
                                filePath = dialog.getFilterPath();
                                String fileName = dialog.getFileName();
                                PartitionComposite.this.handleCreateProUsb(monitor, filePath, fileName);
                            }
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                    }
                } else {
                    return;
                }
            }
        });
        buttonComp.setLayoutData((Object)new GridData(4, 1, true, false, 4, 1));
    }

    protected void handleCreateProUsb(final IFastbootProgressMonitor fastbootMonitor, final String filePath, final String fileName) throws FileNotFoundException {
        fastbootMonitor.getEvent().init(EventType.CREATE_USB_PACKAGE);
        Job job = new Job("Create USB package"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Create USB package", 10);
                monitor.subTask("Create TempDirectory");
                String ProTemp = "ProTemp";
                File tempDirectory = new File(String.valueOf(filePath) + "/" + ProTemp);
                if (!tempDirectory.exists()) {
                    boolean bl = tempDirectory.mkdir();
                } else {
                    ZipUtils.deleteAllFiles(tempDirectory);
                }
                String tempDirectoryPath = tempDirectory.getAbsolutePath();
                monitor.subTask("Create Pro partition table XML");
                if (!PartitionComposite.this.createPartitionXmlForProUsb(tempDirectoryPath)) {
                    if (tempDirectory.exists()) {
                        ZipUtils.deleteAllFiles(tempDirectory);
                    }
                    fastbootMonitor.getEvent().setSuccess(false);
                    monitor.done();
                    fastbootMonitor.finish();
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(1);
                monitor.subTask("Copy partition file to tempDirectory");
                List<PartitionItem> parts = ((PartitionBurner)PartitionComposite.this.getBurner()).getChildren();
                int size = parts.size();
                int i = 0;
                while (i < size) {
                    PartitionItem partition = parts.get(i);
                    if (monitor.isCanceled()) {
                        if (tempDirectory.exists()) {
                            ZipUtils.deleteAllFiles(tempDirectory);
                        }
                        fastbootMonitor.getEvent().setSuccess(false);
                        fastbootMonitor.getEvent().setMessage(Messages.BurnComposite_Usb_Pack_Canceled);
                        monitor.done();
                        fastbootMonitor.finish();
                        return Status.CANCEL_STATUS;
                    }
                    if (partition.isChecked()) {
                        File newFile;
                        if (partition.getFile() == null) {
                            if (tempDirectory.exists()) {
                                ZipUtils.deleteAllFiles(tempDirectory);
                            }
                            fastbootMonitor.getEvent().setSuccess(false);
                            fastbootMonitor.getEvent().setMessage(NLS.bind((String)Messages.AbstractBurner_msg_file_does_not_exist_in_row_, (Object)(i + 1)));
                            monitor.done();
                            fastbootMonitor.finish();
                            return Status.CANCEL_STATUS;
                        }
                        File file = partition.getFile();
                        String filePath2 = file.getAbsolutePath();
                        String fileNewPath = String.valueOf(tempDirectory.getAbsolutePath()) + "/" + file.getName();
                        File oldFile = new File(filePath2 = filePath2.replace("\\", "/"));
                        boolean copy = FileUtils.copy(monitor, oldFile, newFile = new File(fileNewPath = fileNewPath.replace("\\", "/")));
                        if (!copy) {
                            fastbootMonitor.getEvent().setSuccess(false);
                            fastbootMonitor.getEvent().setMessage(NLS.bind((String)Messages.ERROR_INFO_DISK_SPACE_LOW, (Object)newFile));
                            monitor.done();
                            fastbootMonitor.finish();
                            return Status.CANCEL_STATUS;
                        }
                    }
                    ++i;
                }
                monitor.worked(3);
                monitor.subTask("Is compressed image");
                if (filePath != null) {
                    File outFile = new File(String.valueOf(filePath) + "/" + fileName);
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(outFile);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        fastbootMonitor.getEvent().setSuccess(false);
                        monitor.done();
                        fastbootMonitor.finish();
                        return Status.CANCEL_STATUS;
                    }
                    ZipUtils.zipFolderToStream(tempDirectoryPath, out);
                    ZipUtils.deleteAllFiles(tempDirectory);
                    if (monitor.isCanceled()) {
                        if (outFile.exists()) {
                            FileUtils.deleteFile(outFile);
                        }
                        fastbootMonitor.getEvent().setSuccess(false);
                        fastbootMonitor.getEvent().setMessage(Messages.BurnComposite_Usb_Pack_Canceled);
                        monitor.done();
                        fastbootMonitor.finish();
                        return Status.CANCEL_STATUS;
                    }
                }
                fastbootMonitor.getEvent().setSuccess(true);
                monitor.done();
                fastbootMonitor.finish();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private boolean createPartitionXmlForProUsb(String tempDirectoryPath) {
        String partitionFilePath;
        block9: {
            block8: {
                boolean isCreate;
                partitionFilePath = String.valueOf(tempDirectoryPath) + "\\" + "partition.xml";
                this.partitionFile = new File(partitionFilePath);
                if (this.partitionFile.exists()) {
                    FileUtils.deleteFile(this.partitionFile);
                }
                if (isCreate = FileUtils.isCreateNewFile(this.partitionFile)) break block8;
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)NLS.bind((String)Messages.AddressBurnerWorker_PartFile_Create_Failed, (Object)this.partitionFile.getPath()));
                return false;
            }
            if (this.partitionFile != null && this.partitionFile.exists()) break block9;
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)Messages.UanbleParseXml);
            return false;
        }
        try {
            PartitionComposite.getPartitionXml(this.partitionFile, this.getBurner().getPratitionInfo().getChildren());
            SAXReader reader = new SAXReader();
            Document document = null;
            document = reader.read(this.partitionFile);
            Element root = document.getRootElement();
            Iterator parent = root.elementIterator("Part");
            while (parent.hasNext()) {
                Element part = (Element)parent.next();
                Attribute attribute = part.attribute(SELECT_File);
                String strSelectFile = part.attributeValue(SELECT_File);
                int lastIndexOf = strSelectFile.lastIndexOf("\\");
                if (lastIndexOf == -1) {
                    lastIndexOf = strSelectFile.lastIndexOf("/");
                }
                String newSelctFile = strSelectFile.substring(lastIndexOf + 1);
                attribute.setValue(newSelctFile);
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = null;
            writer = new XMLWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(partitionFilePath), "GB2312"), format);
            format.setEncoding("GB2312");
            writer.write(document);
            writer.close();
        }
        catch (DocumentException documentException) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)Messages.UanbleParseXml);
                }
            });
            return false;
        }
        catch (IOException e) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)e.getMessage());
                }
            });
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void getPartitionXml(File tableFile, List<PartitionItem> children) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(tableFile);
            ((OutputStream)out).write("<?xml version=\"1.0\" encoding=\"GB2312\" ?>\n".getBytes("GB2312"));
            ((OutputStream)out).write("<Partition_Info>\n".getBytes("GB2312"));
            for (PartitionItem item : children) {
                ((OutputStream)out).write(item.toString().getBytes("GB2312"));
            }
            ((OutputStream)out).write("</Partition_Info>\n".getBytes("GB2312"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (out == null) return;
            try {
                ((OutputStream)out).close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (IOException iOException) {
            try {
                if (out == null) return;
            }
            catch (Throwable throwable) {
                if (out == null) throw throwable;
                try {
                    ((OutputStream)out).close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                ((OutputStream)out).close();
                return;
            }
            catch (IOException iOException3) {}
            return;
        }
        if (out == null) return;
        try {
            ((OutputStream)out).close();
            return;
        }
        catch (IOException iOException) {}
    }

    protected String getCreateImageButtonCaption() {
        return Messages.PartitionComposite_ButtonCaption_CreateImage;
    }

    protected void createImage() {
        IPartitionBurner burner = this.getBurner();
        if (this.checkStatus(burner.checkCreateImage())) {
            IFastbootProgressMonitor monitor = this.getProgressMonitor();
            monitor.getEvent().setBurner(this.getBurner());
            burner.createImage(monitor);
        } else {
            this.enableButtons();
        }
    }

    protected void initData() {
        IPartitionBurner burner = this.getBurner();
        IDeviceSetting deviceSetting = burner.getBurnContext().getDeviceSetting();
        IFlashSetting flashSetting = deviceSetting.getFlashSetting();
        String[] flashNames = flashSetting.getFlashNames(burner);
        this.flashTypeEditor.setItems(flashNames);
        String[] fileSystemNames = deviceSetting.getFileSystemSetting().getFileSystemNames(burner);
        this.fileSystemEditor.setItems(fileSystemNames);
    }

    protected void handleEnterOnTableFileText() {
        if (this.tableFileText == null || this.tableFileText.isDisposed()) {
            return;
        }
        String text = this.tableFileText.getText().trim();
        File file = new File(text);
        if (!file.exists()) {
            this.handleBrowseFile();
        } else {
            this.loadPartitionFile(file, this.useXMLPathAsParentButton.getSelection());
        }
    }

    protected void handlePaintTableItem(Event event) {
        event.detail &= 0xFFFFFFDF;
        if ((event.detail & 2) == 0) {
            return;
        }
        Table table = (Table)event.widget;
        int clientWidth = table.getClientArea().width;
        GC gc = event.gc;
        Color oldForeground = gc.getForeground();
        Color oldBackground = gc.getBackground();
        Color forecolor = new Color(null, new RGB(255, 0, 0));
        gc.setForeground(forecolor);
        gc.drawRectangle(0, event.y, clientWidth, event.height - 2);
        forecolor.dispose();
        gc.setForeground(oldForeground);
        gc.setBackground(oldBackground);
        event.detail &= 0xFFFFFFFD;
    }

    protected void handleBrowseFile() {
        String filePath;
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.xml"});
        String text = this.tableFileText.getText();
        if (!text.equals("")) {
            dialog.setFileName(text);
        }
        if ((filePath = dialog.open()) != null) {
            this.tableFileText.setText(filePath);
            File tableFile = new File(filePath);
            if (tableFile.exists()) {
                this.loadPartitionFile(tableFile, this.useXMLPathAsParentButton.getSelection());
            }
        }
        this.promptToSave(false);
    }

    protected void loadPartitionFile(File tableFile, boolean xmlPathDefault) {
        try {
            PartitionItem part;
            int i;
            PartitionInfo info = PartitionItem.load(tableFile, xmlPathDefault);
            List<PartitionItem> load = info.getChildren();
            if (load.isEmpty()) {
                throw new DocumentException();
            }
            PartitionItem partitionItem = load.get(0);
            String chipName = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getName();
            if (!(chipName != null && chipName.equalsIgnoreCase("CJXX4") || this.burner instanceof IMergeBurner || FASTBOOT.equals(partitionItem.getName()))) {
                throw new DocumentException();
            }
            IPartitionBurner burner = this.getBurner();
            IDeviceSetting deviceSetting = burner.getBurnContext().getDeviceSetting();
            IFlashSetting flashSetting = deviceSetting.getFlashSetting();
            IFileSystemSetting fileSystemSetting = deviceSetting.getFileSystemSetting();
            List<FileSystem> fileSystems = Arrays.asList(fileSystemSetting.getFileSystems(burner));
            List<FlashType> flashes = Arrays.asList(flashSetting.getFlashTypes(burner));
            if (burner instanceof IEmmcBurner) {
                i = 0;
                while (i < load.size()) {
                    part = load.get(i);
                    if (part.getLength() == -1L && i != load.size() - 1 && i != load.size() - 1) {
                        throw new InvalidElementException(NLS.bind((String)Messages.PartitionComposite_PartitionInvalidLength_For_PARTITION, (Object[])new String[]{part.getName()}));
                    }
                    if (!flashes.contains((Object)part.getFlashType())) {
                        throw new InvalidElementException(NLS.bind((String)Messages.PartitionComposite_FlashTypeUnsupported, (Object[])new String[]{part.getName()}));
                    }
                    if (!fileSystems.contains(part.getFileSystem())) {
                        throw new InvalidFileSystemException(NLS.bind((String)Messages.PartitionComposite_FileSystemUnsupported, (Object[])new String[]{part.getName()}));
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < load.size()) {
                    part = load.get(i);
                    if (part.getLength() < 0L && i != load.size() - 1) {
                        throw new InvalidElementException(NLS.bind((String)Messages.PartitionComposite_PartitionInvalidLength_For_PARTITION, (Object[])new String[]{part.getName()}));
                    }
                    if (!flashes.contains((Object)part.getFlashType())) {
                        throw new InvalidElementException(NLS.bind((String)Messages.PartitionComposite_FlashTypeUnsupported, (Object[])new String[]{part.getName()}));
                    }
                    if (!fileSystems.contains(part.getFileSystem())) {
                        throw new InvalidFileSystemException(NLS.bind((String)Messages.PartitionComposite_FileSystemUnsupported, (Object[])new String[]{part.getName()}));
                    }
                    ++i;
                }
            }
            PartitionInfo partitionInfo = this.getBurner().getPratitionInfo();
            File programmerFile = info.getProgrammerFile();
            if (this.programmerFileText != null) {
                if (programmerFile != null) {
                    this.programmerFileText.setText(programmerFile.getPath());
                    this.getBurner().getPratitionInfo().setProgrammerFile(programmerFile);
                } else {
                    this.programmerFileText.setText("");
                    this.getBurner().getPratitionInfo().setProgrammerFile(null);
                }
            }
            List<PartitionItem> children = partitionInfo.getChildren();
            boolean overwrite = true;
            if (children.size() > 1 && !this.isSamePartitionItems(load, children)) {
                overwrite = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.FASTBOOT_CONFIRM_Title, (String)Messages.PartitionComposite_msg_Make_sure_to_overwrite_partitions);
            }
            if (overwrite) {
                children.clear();
                children.addAll(load);
                this.getBurner().setTableFile(tableFile);
                this.itemViewer.refresh();
                this.updateSelection();
            }
        }
        catch (DocumentException documentException) {
            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.FASTBOOT_WARNING_Title, (String)Messages.PartitionComposite_msg_invalid_partition_file_please_check_the_file);
        }
        catch (InvalidFileSystemException e) {
            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.FASTBOOT_WARNING_Title, (String)e.getMessage());
        }
        catch (InvalidElementException e) {
            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.FASTBOOT_WARNING_Title, (String)e.getMessage());
        }
        this.isDirty = false;
    }

    protected void updateSelection() {
        TableItem[] items;
        TableItem[] tableItemArray = items = this.itemViewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            PartitionItem data = (PartitionItem)tableItem.getData();
            tableItem.setChecked(data.isChecked());
            ++n2;
        }
    }

    protected Control createItemTable(Composite parent) {
        boolean needJumpFunction;
        final Composite control = new Composite(parent, 2048);
        TableColumnLayout tcl = new TableColumnLayout();
        control.setLayout((Layout)tcl);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)control, (int)66064);
        this.viewer.setContentProvider(this.createContentProvider());
        this.viewer.setLabelProvider(this.createLabelProvider());
        final Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                PartitionComposite.this.handlePaintTableItem(event);
            }
        });
        TableColumn column = new TableColumn(table, 0x1000000, 0);
        column.setImage(Activator.getImage("icons/check.bmp"));
        column.setResizable(false);
        column.setMoveable(true);
        column.setAlignment(0x1000000);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(35, false));
        column.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                List<PartitionItem> children = PartitionComposite.this.getBurner().getPratitionInfo().getChildren();
                for (PartitionItem partitionItem : children) {
                    partitionItem.setChecked(!PartitionComposite.this.isAllChecked());
                }
                PartitionComposite.this.updateSelection();
            }
        });
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PartitionItem item = (PartitionItem)event.getElement();
                item.setChecked(event.getChecked());
                PartitionComposite.this.isDirty = true;
                PartitionComposite.this.promptToSave(false);
            }
        });
        column = new TableColumn(table, 0x1000000, 1);
        column.setResizable(true);
        column.setMoveable(true);
        column.setText(COLUMNS[1]);
        column.setAlignment(0x1000000);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(2, 35, false));
        column = new TableColumn(table, 16384, 2);
        column.setResizable(true);
        column.setMoveable(true);
        column.setText(COLUMNS[2]);
        column.setAlignment(131072);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(8, 35, false));
        column = new TableColumn(table, 0x1000000, 3);
        column.setResizable(true);
        column.setMoveable(true);
        column.setText(COLUMNS[3]);
        column.setAlignment(0x1000000);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 35, false));
        column = new TableColumn(table, 0x1000000, 4);
        column.setResizable(true);
        column.setMoveable(true);
        column.setText(COLUMNS[4]);
        column.setAlignment(0x1000000);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 35, false));
        column = new TableColumn(table, 0x1000000, 5);
        column.setResizable(true);
        column.setMoveable(true);
        column.setText(COLUMNS[5]);
        column.setAlignment(0x1000000);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 35, false));
        column = new TableColumn(table, 0x1000000, 6);
        column.setResizable(true);
        column.setMoveable(true);
        column.setText(COLUMNS[6]);
        column.setAlignment(0x1000000);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 35, false));
        TableColumn jumpCol = null;
        final String chipName = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getName();
        boolean bl = needJumpFunction = (this.burner instanceof PartitionBurner || this.burner instanceof CommonBurner) && !(this.burner instanceof EmmcBurner) && !(this.burner instanceof MergeBurner);
        if (needJumpFunction) {
            jumpCol = new TableColumn(table, 0x1000000, 7);
            jumpCol.setAlignment(0x1000000);
            jumpCol.setMoveable(true);
            jumpCol.setResizable(false);
            jumpCol.setText(COLUMNS[7]);
            tcl.setColumnData((Widget)jumpCol, (ColumnLayoutData)new ColumnPixelData(50, false));
            TableViewerColumn JumpColumn = new TableViewerColumn((TableViewer)this.viewer, jumpCol);
            JumpColumn.setLabelProvider(new CellLabelProvider(){

                public void update(ViewerCell cell) {
                }
            });
            this.setTableItemHeight(table, 25);
            final TableEditor jumpEditor = new TableEditor(table);
            jumpEditor.horizontalAlignment = 16384;
            jumpEditor.grabHorizontal = true;
            jumpEditor.minimumWidth = 50;
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    TableItem[] selection;
                    Control oldEditor = jumpEditor.getEditor();
                    if (oldEditor != null) {
                        oldEditor.dispose();
                    }
                    if ((selection = PartitionComposite.this.viewer.getTable().getSelection()).length == 0) {
                        return;
                    }
                    TableItem item = selection[0];
                    if (item == null) {
                        return;
                    }
                    Button jumpBtn = new Button((Composite)table, 0);
                    jumpBtn.setImage(Activator.getImage("icons/bootargs_export.png"));
                    jumpBtn.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            PartitionInfo data = new PartitionInfo();
                            IStructuredSelection selection = (IStructuredSelection)(this).PartitionComposite.this.itemViewer.getSelection();
                            if (selection.isEmpty()) {
                                return;
                            }
                            PartitionItem item = (PartitionItem)selection.getFirstElement();
                            if ((this).PartitionComposite.this.programmerFileText != null && (this).PartitionComposite.this.programmerFileText.getText() != null && !(this).PartitionComposite.this.programmerFileText.getText().isEmpty()) {
                                data.setProgrammerFile(new File((this).PartitionComposite.this.programmerFileText.getText().trim()));
                            }
                            data.getChildren().add(item);
                            TabItem[] items = PartitionComposite.this.tabItem.getParent().getItems();
                            items[0].setData((Object)data);
                            items[0].getParent().setSelection(items[1]);
                            Event event2 = new Event();
                            event2.data = data;
                            PartitionComposite.this.tabItem.getParent().notifyListeners(13, event2);
                            (this).PartitionComposite.this.itemViewer.refresh(true);
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                    jumpEditor.setEditor((Control)jumpBtn, item, 7);
                }
            });
        }
        TableColumn addCol = null;
        addCol = jumpCol == null ? new TableColumn(table, 0x1000000, 7) : new TableColumn(table, 0x1000000, 8);
        addCol.setAlignment(0x1000000);
        addCol.setMoveable(true);
        addCol.setResizable(false);
        addCol.setImage(Activator.getImage("icons/add.jpg"));
        tcl.setColumnData((Widget)addCol, (ColumnLayoutData)new ColumnPixelData(50, false));
        addCol.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PartitionComposite.this.handleAddNewPartition();
                PartitionComposite.this.promptToSave(false);
                control.layout();
            }
        });
        TableViewerColumn addColumn = new TableViewerColumn((TableViewer)this.viewer, addCol);
        addColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
            }
        });
        this.setTableItemHeight(table, 25);
        final TableEditor addEditor = new TableEditor(table);
        addEditor.horizontalAlignment = 16384;
        addEditor.grabHorizontal = true;
        addEditor.minimumWidth = 50;
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableItem[] selection;
                Control oldEditor = addEditor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((selection = PartitionComposite.this.viewer.getTable().getSelection()).length == 0) {
                    return;
                }
                final TableItem item = selection[0];
                if (item == null) {
                    return;
                }
                PartitionItem data = (PartitionItem)item.getData();
                if (!(PartitionComposite.this.burner instanceof IMergeBurner) && PartitionComposite.FASTBOOT.equalsIgnoreCase(data.getName())) {
                    return;
                }
                Button newEditor = new Button((Composite)table, 0);
                newEditor.setImage(Activator.getImage("icons/delrow.ico"));
                newEditor.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        PartitionItem data = (PartitionItem)item.getData();
                        if (PartitionComposite.FASTBOOT.equalsIgnoreCase(data.getName()) && !(PartitionComposite.this.burner instanceof IMergeBurner)) {
                            return;
                        }
                        IStructuredSelection selection = (IStructuredSelection)(this).PartitionComposite.this.itemViewer.getSelection();
                        if (selection.isEmpty()) {
                            return;
                        }
                        data = (PartitionItem)selection.getFirstElement();
                        if (PartitionComposite.FASTBOOT.equalsIgnoreCase(data.getName()) && !(PartitionComposite.this.burner instanceof IMergeBurner)) {
                            return;
                        }
                        PartitionComposite.this.getBurner().remove(data);
                        (this).PartitionComposite.this.itemViewer.refresh(true);
                        (this).PartitionComposite.this.isDirty = true;
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                if (chipName == null || !chipName.equalsIgnoreCase("CJXX4")) {
                    if (!(PartitionComposite.this.burner instanceof EmmcBurner) && !(PartitionComposite.this.burner instanceof MergeBurner)) {
                        addEditor.setEditor((Control)newEditor, item, 8);
                    } else {
                        addEditor.setEditor((Control)newEditor, item, 7);
                    }
                }
            }
        });
        table.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ScrollBar verticalBar = table.getVerticalBar();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            (this).PartitionComposite.this.labelWidth = table.getColumn(2).getWidth() - 10;
                            PartitionComposite.this.viewer.refresh();
                        }
                        catch (Exception exception) {}
                    }
                });
                if (verticalBar != null) {
                    PartitionComposite.this.setvBarVisibility(PartitionComposite.this.vBarVisibility);
                }
                control.layout();
            }
        });
        ScrollBar verticalBar = table.getVerticalBar();
        if (verticalBar != null) {
            this.setvBarVisibility(this.vBarVisibility);
        }
        this.viewer.setColumnProperties(COLUMNS);
        this.viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                PartitionItem value = null;
                if (element instanceof PartitionItem) {
                    value = (PartitionItem)element;
                } else if (element instanceof TableItem) {
                    value = (PartitionItem)((TableItem)element).getData();
                }
                String chipName = ((UnknownDevice)PartitionComposite.this.burner.getBurnContext().getDeviceSetting()).getName();
                return PartitionComposite.this.isCanModify(property, value, chipName);
            }

            public Object getValue(Object element, String property) {
                PartitionItem value = null;
                if (element instanceof PartitionItem) {
                    value = (PartitionItem)element;
                } else if (element instanceof TableItem) {
                    value = (PartitionItem)((TableItem)element).getData();
                }
                if (value != null) {
                    if (property.equals(COLUMNS[1])) {
                        String name = value.getName();
                        return name == null ? "" : name;
                    }
                    if (property.equals(COLUMNS[2])) {
                        File file = value.getFile();
                        return file != null ? file.getAbsolutePath() : "";
                    }
                    if (property.equals(COLUMNS[3])) {
                        FlashType flashType = value.getFlashType();
                        String[] items = PartitionComposite.this.flashTypeEditor.getItems();
                        int i = 0;
                        while (i < items.length) {
                            String name = items[i];
                            if (name.equals("spi nand/nand")) {
                                name = FlashType.nand.name();
                            } else if (name.equals("spi nor")) {
                                name = FlashType.spi.name();
                            }
                            if (name.equals(flashType.name())) {
                                return i;
                            }
                            ++i;
                        }
                        return 0;
                    }
                    if (property.equals(COLUMNS[4])) {
                        String[] items = PartitionComposite.this.fileSystemEditor.getItems();
                        int i = 0;
                        while (i < items.length) {
                            if (items[i].equals(value.getFileSystem().name())) {
                                return i;
                            }
                            ++i;
                        }
                        return 0;
                    }
                    if (property.equals(COLUMNS[5])) {
                        return WorkerUtility.ReceiveHelper.convertUnit(value.getStart());
                    }
                    if (property.equals(COLUMNS[6])) {
                        long length = value.getLength();
                        if (length == -1L) {
                            return "-";
                        }
                        return WorkerUtility.ReceiveHelper.convertUnit(length);
                    }
                }
                return value;
            }

            public void modify(Object element, String property, Object value) {
                PartitionItem item = null;
                if (element instanceof PartitionItem) {
                    item = (PartitionItem)element;
                } else if (element instanceof TableItem) {
                    item = (PartitionItem)((TableItem)element).getData();
                }
                if (item != null) {
                    if (property.equals(COLUMNS[1])) {
                        if (item.getName() == null || !item.getName().equals((String)value)) {
                            item.setName((String)value);
                            PartitionComposite.this.isDirty = true;
                        }
                    } else if (property.equals(COLUMNS[2])) {
                        String valueStr = (String)value;
                        if (valueStr == null || valueStr.isEmpty()) {
                            if (item.getFile() != null) {
                                PartitionComposite.this.isDirty = true;
                                item.setFile(null);
                            }
                        } else if (item.getFile() == null || !item.getFile().getAbsolutePath().equalsIgnoreCase(valueStr)) {
                            File file = new File(valueStr);
                            item.setFile(file);
                            this.updateFileSystem(item, file);
                            PartitionComposite.this.isDirty = true;
                        } else {
                            File file = item.getFile();
                            this.updateFileSystem(item, file);
                        }
                    } else if (property.equals(COLUMNS[3])) {
                        String string;
                        Integer index = (Integer)value;
                        if (index == -1) {
                            index = 0;
                        }
                        if ((string = PartitionComposite.this.flashTypeEditor.getItems()[index]).equals("spi nand/nand")) {
                            string = FlashType.nand.name();
                        } else if (string.equals("spi nor")) {
                            string = FlashType.spi.name();
                        }
                        FlashType oldValue = item.getFlashType();
                        if (oldValue != FlashType.valueOf(string)) {
                            item.setFlashType(FlashType.valueOf(string));
                            PartitionComposite.this.updateFlashTypeAddress(item, oldValue);
                            PartitionComposite.this.isDirty = true;
                        }
                    } else if (property.equals(COLUMNS[4])) {
                        FileSystem valueOf;
                        Integer index = (Integer)value;
                        if (index == -1) {
                            index = 0;
                        }
                        String string = PartitionComposite.this.fileSystemEditor.getItems()[index];
                        FileSystem oldValue = item.getFileSystem();
                        if (oldValue != (valueOf = FileSystem.valueOf(string))) {
                            item.setFileSystem(valueOf);
                            PartitionComposite.this.isDirty = true;
                        }
                    } else if (property.equals(COLUMNS[5])) {
                        long convertToNumber;
                        String valueStr = (String)value;
                        if (valueStr.equals("")) {
                            convertToNumber = 0L;
                        } else {
                            convertToNumber = WorkerUtility.ReceiveHelper.convertToNumber(valueStr);
                            if (convertToNumber % 512L != 0L) {
                                MessageDialog.openWarning((Shell)PartitionComposite.this.getShell(), (String)Messages.FASTBOOT_WARNING_Title, (String)Messages.PartitionComposite_InvalidUnit);
                                PartitionComposite.this.updateAddresses(item);
                                return;
                            }
                        }
                        if (convertToNumber != item.getStart()) {
                            item.setStart(convertToNumber);
                            PartitionComposite.this.updateAddresses(item);
                            PartitionComposite.this.isDirty = true;
                        }
                    } else if (property.equals(COLUMNS[6])) {
                        String valueStr = (String)value;
                        if (valueStr.equals("")) {
                            long convertToNumber = 0L;
                        } else {
                            List<PartitionItem> children = PartitionComposite.this.getBurner().getPratitionInfo().getChildren();
                            if (valueStr.equals("-") && (PartitionComposite.this.getBurner() instanceof EmmcBurner || PartitionComposite.this.getBurner() instanceof PartitionBurner) && children.size() > 0 && children.get(children.size() - 1) == item) {
                                PartitionComposite.this.isDirty = false;
                                if (item.getLength() != -1L) {
                                    item.setLength(-1L);
                                    PartitionComposite.this.itemViewer.refresh((Object)item);
                                    PartitionComposite.this.updateAddresses(item);
                                }
                            } else {
                                long convertToNumber = WorkerUtility.ReceiveHelper.convertToNumber(valueStr);
                                if (convertToNumber % 512L != 0L) {
                                    MessageDialog.openWarning((Shell)PartitionComposite.this.getShell(), (String)Messages.FASTBOOT_WARNING_Title, (String)Messages.PartitionComposite_msg_partition_length_should_be_with_unit_KorM_or_1024_times);
                                } else if (item.getLength() != convertToNumber) {
                                    item.setLength(convertToNumber);
                                    PartitionComposite.this.isDirty = true;
                                    PartitionComposite.this.updateAddresses(item);
                                }
                            }
                        }
                    }
                }
                PartitionComposite.this.viewer.refresh();
                PartitionComposite.this.promptToSave(false);
            }

            private void updateFileSystem(PartitionItem item, File file) {
                String systemItem;
                int systemIndex;
                String[] systemItems;
                String fileName = file.getName();
                if (fileName.toLowerCase().endsWith(".ext3") || fileName.toLowerCase().endsWith(".ext4")) {
                    systemItems = PartitionComposite.this.fileSystemEditor.getItems();
                    systemIndex = 0;
                    while (systemIndex < systemItems.length) {
                        systemItem = systemItems[systemIndex];
                        if (systemItem.equalsIgnoreCase("ext3/4")) {
                            item.setFileSystem(FileSystem.ext3);
                            PartitionComposite.this.isDirty = true;
                            break;
                        }
                        ++systemIndex;
                    }
                }
                if (fileName.toLowerCase().endsWith(".yaffs") || fileName.toLowerCase().endsWith(".yaffs2")) {
                    systemItems = PartitionComposite.this.fileSystemEditor.getItems();
                    systemIndex = 0;
                    while (systemIndex < systemItems.length) {
                        systemItem = systemItems[systemIndex];
                        if (systemItem.equalsIgnoreCase("yaffs")) {
                            item.setFileSystem(FileSystem.yaffs);
                            PartitionComposite.this.isDirty = true;
                            break;
                        }
                        ++systemIndex;
                    }
                }
                if (fileName.toLowerCase().endsWith(".ubi")) {
                    systemItems = PartitionComposite.this.fileSystemEditor.getItems();
                    systemIndex = 0;
                    while (systemIndex < systemItems.length) {
                        systemItem = systemItems[systemIndex];
                        if (systemItem.equalsIgnoreCase("ubifs")) {
                            item.setFileSystem(FileSystem.ubiFs);
                            PartitionComposite.this.isDirty = true;
                            break;
                        }
                        ++systemIndex;
                    }
                }
                if (fileName.toLowerCase().endsWith(".squashfs")) {
                    systemItems = PartitionComposite.this.fileSystemEditor.getItems();
                    systemIndex = 0;
                    while (systemIndex < systemItems.length) {
                        systemItem = systemItems[systemIndex];
                        if (systemItem.equalsIgnoreCase("squashfs")) {
                            item.setFileSystem(FileSystem.squashFs);
                            PartitionComposite.this.isDirty = true;
                            break;
                        }
                        ++systemIndex;
                    }
                }
            }
        });
        TextCellEditor nameEditor = new TextCellEditor((Composite)table);
        this.flashTypeEditor = new ComboBoxCellEditor((Composite)table, FlashType.getItems(this.getBurner()), 8);
        this.fileSystemEditor = new ComboBoxCellEditor((Composite)table, FileSystem.getItems(this.getBurner()), 8);
        TextCellEditor startEditor = new TextCellEditor((Composite)table);
        TextCellEditor lengthEditor = new TextCellEditor((Composite)table);
        DialogCellEditor fileEditor = new DialogCellEditor((Composite)table){

            protected Button createButton(Composite parent) {
                Button result = new Button(parent, 1024);
                result.setImage(Activator.getImage("icons/selfile.ico"));
                result.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent e) {
                        if (e.keyCode == 8 || e.keyCode == 127 || e.keyCode == 16777262) {
                            this.setValue(null);
                            this.fireApplyEditorValue();
                        }
                    }
                });
                return result;
            }

            protected Object openDialogBox(Control cellEditorWindow) {
                FileDialog dialog = new FileDialog(cellEditorWindow.getShell());
                Object value = this.getValue();
                if (value != null) {
                    dialog.setFileName(value.toString());
                }
                String open = dialog.open();
                return open;
            }

            protected Control createContents(Composite cell) {
                Control createContents = super.createContents(cell);
                this.getDefaultLabel().setAlignment(131072);
                return createContents;
            }

            protected void doSetValue(Object value) {
                super.doSetValue(value);
            }

            protected void updateContents(Object value) {
                if (value != null) {
                    String text = value.toString();
                    this.getDefaultLabel().setToolTipText(text);
                    this.getDefaultLabel().setText(text);
                }
            }
        };
        CellEditor[] cellEditorArray = new CellEditor[8];
        cellEditorArray[1] = nameEditor;
        cellEditorArray[2] = fileEditor;
        cellEditorArray[3] = this.flashTypeEditor;
        cellEditorArray[4] = this.fileSystemEditor;
        cellEditorArray[5] = startEditor;
        cellEditorArray[6] = lengthEditor;
        this.viewer.setCellEditors(cellEditorArray);
        control.setData((Object)this.viewer);
        return control;
    }

    protected FastbootEvent getEvent() {
        return null;
    }

    protected long getChipSize() {
        return 0L;
    }

    protected void handleAddNewPartition() {
        StructuredSelection selection = (StructuredSelection)this.itemViewer.getSelection();
        int index = 0;
        FlashType flashType = null;
        List<PartitionItem> children = this.getBurner().getPratitionInfo().getChildren();
        if (!selection.isEmpty()) {
            PartitionItem firstElement = (PartitionItem)selection.getFirstElement();
            flashType = firstElement.getFlashType();
            index = children.indexOf(firstElement);
        } else if (children.size() > 0) {
            PartitionItem partitionItem = children.get(children.size() - 1);
            flashType = partitionItem.getFlashType();
        }
        IDeviceSetting deviceSetting = this.getBurner().getBurnContext().getDeviceSetting();
        IFlashSetting flashSetting = deviceSetting.getFlashSetting();
        if (flashType == null) {
            flashType = flashSetting.getFlashTypes(this.getBurner())[0];
        }
        PartitionItem newItem = new PartitionItem();
        IFileSystemSetting fileSystemSetting = deviceSetting.getFileSystemSetting();
        FileSystem[] fileSystems = fileSystemSetting.getFileSystems(this.getBurner());
        newItem.setFileSystem(fileSystems[0]);
        newItem.setFlashType(flashType);
        if (children.size() == 0) {
            newItem.setStart(0L);
            children.add(0, newItem);
        } else {
            PartitionItem lastPartition = children.get(index);
            newItem.setStart(lastPartition.getStart() + (lastPartition.getLength() < 0L ? 0L : lastPartition.getLength()));
            children.add(++index, newItem);
        }
        this.updateAddressesForAddNew(newItem, index);
        this.isDirty = true;
        this.promptToSave(false);
        this.itemViewer.refresh();
        this.itemViewer.setSelection((ISelection)new StructuredSelection((Object)newItem), true);
    }

    protected IBaseLabelProvider createLabelProvider() {
        return new ViewerLabelProvider();
    }

    protected IContentProvider createContentProvider() {
        return new ViewerContentProvider();
    }

    @Override
    protected Layout createLayout() {
        return new GridLayout(4, false);
    }

    protected boolean isAllChecked() {
        Object[] checkedElements = this.itemViewer.getCheckedElements();
        return checkedElements.length == this.getBurner().getPratitionInfo().getChildren().size();
    }

    protected void savePartitionTable() {
        File out = this.getPartitionFilePath(this.getBurner().getPartitionFile());
        if (out == null) {
            return;
        }
        int open = 1;
        while (out != null && out.exists() && open == 1) {
            MessageDialog dialog = new MessageDialog(this.getShell(), Messages.FASTBOOT_MessageDialog_Title, null, NLS.bind((String)Messages.PartitionComposite_msg_file_exists_already_whether_to_overwrite_it, (Object)out.getAbsolutePath()), 6, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            open = dialog.open();
            if (open != 1) continue;
            out = this.getPartitionFilePath(this.getBurner().getPartitionFile());
        }
        if (out == null || open == 2) {
            return;
        }
        if (!out.exists()) {
            try {
                out.createNewFile();
            }
            catch (IOException iOException) {}
        }
        PartitionItem.save(out, this.getBurner().getPratitionInfo());
        this.tableFileText.setText(out.getAbsolutePath());
        this.getBurner().setPartitionFile(out);
        this.isDirty = false;
    }

    protected File getPartitionFilePath(File partitionFile) {
        String open;
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.xml"});
        dialog.setFilterNames(new String[]{Messages.BurnComposite_Save_Filter_XML});
        if (partitionFile != null) {
            dialog.setFilterPath(partitionFile.getAbsolutePath());
            dialog.setFileName(partitionFile.getName());
        }
        if ((open = dialog.open()) == null) {
            return null;
        }
        return new File(open);
    }

    protected void setTableItemHeight(Table table, int height) {
        int itemHeight = table.getItemHeight();
        if (itemHeight == height) {
            return;
        }
        try {
            Method setHeightMethod = Table.class.getDeclaredMethod("setItemHeight", Integer.TYPE);
            setHeightMethod.setAccessible(true);
            setHeightMethod.invoke((Object)table, height);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    protected long getLastAddress(PartitionItem part) {
        List<PartitionItem> children = this.getBurner().getPratitionInfo().getChildren();
        if (!children.contains(part)) {
            return 0L;
        }
        long address = 0L;
        for (PartitionItem item : children) {
            if (item == part) {
                return address;
            }
            if (part.getFlashType() != item.getFlashType()) continue;
            address = item.getStart();
            if (item.getLength() <= 0L) continue;
            address += item.getLength();
        }
        return 0L;
    }

    protected void updateFlashTypeAddress(PartitionItem part, FlashType oldType) {
        part.setStart(this.getLastAddress(part));
        this.updateAddresses(part);
        long address = 0L;
        for (PartitionItem item : this.getBurner().getPratitionInfo().getChildren()) {
            if (item.getFlashType() != oldType) continue;
            if (address == 0L) {
                address = item.getStart();
            } else {
                item.setStart(address);
            }
            address += item.getLength();
        }
        this.itemViewer.refresh();
    }

    protected void updateAddresses(PartitionItem part) {
        long address = 0L;
        for (PartitionItem item : this.getBurner().getPratitionInfo().getChildren()) {
            if (address > 0L && item.getFlashType() == part.getFlashType()) {
                item.setStart(address);
                if (item.getLength() > 0L) {
                    address += item.getLength();
                }
            }
            if (item != part) continue;
            address = part.getStart() + (part.getLength() < 0L ? 0L : part.getLength());
        }
        this.itemViewer.refresh();
    }

    protected void updateAddressesForAddNew(PartitionItem part, int index) {
        List<PartitionItem> children = this.getBurner().getPratitionInfo().getChildren();
        PartitionItem item = children.get(index);
        long address = item.getStart();
        if (item.getLength() > 0L) {
            address += item.getLength();
        }
        int i = index + 1;
        while (i < children.size()) {
            item = children.get(i);
            if (item.getFlashType() == part.getFlashType()) {
                item.setStart(address);
                if (item.getLength() > 0L) {
                    address += item.getLength();
                }
            }
            ++i;
        }
        this.itemViewer.refresh();
    }

    @Override
    public void finished(FastbootEvent event) {
        super.finished(event);
        if (this.itemViewer != null) {
            this.itemViewer.setSelection((ISelection)new StructuredSelection());
        }
    }

    @Override
    protected void disableUI() {
        if (this.burnButton != null && !this.burnButton.isDisposed()) {
            this.burnButton.setEnabled(false);
        }
        if (this.eraseButton != null && !this.eraseButton.isDisposed()) {
            this.eraseButton.setEnabled(false);
        }
        if (this.eraseAllButton != null && !this.eraseAllButton.isDisposed()) {
            this.eraseAllButton.setEnabled(false);
        }
        if (this.browseButton != null && !this.browseButton.isDisposed()) {
            this.browseButton.setEnabled(false);
        }
        if (this.saveButton != null && !this.saveButton.isDisposed()) {
            this.saveButton.setEnabled(false);
        }
        if (this.programmerFileBrowseButton != null && !this.programmerFileBrowseButton.isDisposed()) {
            this.programmerFileBrowseButton.setEnabled(false);
        }
        if (this.createUsbPackageButton != null && !this.createUsbPackageButton.isDisposed()) {
            this.createUsbPackageButton.setEnabled(false);
        }
        if (this.makeNandImageButton != null && !this.makeNandImageButton.isDisposed()) {
            this.makeNandImageButton.setEnabled(false);
        }
    }

    @Override
    protected void enableButtons() {
        if (this.burnButton != null && !this.burnButton.isDisposed()) {
            this.burnButton.setEnabled(true);
        }
        if (this.eraseButton != null && !this.eraseButton.isDisposed()) {
            this.eraseButton.setEnabled(true);
        }
        if (this.eraseAllButton != null && !this.eraseAllButton.isDisposed()) {
            this.eraseAllButton.setEnabled(true);
        }
        if (this.browseButton != null && !this.browseButton.isDisposed()) {
            this.browseButton.setEnabled(true);
        }
        if (this.saveButton != null && !this.saveButton.isDisposed()) {
            this.saveButton.setEnabled(true);
        }
        if (this.programmerFileBrowseButton != null && !this.programmerFileBrowseButton.isDisposed()) {
            this.programmerFileBrowseButton.setEnabled(true);
        }
        if (this.createUsbPackageButton != null && !this.createUsbPackageButton.isDisposed()) {
            this.createUsbPackageButton.setEnabled(true);
        }
        if (this.makeNandImageButton != null && !this.makeNandImageButton.isDisposed()) {
            this.makeNandImageButton.setEnabled(true);
        }
    }

    @Override
    protected void enableUI() {
        this.enableButtons();
    }

    @Override
    public void hightLight(List<PartitionItem> parts) {
        if (parts.isEmpty()) {
            return;
        }
        if (!this.isDisposed() && this.itemViewer != null) {
            this.itemViewer.setSelection((ISelection)new StructuredSelection(parts), true);
            this.itemViewer.getControl().getParent().setFocus();
        }
    }

    @Override
    public int promptToSave(boolean canCancel) {
        int open = 0;
        if (this.isDisposed()) {
            return open;
        }
        if (this.isDirty()) {
            BurnState state = BurnState.INSTANCE;
            IPartitionBurner burner = this.getBurner();
            String fileContent = PartitionItem.getFileContent(this.getBurner().getPratitionInfo().getChildren());
            File partitionFile = burner.getPartitionFile();
            if (burner instanceof IEmmcBurner) {
                state.setEmmcParitionPath(partitionFile);
                state.setEmmcPartitionContent(fileContent);
            } else {
                state.setPartitionPath(partitionFile);
                state.setPartitionContent(fileContent);
            }
        }
        return open;
    }

    @Override
    public IPartitionBurner getBurner() {
        return (IPartitionBurner)super.getBurner();
    }

    protected void handleBrwoseProgrammerFile() {
        String filePath;
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        String text = this.programmerFileText.getText();
        if (!text.equals("")) {
            dialog.setFileName(text);
        }
        if ((filePath = dialog.open()) != null) {
            this.programmerFileText.setText(filePath);
            File bootFile = new File(filePath);
            if (bootFile.exists()) {
                ((AbstractBurner)((Object)this.getBurner())).setProgrammerFile(filePath);
            } else {
                ((AbstractBurner)((Object)this.getBurner())).setProgrammerFile(null);
            }
        }
    }

    protected void handleCreateUsbPackage() {
        List<PartitionItem> children = this.getBurner().getPratitionInfo().getChildren();
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setOverwrite(true);
        dialog.setFileName("usb_update.bin");
        String filePath = dialog.open();
        if (filePath != null) {
            this.disableUI();
            IFastbootProgressMonitor monitor = this.getProgressMonitor();
            monitor.getEvent().setBurner(this.getBurner());
            ((PartitionBurner)this.getBurner()).createProImage(monitor, filePath, children);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleCreateNandImage() {
        String path;
        ToolStatistics.INSTANCE.logUsage("BurnTool", "Create Nand Image By Partition", "ChipName: " + this.burner.getBurnContext().getDeviceSetting().getName());
        ToolStatistics.INSTANCE.logToolInUse("BurnTool");
        IDeviceSetting deviceSetting = this.getBurner().getBurnContext().getDeviceSetting();
        if (deviceSetting == null) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"BurnTool", (String)Messages.PartitionComposite_MakeNandImage_DoNotSupport);
            return;
        }
        UnknownDevice device = (UnknownDevice)deviceSetting;
        if (device.getNandIPVer() != 500 && device.getNandIPVer() != 600 && device.getNandIPVer() != 610 && device.getNandIPVer() != 611 && device.getNandIPVer() != 620 && device.getSpinandIPVer() != 500 && device.getSpinandIPVer() != 600 && device.getSpinandIPVer() != 610 && device.getSpinandIPVer() != 611 && device.getSpinandIPVer() != 620) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"BurnTool", (String)Messages.NandImage_DoNotSupport);
            return;
        }
        NandIPCommon nandSet = null;
        if (device.getNandIPVer() != -1 && device.getSpinandIPVer() != -1) {
            SelectNandImageDialog selectNandImageDialog = new SelectNandImageDialog(Display.getCurrent().getActiveShell());
            int open = selectNandImageDialog.open();
            if (open != 0) return;
            String selectedNandWay = selectNandImageDialog.getSelectNandImageWay();
            if (selectedNandWay.equals("Nand")) {
                nandSet = NandIPCommon.chooseNandVersion(device);
            } else if (selectedNandWay.equals("SPINand")) {
                nandSet = NandIPCommon.chooseSPINandVersion(device);
            }
            if (nandSet != null) {
                nandSet.setCurSelectedNandWay(selectedNandWay);
            }
        } else if (device.getNandIPVer() != -1) {
            nandSet = NandIPCommon.chooseNandVersion(device);
            if (nandSet != null) {
                nandSet.setCurSelectedNandWay("Nand");
            }
        } else if (device.getSpinandIPVer() != -1) {
            nandSet = NandIPCommon.chooseSPINandVersion(device);
            if (nandSet != null) {
                nandSet.setCurSelectedNandWay("SPINand");
            }
        } else {
            nandSet = NandIPCommon.chooseNandVersion(device);
            if (nandSet != null) {
                nandSet.setCurSelectedNandWay("Nand");
            }
        }
        if (nandSet == null) {
            return;
        }
        NandImageDialog dialog = new NandImageDialog(Display.getCurrent().getActiveShell(), 67680, nandSet, this.burner);
        dialog.open();
        final FlashOption option = dialog.getSelectedFlashOption();
        final NandIPCommon nandSetting = nandSet;
        final int blockSize = dialog.getBlockSize();
        if (option == null) {
            return;
        }
        final boolean isSelectRandom = dialog.isSelectRandom();
        DirectoryDialog outputSelectDialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
        outputSelectDialog.setText(Messages.NandImageDialog_DstFolder);
        outputSelectDialog.setMessage(Messages.NandImageDialog_DstFolderSelect);
        if (saveNandImgPath != null) {
            outputSelectDialog.setFilterPath(saveNandImgPath);
        }
        if ((path = outputSelectDialog.open()) == null) {
            return;
        }
        saveNandImgPath = path;
        this.disableUI();
        final IFastbootProgressMonitor fastbootMonitor = this.getProgressMonitor();
        Job job = new Job("Create Nand Burner Image..."){

            protected IStatus run(IProgressMonitor monitor) {
                nandSetting.make(path, option, PartitionComposite.this.getBurner().getPratitionInfo().getChildren(), blockSize, isSelectRandom, fastbootMonitor, monitor);
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener(new IJobChangeListener(){

            public void aboutToRun(IJobChangeEvent event) {
            }

            public void awake(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation(null, (String)"BurnTool", (String)Messages.PartitionComposite_MakeNandImage_Finish);
                        PartitionComposite.this.enableUI();
                    }
                });
            }

            public void running(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void sleeping(IJobChangeEvent event) {
            }
        });
        job.setUser(true);
        job.schedule();
    }

    private boolean isCanModify(String property, PartitionItem value, String chipName) {
        if (chipName != null && chipName.equalsIgnoreCase("CJXX4") || this.burner instanceof IMergeBurner) {
            return true;
        }
        return value == null || !COLUMNS[1].equals(property) || !FASTBOOT.equals(value.getName());
    }

    String getRealString(String realFileName, int total) {
        Font font = this.tableFileText.getFont();
        if (font == null) {
            return "";
        }
        Shell shell = null;
        Label label = null;
        GC gc = null;
        try {
            shell = new Shell();
            label = new Label((Composite)shell, 0);
            label.setFont(font);
            gc = new GC((Drawable)label);
            int width = PartitionComposite.getStringWidth(shell, gc, label, realFileName);
            if (total >= width) {
                String string = realFileName;
                return string;
            }
            StringBuilder sb = new StringBuilder(realFileName);
            while (width > total) {
                sb.delete(0, 2);
                width = PartitionComposite.getStringWidth(shell, gc, label, sb.toString());
            }
            sb.delete(0, 3).insert(0, "...");
            String string = sb.toString();
            return string;
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
            if (shell != null) {
                shell.dispose();
            }
        }
    }

    private static int getStringWidth(Shell shell, GC gc, Label label, String string) {
        int width = 0;
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            width += gc.getAdvanceWidth(c);
            ++i;
        }
        return width;
    }

    public void setTabItem(TabItem tabItem) {
        this.tabItem = tabItem;
    }

    public void deleteItem(CheckboxTableViewer itemViewer, TableItem itm) {
        TableItem[] items = itemViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(itm)) {
                items[i].dispose();
                items[i] = null;
                itemViewer.refresh();
            }
            ++i;
        }
    }

    public boolean isvBarVisibility() {
        return this.vBarVisibility;
    }

    public void setvBarVisibility(boolean vBarVisibility) {
        this.vBarVisibility = vBarVisibility;
    }

    private static class ViewerContentProvider
    implements IStructuredContentProvider {
        private ViewerContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof PartitionBurner) {
                return ((PartitionBurner)inputElement).getChildren().toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ViewerLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ViewerLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof PartitionItem) {
                PartitionItem item = (PartitionItem)element;
                switch (columnIndex) {
                    case 1: {
                        return item.getName();
                    }
                    case 2: {
                        File file = item.getFile();
                        if (file == null) {
                            return "";
                        }
                        return PartitionComposite.this.getRealString(file.getAbsolutePath(), PartitionComposite.this.labelWidth);
                    }
                    case 4: {
                        FileSystem fileSystem = item.getFileSystem();
                        return fileSystem == null ? "" : fileSystem.name();
                    }
                    case 3: {
                        FlashType flashType = item.getFlashType();
                        if (flashType == null) {
                            return "";
                        }
                        if (flashType == FlashType.nand) {
                            return "spi nand/nand";
                        }
                        if (flashType == FlashType.spi) {
                            return "spi nor";
                        }
                        return flashType.name();
                    }
                    case 6: {
                        if (item.getLength() == -1L) {
                            return "-";
                        }
                        return WorkerUtility.ReceiveHelper.convertUnit(item.getLength());
                    }
                    case 5: {
                        return WorkerUtility.ReceiveHelper.convertUnit(item.getStart());
                    }
                }
            }
            return "";
        }
    }
}

