/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.ui.dialog;

import com.vendor.burn.Messages;
import com.vendor.burn.model.BoardConfig;
import com.vendor.burn.preferences.FastbootPreferences;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ConfigDialog
extends Dialog {
    static String[] columnNames = new String[]{Messages.FastbootView_MacAddress, Messages.FastbootView_IPAddress, Messages.FastbootView_SubnetMask, Messages.FastbootView_Gateway};
    private static final int DELETED_ID = 1025;
    private TableViewer tableViewer;
    private Table table;
    private List<BoardConfig> boardConfigs;
    private BoardConfig boardConfig = null;

    public ConfigDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText(Messages.BoardConfig_Dialog);
        Composite area = (Composite)super.createDialogArea(parent);
        this.tableViewer = new TableViewer(area, 67584);
        this.table = this.tableViewer.getTable();
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        int i = 0;
        while (i < columnNames.length) {
            TableColumn columnName = new TableColumn(this.table, 0x1000000);
            columnName.setWidth(150);
            columnName.setAlignment(0x1000000);
            columnName.setText(columnNames[i]);
            ++i;
        }
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof BoardConfig) {
                    BoardConfig boardConfig = (BoardConfig)element;
                    if (columnIndex == 0) {
                        return boardConfig.getMac();
                    }
                    if (columnIndex == 1) {
                        return boardConfig.getIp();
                    }
                    if (columnIndex == 2) {
                        return boardConfig.getSubnetMask();
                    }
                    if (columnIndex == 3) {
                        return boardConfig.getGateway();
                    }
                }
                return "";
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    Collection c = (Collection)inputElement;
                    return c.toArray(new Object[c.size()]);
                }
                return new Object[0];
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ConfigDialog.this.handleDoubleClick();
            }
        });
        this.tableViewer.setInput(this.createInput());
        if (this.table.getItemCount() > 0) {
            this.table.select(0);
        }
        return area;
    }

    protected void handleDoubleClick() {
        this.buttonPressed(0);
    }

    private List<BoardConfig> createInput() {
        this.boardConfigs = BoardConfig.load();
        return this.boardConfigs;
    }

    protected void buttonPressed(int buttonId) {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (buttonId == 0 && !selection.isEmpty()) {
            this.setBoardConfig((BoardConfig)selection.getFirstElement());
        }
        if (buttonId == 1025) {
            this.handleDelete();
        }
        super.buttonPressed(buttonId);
    }

    private void handleDelete() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        BoardConfig firstElement = (BoardConfig)selection.getFirstElement();
        this.boardConfigs.remove(firstElement);
        this.tableViewer.refresh();
        if (this.table != null && this.table.getItemCount() > 0) {
            this.table.select(0);
        }
        FastbootPreferences.CONFIG.setClientWholeConfig(BoardConfig.save(this.boardConfigs));
    }

    protected void initializeBounds() {
        super.initializeBounds();
        this.getShell().pack();
        Point size = new Point(650, 400);
        this.getShell().setSize(size);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.ConfigDialog_OK, false);
        this.createButton(parent, 1025, Messages.ConfigDialog_Delete, false);
        this.createButton(parent, 1, Messages.ConfigDialog_Cancel, false);
    }

    public BoardConfig getBoardConfig() {
        return this.boardConfig;
    }

    public void setBoardConfig(BoardConfig boardConfig) {
        this.boardConfig = boardConfig;
    }
}

