/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.ui.dialog;

import com.vendor.burn.Messages;
import com.vendor.burn.model.FlashType;
import com.vendor.burn.model.PartitionItem;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.devices.burners.EmmcBurner;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class SelectProDialog
extends Dialog {
    private int status;
    private String selectProWay;
    private IBurner burner;
    private List<PartitionItem> children;
    protected Shell shell;

    public SelectProDialog(Shell parent, int style, IBurner burner, List<PartitionItem> children) {
        super(parent, style);
        this.burner = burner;
        this.children = children;
        this.status = 1;
        this.selectProWay = "serial";
        this.createContents();
    }

    public Object open() {
        Monitor primary = Display.getCurrent().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return null;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), this.getStyle());
        this.shell.setSize(320, 220);
        this.shell.setText(Messages.SelectProWay);
        GridLayout gl_shell = new GridLayout(2, false);
        gl_shell.verticalSpacing = 20;
        gl_shell.horizontalSpacing = 100;
        gl_shell.marginHeight = 20;
        gl_shell.marginWidth = 20;
        this.shell.setLayout((Layout)gl_shell);
        Label label = new Label((Composite)this.shell, 0);
        label.setText(Messages.PleaseSelectProWay);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        final Button serialBtn = new Button((Composite)this.shell, 16);
        serialBtn.setText("Pro_serial");
        serialBtn.setSelection(true);
        serialBtn.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        serialBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = serialBtn.getSelection();
                if (selection) {
                    SelectProDialog.this.selectProWay = "serial";
                }
            }
        });
        final Button usbBtn = new Button((Composite)this.shell, 16);
        usbBtn.setText("Pro_usb");
        usbBtn.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        usbBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = usbBtn.getSelection();
                if (selection) {
                    SelectProDialog.this.selectProWay = "usb";
                }
            }
        });
        if (this.burner instanceof EmmcBurner && FlashType.isOnlySelectCurFlashType(this.children, FlashType.emmc)) {
            Label tipLabel = new Label((Composite)this.shell, 0);
            tipLabel.setLayoutData((Object)new GridData(4, 3, true, true, 2, 1));
            tipLabel.setText(Messages.PleaseSelectProWay_Notes);
        }
        Composite compositeButtons = new Composite((Composite)this.shell, 0);
        compositeButtons.setLayout((Layout)gl_shell);
        compositeButtons.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Button btnMake = new Button(compositeButtons, 0);
        btnMake.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectProDialog.this.setStatus(0);
                SelectProDialog.this.shell.close();
            }
        });
        GridData gd_btnMake = new GridData(16384, 1024, false, true, 1, 1);
        gd_btnMake.widthHint = 80;
        btnMake.setLayoutData((Object)gd_btnMake);
        btnMake.setText(Messages.FASTBOOT_CONFIRM_Title);
        Button btnCancel = new Button(compositeButtons, 0);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectProDialog.this.setStatus(1);
                SelectProDialog.this.shell.close();
            }
        });
        GridData gd_btnCancel = new GridData(16384, 1024, false, true, 1, 1);
        gd_btnCancel.widthHint = 80;
        btnCancel.setLayoutData((Object)gd_btnCancel);
        btnCancel.setText(Messages.INFO_MESSAGE_CANCEL);
        this.shell.pack();
    }

    public String getSelectProWay() {
        return this.selectProWay;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }
}

