/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.utilitily;

import com.vendor.burn.utilitily.JarUtility;
import com.vendor.burn.utilitily.ToolUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;

public class FileUtils {
    public static final int BUFFER_SIZE = 1024;

    public static boolean isExists(String filePath) {
        if (filePath == null) {
            return false;
        }
        File file = new File(filePath);
        return file.exists();
    }

    public static String toAbsolutePath(String filePath) {
        if (!ToolUtils.isCmdLine()) {
            Location location = Platform.getInstallLocation();
            if (location != null && filePath != null) {
                URL url = location.getURL();
                return String.valueOf(url.getPath()) + "/" + filePath;
            }
        } else {
            String jarDir = JarUtility.getJarDir();
            if (jarDir != null) {
                if (!jarDir.endsWith(File.separator)) {
                    jarDir = jarDir.concat(File.separator);
                }
                return String.valueOf(jarDir) + filePath;
            }
            return filePath;
        }
        return null;
    }

    public static byte[] readAllBytes(String filePath) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        FileInputStream inStream = null;
        byte[] buffer = new byte[1024];
        try {
            try {
                inStream = new FileInputStream(filePath);
                int read = 0;
                while ((read = ((InputStream)inStream).read(buffer)) != -1) {
                    outStream.write(buffer, 0, read);
                }
            }
            catch (IOException iOException) {
                try {
                    if (outStream != null) {
                        outStream.close();
                    }
                }
                catch (IOException iOException2) {}
                try {
                    if (inStream != null) {
                        ((InputStream)inStream).close();
                    }
                }
                catch (IOException iOException3) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (inStream != null) {
                    ((InputStream)inStream).close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (outStream != null) {
                outStream.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (inStream != null) {
                ((InputStream)inStream).close();
            }
        }
        catch (IOException iOException) {}
        return outStream.toByteArray();
    }

    public static boolean copy(IProgressMonitor uiMonitor, File oldfile, File newFile) {
        if (oldfile.getAbsolutePath().equals(newFile.getAbsolutePath())) {
            return true;
        }
        if (!FileUtils.checkFreeSpace(newFile.getParent(), oldfile.length())) {
            return false;
        }
        BufferedInputStream inStream = null;
        FilterOutputStream fs = null;
        try {
            try {
                int byteread = 0;
                if (oldfile.exists()) {
                    inStream = new BufferedInputStream(new FileInputStream(oldfile));
                    fs = new BufferedOutputStream(new FileOutputStream(newFile));
                    byte[] buffer = new byte[4096];
                    while ((byteread = inStream.read(buffer)) != -1) {
                        if (uiMonitor != null && uiMonitor.isCanceled()) break;
                        ((BufferedOutputStream)fs).write(buffer, 0, byteread);
                    }
                    fs.close();
                    inStream.close();
                }
            }
            catch (IOException iOException) {
                try {
                    if (fs != null) {
                        fs.close();
                    }
                }
                catch (IOException iOException2) {}
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (IOException iOException3) {}
                return false;
            }
        }
        catch (Throwable throwable) {
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (fs != null) {
                fs.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (inStream != null) {
                inStream.close();
            }
        }
        catch (IOException iOException) {}
        return true;
    }

    public static StringBuilder readFromFile(String path) {
        StringBuilder strInfo;
        block18: {
            strInfo = new StringBuilder();
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "GBK"));
                String item = "";
                while ((item = br.readLine()) != null) {
                    if (item.length() <= 0) continue;
                    String info = item;
                    strInfo.append(String.valueOf(info) + "\r\n");
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
                return null;
            }
            catch (IOException iOException) {
                block17: {
                    try {
                        if (br == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        throw throwable;
                    }
                    try {
                        br.close();
                    }
                    catch (IOException iOException3) {}
                }
                return null;
            }
            if (br == null) break block18;
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return strInfo;
    }

    public static boolean deleteFile(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        long startTime = System.currentTimeMillis();
        long outTime = 5000L;
        while (!file.delete() && System.currentTimeMillis() - startTime < outTime) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return !file.exists();
    }

    public static boolean checkFreeSpace(String directoryPath, long fileSize) {
        File fileDirectory = new File(directoryPath);
        return fileDirectory.getFreeSpace() >= fileSize;
    }

    public static boolean isCreateNewFile(File newFile) {
        if (newFile.exists()) {
            FileUtils.deleteFile(newFile);
        }
        boolean isCreate = false;
        try {
            isCreate = newFile.createNewFile();
        }
        catch (IOException iOException) {}
        return isCreate;
    }

    public static ArrayList<String> readAllLines(String filePath) {
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader bReader = null;
        InputStreamReader isReader = null;
        FileInputStream inStream = null;
        try {
            try {
                inStream = new FileInputStream(filePath);
                isReader = new InputStreamReader((InputStream)inStream, System.getProperty("file.encoding"));
                bReader = new BufferedReader(isReader);
                String line = null;
                while ((line = bReader.readLine()) != null) {
                    result.add(line);
                }
            }
            catch (IOException iOException) {
                try {
                    if (bReader != null) {
                        bReader.close();
                    }
                }
                catch (IOException iOException2) {
                    return null;
                }
                try {
                    if (isReader != null) {
                        isReader.close();
                    }
                }
                catch (IOException iOException3) {
                    return null;
                }
                try {
                    if (inStream != null) {
                        ((InputStream)inStream).close();
                    }
                }
                catch (IOException iOException4) {
                    return null;
                }
                return null;
            }
        }
        catch (Throwable throwable) {
            try {
                if (bReader != null) {
                    bReader.close();
                }
            }
            catch (IOException iOException) {
                return null;
            }
            try {
                if (isReader != null) {
                    isReader.close();
                }
            }
            catch (IOException iOException) {
                return null;
            }
            try {
                if (inStream != null) {
                    ((InputStream)inStream).close();
                }
            }
            catch (IOException iOException) {
                return null;
            }
            throw throwable;
        }
        try {
            if (bReader != null) {
                bReader.close();
            }
        }
        catch (IOException iOException) {
            return null;
        }
        try {
            if (isReader != null) {
                isReader.close();
            }
        }
        catch (IOException iOException) {
            return null;
        }
        try {
            if (inStream != null) {
                ((InputStream)inStream).close();
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return result;
    }

    public static void checkFilePath(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        }
    }
}

