/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.utilitily;

import com.vendor.burn.Messages;
import com.vendor.burn.model.PCNetworkInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class IPUtils {
    static final String KEY_INTERFACES = "SYSTEM\\CurrentControlSet\\services\\Tcpip\\Parameters\\Interfaces";
    static final String KEY_DHCP = "EnableDHCP";
    static final String KEY_IP = "IPAddress";
    static final String KEY_DHCP_IP = "DhcpIPAddress";
    static final String DOT = ".";
    static String MAC_START = "00";
    static String MAC_SEPARATOR = ":";
    private static List<PCNetworkInfo> pcNetworkInfoList = new ArrayList<PCNetworkInfo>();

    private static List<String> loadFromWin32Registry() {
        ArrayList<String> ipList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            if (networkInterfaces != null) {
                while (networkInterfaces.hasMoreElements()) {
                    NetworkInterface networkInterface = networkInterfaces.nextElement();
                    Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                    while (inetAddresses.hasMoreElements()) {
                        InetAddress inetAddress = inetAddresses.nextElement();
                        if (inetAddress == null || !(inetAddress instanceof Inet4Address)) continue;
                        String ip = inetAddress.getHostAddress();
                        ipList.add(ip);
                    }
                }
            }
        }
        catch (SocketException socketException) {}
        return ipList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> getAllIPs() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> network = NetworkInterface.getNetworkInterfaces();
            if (network == null) {
                return null;
            }
            while (network.hasMoreElements()) {
                NetworkInterface net = network.nextElement();
                Enumeration<InetAddress> a = net.getInetAddresses();
                while (a.hasMoreElements()) {
                    InetAddress addr = a.nextElement();
                    result.add(addr.getHostAddress());
                }
            }
        }
        catch (SocketException socketException) {}
        if (result.size() > 0) {
            return result;
        }
        if ("win32".equals(Platform.getOS()) && "x86".equalsIgnoreCase(Platform.getOSArch())) {
            List<String> loadFrom = IPUtils.loadFromWin32Registry();
            for (String ip : loadFrom) {
                if (result.contains(ip) || !IPUtils.isValidIP(ip)) continue;
                result.add(ip);
            }
        }
        return result;
    }

    public static String[] getServerIps() {
        List<String> allIPs = IPUtils.getAllIPs();
        ArrayList<String> ipv4 = new ArrayList<String>();
        if (allIPs == null) {
            return null;
        }
        for (String ip : allIPs) {
            if (ip.indexOf(":") != -1 || ip.contains("127.0.0")) continue;
            ipv4.add(ip);
        }
        return ipv4.toArray(new String[ipv4.size()]);
    }

    public static boolean isOnTheSameNetIP(String ip1, String ip2, String subnetMask) {
        StringTokenizer tokenizer1 = new StringTokenizer(ip1, DOT);
        int countTokens = tokenizer1.countTokens();
        if (countTokens != 4) {
            return false;
        }
        StringTokenizer tokenizer2 = new StringTokenizer(ip2, DOT);
        countTokens = tokenizer2.countTokens();
        if (countTokens != 4) {
            return false;
        }
        StringTokenizer tokenizerSubnetMask = new StringTokenizer(subnetMask, DOT);
        countTokens = tokenizerSubnetMask.countTokens();
        if (countTokens != 4) {
            return false;
        }
        int index = 0;
        while (index < 4) {
            if (tokenizer1.hasMoreElements() && tokenizer2.hasMoreElements() && tokenizerSubnetMask.hasMoreElements()) {
                long tokenizer1L = Long.parseLong((String)tokenizer1.nextElement());
                long tokenizer2L = Long.parseLong((String)tokenizer2.nextElement());
                long tokenizerGatewayL = Long.parseLong((String)tokenizerSubnetMask.nextElement());
                if ((tokenizer1L & tokenizerGatewayL) != (tokenizer2L & tokenizerGatewayL)) {
                    return false;
                }
            } else {
                return false;
            }
            ++index;
        }
        return true;
    }

    private static char generatorChar(Random random) {
        int ch = -1;
        while (ch == -1) {
            ch = random.nextInt(256);
            if (ch >= 48 && ch <= 57 || ch >= 97 && ch <= 102) break;
            ch = -1;
        }
        return (char)ch;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isValidMac(String mac) {
        if (mac == null || mac.length() == 0) {
            return false;
        }
        sb = new StringTokenizer(mac, ":");
        if (sb.countTokens() == 6) ** GOTO lbl15
        return false;
lbl-1000:
        // 1 sources

        {
            nextToken = sb.nextToken();
            if (nextToken.length() != 2) {
                return false;
            }
            try {
                Integer.parseInt(nextToken, 16);
                continue;
            }
            catch (NumberFormatException v0) {
                return false;
            }
lbl15:
            // 2 sources

            ** while (sb.hasMoreElements())
        }
lbl16:
        // 1 sources

        return true;
    }

    public static String generatorMAC() {
        Random random = new Random();
        StringBuilder sb = new StringBuilder(MAC_START);
        int i = 0;
        while (i < 5) {
            sb.append(MAC_SEPARATOR);
            sb.append(IPUtils.generatorChar(random));
            sb.append(IPUtils.generatorChar(random));
            ++i;
        }
        return sb.toString();
    }

    public static boolean isValidIP(String ip) {
        boolean black = IPUtils.isBlank(ip);
        if (black) {
            return false;
        }
        StringTokenizer tokenizer1 = new StringTokenizer(ip, DOT);
        int countTokens = tokenizer1.countTokens();
        if (countTokens != 4) {
            return false;
        }
        if (ip.charAt(ip.length() - 1) == '.') {
            return false;
        }
        int index = 0;
        while (index < countTokens) {
            if (tokenizer1.hasMoreElements()) {
                Object nextElement = tokenizer1.nextElement();
                if (!(nextElement instanceof String)) {
                    return false;
                }
                try {
                    int parseInt = Integer.parseInt((String)nextElement);
                    if (parseInt < 0 || parseInt > 255) {
                        return false;
                    }
                }
                catch (Exception exception) {
                    return false;
                }
            }
            ++index;
        }
        return true;
    }

    public static boolean isBlank(String ip) {
        if (ip == null || ip.trim().length() == 0) {
            return true;
        }
        return "0.0.0.0".equals(ip);
    }

    public static List<PCNetworkInfo> getPCNetworkInfo() {
        try {
            List<String> ipList = IPUtils.getLocalMachineInfo("IP Address", "IPv4 \u5730\u5740");
            List<String> subnetMaskList = IPUtils.getLocalMachineInfo("Subnet Mask", "\u5b50\u7f51\u63a9\u7801");
            List<String> gatewayList = IPUtils.getLocalMachineInfo("Default Gateway", "\u9ed8\u8ba4\u7f51\u5173");
            int ipSize = ipList.size();
            int subnetMaskSize = subnetMaskList.size();
            int gatewaySize = gatewayList.size();
            if (ipSize == subnetMaskSize) {
                String priorGateWay = "";
                int ipIndex = 0;
                while (ipIndex < ipList.size()) {
                    String ip = ipList.get(ipIndex);
                    String subnetMask = subnetMaskList.get(ipIndex);
                    String gateway = "";
                    if (ipIndex >= gatewaySize) {
                        gateway = priorGateWay;
                    } else {
                        gateway = gatewayList.get(ipIndex);
                        if (gateway.isEmpty()) {
                            gateway = String.valueOf(ip.substring(0, ip.lastIndexOf(DOT))) + ".1";
                        }
                        priorGateWay = gateway;
                    }
                    PCNetworkInfo pcNetworkInfo = new PCNetworkInfo(ip, subnetMask, gateway);
                    pcNetworkInfoList.add(pcNetworkInfo);
                    ++ipIndex;
                }
            }
        }
        catch (Exception exception) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.FASTBOOT_ERROR_Title, (String)Messages.ERROR_INFO_Get_PC_IP_Failed);
                }
            });
            return null;
        }
        return pcNetworkInfoList;
    }

    public static List<String> getLocalMachineInfo(String strEn, String strCh) {
        BufferedReader br;
        InputStreamReader inputRead;
        ArrayList<String> paramList;
        block49: {
            paramList = new ArrayList<String>();
            String line = "";
            InputStream input = null;
            inputRead = null;
            br = null;
            try {
                Process ps = null;
                String osName = System.getProperties().getProperty("os.name");
                ps = osName.toLowerCase().startsWith("windows") ? Runtime.getRuntime().exec("cmd /c ipconfig /all") : (osName.toLowerCase().startsWith("linux") ? Runtime.getRuntime().exec("/bin/sh -c ipconfig /all") : Runtime.getRuntime().exec("cmd /c ipconfig /all"));
                input = ps.getInputStream();
                inputRead = new InputStreamReader(input, System.getProperty("file.encoding"));
                br = new BufferedReader(inputRead);
                while ((line = br.readLine()) != null) {
                    int n;
                    if (line.indexOf(strEn) != -1) {
                        n = line.indexOf(":");
                        if ((line = line.substring(n + 2)).contains("(")) {
                            line = line.substring(0, line.indexOf("("));
                        }
                        if (line.contains(":")) {
                            line = br.readLine();
                            if (line != null) {
                                paramList.add(line.trim());
                            }
                        } else {
                            paramList.add(line);
                        }
                    }
                    if (line == null || line.indexOf(strCh) == -1) continue;
                    n = line.indexOf(":");
                    if ((line = line.substring(n + 2)).contains("(")) {
                        line = line.substring(0, line.indexOf("("));
                    }
                    if (line.contains(":")) {
                        line = br.readLine();
                        if (line == null) continue;
                        paramList.add(line.trim());
                        continue;
                    }
                    paramList.add(line);
                }
                ps.waitFor();
            }
            catch (IOException iOException) {
                ArrayList<String> arrayList = paramList;
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException2) {}
                }
                if (inputRead != null) {
                    try {
                        inputRead.close();
                    }
                    catch (IOException iOException3) {}
                }
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException4) {}
                }
                return arrayList;
            }
            catch (Exception exception) {
                ArrayList<String> arrayList;
                block48: {
                    try {
                        arrayList = paramList;
                        if (input == null) break block48;
                    }
                    catch (Throwable throwable) {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (inputRead != null) {
                            try {
                                inputRead.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                if (inputRead != null) {
                    try {
                        inputRead.close();
                    }
                    catch (IOException iOException) {}
                }
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
                return arrayList;
            }
            if (input == null) break block49;
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        if (inputRead != null) {
            try {
                inputRead.close();
            }
            catch (IOException iOException) {}
        }
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return paramList;
    }

    public static List<PCNetworkInfo> getPcNetworkInfoList() {
        return pcNetworkInfoList;
    }
}

