/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.utilitily;

import com.vendor.burn.utilitily.FileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    public static final String UNIX_SEPERATOR = "/";

    public static void deleteAllFiles(File dirOrFile) {
        if (!dirOrFile.exists()) {
            return;
        }
        if (dirOrFile.isFile()) {
            FileUtils.deleteFile(dirOrFile);
        } else {
            if (dirOrFile.listFiles() != null && dirOrFile.listFiles().length > 0) {
                File[] fileList = dirOrFile.listFiles();
                int i = 0;
                while (i < fileList.length) {
                    ZipUtils.deleteAllFiles(fileList[i]);
                    ++i;
                }
            }
            FileUtils.deleteFile(dirOrFile);
        }
    }

    public static void zipFolderToStream(String tempFolderPath, OutputStream ostream) {
        ZipOutputStream zipOutput = new ZipOutputStream(ostream);
        File rootDir = new File(tempFolderPath);
        File[] files = rootDir.listFiles();
        try {
            ZipUtils.zipFiles(zipOutput, files, tempFolderPath);
            zipOutput.close();
        }
        catch (Exception exception) {}
    }

    private static void zipFiles(ZipOutputStream zipOut, File[] files, String tempFolderPath) throws FileNotFoundException, IOException {
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                ZipUtils.zipFiles(zipOut, file.listFiles(), tempFolderPath);
            } else {
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                    String relativePath = ZipUtils.generateRelativePath(tempFolderPath, file.getPath());
                    ZipEntry entry = new ZipEntry(relativePath);
                    try {
                        int len;
                        entry.setTime(file.lastModified());
                        zipOut.putNextEntry(entry);
                        byte[] buf = new byte[5120];
                        while ((len = in.read(buf)) > 0) {
                            zipOut.write(buf, 0, len);
                        }
                    }
                    finally {
                        zipOut.closeEntry();
                    }
                }
            }
            ++i;
        }
    }

    public static String generateRelativePath(String rootPath, String fullPath) {
        File rootFile = new File(rootPath);
        File currentFile = new File(fullPath);
        String root = rootFile.getAbsolutePath();
        String path = currentFile.getAbsolutePath();
        String relativePath = null;
        relativePath = root != null && path != null && path.startsWith(root) ? path.substring(root.length() + 1) : fullPath;
        relativePath = ZipUtils.convertToUnixString(relativePath);
        return relativePath;
    }

    private static String convertToUnixString(String path) {
        if (path == null) {
            return null;
        }
        return path.replace(File.separator.charAt(0), UNIX_SEPERATOR.charAt(0));
    }
}

