/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.views;

import com.vendor.burn.Messages;
import com.vendor.burn.log.Log;
import com.vendor.burn.model.BoardConfig;
import com.vendor.burn.model.BurnContext;
import com.vendor.burn.model.FileSystem;
import com.vendor.burn.model.FlashType;
import com.vendor.burn.model.LocalConfig;
import com.vendor.burn.model.PartitionInfo;
import com.vendor.burn.model.PartitionItem;
import com.vendor.burn.model.TransferWay;
import com.vendor.burn.model.cmdline.BurnStatus;
import com.vendor.burn.model.cmdline.CmdLineParam;
import com.vendor.burn.model.cmdline.CmdType;
import com.vendor.burn.model.cmdline.adapter.BootBurn;
import com.vendor.burn.model.cmdline.adapter.EmmcImg;
import com.vendor.burn.model.cmdline.adapter.Erase;
import com.vendor.burn.model.cmdline.adapter.NandImg;
import com.vendor.burn.model.config.BurnConfig;
import com.vendor.burn.model.config.PreferenceConfig;
import com.vendor.burn.model.define.IFastbootProgressMonitor;
import com.vendor.burn.model.devices.burners.CommonBurner;
import com.vendor.burn.model.devices.burners.EmmcBurner;
import com.vendor.burn.model.devices.burners.FastbootBurner;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import com.vendor.burn.model.monitor.CmdMonitor;
import com.vendor.burn.packagers.nand.FlashOption;
import com.vendor.burn.packagers.nand.ip.NandIPCommon;
import com.vendor.burn.serial.workers.SerialHelper;
import com.vendor.burn.utilitily.PropertiesUtility;
import com.vendor.burn.utilitily.ToolUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.vendor.tftp.tool.TFTPService;

public class CmdMain {
    private static final String VERSION = "5.4.23";
    private static final int EXTRA_START = 1;
    private static int EXTRA_COUNT = 1;
    private static CmdType curCmdType = null;
    private static String chipName = null;
    private IFastbootProgressMonitor progressMonitor;

    public static void main(String[] args) {
        int result;
        if (args == null || args.length == 0) {
            CmdMain.help();
            System.exit(BurnStatus.PARAM_ERROR.getErrorCode());
        }
        ToolUtils.setCmdLine(true);
        CmdLineParam cmdLineParam = new CmdLineParam();
        CmdMain cmdMain = new CmdMain();
        if (!CmdMain.parseExtraParam(args, cmdLineParam)) {
            CmdMain.help();
            System.exit(BurnStatus.PARAM_ERROR.getErrorCode());
        }
        if ((result = CmdMain.parseFirstParam(args, cmdLineParam, cmdMain)) != 0) {
            CmdMain.help();
            System.exit(result);
        }
        System.exit(0);
    }

    public static CmdType getCurCmdType() {
        return curCmdType;
    }

    public static void setCurCmdType(CmdType curCmdType) {
        CmdMain.curCmdType = curCmdType;
    }

    public static String getChipName() {
        return chipName;
    }

    public static void setChipName(String chipName) {
        CmdMain.chipName = chipName;
    }

    private static boolean parseExtraParam(String[] args, CmdLineParam cmdLineParam) {
        boolean result;
        boolean bl = result = args[0] == null || !args[0].equalsIgnoreCase("--burn") && !args[0].equalsIgnoreCase("-b");
        if (result) {
            return true;
        }
        if (cmdLineParam == null) {
            Log.errorln(Messages.MESSAGE_EXTRA_PARAMETER_EMPTY);
            return false;
        }
        int extraParam = args.length - 1;
        int index = 1;
        if (extraParam >= 1) {
            while (index < extraParam) {
                String argsName = args[index];
                String argsValue = args[index + 1];
                if (argsName == null || argsValue == null) {
                    Log.errorln(Messages.MESSAGE_UNEXPECTED_NULL);
                    return false;
                }
                if (!CmdMain.parseCmdParam(args, cmdLineParam, index, extraParam)) {
                    return false;
                }
                if (!CmdMain.parseCommandParam(args, cmdLineParam, index)) {
                    return false;
                }
                index += EXTRA_COUNT;
            }
        }
        return true;
    }

    private static boolean parseCmdParam(String[] args, CmdLineParam cmdLineParam, int index, int extraParam) {
        String argsName = args[index];
        String argsValue = args[index + 1];
        if (argsName.equalsIgnoreCase("-n")) {
            if (argsValue.isEmpty()) {
                Log.errorln(NLS.bind((String)Messages.ERROR_COMMAND_PARAMETER, (Object)argsValue));
                return false;
            }
            cmdLineParam.setChipName(argsValue);
        }
        if (argsName.equalsIgnoreCase("-m")) {
            if (argsValue.isEmpty()) {
                Log.errorln(NLS.bind((String)Messages.ERROR_COMMAND_PARAMETER, (Object)argsValue));
                return false;
            }
            cmdLineParam.setMode(argsValue);
            if (argsValue.equalsIgnoreCase("serial") || argsValue.equalsIgnoreCase("net") || argsValue.equalsIgnoreCase("NetNonNude")) {
                if (extraParam < index + 2) {
                    Log.errorln(NLS.bind((String)Messages.ERROR_COMMAND_PARAMETER, (Object)"serialPort"));
                    return false;
                }
                String serialPort = args[index + 2];
                if (serialPort == null || serialPort.isEmpty()) {
                    Log.errorln(NLS.bind((String)Messages.ERROR_COMMAND_PARAMETER, (Object)serialPort));
                    return false;
                }
                cmdLineParam.setSerialPort(serialPort);
                if (!CmdMain.parseCmdNetParam(args, cmdLineParam, index, argsValue, extraParam)) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean parseCommandParam(String[] args, CmdLineParam cmdLineParam, int index) {
        block10: {
            String argsName = args[index];
            String argsValue = args[index + 1];
            if (argsName.equalsIgnoreCase("-x")) {
                File file = new File(argsValue);
                if (!file.exists() || !file.isFile()) {
                    Log.errorln(NLS.bind((String)Messages.ERROR_CURRENT_XML_PATH_NOT_FOUND, (Object)argsValue));
                    return false;
                }
                cmdLineParam.setXmlPath(argsValue);
                try {
                    PartitionInfo PartitionInfo2 = PartitionItem.load(file, true);
                    List<PartitionItem> partitionLists = PartitionInfo2.getChildren();
                    if (partitionLists != null && partitionLists.size() > 0) {
                        cmdLineParam.setPartitionList(partitionLists);
                        break block10;
                    }
                    Log.errorln(NLS.bind((String)Messages.ERROR_CURRENT_XML_PATH_NOT_FOUND, (Object)file.getAbsolutePath()));
                    return false;
                }
                catch (DocumentException documentException) {
                    Log.errorln(Messages.UanbleParseXml);
                    return false;
                }
            }
            if (argsName.equalsIgnoreCase("-p")) {
                File file = new File(argsValue);
                if (!file.exists() || !file.isFile()) {
                    Log.errorln(NLS.bind((String)Messages.ERROR_CURRENT_XML_PATH_NOT_FOUND, (Object)argsValue));
                    return false;
                }
                cmdLineParam.setProgrammerPath(argsValue);
            } else if (argsName.equalsIgnoreCase("-c")) {
                File file = new File(argsValue);
                if (!file.exists() || !file.isFile()) {
                    Log.errorln(NLS.bind((String)Messages.ERROR_CURRENT_XML_PATH_NOT_FOUND, (Object)argsValue));
                    return false;
                }
                cmdLineParam.setBurnConfigPath(argsValue);
            }
        }
        return true;
    }

    private static boolean parseCmdNetParam(String[] args, CmdLineParam cmdLineParam, int index, String argsValue, int extraParam) {
        if (argsValue.equalsIgnoreCase("NetNonNude") || argsValue.equalsIgnoreCase("net")) {
            if (extraParam < index + 7) {
                Log.errorln(NLS.bind((String)Messages.ERROR_COMMAND_PARAMETER, (Object)"serverIp orboardIp or netMask or gatewayIp or tftpPort"));
                return false;
            }
            String serverIp = args[index + 3];
            String boardIp = args[index + 4];
            String netMask = args[index + 5];
            String gatewayIp = args[index + 6];
            String tftpPort = args[index + 7];
            if (!CmdMain.checkValid(serverIp)) {
                return false;
            }
            if (!CmdMain.checkValid(boardIp)) {
                return false;
            }
            if (!CmdMain.checkValid(netMask)) {
                return false;
            }
            if (!CmdMain.checkValid(gatewayIp)) {
                return false;
            }
            if (!CmdMain.checkValid(tftpPort)) {
                return false;
            }
            cmdLineParam.setServerIp(serverIp);
            cmdLineParam.setBoardIp(boardIp);
            cmdLineParam.setNetMask(netMask);
            cmdLineParam.setGatewayIp(gatewayIp);
            cmdLineParam.setTftpPort(tftpPort);
        }
        return true;
    }

    private static boolean checkValid(String argsValue) {
        if (argsValue == null || argsValue.isEmpty()) {
            Log.errorln(NLS.bind((String)Messages.ERROR_COMMAND_PARAMETER, (Object)argsValue));
            return false;
        }
        return true;
    }

    private static int parseFirstParam(String[] args, CmdLineParam cmdLineParam, CmdMain cmdMain) {
        String cmdType = args[0];
        if (cmdType == null) {
            return BurnStatus.PARAM_ERROR.getErrorCode();
        }
        if (cmdMain.checkCmdType(cmdType, "--help", "-h")) {
            CmdMain.setCurCmdType(CmdType.help);
            CmdMain.help();
        } else if (cmdMain.checkCmdType(cmdType, "--version", "-v")) {
            CmdMain.setCurCmdType(CmdType.version);
            CmdMain.printVersion();
        } else {
            if (cmdMain.checkCmdType(cmdType, "--burn", "-b")) {
                return CmdMain.burn(cmdLineParam, cmdMain);
            }
            if (cmdMain.checkCmdType(cmdType, "--burnboot", "-bb")) {
                return CmdMain.burnBoot(args, cmdMain, cmdLineParam);
            }
            if (cmdMain.checkCmdType(cmdType, "--erase", "-er")) {
                return CmdMain.erase(args, cmdMain, cmdLineParam);
            }
            if (cmdMain.checkCmdType(cmdType, "--nandimg", "-n")) {
                return CmdMain.makeNandImage(args, cmdMain, cmdLineParam);
            }
            if (cmdMain.checkCmdType(cmdType, "--emmcimg", "-e")) {
                return CmdMain.makeEmmcImage(args, cmdMain, cmdLineParam);
            }
            return BurnStatus.PARAM_ERROR.getErrorCode();
        }
        return BurnStatus.SUCCESS.getErrorCode();
    }

    private boolean checkCmdType(String cmdType, String fullCmdName, String shortCmdName) {
        return cmdType.equalsIgnoreCase(fullCmdName) || cmdType.equalsIgnoreCase(shortCmdName);
    }

    private static int makeNandImage(String[] args, CmdMain cmdMain, CmdLineParam cmdLineParam) {
        CmdMain.setCurCmdType(CmdType.nandimg);
        NandImg nandImg = new NandImg(args);
        boolean parseResult = nandImg.parseAllParameter();
        if (!parseResult) {
            return BurnStatus.PARAM_ERROR.getErrorCode();
        }
        CmdMain.setChipName(nandImg.getChipName());
        NandIPCommon nandIp = nandImg.getNandIp();
        String inputFile = nandImg.getInputFile();
        boolean isFastboot = nandImg.isFastboot();
        FlashOption flashOption = nandImg.getFlashOption();
        FileSystem fileSystem = nandImg.getFileSystem();
        boolean isSelectRandom = nandImg.isRandomizer();
        int blockSize = nandImg.getBlock();
        PartitionItem item = new PartitionItem();
        item.setChecked(true);
        item.setFlashType(FlashType.nand);
        item.setFileSystem(fileSystem);
        item.setFile(new File(inputFile));
        if (isFastboot) {
            item.setStart(0L);
        } else {
            item.setStart(1L);
        }
        PreferenceConfig preferenceConfig = new PreferenceConfig(cmdLineParam);
        if (!preferenceConfig.isLoadResult()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_FAILED_To_LOAD_FILE, (Object)"preference.config"));
            return BurnStatus.LOAD_FILE_FAILED.getErrorCode();
        }
        ArrayList<PartitionItem> partitions = new ArrayList<PartitionItem>();
        partitions.add(item);
        CmdMonitor cmdMonitor = new CmdMonitor();
        IFastbootProgressMonitor monitor = cmdMain.getProgressMonitor();
        String outputDir = new File(inputFile).getParent();
        try {
            nandIp.make(outputDir, flashOption, partitions, blockSize, isSelectRandom, monitor, cmdMonitor);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Log.errorln("Throws ArrayIndexOutOfBoundsException exception.");
            return BurnStatus.MAKE_NAND_IMAGE_FAILED.getErrorCode();
        }
        return 0;
    }

    private static int burn(CmdLineParam cmdLineParam, CmdMain cmdMain) {
        CmdMain.setCurCmdType(CmdType.burn);
        BurnContext burnContext = CmdMain.loadBurnConfig(cmdLineParam, null);
        if (burnContext == null) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_FAILED_To_LOAD_FILE, (Object)"burn.config"));
            return BurnStatus.LOAD_FILE_FAILED.getErrorCode();
        }
        PreferenceConfig preferenceConfig = new PreferenceConfig(cmdLineParam);
        if (!preferenceConfig.isLoadResult()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_FAILED_To_LOAD_FILE, (Object)"preference.config"));
            return BurnStatus.LOAD_FILE_FAILED.getErrorCode();
        }
        CmdMain.setChipName(BurnConfig.getChipName());
        List<PartitionItem> partitionList = CmdMain.getPartitionList(cmdLineParam);
        if (partitionList == null) {
            return BurnStatus.LOAD_FILE_FAILED.getErrorCode();
        }
        String programmerPath = cmdLineParam.getProgrammerPath();
        File programmerFile = null;
        if (programmerPath != null) {
            programmerFile = new File(programmerPath);
        }
        return cmdMain.burnByXML(partitionList, burnContext, programmerFile);
    }

    private static List<PartitionItem> getPartitionList(CmdLineParam cmdLineParam) {
        List<PartitionItem> partitionList = null;
        String xmlPath = cmdLineParam.getXmlPath();
        if (xmlPath != null) {
            BurnConfig.setXmlPath(cmdLineParam.getXmlPath());
            partitionList = cmdLineParam.getPartitionList();
            if (partitionList == null) {
                Log.errorln(NLS.bind((String)Messages.MESSAGE_FAILED_To_LOAD_FILE, (Object)xmlPath));
                return null;
            }
        } else {
            String loadXmlPath = BurnConfig.getXmlPath();
            partitionList = CmdMain.loadPartitionList(cmdLineParam, loadXmlPath);
            if (partitionList == null) {
                return null;
            }
        }
        return partitionList;
    }

    private static int burnBoot(String[] args, CmdMain cmdMain, CmdLineParam cmdLineParam) {
        CmdMain.setCurCmdType(CmdType.burnboot);
        int paramSize = args.length - 1;
        BootBurn bootBurn = new BootBurn();
        List<String> listSerialPorts = SerialHelper.getSerialPorts();
        bootBurn.setSerialPorts(listSerialPorts);
        boolean parseResult = bootBurn.parseAllParameter(args, paramSize);
        if (!parseResult) {
            return BurnStatus.PARAM_ERROR.getErrorCode();
        }
        CmdMain.setChipName(bootBurn.getChipName());
        BurnContext burnContext = CmdMain.loadAndCheckBurnConfig(bootBurn, cmdLineParam);
        PreferenceConfig preferenceConfig = new PreferenceConfig(cmdLineParam);
        if (!preferenceConfig.isLoadResult()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_FAILED_To_LOAD_FILE, (Object)"preference.config"));
            return BurnStatus.LOAD_FILE_FAILED.getErrorCode();
        }
        FlashType flashType = bootBurn.getFlashType();
        File bootFile = bootBurn.getBootFile();
        File programmer = bootBurn.getProgrammer();
        FastbootBurner fastbootBurner = new FastbootBurner(burnContext);
        if (programmer != null) {
            fastbootBurner.setProgrammerFile(programmer.getAbsolutePath());
        }
        if (bootFile != null) {
            fastbootBurner.setFile(bootFile.getAbsolutePath());
        }
        if (flashType != null) {
            fastbootBurner.setFlashType(flashType);
        }
        if (CmdMain.checkStatus(fastbootBurner.checkBeforeBurn())) {
            IFastbootProgressMonitor monitor = cmdMain.getProgressMonitor();
            monitor.getEvent().setBurner(fastbootBurner);
            return fastbootBurner.burnCmdLine(monitor);
        }
        return BurnStatus.PARAM_ERROR.getErrorCode();
    }

    private static int erase(String[] args, CmdMain cmdMain, CmdLineParam cmdLineParam) {
        CmdMain.setCurCmdType(CmdType.erase);
        int paramSize = args.length - 1;
        Erase earse = new Erase();
        List<String> listSerialPorts = SerialHelper.getSerialPorts();
        earse.setSerialPorts(listSerialPorts);
        boolean parseResult = earse.parseAllEarseParameter(args, paramSize, cmdLineParam);
        if (!parseResult) {
            return BurnStatus.PARAM_ERROR.getErrorCode();
        }
        CmdMain.setChipName(earse.getChipName());
        BurnContext burnContext = CmdMain.loadAndCheckEarseConfig(earse, cmdLineParam);
        PreferenceConfig preferenceConfig = new PreferenceConfig(cmdLineParam);
        if (!preferenceConfig.isLoadResult()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_FAILED_To_LOAD_FILE, (Object)"preference.config"));
            return BurnStatus.LOAD_FILE_FAILED.getErrorCode();
        }
        List<PartitionItem> partitionList = earse.getPartitionList();
        if (partitionList == null && (partitionList = CmdMain.getPartitionList(cmdLineParam)) == null) {
            return BurnStatus.LOAD_FILE_FAILED.getErrorCode();
        }
        File programmerFile = earse.getProgrammer();
        return cmdMain.earseByXML(partitionList, burnContext, programmerFile);
    }

    private static BurnContext loadAndCheckBurnConfig(BootBurn bootBurn, CmdLineParam cmdLineParam) {
        BurnContext burnContext = CmdMain.loadBurnConfig(cmdLineParam, bootBurn.getChipName());
        if (burnContext == null) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_FAILED_To_LOAD_FILE, (Object)"burn.config"));
            System.exit(-1);
        }
        LocalConfig localConfig = burnContext.getLocalConfig();
        String comPort = bootBurn.getPort();
        TransferWay mode = bootBurn.getMode();
        if (localConfig != null) {
            localConfig.setComPort(comPort);
        }
        burnContext.setTransferWay(mode);
        burnContext.setJtagFrequency(BurnConfig.getBoardConfig().getFrequency());
        return burnContext;
    }

    private static BurnContext loadAndCheckEarseConfig(Erase earse, CmdLineParam cmdLineParam) {
        BurnContext burnContext = CmdMain.loadBurnConfig(cmdLineParam, earse.getChipName());
        if (burnContext == null) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_FAILED_To_LOAD_FILE, (Object)"burn.config"));
            System.exit(-1);
        }
        LocalConfig localConfig = burnContext.getLocalConfig();
        String comPort = earse.getPort();
        TransferWay mode = earse.getMode();
        if (localConfig != null && comPort != null) {
            localConfig.setComPort(comPort);
        }
        if (mode != null) {
            burnContext.setTransferWay(mode);
        }
        if (CmdMain.getChipName() == null) {
            CmdMain.setChipName(BurnConfig.getChipName());
        }
        return burnContext;
    }

    private static int makeEmmcImage(String[] args, CmdMain cmdMain, CmdLineParam cmdLineParam) {
        CmdMain.setCurCmdType(CmdType.emmcimg);
        int paramSize = args.length - 1;
        EmmcImg emmcImg = new EmmcImg();
        boolean parseResult = emmcImg.parseAllParameter(args, paramSize);
        if (!parseResult) {
            return BurnStatus.PARAM_ERROR.getErrorCode();
        }
        CmdMain.setChipName(CmdMain.getChipName());
        PreferenceConfig preferenceConfig = new PreferenceConfig(cmdLineParam);
        if (!preferenceConfig.isLoadResult()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_FAILED_To_LOAD_FILE, (Object)"preference.config"));
            System.exit(-1);
        }
        List<PartitionItem> partitionList = emmcImg.getPartitionList();
        UnknownDevice device = emmcImg.getDevice();
        String outputPath = emmcImg.getOutputPath();
        if (device != null) {
            BurnContext burnContext = device.getBurnContext();
            EmmcBurner emmcBurner = new EmmcBurner(burnContext);
            emmcBurner.setChildren(partitionList);
            if (emmcBurner.checkCreateImage() == null) {
                IFastbootProgressMonitor monitor = cmdMain.getProgressMonitor();
                monitor.getEvent().setBurner(emmcBurner);
                emmcBurner.setEmmcImgOutPath(outputPath);
                return emmcBurner.createImageCmdLine(monitor);
            }
            return BurnStatus.NULL_POINTER_ERROR.getErrorCode();
        }
        return 0;
    }

    private static List<PartitionItem> loadPartitionList(CmdLineParam cmdLineParam, String xmlPath) {
        List<PartitionItem> partitionLists;
        block11: {
            File file;
            block10: {
                block9: {
                    partitionLists = null;
                    try {
                        file = new File(xmlPath);
                        if (file.exists() && file.isFile()) break block9;
                        Log.errorln(NLS.bind((String)Messages.ERROR_CURRENT_XML_PATH_NOT_FOUND, (Object)xmlPath));
                        return null;
                    }
                    catch (DocumentException documentException) {
                        Log.errorln(Messages.UanbleParseXml);
                        return null;
                    }
                }
                String xmlPathDefault = PropertiesUtility.queryForString("xmlPathDefault");
                if (xmlPathDefault != null && !xmlPathDefault.isEmpty()) {
                    PartitionInfo PartitionInfo2 = PartitionItem.load(file, Boolean.valueOf(xmlPathDefault.trim()));
                    partitionLists = PartitionInfo2.getChildren();
                    File programmerFile = PartitionInfo2.getProgrammerFile();
                    if (programmerFile != null) {
                        try {
                            cmdLineParam.setProgrammerPath(PartitionInfo2.getProgrammerFile().getCanonicalPath());
                        }
                        catch (IOException iOException) {
                            Log.errorln(Messages.UanbleParseXml);
                        }
                    }
                    break block10;
                }
                Log.errorln(NLS.bind((String)Messages.MESSAGE_FAILED_To_READ_KEY, (Object)"xmlPathDefault"));
                return null;
            }
            if (partitionLists != null && partitionLists.size() > 0) {
                cmdLineParam.setPartitionList(partitionLists);
                break block11;
            }
            Log.errorln(NLS.bind((String)Messages.MESSAGE_FAILED_To_LOAD_FILE, (Object)file.getName()));
            return null;
        }
        return partitionLists;
    }

    private int burnByXML(List<PartitionItem> partitionList, BurnContext burnContext, File programmerFile) {
        if (partitionList.size() > 0) {
            CommonBurner commonBurner = new CommonBurner(burnContext);
            commonBurner.setChildren(partitionList);
            if (programmerFile != null) {
                commonBurner.setProgrammerFile(programmerFile.getAbsolutePath());
            }
            if (CmdMain.checkStatus(commonBurner.checkBeforeBurn())) {
                IFastbootProgressMonitor monitor = this.getProgressMonitor();
                monitor.getEvent().setBurner(commonBurner);
                return commonBurner.commonBurn(monitor, commonBurner.getBurnerWorker());
            }
        } else {
            Log.errorln(Messages.UanbleParseXml);
        }
        return BurnStatus.LOAD_FILE_FAILED.getErrorCode();
    }

    private int earseByXML(List<PartitionItem> partitionList, BurnContext burnContext, File programmerFile) {
        if (partitionList.size() > 0) {
            CommonBurner commonBurner = new CommonBurner(burnContext);
            commonBurner.setChildren(partitionList);
            if (programmerFile != null) {
                commonBurner.setProgrammerFile(programmerFile.getAbsolutePath());
            }
            if (CmdMain.checkStatus(commonBurner.checkBeforeBurn())) {
                IFastbootProgressMonitor monitor = this.getProgressMonitor();
                monitor.getEvent().setBurner(commonBurner);
                return commonBurner.erase(monitor, commonBurner.getBurnerWorker());
            }
        } else {
            Log.errorln(Messages.UanbleParseXml);
        }
        return BurnStatus.LOAD_FILE_FAILED.getErrorCode();
    }

    protected static boolean checkStatus(IStatus status) {
        boolean valid;
        if (status == Status.CANCEL_STATUS) {
            return false;
        }
        boolean bl = valid = status == null || status.isOK();
        if (!valid) {
            Log.errorln(status.getMessage());
        }
        return valid;
    }

    private static BurnContext loadBurnConfig(CmdLineParam cmdLineParam, String chipName) {
        BurnConfig burnConfig = new BurnConfig(cmdLineParam);
        if (!burnConfig.isLoadResult()) {
            return null;
        }
        String deviceName = BurnConfig.getChipName();
        if (chipName != null) {
            deviceName = chipName;
        }
        Log.println("The current select chip: " + deviceName);
        UnknownDevice ud = new UnknownDevice(deviceName);
        if (!ud.isValid()) {
            Log.errorln(Messages.FastbootView_Unsupported_Device);
            return null;
        }
        LocalConfig localConfig = ud.getBurnContext().getLocalConfig();
        BoardConfig boardConfig = ud.getBurnContext().getBoardConfig();
        localConfig.setComPort(BurnConfig.getLocalConfig().getComPort());
        localConfig.setServerIp(BurnConfig.getLocalConfig().getServerIp());
        boardConfig.setSocket(BurnConfig.getBoardConfig().isSocket());
        boardConfig.setSerialServerIp(BurnConfig.getBoardConfig().getSerialServerIp());
        boardConfig.setSerialServerPort(BurnConfig.getBoardConfig().getSerialServerPort());
        boardConfig.setIp(BurnConfig.getBoardConfig().getIp());
        boardConfig.setGateway(BurnConfig.getBoardConfig().getGateway());
        boardConfig.setSubnetMask(BurnConfig.getBoardConfig().getSubnetMask());
        boardConfig.setMac(BurnConfig.getBoardConfig().getMac());
        boardConfig.setGeneratorMAC(BurnConfig.getBoardConfig().isGeneratorMAC());
        boardConfig.setUdpPort(BurnConfig.getBoardConfig().getUdpPort());
        ud.getBurnContext().setTransferWay(BurnConfig.getTransferway());
        ud.getBurnContext().setDwTimeout(BurnConfig.getDwTimeout());
        ud.getBurnContext().setJtagFrequency(BurnConfig.getBoardConfig().getFrequency());
        ud.getBurnContext().setUsbToEthernet(BurnConfig.isUSBToEthernet());
        TFTPService.setUsb2EtherNet((BurnConfig.getTransferway() == TransferWay.UsbTransNet || BurnConfig.isUSBToEthernet() ? 1 : 0) != 0);
        return ud.getBurnContext();
    }

    private static void help() {
        CmdMain.printBurnByXml();
        Log.println("");
        BootBurn.printBurnBootEg();
        Log.println("");
        Erase.printEarseBootEg();
        Log.println("");
        NandImg.printNandImgEg();
        Log.println(Messages.NAND_IMG_GET_PAGESIZE_AND_BLOCK);
        EmmcImg.printEmmcImgEg();
        Log.println("");
        Log.println("");
        Log.println("general options:");
        Log.println("--help    | -h    usage message");
        Log.println("--version | -v    version number and copyright");
        Log.println("--burn    | -b    this command will burn image to the flash according to the partition table xmlPath.");
        Log.println("                  first of all, you need to configure the burn.config file.");
        Log.println("--burnboot| -bb   This command is used to burn fastboot.");
        Log.println("--nandimg | -n    the commands is used to create nand image.");
        Log.println("--emmcimg | -e    the commands is used to create emmc image.");
    }

    private static void printVersion() {
        Log.println(String.valueOf(Messages.MESSAGE_BURN_VERSION_NAME) + VERSION);
        Log.println(Messages.MESSAGE_BURN_RESERVED);
    }

    private static void printBurnByXml() {
        Log.println("burntool.jar --burn [-x xmlPath] [-p programmerPath]");
        Log.println(Messages.MESSAGE_BURN_BURN_BY_XML);
        Log.println(Messages.MESSAGE_BURN_BURN_NOTICE);
    }

    private IFastbootProgressMonitor getProgressMonitor() {
        if (this.progressMonitor == null) {
            this.progressMonitor = IFastbootProgressMonitor.PROGRESSMONITORCMDLINE;
        }
        return this.progressMonitor;
    }
}

