/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.views;

import com.vendor.burn.Activator;
import com.vendor.burn.Messages;
import com.vendor.burn.utilitily.FileUtils;
import com.vendor.burn.utilitily.ToolUtils;
import java.util.Locale;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.part.ViewPart;

public class LightView
extends ViewPart {
    public static final String ID = LightView.class.getName();
    static final String LIGHT_DEBUG_FILE = "Resources/Common/LightDebugInfo/CJ3X0VXX9.txt";
    static final String LIGHT_DEBUG_FILE_EN = "Resources/Common/LightDebugInfo/CJ3X0VXX9_EN.txt";
    private ImageHyperlink cpuLbl;
    private ImageHyperlink bootromLbl;
    private ImageHyperlink serialLbl;
    private Label bootFromLbl;
    private Label caTypeLbl;
    private ImageHyperlink readEmmcLbl;
    private ImageHyperlink readSDLbl;
    private ImageHyperlink ddrInitLbl;
    private ImageHyperlink ddrTrainingLbl;
    private ImageHyperlink fastbootStartLbl;
    private ImageHyperlink flashTypeMatchLbl;
    private ImageHyperlink emmcFlash;
    private ImageHyperlink nandFlash;
    private ImageHyperlink tftplbl;
    private String cpuInfo;
    private String bootromInfo;
    private String serialInfo;
    private String readEmmcSDInfo;
    private String ddrInitInfo;
    private String ddrTrainingInfo;
    private String fastbootStartInfo;
    private String flashTypeMatchInfo;
    private String emmcFlashInfo;
    private String nandFlashInfo;
    private String tftpInfo;
    private Composite composite;

    public void createPartControl(Composite parent) {
        Image whiteLigth = Activator.getImage("icons/white_light.png");
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 2816);
        GridData scrollableLayoutData = new GridData(1808);
        scrolledComposite.setLayoutData((Object)scrollableLayoutData);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinWidth(175);
        scrolledComposite.setMinHeight(550);
        scrolledComposite.setAlwaysShowScrollBars(true);
        this.composite = new Composite((Composite)scrolledComposite, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        this.composite.setLayoutData((Object)gd);
        scrolledComposite.setContent((Control)this.composite);
        this.bootFromLbl = new Label(this.composite, 0);
        this.bootFromLbl.setText(Messages.LightView_BootFrom);
        this.caTypeLbl = new Label(this.composite, 0);
        this.caTypeLbl.setText(Messages.LightView_CAType);
        this.serialLbl = new ImageHyperlink(this.composite, 0);
        this.serialLbl.setUnderlined(true);
        this.serialLbl.setText(Messages.LightView_Serial);
        this.serialLbl.setImage(whiteLigth);
        this.cpuLbl = new ImageHyperlink(this.composite, 0);
        this.cpuLbl.setUnderlined(true);
        this.cpuLbl.setImage(whiteLigth);
        this.cpuLbl.setText(Messages.LightView_Cpu);
        this.readEmmcLbl = new ImageHyperlink(this.composite, 0);
        this.readEmmcLbl.setUnderlined(true);
        this.readEmmcLbl.setText(Messages.LightView_ReadEmmc);
        this.readEmmcLbl.setImage(whiteLigth);
        this.readSDLbl = new ImageHyperlink(this.composite, 0);
        this.readSDLbl.setUnderlined(true);
        this.readSDLbl.setText(Messages.LightView_ReadSD);
        this.readSDLbl.setImage(whiteLigth);
        this.bootromLbl = new ImageHyperlink(this.composite, 0);
        this.bootromLbl.setUnderlined(true);
        this.bootromLbl.setText(Messages.LightView_Bootrom);
        this.bootromLbl.setImage(whiteLigth);
        this.ddrInitLbl = new ImageHyperlink(this.composite, 0);
        this.ddrInitLbl.setUnderlined(true);
        this.ddrInitLbl.setText(Messages.LightView_DDRInit);
        this.ddrInitLbl.setImage(whiteLigth);
        this.ddrTrainingLbl = new ImageHyperlink(this.composite, 0);
        this.ddrTrainingLbl.setUnderlined(true);
        this.ddrTrainingLbl.setText(Messages.LightView_DDRTraining);
        this.ddrTrainingLbl.setImage(whiteLigth);
        this.fastbootStartLbl = new ImageHyperlink(this.composite, 0);
        this.fastbootStartLbl.setUnderlined(true);
        this.fastbootStartLbl.setText(Messages.LightView_FastbootStart);
        this.fastbootStartLbl.setImage(whiteLigth);
        this.flashTypeMatchLbl = new ImageHyperlink(this.composite, 0);
        this.flashTypeMatchLbl.setUnderlined(true);
        this.flashTypeMatchLbl.setText(Messages.LightView_FlashTypeMatch);
        this.flashTypeMatchLbl.setImage(whiteLigth);
        this.emmcFlash = new ImageHyperlink(this.composite, 0);
        this.emmcFlash.setUnderlined(true);
        this.emmcFlash.setText(Messages.LightView_EmmcFlash);
        this.emmcFlash.setImage(whiteLigth);
        this.nandFlash = new ImageHyperlink(this.composite, 0);
        this.nandFlash.setUnderlined(true);
        this.nandFlash.setText(Messages.LightView_NandFlash);
        this.nandFlash.setImage(whiteLigth);
        this.tftplbl = new ImageHyperlink(this.composite, 0);
        this.tftplbl.setUnderlined(true);
        this.tftplbl.setText(Messages.LightView_Tftp);
        this.tftplbl.setImage(whiteLigth);
        this.readInformationFromFile();
        this.addHyperlinkListenerToView(this.serialLbl, this.serialInfo);
        this.addHyperlinkListenerToView(this.cpuLbl, this.cpuInfo);
        this.addHyperlinkListenerToView(this.readEmmcLbl, this.readEmmcSDInfo);
        this.addHyperlinkListenerToView(this.readSDLbl, this.readEmmcSDInfo);
        this.addHyperlinkListenerToView(this.bootromLbl, this.bootromInfo);
        this.addHyperlinkListenerToView(this.ddrInitLbl, this.ddrInitInfo);
        this.addHyperlinkListenerToView(this.ddrTrainingLbl, this.ddrTrainingInfo);
        this.addHyperlinkListenerToView(this.fastbootStartLbl, this.fastbootStartInfo);
        this.addHyperlinkListenerToView(this.flashTypeMatchLbl, this.flashTypeMatchInfo);
        this.addHyperlinkListenerToView(this.emmcFlash, this.emmcFlashInfo);
        this.addHyperlinkListenerToView(this.nandFlash, this.nandFlashInfo);
        this.addHyperlinkListenerToView(this.tftplbl, this.tftpInfo);
    }

    private void addHyperlinkListenerToView(final ImageHyperlink imageHyperlink, final String info) {
        imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                if (info == null) {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.FASTBOOT_WARNING_Title, (String)Messages.LightView_Read_File_ERROR);
                    return;
                }
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)imageHyperlink.getText(), (String)info);
            }
        });
    }

    private void readInformationFromFile() {
        Locale currentLocale = ToolUtils.getCurrentLocale();
        StringBuilder strBuilder = null;
        strBuilder = currentLocale == Locale.SIMPLIFIED_CHINESE ? FileUtils.readFromFile(LIGHT_DEBUG_FILE) : FileUtils.readFromFile(LIGHT_DEBUG_FILE_EN);
        if (strBuilder == null) {
            return;
        }
        String[] split = strBuilder.toString().split("\\[");
        int i = 0;
        while (i < split.length) {
            if (split[i].length() > 0) {
                if (split[i].contains(this.serialLbl.getText())) {
                    this.serialInfo = "[" + split[i];
                } else if (split[i].contains(this.cpuLbl.getText())) {
                    this.cpuInfo = "[" + split[i];
                } else if (split[i].contains(this.bootromLbl.getText())) {
                    this.bootromInfo = "[" + split[i];
                } else if (split[i].contains("Read eMMC/SD")) {
                    this.readEmmcSDInfo = "[" + split[i];
                } else if (split[i].contains(this.ddrInitLbl.getText())) {
                    this.ddrInitInfo = "[" + split[i];
                } else if (split[i].contains(this.ddrTrainingLbl.getText())) {
                    this.ddrTrainingInfo = "[" + split[i];
                } else if (split[i].contains(this.fastbootStartLbl.getText())) {
                    this.fastbootStartInfo = "[" + split[i];
                } else if (split[i].contains(this.flashTypeMatchLbl.getText())) {
                    this.flashTypeMatchInfo = "[" + split[i];
                } else if (split[i].contains(this.emmcFlash.getText())) {
                    this.emmcFlashInfo = "[" + split[i];
                } else if (split[i].contains(this.nandFlash.getText())) {
                    this.nandFlashInfo = "[" + split[i];
                } else if (split[i].contains(this.tftplbl.getText())) {
                    this.tftpInfo = "[" + split[i];
                }
            }
            ++i;
        }
    }

    public ImageHyperlink getCpuLbl() {
        return this.cpuLbl;
    }

    public ImageHyperlink getBootromLbl() {
        return this.bootromLbl;
    }

    public ImageHyperlink getSerialLbl() {
        return this.serialLbl;
    }

    public Label getBootFromLbl() {
        return this.bootFromLbl;
    }

    public Label getCaTypeLbl() {
        return this.caTypeLbl;
    }

    public ImageHyperlink getReadEmmcLbl() {
        return this.readEmmcLbl;
    }

    public ImageHyperlink getReadSDLbl() {
        return this.readSDLbl;
    }

    public ImageHyperlink getDdrInitLbl() {
        return this.ddrInitLbl;
    }

    public ImageHyperlink getDdrTrainingLbl() {
        return this.ddrTrainingLbl;
    }

    public ImageHyperlink getFastbootStartLbl() {
        return this.fastbootStartLbl;
    }

    public ImageHyperlink getFlashTypeMatchLbl() {
        return this.flashTypeMatchLbl;
    }

    public ImageHyperlink getEmmcFlash() {
        return this.emmcFlash;
    }

    public ImageHyperlink getNandFlash() {
        return this.nandFlash;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public ImageHyperlink getTftplbl() {
        return this.tftplbl;
    }

    public void setFocus() {
    }
}

