/*
 * Decompiled with CFR 0.152.
 */
package org.vendor.console;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.internal.console.ConsoleManager;
import org.eclipse.ui.internal.console.ConsoleView;

public class ConsoleHelper {
    public static List<ConsoleView> getConsoleViews() {
        ArrayList<ConsoleView> consoleViews = new ArrayList<ConsoleView>();
        try {
            IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
            Class<ConsoleManager> clazz = ConsoleManager.class;
            Field declaredField = clazz.getDeclaredField("fConsoleViews");
            declaredField.setAccessible(true);
            List consoleViewsObj = (List)declaredField.get(consoleManager);
            for (Object object : consoleViewsObj) {
                if (!(object instanceof ConsoleView)) continue;
                consoleViews.add((ConsoleView)object);
            }
        }
        catch (Throwable throwable) {}
        return consoleViews;
    }

    public static boolean removeConsoles(List<IConsole> toRemove) {
        ConsolePlugin consolePlugin = ConsolePlugin.getDefault();
        if (consolePlugin == null) {
            return false;
        }
        IConsoleManager consoleManager = consolePlugin.getConsoleManager();
        if (consoleManager == null) {
            return false;
        }
        IConsole[] current = consoleManager.getConsoles();
        ArrayList<IConsole> toremovelist = new ArrayList<IConsole>();
        if (current != null) {
            IConsole[] iConsoleArray = current;
            int n = current.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if (toRemove.contains(console)) {
                    toremovelist.add(console);
                }
                ++n2;
            }
            consoleManager.removeConsoles(toremovelist.toArray(new IConsole[toremovelist.size()]));
        }
        return true;
    }

    public static void display(IConsole console) {
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        try {
            consoleManager.showConsoleView(console);
        }
        catch (Exception exception) {
            try {
                consoleManager.showConsoleView(console);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public static void display2(final IConsole console) {
        try {
            IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
            Class<ConsoleManager> clazz = ConsoleManager.class;
            Field declaredField = clazz.getDeclaredField("fConsoleViews");
            declaredField.setAccessible(true);
            List consoleViews = (List)declaredField.get(consoleManager);
            int i = 0;
            while (i < consoleViews.size()) {
                final Object object = consoleViews.get(i);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (object instanceof ConsoleView) {
                            ConsoleView consoleView = (ConsoleView)object;
                            consoleView.display(console);
                        }
                    }
                });
                ++i;
            }
        }
        catch (Throwable throwable) {}
    }

    public static void addConsole(IConsole console) {
        List<ConsoleView> consoleViews = ConsoleHelper.getConsoleViews();
        boolean[] caches = new boolean[consoleViews.size()];
        int i = 0;
        while (i < caches.length) {
            ConsoleView consoleView = consoleViews.get(i);
            caches[i] = consoleView.isPinned();
            if (!caches[i]) {
                consoleView.setPinned(true);
            }
            ++i;
        }
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        consoleManager.addConsoles(new IConsole[]{console});
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        int i2 = 0;
        while (i2 < caches.length) {
            ConsoleView consoleView = consoleViews.get(i2);
            consoleView.setPinned(caches[i2]);
            ++i2;
        }
    }

    public static IConsole addAndShowConsole(IConsole console) {
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        consoleManager.addConsoles(new IConsole[]{console});
        return console;
    }
}

