/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.platform.rcp.internal;

import com.vendor.platform.rcp.Activator;
import com.vendor.platform.rcp.internal.Messages;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.osgi.framework.Version;

public class ToolPlatformAboutAction
extends Action {
    private static final String ID = "com.vendor.platform.rcp.internal.ToolPlatformAboutAction";
    private Version version;
    private Shell shell;
    private String productName;

    public ToolPlatformAboutAction(Shell shell) {
        this.shell = shell;
        this.setId(ID);
        IProduct product = Platform.getProduct();
        this.productName = null;
        if (product != null) {
            this.productName = product.getName();
            this.version = product.getDefiningBundle().getVersion();
        }
        if (this.productName == null) {
            this.productName = "";
        }
        this.setText(NLS.bind((String)WorkbenchMessages.AboutAction_text, (Object)this.productName));
        this.setToolTipText(NLS.bind((String)WorkbenchMessages.AboutAction_toolTip, (Object)this.productName));
    }

    public void run() {
        ToolPlatformAboutDialog dialog = new ToolPlatformAboutDialog(this.shell);
        dialog.open();
    }

    public class ToolPlatformAboutDialog
    extends Dialog {
        private final String copyrightinfo;
        private final String versioninfo;

        protected ToolPlatformAboutDialog(Shell parentShell) {
            super(parentShell);
            this.copyrightinfo = Messages.ActionBarAdvisorHack_16;
            this.versioninfo = Messages.ActionBarAdvisorHack_17;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(NLS.bind((String)WorkbenchMessages.AboutDialog_shellTitle, (Object)ToolPlatformAboutAction.this.productName));
        }

        protected void setShellStyle(int newShellStyle) {
            super.setShellStyle(newShellStyle);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            GridLayout layout = (GridLayout)container.getLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            Composite panel = new Composite(container, 2048);
            layout = new GridLayout(3, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            panel.setBackground(Display.getDefault().getSystemColor(1));
            panel.setLayoutData((Object)new GridData(1808));
            panel.setLayout((Layout)layout);
            Composite left = new Composite(panel, 0);
            left.setBackground(Display.getDefault().getSystemColor(1));
            left.setLayoutData((Object)new GridData(1040));
            left.setLayout((Layout)new FillLayout());
            Label imageLable = new Label(left, 0);
            imageLable.setBackground(Display.getDefault().getSystemColor(1));
            imageLable.setImage(Activator.getImageDescriptor("icons/vendor_logo.png").createImage());
            new Label(panel, 2048).setLayoutData((Object)new GridData(1040));
            Composite right = new Composite(panel, 0);
            right.setBackground(Display.getDefault().getSystemColor(1));
            right.setLayoutData((Object)new GridData(1808));
            right.setLayout((Layout)new GridLayout(1, false));
            String versionStr = "";
            if (ToolPlatformAboutAction.this.version != null) {
                versionStr = ToolPlatformAboutAction.this.version.toString();
            }
            Label versionLab = new Label(right, 0);
            versionLab.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
            versionLab.setText("ToolPlatform " + MessageFormat.format(this.versioninfo, versionStr));
            versionLab.setBackground(Display.getDefault().getSystemColor(1));
            Label copyright = new Label(right, 0);
            copyright.setLayoutData((Object)new GridData(16384, 1, true, false, 1, 1));
            copyright.setText(this.copyrightinfo);
            copyright.setBackground(Display.getDefault().getSystemColor(1));
            Label bottom = new Label(right, 0);
            bottom.setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 1, 1));
            bottom.setText(Messages.ActionBarAdvisorHack_18);
            bottom.setBackground(Display.getDefault().getSystemColor(1));
            return container;
        }

        public String toString(Version v) {
            StringBuffer result = new StringBuffer();
            result.append(v.getMajor());
            result.append(".");
            result.append(v.getMinor());
            result.append(".");
            result.append(v.getMicro());
            return result.toString();
        }
    }
}

