/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.platform.rcp.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.internal.wizards.AbstractExtensionWizardRegistry;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class UIFilter {
    public static void removeNewWizards() {
        AbstractExtensionWizardRegistry wizardRegistry = (AbstractExtensionWizardRegistry)WorkbenchPlugin.getDefault().getNewWizardRegistry();
        IWizardCategory[] categories = wizardRegistry.getRootCategory().getCategories();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.ui.newWizards");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < categories.length) {
            if (categories[i].getId().equals("org.eclipse.jdt.ui.java") || categories[i].getId().equals("org.eclipse.pde.PDE") || categories[i].getId().equals("org.eclipse.buckminster")) {
                UIFilter.removeCategory(wizardRegistry, categories[i], extensions[0]);
            }
            ++i;
        }
    }

    public static void removeCategory(AbstractExtensionWizardRegistry wizardRegistry, IWizardCategory category, IExtension extension) {
        IWizardDescriptor[] wizard = category.getWizards();
        int j = 0;
        while (j < wizard.length) {
            wizardRegistry.removeExtension(extension, new Object[]{wizard[j]});
            ++j;
        }
        IWizardCategory[] categories = category.getCategories();
        if (categories != null && categories.length > 0) {
            IWizardCategory[] iWizardCategoryArray = categories;
            int n = categories.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardCategory temp = iWizardCategoryArray[n2];
                UIFilter.removeCategory(wizardRegistry, temp, extension);
                ++n2;
            }
        }
    }

    public static void removeImportWizards() {
        AbstractExtensionWizardRegistry wizardRegistry = (AbstractExtensionWizardRegistry)WorkbenchPlugin.getDefault().getImportWizardRegistry();
        IWizardCategory[] categories = wizardRegistry.getRootCategory().getCategories();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.ui.importWizards");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < categories.length) {
            if (categories[i].getId().equals("org.eclipse.buckminster") || categories[i].getId().equals("org.eclipse.debug.ui") || categories[i].getId().equals("org.eclipse.pde.ui.PluginDevelopment") || categories[i].getId().equals("org.eclipse.equinox.p2.category")) {
                UIFilter.removeCategory(wizardRegistry, categories[i], extensions[0]);
            }
            ++i;
        }
    }

    public static void removeExportWizards() {
        AbstractExtensionWizardRegistry wizardRegistry = (AbstractExtensionWizardRegistry)WorkbenchPlugin.getDefault().getExportWizardRegistry();
        IWizardCategory[] categories = wizardRegistry.getRootCategory().getCategories();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.ui.exportWizards");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < categories.length) {
            if (categories[i].getId().equals("org.eclipse.jdt.ui.Java") || categories[i].getId().equals("org.eclipse.debug.ui") || categories[i].getId().equals("org.eclipse.pde.ui.PluginDevelopment") || categories[i].getId().equals("org.eclipse.equinox.p2.category")) {
                UIFilter.removeCategory(wizardRegistry, categories[i], extensions[0]);
            } else if (categories[i].getId().equals("org.eclipse.ui.Basic")) {
                IWizardDescriptor[] wizard = categories[i].getWizards();
                int j = 0;
                while (j < wizard.length) {
                    if (wizard[j].getId().equals("org.eclipse.ant.ui.export")) {
                        wizardRegistry.removeExtension(extensions[0], new Object[]{wizard[j]});
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public static void removeActionSet(String actionSetId) {
        ActionSetRegistry reg = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IActionSetDescriptor[] actionSets = reg.getActionSets();
        int i = 0;
        while (i < actionSets.length) {
            if (actionSets[i].getId().equals(actionSetId)) {
                IExtension ext = actionSets[i].getConfigurationElement().getDeclaringExtension();
                reg.removeExtension(ext, new Object[]{actionSets[i]});
            }
            ++i;
        }
    }

    public static void enableActivity(String id) {
        IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
        IActivityManager activityManager = workbenchActivitySupport.getActivityManager();
        HashSet<String> enabledActivities = new HashSet<String>();
        if (activityManager.getActivity(id).isDefined()) {
            enabledActivities.add(id);
        }
        workbenchActivitySupport.setEnabledActivityIds(enabledActivities);
    }

    public static void removeActionsets(String[] actionsets) {
        ActionSetRegistry reg = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IActionSetDescriptor[] actionSets = reg.getActionSets();
        List<String> list = Arrays.asList(actionsets);
        int i = 0;
        while (i < actionSets.length) {
            if (list.contains(actionSets[i].getId())) {
                UIFilter.removeAction(reg, actionSets[i]);
            }
            ++i;
        }
    }

    public static void removeAction(ActionSetRegistry reg, IActionSetDescriptor actionSet) {
        IExtension ext = actionSet.getConfigurationElement().getDeclaringExtension();
        reg.removeExtension(ext, new Object[]{actionSet});
    }

    public static void disableActivity() {
        IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
        HashSet enabledActivities = new HashSet();
        workbenchActivitySupport.setEnabledActivityIds(enabledActivities);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().resetPerspective();
    }

    public static ArrayList getRemoveActionSets(IWorkbenchWindow window, String[] actionsetIDS) {
        ArrayList<IActionSetDescriptor> toRemove = new ArrayList<IActionSetDescriptor>();
        IActionSetDescriptor[] actionSetDescriptors = ((WorkbenchPage)window.getActivePage()).getActionSets();
        List<String> list = Arrays.asList(actionsetIDS);
        IActionSetDescriptor[] iActionSetDescriptorArray = actionSetDescriptors;
        int n = actionSetDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IActionSetDescriptor a = iActionSetDescriptorArray[n2];
            if (list.contains(a.getId())) {
                toRemove.add(a);
            }
            ++n2;
        }
        return toRemove;
    }

    public static void removePreferences() {
        IPreferenceNode[] nodes;
        PreferenceManager pm = PlatformUI.getWorkbench().getPreferenceManager();
        IPreferenceNode[] iPreferenceNodeArray = nodes = pm.getRootSubNodes();
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceNode n3 = iPreferenceNodeArray[n2];
            if (n3.getId().equals("de.guhsoft.jinto.ui.mainPage") || n3.getId().equals("org.eclipse.ant.ui.AntPreferencePage") || n3.getId().equals("org.eclipse.buckminster.ui.prefs.BuckminsterPreferencePage") || n3.getId().equals("org.eclipse.debug.ui.DebugPreferencePage") || n3.getId().equals("org.eclipse.help.ui.browsersPreferencePage") || n3.getId().equals("org.eclipse.jdt.ui.preferences.JavaBasePreferencePage") || n3.getId().equals("org.eclipse.pde.ui.MainPreferencePage") || n3.getId().equals("org.eclipse.team.ui.TeamPreferences") || n3.getId().equals("org.eclipse.update.internal.ui.preferences.MainPreferencePage")) {
                pm.remove(n3);
            }
            ++n2;
        }
    }
}

